/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceUncompressHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.queryplugin.StockDetailRptQueryPlugin;

public class StockCostDetailRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(StockDetailRptQueryPlugin.class);
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private DynamicObject costAccount_startPeriod;
    private int costAccount_startPeriodNumber;
    private int filter_endPeriodNumber;
    private Date costAccount_startDate;
    private List<Integer> periodNumberList = new ArrayList<Integer>();
    private boolean onlyShowSumRow;
    private boolean topSumRow;
    private boolean showdetail;
    private long baseUnitId;
    private long currencyId;
    private DynamicObjectCollection filter_billtype;
    private String[] filter_billno;
    private String filter_ownertype;
    private DynamicObjectCollection filter_ownerFrom;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private String[] filter_lot;
    private DynamicObjectCollection filter_project;
    private DynamicObjectCollection filter_tracknumber;
    private DynamicObjectCollection filter_invType;
    private DynamicObjectCollection filter_invStatus;
    private Date filter_startDate;
    private Date filter_endDate;
    private DynamicObject currentPeriod;
    private DynamicObject currentEndPeriod;
    private long materialId;
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private LocaleString locale_baseUnit = new LocaleString(this.getLocale_baseUnit());
    private LocaleString locale_periodIn = new LocaleString(this.getLocale_periodIn());
    private LocaleString locale_periodOut = new LocaleString(this.getLocale_periodOut());
    private LocaleString locale_periodEnd = new LocaleString(this.getLocale_periodEnd());
    private LocaleString locale_qty = new LocaleString(this.getLocale_qty());
    private LocaleString locale_price = new LocaleString(this.getLocale_price());
    private LocaleString locale_amount = new LocaleString(this.getLocale_amount());
    private LocaleString locale_currency = new LocaleString(this.getLocale_currency());
    private static final LocaleString width = new LocaleString("100px");
    private static final int BATCH_SIZE = 100000;
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    private String getLocale_baseUnit() {
        return ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"StockCostDetailRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodIn() {
        return ResManager.loadKDString((String)"\u672c\u671f\u6536\u5165", (String)"StockCostDetailRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodOut() {
        return ResManager.loadKDString((String)"\u672c\u671f\u53d1\u51fa", (String)"StockCostDetailRptQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodEnd() {
        return ResManager.loadKDString((String)"\u671f\u672b\u7ed3\u5b58", (String)"StockCostDetailRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_qty() {
        return ResManager.loadKDString((String)"\u6570\u91cf", (String)"StockCostDetailRptQueryPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_price() {
        return ResManager.loadKDString((String)"\u5355\u4ef7", (String)"StockCostDetailRptQueryPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_amount() {
        return ResManager.loadKDString((String)"\u91d1\u989d", (String)"StockCostDetailRptQueryPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_currency() {
        return ResManager.loadKDString((String)"\u5e01\u79cd", (String)"StockCostDetailRptQueryPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        try {
            this.init(param);
            DataSet dataSet = this.getCostRecordDataSet();
            if (this.materialId == -1L) {
                return dataSet;
            }
            dataSet = dataSet.union(this.getCostAdjustDataSet());
            dataSet = this.filterByAllZeroCondition(dataSet);
            dataSet = this.unionPeriodBeginDataSet(dataSet);
            dataSet = this.calPeriodEndDataSet(dataSet);
            dataSet = this.filterStratPeriod(dataSet);
            dataSet = this.unionTotalDataSet(dataSet);
            dataSet = this.topSumRow(dataSet);
            dataSet = this.onlyShowSumRow(dataSet);
            dataSet = dataSet.select(this.getFinalSelects().split(",")).addField("owner", "ownernumber");
            return dataSet;
        }
        catch (Exception e) {
            StringBuilder sBuilder = new StringBuilder("stockDetailRpt=?");
            if (e instanceof KDBizException) {
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage());
                }
            } else {
                StackTraceElement[] errs;
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage()).append("\n");
                }
                for (StackTraceElement err : errs = e.getStackTrace()) {
                    sBuilder.append(err.toString()).append("\n");
                }
            }
            logger.info(sBuilder.toString());
            throw e;
        }
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        this.createDecimalColumns(cols);
        this.createHideColumns(cols);
        return cols;
    }

    private void init(ReportQueryParam param) {
        this.filterInfo = param.getFilter();
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        Long costAccountId = this.filter_costAccount.getLong("id");
        this.filter_startDate = this.filterInfo.getDate("startdate");
        this.filter_endDate = DateUtils.getDayEndTime((Date)this.filterInfo.getDate("enddate"));
        this.currentPeriod = PeriodHelper.getPeriodByDate((Date)this.filter_startDate, (Long)costAccountId);
        this.currentPeriod.getDate("begindate");
        this.currentEndPeriod = PeriodHelper.getPeriodByDate((Date)DateUtils.getDayStartTime((Date)this.filter_endDate), (Long)costAccountId);
        this.costAccount_startPeriod = PeriodHelper.getStartPeriod((Long)this.filter_costAccount.getLong("id"));
        this.costAccount_startPeriodNumber = this.costAccount_startPeriod.getInt("periodyear") * 100 + this.costAccount_startPeriod.getInt("periodnumber");
        this.costAccount_startDate = this.costAccount_startPeriod.getDate("begindate");
        this.filter_endPeriodNumber = this.currentPeriod.getInt("periodyear") * 100 + this.currentPeriod.getInt("periodnumber");
        this.onlyShowSumRow = this.filterInfo.getBoolean("onlyshowsumrow");
        this.topSumRow = this.filterInfo.getBoolean("topsumrow");
        this.showdetail = this.filterInfo.getBoolean("showdetail");
        Object calPolicyId = this.filter_costAccount.getDynamicObject("calpolicy").getPkValue();
        DynamicObject calPolicy = BusinessDataServiceHelper.loadSingleFromCache((Object)calPolicyId, (String)"cal_bd_calpolicy");
        this.showdetail = this.showdetail && calPolicy.getBoolean("calbycostelement");
        Object filterInfoValue = this.filterInfo.getFilterItem("currentMateiralId").getValue();
        this.materialId = Long.parseLong((String)filterInfoValue);
        DynamicObjectCollection materialColl = QueryServiceHelper.query((String)"bd_material", (String)"baseunit.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.materialId)});
        if (materialColl.size() > 0) {
            this.baseUnitId = ((DynamicObject)materialColl.get(0)).getLong("baseunit.id");
        }
        this.currencyId = this.filterInfo.getDynamicObject("localcurrency").getLong("id");
        this.filter_ownertype = (String)this.filterInfo.getValue("ownertypehead");
        if (StringUtils.isNotEmpty((String)this.filter_ownertype)) {
            if ("bos_org".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        if (StringUtils.isNotEmpty((String)this.filterInfo.getString("lotnumber"))) {
            this.filter_lot = this.filterInfo.getString("lotnumber").split(";");
        }
        this.filter_project = this.filterInfo.getDynamicObjectCollection("mulproject");
        this.filter_tracknumber = this.filterInfo.getDynamicObjectCollection("multracknum");
        this.filter_invType = this.filterInfo.getDynamicObjectCollection("mulinvtype");
        this.filter_invStatus = this.filterInfo.getDynamicObjectCollection("mulinvstatus");
        this.filter_billtype = this.filterInfo.getDynamicObjectCollection("mulbilltype");
        if (!"".equals(this.filterInfo.getString("billnoid").trim())) {
            this.filter_billno = this.filterInfo.getString("billnoid").split(" ");
        }
    }

    private QFilter getCostRecordFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("bookdate", ">=", (Object)this.costAccount_startDate);
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("entry.material", "=", (Object)this.materialId);
        q.and("issplitcreate", "=", (Object)false);
        q.and("isinitbill", "=", (Object)false);
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costrecord");
        if (this.filter_billtype != null) {
            set = new HashSet<Object>(this.filter_billtype.size());
            for (DynamicObject info : this.filter_billtype) {
                set.add(info.getPkValue());
            }
            q.and("billtype", "in", set);
        }
        if (this.filter_billno != null) {
            q.and("billno", "in", (Object)this.filter_billno);
        }
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entry.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entry.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entry.location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("entry.lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("entry.project", "in", set);
        }
        if (this.filter_tracknumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_tracknumber) {
                set.add(info.getPkValue());
            }
            q.and("entry.tracknumber", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("entry.invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("entry.invstatus", "in", set);
        }
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        return q;
    }

    private DataSet getCostRecordDataSet() {
        QFilter q = this.getCostRecordFilter();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getCostRecordSelects(), (QFilter[])new QFilter[]{q}, null);
        return dataSet;
    }

    private String getCostRecordSelects() {
        StringBuilder select = new StringBuilder();
        select.append("period.periodyear as year,period.periodnumber as period,bizdate,bookdate,auditdate as audittime,case when isvoucher = '1' then '1' else '0' end  as isvoucher,");
        select.append("billno as billno,calbilltype as calbilltype,billtype.name as billtype,comment as comment,");
        select.append("entry.ownertype as ownertype,entry.owner as owner,");
        select.append("storageorgunit.number as storageorgnumber,storageorgunit.name as storageorgname,");
        select.append("entry.warehouse.number as warehousenumber,entry.warehouse.name as warehousename,");
        select.append("entry.warehouse.group.number as warehsgroupnumber,entry.warehouse.group.name as warehsgroupname,entry.location.number as locationnumber,entry.location.name as locationname,entry.lot as lot,");
        select.append("entry.assist as assist,entry.project.name as projectname,entry.tracknumber.number as tracknumber,");
        select.append("case when calbilltype = 'IN' then entry.baseqty else 0 end as periodinqty,");
        select.append("case when calbilltype = 'IN' and entry.accounttype != 'D' then entry.actualcost ");
        select.append(" when calbilltype = 'IN' and entry.accounttype = 'D' then entry.standardcost  ");
        select.append(" else 0 end as periodinamount,");
        select.append("case when calbilltype = 'OUT' then entry.baseqty else 0 end as periodoutqty,");
        select.append("case when calbilltype = 'OUT' and entry.accounttype != 'D' then entry.actualcost ");
        select.append("when calbilltype = 'OUT' and entry.accounttype = 'D' then entry.standardcost ");
        select.append("else 0 end as periodoutamount, ");
        select.append("0 as periodendqty,0 as periodendamount,");
        select.append("case when entry.accounttype = 'D' then entry.unitstandardcost else entry.unitactualcost end as unitprice,");
        select.append("case when calbilltype = 'IN' then entry.baseqty else 0 end as periodinqtybak,");
        select.append("case when calbilltype = 'IN' and entry.accounttype != 'D' then entry.actualcost ");
        select.append(" when calbilltype = 'IN' and entry.accounttype = 'D' then entry.standardcost  ");
        select.append(" else 0 end as periodinamountbak,");
        select.append("id as billid,'cal_costrecord_subentity' as bizentityobject,entry.id as entryid,'costrecord' as srcobject");
        return select.toString();
    }

    private DataSet getCostAdjustDataSet() {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjustbill", (String)this.getCostAdjustSelects(), (QFilter[])new QFilter[]{this.getCostAdjustFilter(true)}, null);
        DataSet stdDiff = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)this.getStdDiffSelects(), (QFilter[])new QFilter[]{this.getCostAdjustFilter(false)}, null);
        dataSet = dataSet.union(stdDiff);
        return dataSet.filter("periodinamount != 0 or periodoutamount != 0");
    }

    private QFilter getCostAdjustFilter(boolean isAdjust) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("bookdate", ">=", (Object)this.costAccount_startDate);
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("entryentity.material", "=", (Object)this.materialId);
        q.and("billstatus", "=", (Object)"C");
        q.and("isupdatecost", "=", (Object)"1");
        if (isAdjust) {
            q.and("entryentity.accounttype", "<>", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        }
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costadjustbill");
        if (this.filter_billtype != null) {
            set = new HashSet<Object>(this.filter_billtype.size());
            for (DynamicObject info : this.filter_billtype) {
                set.add(info.getPkValue());
            }
            q.and("billtype", "in", set);
        }
        if (this.filter_billno != null) {
            q.and("billno", "in", (Object)this.filter_billno);
        }
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("entryentity.lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.project", "in", set);
        }
        if (this.filter_tracknumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_tracknumber) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.tracknumber", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invstatus", "in", set);
        }
        return q;
    }

    private String getCostAdjustSelects() {
        String s = ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"StockCostDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("period.periodyear as year,period.periodnumber as period,bizdate,bookdate,auditdate as audittime,case when isvoucher = '1' then '1' else '0' end  as isvoucher,");
        select.append("billno as billno,case when biztype = 'A' then 'IN' else 'OUT' end as calbilltype,'");
        select.append(s);
        select.append("' as billtype,remark as comment,entryentity.ownertype as ownertype,entryentity.owner,");
        select.append("entryentity.storageorgunit.number as storageorgnumber,entryentity.storageorgunit.name as storageorgname,");
        select.append("entryentity.warehouse.number as warehousenumber,entryentity.warehouse.name as warehousename,");
        select.append("entryentity.warehouse.group.number as warehsgroupnumber,entryentity.warehouse.group.name as warehsgroupname,entryentity.location.number as locationnumber,entryentity.location.name as locationname,entryentity.lot as lot,");
        select.append("entryentity.assist as assist,entryentity.project.name as projectname,entryentity.tracknumber.number as tracknumber,");
        select.append(" 0 as periodinqty,case when biztype = 'A' and entryentity.accounttype = 'D' and difftype <> 'B' and createtype <> 'C1' then entryentity.adjustamt ");
        select.append(" when biztype = 'A' and entryentity.accounttype <> 'D' and difftype = 'B' then entryentity.adjustamt else 0 end as periodinamount,");
        select.append("0 as periodoutqty,case when biztype = 'B' and entryentity.accounttype = 'D' and difftype <> 'B' and createtype <> 'C1' then entryentity.adjustamt ");
        select.append(" when biztype = 'B' and entryentity.accounttype <> 'D' and difftype = 'B' then entryentity.adjustamt  else 0 end as periodoutamount,");
        select.append("0 as periodendqty,0 as periodendamount,");
        select.append("0 as unitprice,");
        select.append("0 as periodinqtybak,case when biztype = 'A' then entryentity.adjustamt else 0 end as periodinamountbak,");
        select.append("id as billid,'cal_costadjust_subentity' as bizentityobject,entryentity.id as entryid,'costadjustbill' as srcobject");
        return select.toString();
    }

    private String getStdDiffSelects() {
        String s = ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355", (String)"StockDetailRptQueryPlugin_23", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("period.periodyear as year,period.periodnumber as period,bizdate,bookdate,auditdate as audittime,case when isvoucher = '1' then '1' else '0' end  as isvoucher,");
        select.append("billno as billno,case when biztype = 'A' then 'IN' else 'OUT' end as calbilltype,'");
        select.append(s);
        select.append("' as billtype,remark as comment,entryentity.ownertype as ownertype,entryentity.owner,");
        select.append("entryentity.storageorgunit.number as storageorgnumber,entryentity.storageorgunit.name as storageorgname,");
        select.append("entryentity.warehouse.number as warehousenumber,entryentity.warehouse.name as warehousename,");
        select.append("entryentity.warehouse.group.number as warehsgroupnumber,entryentity.warehouse.group.name as warehsgroupname,entryentity.location.number as locationnumber,entryentity.location.name as locationname,entryentity.lot as lot,");
        select.append("entryentity.assist as assist,entryentity.project.name as projectname,entryentity.tracknumber.number as tracknumber,");
        select.append(" 0 as periodinqty,case when biztype = 'A' and entryentity.accounttype = 'D' and createtype <> 'C1' then entryentity.adjustamt ");
        select.append(" when biztype = 'A' and entryentity.accounttype <> 'D' then 0 else 0 end as periodinamount,");
        select.append("0 as periodoutqty,case when biztype = 'B' and entryentity.accounttype = 'D' and createtype <> 'C1' then entryentity.adjustamt ");
        select.append(" when biztype = 'B' and entryentity.accounttype <> 'D' then 0  else 0 end as periodoutamount,");
        select.append("0 as periodendqty,0 as periodendamount,");
        select.append("0 as unitprice,");
        select.append("0 as periodinqtybak,case when biztype = 'A' then entryentity.adjustamt else 0 end as periodinamountbak,");
        select.append("id as billid,'cal_stdcostdiffbill' as bizentityobject,entryentity.id as entryid,'costadjustbill' as srcobject");
        return select.toString();
    }

    private DataSet joinOwnerDataSet(DataSet dataSet) {
        DataSet ownerSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org", (String)"id,name,number", null, null);
        return dataSet.join(ownerSet, JoinType.LEFT).on("ownerid", "id").select(this.getAliasSelects().split(","), new String[]{"name as ownername"}).finish();
    }

    private DataSet unionPeriodBeginDataSet(DataSet dataSet) {
        return dataSet.addField("1", "ordercol_second").union(this.getPeriodBeginDataSet().addField("0", "ordercol_second"));
    }

    private DataSet filterByAllZeroCondition(DataSet calDataSet) {
        StringBuilder select = new StringBuilder();
        select.append("periodinqty <> 0 or periodinamount <> 0 or ");
        select.append(" periodoutqty <> 0 or periodoutamount <> 0");
        calDataSet = calDataSet.filter(select.toString());
        return calDataSet;
    }

    private DataSet getPeriodBeginDataSet() {
        DataSet dataSet;
        QFilter q = new QFilter("periodyear*100+periodnumber", ">=", (Object)this.costAccount_startPeriodNumber);
        q.and("periodyear*100+periodnumber", "<=", (Object)this.filter_endPeriodNumber);
        DynamicObject costAccountInfo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", this.filter_costAccount.get("id"))});
        q.and("periodtype", "=", costAccountInfo.get("calpolicy.periodtype"));
        q.and("isadjustperiod", "=", (Object)false);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{q}, (String)"periodyear asc,periodnumber asc");
        for (DynamicObject info : coll) {
            if (this.periodNumberList.indexOf(info.getInt("periodyear") * 100 + info.getInt("periodnumber")) >= 0) continue;
            this.periodNumberList.add(info.getInt("periodyear") * 100 + info.getInt("periodnumber"));
        }
        DataSet zeroPeriodBeginDataSet = null;
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DateType.LongType)});
        DataSetBuilder billMatCostDataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
        billMatCostDataSetBuilder.append(new Object[]{0L});
        try (DataSet singleDataSet = billMatCostDataSetBuilder.build();){
            for (int i = 0; i < this.periodNumberList.size(); ++i) {
                int periodNumber = this.periodNumberList.get(i);
                int year = periodNumber / 100;
                int month = periodNumber % 100;
                DataSet dataSet2 = singleDataSet.copy().select(new String[]{year + " as year", month + " as month", "0 as periodbeginqty", "0 as periodbeginactualcost"});
                zeroPeriodBeginDataSet = i == 0 ? dataSet2 : (zeroPeriodBeginDataSet != null ? zeroPeriodBeginDataSet.union(dataSet2) : dataSet2);
            }
        }
        String selectfields = "year,month,periodbeginqty,periodbeginactualcost";
        if (this.isNewBalance) {
            boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
            if (!balCompress) {
                String moreFields = ",year,month,baseqty as periodbeginqty,actualcost as periodbeginactualcost";
                String select = CalBalanceModelHelper.getDimFields((boolean)true) + moreFields;
                String[] groupSelect = (CalBalanceModelHelper.getDimFields((boolean)false) + ",year,month").split(",");
                dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)select, (QFilter[])new QFilter[]{this.getPeriodBeginBalFilter()}, null);
                dataSet = dataSet.groupBy(groupSelect).max("periodbeginqty").sum("periodbeginactualcost").finish();
                dataSet = dataSet.select(selectfields);
            } else {
                String moreFields = ",year,month,baseqty as periodbeginqty,actualcost as periodbeginactualcost";
                String select = CalBalanceModelHelper.getDimFields((boolean)true) + moreFields;
                String[] groupSelect = (CalBalanceModelHelper.getDimFields((boolean)false) + ",year,month").split(",");
                HashSet<String> otherFields = new HashSet<String>();
                otherFields.add("year");
                otherFields.add("month");
                ArrayList<QFilter> ql = new ArrayList<QFilter>();
                ql.add(this.getPeriodBeginBalFilter());
                dataSet = BalanceUncompressHelper.getBalancDataSetDetail((boolean)false, (boolean)false, otherFields, ql).select(select);
                dataSet = dataSet.groupBy(groupSelect).sum("periodbeginqty").sum("periodbeginactualcost").finish();
                dataSet = dataSet.select(selectfields);
            }
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)selectfields, (QFilter[])new QFilter[]{this.getPeriodBeginBalFilter()}, null);
        }
        dataSet = dataSet.groupBy(new String[]{"year", "month"}).sum("periodbeginqty").sum("periodbeginactualcost").finish();
        if (zeroPeriodBeginDataSet != null) {
            zeroPeriodBeginDataSet = zeroPeriodBeginDataSet.join(dataSet, JoinType.LEFT).on("year", "year").on("month", "month").select(new String[]{"year", "month"}, new String[]{"periodbeginqty", "periodbeginactualcost"}).finish();
            return zeroPeriodBeginDataSet.select(this.getPeriodBeginFinalSelects().split(","));
        }
        return dataSet.select(this.getPeriodBeginFinalSelects().split(","));
    }

    private DataSet calPeriodEndDataSet(DataSet dataSet) {
        return dataSet.orderBy(new String[]{"year", "period", "ordercol_second", "bizdate", "bookdate", "audittime", "entryid"}).select((this.getTempSelects() + ",PreRowValue(periodendqty) + periodinqtybak - periodoutqty as periodendqty,PreRowValue(periodendamount) + periodinamountbak - periodoutamount as periodendamount,unitprice,billid,bizentityobject,ordercol_second").split(","));
    }

    private DataSet filterStratPeriod(DataSet dataSet) {
        QFilter periodQ = new QFilter("ordercol_second", "=", (Object)0);
        QFilter bizQ = new QFilter("ordercol_second", "=", (Object)1);
        HashMap<String, Date> map = new HashMap<String, Date>();
        map.put("a", this.filter_startDate);
        DataSet periodDataSet = dataSet.copy().filter(periodQ.toString());
        DataSet beforeDataSet = dataSet.copy().filter(bizQ.toString()).filter("bookdate < a", map);
        DataSet afterDataSet = dataSet.filter(bizQ.toString()).filter("bookdate >= a", map);
        beforeDataSet = periodDataSet.union(beforeDataSet);
        beforeDataSet = beforeDataSet.orderBy(new String[]{"year desc", "period desc", "ordercol_second desc", "bookdate desc", "audittime desc", "entryid desc"});
        beforeDataSet = beforeDataSet.top(1);
        beforeDataSet = beforeDataSet.select(this.getPeriodBeginFinalTopSelects());
        afterDataSet = beforeDataSet.union(afterDataSet).orderBy(new String[]{"year", "period", "ordercol_second", "bookdate", "audittime", "entryid"});
        return afterDataSet;
    }

    private DataSet unionTotalDataSet(DataSet dataSet) {
        DataSet periodTotalDataSet = dataSet.copy().groupBy().sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").minP("ordercol_second", "periodendqty").minP("ordercol_second", "periodendamount").finish().select(new String[]{this.currentEndPeriod.getInt("periodyear") + " as year", this.currentEndPeriod.getInt("periodnumber") + " as period", "periodinqty", "periodinamount", "periodoutqty", "periodoutamount", "periodendqty+periodinqty-periodoutqty as periodendqty", "periodendamount+periodinamount-periodoutamount as periodendamount"}).select(this.getPeriodTotalFinalSelects().split(","));
        return dataSet.addField("0", "ordercol_first").union(periodTotalDataSet.addField("1", "ordercol_second").addField("1", "ordercol_first"));
    }

    private DataSet topSumRow(DataSet dataSet) {
        if (this.topSumRow) {
            return dataSet.orderBy(new String[]{"ordercol_first desc", "year", "period", "ordercol_second", "bizdate", "bookdate", "audittime", "entryid"});
        }
        return dataSet.orderBy(new String[]{"ordercol_first", "year", "period", "ordercol_second", "bizdate", "bookdate", "audittime", "entryid"});
    }

    private DataSet onlyShowSumRow(DataSet dataSet) {
        if (this.onlyShowSumRow) {
            return dataSet.filter("ordercol_first <> 0");
        }
        return dataSet;
    }

    private QFilter getPeriodBeginBalFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("material", "=", (Object)this.materialId);
        q.and("period", "=", (Object)0);
        q.and("year*100+month", ">=", (Object)this.costAccount_startPeriodNumber);
        q.and("year*100+month", "<=", (Object)this.filter_endPeriodNumber);
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_balance");
        if (this.filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("project", "in", set);
        }
        if (this.filter_tracknumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_tracknumber) {
                set.add(info.getPkValue());
            }
            q.and("tracknumber", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("invstatus", "in", set);
        }
        return q;
    }

    private String getPeriodBeginFinalSelects() {
        String s = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"StockCostDetailRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("year as year,month as period,null as bizdate,null as bookdate,null as audittime,'0' as isvoucher,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,null as comment,null as ownertype,0 as owner,null as storageorgnumber,null as storageorgname,");
        select.append("null as warehousenumber,null as warehousename,");
        select.append("null as warehsgroupnumber,null as warehsgroupname,null as locationnumber,null as locationname,null as lot,");
        select.append("null as assist,null as projectname,null as tracknumber,");
        select.append("0 as periodinqty,0 as periodinamount,");
        select.append("0 as periodoutqty,0 as periodoutamount,");
        select.append("0 as periodendqty,0 as periodendamount,");
        select.append("0 as unitprice,");
        select.append("periodbeginqty as periodinqtybak,periodbeginactualcost as periodinamountbak,");
        select.append("0 as billid,null as bizentityobject,null as entryid,null as srcobject");
        return select.toString();
    }

    private String getPeriodBeginFinalTopSelects() {
        String s = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"StockCostDetailRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("year as year,period as period,null as bizdate,null as bookdate,null as audittime,'0' as isvoucher,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,null as comment,null as ownertype,0 as owner,null as storageorgnumber,null as storageorgname,");
        select.append("null as warehousenumber,null as warehousename,");
        select.append("null as warehsgroupnumber,null as warehsgroupname,null as locationnumber,null as locationname,null as lot,");
        select.append("null as assist,null as projectname,null as tracknumber,null as entryid,null as srcobject,");
        select.append("0 as periodinqty,0 as periodinamount,");
        select.append("0 as periodoutqty,0 as periodoutamount,");
        select.append("periodendqty as periodendqty,periodendamount as periodendamount,");
        select.append("0 as unitprice,");
        select.append("0 as billid,null as bizentityobject,0 as ordercol_second");
        return select.toString();
    }

    private String getPeriodTotalFinalSelects() {
        String s = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"StockCostDetailRptQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("year as year,period as period,null as bizdate,null as bookdate,null as audittime,'0' as isvoucher,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,null as ownertype,null as comment,0 as owner,null as storageorgnumber,null as storageorgname,");
        select.append("null as warehousenumber,null as warehousename,null as warehsgroupnumber,null as warehsgroupname,null as locationnumber,null as locationname,null as lot,");
        select.append("null as assist,null as projectname,null as tracknumber,null as entryid,null as srcobject,");
        select.append("periodinqty as periodinqty,periodinamount as periodinamount,");
        select.append("periodoutqty as periodoutqty,periodoutamount as periodoutamount,");
        select.append("periodendqty as periodendqty,periodendamount as periodendamount,");
        select.append("0 as unitprice,");
        select.append("0 as billid,null as bizentityobject");
        return select.toString();
    }

    private String getTempSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,comment,ownertype,owner,storageorgnumber,storageorgname,");
        select.append("warehousenumber,warehousename,warehsgroupnumber,warehsgroupname,locationnumber,locationname,lot,");
        select.append("assist,projectname,tracknumber,entryid,srcobject,");
        select.append("periodinqty,periodinamount,");
        select.append("periodoutqty,periodoutamount");
        return select.toString();
    }

    private String getAliasSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,storageorgnumber,storageorgname,");
        select.append("warehousenumber,warehousename,warehsgroupnumber,warehsgroupname,locationnumber,locationname,lot,");
        select.append("assist,projectname,tracknumber,");
        select.append("periodinqty,periodinamount,");
        select.append("periodoutqty,periodoutamount,");
        select.append("periodendqty,periodendamount,");
        select.append("unitprice,");
        select.append("periodinqtybak,periodinamountbak,");
        select.append("billid,bizentityobject,entryid,srcobject");
        return select.toString();
    }

    private String getFinalSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,case when period = 99 then 0 else period end as period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,comment,storageorgnumber,storageorgname,");
        select.append("ownertype,owner,owner as ownernumber,warehousenumber,warehousename,warehsgroupnumber,warehsgroupname,locationnumber,locationname,lot,");
        select.append("assist as assistproperty,projectname,tracknumber,");
        select.append("periodinqty,periodinamount,");
        select.append("periodoutqty,periodoutamount,");
        select.append("periodendqty,periodendamount,");
        select.append(this.getPriceSelect("periodinamount", "periodinqty")).append(" as periodinprice,");
        select.append(this.getPriceSelect("periodoutamount", "periodoutqty")).append(" as periodoutprice,");
        select.append(this.getEndPriceSelect("periodendamount", "periodendqty")).append(" as periodendprice,");
        select.append(this.baseUnitId).append(" as baseunitid,").append(this.currencyId).append(" as currencyid,");
        if (this.showdetail && this.onlyShowSumRow) {
            select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname,");
        }
        select.append("billid,bizentityobject").append(",").append(this.materialId).append(" as materialid");
        return select.toString();
    }

    private String getEndPriceSelect(String amount, String qty) {
        return "case when  " + qty + " = 0 then 0 else " + amount + "/" + qty + " end ";
    }

    private String getPriceSelect(String amount, String qty) {
        return "case when unitprice <> 0  and " + qty + " <> 0 then unitprice when " + qty + " = 0 then 0 else " + amount + "/" + qty + " end ";
    }

    private void createDecimalColumns(List<AbstractReportColumn> cols) {
        this.createDecimalColumn(cols, this.locale_periodIn, "periodin");
        this.createDecimalColumn(cols, this.locale_periodOut, "periodout");
        this.createDecimalColumn(cols, this.locale_periodEnd, "periodend");
    }

    private void createDecimalColumn(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey);
        cols.add((AbstractReportColumn)groupCol);
        ReportColumn qty = new ReportColumn();
        qty.setCaption(this.locale_qty);
        qty.setWidth(width);
        qty.setFieldKey(fieldKey + "qty");
        qty.setFieldType("qty");
        qty.setMeasureUnitField("baseunitid");
        ReportColumn price = new ReportColumn();
        price.setCaption(this.locale_price);
        price.setWidth(width);
        price.setFieldKey(fieldKey + "price");
        price.setFieldType("price");
        price.setCurrencyField("currencyid");
        ReportColumn amount = new ReportColumn();
        amount.setCaption(this.locale_amount);
        amount.setWidth(width);
        amount.setFieldKey(fieldKey + "amount");
        amount.setFieldType("amount");
        amount.setCurrencyField("currencyid");
        groupCol.getChildren().add(qty);
        groupCol.getChildren().add(price);
        groupCol.getChildren().add(amount);
    }

    private void createHideColumns(List<AbstractReportColumn> cols) {
        ReportColumn baseUnitId = new ReportColumn();
        baseUnitId.setCaption(this.locale_baseUnit);
        baseUnitId.setWidth(width);
        baseUnitId.setFieldKey("baseunitid");
        baseUnitId.setFieldType("unit");
        baseUnitId.setEntityId("bd_measureunits");
        baseUnitId.setHide(true);
        ReportColumn currencyId = new ReportColumn();
        currencyId.setCaption(this.locale_currency);
        currencyId.setWidth(width);
        currencyId.setFieldKey("currencyid");
        currencyId.setFieldType("currency");
        currencyId.setEntityId("bd_currency");
        currencyId.setHide(true);
        ReportColumn bizEntityObject = new ReportColumn();
        bizEntityObject.setCaption(this.locale_currency);
        bizEntityObject.setWidth(width);
        bizEntityObject.setFieldKey("bizentityobject");
        bizEntityObject.setFieldType("text");
        bizEntityObject.setHide(true);
        ReportColumn billId = new ReportColumn();
        billId.setCaption(this.locale_currency);
        billId.setWidth(width);
        billId.setFieldKey("billid");
        billId.setFieldType("text");
        billId.setHide(true);
        cols.add((AbstractReportColumn)baseUnitId);
        cols.add((AbstractReportColumn)currencyId);
        cols.add((AbstractReportColumn)bizEntityObject);
        cols.add((AbstractReportColumn)billId);
    }

    private DataSet getDetailByBatch(Set<Object> ids, String entityName, String selectFields) {
        if (ids == null || ids.size() < 1) {
            QFilter qFilter = new QFilter("1", "!=", (Object)"1");
            return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
        }
        List<Set<Object>> balIdsArray = this.getBatchIdList(ids);
        DataSet detailDataSet = null;
        for (int arrayIndex = 0; arrayIndex < balIdsArray.size(); ++arrayIndex) {
            QFilter qFilter = new QFilter("entryid", "in", balIdsArray.get(arrayIndex));
            DataSet currDetailDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
            detailDataSet = detailDataSet == null ? currDetailDataSet : detailDataSet.union(currDetailDataSet);
        }
        return detailDataSet;
    }

    private List<Set<Object>> getBatchIdList(Set<Object> ids) {
        ArrayList<Set<Object>> balIdsArray = new ArrayList<Set<Object>>(16);
        HashSet<Object> balIds = null;
        long index = 0L;
        for (Object id : ids) {
            if (index % 100000L == 0L) {
                balIds = new HashSet<Object>();
                balIdsArray.add(balIds);
            }
            if (balIds != null) {
                balIds.add(id);
            }
            ++index;
        }
        return balIdsArray;
    }

    private int getPeriodByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int period = year * 100 + month;
        return period;
    }
}

