/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.StringType;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.balance.BalanceUncompressHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalBillRuleHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.MaterialCategoryHelper;
import kd.fi.cal.common.model.CalBillRule;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.common.util.ReportUtil;

public class StockCostGatherRptQueryPlugin
extends AbstractReportListDataPlugin {
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private Date filter_startdate;
    private Date filter_enddate;
    private boolean noShowZeroInOut;
    private boolean showAllZero;
    private List<String> groupTypes = new ArrayList<String>(8);
    private boolean onlyShowSumRow;
    private boolean topSumRow;
    private long currencyId;
    private DynamicObjectCollection filter_owner;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private DynamicObjectCollection filter_materialFrom;
    private DynamicObject filter_materialTo;
    private DynamicObjectCollection filter_materialgroupfrom;
    private DynamicObject filter_assistProperty;
    private String filter_lot;
    private DynamicObjectCollection filter_project;
    private DynamicObjectCollection filter_trackNumber;
    private DynamicObjectCollection filter_invType;
    private DynamicObjectCollection filter_invStatus;
    private DynamicObjectCollection filter_mulMaterialCategory;
    private MaterialCategoryHelper materialCategoryHelper = null;
    private String groupType;
    private String qtyShowCondition;
    private String amountShowCondition;
    private DataSet calRecordDsf;
    private List<Long> invOrgIds = new ArrayList<Long>();
    private Long[] acctOwnerIds = new Long[0];
    private Map<String, String> recs = new LinkedHashMap<String, String>();
    private Map<String, String> sends = new LinkedHashMap<String, String>();
    private Boolean displayin;
    private Boolean displayout;
    private Boolean displayqty2nd;
    private boolean notShowMaterialGroup;
    private DynamicObject materialgroupstandard;
    public static final String MATERIALGROUPSTANDARD = "materialgroupstandard";
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private LocaleString locale_qty = new LocaleString(this.getLocale_qty());
    private LocaleString locale_assistqty = new LocaleString(this.getLocale_assistqty());
    private LocaleString locale_assistprice = new LocaleString(this.getLocale_assistprice());
    private LocaleString locale_price = new LocaleString(this.getLocale_price());
    private LocaleString locale_amount = new LocaleString(this.getLocale_amount());
    private static final LocaleString width = new LocaleString("100px");
    private Set<Long> recSedTypes = new HashSet<Long>(16);
    private Set<String> recSpBills = new HashSet<String>(16);
    private Set<String> sedSpBills = new HashSet<String>(16);
    private static final List<String> SPBILLS = Arrays.asList("im_adjustbill", "im_assembbill", "im_locationtransfer", "im_disassemblebill");
    private List<String> rptDims = new ArrayList<String>(16);
    private Map<String, List<CalBillRule>> inCalBillRuleMap;
    private Map<String, List<CalBillRule>> outCalBillRuleMap;
    private Map<String, String> rptDimCalBillDimMap = new HashMap<String, String>(16);
    private Map<String, String> rptDimCalRecordDimMap = new HashMap<String, String>(16);
    private Map<String, String> rptDimCalAdjDimMap = new HashMap<String, String>(16);
    private Map<String, String> rptDimCalBalDimMap = new HashMap<String, String>(16);
    private Map<String, String> rptDimInvBalDimMap = new HashMap<String, String>(16);
    private Set<Long> notUpdBalBizTypes;
    private Boolean isNewPeriodBal = false;
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    private String getLocale_qty() {
        return ResManager.loadKDString((String)"\u6570\u91cf", (String)"StockGatherRptQueryPlugin_25", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_assistqty() {
        return ResManager.loadKDString((String)"\u8f85\u52a9\u6570\u91cf", (String)"StockCostGatherRptQueryPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_assistprice() {
        return ResManager.loadKDString((String)"\u8f85\u52a9\u5355\u4ef7", (String)"StockCostGatherRptQueryPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_price() {
        return ResManager.loadKDString((String)"\u5355\u4ef7", (String)"StockGatherRptQueryPlugin_26", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_amount() {
        return ResManager.loadKDString((String)"\u91d1\u989d", (String)"StockGatherRptQueryPlugin_27", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public DataSet query(ReportQueryParam param, Object arg1) {
        this.init(param);
        DataSet materialGroupDs = ReportUtil.getClassifiedMaterialDataSet((FilterInfo)this.filterInfo, (boolean)this.notShowMaterialGroup, (DynamicObject)this.materialgroupstandard);
        DataSet dataSet = this.getCalDataSet();
        DataSet invDataSet = this.getInvDataSet();
        if (this.hasGroup(this.groupType, "L")) {
            dataSet = this.hasGroup(this.groupType, "C") ? dataSet.leftJoin(this.materialCategoryHelper.getMaterialCategoryDataSet(false)).on("owner", "owner").on("material", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialcategory"}).finish() : dataSet.leftJoin(this.materialCategoryHelper.getMaterialCategoryDataSet(true)).on("material", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialcategory"}).finish();
            if (invDataSet != null) {
                invDataSet = this.hasGroup(this.groupType, "C") ? invDataSet.leftJoin(this.materialCategoryHelper.getMaterialCategoryDataSet(false)).on("owner", "owner").on("material", "material").select(invDataSet.getRowMeta().getFieldNames(), new String[]{"materialcategory"}).finish() : invDataSet.leftJoin(this.materialCategoryHelper.getMaterialCategoryDataSet(true)).on("material", "material").select(invDataSet.getRowMeta().getFieldNames(), new String[]{"materialcategory"}).finish();
            }
        }
        dataSet = this.addBaseMaterialGroup(dataSet, materialGroupDs);
        invDataSet = this.addBaseMaterialGroup(invDataSet, materialGroupDs);
        HashSet<String> tsSumFields = new HashSet<String>();
        HashSet<String> cAdjSumFields = new HashSet<String>();
        invDataSet = this.addTransceiverColumn(invDataSet, tsSumFields);
        dataSet = this.addCostTransciverColumn(dataSet, cAdjSumFields);
        DataSet calGroupByDs = this.getCalGroupByDs(dataSet, cAdjSumFields);
        DataSet invGroupByDs = this.getInvGroupByDs(invDataSet, tsSumFields);
        if (invGroupByDs != null) {
            JoinDataSet calLJoinInvDs = calGroupByDs.join(invGroupByDs, JoinType.LEFT);
            List<String> groupDimf = this.getGroupDimf();
            for (String dimf : groupDimf) {
                calLJoinInvDs = calLJoinInvDs.on(dimf, dimf);
            }
            calGroupByDs = this.addPrice(tsSumFields, calGroupByDs, calLJoinInvDs);
        }
        calGroupByDs = this.filterByQtyCondition(calGroupByDs);
        calGroupByDs = this.filterByAmountCondition(calGroupByDs);
        calGroupByDs = this.noShowZeroInOut(calGroupByDs);
        calGroupByDs = this.filterByAllZeroCondition(calGroupByDs);
        calGroupByDs = calGroupByDs.addField("0", "ordercol");
        DataSet resultDs = calGroupByDs.addField("material", "materialauxpty").union(this.unionGroupDataSet(calGroupByDs, true));
        resultDs = this.topSumRow ? resultDs.union(this.unionGroupDataSet(calGroupByDs, false).addField("0", "materialauxpty")) : resultDs;
        ArrayList<String> orders = new ArrayList<String>(this.groupTypes.size() + 2);
        orders.addAll(this.groupTypes);
        orders.add(this.topSumRow ? "ordercol desc" : "ordercol");
        orders.add("materialnum");
        resultDs = resultDs.orderBy(orders.toArray(new String[0]));
        resultDs = this.topSumRow ? resultDs : resultDs.union(this.unionGroupDataSet(calGroupByDs, false).addField("0", "materialauxpty"));
        resultDs = this.onlyShowSumRow ? resultDs.filter("ordercol <> 0") : resultDs;
        return resultDs;
    }

    private DataSet filterByAllZeroCondition(DataSet calGroupByDs) {
        if (!this.showAllZero) {
            String filter = "bgn_qty <> 0 or bgn_amount <> 0 or rec_qty <> 0 or rec_amount <> 0 or sed_qty <> 0 or sed_amount <> 0 or end_qty <> 0 or end_amount <> 0 ";
            if (this.displayqty2nd.booleanValue()) {
                filter = filter + " or (bgn2nd_qty <> 0 and bgn2nd_qty <> null) or (rec2nd_qty <> 0 and rec2nd_qty <> null) or (sed2nd_qty <> 0 and sed2nd_qty <> null) or (end2nd_qty <> 0 and end2nd_qty <> null)";
            }
            calGroupByDs = calGroupByDs.filter(filter);
        }
        return calGroupByDs;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List oldColumns = super.getColumns(columns);
        ArrayList<AbstractReportColumn> newColumns = new ArrayList<AbstractReportColumn>(oldColumns.size());
        for (AbstractReportColumn abstractReportColumn : oldColumns) {
            boolean nonContainColumnName;
            ReportColumn column = (ReportColumn)abstractReportColumn;
            String columnName = column.createColumn().get("dataIndex").toString();
            boolean bl = nonContainColumnName = this.groupTypes.indexOf(columnName) < 0;
            if (("owner".equals(columnName) || "owner".equals(column.getRefBasedataProp())) && nonContainColumnName) {
                column.setHide(true);
            } else if (("storageorg".equals(columnName) || "storageorg".equals(column.getRefBasedataProp())) && nonContainColumnName) {
                column.setHide(true);
            } else if (("warehs".equals(columnName) || "warehs".equals(column.getRefBasedataProp())) && nonContainColumnName) {
                column.setHide(true);
            } else if (("location".equals(columnName) || "location".equals(column.getRefBasedataProp())) && nonContainColumnName) {
                column.setHide(true);
            } else if ("lot".equals(columnName) && nonContainColumnName) {
                column.setHide(true);
            } else if ("auxpty".equals(columnName) && nonContainColumnName) {
                column.setHide(true);
            } else if ("project".equals(columnName) && nonContainColumnName) {
                column.setHide(true);
            } else if ("tracknumber".equals(columnName) && nonContainColumnName) {
                column.setHide(true);
            } else if ("eauxpty".equals(columnName) && nonContainColumnName) {
                column.setHide(true);
            } else if ("group".equals(columnName)) {
                column.setHide(this.notShowMaterialGroup);
            } else if ("unit2nd".equals(columnName) && !this.displayqty2nd.booleanValue()) {
                column.setHide(true);
            } else if (("warehsgroup".equals(columnName) || "warehsgroup".equals(column.getRefBasedataProp())) && nonContainColumnName) {
                column.setHide(true);
            } else if (("materialcategory".equals(columnName) || "materialcategory".equals(column.getRefBasedataProp())) && nonContainColumnName) {
                column.setHide(true);
            }
            newColumns.add((AbstractReportColumn)column);
        }
        this.createDecimalColumn(newColumns, ResManager.loadKDString((String)"\u671f\u521d", (String)"SalesEstimateGroupQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]), "bgn");
        if (this.displayin.booleanValue()) {
            this.createDecimalColumn(newColumns, ResManager.loadKDString((String)"\u6536\u5165", (String)"StockCostGatherRptQueryPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]), "rec");
        }
        for (Map.Entry entry : this.recs.entrySet()) {
            this.createDecimalColumn(newColumns, (String)entry.getValue(), "rec" + (String)entry.getKey());
        }
        if (this.displayout.booleanValue()) {
            this.createDecimalColumn(newColumns, ResManager.loadKDString((String)"\u53d1\u51fa", (String)"StockCostGatherRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]), "sed");
        }
        for (Map.Entry entry : this.sends.entrySet()) {
            this.createDecimalColumn(newColumns, (String)entry.getValue(), "sed" + (String)entry.getKey());
        }
        this.createDecimalColumn(newColumns, ResManager.loadKDString((String)"\u671f\u672b", (String)"StockCostGatherRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]), "end");
        return newColumns;
    }

    private void init(ReportQueryParam param) {
        this.filterInfo = param.getFilter();
        this.invOrgIds = new ArrayList<Long>();
        this.initRecAndSeds();
        this.displayin = this.filterInfo.getBoolean("displayin");
        this.displayout = this.filterInfo.getBoolean("displayout");
        this.displayqty2nd = this.filterInfo.getBoolean("displayqty2nd");
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.acctOwnerIds = AccountingSysHelper.getOwners((Long)((Long)this.filter_costAccount.getPkValue()));
        this.filter_startdate = this.filterInfo.getDate("startdate");
        this.filter_enddate = DateUtils.getDayEndTime((Date)this.filterInfo.getDate("enddate"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.filter_startdate);
        calendar.setTime(this.filter_enddate);
        this.noShowZeroInOut = this.filterInfo.getBoolean("noshowzeroinout");
        this.showAllZero = this.filterInfo.getBoolean("showallzero");
        this.groupType = this.filterInfo.getString("mulgrouptype");
        if (this.groupType == null) {
            this.groupType = "A";
        }
        this.appendCommonGroupCols();
        this.onlyShowSumRow = this.filterInfo.getBoolean("onlyshowsumrow");
        this.topSumRow = this.filterInfo.getBoolean("topsumrow");
        this.currencyId = this.filterInfo.getDynamicObject("localcurrency").getLong("id");
        this.filter_owner = this.filterInfo.getDynamicObjectCollection("mulowner");
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        if (this.filter_storageOrg != null && this.filter_storageOrg.size() > 0) {
            for (DynamicObject info : this.filter_storageOrg) {
                this.invOrgIds.add((Long)info.getPkValue());
            }
        }
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        this.filter_materialFrom = this.filterInfo.getDynamicObjectCollection("mulmaterial");
        this.filter_materialTo = this.filterInfo.getDynamicObject("materialto");
        this.filter_materialgroupfrom = this.filterInfo.getDynamicObjectCollection("mulmaterialgroup");
        this.filter_assistProperty = this.filterInfo.getDynamicObject("assist");
        this.filter_lot = this.filterInfo.getString("lotnumber");
        this.filter_project = this.filterInfo.getDynamicObjectCollection("mulproject");
        this.filter_trackNumber = this.filterInfo.getDynamicObjectCollection("multracknum");
        this.filter_invType = this.filterInfo.getDynamicObjectCollection("mulinvtype");
        this.filter_invStatus = this.filterInfo.getDynamicObjectCollection("mulinvstatus");
        this.qtyShowCondition = this.filterInfo.getString("qtyshowcondition");
        this.amountShowCondition = this.filterInfo.getString("amountshowcondition");
        this.materialgroupstandard = this.filterInfo.getDynamicObject(MATERIALGROUPSTANDARD);
        this.notShowMaterialGroup = this.materialgroupstandard == null && (this.filter_materialgroupfrom == null || this.filter_materialgroupfrom.size() < 1) && !this.hasGroup(this.groupType, "K");
        this.initRptDims();
        this.initCalBillRules();
        this.initRptDimCalBalDimMap();
        this.initRptDimCalRecordDimMap();
        this.initRptDimCalAdjDimMap();
        this.notUpdBalBizTypes = CommonSettingHelper.getNotUpdBalBizType();
        this.isNewPeriodBal = (Boolean)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvBalanceService", (String)"isNewPeriodBal", (Object[])new Object[0]);
        this.filter_mulMaterialCategory = this.filterInfo.getDynamicObjectCollection("mulmatcategory");
        if (this.filter_mulMaterialCategory != null || this.hasGroup(this.groupType, "L")) {
            DynamicObjectCollection costacconts = new DynamicObjectCollection();
            costacconts.add((Object)this.filter_costAccount);
            this.materialCategoryHelper = new MaterialCategoryHelper(costacconts, this.filter_owner, this.filter_mulMaterialCategory);
        }
    }

    private void initRecAndSeds() {
        String showspecialbill;
        DynamicObjectCollection receivers = this.filterInfo.getDynamicObjectCollection("showreceiver");
        if (receivers != null && receivers.size() != 0) {
            for (DynamicObject receiver : receivers) {
                String transceiver = receiver.getString("transceiver");
                String transceiverName = receiver.getString("name");
                String transceiverNumber = receiver.getString("id");
                if ("2".equals(transceiver)) {
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u5165", (String)"StockGatherRptQueryPlugin_52", (String)"fi-cal-report", (Object[])new Object[0]), transceiverName);
                    this.recs.put(transceiverNumber, msg);
                    String msg1 = String.format(ResManager.loadKDString((String)"%1$s\u51fa", (String)"StockGatherRptQueryPlugin_53", (String)"fi-cal-report", (Object[])new Object[0]), transceiverName);
                    this.sends.put(transceiverNumber, msg1);
                } else if ("0".equals(transceiver)) {
                    this.recs.put(transceiverNumber, transceiverName);
                } else if ("1".equals(transceiver)) {
                    this.sends.put(transceiverNumber, transceiverName);
                }
                this.recSedTypes.add(receiver.getLong("id"));
            }
        }
        if ((showspecialbill = this.filterInfo.getString("showspecialbill")) != null && !showspecialbill.trim().equals("")) {
            String[] specialbills = showspecialbill.trim().split(",");
            MulComboProp showSpecialBillProp = (MulComboProp)EntityMetadataCache.getDataEntityType((String)"cal_stockcostgatherrpt").findProperty("showspecialbill");
            String[] stringArray = specialbills;
            int n = stringArray.length;
            block21: for (int i = 0; i < n; ++i) {
                String specialbill;
                switch (specialbill = stringArray[i]) {
                    case "transrec": {
                        this.recs.put("im_adjustbill0", ResManager.loadKDString((String)"\u5f62\u6001\u8f6c\u6362\u5165", (String)"StockCostGatherRptQueryPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
                        this.recSpBills.add("im_adjustbill");
                        continue block21;
                    }
                    case "transsend": {
                        this.sends.put("im_adjustbill1", ResManager.loadKDString((String)"\u5f62\u6001\u8f6c\u6362\u51fa", (String)"StockCostGatherRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]));
                        this.sedSpBills.add("im_adjustbill");
                        continue block21;
                    }
                    case "assembbillrec": {
                        this.recs.put("im_assembbill0", ResManager.loadKDString((String)"\u7ec4\u88c5\u540e", (String)"StockCostGatherRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]));
                        this.recSpBills.add("im_assembbill");
                        continue block21;
                    }
                    case "assembbillsend": {
                        this.sends.put("im_assembbill1", ResManager.loadKDString((String)"\u7ec4\u88c5\u524d", (String)"StockCostGatherRptQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]));
                        this.sedSpBills.add("im_assembbill");
                        continue block21;
                    }
                    case "locationtransferbillrec": {
                        this.recs.put("im_locationtransfer0", ResManager.loadKDString((String)"\u4ed3\u4f4d\u79fb\u52a8\u8c03\u5165", (String)"StockCostGatherRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]));
                        this.recSpBills.add("im_locationtransfer");
                        continue block21;
                    }
                    case "locationtransferbillsend": {
                        this.sends.put("im_locationtransfer1", ResManager.loadKDString((String)"\u4ed3\u4f4d\u79fb\u52a8\u8c03\u51fa", (String)"StockCostGatherRptQueryPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]));
                        this.sedSpBills.add("im_locationtransfer");
                        continue block21;
                    }
                    case "costadjustbillrec": {
                        this.recs.put("cal_costadjustbill0", ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5165", (String)"StockCostGatherRptQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]));
                        this.recSpBills.add("cal_costadjustbill");
                        continue block21;
                    }
                    case "costadjustbillsed": {
                        this.sends.put("cal_costadjustbill1", ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u51fa", (String)"StockCostGatherRptQueryPlugin_16", (String)"fi-cal-report", (Object[])new Object[0]));
                        this.sedSpBills.add("cal_costadjustbill");
                        continue block21;
                    }
                    default: {
                        if (specialbill.endsWith("rec")) {
                            this.recs.put(specialbill.replace("rec", "0"), showSpecialBillProp.getItemByName(specialbill));
                            this.recSpBills.add(specialbill.replace("rec", ""));
                            continue block21;
                        }
                        if (!specialbill.endsWith("sed") && !specialbill.endsWith("send")) continue block21;
                        this.sends.put(specialbill.replace("sed", "1").replace("send", "1"), showSpecialBillProp.getItemByName(specialbill));
                        this.sedSpBills.add(specialbill.replace("sed", "").replace("send", ""));
                    }
                }
            }
        }
    }

    private DataSet addPrice(Set<String> tsSumFields, DataSet calGroupByDs, JoinDataSet calLJoinInvDs) {
        tsSumFields.addAll(Arrays.asList("case when unit2nd is null then 0 else unit2nd end as unit2nd", "bgn2nd_qty", "end2nd_qty", "rec2nd_qty", "sed2nd_qty"));
        calGroupByDs = calLJoinInvDs.select(calGroupByDs.getRowMeta().getFieldNames(), tsSumFields.toArray(new String[0])).finish();
        ArrayList<String> allColumns = new ArrayList<String>(Arrays.asList(calGroupByDs.getRowMeta().getFieldNames()));
        allColumns.add("case when bgn2nd_qty = 0 then 0 else bgn_amount/bgn2nd_qty end as bgn2nd_price");
        allColumns.add("case when end2nd_qty = 0 then 0 else end_amount/end2nd_qty end as end2nd_price");
        allColumns.add("case when rec2nd_qty = 0 then 0 else rec_amount/rec2nd_qty end as rec2nd_price");
        allColumns.add("case when sed2nd_qty = 0 then 0 else sed_amount/sed2nd_qty end as sed2nd_price");
        for (String rec : this.recs.keySet()) {
            if (rec.equals("cal_costadjustbill0")) continue;
            allColumns.add("case when rec" + rec + "_qty = 0 then 0 else rec" + rec + "_amount/rec" + rec + "_qty end as rec" + rec + "_price");
            allColumns.add("case when rec" + rec + "2nd_qty = 0 then 0 else rec" + rec + "_amount/rec" + rec + "2nd_qty end as rec" + rec + "2nd_price");
        }
        for (String sed : this.sends.keySet()) {
            if (sed.equals("cal_costadjustbill1")) continue;
            allColumns.add("case when sed" + sed + "_qty = 0 then 0 else sed" + sed + "_amount/sed" + sed + "_qty end as sed" + sed + "_price");
            allColumns.add("case when sed" + sed + "2nd_qty = 0 then 0 else sed" + sed + "_amount/sed" + sed + "2nd_qty end as sed" + sed + "2nd_price");
        }
        calGroupByDs = calGroupByDs.select(allColumns.toArray(new String[0]));
        return calGroupByDs;
    }

    private DataSet unionGroupDataSet(DataSet dataSet, boolean subTotal) {
        String[] groups = subTotal ? this.groupTypes.toArray(new String[0]) : new String[]{};
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(groups);
        ArrayList<String> fields = new ArrayList<String>(32);
        for (Field field : dataSet.getRowMeta().getFields()) {
            String alia = field.getAlias();
            if (alia.contains("qty") || alia.contains("amount")) {
                groupbyDataSet.sum(alia);
            } else if (alia.contains("price")) {
                String aliaPre = alia.substring(0, alia.lastIndexOf("_"));
                String qtyf = aliaPre + "_qty";
                alia = "case when " + qtyf + " = 0 then 0 else " + aliaPre.replace("2nd", "") + "_amount/" + qtyf + " end as " + alia;
            } else if (alia.equals("materialnum")) {
                String totalName = subTotal ? ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"StockGatherRptQueryPlugin_29", (String)"fi-cal-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u603b\u8ba1", (String)"StockGatherRptQueryPlugin_32", (String)"fi-cal-report", (Object[])new Object[0]);
                alia = "'" + totalName + "' as " + alia;
            } else if (field.getDataType() instanceof StringType) {
                if (!subTotal || this.groupTypes.indexOf(alia) < 0) {
                    alia = "' ' as " + alia;
                }
            } else if (alia.equals("ordercol")) {
                alia = (subTotal ? "1" : "2") + " as " + alia;
            } else if (alia.equals("currencyid")) {
                alia = this.currencyId + " as " + alia;
            } else if (!subTotal || this.groupTypes.indexOf(alia) < 0) {
                alia = "0 as " + alia;
            }
            fields.add(alia);
        }
        DataSet groupByDs = null;
        if (subTotal) {
            fields.add("materialauxpty");
            groupByDs = groupbyDataSet.max("material", "materialauxpty").finish().select(fields.toArray(new String[0]));
        } else {
            groupByDs = groupbyDataSet.finish().select(fields.toArray(new String[0]));
        }
        return groupByDs;
    }

    private List<QFilter> getCalBalFilter() {
        ArrayList<QFilter> baseFilters = new ArrayList<QFilter>(16);
        QFilter filter = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        baseFilters.add(filter);
        this.addFormFilters(this.rptDimCalBalDimMap, baseFilters);
        return baseFilters;
    }

    private DataSet getCalDataSet() {
        boolean showCostStdDiffAdjBillSedSp;
        boolean showCostStdDiffAdjBillRecSp;
        DataSet calDs;
        List<QFilter> balFilter = this.getCalBalFilter();
        DynamicObject periodDyc = this.getYearPeriodByDate(this.filter_costAccount.getPkValue(), this.filter_startdate);
        int yearPeriod = periodDyc == null ? 1 : periodDyc.getInt("periodyear") * 100 + periodDyc.getInt("periodnumber");
        Date periodBeginDate = periodDyc == null ? null : periodDyc.getDate("begindate");
        QFilter periodf = new QFilter("period", "<", (Object)yearPeriod);
        periodf.and(new QFilter("endperiod", ">=", (Object)yearPeriod));
        balFilter.add(periodf);
        if (this.isNewBalance) {
            String[] groupSelect;
            String moreFields;
            boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
            if (!balCompress) {
                moreFields = ",warehouse.group,baseunit,material.number,currency,baseqty_bal as periodendqty,actualcost_bal as periodendactualcost";
                String select = CalBalanceModelHelper.getDimFields((boolean)true) + moreFields;
                groupSelect = (CalBalanceModelHelper.getDimFields((boolean)false) + ",warehouse.group,baseunit,material.number,currency").split(",");
                calDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)select, (QFilter[])balFilter.toArray(new QFilter[0]), null);
                calDs = calDs.groupBy(groupSelect).max("periodendqty").sum("periodendactualcost").finish();
                calDs = calDs.select(this.getBalSelectFields());
            } else {
                moreFields = ",warehouse.group,baseunit,material.number,calpolicy.currency as currency,baseqty_bal as periodendqty,actualcost_bal as periodendactualcost";
                String selectFields = CalBalanceModelHelper.getDimFields((boolean)true) + moreFields;
                groupSelect = (CalBalanceModelHelper.getDimFields((boolean)false) + ",warehouse.group,baseunit,material.number,currency").split(",");
                HashSet<String> otherFields = new HashSet<String>();
                otherFields.add("material.number");
                otherFields.add("warehouse.group");
                otherFields.add("calpolicy.currency");
                calDs = BalanceUncompressHelper.getBalancDataSetDetail((boolean)true, (boolean)false, otherFields, balFilter).select(selectFields);
                calDs = calDs.groupBy(groupSelect).sum("periodendqty").sum("periodendactualcost").finish();
                calDs = calDs.select(this.getBalSelectFields());
            }
        } else {
            calDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)this.getBalSelectFields(), (QFilter[])balFilter.toArray(new QFilter[0]), null);
        }
        Date startDateLastTime = StockCostGatherRptQueryPlugin.getPreDay(this.filter_startdate);
        DataSet recRecordDs = this.getCalRecOrSedRecordDs(periodBeginDate, this.filter_enddate, true);
        DataSet sedRecordDs = this.getCalRecOrSedRecordDs(periodBeginDate, this.filter_enddate, false);
        this.calRecordDsf = recRecordDs.union(sedRecordDs).select("entityid, entryid, recorsed, rec_amount, sed_amount");
        calDs = calDs.union(recRecordDs.filter("date(year(bookdate),month(bookdate),day(bookdate)) <= " + this.getStrToDate(startDateLastTime)).removeFields(new String[]{"bookdate"}));
        calDs = calDs.union(sedRecordDs.filter("date(year(bookdate),month(bookdate),day(bookdate)) <= " + this.getStrToDate(startDateLastTime)).removeFields(new String[]{"bookdate"}));
        DataSet recAdjDs = null;
        boolean showRecSedTypeOrSpBills = this.showRecSedTypeOrSpBills();
        boolean showCostAdjBillRecSp = showRecSedTypeOrSpBills && this.recSpBills.contains("cal_costadjustbill");
        boolean bl = showCostStdDiffAdjBillRecSp = showRecSedTypeOrSpBills && this.recSpBills.contains("cal_stdcostdiffbill");
        if (!showRecSedTypeOrSpBills || showCostAdjBillRecSp || showCostStdDiffAdjBillRecSp) {
            recAdjDs = this.getCalRecOrSedAdjDs(periodBeginDate, this.filter_enddate, true, false);
            DataSet stdDiffAdjDs = this.getCalRecOrSedStdDiffAdjDs(periodBeginDate, this.filter_enddate, true, true);
            recAdjDs = recAdjDs.union(stdDiffAdjDs);
            calDs = calDs.union(recAdjDs.filter("date(year(bookdate),month(bookdate),day(bookdate)) <= " + this.getStrToDate(startDateLastTime)).removeFields(new String[]{"bookdate"}));
        }
        DataSet sedAdjDs = null;
        boolean showCostAdjBillSedSp = showRecSedTypeOrSpBills && this.sedSpBills.contains("cal_costadjustbill");
        boolean bl2 = showCostStdDiffAdjBillSedSp = showRecSedTypeOrSpBills && this.sedSpBills.contains("cal_stdcostdiffbill");
        if (!showRecSedTypeOrSpBills || showCostAdjBillSedSp || showCostStdDiffAdjBillSedSp) {
            sedAdjDs = this.getCalRecOrSedAdjDs(periodBeginDate, this.filter_enddate, false, false);
            DataSet stdDiffAdjDs = this.getCalRecOrSedStdDiffAdjDs(periodBeginDate, this.filter_enddate, false, true);
            if (recAdjDs != null) {
                recAdjDs = recAdjDs.union(stdDiffAdjDs);
            }
            calDs = calDs.union(sedAdjDs.filter("date(year(bookdate),month(bookdate),day(bookdate)) <= " + this.getStrToDate(startDateLastTime)).removeFields(new String[]{"bookdate"}));
        }
        ArrayList<String> fields = new ArrayList<String>(32);
        for (Field field : calDs.getRowMeta().getFields()) {
            String alia = field.getAlias();
            if (alia.equals("bgn_qty")) {
                alia = "bgn_qty + rec_qty - sed_qty as bgn_qty";
            } else if (alia.equals("bgn_amount")) {
                alia = "bgn_amount + rec_amount - sed_amount as bgn_amount";
            } else if (field.getDataType() instanceof BigDecimalType) {
                alia = "0 as " + alia;
            }
            fields.add(alia);
        }
        calDs = calDs.select(fields.toArray(new String[0]));
        Date startDateStartTime = StockCostGatherRptQueryPlugin.getPreDay(this.filter_startdate);
        calDs = calDs.union(recRecordDs.filter("date(year(bookdate),month(bookdate),day(bookdate)) > " + this.getStrToDate(startDateStartTime)).removeFields(new String[]{"bookdate"}));
        if (recAdjDs != null) {
            calDs = calDs.union(recAdjDs.filter("date(year(bookdate),month(bookdate),day(bookdate)) > " + this.getStrToDate(startDateStartTime)).removeFields(new String[]{"bookdate"}));
        }
        calDs = calDs.union(sedRecordDs.filter("date(year(bookdate),month(bookdate),day(bookdate)) > " + this.getStrToDate(startDateStartTime)).removeFields(new String[]{"bookdate"}));
        if (sedAdjDs != null) {
            calDs = calDs.union(sedAdjDs.filter("date(year(bookdate),month(bookdate),day(bookdate)) > " + this.getStrToDate(startDateStartTime)).removeFields(new String[]{"bookdate"}));
        }
        return calDs;
    }

    private static Date getPreDay(Date filter_startdate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(filter_startdate);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    private DataSet getCalGroupByDs(DataSet calDs, Set<String> cAdjSumFields) {
        ArrayList<String> endFields = new ArrayList<String>(32);
        DataSet calGroupbyDs = this.getCalGroupbyDs(calDs, cAdjSumFields);
        for (Field field : calGroupbyDs.getRowMeta().getFields()) {
            String alia = field.getAlias();
            if (alia.equals("end_qty")) {
                alia = "bgn_qty + rec_qty - sed_qty as end_qty";
            } else if (alia.equals("end_amount")) {
                alia = "bgn_amount + rec_amount - sed_amount as end_amount";
            }
            endFields.add(alia);
        }
        endFields.add("case when bgn_qty = 0 then 0 else bgn_amount/bgn_qty end as bgn_price");
        endFields.add("case when rec_qty = 0 then 0 else rec_amount/rec_qty end as rec_price");
        endFields.add("case when sed_qty = 0 then 0 else sed_amount/sed_qty end as sed_price");
        calDs = calGroupbyDs.select(endFields.toArray(new String[0]));
        calDs = calDs.addField("case when end_qty = 0 then 0 else end_amount/end_qty end", "end_price");
        return calDs;
    }

    private DataSet getInvDataSet() {
        if (this.notLoadBizBill()) {
            return null;
        }
        DataSet invBalDs = this.getInvBgnQtyDataSet();
        List<OrmInput> billsIO = this.getInvRecQtyDataSet();
        List<OrmInput> sedBillsIO = this.getInvSedQtyDataSet();
        billsIO.addAll(sedBillsIO);
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet allBillDs = algo.createDataSet((Input[])billsIO.toArray(new OrmInput[billsIO.size()]));
        String lessStartDatef = "date(year(bookdate),month(bookdate),day(bookdate)) <= " + this.getStrToDate(StockCostGatherRptQueryPlugin.getPreDay(this.filter_startdate));
        DataSet invBillsDs = allBillDs.filter(lessStartDatef).removeFields(new String[]{"bookdate"});
        invBalDs = invBalDs.union(invBillsDs);
        ArrayList<String> fields = new ArrayList<String>(32);
        for (Field field : invBalDs.getRowMeta().getFields()) {
            String alia = field.getAlias();
            if (alia.equals("bgn_qty")) {
                alia = "bgn_qty + rec_qty - sed_qty as bgn_qty";
            } else if (alia.equals("bgn2nd_qty")) {
                alia = "bgn2nd_qty + rec2nd_qty - sed2nd_qty as bgn2nd_qty";
            } else if (field.getDataType() instanceof BigDecimalType) {
                alia = "0 as " + alia;
            }
            fields.add(alia);
        }
        invBalDs = invBalDs.select(fields.toArray(new String[0]));
        Date dayStartTime = StockCostGatherRptQueryPlugin.getPreDay(this.filter_startdate);
        String largeStartTimef = "date(year(bookdate),month(bookdate),day(bookdate)) > " + this.getStrToDate(dayStartTime);
        String[] fieldNames = allBillDs.getRowMeta().getFieldNames();
        ArrayList<String> invFieldNames = new ArrayList<String>(Arrays.asList(fieldNames));
        invFieldNames.remove("rec_amount");
        invFieldNames.remove("sed_amount");
        fieldNames = invFieldNames.toArray(new String[0]);
        DataSet invBillRealDs = allBillDs.filter(largeStartTimef).join(this.calRecordDsf).on("entityid", "entityid").on("entryid", "entryid").on("recorsed", "recorsed").select(fieldNames, new String[]{"rec_amount", "sed_amount"}).finish().removeFields(new String[]{"bookdate"});
        invBalDs = invBalDs.union(invBillRealDs);
        return invBalDs;
    }

    private DataSet getInvGroupByDs(DataSet invBalDs, Set<String> tsSumFields) {
        if (invBalDs == null) {
            return null;
        }
        ArrayList<String> sumFields = new ArrayList<String>(Arrays.asList("bgn_qty", "bgn2nd_qty", "end_qty", "end2nd_qty", "rec_qty", "rec2nd_qty", "sed_qty", "sed2nd_qty"));
        sumFields.addAll(tsSumFields);
        List<String> groupDimf = this.getGroupDimf();
        GroupbyDataSet invGroupDs = invBalDs.groupBy(groupDimf.toArray(new String[0]));
        for (String item : sumFields) {
            invGroupDs = invGroupDs.sum(item);
        }
        invGroupDs = invGroupDs.max("unit2nd");
        ArrayList<String> endFields = new ArrayList<String>(32);
        DataSet invGroupFinishDs = invGroupDs.finish();
        for (Field field : invGroupFinishDs.getRowMeta().getFields()) {
            String alia = field.getAlias();
            if (alia.equals("end_qty")) {
                alia = "bgn_qty + rec_qty - sed_qty as end_qty";
            } else if (alia.equals("end2nd_qty")) {
                alia = "bgn2nd_qty + rec2nd_qty - sed2nd_qty as end2nd_qty";
            }
            endFields.add(alia);
        }
        invBalDs = invGroupFinishDs.select(endFields.toArray(new String[endFields.size()]));
        return invBalDs;
    }

    private List<OrmInput> getInvSedQtyDataSet() {
        ArrayList<OrmInput> billsIO = new ArrayList<OrmInput>(this.outCalBillRuleMap.size());
        RowMeta rowMeta = null;
        for (Map.Entry<String, List<CalBillRule>> item : this.outCalBillRuleMap.entrySet()) {
            for (CalBillRule outCalBillRule : item.getValue()) {
                StringBuilder sb = new StringBuilder();
                Map outCalBizFieldMap = outCalBillRule.getCalBizFieldMap();
                this.appendBizBillDim(outCalBizFieldMap, sb);
                String baseUnit = (String)outCalBizFieldMap.get("baseunit");
                sb.append(baseUnit.replace("baseunit", "unit2nd"));
                sb.append(" as unit2nd,");
                sb.append("0 as bgn_qty,0 as bgn2nd_qty,0 as end_qty, 0 as end2nd_qty,");
                sb.append("0 as rec_qty,0 as rec2nd_qty,");
                String baseQty = (String)outCalBizFieldMap.get("baseqty");
                sb.append(baseQty);
                sb.append(" as sed_qty,");
                sb.append(baseQty.replace("baseqty", "qtyunit2nd"));
                sb.append(" as sed2nd_qty,");
                sb.append("'");
                sb.append(item.getKey());
                sb.append("' as entityid,");
                String material = ((String)outCalBizFieldMap.get("material")).replace(".masterid", "");
                sb.append(material, 0, material.lastIndexOf("."));
                sb.append(" as entryid,");
                String invscheme = (String)outCalBizFieldMap.get("invscheme");
                invscheme = invscheme == null ? "' '" : "to_char(" + invscheme + ".transceivertype)";
                sb.append(invscheme);
                sb.append(" as tstype,'1' as recorsed,0 as rec_amount,0 as sed_amount,");
                String bizTimeField = (String)outCalBizFieldMap.get("bookdate");
                sb.append(bizTimeField);
                if (rowMeta == null) {
                    DataSet billRecDs = QueryServiceHelper.queryDataSet((String)(StockCostGatherRptQueryPlugin.class + "getInvRecQtyDataSet"), (String)item.getKey(), (String)sb.toString(), (QFilter[])new QFilter[]{QFilter.of((String)"1!=1", (Object[])new Object[0])}, null);
                    rowMeta = billRecDs.getRowMeta();
                }
                List<QFilter> filters = this.getInvBaseFilter(outCalBizFieldMap);
                filters.addAll(outCalBillRule.getBillFilters());
                if (item.getKey().contains("im_mdc_")) {
                    filters.add(new QFilter("billtype.billformid.number", "=", (Object)item.getKey()));
                }
                if (this.showRecSedTypeOrSpBills()) {
                    if (SPBILLS.contains(item.getKey())) {
                        if (!this.sedSpBills.contains(item.getKey())) {
                            continue;
                        }
                    } else {
                        QFilter recSedTypef = new QFilter("invscheme.transceivertype", "in", this.recSedTypes);
                        filters.add(recSedTypef);
                    }
                }
                filters.add(new QFilter("billstatus", "=", (Object)"C"));
                OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass().getName() + item.getKey(), item.getKey(), sb.toString(), filters.toArray(new QFilter[0]), rowMeta);
                billsIO.add(billIO);
            }
        }
        return billsIO;
    }

    private DataSet getInvBgnQtyDataSet() {
        ArrayList<QFilter> baseFilters = new ArrayList<QFilter>(16);
        String selectFields = this.getInvBalanceSelector();
        if (!this.isNewPeriodBal.booleanValue()) {
            QFilter filter = new QFilter("balancetype", "=", (Object)"2");
            baseFilters.add(filter);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.filter_startdate);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int period = year * 100 + month;
        QFilter periodf = new QFilter("period", "<", (Object)period);
        periodf.and(new QFilter("endperiod", ">=", (Object)period));
        this.addFormFilters(this.rptDimInvBalDimMap, baseFilters);
        baseFilters.add(periodf);
        String entityName = "im_invbalance";
        if (this.isNewPeriodBal.booleanValue()) {
            entityName = "im_cal_periodbalance";
        }
        DataSet invBalDs = QueryServiceHelper.queryDataSet((String)(StockCostGatherRptQueryPlugin.class + "getInvBalanceDataSet"), (String)entityName, (String)selectFields, (QFilter[])baseFilters.toArray(new QFilter[0]), null);
        return invBalDs;
    }

    private List<OrmInput> getInvRecQtyDataSet() {
        ArrayList<OrmInput> billsIO = new ArrayList<OrmInput>(this.inCalBillRuleMap.size());
        RowMeta rowMeta = null;
        for (Map.Entry<String, List<CalBillRule>> item : this.inCalBillRuleMap.entrySet()) {
            for (CalBillRule inCalBillRule : item.getValue()) {
                StringBuilder sb = new StringBuilder();
                Map inCalBizFieldMap = inCalBillRule.getCalBizFieldMap();
                this.appendBizBillDim(inCalBizFieldMap, sb);
                String baseUnit = (String)inCalBizFieldMap.get("baseunit");
                sb.append(baseUnit.replace("baseunit", "unit2nd"));
                sb.append(" as unit2nd,");
                sb.append("0 as bgn_qty,0 as bgn2nd_qty,0 as end_qty, 0 as end2nd_qty,");
                String baseQty = (String)inCalBizFieldMap.get("baseqty");
                sb.append(baseQty);
                sb.append(" as rec_qty,");
                sb.append(baseQty.replace("baseqty", "qtyunit2nd"));
                sb.append(" as rec2nd_qty,");
                sb.append("0 as sed_qty, 0 as sed2nd_qty,");
                sb.append("'");
                sb.append(item.getKey());
                sb.append("' as entityid,");
                String material = ((String)inCalBizFieldMap.get("material")).replace(".masterid", "");
                sb.append(material, 0, material.lastIndexOf("."));
                sb.append(" as entryid,");
                String invscheme = (String)inCalBizFieldMap.get("invscheme");
                invscheme = invscheme == null ? "' '" : "to_char(" + invscheme + ".transceivertype)";
                sb.append(invscheme);
                sb.append(" as tstype,'0' as recorsed,0 as rec_amount,0 as sed_amount,");
                String bizTimeField = (String)inCalBizFieldMap.get("bookdate");
                sb.append(bizTimeField);
                sb.append(" as bookdate");
                if (rowMeta == null) {
                    DataSet billRecDs = QueryServiceHelper.queryDataSet((String)(StockCostGatherRptQueryPlugin.class + "getInvRecQtyDataSet"), (String)item.getKey(), (String)sb.toString(), (QFilter[])new QFilter[]{QFilter.of((String)"1!=1", (Object[])new Object[0])}, null);
                    rowMeta = billRecDs.getRowMeta();
                    rowMeta.getField("sed2nd_qty").setDataType((DataType)DataType.BigDecimalType);
                    rowMeta.getField("sed_qty").setDataType((DataType)DataType.BigDecimalType);
                }
                List<QFilter> filters = this.getInvBaseFilter(inCalBizFieldMap);
                filters.addAll(inCalBillRule.getBillFilters());
                if (item.getKey().contains("im_mdc_")) {
                    filters.add(new QFilter("billtype.billformid.number", "=", (Object)item.getKey()));
                }
                if (this.showRecSedTypeOrSpBills()) {
                    if (SPBILLS.contains(item.getKey())) {
                        if (!this.recSpBills.contains(item.getKey())) {
                            continue;
                        }
                    } else {
                        QFilter recSedTypef = new QFilter("invscheme.transceivertype", "in", this.recSedTypes);
                        filters.add(recSedTypef);
                    }
                }
                filters.add(new QFilter("billstatus", "=", (Object)"C"));
                OrmInput billIO = new OrmInput(((Object)((Object)this)).getClass().getName() + item.getKey(), item.getKey(), sb.toString(), filters.toArray(new QFilter[0]), rowMeta);
                billsIO.add(billIO);
            }
        }
        return billsIO;
    }

    private String getInvBalanceSelector() {
        StringBuilder sb = new StringBuilder();
        for (String dim : this.rptDims) {
            if ("materialnum".equals(dim)) continue;
            if ("warehsgroup".equals(dim)) {
                sb.append(this.rptDimInvBalDimMap.get("warehs"));
                sb.append(".group as warehsgroup,");
                continue;
            }
            sb.append(this.rptDimInvBalDimMap.get(dim));
            sb.append(" as ");
            sb.append(dim);
            sb.append(",");
            if (!"material".equals(dim)) continue;
            sb.append(this.rptDimInvBalDimMap.get(dim));
            sb.append(".number as materialnum,");
        }
        sb.append("unit2nd,");
        if (this.isNewPeriodBal.booleanValue()) {
            sb.append("baseqty_bal as bgn_qty,qty2nd_bal as bgn2nd_qty,0 as end_qty, 0 as end2nd_qty,");
        } else {
            sb.append("endbaseqty as bgn_qty,endqty2nd as bgn2nd_qty,0 as end_qty, 0 as end2nd_qty,");
        }
        sb.append("0 as rec_qty,0 as rec2nd_qty,0 as sed_qty, 0 as sed2nd_qty,");
        sb.append("' ' as entityid,0 as entryid,' ' as tstype,' ' as recorsed,0 as rec_amount, 0 as sed_amount");
        return sb.toString();
    }

    private DataSet getCalGroupbyDs(DataSet calDs, Set<String> sumFields) {
        sumFields.addAll(Arrays.asList("bgn_qty", "bgn_amount", "end_qty", "end_amount", "rec_qty", "rec_amount", "sed_qty", "sed_amount"));
        List<String> groupDimf = this.getGroupDimf();
        groupDimf.add("currencyid");
        GroupbyDataSet calBgnGroupDs = calDs.groupBy(groupDimf.toArray(new String[0]));
        for (String item : sumFields) {
            calBgnGroupDs = calBgnGroupDs.sum(item);
        }
        return calBgnGroupDs.finish();
    }

    private List<String> getGroupDimf() {
        ArrayList<String> groups = new ArrayList<String>(Arrays.asList("material", "materialnum", "baseunit"));
        groups.addAll(this.groupTypes);
        if (!this.notShowMaterialGroup && !groups.contains("group")) {
            groups.add("group");
        }
        return groups;
    }

    private DynamicObject getYearPeriodByDate(Object costAccountId, Date date) {
        DynamicObject periodDyc = null;
        QFilter filter = new QFilter("id", "=", costAccountId);
        DynamicObject calAcctDyc = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy,calpolicy.periodtype", (QFilter[])new QFilter[]{filter});
        if (calAcctDyc != null) {
            QFilter beginDate = new QFilter("begindate", "<=", (Object)date);
            QFilter endDatef = new QFilter("enddate", ">=", (Object)date);
            QFilter periodTypef = new QFilter("periodtype", "=", (Object)calAcctDyc.getLong("calpolicy.periodtype"));
            QFilter notAdjPeriodf = new QFilter("isadjustperiod", "=", (Object)false);
            periodDyc = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter[]{beginDate, endDatef, periodTypef, notAdjPeriodf});
        }
        return periodDyc;
    }

    protected DataSet getCalRecOrSedRecordDs(Date startDate, Date endDate, boolean isRec) {
        ArrayList<QFilter> baseFilters = new ArrayList<QFilter>(16);
        String selectFields = this.getCalRecordSelector(isRec);
        QFilter filter = new QFilter("issplitcreate", "=", (Object)false);
        filter.and(new QFilter("isinitbill", "=", (Object)false));
        if (startDate != null) {
            filter.and(new QFilter("bookdate", ">=", (Object)startDate));
        }
        filter.and(new QFilter("bookdate", "<=", (Object)endDate));
        filter.and(new QFilter("calbilltype", "=", (Object)(isRec ? "IN" : "OUT")));
        filter.and(new QFilter("costaccount", "=", this.filter_costAccount.getPkValue()));
        if (this.notUpdBalBizTypes.size() > 0) {
            filter.and("biztype", "not in", this.notUpdBalBizTypes);
        }
        baseFilters.add(filter);
        this.addFormFilters(this.rptDimCalRecordDimMap, baseFilters);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        baseFilters.add(billStatusf);
        ArrayList<QFilter> spBillFilters = new ArrayList<QFilter>(16);
        if (this.showRecSedTypeOrSpBills()) {
            spBillFilters.addAll(baseFilters);
            if (isRec) {
                spBillFilters.add(new QFilter("bizentityobject.id", "in", this.recSpBills));
            } else {
                spBillFilters.add(new QFilter("bizentityobject.id", "in", this.sedSpBills));
            }
            QFilter recSedTypef = new QFilter("invscheme.transceivertype", "in", this.recSedTypes);
            recSedTypef.and(new QFilter("bizentityobject.id", "not in", SPBILLS));
            baseFilters.add(recSedTypef);
        }
        DataSet recRecordDs = QueryServiceHelper.queryDataSet((String)(StockCostGatherRptQueryPlugin.class + "getCalBalanceDataSet"), (String)"cal_costrecord", (String)selectFields, (QFilter[])baseFilters.toArray(new QFilter[0]), null);
        if (spBillFilters.size() > 0) {
            DataSet spBillDs = QueryServiceHelper.queryDataSet((String)(StockCostGatherRptQueryPlugin.class + "getCalBalanceDataSet"), (String)"cal_costrecord", (String)selectFields, (QFilter[])spBillFilters.toArray(new QFilter[0]), null);
            recRecordDs = recRecordDs.union(spBillDs);
        }
        return recRecordDs;
    }

    protected DataSet getCalRecOrSedAdjDs(Date startDate, Date endDate, boolean isRec, boolean iscostdiff) {
        ArrayList<QFilter> baseFilters = new ArrayList<QFilter>(16);
        String selectFields = this.getCalAdjSelector(isRec, iscostdiff);
        QFilter filter = new QFilter("biztype", "=", (Object)(isRec ? "A" : "B"));
        filter.and(new QFilter("billstatus", "=", (Object)BillStatus.C));
        filter.and(new QFilter("costaccount", "=", this.filter_costAccount.getPkValue()));
        if (this.invOrgIds.size() > 0) {
            filter.and(new QFilter("entryentity.storageorgunit", "in", this.invOrgIds));
        }
        QFilter standf = new QFilter("entryentity.accounttype", "=", (Object)"D");
        standf.and(new QFilter("difftype", "<>", (Object)"B"));
        standf.and(new QFilter("createtype", "<>", (Object)"C1"));
        QFilter notStandf = new QFilter("entryentity.accounttype", "<>", (Object)"D");
        notStandf.and(new QFilter("difftype", "=", (Object)"B"));
        filter.and(standf.or(notStandf));
        if (startDate != null) {
            filter.and(new QFilter("bookdate", ">=", (Object)startDate));
        }
        filter.and(new QFilter("bookdate", "<=", (Object)endDate));
        baseFilters.add(filter);
        this.addFormFilters(this.rptDimCalAdjDimMap, baseFilters);
        DataSet recRecordDs = QueryServiceHelper.queryDataSet((String)(StockCostGatherRptQueryPlugin.class + "getCalRecOrSedAdjDs"), (String)"cal_costadjustbill", (String)selectFields, (QFilter[])baseFilters.toArray(new QFilter[0]), null);
        return recRecordDs;
    }

    protected DataSet getCalRecOrSedStdDiffAdjDs(Date startDate, Date endDate, boolean isRec, boolean iscostdiff) {
        ArrayList<QFilter> baseFilters = new ArrayList<QFilter>(16);
        String selectFields = this.getCalAdjSelector(isRec, iscostdiff);
        QFilter filter = new QFilter("biztype", "=", (Object)(isRec ? "A" : "B"));
        filter.and(new QFilter("billstatus", "=", (Object)BillStatus.C));
        filter.and(new QFilter("costaccount", "=", this.filter_costAccount.getPkValue()));
        filter.and("isupdatecost", "=", (Object)"1");
        if (this.invOrgIds.size() > 0) {
            filter.and(new QFilter("entryentity.storageorgunit", "in", this.invOrgIds));
        }
        QFilter standf = new QFilter("entryentity.accounttype", "=", (Object)"D");
        standf.and(new QFilter("createtype", "<>", (Object)"C1"));
        QFilter notStandf = new QFilter("entryentity.accounttype", "<>", (Object)"D");
        filter.and(standf.or(notStandf));
        if (startDate != null) {
            filter.and(new QFilter("bookdate", ">=", (Object)startDate));
        }
        filter.and(new QFilter("bookdate", "<=", (Object)endDate));
        baseFilters.add(filter);
        this.addFormFilters(this.rptDimCalAdjDimMap, baseFilters);
        DataSet recRecordDs = QueryServiceHelper.queryDataSet((String)(StockCostGatherRptQueryPlugin.class + "getCalRecOrSedAdjDs"), (String)"cal_stdcostdiffbill", (String)selectFields, (QFilter[])baseFilters.toArray(new QFilter[0]), null);
        return recRecordDs;
    }

    private String getCalRecordSelector(boolean isRec) {
        StringBuilder sb = new StringBuilder();
        for (String dim : this.rptDims) {
            sb.append(this.rptDimCalRecordDimMap.get(dim));
            sb.append(" as ");
            sb.append(dim);
            sb.append(",");
        }
        String recOrsed = isRec ? "0" : "1";
        sb.append("bizentityobject.number as entityid,entry.bizbillentryid as entryid,' ' as tstype,'");
        sb.append(recOrsed);
        sb.append("' as recorsed,costaccount.calpolicy.currency as currencyid,");
        sb.append("0 as bgn_qty,0 as bgn_price, 0 as bgn_amount,");
        sb.append("0 as end_qty,0 as end_price, 0 as end_amount,");
        String select = isRec ? "entry.baseqty as rec_qty,0 as rec_price, case when entry.accounttype = 'D' then entry.standardcost else entry.actualcost end as rec_amount,0 as sed_qty,0 as sed_price, 0 as sed_amount" : "0 as rec_qty,0 as rec_price, 0 as rec_amount,entry.baseqty as sed_qty,0 as sed_price, case when entry.accounttype = 'D' then entry.standardcost else entry.actualcost end as sed_amount";
        sb.append(select);
        sb.append(",bookdate");
        return sb.toString();
    }

    private String getCalAdjSelector(boolean isRec, boolean iscostdiff) {
        String recOrsed;
        StringBuilder sb = new StringBuilder();
        for (String dim : this.rptDims) {
            sb.append(this.rptDimCalAdjDimMap.get(dim));
            sb.append(" as ");
            sb.append(dim);
            sb.append(",");
        }
        String string = recOrsed = isRec ? "0" : "1";
        if (iscostdiff) {
            sb.append("'cal_stdcostdiffbill' as entityid");
        } else {
            sb.append("'cal_costadjustbill' as entityid");
        }
        sb.append(",0 as entryid,' ' as tstype,'");
        sb.append(recOrsed);
        sb.append("' as recorsed,costaccount.calpolicy.currency as currencyid,");
        sb.append("0 as bgn_qty,0 as bgn_price, 0 as bgn_amount,");
        sb.append("0 as end_qty,0 as end_price, 0 as end_amount,");
        String select = isRec ? "0 as rec_qty,0 as rec_price, entryentity.adjustamt as rec_amount,0 as sed_qty,0 as sed_price, 0 as sed_amount" : "0 as rec_qty,0 as rec_price, 0 as rec_amount,0 as sed_qty,0 as sed_price, entryentity.adjustamt as sed_amount";
        sb.append(select);
        sb.append(",bookdate");
        return sb.toString();
    }

    private DataSet noShowZeroInOut(DataSet dataSet) {
        if (this.noShowZeroInOut) {
            return dataSet.filter("rec_qty <> 0 or rec_amount <> 0 or sed_qty <> 0 or sed_amount <> 0");
        }
        return dataSet;
    }

    private DataSet filterByQtyCondition(DataSet dataSet) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)this.qtyShowCondition)) {
            if ("A".equals(this.qtyShowCondition)) {
                return dataSet.filter("end_qty = 0");
            }
            if ("B".equals(this.qtyShowCondition)) {
                return dataSet.filter("end_qty <> 0");
            }
            if ("C".equals(this.qtyShowCondition)) {
                return dataSet.filter("end_qty > 0");
            }
            if ("D".equals(this.qtyShowCondition)) {
                return dataSet.filter("end_qty < 0");
            }
        }
        return dataSet;
    }

    private DataSet filterByAmountCondition(DataSet dataSet) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)this.amountShowCondition)) {
            if ("A".equals(this.amountShowCondition)) {
                return dataSet.filter("end_amount = 0");
            }
            if ("B".equals(this.amountShowCondition)) {
                return dataSet.filter("end_amount <> 0");
            }
            if ("C".equals(this.amountShowCondition)) {
                return dataSet.filter("end_amount > 0");
            }
            if ("D".equals(this.amountShowCondition)) {
                return dataSet.filter("end_amount < 0");
            }
        }
        return dataSet;
    }

    private String getBalSelectFields() {
        StringBuilder sb = new StringBuilder();
        for (String dim : this.rptDims) {
            if ("materialnum".equals(dim)) continue;
            if ("warehsgroup".equals(dim)) {
                sb.append(this.rptDimCalBalDimMap.get("warehs"));
                sb.append(".group as warehsgroup,");
            } else {
                sb.append(this.rptDimCalBalDimMap.get(dim));
                sb.append(" as ");
                sb.append(dim);
                sb.append(",");
            }
            if (!"material".equals(dim)) continue;
            sb.append(this.rptDimCalBalDimMap.get(dim));
            sb.append(".number as materialnum,");
        }
        sb.append("' ' as entityid,0 as entryid,' ' as tstype,' ' as recorsed,currency as currencyid,");
        sb.append("periodendqty as bgn_qty,0 as bgn_price, periodendactualcost as bgn_amount,");
        sb.append("0 as end_qty,0 as end_price, 0 as end_amount,");
        sb.append("0 as rec_qty,0 as rec_price, 0 as rec_amount,0 as sed_qty,0 as sed_price, 0 as sed_amount");
        return sb.toString();
    }

    private void appendCommonGroupCols() {
        if (this.hasGroup(this.groupType, "B")) {
            // empty if block
        }
        if (this.hasGroup(this.groupType, "C")) {
            this.groupTypes.add("owner");
        }
        if (this.hasGroup(this.groupType, "D")) {
            this.groupTypes.add("storageorg");
        }
        if (this.hasGroup(this.groupType, "E")) {
            if (!this.hasGroup(this.groupType, "D")) {
                this.groupTypes.add("storageorg");
            }
            this.groupTypes.add("warehs");
        }
        if (this.hasGroup(this.groupType, "F")) {
            if (!this.hasGroup(this.groupType, "D") && !this.hasGroup(this.groupType, "E")) {
                this.groupTypes.add("storageorg");
            }
            if (!this.hasGroup(this.groupType, "E")) {
                this.groupTypes.add("warehs");
            }
            this.groupTypes.add("location");
        }
        if (this.hasGroup(this.groupType, "G")) {
            this.groupTypes.add("lot");
        }
        if (this.hasGroup(this.groupType, "H")) {
            this.groupTypes.add("auxpty");
        }
        if (this.hasGroup(this.groupType, "I")) {
            this.groupTypes.add("project");
        }
        if (this.hasGroup(this.groupType, "M")) {
            this.groupTypes.add("tracknumber");
        }
        if (this.hasGroup(this.groupType, "J")) {
            this.groupTypes.add("warehsgroup");
        }
        if (this.hasGroup(this.groupType, "K")) {
            this.groupTypes.add("group");
        }
        if (this.hasGroup(this.groupType, "L")) {
            this.groupTypes.add("materialcategory");
        }
    }

    private boolean hasGroup(String groupType, String value) {
        return groupType.contains(value);
    }

    private void createDecimalColumn(List<AbstractReportColumn> cols, String name, String fieldKey) {
        LocaleString groupName = new LocaleString(name);
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey);
        cols.add((AbstractReportColumn)groupCol);
        boolean isCostAdj = fieldKey.contains("cal_costadjustbill");
        if (!isCostAdj) {
            ReportColumn qty = new ReportColumn();
            qty.setCaption(this.locale_qty);
            qty.setWidth(width);
            qty.setFieldKey(fieldKey + "_qty");
            qty.setFieldType("qty");
            qty.setMeasureUnitField("baseunit");
            groupCol.getChildren().add(qty);
            ReportColumn price = new ReportColumn();
            price.setCaption(this.locale_price);
            price.setWidth(width);
            price.setFieldKey(fieldKey + "_price");
            price.setFieldType("price");
            price.setCurrencyField("currencyid");
            groupCol.getChildren().add(price);
            if (this.displayqty2nd.booleanValue()) {
                ReportColumn qty2nd = new ReportColumn();
                qty2nd.setCaption(this.locale_assistqty);
                qty2nd.setWidth(width);
                qty2nd.setFieldKey(fieldKey + "2nd_qty");
                qty2nd.setFieldType("qty");
                qty2nd.setMeasureUnitField("unit2nd");
                qty2nd.setHide(isCostAdj);
                groupCol.getChildren().add(qty2nd);
                ReportColumn price2nd = new ReportColumn();
                price2nd.setCaption(this.locale_assistprice);
                price2nd.setWidth(width);
                price2nd.setFieldKey(fieldKey + "2nd_price");
                price2nd.setFieldType("price");
                price2nd.setCurrencyField("currencyid");
                price2nd.setHide(isCostAdj);
                groupCol.getChildren().add(price2nd);
            }
        }
        ReportColumn amount = new ReportColumn();
        amount.setCaption(this.locale_amount);
        amount.setWidth(width);
        amount.setFieldKey(fieldKey + "_amount");
        amount.setFieldType("amount");
        amount.setCurrencyField("currencyid");
        groupCol.getChildren().add(amount);
    }

    private String getStrToDate(Date date) {
        return "to_date('" + new SimpleDateFormat("yyyy-MM-dd").format(date) + "','yyyy-MM-dd')";
    }

    private DataSet addTransceiverColumn(DataSet dataSet, Set<String> tsSumFields) {
        String tsTypeOrSpBill;
        if (dataSet == null) {
            return null;
        }
        ArrayList<String> transceColumns = new ArrayList<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
        for (String column : this.recs.keySet()) {
            if (column.equals("cal_costadjustbill0")) continue;
            tsTypeOrSpBill = "case when  entityid + recorsed= '" + column + "' or '" + column + "'= tstype ";
            String recQty = "rec" + column + "_qty";
            transceColumns.add(tsTypeOrSpBill + "then rec_qty else 0 end as " + recQty);
            tsSumFields.add(recQty);
            String rec2ndQty = "rec" + column + "2nd_qty";
            transceColumns.add(tsTypeOrSpBill + "then rec2nd_qty else 0 end as " + rec2ndQty);
            tsSumFields.add(rec2ndQty);
            String recAmount = "rec" + column + "_amount";
            transceColumns.add(tsTypeOrSpBill + "then rec_amount else 0 end as " + recAmount);
            tsSumFields.add(recAmount);
        }
        for (String column : this.sends.keySet()) {
            if (column.equals("cal_costadjustbill1")) continue;
            tsTypeOrSpBill = "case when  entityid + recorsed= '" + column + "' or '" + column + "'= tstype ";
            String sedQty = "sed" + column + "_qty";
            transceColumns.add(tsTypeOrSpBill + " then sed_qty else 0 end as " + sedQty);
            tsSumFields.add(sedQty);
            String sed2ndQty = "sed" + column + "2nd_qty";
            transceColumns.add(tsTypeOrSpBill + "then sed2nd_qty else 0 end as " + sed2ndQty);
            tsSumFields.add(sed2ndQty);
            String sedAmount = "sed" + column + "_amount";
            transceColumns.add(tsTypeOrSpBill + "then sed_amount else 0 end as " + sedAmount);
            tsSumFields.add(sedAmount);
        }
        dataSet = dataSet.select(transceColumns.toArray(new String[0]));
        return dataSet;
    }

    private DataSet addCostTransciverColumn(DataSet dataSet, Set<String> tsSumFields) {
        ArrayList<String> transceColumns = new ArrayList<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
        if (this.recs.containsKey("cal_costadjustbill0")) {
            String recAmount = "reccal_costadjustbill0_amount";
            transceColumns.add("case when  entityid + recorsed= 'cal_costadjustbill0' then rec_amount else 0 end as " + recAmount);
            tsSumFields.add(recAmount);
        }
        if (this.sends.containsKey("cal_costadjustbill1")) {
            String sedAmount = "sedcal_costadjustbill1_amount";
            transceColumns.add("case when  entityid + recorsed= 'cal_costadjustbill1' then sed_amount else 0 end as " + sedAmount);
            tsSumFields.add(sedAmount);
        }
        dataSet = dataSet.select(transceColumns.toArray(new String[0]));
        return dataSet;
    }

    private DataSet addBaseMaterialGroup(DataSet dataSet, DataSet materialGroup) {
        if (dataSet == null) {
            return null;
        }
        return materialGroup == null ? dataSet : dataSet.join(materialGroup).on("material", "material").select(new String[]{"group", "materialtype"}, dataSet.getRowMeta().getFieldNames()).finish();
    }

    private void initRptDims() {
        this.rptDims.add("storageorg");
        this.rptDims.add("material");
        this.rptDims.add("materialnum");
        this.rptDims.add("baseunit");
        this.rptDims.add("warehs");
        this.rptDims.add("warehsgroup");
        this.rptDims.add("location");
        this.rptDims.add("ownertype");
        this.rptDims.add("owner");
        this.rptDims.add("invtype");
        this.rptDims.add("invstatus");
        this.rptDims.add("auxpty");
        this.rptDims.add("project");
        this.rptDims.add("tracknumber");
        this.rptDims.add("lot");
        this.rptDims.retainAll(this.getGroupDimf());
    }

    private void initCalBillRules() {
        if (this.notLoadBizBill()) {
            return;
        }
        this.initRptDimInvBalDimMap();
        this.initRptDimCalBillDimMap();
        CalBillRuleHelper calBillRuleHelper = new CalBillRuleHelper();
        calBillRuleHelper.loadAllRules();
        this.inCalBillRuleMap = calBillRuleHelper.getInCalBillRuleMap();
        this.outCalBillRuleMap = calBillRuleHelper.getOutCalBillRuleMap();
    }

    private boolean notLoadBizBill() {
        boolean notInvRecBills = this.recs.isEmpty() || this.recs.containsKey("cal_costadjustbill0") && this.recs.size() == 1;
        boolean notInvSedBills = this.sends.isEmpty() || this.sends.containsKey("cal_costadjustbill1") && this.sends.size() == 1;
        return this.displayqty2nd == false && notInvRecBills && notInvSedBills;
    }

    private void initRptDimCalBillDimMap() {
        this.rptDimCalBillDimMap.put("storageorg", "org");
        this.rptDimCalBillDimMap.put("material", "material");
        this.rptDimCalBillDimMap.put("baseunit", "baseunit");
        this.rptDimCalBillDimMap.put("warehs", "warehouse");
        this.rptDimCalBillDimMap.put("location", "location");
        this.rptDimCalBillDimMap.put("ownertype", "ownertype");
        this.rptDimCalBillDimMap.put("owner", "owner");
        this.rptDimCalBillDimMap.put("invtype", "invtype");
        this.rptDimCalBillDimMap.put("invstatus", "invstatus");
        this.rptDimCalBillDimMap.put("auxpty", "assistproperty");
        this.rptDimCalBillDimMap.put("project", "project");
        this.rptDimCalBillDimMap.put("tracknumber", "tracknumber");
        this.rptDimCalBillDimMap.put("lot", "lot");
    }

    private void appendBizBillDim(Map<String, String> calBillFieldBizBillFieldMap, StringBuilder sb) {
        for (String dim : this.rptDims) {
            if ("materialnum".equals(dim)) continue;
            if ("warehsgroup".equals(dim)) {
                sb.append(calBillFieldBizBillFieldMap.get("warehouse"));
                sb.append(".group as warehsgroup,");
                continue;
            }
            String key = this.rptDimCalBillDimMap.get(dim);
            String bizBillField = calBillFieldBizBillFieldMap.get(key);
            if (StringUtils.isEmpty((CharSequence)bizBillField)) {
                DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"cal_incalbill").getProperty(key);
                if (property instanceof BasedataProp) {
                    sb.append("0");
                } else if (property instanceof TextProp) {
                    sb.append("''");
                } else {
                    sb.append(bizBillField);
                }
            } else {
                sb.append(bizBillField);
            }
            sb.append(" as ");
            sb.append(dim);
            sb.append(",");
            if (!"material".equals(dim)) continue;
            sb.append(bizBillField);
            sb.append(".number as ematerialnum,");
        }
    }

    private List<QFilter> getInvBaseFilter(Map<String, String> calFieldBizFieldMap) {
        ArrayList<QFilter> baseFilters = new ArrayList<QFilter>(16);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.filter_startdate);
        calendar.set(5, 1);
        Date firstDayOfMonth = calendar.getTime();
        String bookDateField = calFieldBizFieldMap.get("bookdate");
        QFilter basef = new QFilter(bookDateField, "<=", (Object)this.filter_enddate);
        basef.and(new QFilter(bookDateField, ">=", (Object)DateUtils.getDayStartTime((Date)firstDayOfMonth)));
        String bizTypeField = calFieldBizFieldMap.get("biztype");
        if (this.notUpdBalBizTypes.size() > 0 && kd.bos.util.StringUtils.isNotEmpty((String)bizTypeField)) {
            basef.and(bizTypeField, "not in", this.notUpdBalBizTypes);
        }
        baseFilters.add(basef);
        String isInitBillField = calFieldBizFieldMap.get("isinitbill");
        if (StringUtils.isNotEmpty((CharSequence)isInitBillField)) {
            baseFilters.add(new QFilter(isInitBillField, "=", (Object)false));
        }
        HashMap<String, String> rptDimBizFieldMapCopy = new HashMap<String, String>(this.rptDimCalBillDimMap);
        for (Map.Entry entry : rptDimBizFieldMapCopy.entrySet()) {
            entry.setValue(calFieldBizFieldMap.get(entry.getValue()));
        }
        this.addFormFilters(rptDimBizFieldMapCopy, baseFilters);
        return baseFilters;
    }

    private void addFormFilters(Map<String, String> rptDimBillFieldMap, List<QFilter> baseFilters) {
        HashSet<Object> set;
        String ownerTypeField = rptDimBillFieldMap.get("ownertype");
        baseFilters.add(new QFilter(ownerTypeField, "=", (Object)"bos_org"));
        if (this.invOrgIds.size() > 0) {
            String orgField = rptDimBillFieldMap.get("storageorg");
            baseFilters.add(0, new QFilter(orgField, "in", this.invOrgIds));
        }
        String ownerField = rptDimBillFieldMap.get("owner");
        if (this.filter_owner != null) {
            HashSet<Object> set2 = new HashSet<Object>(this.filter_owner.size());
            for (Object info : this.filter_owner) {
                set2.add(info.getPkValue());
            }
            baseFilters.add(new QFilter(ownerField, "in", set2));
        } else {
            baseFilters.add(new QFilter(ownerField, "in", (Object)this.acctOwnerIds));
        }
        String warehouseField = rptDimBillFieldMap.get("warehs");
        if (!this.warehsGroupSet.isEmpty()) {
            baseFilters.add(new QFilter(warehouseField + ".group", "in", this.warehsGroupSet));
        }
        if (this.filter_warehouse != null) {
            set = new HashSet<Object>(this.filter_warehouse.size());
            for (Object info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            baseFilters.add(new QFilter(warehouseField, "in", set));
        }
        if (this.filter_location != null) {
            set = new HashSet(this.filter_location.size());
            for (Object info : this.filter_location) {
                set.add(info.getPkValue());
            }
            String locationField = rptDimBillFieldMap.get("location");
            baseFilters.add(new QFilter(locationField, "in", set));
        }
        String materialField = rptDimBillFieldMap.get("material");
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                baseFilters.add(new QFilter(materialField, "in", materialSet));
            } else if (this.filter_materialFrom.size() == 1) {
                baseFilters.add(new QFilter(materialField + ".number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number")));
            }
        }
        if (this.filter_materialTo != null) {
            baseFilters.add(new QFilter(materialField + ".number", "<=", (Object)this.filter_materialTo.getString("number")));
        }
        if (this.filter_mulMaterialCategory != null) {
            Set materialIds = this.materialCategoryHelper.getMaterialIds();
            baseFilters.add(new QFilter(materialField, "in", (Object)materialIds));
        }
        if (this.filter_assistProperty != null) {
            String auxptyField = rptDimBillFieldMap.get("auxpty");
            baseFilters.add(new QFilter(auxptyField, "=", this.filter_assistProperty.getPkValue()));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)this.filter_lot)) {
            String lotField = rptDimBillFieldMap.get("lot");
            baseFilters.add(new QFilter(lotField, "=", (Object)this.filter_lot));
        }
        if (this.filter_invType != null) {
            HashSet<Long> invTypeSet = new HashSet<Long>(this.filter_invType.size());
            for (DynamicObject invType : this.filter_invType) {
                invTypeSet.add(invType.getLong("id"));
            }
            String invTypeField = rptDimBillFieldMap.get("invtype");
            baseFilters.add(new QFilter(invTypeField, "in", invTypeSet));
        }
        if (this.filter_invStatus != null) {
            HashSet<Long> invStatusSet = new HashSet<Long>();
            for (DynamicObject invStatus : this.filter_invStatus) {
                invStatusSet.add(invStatus.getLong("id"));
            }
            String invStatusField = rptDimBillFieldMap.get("invstatus");
            baseFilters.add(new QFilter(invStatusField, "in", invStatusSet));
        }
        if (this.filter_project != null) {
            HashSet<Long> projectSet = new HashSet<Long>();
            for (DynamicObject project : this.filter_project) {
                projectSet.add(project.getLong("id"));
            }
            String projectField = rptDimBillFieldMap.get("project");
            baseFilters.add(new QFilter(projectField, "in", projectSet));
        }
        if (this.filter_trackNumber != null) {
            HashSet<Long> trackNumSet = new HashSet<Long>();
            for (DynamicObject trackNum : this.filter_trackNumber) {
                trackNumSet.add(trackNum.getLong("id"));
            }
            String trackNumField = rptDimBillFieldMap.get("tracknumber");
            baseFilters.add(new QFilter(trackNumField, "in", trackNumSet));
        }
    }

    private void initRptDimCalRecordDimMap() {
        this.rptDimCalRecordDimMap.put("storageorg", "storageorgunit");
        this.rptDimCalRecordDimMap.put("material", "entry.material");
        this.rptDimCalRecordDimMap.put("materialnum", "entry.material.number");
        this.rptDimCalRecordDimMap.put("baseunit", "entry.baseunit");
        this.rptDimCalRecordDimMap.put("warehs", "entry.warehouse");
        this.rptDimCalRecordDimMap.put("warehsgroup", "entry.warehouse.group");
        this.rptDimCalRecordDimMap.put("location", "entry.location");
        this.rptDimCalRecordDimMap.put("ownertype", "entry.ownertype");
        this.rptDimCalRecordDimMap.put("owner", "entry.owner");
        this.rptDimCalRecordDimMap.put("invtype", "entry.invtype");
        this.rptDimCalRecordDimMap.put("invstatus", "entry.invstatus");
        this.rptDimCalRecordDimMap.put("auxpty", "entry.assist");
        this.rptDimCalRecordDimMap.put("project", "entry.project");
        this.rptDimCalRecordDimMap.put("tracknumber", "entry.tracknumber");
        this.rptDimCalRecordDimMap.put("lot", "entry.lot");
    }

    private void initRptDimCalAdjDimMap() {
        this.rptDimCalAdjDimMap.put("storageorg", "entryentity.storageorgunit");
        this.rptDimCalAdjDimMap.put("material", "entryentity.material");
        this.rptDimCalAdjDimMap.put("materialnum", "entryentity.material.number");
        this.rptDimCalAdjDimMap.put("baseunit", "entryentity.baseunit");
        this.rptDimCalAdjDimMap.put("warehs", "entryentity.warehouse");
        this.rptDimCalAdjDimMap.put("warehsgroup", "entryentity.warehouse.group");
        this.rptDimCalAdjDimMap.put("location", "entryentity.location");
        this.rptDimCalAdjDimMap.put("ownertype", "entryentity.ownertype");
        this.rptDimCalAdjDimMap.put("owner", "entryentity.owner");
        this.rptDimCalAdjDimMap.put("invtype", "entryentity.invtype");
        this.rptDimCalAdjDimMap.put("invstatus", "entryentity.invstatus");
        this.rptDimCalAdjDimMap.put("auxpty", "entryentity.assist");
        this.rptDimCalAdjDimMap.put("project", "entryentity.project");
        this.rptDimCalAdjDimMap.put("tracknumber", "entryentity.tracknumber");
        this.rptDimCalAdjDimMap.put("lot", "entryentity.lot");
    }

    private void initRptDimCalBalDimMap() {
        this.rptDimCalBalDimMap.put("storageorg", "storageorgunit");
        this.rptDimCalBalDimMap.put("material", "material");
        this.rptDimCalBalDimMap.put("materialnum", "material.number");
        this.rptDimCalBalDimMap.put("baseunit", "baseunit");
        this.rptDimCalBalDimMap.put("warehs", "warehouse");
        this.rptDimCalBalDimMap.put("warehsgroup", "entryentity.warehouse.group");
        this.rptDimCalBalDimMap.put("location", "location");
        this.rptDimCalBalDimMap.put("ownertype", "ownertype");
        this.rptDimCalBalDimMap.put("owner", "owner");
        this.rptDimCalBalDimMap.put("invtype", "invtype");
        this.rptDimCalBalDimMap.put("invstatus", "invstatus");
        this.rptDimCalBalDimMap.put("auxpty", "assist");
        this.rptDimCalBalDimMap.put("project", "project");
        this.rptDimCalBalDimMap.put("tracknumber", "tracknumber");
        this.rptDimCalBalDimMap.put("lot", "lot");
    }

    private void initRptDimInvBalDimMap() {
        this.rptDimInvBalDimMap.put("storageorg", "org");
        this.rptDimInvBalDimMap.put("material", "material");
        this.rptDimInvBalDimMap.put("materialnum", "material.number");
        this.rptDimInvBalDimMap.put("baseunit", "baseunit");
        this.rptDimInvBalDimMap.put("warehs", "warehouse");
        this.rptDimInvBalDimMap.put("warehsgroup", "entryentity.warehouse.group");
        this.rptDimInvBalDimMap.put("location", "location");
        this.rptDimInvBalDimMap.put("ownertype", "ownertype");
        this.rptDimInvBalDimMap.put("owner", "owner");
        this.rptDimInvBalDimMap.put("invtype", "invtype");
        this.rptDimInvBalDimMap.put("invstatus", "invstatus");
        this.rptDimInvBalDimMap.put("auxpty", "auxpty");
        this.rptDimInvBalDimMap.put("project", "project");
        this.rptDimInvBalDimMap.put("tracknumber", "tracknumber");
        this.rptDimInvBalDimMap.put("lot", "lotnumber");
    }

    private boolean showRecSedTypeOrSpBills() {
        return this.recSedTypes.size() > 0 || this.recSpBills.size() > 0 || this.sedSpBills.size() > 0;
    }
}

