/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.queryplugin.StockDetailRptQueryPlugin;

public class StockDetailRptQueryNewPlugin {
    private static final Log logger = LogFactory.getLog(StockDetailRptQueryPlugin.class);
    static final int maxLimit = 100000;
    DynamicObject costAccountObject;
    DynamicObject startPeriodObject;
    DynamicObject endPeriodObject;
    int startPeriodValue;
    int endPeriodValue;
    Date beginDate;
    Date endDate;
    String ownerType;
    DynamicObjectCollection ownerFrom = null;
    DynamicObjectCollection calRange;
    DynamicObjectCollection storageOrgs;
    Set<Long> warehouseGroupIds;
    DynamicObjectCollection warehouses;
    DynamicObjectCollection locations;
    String[] lotIds;
    DynamicObjectCollection projects;
    DynamicObjectCollection invTypes;
    DynamicObjectCollection invStatuss;
    DynamicObjectCollection tracknumbers;
    String qtyShowCondition;
    String amountShowCondition;
    String orderType;
    String accountTypes;
    Set<String> accountTypeContainer;
    boolean onlyShowSumRow;
    boolean topSumRow;
    boolean showDetail;
    boolean showPartition;
    long currencyId;
    Map<Long, Long> materialIdAndUnitId;
    String materialIds;
    boolean printAll;
    private static String[] COSTRECORDPARAM = new String[]{"entry.material", "storageorgunit", "entry.warehouse", "entry.location", "entry.project", "entry.invtype", "entry.invstatus", "entry.warehouse.group", "entry.lot", "entry.calrange", "entry.accounttype", "entry.tracknumber"};
    private static String[] COSTADJUSTBILLPARAM = new String[]{"entryentity.material", "entryentity.storageorgunit", "entryentity.warehouse", "entryentity.location", "entryentity.project", "entryentity.invtype", "entryentity.invstatus", "entryentity.warehouse.group", "entryentity.lot", "entryentity.calrange", "entryentity.accounttype", "entryentity.tracknumber"};
    private static String[] BALANCEPARAM = new String[]{"material", "storageorgunit", "warehouse", "location", "project", "invtype", "invstatus", "warehouse.group", "lot", "calrange", "accounttype", "tracknumber"};
    private static String[] top_standardCostOne_TYPE_BizFirst_Print = new String[]{"currentMaterialId", "year", "period", "priorityOrder desc", "priorityOrder_first", "calbilltype", "bookdate", "audittime"};
    private static String[] top_standardCostOne_TYPE_BizFirst = new String[]{"year", "period", "currentMaterialId", "priorityOrder desc", "priorityOrder_first", "calbilltype", "bookdate", "audittime"};
    private static String[] top_standardCostOne_TYPE_AuditFirst_Print = new String[]{"currentMaterialId", "year", "period", "priorityOrder desc", "priorityOrder_first", "calbilltype", "audittime", "bookdate"};
    private static String[] top_standardCostOne_TYPE_AuditFirst = new String[]{"year", "period", "currentMaterialId", "priorityOrder desc", "priorityOrder_first", "calbilltype", "audittime", "bookdate"};
    private static String[] top_standardCost_BizFirst_Print = new String[]{"currentMaterialId", "year", "period", "priorityOrder desc", "priorityOrder_first", "bookdate", "audittime"};
    private static String[] top_standardCost_BizFirst = new String[]{"year", "period", "currentMaterialId", "priorityOrder desc", "priorityOrder_first", "bookdate", "audittime"};
    private static String[] top_standardCost_AuditFirst_Print = new String[]{"currentMaterialId", "year", "period", "priorityOrder desc", "priorityOrder_first", "audittime", "bookdate"};
    private static String[] top_standardCost_AuditFirst = new String[]{"year", "period", "currentMaterialId", "priorityOrder desc", "priorityOrder_first", "audittime", "bookdate"};
    private static String[] standardCostOne_TYPE_BizFirst_Print = new String[]{"currentMaterialId", "year", "period", "priorityOrder", "priorityOrder_first", "calbilltype", "bookdate", "audittime"};
    private static String[] standardCostOne_TYPE_BizFirst = new String[]{"year", "period", "currentMaterialId", "priorityOrder", "priorityOrder_first", "calbilltype", "bookdate", "audittime"};
    private static String[] standardCostOne_TYPE_AuditFirst_Print = new String[]{"currentMaterialId", "year", "period", "priorityOrder", "priorityOrder_first", "calbilltype", "audittime", "bookdate"};
    private static String[] standardCostOne_TYPE_AuditFirst = new String[]{"year", "period", "currentMaterialId", "priorityOrder", "priorityOrder_first", "calbilltype", "audittime", "bookdate"};
    private static String[] standardCost_BizFirst_Print = new String[]{"currentMaterialId", "year", "period", "priorityOrder", "priorityOrder_first", "bookdate", "audittime"};
    private static String[] standardCost_BizFirst = new String[]{"year", "period", "currentMaterialId", "priorityOrder", "priorityOrder_first", "bookdate", "audittime"};
    private static String[] standardCost_AuditFirst_Print = new String[]{"currentMaterialId", "year", "period", "priorityOrder", "priorityOrder_first", "audittime", "bookdate"};
    private static String[] standardCost_AuditFirst = new String[]{"year", "period", "currentMaterialId", "priorityOrder", "priorityOrder_first", "audittime", "bookdate"};
    private static String[] standardCost_TYPE_BizFirst_OneOrder = new String[]{"currentMaterialId", "year", "period", "priorityOrder_first", "calbilltype", "bookdate", "audittime"};
    private static String[] standardCost_TYPE_AuditFirst_OneOrder = new String[]{"currentMaterialId", "year", "period", "priorityOrder_first", "calbilltype", "audittime", "bookdate"};
    private static String[] standardCost_BizFirst_OneOrder = new String[]{"currentMaterialId", "year", "period", "priorityOrder_first", "bookdate", "audittime"};
    private static String[] standardCost_AuditFirst_OneOrder = new String[]{"currentMaterialId", "year", "period", "priorityOrder_first", "audittime", "bookdate"};
    private static String[] materialFields = new String[]{"head_materialnumber", "head_materialname", "head_baseunit", "head_model", "head_group", "head_precision"};
    private Set<Long> materialIdContainer = new HashSet<Long>(16);
    private List<Integer> periods = new ArrayList<Integer>(16);
    private boolean isNewBalance;

    public DataSet queryAll(ReportQueryParam param, Map<String, Object> selfDefinitionMap) {
        long jobStartTime = System.currentTimeMillis();
        this.getFilterParam(param, this.materialIdContainer, selfDefinitionMap);
        if (this.materialIdContainer.isEmpty()) {
            return this.getDefaultEmptyDataSet();
        }
        if (this.materialIds == null || this.materialIds.length() == 0) {
            return this.getDefaultEmptyDataSet();
        }
        if (this.materialIdAndUnitId.isEmpty()) {
            return this.getDefaultEmptyDataSet();
        }
        DataSet costDataSet = this.getDataSet(this.materialIdContainer, "cal_costrecord", this.getCostRecordSelects());
        long cur1 = System.currentTimeMillis();
        long job1 = cur1 - jobStartTime;
        logger.info("------------------job1----------------" + job1 + "-------------------------------------");
        DataSet adjustDataSet = this.getDataSet(this.materialIdContainer, "cal_costadjustbill", this.getCostAdjustSelects());
        DataSet stdDiff = this.getDataSet(this.materialIdContainer, "cal_stdcostdiffbill", this.getStdDiffSelects());
        adjustDataSet = adjustDataSet.union(stdDiff);
        long cur2 = System.currentTimeMillis();
        long job2 = cur2 - cur1;
        logger.info("------------------job2----------------" + job2 + "-------------------------------------");
        adjustDataSet = adjustDataSet.filter("periodinamount != 0 or periodoutamount != 0");
        DataSet costAndAdjust = costDataSet.union(adjustDataSet);
        long cur3 = System.currentTimeMillis();
        long job3 = cur3 - cur2;
        logger.info("------------------job3----------------" + job3 + "-------------------------------------");
        costAndAdjust = costAndAdjust.filter("periodinqty <> 0 or periodinamount <> 0 or periodoutqty <> 0 or periodoutamount <> 0");
        costAndAdjust = costAndAdjust.addField("1", "priorityOrder_first");
        DataSet[] balanceDataSetContainer = new DataSet[1];
        DataSet beginDataSet = this.getStartPeriod(this.materialIdContainer, this.periods, balanceDataSetContainer);
        long cur4 = System.currentTimeMillis();
        long job4 = cur4 - cur3;
        logger.info("------------------job4----------------" + job4 + "-------------------------------------");
        DataSet beginAndAdjustCost = costAndAdjust.union(beginDataSet);
        beginAndAdjustCost = beginAndAdjustCost.orderBy(this.getCalperiodEndOrderByField()).select((this.getTempSelects() + ",case when PreRowValue(currentMaterialId) = currentMaterialId and PreRowValue(year) = year and PreRowValue(period) = period then PreRowValue(periodendqty) + periodinqtybak - periodoutqty else periodinqtybak - periodoutqty end periodendqty,case when PreRowValue(currentMaterialId) = currentMaterialId and PreRowValue(year) = year and PreRowValue(period) = period then PreRowValue(periodendamount) + periodinamountbak - periodoutamount else periodinamountbak - periodoutamount end periodendamount,unitprice,billid,bizentityobject,currentMaterialId,priorityOrder_first").split(","));
        long cur5 = System.currentTimeMillis();
        long job5 = cur5 - cur4;
        logger.info("------------------job5----------------" + job5 + "-------------------------------------");
        DataSet startPeriodRest = beginAndAdjustCost;
        DataSet startAndYearAndPeriod = this.getTotalData(balanceDataSetContainer[0], startPeriodRest);
        long cur6 = System.currentTimeMillis();
        long job6 = cur6 - cur5;
        logger.info("------------------job6----------------" + job6 + "-------------------------------------");
        DataSet startAndYearAndPeriodOrCostAdjustSet = this.getDetailData(startAndYearAndPeriod);
        long cur7 = System.currentTimeMillis();
        long job7 = cur7 - cur6;
        logger.info("------------------job7----------------" + job7 + "-------------------------------------");
        QFilter filter = new QFilter("id", "in", this.materialIdContainer);
        String materialSelect = "id AS currentMateiralId,number AS head_materialnumber,name AS head_materialname,modelnum AS head_model,baseunit.name AS head_baseunit,group.name as head_group,baseunit.precision AS head_precision";
        DataSet materialInfos = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_material", (String)materialSelect, (QFilter[])filter.toArray(), null);
        DataSet startAndYearAndPeriodOrCostAdjustAndMaterial = startAndYearAndPeriodOrCostAdjustSet.leftJoin(materialInfos).on("currentMaterialId", "currentMateiralId").select(startAndYearAndPeriodOrCostAdjustSet.getRowMeta().getFieldNames(), materialFields).finish();
        DataSet finalResult = startAndYearAndPeriodOrCostAdjustAndMaterial.select(this.getFinalSelects().split(","));
        long cur8 = System.currentTimeMillis();
        long job8 = cur8 - cur7;
        logger.info("------------------job8----------------" + job8 + "-------------------------------------");
        ArrayList<Object[]> list = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Long> entry : this.materialIdAndUnitId.entrySet()) {
            list.add(new Object[]{entry.getKey(), entry.getValue()});
        }
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("currentMaterialId", (DataType)DataType.LongType), new Field("baseunitid", (DataType)DataType.StringType)});
        DataSet materialUnitDataSet = Algo.create((String)this.getClass().getName()).createDataSet(list.iterator(), rowMeta);
        long cur9 = System.currentTimeMillis();
        long job9 = cur9 - cur8;
        logger.info("------------------job9----------------" + job9 + "-------------------------------------");
        DataSet lastDataSet = finalResult.leftJoin(materialUnitDataSet).on("currentMaterialId", "currentMaterialId").select(finalResult.getRowMeta().getFieldNames(), new String[]{"baseunitid"}).finish();
        long cur10 = System.currentTimeMillis();
        long job10 = cur10 - cur9;
        logger.info("------------------job10----------------" + job10 + "-------------------------------------");
        lastDataSet = this.topSumRow(lastDataSet);
        if (this.onlyShowSumRow) {
            lastDataSet = lastDataSet.filter("priorityOrder <> 0");
        }
        long cur11 = System.currentTimeMillis();
        long job11 = cur11 - cur10;
        logger.info("------------------job11----------------" + job11 + "-----------------------------------------");
        long totalTime = System.currentTimeMillis() - jobStartTime;
        logger.info("------------------job12----------------" + totalTime + "-------------------------------------");
        String[] fieldNames = lastDataSet.getRowMeta().getFieldNames();
        StringBuilder sb = new StringBuilder();
        for (String fieldName : fieldNames) {
            if (!fieldName.equals("period")) {
                sb.append(fieldName).append(",");
                continue;
            }
            sb.append("case when priorityOrder = 2 then 0 else period end as period,");
        }
        String selectFields = sb.substring(0, sb.length() - 1);
        lastDataSet = lastDataSet.select(selectFields);
        return lastDataSet;
    }

    private DataSet getDataSet(Set<Long> materialIdContainer, String tableName, String selectFields) {
        if ("cal_balance".equals(tableName) || "cal_bal".equals(tableName)) {
            DataSet balanceSet = null;
            ArrayList<DataSet> list = new ArrayList<DataSet>(16);
            for (Integer period : this.periods) {
                DataSet result;
                if (this.isNewBalance) {
                    String dimFields = CalBalanceModelHelper.getDimFields((boolean)false) + ",year";
                    String[] groupSelectField = dimFields.split(",");
                    String newBalanceSelectField = dimFields + ",baseqty_bal as periodbeginqty,actualcost_bal as periodbeginactualcost";
                    QFilter q = this.commonFilter(tableName, materialIdContainer, period);
                    DataSet newBalanceSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)tableName, (String)newBalanceSelectField, (QFilter[])new QFilter[]{q}, null);
                    String balanceFields = "material as currentMaterialId,periodbeginqty,periodbeginactualcost,year";
                    result = newBalanceSet.groupBy(groupSelectField).max("periodbeginqty").sum("periodbeginactualcost").finish().select(balanceFields);
                } else {
                    QFilter q = this.commonFilter(tableName, materialIdContainer, period);
                    result = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)tableName, (String)selectFields, (QFilter[])new QFilter[]{q}, null);
                }
                result = result.addField(period / 100 + "", "year");
                result = result.addField(period % 100 + "", "month");
                if (balanceSet == null) {
                    balanceSet = result;
                    continue;
                }
                list.add(result);
            }
            DataSet[] rest = list.toArray(new DataSet[list.size()]);
            balanceSet = balanceSet == null ? this.getDefaultEmptyDataSet() : balanceSet;
            return rest.length == 0 ? balanceSet : balanceSet.union(rest);
        }
        QFilter qCost = this.commonFilter(tableName, materialIdContainer, null);
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)tableName, (String)selectFields, (QFilter[])new QFilter[]{qCost}, null);
    }

    public void getFilterParam(ReportQueryParam param, Set<Long> materialIdContainer, Map<String, Object> selfDefinitionMap) {
        String[] materialIdValues;
        FilterInfo filterInfo = param.getFilter();
        this.costAccountObject = filterInfo.getDynamicObject("costaccount");
        this.startPeriodObject = filterInfo.getDynamicObject("startperiod");
        this.endPeriodObject = filterInfo.getDynamicObject("endperiod");
        this.startPeriodValue = this.startPeriodObject.getInt("periodyear") * 100 + this.startPeriodObject.getInt("periodnumber");
        this.endPeriodValue = this.endPeriodObject.getInt("periodyear") * 100 + this.endPeriodObject.getInt("periodnumber");
        this.beginDate = this.startPeriodObject.getDate("begindate");
        this.endDate = this.endPeriodObject.getDate("enddate");
        this.ownerType = (String)filterInfo.getValue("ownertypehead");
        this.ownerFrom = null;
        switch (this.ownerType) {
            case "bos_org": {
                this.ownerFrom = filterInfo.getDynamicObjectCollection("mulowner");
                break;
            }
            case "bd_supplier": {
                this.ownerFrom = filterInfo.getDynamicObjectCollection("mulsupplierownerfrom");
                break;
            }
            case "bd_customer": {
                this.ownerFrom = filterInfo.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        this.calRange = filterInfo.getDynamicObjectCollection("mulcalrange");
        this.storageOrgs = filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehouseGroupIds = ReportUtil.getWarehsGroupSet((FilterInfo)filterInfo);
        this.warehouses = filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.locations = filterInfo.getDynamicObjectCollection("mullocation");
        this.lotIds = null;
        if (StringUtils.isNotEmpty((String)filterInfo.getString("lotnumber"))) {
            this.lotIds = filterInfo.getString("lotnumber").split(";");
        }
        this.projects = filterInfo.getDynamicObjectCollection("mulproject");
        this.invTypes = filterInfo.getDynamicObjectCollection("mulinvtype");
        this.invStatuss = filterInfo.getDynamicObjectCollection("mulinvstatus");
        this.tracknumbers = filterInfo.getDynamicObjectCollection("multracknum");
        this.qtyShowCondition = filterInfo.getString("qtyshowcondition");
        this.amountShowCondition = filterInfo.getString("amountshowcondition");
        this.orderType = filterInfo.getString("ordertype");
        this.accountTypes = filterInfo.getString("mulaccounttype");
        this.accountTypeContainer = new HashSet<String>(16);
        if (this.accountTypes != null && this.accountTypes.length() != 0) {
            String[] accountTypeValues;
            for (String accountType : accountTypeValues = this.accountTypes.split(",")) {
                this.accountTypeContainer.add(accountType);
            }
        }
        this.onlyShowSumRow = filterInfo.getBoolean("onlyshowsumrow");
        this.topSumRow = filterInfo.getBoolean("topsumrow");
        this.showDetail = filterInfo.getBoolean("showdetail");
        this.showPartition = filterInfo.getBoolean("showpartition");
        DynamicObject calPolicy = BusinessDataServiceHelper.loadSingleFromCache((Object)this.costAccountObject.getDynamicObject("calpolicy").getPkValue(), (String)"cal_bd_calpolicy");
        this.showDetail = this.showDetail && calPolicy.getBoolean("calbycostelement");
        boolean bl = this.printAll = selfDefinitionMap.get("self_use_multi") == null || !this.showPartition ? false : "useMulti".equals(selfDefinitionMap.get("self_use_multi"));
        this.materialIds = this.printAll ? (String)selfDefinitionMap.get("materialIds") : (!this.showPartition ? (filterInfo.getFilterItem("materialIds") == null ? null : filterInfo.getFilterItem("materialIds").getString()) : null);
        if (this.materialIds == null || this.materialIds.length() == 0) {
            return;
        }
        for (String materialId : materialIdValues = this.materialIds.split(",")) {
            Long materialIdValue = Long.valueOf(materialId);
            if (materialIdValue == 0L) continue;
            materialIdContainer.add(materialIdValue);
        }
        this.materialIdAndUnitId = new HashMap<Long, Long>(16);
        try (DataSet idAndUnitIdObject = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_material", (String)"id,baseunit.id", (QFilter[])new QFilter("id", "in", materialIdContainer).toArray(), null);){
            for (Row row : idAndUnitIdObject) {
                Long id = row.getLong("id");
                Long unitId = row.getLong("baseunit.id");
                if (this.materialIdAndUnitId.containsKey(id)) continue;
                this.materialIdAndUnitId.put(id, unitId);
            }
        }
        this.currencyId = filterInfo.getDynamicObject("localcurrency").getLong("id");
        this.isNewBalance = CalBalanceModelHelper.isNewBalance();
        DynamicObjectCollection costacconts = new DynamicObjectCollection();
        costacconts.add((Object)this.costAccountObject);
    }

    public QFilter commonFilter(String tableName, Set<Long> materialIdContainer, Integer periodNumber) {
        QFilter q = new QFilter("costaccount", "=", this.costAccountObject.getPkValue());
        String[] commonParamName = null;
        switch (tableName) {
            case "cal_costrecord": {
                q.and("bookdate", ">=", (Object)this.beginDate);
                q.and("bookdate", "<=", (Object)this.endDate);
                q.and("issplitcreate", "=", (Object)false);
                q.and("isinitbill", "=", (Object)false);
                q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
                q.and("billstatus", "=", (Object)"C");
                ReportUtil.getOwnerFilter((QFilter)q, (String)this.ownerType, (DynamicObjectCollection)this.ownerFrom, (String)"cal_costrecord");
                commonParamName = COSTRECORDPARAM;
                break;
            }
            case "cal_costadjustbill": {
                q.and("bookdate", ">=", (Object)this.beginDate);
                q.and("bookdate", "<=", (Object)this.endDate);
                q.and("billstatus", "=", (Object)"C");
                q.and("isupdatecost", "=", (Object)"1");
                q.and("entryentity.accounttype", "<>", (Object)AccountTypeEnum.STANDARDCOST.getValue());
                ReportUtil.getOwnerFilter((QFilter)q, (String)this.ownerType, (DynamicObjectCollection)this.ownerFrom, (String)"cal_costadjustbill");
                commonParamName = COSTADJUSTBILLPARAM;
                break;
            }
            case "cal_stdcostdiffbill": {
                q.and("bookdate", ">=", (Object)this.beginDate);
                q.and("bookdate", "<=", (Object)this.endDate);
                q.and("billstatus", "=", (Object)"C");
                q.and("isupdatecost", "=", (Object)"1");
                ReportUtil.getOwnerFilter((QFilter)q, (String)this.ownerType, (DynamicObjectCollection)this.ownerFrom, (String)"cal_costadjustbill");
                commonParamName = COSTADJUSTBILLPARAM;
                break;
            }
            case "cal_balance": {
                q.and("period", "<", (Object)periodNumber);
                q.and("endperiod", ">=", (Object)periodNumber);
                ReportUtil.getOwnerFilter((QFilter)q, (String)this.ownerType, (DynamicObjectCollection)this.ownerFrom, (String)"cal_balance");
                commonParamName = BALANCEPARAM;
                break;
            }
            case "cal_bal": {
                q.and("period", "<", (Object)periodNumber);
                q.and("endperiod", ">=", (Object)periodNumber);
                ReportUtil.getOwnerFilter((QFilter)q, (String)this.ownerType, (DynamicObjectCollection)this.ownerFrom, (String)"cal_bal");
                commonParamName = BALANCEPARAM;
                break;
            }
            case "cal_initbill": {
                q.and("period.periodyear", ">=", (Object)(this.startPeriodValue / 100));
                q.and("period.periodyear", "<=", (Object)(this.endPeriodValue / 100));
                q.and("entryentity.material", "in", materialIdContainer);
                ReportUtil.getOwnerFilter((QFilter)q, (String)this.ownerType, (DynamicObjectCollection)this.ownerFrom, (String)"cal_costadjustbill");
                commonParamName = COSTADJUSTBILLPARAM;
                break;
            }
            default: {
                q.and("1", "<>", (Object)"1");
            }
        }
        if (commonParamName == null || commonParamName.length == 0) {
            return q;
        }
        q.and((String)commonParamName[0], "in", materialIdContainer);
        q = this.setIds(this.storageOrgs, q, commonParamName[1]);
        q = this.setIds(this.warehouses, q, commonParamName[2]);
        q = this.setIds(this.locations, q, commonParamName[3]);
        q = this.setIds(this.projects, q, commonParamName[4]);
        q = this.setIds(this.invTypes, q, commonParamName[5]);
        q = this.setIds(this.invStatuss, q, commonParamName[6]);
        q = this.warehouseGroupIds != null && this.warehouseGroupIds.size() != 0 ? q.and(commonParamName[7], "in", this.warehouseGroupIds) : q;
        q = this.lotIds != null && this.lotIds.length != 0 ? q.and(commonParamName[8], "in", (Object)this.lotIds) : q;
        q = this.setIds(this.calRange, q, commonParamName[9]);
        q = this.accountTypeContainer != null && this.accountTypeContainer.size() != 0 ? q.and(commonParamName[10], "in", this.accountTypeContainer) : q;
        q = this.setTracknumberIds(this.tracknumbers, q, commonParamName[11]);
        return q;
    }

    private QFilter setTracknumberIds(DynamicObjectCollection tracknumbers, QFilter q, String multiParamIdName) {
        HashSet<Object> idContainer = new HashSet<Object>(16);
        if (tracknumbers != null && tracknumbers.size() != 0) {
            for (DynamicObject tracknumber : tracknumbers) {
                idContainer.add(tracknumber.getPkValue());
            }
            q = tracknumbers != null ? q.and(multiParamIdName, "in", idContainer) : q;
        }
        return q;
    }

    private DataSet getStartPeriod(Set<Long> materialIdContainer, List<Integer> periods, DataSet[] container) {
        DynamicObject costAccountInfo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", this.costAccountObject.get("id"))});
        QFilter qBegin = new QFilter("periodyear*100+periodnumber", ">=", (Object)this.startPeriodValue);
        qBegin.and("periodyear*100+periodnumber", "<=", (Object)this.endPeriodValue);
        qBegin.and("periodtype", "=", costAccountInfo.get("calpolicy.periodtype"));
        qBegin.and("isadjustperiod", "=", (Object)false);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{qBegin}, (String)"periodyear asc,periodnumber asc");
        for (DynamicObject info : coll) {
            if (periods.contains(info.getInt("periodyear") * 100 + info.getInt("periodnumber"))) continue;
            periods.add(info.getInt("periodyear") * 100 + info.getInt("periodnumber"));
        }
        if (periods.isEmpty()) {
            return this.getDefaultEmptyDataSet();
        }
        String beginSelect = "material as currentMaterialId,periodendqty as periodbeginqty,periodendactualcost as periodbeginactualcost,yearinqty,yearinactualcost,yearissueqty,yearissueactualcost";
        container[0] = this.getDataSet(materialIdContainer, this.isNewBalance ? "cal_bal" : "cal_balance", beginSelect);
        DataSet balanceSet = container[0].copy().groupBy(new String[]{"currentMaterialId", "year", "month"}).sum("periodbeginqty").sum("periodbeginactualcost").finish();
        DataSet beginDataSet = null;
        DataSet singleDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance", (String)"id", null, null, (int)1);
        ArrayList<DataSet> rest = new ArrayList<DataSet>(16);
        for (Long currentMaterialId : materialIdContainer) {
            for (int j = 0; j < periods.size(); ++j) {
                int periodNumber = periods.get(j);
                int year = periodNumber / 100;
                int month = periodNumber % 100;
                DataSet dataSet = singleDataSet.copy().select(new String[]{year + " as year", month + " as month", "0 as periodbeginqty", "0 as periodbeginactualcost", currentMaterialId + " as currentMaterialId"});
                if (beginDataSet == null) {
                    beginDataSet = dataSet;
                    continue;
                }
                rest.add(dataSet);
            }
        }
        DataSet[] restSet = rest.toArray(new DataSet[rest.size()]);
        if (beginDataSet == null) {
            return this.getDefaultEmptyDataSet();
        }
        DataSet dataSet = beginDataSet = restSet != null && restSet.length != 0 ? beginDataSet.union(restSet) : beginDataSet;
        if (beginDataSet != null) {
            beginDataSet = beginDataSet.join(balanceSet, JoinType.LEFT).on("year", "year").on("month", "month").on("currentMaterialId", "currentMaterialId").select(new String[]{"year", "month", "currentMaterialId"}, new String[]{"periodbeginqty", "periodbeginactualcost"}).finish();
            beginDataSet = beginDataSet.select(this.getPeriodBeginFinalSelects().split(","));
        } else {
            beginDataSet = balanceSet.select(this.getPeriodBeginFinalSelects().split(","));
        }
        beginDataSet = beginDataSet.addField("0", "priorityOrder_first");
        return beginDataSet;
    }

    private DataSet getPeriodTotal(DataSet startPeriodRest) {
        DataSet periodTotalDataSet = startPeriodRest.copy().groupBy(new String[]{"currentMaterialId", "year", "period"}).sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").minP("priorityOrder_first", "periodendqty").minP("priorityOrder_first", "periodendamount").finish().select(new String[]{"currentMaterialId", "year", "period", "periodinqty", "periodinamount", "periodoutqty", "periodoutamount", "periodendqty+periodinqty-periodoutqty as periodendqty", "periodendamount+periodinamount-periodoutamount as periodendamount"}).select(this.getPeriodTotalFinalSelects().split(","));
        periodTotalDataSet = this.filterByQtyCondition(periodTotalDataSet);
        periodTotalDataSet = this.filterByAmountCondition(periodTotalDataSet);
        return periodTotalDataSet;
    }

    private DataSet getTotalData(DataSet rows, DataSet startPeriodRest) {
        DataSet periodTotalDataSet = this.getPeriodTotal(startPeriodRest);
        String validPeriod = null;
        StringBuilder sb = new StringBuilder(16);
        for (Row row : periodTotalDataSet.copy()) {
            int year = row.getInteger("year");
            int period = row.getInteger("period");
            int periodNumber = year * 100 + period;
            sb.append(periodNumber).append(",");
        }
        validPeriod = sb.toString();
        if (!StringUtils.isEmpty((String)validPeriod)) {
            validPeriod = validPeriod.substring(0, validPeriod.length() - 1);
            startPeriodRest = startPeriodRest.filter("year*100+period in (" + validPeriod + ")");
        } else {
            startPeriodRest = startPeriodRest.filter("1 <> 1");
        }
        DataSet yearInOutDataSet = null;
        if (this.isNewBalance) {
            String yearInfoSelectFields = "period.periodyear as year,entryentity.material as currentMaterialId,entryentity.yearinqty as yearinqty,entryentity.yearincost + entryentity.yearincostdiff as yearinactualcost,entryentity.yearissueqty as yearissueqty,entryentity.yearissuecost + entryentity.yearissuecostdiff as yearissueactualcost";
            QFilter q = this.commonFilter("cal_initbill", this.materialIdContainer, null);
            yearInOutDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_initbill", (String)yearInfoSelectFields, (QFilter[])new QFilter[]{q}, null).groupBy(new String[]{"currentMaterialId", "year"}).sum("yearinqty").sum("yearinactualcost").sum("yearissueqty").sum("yearissueactualcost").finish();
        } else {
            yearInOutDataSet = rows.groupBy(new String[]{"currentMaterialId", "year"}).sum("yearinqty").sum("yearinactualcost").sum("yearissueqty").sum("yearissueactualcost").finish();
        }
        DataSet yearTotalDataSet = periodTotalDataSet.copy().groupBy(new String[]{"currentMaterialId", "year"}).sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").max("period").finish();
        yearTotalDataSet = yearTotalDataSet.join(yearInOutDataSet, JoinType.LEFT).on("year", "year").on("currentMaterialId", "currentMaterialId").select(new String[]{"currentMaterialId", "year", "period", "0 as periodendqty", "0 as periodendamount", "periodinqty+yearinqty as periodinqty", "periodinamount+yearinactualcost as periodinamount", "periodoutqty+yearissueqty as periodoutqty", "periodoutamount+yearissueactualcost as periodoutamount"}).finish().select(this.getYearTotalFinalSelects().split(","));
        return startPeriodRest.addField("0", "priorityOrder").union(periodTotalDataSet.addField("1", "priorityOrder").addField("1", "priorityOrder_first")).union(yearTotalDataSet.addField("1", "priorityOrder").addField("2", "priorityOrder_first"));
    }

    private DataSet getDetailData(DataSet startAndYearAndPeriod) {
        if (this.showDetail && !this.onlyShowSumRow) {
            DataSet tempDataSet = startAndYearAndPeriod.copy();
            HashSet<Object> costAdjustEntryIds = new HashSet<Object>(16);
            for (Row row : tempDataSet) {
                Object entryId = row.get("entryid");
                String srcObject = row.getString("srcObject");
                if (!"costadjustbill".equals(srcObject) || entryId == null) continue;
                costAdjustEntryIds.add(entryId);
            }
            DataSet costRecordDetailDataSet = this.groupQuery(costAdjustEntryIds, "cal_costrecord_detail", this.getCostRecordDetailSelects());
            DataSet adjustDetailDataSet = this.groupQuery(costAdjustEntryIds, "cal_costadjust_detail", this.getCostAdjustDetailSelects());
            DataSet costRecordAndAdjustDetail = costRecordDetailDataSet.union(adjustDetailDataSet);
            DataSet detailDataSet = startAndYearAndPeriod.copy().join(costRecordAndAdjustDetail, JoinType.LEFT).on("entryid", "entryid").on("srcobject", "srcobject").select(this.getLeftSelects(), this.getRightSelects()).finish().select(this.getDetailSelects());
            detailDataSet = detailDataSet.addField("2", "priorityOrder").addField("0", "priorityOrder_first");
            startAndYearAndPeriod = startAndYearAndPeriod.where("priorityOrder = 0 and priorityOrder_first = 1").addNullField("costelementnumber").addField(ResManager.loadKDString((String)"'\u5c0f\u8ba1'", (String)"StockDetailRptQueryPlugin_12", (String)"fi-cal-report", (Object[])new Object[0]), "costelementname").addNullField("costsubelementnumber").addNullField("costsubelementname").union(detailDataSet);
        }
        return startAndYearAndPeriod;
    }

    public DataSet groupQuery(Set<Object> ids, String tableName, String costRecordSelect) {
        if (ids == null || ids.size() == 0) {
            return this.getDefaultEmptyDetail(costRecordSelect, tableName);
        }
        ArrayList<Object> listIds = new ArrayList<Object>(ids);
        List belowLimitIds = Lists.partition(listIds, (int)100000);
        ArrayList<DataSet> rest = new ArrayList<DataSet>(16);
        DataSet dataSet = null;
        for (List belowLimitAdjustId : belowLimitIds) {
            QFilter qFilter = new QFilter("entryid", "in", (Object)belowLimitAdjustId);
            DataSet currentCostDetail = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)tableName, (String)costRecordSelect, (QFilter[])new QFilter[]{qFilter}, null);
            if (dataSet == null) {
                dataSet = currentCostDetail;
                continue;
            }
            rest.add(currentCostDetail);
        }
        DataSet[] dataSets = rest.toArray(new DataSet[rest.size()]);
        if (dataSet == null) {
            return this.getDefaultEmptyDetail(costRecordSelect, tableName);
        }
        return dataSet != null && dataSets.length != 0 ? dataSet.union(dataSets) : dataSet;
    }

    private String getEndPriceSelect(String amount, String qty) {
        return "case when  " + qty + " = 0 then 0 else " + amount + "/" + qty + " end ";
    }

    private String getPriceSelect(String amount, String qty) {
        return "case when unitprice <> 0  and " + qty + " <> 0 then unitprice when " + qty + " = 0 then 0 else " + amount + "/" + qty + " end ";
    }

    private DataSet topSumRow(DataSet dataSet) {
        if (this.topSumRow) {
            if (this.accountTypeContainer.size() == 1 && this.accountTypeContainer.contains("D")) {
                if ("A".equals(this.orderType)) {
                    logger.info("------------------" + this.orderType + "--bookdate-audittime");
                    logger.info("------------------" + this.printAll + "----------printAll---");
                    String[] orderFields = this.printAll ? top_standardCostOne_TYPE_BizFirst_Print : top_standardCostOne_TYPE_BizFirst;
                    return dataSet.orderBy(orderFields);
                }
                logger.info("------------------" + this.orderType + "--audittime-bookdate");
                logger.info("------------------" + this.printAll + "----------printAll---");
                String[] orderFields = this.printAll ? top_standardCostOne_TYPE_AuditFirst_Print : top_standardCostOne_TYPE_AuditFirst;
                return dataSet.orderBy(orderFields);
            }
            if ("A".equals(this.orderType)) {
                logger.info("------------------" + this.orderType + "--bookdate-audittime");
                logger.info("------------------" + this.printAll + "----------printAll---");
                String[] orderFields = this.printAll ? top_standardCost_BizFirst_Print : top_standardCost_BizFirst;
                return dataSet.orderBy(orderFields);
            }
            logger.info("------------------" + this.orderType + "--audittime-bookdate");
            logger.info("------------------" + this.printAll + "----------printAll---");
            String[] orderFields = this.printAll ? top_standardCost_AuditFirst_Print : top_standardCost_AuditFirst;
            return dataSet.orderBy(orderFields);
        }
        if (this.accountTypeContainer.size() == 1 && this.accountTypeContainer.contains("D")) {
            if ("A".equals(this.orderType)) {
                logger.info("------------------" + this.orderType + "--bookdate-audittime");
                logger.info("------------------" + this.printAll + "----------printAll---");
                String[] orderFields = this.printAll ? standardCostOne_TYPE_BizFirst_Print : standardCostOne_TYPE_BizFirst;
                return dataSet.orderBy(orderFields);
            }
            logger.info("------------------" + this.orderType + "--audittime-bookdate");
            logger.info("------------------" + this.printAll + "----------printAll---");
            String[] orderFields = this.printAll ? standardCostOne_TYPE_AuditFirst_Print : standardCostOne_TYPE_AuditFirst;
            return dataSet.orderBy(orderFields);
        }
        if ("A".equals(this.orderType)) {
            logger.info("------------------" + this.orderType + "--bookdate-audittime");
            logger.info("------------------" + this.printAll + "----------printAll---");
            String[] orderFields = this.printAll ? standardCost_BizFirst_Print : standardCost_BizFirst;
            return dataSet.orderBy(orderFields);
        }
        logger.info("------------------" + this.orderType + "--audittime-bookdate");
        logger.info("------------------" + this.printAll + "----------printAll---");
        String[] orderFields = this.printAll ? standardCost_AuditFirst_Print : standardCost_AuditFirst;
        return dataSet.orderBy(orderFields);
    }

    private DataSet getDefaultEmptyDetail(String costRecordSelect, String tableName) {
        QFilter qFilter = QFilter.of((String)"1<>1", (Object[])new Object[0]);
        DataSet costRecordDetailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)tableName, (String)costRecordSelect, (QFilter[])new QFilter[]{qFilter}, null);
        return costRecordDetailDataSet;
    }

    private DataSet filterByAmountCondition(DataSet periodTotalDataSet) {
        if (StringUtils.isNotEmpty((String)this.amountShowCondition)) {
            String sign = "";
            if ("A".equals(this.amountShowCondition)) {
                sign = "=";
            } else if ("B".equals(this.amountShowCondition)) {
                sign = "<>";
            } else if ("C".equals(this.amountShowCondition)) {
                sign = ">";
            } else if ("D".equals(this.amountShowCondition)) {
                sign = "<";
            }
            return periodTotalDataSet.filter("periodendamount " + sign + " 0");
        }
        return periodTotalDataSet;
    }

    private DataSet filterByQtyCondition(DataSet periodTotalDataSet) {
        if (StringUtils.isNotEmpty((String)this.qtyShowCondition)) {
            String sign = "";
            if ("A".equals(this.qtyShowCondition)) {
                sign = "=";
            } else if ("B".equals(this.qtyShowCondition)) {
                sign = "<>";
            } else if ("C".equals(this.qtyShowCondition)) {
                sign = ">";
            } else if ("D".equals(this.qtyShowCondition)) {
                sign = "<";
            }
            return periodTotalDataSet.filter("periodendqty " + sign + " 0");
        }
        return periodTotalDataSet;
    }

    private String[] getCalperiodEndOrderByField() {
        if (this.accountTypeContainer.size() == 1 && this.accountTypeContainer.contains("D")) {
            if ("A".equals(this.orderType)) {
                logger.info(this.orderType + "--------------------bookdate+audittime+" + this.accountTypeContainer);
                return standardCost_TYPE_BizFirst_OneOrder;
            }
            logger.info(this.orderType + "--------------------audittime+bookdate+" + this.accountTypeContainer);
            return standardCost_TYPE_AuditFirst_OneOrder;
        }
        if ("A".equals(this.orderType)) {
            logger.info(this.orderType + "--------------------bookdate+audittime");
            return standardCost_BizFirst_OneOrder;
        }
        logger.info(this.orderType + "--------------------audittime+bookdate");
        return standardCost_AuditFirst_OneOrder;
    }

    private QFilter setIds(DynamicObjectCollection multiParam, QFilter q, String multiParamIdName) {
        HashSet<Object> idContainer = new HashSet<Object>(16);
        if (multiParam != null && multiParam.size() != 0) {
            for (DynamicObject storageOrg : multiParam) {
                idContainer.add(storageOrg.getPkValue());
            }
            q = multiParam != null ? q.and(multiParamIdName, "in", idContainer) : q;
        }
        return q;
    }

    public DataSet getDefaultEmptyDataSet() {
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_material", (String)"id", (QFilter[])new QFilter("id", "=", (Object)0L).toArray(), null);
    }

    private String getCostAdjustDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("entryid,costelement.number as costelementnumber,costelement.name as costelementname,costsubelement.number as costsubelementnumber,costsubelement.name as costsubelementname,");
        select.append("case when adjustamt = null then 0 else adjustamt end as actualcost,");
        select.append("'costadjustbill' as srcobject");
        return select.toString();
    }

    private String getCostRecordDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("entryid,costelement.number as costelementnumber,costelement.name as costelementname,costsubelement.number as costsubelementnumber,costsubelement.name as costsubelementname,");
        select.append("case when actualcost = null then 0 else actualcost end as actualcost,");
        select.append("'costrecord' as srcobject");
        return select.toString();
    }

    private String getFinalSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,case when period = 99 then 0 else period end as period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,comment,storageorgnumber,storageorgname,");
        select.append("ownertype,owner,owner as ownernumber,warehousenumber,warehousename,warehsgroupnumber,warehsgroupname,locationnumber,locationname,lot,");
        select.append("assist as assistproperty,projectname,tracknumber,materialcategory,");
        select.append("periodinqty,periodinamount,");
        select.append("periodoutqty,periodoutamount,");
        select.append("periodendqty,periodendamount,");
        select.append(this.getPriceSelect("periodinamount", "periodinqty")).append(" as periodinprice,");
        select.append(this.getPriceSelect("periodoutamount", "periodoutqty")).append(" as periodoutprice,");
        select.append(this.getEndPriceSelect("periodendamount", "periodendqty")).append(" as periodendprice,");
        select.append(this.currencyId).append(" as currencyid,");
        if (this.showDetail && this.onlyShowSumRow) {
            select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname,");
        }
        select.append("billid,bizentityobject,");
        select.append("currentMaterialId,");
        select.append("currentMaterialId as currentMateiralId,");
        select.append("priorityOrder,");
        select.append("priorityOrder_first,");
        select.append("head_materialnumber,");
        select.append("head_materialname,");
        select.append("head_baseunit,");
        select.append("head_model,");
        select.append("head_group,");
        select.append("head_precision,");
        return select.toString();
    }

    private String[] getDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,comment,storageorgnumber,storageorgname,ownername,");
        select.append("warehousenumber,warehousename,warehsgroupnumber,warehsgroupname,locationnumber,locationname,lot,");
        select.append("assist,projectname,tracknumber,materialcategory,entryid,srcobject,");
        select.append("periodinqty,case when calbilltype = 'IN' then actualcost else 0 end as periodinamount,");
        select.append("periodoutqty,case when calbilltype = 'OUT' then actualcost else 0 end as periodoutamount,");
        select.append("0 as periodendqty,0 as periodendamount,");
        select.append("billid,bizentityobject,");
        select.append("currentMaterialId,");
        select.append("year * 100 + period as yearperiod,");
        select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname");
        return select.toString().split(",");
    }

    private String[] getRightSelects() {
        StringBuilder select = new StringBuilder();
        select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname,");
        select.append("actualcost");
        return select.toString().split(",");
    }

    private String[] getLeftSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,comment,storageorgnumber,storageorgname,ownername,");
        select.append("warehousenumber,warehousename,warehsgroupnumber,warehsgroupname,locationnumber,locationname,lot,");
        select.append("assist,projectname,tracknumber,materialcategory,entryid,srcobject,");
        select.append("periodinqty,periodinamount,");
        select.append("periodoutqty,periodoutamount,");
        select.append("periodendqty,periodendamount,");
        select.append("billid,bizentityobject,");
        select.append("currentMaterialId,");
        select.append("year * 100 + period as yearperiod");
        select.append("ordercol_second,ordercol_first");
        return select.toString().split(",");
    }

    private String getYearTotalFinalSelects() {
        String s = ResManager.loadKDString((String)"\u672c\u5e74\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_31", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("year as year,");
        select.append("period,");
        select.append("null as bizdate,null as bookdate,null as audittime,'0' as isvoucher,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,null as comment,null as ownertype,0 as owner,null as storageorgnumber,null as storageorgname,");
        select.append("null as warehousenumber,null as warehousename,null as warehsgroupnumber,null as warehsgroupname,");
        select.append("null as locationnumber,null as locationname,null as lot,");
        select.append("null as assist,null as projectname,null as tracknumber,null as materialcategory,null as entryid,null as srcobject,");
        select.append("periodinqty as periodinqty,periodinamount as periodinamount,");
        select.append("periodoutqty as periodoutqty,periodoutamount as periodoutamount,");
        select.append("periodendqty as periodendqty,periodendamount as periodendamount,");
        select.append("0 as unitprice,");
        select.append("0 as billid,null as bizentityobject");
        select.append(",currentMaterialId");
        return select.toString();
    }

    private String getPeriodTotalFinalSelects() {
        String s = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"StockDetailRptQueryPlugin_24", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("year as year,period as period,null as bizdate,null as bookdate,null as audittime,'0' as isvoucher,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,null as ownertype,null as comment,0 as owner,null as storageorgnumber,null as storageorgname,");
        select.append("null as warehousenumber,null as warehousename,null as warehsgroupnumber,null as warehsgroupname,null as locationnumber,null as locationname,null as lot,");
        select.append("null as assist,null as projectname,null as tracknumber,null as materialcategory,null as entryid,null as srcobject,");
        select.append("periodinqty as periodinqty,periodinamount as periodinamount,");
        select.append("periodoutqty as periodoutqty,periodoutamount as periodoutamount,");
        select.append("periodendqty as periodendqty,periodendamount as periodendamount,");
        select.append("0 as unitprice,");
        select.append("0 as billid,null as bizentityobject");
        select.append(",currentMaterialId");
        return select.toString();
    }

    private String getTempSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,comment,ownertype,owner,storageorgnumber,storageorgname,");
        select.append("warehousenumber,warehousename,warehsgroupnumber,warehsgroupname,locationnumber,locationname,lot,");
        select.append("assist,projectname,tracknumber,materialcategory,entryid,srcobject,");
        select.append("periodinqty,periodinamount,");
        select.append("periodoutqty,periodoutamount");
        return select.toString();
    }

    private String getPeriodBeginFinalSelects() {
        String s = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"StockDetailRptQueryPlugin_14", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("year as year,month as period,null as bizdate,null as bookdate,null as audittime,'0' as isvoucher,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,null as comment,null as ownertype,0 as owner,null as storageorgnumber,null as storageorgname,");
        select.append("null as warehousenumber,null as warehousename,");
        select.append("null as warehsgroupnumber,null as warehsgroupname,null as locationnumber,null as locationname,null as lot,");
        select.append("null as assist,null as projectname,null as tracknumber,null as materialcategory,");
        select.append("0 as periodinqty,0 as periodinamount,");
        select.append("0 as periodoutqty,0 as periodoutamount,");
        select.append("0 as periodendqty,0 as periodendamount,");
        select.append("0 as unitprice,");
        select.append("periodbeginqty as periodinqtybak,periodbeginactualcost as periodinamountbak,");
        select.append("0 as billid,null as bizentityobject,null as entryid,null as srcobject");
        select.append(",currentMaterialId");
        return select.toString();
    }

    private String getCostRecordSelects() {
        StringBuilder select = new StringBuilder();
        select.append("period.periodyear as year,period.periodnumber as period,bizdate as bizdate,bookdate,auditdate as audittime,case when isvoucher = '1' then '1' else '0' end  as isvoucher,");
        select.append("billno as billno,calbilltype as calbilltype,billtype.name as billtype,comment as comment,");
        select.append("entry.ownertype as ownertype,entry.owner as owner,");
        select.append("storageorgunit.number as storageorgnumber,storageorgunit.name as storageorgname,");
        select.append("entry.warehouse.number as warehousenumber,entry.warehouse.name as warehousename,");
        select.append("entry.warehouse.group.number as warehsgroupnumber,entry.warehouse.group.name as warehsgroupname,entry.location.number as locationnumber,entry.location.name as locationname,entry.lot as lot,");
        select.append("entry.assist as assist,entry.project.name as projectname,entry.tracknumber.number as tracknumber,");
        select.append("entry.stocktype as materialcategory,");
        select.append("case when calbilltype = 'IN' then entry.baseqty else 0 end as periodinqty,");
        select.append("case when calbilltype = 'IN' and entry.accounttype != 'D' then entry.actualcost ");
        select.append(" when calbilltype = 'IN' and entry.accounttype = 'D' then entry.standardcost  ");
        select.append(" else 0 end as periodinamount,");
        select.append("case when calbilltype = 'OUT' then entry.baseqty else 0 end as periodoutqty,");
        select.append("case when calbilltype = 'OUT' and entry.accounttype != 'D' then entry.actualcost ");
        select.append("when calbilltype = 'OUT' and entry.accounttype = 'D' then entry.standardcost ");
        select.append("else 0 end as periodoutamount, ");
        select.append("0 as periodendqty,0 as periodendamount,");
        select.append("case when entry.accounttype = 'D' then entry.unitstandardcost else entry.unitactualcost end as unitprice,");
        select.append("case when calbilltype = 'IN' then entry.baseqty else 0 end as periodinqtybak,");
        select.append("case when calbilltype = 'IN' and entry.accounttype != 'D' then entry.actualcost ");
        select.append(" when calbilltype = 'IN' and entry.accounttype = 'D' then entry.standardcost  ");
        select.append(" else 0 end as periodinamountbak,");
        select.append("id as billid,'cal_costrecord_subentity' as bizentityobject,entry.id as entryid,'costrecord' as srcobject");
        select.append(",entry.material as currentMaterialId");
        return select.toString();
    }

    private String getCostAdjustSelects() {
        String s = ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"StockDetailRptQueryPlugin_13", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("period.periodyear as year,period.periodnumber as period,bizdate as bizdate,bookdate,auditdate as audittime,case when isvoucher = '1' then '1' else '0' end  as isvoucher,");
        select.append("billno as billno,case when biztype = 'A' then 'IN' else 'OUT' end as calbilltype,'");
        select.append(s);
        select.append("' as billtype,remark as comment,entryentity.ownertype as ownertype,entryentity.owner,");
        select.append("entryentity.storageorgunit.number as storageorgnumber,entryentity.storageorgunit.name as storageorgname,");
        select.append("entryentity.warehouse.number as warehousenumber,entryentity.warehouse.name as warehousename,");
        select.append("entryentity.warehouse.group.number as warehsgroupnumber,entryentity.warehouse.group.name as warehsgroupname,entryentity.location.number as locationnumber,entryentity.location.name as locationname,entryentity.lot as lot,");
        select.append("entryentity.assist as assist,entryentity.project.name as projectname,entryentity.tracknumber.number as tracknumber,");
        select.append("entryentity.stocktype as materialcategory,");
        select.append(" 0 as periodinqty,case when biztype = 'A' and entryentity.accounttype = 'D' and difftype <> 'B' and createtype <> 'C1' then entryentity.adjustamt ");
        select.append(" when biztype = 'A' and entryentity.accounttype <> 'D' and difftype = 'B' then entryentity.adjustamt else 0 end as periodinamount,");
        select.append("0 as periodoutqty,case when biztype = 'B' and entryentity.accounttype = 'D' and difftype <> 'B' and createtype <> 'C1' then entryentity.adjustamt ");
        select.append(" when biztype = 'B' and entryentity.accounttype <> 'D' and difftype = 'B' then entryentity.adjustamt  else 0 end as periodoutamount,");
        select.append("0 as periodendqty,0 as periodendamount,");
        select.append("0 as unitprice,");
        select.append("0 as periodinqtybak,case when biztype = 'A' then entryentity.adjustamt else 0 end as periodinamountbak,");
        select.append("id as billid,'cal_costadjust_subentity' as bizentityobject,entryentity.id as entryid,'costadjustbill' as srcobject");
        select.append(",entryentity.material as currentMaterialId");
        return select.toString();
    }

    private String getStdDiffSelects() {
        String s = ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355", (String)"StockDetailRptQueryPlugin_23", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("period.periodyear as year,period.periodnumber as period,bizdate as bizdate,bookdate,auditdate as audittime,case when isvoucher = '1' then '1' else '0' end  as isvoucher,");
        select.append("billno as billno,case when biztype = 'A' then 'IN' else 'OUT' end as calbilltype,'");
        select.append(s);
        select.append("' as billtype,remark as comment,entryentity.ownertype as ownertype,entryentity.owner,");
        select.append("entryentity.storageorgunit.number as storageorgnumber,entryentity.storageorgunit.name as storageorgname,");
        select.append("entryentity.warehouse.number as warehousenumber,entryentity.warehouse.name as warehousename,");
        select.append("entryentity.warehouse.group.number as warehsgroupnumber,entryentity.warehouse.group.name as warehsgroupname,entryentity.location.number as locationnumber,entryentity.location.name as locationname,entryentity.lot as lot,");
        select.append("entryentity.assist as assist,entryentity.project.name as projectname,entryentity.tracknumber.number as tracknumber,");
        select.append("entryentity.stocktype as materialcategory,");
        select.append(" 0 as periodinqty,case when biztype = 'A' and entryentity.accounttype = 'D' and createtype <> 'C1' then entryentity.adjustamt ");
        select.append(" when biztype = 'A' and entryentity.accounttype <> 'D' then 0 else 0 end as periodinamount,");
        select.append("0 as periodoutqty,case when biztype = 'B' and entryentity.accounttype = 'D' and createtype <> 'C1' then entryentity.adjustamt ");
        select.append(" when biztype = 'B' and entryentity.accounttype <> 'D' then 0  else 0 end as periodoutamount,");
        select.append("0 as periodendqty,0 as periodendamount,");
        select.append("0 as unitprice,");
        select.append("0 as periodinqtybak,case when biztype = 'A' then entryentity.adjustamt else 0 end as periodinamountbak,");
        select.append("id as billid,'cal_stdcostdiffbill' as bizentityobject,entryentity.id as entryid,'costadjustbill' as srcobject");
        select.append(",entryentity.material as currentMaterialId");
        return select.toString();
    }
}

