/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.queryplugin.StockDetailRptQueryNewPlugin;

public class StockDetailRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(StockDetailRptQueryPlugin.class);
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private DynamicObject filter_startPeriod;
    private DynamicObject filter_endPeriod;
    private int filter_startPeriodNumber;
    private int filter_endPeriodNumber;
    private List<Integer> periodNumberList = new ArrayList<Integer>();
    private boolean onlyShowSumRow;
    private boolean topSumRow;
    private boolean showdetail;
    private long baseUnitId;
    private long currencyId;
    private String filter_ownertype;
    private DynamicObjectCollection filter_ownerFrom;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private String[] filter_lot;
    private DynamicObjectCollection filter_project;
    private DynamicObjectCollection filter_tracknumber;
    private DynamicObjectCollection filter_invType;
    private DynamicObjectCollection filter_invStatus;
    private DynamicObjectCollection filter_mulcalrange;
    private Set<String> filter_mulaccounttype = new HashSet<String>(16);
    private String filter_ordertype;
    private String qtyShowCondition;
    private String amountShowCondition;
    private Date filter_startDate;
    private Date filter_endDate;
    private long materialId;
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private boolean isNewBalance;
    private LocaleString locale_costelementNum = new LocaleString(this.getLocale_costelementNum());
    private LocaleString locale_costelementName = new LocaleString(this.getLocale_costelementName());
    private LocaleString locale_costsubelementNum = new LocaleString(this.getLocale_costsubelementNum());
    private LocaleString locale_costsubelementName = new LocaleString(this.getLocale_costsubelementName());
    private LocaleString locale_baseUnit = new LocaleString(this.getLocale_baseUnit());
    private LocaleString locale_periodIn = new LocaleString(this.getLocale_periodIn());
    private LocaleString locale_periodOut = new LocaleString(this.getLocale_periodOut());
    private LocaleString locale_periodEnd = new LocaleString(this.getLocale_periodEnd());
    private LocaleString locale_qty = new LocaleString(this.getLocale_qty());
    private LocaleString locale_price = new LocaleString(this.getLocale_price());
    private LocaleString locale_amount = new LocaleString(this.getLocale_amount());
    private LocaleString locale_currency = new LocaleString(this.getLocale_currency());
    private static final LocaleString width = new LocaleString("100px");
    private LocaleString locale_materialNo = new LocaleString(this.getLocale_materialNo());
    private LocaleString locale_materialName = new LocaleString(this.getLocale_materialName());
    private LocaleString locale_materialType = new LocaleString(this.getLocale_materialType());
    private LocaleString locale_materialUnit = new LocaleString(this.getLocale_materialUnit());
    private LocaleString locale_materialModel = new LocaleString(this.getLocale_materialModel());
    private LocaleString locale_MaterialCategoryNum = new LocaleString(this.getLocale_MaterialCategoryNum());
    private LocaleString locale_MaterialCategoryName = new LocaleString(this.getLocale_MaterialCategoryName());
    private static final int BATCH_SIZE = 100000;

    private String getLocale_costelementNum() {
        return ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u7f16\u7801", (String)"StockDetailRptQueryPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costelementName() {
        return ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u540d\u79f0", (String)"StockDetailRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costsubelementNum() {
        return ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801", (String)"StockDetailRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costsubelementName() {
        return ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u540d\u79f0", (String)"StockDetailRptQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_baseUnit() {
        return ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"StockDetailRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodIn() {
        return ResManager.loadKDString((String)"\u672c\u671f\u6536\u5165", (String)"StockDetailRptQueryPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodOut() {
        return ResManager.loadKDString((String)"\u672c\u671f\u53d1\u51fa", (String)"StockDetailRptQueryPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodEnd() {
        return ResManager.loadKDString((String)"\u671f\u672b\u7ed3\u5b58", (String)"StockDetailRptQueryPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_qty() {
        return ResManager.loadKDString((String)"\u6570\u91cf", (String)"StockDetailRptQueryPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_price() {
        return ResManager.loadKDString((String)"\u5355\u4ef7", (String)"StockDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_amount() {
        return ResManager.loadKDString((String)"\u91d1\u989d", (String)"StockDetailRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_currency() {
        return ResManager.loadKDString((String)"\u5e01\u79cd", (String)"StockDetailRptQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialNo() {
        return ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"StockDetailRptQueryPlugin_17", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialName() {
        return ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"StockDetailRptQueryPlugin_18", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialType() {
        return ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b", (String)"StockDetailRptQueryPlugin_19", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialUnit() {
        return ResManager.loadKDString((String)"\u5355\u4f4d", (String)"StockDetailRptQueryPlugin_20", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialModel() {
        return ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"StockDetailRptQueryPlugin_21", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_isVoucher() {
        return ResManager.loadKDString((String)"\u51ed\u8bc1\u6807\u8bc6", (String)"StockDetailRptQueryPlugin_22", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_MaterialCategoryNum() {
        return ResManager.loadKDString((String)"\u5b58\u8d27\u7c7b\u522b\u7f16\u7801", (String)"StockGatherRptQueryPlugin_55", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_MaterialCategoryName() {
        return ResManager.loadKDString((String)"\u5b58\u8d27\u7c7b\u522b\u540d\u79f0", (String)"StockGatherRptQueryPlugin_56", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        try {
            if (ThreadCache.get((Object)"self_print_value") != null && ThreadCache.get((Object)"self_print_value") instanceof String) {
                String printValue = (String)ThreadCache.get((Object)"self_print_value");
                ThreadCache.remove((Object)"self_print_value");
                if (printValue == null || printValue.length() == 0) {
                    return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id", (QFilter[])new QFilter("id", "=", (Object)0L).toArray(), null);
                }
                HashMap<String, Object> selfDefinition = new HashMap<String, Object>(16);
                selfDefinition.put("self_use_multi", "useMulti");
                selfDefinition.put("materialIds", printValue);
                DataSet rows = new StockDetailRptQueryNewPlugin().queryAll(param, selfDefinition);
                selfDefinition.remove("self_use_multi");
                selfDefinition.remove("materialIds");
                return rows;
            }
            if (!param.getFilter().getFilterItem("showpartition").getBoolean()) {
                return new StockDetailRptQueryNewPlugin().queryAll(param, new HashMap<String, Object>(16));
            }
            return this.queryResult(param);
        }
        catch (Exception e) {
            StringBuilder sBuilder = new StringBuilder("stockDetailRpt=?");
            if (e instanceof KDBizException) {
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage());
                }
            } else {
                StackTraceElement[] errs;
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage()).append("\n");
                }
                for (StackTraceElement err : errs = e.getStackTrace()) {
                    sBuilder.append(err.toString()).append("\n");
                }
            }
            logger.info(sBuilder.toString());
            throw e;
        }
    }

    private DataSet queryResult(ReportQueryParam param) {
        this.init(param);
        DataSet dataSet = this.getCostRecordDataSet();
        if (this.materialId == -1L) {
            return dataSet;
        }
        dataSet = dataSet.union(this.getCostAdjustDataSet());
        dataSet = this.filterByAllZeroCondition(dataSet);
        dataSet = this.unionPeriodBeginDataSet(dataSet);
        dataSet = this.calPeriodEndDataSet(dataSet);
        dataSet = this.filterStratPeriod(dataSet);
        dataSet = this.unionTotalDataSet(dataSet);
        dataSet = this.unionDetailDataSet(dataSet);
        dataSet = this.topSumRow(dataSet);
        dataSet = this.onlyShowSumRow(dataSet);
        dataSet = dataSet.select(this.getFinalSelects().split(","));
        return dataSet;
    }

    private DataSet unionDetailDataSet(DataSet dataSet) {
        if (this.showdetail && !this.onlyShowSumRow) {
            DataSet tempDataSet = dataSet.copy();
            HashSet<Object> costRecordEntryIds = new HashSet<Object>();
            HashSet<Object> costAdjustEntryIds = new HashSet<Object>();
            for (Row row : tempDataSet) {
                Object entryId = row.get("entryid");
                String srcObject = row.getString("srcObject");
                if ("costadjustbill".equals(srcObject) && entryId != null) {
                    costAdjustEntryIds.add(entryId);
                    continue;
                }
                if (!"costrecord".equals(srcObject) || entryId == null) continue;
                costRecordEntryIds.add(entryId);
            }
            DataSet costRecordDetailDataSet = this.getDetailByBatch(costAdjustEntryIds, "cal_costrecord_detail", this.getCostRecordDetailSelects());
            DataSet adjustDetailDataSet = this.getDetailByBatch(costAdjustEntryIds, "cal_costadjust_detail", this.getCostAdjustDetailSelects());
            DataSet detailDataSet = dataSet.copy().join(costRecordDetailDataSet.union(adjustDetailDataSet), JoinType.LEFT).on("entryid", "entryid").on("srcobject", "srcobject").select(this.getLeftSelects(), this.getRightSelects()).finish().select(this.getDetailSelects());
            dataSet = dataSet.where("ordercol_first=0 and ordercol_second=1").addNullField("costelementnumber").addField(ResManager.loadKDString((String)"'\u5c0f\u8ba1'", (String)"StockDetailRptQueryPlugin_12", (String)"fi-cal-report", (Object[])new Object[0]), "costelementname").addNullField("costsubelementnumber").addNullField("costsubelementname").union(detailDataSet);
        }
        return dataSet;
    }

    private String[] getDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,comment,storageorgnumber,storageorgname,ownername,");
        select.append("warehousenumber,warehousename,warehsgroupnumber,warehsgroupname,locationnumber,locationname,lot,");
        select.append("assist,projectname,tracknumber,entryid,srcobject,");
        select.append("periodinqty,case when calbilltype = 'IN' then actualcost else 0 end as periodinamount,");
        select.append("periodoutqty,case when calbilltype = 'OUT' then actualcost else 0 end as periodoutamount,");
        select.append("0 as periodendqty,0 as periodendamount,");
        select.append("billid,bizentityobject,");
        select.append("2 as ordercol_second, 0 as ordercol_first,");
        select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname");
        return select.toString().split(",");
    }

    private String[] getRightSelects() {
        StringBuilder select = new StringBuilder();
        select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname,");
        select.append("actualcost");
        return select.toString().split(",");
    }

    private String[] getLeftSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,comment,storageorgnumber,storageorgname,ownername,");
        select.append("warehousenumber,warehousename,warehsgroupnumber,warehsgroupname,locationnumber,locationname,lot,");
        select.append("assist,projectname,tracknumber,entryid,srcobject,");
        select.append("periodinqty,periodinamount,");
        select.append("periodoutqty,periodoutamount,");
        select.append("periodendqty,periodendamount,");
        select.append("billid,bizentityobject,");
        select.append("ordercol_second,ordercol_first");
        return select.toString().split(",");
    }

    private String getCostAdjustDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("entryid,costelement.number as costelementnumber,costelement.name as costelementname,costsubelement.number as costsubelementnumber,costsubelement.name as costsubelementname,");
        select.append("case when adjustamt = null then 0 else adjustamt end as actualcost,");
        select.append("'costadjustbill' as srcobject");
        return select.toString();
    }

    private String getCostRecordDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("entryid,costelement.number as costelementnumber,costelement.name as costelementname,costsubelement.number as costsubelementnumber,costsubelement.name as costsubelementname,");
        select.append("case when actualcost = null then 0 else actualcost end as actualcost,");
        select.append("'costrecord' as srcobject");
        return select.toString();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        this.insertSelfDefinition(cols);
        this.createCostElementColumns(cols);
        this.createDecimalColumns(cols);
        this.createHideColumns(cols);
        return cols;
    }

    private void insertSelfDefinition(List<AbstractReportColumn> cols) {
        int i;
        ArrayList<AbstractReportColumn> pre = new ArrayList<AbstractReportColumn>(16);
        ArrayList<ReportColumn> middle = new ArrayList<ReportColumn>(16);
        ArrayList<AbstractReportColumn> behind = new ArrayList<AbstractReportColumn>(16);
        for (i = 0; i < cols.size(); ++i) {
            pre.add(cols.get(i));
            String localeValue = cols.get(i).getCaption().getLocaleValue();
            if (localeValue.equals(this.getLocale_isVoucher())) break;
        }
        ReportColumn head_materialnumber = new ReportColumn();
        head_materialnumber.setCaption(this.locale_materialNo);
        head_materialnumber.setWidth(width);
        head_materialnumber.setFieldKey("head_materialnumber");
        head_materialnumber.setFieldType("text");
        head_materialnumber.setHide(true);
        ReportColumn head_materialname = new ReportColumn();
        head_materialname.setCaption(this.locale_materialName);
        head_materialname.setWidth(width);
        head_materialname.setFieldKey("head_materialname");
        head_materialname.setFieldType("text");
        head_materialname.setHide(true);
        ReportColumn head_baseunit = new ReportColumn();
        head_baseunit.setCaption(this.locale_materialUnit);
        head_baseunit.setWidth(width);
        head_baseunit.setFieldKey("head_baseunit");
        head_baseunit.setFieldType("text");
        head_baseunit.setHide(true);
        ReportColumn head_model = new ReportColumn();
        head_model.setCaption(this.locale_materialModel);
        head_model.setWidth(width);
        head_model.setFieldKey("head_model");
        head_model.setFieldType("text");
        head_model.setHide(true);
        ReportColumn head_group = new ReportColumn();
        head_group.setCaption(this.locale_materialType);
        head_group.setWidth(width);
        head_group.setFieldKey("head_group");
        head_group.setFieldType("text");
        head_group.setHide(true);
        ReportColumn materialcategory = ReportColumn.createBaseDataColumn((String)"materialcategory", (String)"bd_materialcategory");
        materialcategory.setDisplayProp("number");
        materialcategory.setCaption(this.locale_MaterialCategoryNum);
        materialcategory.setWidth(width);
        materialcategory.setHide(true);
        ReportColumn materialcategoryname = ReportColumn.createBaseDataPropColumn((String)"materialcategoryname", (String)"materialcategory", (String)"name");
        materialcategoryname.setCaption(this.locale_MaterialCategoryName);
        materialcategoryname.setWidth(width);
        materialcategoryname.setHide(true);
        middle.add(head_materialnumber);
        middle.add(head_materialname);
        middle.add(head_baseunit);
        middle.add(head_model);
        middle.add(head_group);
        middle.add(materialcategory);
        middle.add(materialcategoryname);
        ++i;
        while (i < cols.size()) {
            behind.add(cols.get(i));
            ++i;
        }
        cols.clear();
        cols.addAll(pre);
        cols.addAll(middle);
        cols.addAll(behind);
    }

    private void init(ReportQueryParam param) {
        this.filterInfo = param.getFilter();
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.filter_startPeriod = PeriodHelper.getStartPeriod((Long)this.filter_costAccount.getLong("id"));
        this.filter_endPeriod = this.filterInfo.getDynamicObject("endperiod");
        this.filter_startPeriodNumber = this.filter_startPeriod.getInt("periodyear") * 100 + this.filter_startPeriod.getInt("periodnumber");
        this.filter_endPeriodNumber = this.filter_endPeriod.getInt("periodyear") * 100 + this.filter_endPeriod.getInt("periodnumber");
        this.filter_startDate = this.filter_startPeriod.getDate("begindate");
        this.filter_endDate = this.filter_endPeriod.getDate("enddate");
        this.onlyShowSumRow = this.filterInfo.getBoolean("onlyshowsumrow");
        this.topSumRow = this.filterInfo.getBoolean("topsumrow");
        this.showdetail = this.filterInfo.getBoolean("showdetail");
        Object calPolicyId = this.filter_costAccount.getDynamicObject("calpolicy").getPkValue();
        DynamicObject calPolicy = BusinessDataServiceHelper.loadSingleFromCache((Object)calPolicyId, (String)"cal_bd_calpolicy");
        this.showdetail = this.showdetail && calPolicy.getBoolean("calbycostelement");
        Object filterInfoValue = this.filterInfo.getFilterItem("currentMateiralId").getValue();
        this.materialId = Long.parseLong((String)filterInfoValue);
        DynamicObjectCollection materialColl = QueryServiceHelper.query((String)"bd_material", (String)"baseunit.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.materialId)});
        if (materialColl.size() > 0) {
            this.baseUnitId = ((DynamicObject)materialColl.get(0)).getLong("baseunit.id");
        }
        this.currencyId = this.filterInfo.getDynamicObject("localcurrency").getLong("id");
        this.filter_ownertype = (String)this.filterInfo.getValue("ownertypehead");
        if (StringUtils.isNotEmpty((String)this.filter_ownertype)) {
            if ("bos_org".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        if (StringUtils.isNotEmpty((String)this.filterInfo.getString("lotnumber"))) {
            this.filter_lot = this.filterInfo.getString("lotnumber").split(";");
        }
        this.filter_project = this.filterInfo.getDynamicObjectCollection("mulproject");
        this.filter_tracknumber = this.filterInfo.getDynamicObjectCollection("multracknum");
        this.filter_invType = this.filterInfo.getDynamicObjectCollection("mulinvtype");
        this.filter_invStatus = this.filterInfo.getDynamicObjectCollection("mulinvstatus");
        this.qtyShowCondition = this.filterInfo.getString("qtyshowcondition");
        this.amountShowCondition = this.filterInfo.getString("amountshowcondition");
        this.filter_mulcalrange = this.filterInfo.getDynamicObjectCollection("mulcalrange");
        String mulaccounttype = this.filterInfo.getString("mulaccounttype");
        if (StringUtils.isNotEmpty((String)mulaccounttype)) {
            for (String s : mulaccounttype.split(",")) {
                if (!StringUtils.isNotEmpty((String)s)) continue;
                this.filter_mulaccounttype.add(s);
            }
        }
        this.filter_ordertype = this.filterInfo.getString("ordertype");
        this.isNewBalance = CalBalanceModelHelper.isNewBalance();
    }

    private QFilter getCostRecordFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("bookdate", ">=", (Object)this.filter_startDate);
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("entry.material", "=", (Object)this.materialId);
        q.and("issplitcreate", "=", (Object)false);
        q.and("isinitbill", "=", (Object)false);
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costrecord");
        if (this.filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entry.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entry.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entry.location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("entry.lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("entry.project", "in", set);
        }
        if (this.filter_tracknumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_tracknumber) {
                set.add(info.getPkValue());
            }
            q.and("entry.tracknumber", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("entry.invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("entry.invstatus", "in", set);
        }
        if (this.filter_mulcalrange != null) {
            set = new HashSet();
            for (DynamicObject dynamicObject : this.filter_mulcalrange) {
                set.add(dynamicObject.getPkValue());
            }
            q.and("entry.calrange", "in", set);
        }
        if (!this.filter_mulaccounttype.isEmpty()) {
            q.and("entry.accounttype", "in", this.filter_mulaccounttype);
        }
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        return q;
    }

    private DataSet getCostRecordDataSet() {
        QFilter q = this.getCostRecordFilter();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getCostRecordSelects(), (QFilter[])new QFilter[]{q}, null);
        return dataSet;
    }

    private String getCostRecordSelects() {
        StringBuilder select = new StringBuilder();
        select.append("period.periodyear as year,period.periodnumber as period,bizdate,bookdate,auditdate as audittime,case when isvoucher = '1' then '1' else '0' end  as isvoucher,");
        select.append("billno as billno,calbilltype as calbilltype,billtype.name as billtype,comment as comment,");
        select.append("entry.ownertype as ownertype,entry.owner as owner,");
        select.append("storageorgunit.number as storageorgnumber,storageorgunit.name as storageorgname,");
        select.append("entry.warehouse.number as warehousenumber,entry.warehouse.name as warehousename,");
        select.append("entry.warehouse.group.number as warehsgroupnumber,entry.warehouse.group.name as warehsgroupname,entry.location.number as locationnumber,entry.location.name as locationname,entry.lot as lot,");
        select.append("entry.assist as assist,entry.project.name as projectname,entry.tracknumber.number as tracknumber,");
        select.append("case when calbilltype = 'IN' then entry.baseqty else 0 end as periodinqty,");
        select.append("case when calbilltype = 'IN' and entry.accounttype != 'D' then entry.actualcost ");
        select.append(" when calbilltype = 'IN' and entry.accounttype = 'D' then entry.standardcost  ");
        select.append(" else 0 end as periodinamount,");
        select.append("case when calbilltype = 'OUT' then entry.baseqty else 0 end as periodoutqty,");
        select.append("case when calbilltype = 'OUT' and entry.accounttype != 'D' then entry.actualcost ");
        select.append("when calbilltype = 'OUT' and entry.accounttype = 'D' then entry.standardcost ");
        select.append("else 0 end as periodoutamount, ");
        select.append("0 as periodendqty,0 as periodendamount,");
        select.append("case when entry.accounttype = 'D' then entry.unitstandardcost else entry.unitactualcost end as unitprice,");
        select.append("case when calbilltype = 'IN' then entry.baseqty else 0 end as periodinqtybak,");
        select.append("case when calbilltype = 'IN' and entry.accounttype != 'D' then entry.actualcost ");
        select.append(" when calbilltype = 'IN' and entry.accounttype = 'D' then entry.standardcost  ");
        select.append(" else 0 end as periodinamountbak,");
        select.append("id as billid,'cal_costrecord_subentity' as bizentityobject,entry.id as entryid,'costrecord' as srcobject");
        return select.toString();
    }

    private DataSet getCostAdjustDataSet() {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjustbill", (String)this.getCostAdjustSelects(), (QFilter[])new QFilter[]{this.getCostAdjustFilter(true)}, null);
        DataSet stdDiff = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)this.getStdDiffSelects(), (QFilter[])new QFilter[]{this.getCostAdjustFilter(false)}, null);
        dataSet = dataSet.union(stdDiff);
        return dataSet.filter("periodinamount != 0 or periodoutamount != 0");
    }

    private QFilter getCostAdjustFilter(boolean isCostAdjust) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("bookdate", ">=", (Object)this.filter_startDate);
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("entryentity.material", "=", (Object)this.materialId);
        q.and("billstatus", "=", (Object)"C");
        if (isCostAdjust) {
            q.and("entryentity.accounttype", "<>", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        }
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costadjustbill");
        if (this.filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("entryentity.lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.project", "in", set);
        }
        if (this.filter_tracknumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_tracknumber) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.tracknumber", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invstatus", "in", set);
        }
        if (this.filter_mulcalrange != null) {
            set = new HashSet();
            for (DynamicObject dynamicObject : this.filter_mulcalrange) {
                set.add(dynamicObject.getPkValue());
            }
            q.and("entryentity.calrange", "in", set);
        }
        if (!this.filter_mulaccounttype.isEmpty()) {
            q.and("entryentity.accounttype", "in", this.filter_mulaccounttype);
        }
        return q;
    }

    private String getCostAdjustSelects() {
        String s = ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"StockDetailRptQueryPlugin_13", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("period.periodyear as year,period.periodnumber as period,bizdate,bookdate,auditdate as audittime,case when isvoucher = '1' then '1' else '0' end  as isvoucher,");
        select.append("billno as billno,case when biztype = 'A' then 'IN' else 'OUT' end as calbilltype,'");
        select.append(s);
        select.append("' as billtype,remark as comment,entryentity.ownertype as ownertype,entryentity.owner,");
        select.append("entryentity.storageorgunit.number as storageorgnumber,entryentity.storageorgunit.name as storageorgname,");
        select.append("entryentity.warehouse.number as warehousenumber,entryentity.warehouse.name as warehousename,");
        select.append("entryentity.warehouse.group.number as warehsgroupnumber,entryentity.warehouse.group.name as warehsgroupname,entryentity.location.number as locationnumber,entryentity.location.name as locationname,entryentity.lot as lot,");
        select.append("entryentity.assist as assist,entryentity.project.name as projectname,entryentity.tracknumber.number as tracknumber,");
        select.append(" 0 as periodinqty,case when biztype = 'A' and entryentity.accounttype = 'D' and difftype <> 'B' and createtype <> 'C1' then entryentity.adjustamt ");
        select.append(" when biztype = 'A' and entryentity.accounttype <> 'D' and difftype = 'B' then entryentity.adjustamt else 0 end as periodinamount,");
        select.append("0 as periodoutqty,case when biztype = 'B' and entryentity.accounttype = 'D' and difftype <> 'B' and createtype <> 'C1' then entryentity.adjustamt ");
        select.append(" when biztype = 'B' and entryentity.accounttype <> 'D' and difftype = 'B' then entryentity.adjustamt  else 0 end as periodoutamount,");
        select.append("0 as periodendqty,0 as periodendamount,");
        select.append("0 as unitprice,");
        select.append("0 as periodinqtybak,case when biztype = 'A' then entryentity.adjustamt else 0 end as periodinamountbak,");
        select.append("id as billid,'cal_costadjust_subentity' as bizentityobject,entryentity.id as entryid,'costadjustbill' as srcobject");
        return select.toString();
    }

    private String getStdDiffSelects() {
        String s = ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355", (String)"StockDetailRptQueryPlugin_23", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("period.periodyear as year,period.periodnumber as period,bizdate,bookdate,auditdate as audittime,case when isvoucher = '1' then '1' else '0' end  as isvoucher,");
        select.append("billno as billno,case when biztype = 'A' then 'IN' else 'OUT' end as calbilltype,'");
        select.append(s);
        select.append("' as billtype,remark as comment,entryentity.ownertype as ownertype,entryentity.owner,");
        select.append("entryentity.storageorgunit.number as storageorgnumber,entryentity.storageorgunit.name as storageorgname,");
        select.append("entryentity.warehouse.number as warehousenumber,entryentity.warehouse.name as warehousename,");
        select.append("entryentity.warehouse.group.number as warehsgroupnumber,entryentity.warehouse.group.name as warehsgroupname,entryentity.location.number as locationnumber,entryentity.location.name as locationname,entryentity.lot as lot,");
        select.append("entryentity.assist as assist,entryentity.project.name as projectname,entryentity.tracknumber.number as tracknumber,");
        select.append(" 0 as periodinqty,case when biztype = 'A' and entryentity.accounttype = 'D' and createtype <> 'C1' then entryentity.adjustamt ");
        select.append(" when biztype = 'A' and entryentity.accounttype <> 'D' then 0 else 0 end as periodinamount,");
        select.append("0 as periodoutqty,case when biztype = 'B' and entryentity.accounttype = 'D' and createtype <> 'C1' then entryentity.adjustamt ");
        select.append(" when biztype = 'B' and entryentity.accounttype <> 'D' then 0  else 0 end as periodoutamount,");
        select.append("0 as periodendqty,0 as periodendamount,");
        select.append("0 as unitprice,");
        select.append("0 as periodinqtybak,case when biztype = 'A' then entryentity.adjustamt else 0 end as periodinamountbak,");
        select.append("id as billid,'cal_stdcostdiffbill' as bizentityobject,entryentity.id as entryid,'costadjustbill' as srcobject");
        return select.toString();
    }

    private DataSet joinOwnerDataSet(DataSet dataSet) {
        DataSet ownerSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org", (String)"id,name,number", null, null);
        return dataSet.join(ownerSet, JoinType.LEFT).on("ownerid", "id").select(this.getAliasSelects().split(","), new String[]{"name as ownername"}).finish();
    }

    private DataSet unionPeriodBeginDataSet(DataSet dataSet) {
        return dataSet.addField("1", "ordercol_second").union(this.getPeriodBeginDataSet().addField("0", "ordercol_second"));
    }

    private DataSet filterByAllZeroCondition(DataSet calDataSet) {
        StringBuilder select = new StringBuilder();
        select.append("periodinqty <> 0 or periodinamount <> 0 or ");
        select.append(" periodoutqty <> 0 or periodoutamount <> 0");
        calDataSet = calDataSet.filter(select.toString());
        return calDataSet;
    }

    private DataSet getPeriodBeginDataSet() {
        QFilter q = QFilter.of((String)"periodyear*100+periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber});
        q.and(QFilter.of((String)"periodyear*100+periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        DynamicObject costAccountInfo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", this.filter_costAccount.get("id"))});
        q.and("periodtype", "=", costAccountInfo.get("calpolicy.periodtype"));
        q.and("isadjustperiod", "=", (Object)false);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{q}, (String)"periodyear asc,periodnumber asc");
        for (DynamicObject info : coll) {
            if (this.periodNumberList.indexOf(info.getInt("periodyear") * 100 + info.getInt("periodnumber")) >= 0) continue;
            this.periodNumberList.add(info.getInt("periodyear") * 100 + info.getInt("periodnumber"));
        }
        DataSet zeroPeriodBeginDataSet = null;
        try (DataSet singleDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)"id", null, null, (int)1);){
            for (int i = 0; i < this.periodNumberList.size(); ++i) {
                int periodNumber = this.periodNumberList.get(i);
                int year = periodNumber / 100;
                int month = periodNumber % 100;
                DataSet dataSet = singleDataSet.copy().select(new String[]{year + " as year", month + " as month", "0 as periodbeginqty", "0 as periodbeginactualcost"});
                zeroPeriodBeginDataSet = i == 0 ? dataSet : (zeroPeriodBeginDataSet != null ? zeroPeriodBeginDataSet.union(dataSet) : dataSet);
            }
        }
        DataSet dataSet = null;
        String beginSelect = "material as currentMaterialId,periodendqty as periodbeginqty,periodendactualcost as periodbeginactualcost,yearinqty,yearinactualcost,yearissueqty,yearissueactualcost";
        dataSet = this.getDataSet(this.isNewBalance ? "cal_bal" : "cal_balance", beginSelect, this.periodNumberList);
        dataSet = dataSet.groupBy(new String[]{"currentMaterialId", "year", "month"}).sum("periodbeginqty").sum("periodbeginactualcost").finish();
        if (zeroPeriodBeginDataSet != null) {
            zeroPeriodBeginDataSet = zeroPeriodBeginDataSet.join(dataSet, JoinType.LEFT).on("year", "year").on("month", "month").select(new String[]{"year", "month"}, new String[]{"periodbeginqty", "periodbeginactualcost"}).finish();
            return zeroPeriodBeginDataSet.select(this.getPeriodBeginFinalSelects().split(","));
        }
        return dataSet.select(this.getPeriodBeginFinalSelects().split(","));
    }

    private DataSet calPeriodEndDataSet(DataSet dataSet) {
        return dataSet.orderBy(this.getCalperiodEndOrderByField()).select((this.getTempSelects() + ",case when PreRowValue(year) = year and PreRowValue(period) = period then PreRowValue(periodendqty) + periodinqtybak - periodoutqty else periodinqtybak - periodoutqty end periodendqty,case when PreRowValue(year) = year and PreRowValue(period) = period then PreRowValue(periodendamount) + periodinamountbak - periodoutamount else periodinamountbak - periodoutamount end periodendamount,unitprice,billid,bizentityobject,ordercol_second").split(","));
    }

    private String[] getCalperiodEndOrderByField() {
        if (this.filter_mulaccounttype.size() == 1 && this.filter_mulaccounttype.contains("D")) {
            if ("A".equals(this.filter_ordertype)) {
                return new String[]{"year", "period", "ordercol_second", "calbilltype", "bookdate", "audittime"};
            }
            return new String[]{"year", "period", "ordercol_second", "calbilltype", "audittime", "bookdate"};
        }
        if ("A".equals(this.filter_ordertype)) {
            return new String[]{"year", "period", "ordercol_second", "bookdate", "audittime"};
        }
        return new String[]{"year", "period", "ordercol_second", "audittime", "bookdate"};
    }

    private DataSet filterByQtyCondition(DataSet periodTotalDataSet) {
        if (StringUtils.isNotEmpty((String)this.qtyShowCondition)) {
            String sign = "";
            if ("A".equals(this.qtyShowCondition)) {
                sign = "=";
            } else if ("B".equals(this.qtyShowCondition)) {
                sign = "<>";
            } else if ("C".equals(this.qtyShowCondition)) {
                sign = ">";
            } else if ("D".equals(this.qtyShowCondition)) {
                sign = "<";
            }
            return periodTotalDataSet.filter("periodendqty " + sign + " 0");
        }
        return periodTotalDataSet;
    }

    private DataSet filterByAmountCondition(DataSet periodTotalDataSet) {
        if (StringUtils.isNotEmpty((String)this.amountShowCondition)) {
            String sign = "";
            if ("A".equals(this.amountShowCondition)) {
                sign = "=";
            } else if ("B".equals(this.amountShowCondition)) {
                sign = "<>";
            } else if ("C".equals(this.amountShowCondition)) {
                sign = ">";
            } else if ("D".equals(this.amountShowCondition)) {
                sign = "<";
            }
            return periodTotalDataSet.filter("periodendamount " + sign + " 0");
        }
        return periodTotalDataSet;
    }

    private DataSet filterStratPeriod(DataSet dataSet) {
        DynamicObject startPeriod = this.filterInfo.getDynamicObject("startperiod");
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        QFilter q = new QFilter("year*100+period", ">=", (Object)startPeriodNumber);
        dataSet = dataSet.filter(q.toString());
        return dataSet;
    }

    private DataSet unionTotalDataSet(DataSet dataSet) {
        DataSet periodTotalDataSet = dataSet.copy().groupBy(new String[]{"year", "period"}).sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").minP("ordercol_second", "periodendqty").minP("ordercol_second", "periodendamount").finish().select(new String[]{"year", "period", "periodinqty", "periodinamount", "periodoutqty", "periodoutamount", "periodendqty+periodinqty-periodoutqty as periodendqty", "periodendamount+periodinamount-periodoutamount as periodendamount"}).select(this.getPeriodTotalFinalSelects().split(","));
        periodTotalDataSet = this.filterByQtyCondition(periodTotalDataSet);
        periodTotalDataSet = this.filterByAmountCondition(periodTotalDataSet);
        String validPeriod = null;
        StringBuilder sBuilder = new StringBuilder(16);
        for (Row row : periodTotalDataSet.copy()) {
            int year = row.getInteger("year");
            int period = row.getInteger("period");
            int periodNumber = year * 100 + period;
            sBuilder.append(periodNumber).append(",");
        }
        validPeriod = sBuilder.toString();
        if (!StringUtils.isEmpty((String)validPeriod)) {
            validPeriod = validPeriod.substring(0, validPeriod.length() - 1);
            dataSet = dataSet.filter("year*100+period in (" + validPeriod + ")");
        } else {
            dataSet = dataSet.filter("1 <> 1");
        }
        DataSet yearTotalDataSet = periodTotalDataSet.copy().groupBy(new String[]{"year"}).sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").finish();
        DataSet yearInOutDataSet = null;
        yearInOutDataSet = this.isNewBalance ? QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_initbill", (String)"period.periodyear as year,entryentity.yearinqty as yearinqty,entryentity.yearincost + entryentity.yearincostdiff as yearinactualcost,entryentity.yearissueqty as yearissueqty,entryentity.yearissuecost + entryentity.yearissuecostdiff as yearissueactualcost", (QFilter[])new QFilter[]{this.getInitBillFilter()}, null).groupBy(new String[]{"year"}).sum("yearinqty").sum("yearinactualcost").sum("yearissueqty").sum("yearissueactualcost").finish() : QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)"year,yearinqty,yearinactualcost,yearissueqty,yearissueactualcost", (QFilter[])new QFilter[]{this.getPeriodBeginBalFilter()}, null).groupBy(new String[]{"year"}).sum("yearinqty").sum("yearinactualcost").sum("yearissueqty").sum("yearissueactualcost").finish();
        yearTotalDataSet = yearTotalDataSet.join(yearInOutDataSet, JoinType.LEFT).on("year", "year").select(new String[]{"year", "0 as periodendqty", "0 as periodendamount", "periodinqty+yearinqty as periodinqty", "periodinamount+yearinactualcost as periodinamount", "periodoutqty+yearissueqty as periodoutqty", "periodoutamount+yearissueactualcost as periodoutamount"}).finish().select(this.getYearTotalFinalSelects().split(","));
        return dataSet.addField("0", "ordercol_first").union(periodTotalDataSet.addField("1", "ordercol_second").addField("1", "ordercol_first")).union(yearTotalDataSet.addField("1", "ordercol_second").addField("2", "ordercol_first"));
    }

    private DataSet topSumRow(DataSet dataSet) {
        if (this.topSumRow) {
            if (this.filter_mulaccounttype.size() == 1 && this.filter_mulaccounttype.contains("D")) {
                if ("A".equals(this.filter_ordertype)) {
                    return dataSet.orderBy(new String[]{"year", "period", "ordercol_first desc", "ordercol_second", "calbilltype", "bookdate", "audittime"});
                }
                return dataSet.orderBy(new String[]{"year", "period", "ordercol_first desc", "ordercol_second", "calbilltype", "audittime", "bookdate"});
            }
            if ("A".equals(this.filter_ordertype)) {
                return dataSet.orderBy(new String[]{"year", "period", "ordercol_first desc", "ordercol_second", "bookdate", "audittime"});
            }
            return dataSet.orderBy(new String[]{"year", "period", "ordercol_first desc", "ordercol_second", "audittime", "bookdate"});
        }
        if (this.filter_mulaccounttype.size() == 1 && this.filter_mulaccounttype.contains("D")) {
            if ("A".equals(this.filter_ordertype)) {
                return dataSet.orderBy(new String[]{"year", "period", "ordercol_first", "ordercol_second", "calbilltype", "bookdate", "audittime"});
            }
            return dataSet.orderBy(new String[]{"year", "period", "ordercol_first", "ordercol_second", "calbilltype", "audittime", "bookdate"});
        }
        if ("A".equals(this.filter_ordertype)) {
            return dataSet.orderBy(new String[]{"year", "period", "ordercol_first", "ordercol_second", "bookdate", "audittime"});
        }
        return dataSet.orderBy(new String[]{"year", "period", "ordercol_first", "ordercol_second", "audittime", "bookdate"});
    }

    private DataSet onlyShowSumRow(DataSet dataSet) {
        if (this.onlyShowSumRow) {
            return dataSet.filter("ordercol_first <> 0");
        }
        return dataSet;
    }

    private QFilter getPeriodBeginBalFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("material", "=", (Object)this.materialId);
        q.and("period", "=", (Object)0);
        q.and("year*100+month", ">=", (Object)this.filter_startPeriodNumber);
        q.and("year*100+month", "<=", (Object)this.filter_endPeriodNumber);
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_balance");
        if (this.filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("project", "in", set);
        }
        if (this.filter_tracknumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_tracknumber) {
                set.add(info.getPkValue());
            }
            q.and("tracknumber", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("invstatus", "in", set);
        }
        if (this.filter_mulcalrange != null) {
            set = new HashSet();
            for (DynamicObject dynamicObject : this.filter_mulcalrange) {
                set.add(dynamicObject.getPkValue());
            }
            q.and("calrange", "in", set);
        }
        if (!this.filter_mulaccounttype.isEmpty()) {
            q.and("accounttype", "in", this.filter_mulaccounttype);
        }
        return q;
    }

    private QFilter getInitBillFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("entryentity.material", "=", (Object)this.materialId);
        q.and("billstatus", "=", (Object)"C");
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costadjustbill");
        if (this.filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("entryentity.lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.project", "in", set);
        }
        if (this.filter_tracknumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_tracknumber) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.tracknumber", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invstatus", "in", set);
        }
        if (this.filter_mulcalrange != null) {
            set = new HashSet();
            for (DynamicObject dynamicObject : this.filter_mulcalrange) {
                set.add(dynamicObject.getPkValue());
            }
            logger.info("------------------------calrange:" + set);
            q.and("entryentity.calrange", "in", set);
        }
        if (!this.filter_mulaccounttype.isEmpty()) {
            q.and("entryentity.accounttype", "in", this.filter_mulaccounttype);
        }
        return q;
    }

    private String getPeriodBeginFinalSelects() {
        String s = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"StockDetailRptQueryPlugin_14", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("year as year,month as period,null as bizdate,null as bookdate,null as audittime,'0' as isvoucher,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,null as comment,null as ownertype,0 as owner,null as storageorgnumber,null as storageorgname,");
        select.append("null as warehousenumber,null as warehousename,");
        select.append("null as warehsgroupnumber,null as warehsgroupname,null as locationnumber,null as locationname,null as lot,");
        select.append("null as assist,null as projectname,null as tracknumber,");
        select.append("0 as periodinqty,0 as periodinamount,");
        select.append("0 as periodoutqty,0 as periodoutamount,");
        select.append("0 as periodendqty,0 as periodendamount,");
        select.append("0 as unitprice,");
        select.append("periodbeginqty as periodinqtybak,periodbeginactualcost as periodinamountbak,");
        select.append("0 as billid,null as bizentityobject,null as entryid,null as srcobject");
        return select.toString();
    }

    private String getPeriodTotalFinalSelects() {
        String s = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"StockDetailRptQueryPlugin_24", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("year as year,period as period,null as bizdate,null as bookdate,null as audittime,'0' as isvoucher,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,null as ownertype,null as comment,0 as owner,null as storageorgnumber,null as storageorgname,");
        select.append("null as warehousenumber,null as warehousename,null as warehsgroupnumber,null as warehsgroupname,null as locationnumber,null as locationname,null as lot,");
        select.append("null as assist,null as projectname,null as tracknumber,null as entryid,null as srcobject,");
        select.append("periodinqty as periodinqty,periodinamount as periodinamount,");
        select.append("periodoutqty as periodoutqty,periodoutamount as periodoutamount,");
        select.append("periodendqty as periodendqty,periodendamount as periodendamount,");
        select.append("0 as unitprice,");
        select.append("0 as billid,null as bizentityobject");
        return select.toString();
    }

    private String getYearTotalFinalSelects() {
        String s = ResManager.loadKDString((String)"\u672c\u5e74\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_31", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        int period = 99;
        if (this.topSumRow) {
            period = 0;
        }
        select.append("year as year,");
        select.append(period);
        select.append(" as period,");
        select.append("null as bizdate,null as bookdate,null as audittime,'0' as isvoucher,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,null as comment,null as ownertype,0 as owner,null as storageorgnumber,null as storageorgname,");
        select.append("null as warehousenumber,null as warehousename,null as warehsgroupnumber,null as warehsgroupname,");
        select.append("null as locationnumber,null as locationname,null as lot,");
        select.append("null as assist,null as projectname,null as tracknumber,null as entryid,null as srcobject,");
        select.append("periodinqty as periodinqty,periodinamount as periodinamount,");
        select.append("periodoutqty as periodoutqty,periodoutamount as periodoutamount,");
        select.append("periodendqty as periodendqty,periodendamount as periodendamount,");
        select.append("0 as unitprice,");
        select.append("0 as billid,null as bizentityobject");
        return select.toString();
    }

    private String getTempSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,comment,ownertype,owner,storageorgnumber,storageorgname,");
        select.append("warehousenumber,warehousename,warehsgroupnumber,warehsgroupname,locationnumber,locationname,lot,");
        select.append("assist,projectname,tracknumber,entryid,srcobject,");
        select.append("periodinqty,periodinamount,");
        select.append("periodoutqty,periodoutamount");
        return select.toString();
    }

    private String getAliasSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,storageorgnumber,storageorgname,");
        select.append("warehousenumber,warehousename,warehsgroupnumber,warehsgroupname,locationnumber,locationname,lot,");
        select.append("assist,projectname,tracknumber,");
        select.append("periodinqty,periodinamount,");
        select.append("periodoutqty,periodoutamount,");
        select.append("periodendqty,periodendamount,");
        select.append("unitprice,");
        select.append("periodinqtybak,periodinamountbak,");
        select.append("billid,bizentityobject,entryid,srcobject");
        return select.toString();
    }

    private String getFinalSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,case when period = 99 then 0 else period end as period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,comment,storageorgnumber,storageorgname,");
        select.append("ownertype,owner,owner as ownernumber,warehousenumber,warehousename,warehsgroupnumber,warehsgroupname,locationnumber,locationname,lot,");
        select.append("assist as assistproperty,projectname,tracknumber,");
        select.append("periodinqty,periodinamount,");
        select.append("periodoutqty,periodoutamount,");
        select.append("periodendqty,periodendamount,");
        select.append(this.getPriceSelect("periodinamount", "periodinqty")).append(" as periodinprice,");
        select.append(this.getPriceSelect("periodoutamount", "periodoutqty")).append(" as periodoutprice,");
        select.append(this.getEndPriceSelect("periodendamount", "periodendqty")).append(" as periodendprice,");
        select.append(this.baseUnitId).append(" as baseunitid,").append(this.currencyId).append(" as currencyid,");
        if (this.showdetail && this.onlyShowSumRow) {
            select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname,");
        }
        select.append("billid,bizentityobject").append(",").append(this.materialId).append(" as materialid");
        return select.toString();
    }

    private String getEndPriceSelect(String amount, String qty) {
        return "case when  " + qty + " = 0 then 0 else " + amount + "/" + qty + " end ";
    }

    private String getPriceSelect(String amount, String qty) {
        return "case when unitprice <> 0  and " + qty + " <> 0 then unitprice when " + qty + " = 0 then 0 else " + amount + "/" + qty + " end ";
    }

    private void createDecimalColumns(List<AbstractReportColumn> cols) {
        this.createDecimalColumn(cols, this.locale_periodIn, "periodin");
        this.createDecimalColumn(cols, this.locale_periodOut, "periodout");
        this.createDecimalColumn(cols, this.locale_periodEnd, "periodend");
    }

    private void createCostElementColumns(List<AbstractReportColumn> cols) {
        if (this.showdetail && !this.onlyShowSumRow) {
            this.createCostDetailColumns(cols);
        }
    }

    private void createCostDetailColumns(List<AbstractReportColumn> cols) {
        ReportColumn costelementNum = new ReportColumn();
        costelementNum.setCaption(this.locale_costelementNum);
        costelementNum.setWidth(width);
        costelementNum.setFieldKey("costelementnumber");
        costelementNum.setFieldType("text");
        cols.add((AbstractReportColumn)costelementNum);
        ReportColumn costelementName = new ReportColumn();
        costelementName.setCaption(this.locale_costelementName);
        costelementName.setWidth(width);
        costelementName.setFieldKey("costelementname");
        costelementName.setFieldType("text");
        cols.add((AbstractReportColumn)costelementName);
        ReportColumn costsubelementNum = new ReportColumn();
        costsubelementNum.setCaption(this.locale_costsubelementNum);
        costsubelementNum.setWidth(width);
        costsubelementNum.setFieldKey("costsubelementnumber");
        costsubelementNum.setFieldType("text");
        cols.add((AbstractReportColumn)costsubelementNum);
        ReportColumn costsubelementName = new ReportColumn();
        costsubelementName.setCaption(this.locale_costsubelementName);
        costsubelementName.setWidth(width);
        costsubelementName.setFieldKey("costsubelementname");
        costsubelementName.setFieldType("text");
        cols.add((AbstractReportColumn)costsubelementName);
    }

    private void createDecimalColumn(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey);
        cols.add((AbstractReportColumn)groupCol);
        ReportColumn qty = new ReportColumn();
        qty.setCaption(this.locale_qty);
        qty.setWidth(width);
        qty.setFieldKey(fieldKey + "qty");
        qty.setFieldType("qty");
        qty.setMeasureUnitField("baseunitid");
        ReportColumn price = new ReportColumn();
        price.setCaption(this.locale_price);
        price.setWidth(width);
        price.setFieldKey(fieldKey + "price");
        price.setFieldType("price");
        price.setCurrencyField("currencyid");
        ReportColumn amount = new ReportColumn();
        amount.setCaption(this.locale_amount);
        amount.setWidth(width);
        amount.setFieldKey(fieldKey + "amount");
        amount.setFieldType("amount");
        amount.setCurrencyField("currencyid");
        groupCol.getChildren().add(qty);
        groupCol.getChildren().add(price);
        groupCol.getChildren().add(amount);
    }

    private void createHideColumns(List<AbstractReportColumn> cols) {
        ReportColumn baseUnitId = new ReportColumn();
        baseUnitId.setCaption(this.locale_baseUnit);
        baseUnitId.setWidth(width);
        baseUnitId.setFieldKey("baseunitid");
        baseUnitId.setFieldType("unit");
        baseUnitId.setEntityId("bd_measureunits");
        baseUnitId.setHide(true);
        ReportColumn currencyId = new ReportColumn();
        currencyId.setCaption(this.locale_currency);
        currencyId.setWidth(width);
        currencyId.setFieldKey("currencyid");
        currencyId.setFieldType("currency");
        currencyId.setEntityId("bd_currency");
        currencyId.setHide(true);
        ReportColumn bizEntityObject = new ReportColumn();
        bizEntityObject.setCaption(this.locale_currency);
        bizEntityObject.setWidth(width);
        bizEntityObject.setFieldKey("bizentityobject");
        bizEntityObject.setFieldType("text");
        bizEntityObject.setHide(true);
        ReportColumn billId = new ReportColumn();
        billId.setCaption(this.locale_currency);
        billId.setWidth(width);
        billId.setFieldKey("billid");
        billId.setFieldType("text");
        billId.setHide(true);
        ReportColumn currentMaterialId = new ReportColumn();
        currentMaterialId.setCaption(this.locale_currency);
        currentMaterialId.setWidth(width);
        currentMaterialId.setFieldKey("currentMateiralId");
        currentMaterialId.setFieldType("text");
        currentMaterialId.setHide(true);
        ReportColumn currentPrecision = new ReportColumn();
        currentPrecision.setCaption(this.locale_currency);
        currentPrecision.setWidth(width);
        currentPrecision.setFieldKey("head_precision");
        currentPrecision.setFieldType("text");
        currentPrecision.setHide(true);
        cols.add((AbstractReportColumn)baseUnitId);
        cols.add((AbstractReportColumn)currencyId);
        cols.add((AbstractReportColumn)bizEntityObject);
        cols.add((AbstractReportColumn)billId);
        cols.add((AbstractReportColumn)currentMaterialId);
        cols.add((AbstractReportColumn)currentPrecision);
    }

    private DataSet getDetailByBatch(Set<Object> ids, String entityName, String selectFields) {
        if (ids == null || ids.size() < 1) {
            QFilter qFilter = QFilter.of((String)"1<>1", (Object[])new Object[0]);
            return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
        }
        List<Set<Object>> balIdsArray = this.getBatchIdList(ids);
        DataSet detailDataSet = null;
        for (int arrayIndex = 0; arrayIndex < balIdsArray.size(); ++arrayIndex) {
            QFilter qFilter = new QFilter("entryid", "in", balIdsArray.get(arrayIndex));
            DataSet currDetailDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
            detailDataSet = detailDataSet == null ? currDetailDataSet : detailDataSet.union(currDetailDataSet);
        }
        if (detailDataSet == null) {
            QFilter qFilter = QFilter.of((String)"1<>1", (Object[])new Object[0]);
            return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
        }
        return detailDataSet;
    }

    private List<Set<Object>> getBatchIdList(Set<Object> ids) {
        ArrayList<Set<Object>> balIdsArray = new ArrayList<Set<Object>>(16);
        HashSet<Object> balIds = null;
        long index = 0L;
        for (Object id : ids) {
            if (index % 100000L == 0L) {
                balIds = new HashSet<Object>();
                balIdsArray.add(balIds);
            }
            if (balIds != null) {
                balIds.add(id);
            }
            ++index;
        }
        return balIdsArray;
    }

    private DataSet getDataSet(String tableName, String selectFields, List<Integer> periods) {
        DataSet balanceSet = null;
        ArrayList<DataSet> list = new ArrayList<DataSet>(16);
        for (Integer period : periods) {
            DataSet result;
            if (this.isNewBalance) {
                String dimFields = CalBalanceModelHelper.getDimFields((boolean)false) + ",year";
                String[] groupSelectField = dimFields.split(",");
                String newBalanceSelectField = dimFields + ",baseqty_bal as periodbeginqty,actualcost_bal as periodbeginactualcost";
                QFilter q = this.getPeriodBeginBalNewFilter(tableName, period);
                DataSet newBalanceSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)tableName, (String)newBalanceSelectField, (QFilter[])new QFilter[]{q}, null);
                String balanceFields = "material as currentMaterialId,periodbeginqty,periodbeginactualcost,year";
                result = newBalanceSet.groupBy(groupSelectField).max("periodbeginqty").sum("periodbeginactualcost").finish().select(balanceFields);
            } else {
                QFilter q = this.getPeriodBeginBalNewFilter(tableName, period);
                result = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)tableName, (String)selectFields, (QFilter[])new QFilter[]{q}, null);
            }
            result = result.addField(period / 100 + "", "year");
            result = result.addField(period % 100 + "", "month");
            if (balanceSet == null) {
                balanceSet = result;
                continue;
            }
            list.add(result);
        }
        DataSet[] rest = list.toArray(new DataSet[list.size()]);
        balanceSet = balanceSet == null ? this.getDefaultEmptyDataSet(tableName) : balanceSet;
        return rest.length == 0 ? balanceSet : balanceSet.union(rest);
    }

    public DataSet getDefaultEmptyDataSet(String tableName) {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)tableName, (String)"id", (QFilter[])new QFilter("id", "=", (Object)0L).toArray(), null);
    }

    private QFilter getPeriodBeginBalNewFilter(String tableName, Integer periodNumber) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("material", "=", (Object)this.materialId);
        q.and("period", "<", (Object)periodNumber);
        q.and("endperiod", ">=", (Object)periodNumber);
        if ("cal_bal".equals(tableName)) {
            ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_bal");
        } else if ("cal_balance".equals(tableName)) {
            ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_balance");
        }
        if (this.filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("project", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("invstatus", "in", set);
        }
        if (this.filter_mulcalrange != null) {
            set = new HashSet();
            for (DynamicObject dynamicObject : this.filter_mulcalrange) {
                set.add(dynamicObject.getPkValue());
            }
            q.and("calrange", "in", set);
        }
        if (!this.filter_mulaccounttype.isEmpty()) {
            q.and("accounttype", "in", this.filter_mulaccounttype);
        }
        return q;
    }
}

