/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.DiffJsonEntryServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.ReportUtil;

public class StockDifferDetailRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(StockDifferDetailRptQueryPlugin.class);
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private DynamicObjectCollection filter_calrange;
    private DynamicObject filter_startPeriod;
    private DynamicObject filter_endPeriod;
    private int filter_startPeriodNumber;
    private int filter_endPeriodNumber;
    private List<Integer> periodNumberList = new ArrayList<Integer>();
    private boolean onlyShowSumRow;
    private boolean topSumRow;
    private boolean noShowZeroInOut;
    private boolean showdetail;
    private long baseUnitId;
    private long currencyId;
    private String filter_ownertype;
    private DynamicObjectCollection filter_ownerFrom;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private String[] filter_lot;
    private DynamicObjectCollection filter_project;
    private DynamicObjectCollection filter_invType;
    private DynamicObjectCollection filter_invStatus;
    private DynamicObjectCollection filter_billType;
    private DynamicObjectCollection filter_trackNumber;
    private String billno;
    private Date filter_startDate;
    private Date filter_endDate;
    private long materialId;
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private LocaleString locale_costelementNum = new LocaleString(this.getLocale_costelementNum());
    private LocaleString locale_costelementName = new LocaleString(this.getLocale_costelementName());
    private LocaleString locale_costsubelementNum = new LocaleString(this.getLocale_costsubelementNum());
    private LocaleString locale_costsubelementName = new LocaleString(this.getLocale_costsubelementName());
    private LocaleString locale_baseUnit = new LocaleString(this.getLocale_baseUnit());
    private LocaleString locale_periodIn = new LocaleString(this.getLocale_periodIn());
    private LocaleString locale_periodOut = new LocaleString(this.getLocale_periodOut());
    private LocaleString locale_periodEnd = new LocaleString(this.getLocale_periodEnd());
    private LocaleString locale_qty = new LocaleString(this.getLocale_qty());
    private LocaleString locale_price = new LocaleString(this.getLocale_price());
    private LocaleString locale_standardAmount = new LocaleString(this.getLocale_standardAmount());
    private LocaleString locale_actualAmount = new LocaleString(this.getLocale_actualAmount());
    private LocaleString locale_differAmount = new LocaleString(this.getLocale_differAmount());
    private LocaleString locale_currency = new LocaleString(this.getLocale_currency());
    private static final LocaleString width = new LocaleString("100px");
    private static final int BATCH_SIZE = 100000;

    private String getLocale_costelementNum() {
        return ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u7f16\u7801", (String)"StockDetailRptQueryPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costelementName() {
        return ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u540d\u79f0", (String)"StockDetailRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costsubelementNum() {
        return ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801", (String)"StockDetailRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costsubelementName() {
        return ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u540d\u79f0", (String)"StockDetailRptQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_baseUnit() {
        return ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"StockDetailRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodIn() {
        return ResManager.loadKDString((String)"\u672c\u671f\u6536\u5165", (String)"StockDetailRptQueryPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodOut() {
        return ResManager.loadKDString((String)"\u672c\u671f\u53d1\u51fa", (String)"StockDetailRptQueryPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodEnd() {
        return ResManager.loadKDString((String)"\u671f\u672b\u7ed3\u5b58", (String)"StockDetailRptQueryPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_qty() {
        return ResManager.loadKDString((String)"\u6570\u91cf", (String)"StockDetailRptQueryPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_price() {
        return ResManager.loadKDString((String)"\u5355\u4ef7", (String)"StockDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_standardAmount() {
        return ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c", (String)"StockDifferGroupRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_actualAmount() {
        return ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c", (String)"StockDifferGroupRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_differAmount() {
        return ResManager.loadKDString((String)"\u5dee\u5f02", (String)"StockDifferGroupRptQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_currency() {
        return ResManager.loadKDString((String)"\u5e01\u79cd", (String)"StockDetailRptQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        try {
            this.init(param);
            DataSet dataSet = this.getCostRecordDataSet();
            if (this.materialId == -1L) {
                return dataSet;
            }
            DataSet costDiffbillDataSet = this.getCalStdcostDiffbillDataSet();
            dataSet = dataSet.union(costDiffbillDataSet);
            dataSet = this.dealActualCost(dataSet);
            dataSet = this.filterByAllZeroCondition(dataSet);
            if (this.noShowZeroInOut && dataSet.copy().isEmpty()) {
                return dataSet;
            }
            dataSet = this.unionPeriodBeginDataSet(dataSet);
            dataSet = this.calPeriodEndDataSet(dataSet);
            dataSet = this.filterStartPeriod(dataSet);
            dataSet = this.unionTotalDataSet(dataSet);
            dataSet = this.unionDetailDataSet(dataSet);
            dataSet = this.topSumRow(dataSet);
            dataSet = this.onlyShowSumRow(dataSet);
            dataSet = dataSet.select(this.getFinalSelects().split(",")).addField("owner", "ownernumber");
            return dataSet;
        }
        catch (Exception e) {
            StringBuilder sBuilder = new StringBuilder("stockDifferDetailRpt=?");
            if (e instanceof KDBizException) {
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage());
                }
            } else {
                StackTraceElement[] errs;
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage()).append("\n");
                }
                for (StackTraceElement err : errs = e.getStackTrace()) {
                    sBuilder.append(err.toString()).append("\n");
                }
            }
            logger.info(sBuilder.toString());
            throw e;
        }
    }

    private DataSet dealActualCost(DataSet dataSet) {
        return dataSet.select(this.getAliasSelects().split(","));
    }

    private DataSet filterByAllZeroCondition(DataSet calDataSet) {
        StringBuilder select = new StringBuilder();
        select.append("periodinqty <> 0 or periodinstandardamount <> 0 or periodindifferamount <> 0 or ");
        select.append("periodoutqty <> 0 or periodoutstandardamount <> 0 or periodoutdifferamount <> 0 ");
        calDataSet = calDataSet.filter(select.toString());
        return calDataSet;
    }

    private DataSet unionDetailDataSet(DataSet dataSet) {
        if (this.showdetail && !this.onlyShowSumRow) {
            DataSet tempDataSet = dataSet.copy();
            HashSet<Object> costRecordEntryIds = new HashSet<Object>();
            HashSet<Object> costAdjustEntryIds = new HashSet<Object>();
            HashSet<Object> costDiffbillIEntryIds = new HashSet<Object>();
            for (Row row : tempDataSet) {
                Object entryId = row.get("entryid");
                String srcObject = row.getString("srcObject");
                if ("costadjustbill".equals(srcObject) && entryId != null) {
                    costAdjustEntryIds.add(entryId);
                    continue;
                }
                if ("costrecord".equals(srcObject) && entryId != null) {
                    costRecordEntryIds.add(entryId);
                    continue;
                }
                if (!"stdcostdiffbill".equals(srcObject) || entryId == null) continue;
                costDiffbillIEntryIds.add(entryId);
            }
            DataSet costRecordDataset = dataSet.copy().filter("srcObject = 'costrecord'");
            DataSet adjustDataset = dataSet.copy().filter("srcObject = 'costadjustbill'");
            DataSet costdiffbillDataset = dataSet.copy().filter("srcObject = 'stdcostdiffbill'");
            DataSet costRecordDetailDataSet = this.getDetailByBatch(costRecordEntryIds, "cal_costrecord_detail", this.getCostRecordDetailSelects());
            DataSet adjustDetailDataSet = this.getDetailByBatch(costAdjustEntryIds, "cal_costadjust_detail", this.getCostAdjustDetailSelects()).filter("differ != 0");
            QFilter filter = new QFilter("entryentity.id", "in", costDiffbillIEntryIds);
            DataSet costdiffbillDetailDataSet = DiffJsonEntryServiceHelper.queryJsonSubEntryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)this.getCostDiffbillDetailSelects(), (String)"entryentity.subentryentity", (QFilter[])filter.toArray(), null).filter("sub_adjustamt != 0");
            DataSet cadelementdataset = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cad_element", (String)"id,number,name", null, null);
            costdiffbillDetailDataSet = costdiffbillDetailDataSet.leftJoin(cadelementdataset).on("costelement", "id").select(costdiffbillDetailDataSet.getRowMeta().getFieldNames(), new String[]{"name as costelementname", "number as costelementnumber"}).finish();
            DataSet cadsubelementdataset = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cad_subelement", (String)"id,number,name", null, null);
            costdiffbillDetailDataSet = costdiffbillDetailDataSet.leftJoin(cadsubelementdataset).on("costsubelement", "id").select(costdiffbillDetailDataSet.getRowMeta().getFieldNames(), new String[]{"name as costsubelementname", "number as costsubelementnumber"}).finish();
            DataSet extCostRecordDetailDataSet = costRecordDataset.join(costRecordDetailDataSet, JoinType.LEFT).on("entryid", "entryid").on("srcobject", "srcobject").select(this.getLeftSelects(), this.getRightSelects()).finish().filter("standardcost != 0").select(this.getExtCostRecordDetailSelects());
            DataSet extAdjustDetailDataSet = adjustDataset.join(adjustDetailDataSet, JoinType.LEFT).on("entryid", "entryid").on("srcobject", "srcobject").select(this.getLeftSelects(), this.getRightSelects()).finish().filter("differ != 0").select(this.getExtAdjustDetailSelects());
            DataSet extDiffbillDetailDataSet = costdiffbillDataset.join(costdiffbillDetailDataSet, JoinType.LEFT).on("entryid", "entryid").on("srcobject", "srcobject").select(this.getLeftSelects(), this.getDiffRightSelects()).finish().filter("sub_adjustamt != 0").select(this.getExtCostdiffbillDetailSelects());
            DataSet detailDataSet = extCostRecordDetailDataSet.union(extAdjustDetailDataSet).union(extDiffbillDetailDataSet).where("ordercol_first=0 and ordercol_second=2 and bookdate != null").addField("0", "orderval");
            dataSet = dataSet.addNullField("costelementnumber").addField(ResManager.loadKDString((String)"'\u5c0f\u8ba1'", (String)"StockDetailRptQueryPlugin_12", (String)"fi-cal-report", (Object[])new Object[0]), "costelementname").addNullField("costsubelementnumber").addNullField("costsubelementname").addField("1", "orderval").union(detailDataSet);
        } else {
            dataSet = dataSet.addNullField("orderval");
        }
        return dataSet;
    }

    private String[] getExtCostRecordDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,storageorgnumber,storageorgname,ownertype,owner,");
        select.append("warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,lot,tracknumber,");
        select.append("assist,projectname,entryid,srcobject,difftype,createtype,billsrctype,");
        select.append("0 as periodinqty,case when calbilltype = 'IN' then actualcost else 0 end as periodinamount,");
        select.append("0 as periodindifferamount,case when calbilltype = 'IN' then standardcost else 0 end as periodinstandardamount,");
        select.append("0 as periodoutqty,case when calbilltype = 'OUT' then actualcost else 0 end as periodoutamount,");
        select.append("0 as periodoutdifferamount,case when calbilltype = 'OUT' then standardcost else 0 end as periodoutstandardamount,");
        select.append("0 as periodendqty,0 as periodendamount,0 as periodenddifferamount,0 as periodendstandardamount,");
        select.append("unitprice,");
        select.append("billid,bizentityobject,");
        select.append("2 as ordercol_second, 0 as ordercol_first,");
        select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname");
        return select.toString().split(",");
    }

    private String[] getExtAdjustDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,storageorgnumber,storageorgname,ownertype,owner,");
        select.append("warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,lot,tracknumber,");
        select.append("assist,projectname,entryid,srcobject,difftype,createtype,billsrctype,");
        select.append("0 as periodinqty,case when calbilltype = 'IN' AND difftype != 'M' then differ ");
        select.append("when calbilltype = 'IN' AND difftype = 'M' and createtype != 'C1' then differ else 0 end as periodinamount,");
        select.append("case when calbilltype = 'IN' and difftype <> 'B' AND difftype != 'M' then differ ");
        select.append(" when calbilltype = 'IN' AND difftype = 'M' then differ else 0 end as periodindifferamount,");
        select.append("case when calbilltype = 'IN' and difftype = 'B' AND difftype != 'M' then differ ");
        select.append(" when calbilltype = 'IN' and difftype = 'M' and createtype = 'C1' then (0-differ)  else 0 end as periodinstandardamount,");
        select.append("0 as periodoutqty, case when calbilltype = 'OUT' AND difftype != 'M' then differ ");
        select.append("when calbilltype = 'OUT' AND difftype = 'M' and createtype != 'C1' then differ else 0 end as periodoutamount,");
        select.append("case when calbilltype = 'OUT' and difftype <> 'B' AND difftype != 'M' then differ ");
        select.append(" when calbilltype = 'OUT' AND difftype = 'M' then differ else 0 end as periodoutdifferamount,");
        select.append("case when calbilltype = 'OUT' and difftype = 'B' AND difftype != 'M' then differ ");
        select.append(" when calbilltype = 'OUT' and difftype = 'M' and createtype = 'C1' then (0-differ)  else 0 end as periodoutstandardamount,");
        select.append("0 as periodendqty,0 as periodendamount,0 as periodenddifferamount,0 as periodendstandardamount,");
        select.append("unitprice,");
        select.append("billid,bizentityobject,");
        select.append("2 as ordercol_second, 0 as ordercol_first,");
        select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname");
        return select.toString().split(",");
    }

    private String[] getExtCostdiffbillDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,storageorgnumber,storageorgname,ownertype,owner,");
        select.append("warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,lot,tracknumber,");
        select.append("assist,projectname,entryid,srcobject,difftype,createtype,billsrctype,");
        select.append("0 as periodinqty,case when calbilltype = 'IN' AND createtype != 'C1' then ddiff_m ");
        select.append("when calbilltype = 'IN' then (sub_adjustamt-ddiff_m) else 0 end as periodinamount,");
        select.append("case when calbilltype = 'IN' then sub_adjustamt else 0 end as periodindifferamount,");
        select.append("case when calbilltype = 'IN' and createtype = 'C1' then (0-ddiff_m)  else 0 end as periodinstandardamount,");
        select.append("0 as periodoutqty, case when calbilltype = 'OUT' AND createtype != 'C1' then ddiff_m ");
        select.append("when calbilltype = 'OUT' then (sub_adjustamt-ddiff_m) else 0 end as periodoutamount,");
        select.append("case when calbilltype = 'OUT' then sub_adjustamt else 0 end as periodoutdifferamount,");
        select.append("case when calbilltype = 'OUT' and createtype = 'C1' then (0-ddiff_m)  else 0 end as periodoutstandardamount,");
        select.append("0 as periodendqty,0 as periodendamount,0 as periodenddifferamount,0 as periodendstandardamount,");
        select.append("unitprice,");
        select.append("billid,bizentityobject,");
        select.append("2 as ordercol_second, 0 as ordercol_first,");
        select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname");
        return select.toString().split(",");
    }

    private String[] getRightSelects() {
        StringBuilder select = new StringBuilder();
        select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname,");
        select.append("actualcost,differ,standardcost");
        return select.toString().split(",");
    }

    private String[] getDiffRightSelects() {
        StringBuilder select = new StringBuilder();
        select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname,");
        select.append("actualcost,sub_adjustamt,ddiff_m,standardcost");
        return select.toString().split(",");
    }

    private String[] getLeftSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,storageorgnumber,storageorgname,ownertype,owner,");
        select.append("warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,lot,tracknumber,");
        select.append("assist,projectname,entryid,srcobject,difftype,createtype,billsrctype,");
        select.append("periodinqty,periodinamount,periodindifferamount,periodinstandardamount,");
        select.append("periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount,");
        select.append("periodendqty,periodendamount,periodenddifferamount,periodendstandardamount,");
        select.append("unitprice,");
        select.append("billid,bizentityobject,");
        select.append("ordercol_second,ordercol_first");
        return select.toString().split(",");
    }

    private String getCostAdjustDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("entryid,costelement.number as costelementnumber,costelement.name as costelementname,costsubelement.number as costsubelementnumber,costsubelement.name as costsubelementname,");
        select.append("0 as actualcost,");
        select.append("case when adjustamt = null then 0 else adjustamt end as differ,0 as standardcost,");
        select.append("'costadjustbill' as srcobject");
        return select.toString();
    }

    private String getCostDiffbillDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("entryentity.id as entryid,entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,");
        select.append("0 as actualcost,");
        select.append("entryentity.subentryentity.sub_adjustamt as sub_adjustamt,0 as standardcost,entryentity.subentryentity.ddiff_m as ddiff_m,");
        select.append("'stdcostdiffbill' as srcobject");
        return select.toString();
    }

    private String getCostRecordDetailSelects() {
        StringBuilder select = new StringBuilder();
        select.append("entryid,costelement.number as costelementnumber,costelement.name as costelementname,costsubelement.number as costsubelementnumber,costsubelement.name as costsubelementname,");
        select.append("case when standardcost = null then 0 else standardcost end as actualcost,null as differ,");
        select.append("case when standardcost = null then 0 else standardcost end as standardcost,");
        select.append("'costrecord' as srcobject");
        return select.toString();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        this.createCostElementColumns(cols);
        this.createDecimalColumns(cols);
        this.createHideColumns(cols);
        return cols;
    }

    private void init(ReportQueryParam param) {
        this.filterInfo = param.getFilter();
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.filter_calrange = this.filterInfo.getDynamicObjectCollection("mulcalrange");
        this.filter_startPeriod = PeriodHelper.getStartPeriod((Long)this.filter_costAccount.getLong("id"));
        this.filter_endPeriod = this.filterInfo.getDynamicObject("endperiod");
        this.filter_startPeriodNumber = this.filter_startPeriod.getInt("periodyear") * 100 + this.filter_startPeriod.getInt("periodnumber");
        this.filter_endPeriodNumber = this.filter_endPeriod.getInt("periodyear") * 100 + this.filter_endPeriod.getInt("periodnumber");
        this.filter_startDate = this.filter_startPeriod.getDate("begindate");
        this.filter_endDate = this.filter_endPeriod.getDate("enddate");
        this.onlyShowSumRow = this.filterInfo.getBoolean("onlyshowsumrow");
        this.topSumRow = this.filterInfo.getBoolean("topsumrow");
        this.billno = this.filterInfo.getString("fbillno");
        this.showdetail = this.filterInfo.getBoolean("showdetail");
        Object calPolicyId = this.filter_costAccount.getDynamicObject("calpolicy").getPkValue();
        DynamicObject calPolicy = BusinessDataServiceHelper.loadSingleFromCache((Object)calPolicyId, (String)"cal_bd_calpolicy");
        this.showdetail = this.showdetail && calPolicy.getBoolean("calbycostelement");
        this.noShowZeroInOut = this.filterInfo.getBoolean("noshowzeroinout");
        Object filterInfoValue = this.filterInfo.getFilterItem("currentMateiralId").getValue();
        this.materialId = Long.parseLong((String)filterInfoValue);
        DynamicObjectCollection materialColl = QueryServiceHelper.query((String)"bd_material", (String)"baseunit.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.materialId)});
        if (materialColl.size() > 0) {
            this.baseUnitId = ((DynamicObject)materialColl.get(0)).getLong("baseunit.id");
        }
        this.currencyId = this.filterInfo.getDynamicObject("localcurrency").getLong("id");
        this.filter_ownertype = (String)this.filterInfo.getValue("ownertypehead");
        if (StringUtils.isNotEmpty((String)this.filter_ownertype)) {
            if ("bos_org".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        if (StringUtils.isNotEmpty((String)this.filterInfo.getString("lotnumber"))) {
            this.filter_lot = this.filterInfo.getString("lotnumber").split(";");
        }
        this.filter_project = this.filterInfo.getDynamicObjectCollection("mulproject");
        this.filter_invType = this.filterInfo.getDynamicObjectCollection("mulinvtype");
        this.filter_invStatus = this.filterInfo.getDynamicObjectCollection("mulinvstatus");
        this.filter_billType = this.filterInfo.getDynamicObjectCollection("mulbilltype");
        this.filter_trackNumber = this.filterInfo.getDynamicObjectCollection("multracknum");
    }

    private QFilter getCostRecordFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        if (this.filter_calrange != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_calrange) {
                set.add(info.getPkValue());
            }
            q.and("entry.calrange", "in", set);
        }
        if (this.billno != null && !this.billno.trim().isEmpty()) {
            q.and("billno", "=", (Object)this.billno);
        }
        q.and("bookdate", ">=", (Object)this.filter_startDate);
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("entry.material", "=", (Object)this.materialId);
        q.and("issplitcreate", "=", (Object)false);
        q.and("isinitbill", "=", (Object)false);
        q.and(QFilter.of((String)"entry.accounttype = 'D' or costaccount.enablestandardcost = '1'", (Object[])new Object[0]));
        q.and("entry.invtype.isforwardamount", "=", (Object)true);
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costrecord");
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entry.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entry.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entry.location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("entry.lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("entry.project", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("entry.invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("entry.invstatus", "in", set);
        }
        if (this.filter_billType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_billType) {
                set.add(info.getPkValue());
            }
            q.and("billtype", "in", set);
        }
        if (this.filter_trackNumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_trackNumber) {
                set.add(info.getPkValue());
            }
            q.and("entry.tracknumber", "in", set);
        }
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        return q;
    }

    private DataSet getCostRecordDataSet() {
        QFilter q = this.getCostRecordFilter();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getCostRecordSelects(), (QFilter[])new QFilter[]{q}, null);
        return dataSet;
    }

    private String getCostRecordSelects() {
        StringBuilder select = new StringBuilder();
        select.append("period.periodyear as year,period.periodnumber as period,bizdate as bizdate,bookdate,auditdate as audittime,case when isvoucher = '1' then '1' else '0' end  as isvoucher,");
        select.append("billno as billno,calbilltype as calbilltype,billtype.name as billtype,entry.ownertype as ownertype,entry.owner as owner,storageorgunit.number as storageorgnumber,storageorgunit.name as storageorgname,");
        select.append("entry.warehouse.group.number as warehsgroupnumber,entry.warehouse.group.name as warehsgroupname,");
        select.append("entry.warehouse.number as warehousenumber,entry.warehouse.name as warehousename,entry.location.number as locationnumber,entry.location.name as locationname,entry.lot as lot,entry.tracknumber.number as tracknumber,");
        select.append("entry.assist as assist,entry.project.name as projectname,");
        select.append("case when calbilltype = 'IN' then entry.baseqty else 0 end as periodinqty,");
        select.append("0  as periodinamount,0 as periodindifferamount,");
        select.append("case when calbilltype = 'IN' and (entry.accounttype = 'D' or costaccount.enablestandardcost = '1') then entry.standardcost else 0 end as periodinstandardamount,");
        select.append("case when calbilltype = 'OUT' then entry.baseqty else 0 end as periodoutqty,");
        select.append("0  as periodoutamount,0 as periodoutdifferamount,");
        select.append("case when calbilltype = 'OUT' and (entry.accounttype = 'D' or costaccount.enablestandardcost = '1') then entry.standardcost else 0 end as periodoutstandardamount,");
        select.append("0 as periodendqty,0 as periodendamount,0 as periodenddifferamount,0 as periodendstandardamount,");
        select.append("case when entry.accounttype = 'D' then entry.unitstandardcost else entry.unitactualcost end as unitprice,");
        select.append("case when calbilltype = 'IN' then entry.baseqty else 0 end as periodinqtybak,0 as periodinamountbak,0 as periodindifferamountbak,");
        select.append("case when calbilltype = 'IN' and (entry.accounttype = 'D' or costaccount.enablestandardcost = '1') then entry.standardcost else 0 end as periodinstandardamountbak,");
        select.append("id as billid,'cal_costrecord_subentity' as bizentityobject,entry.id as entryid,'costrecord' as srcobject,'' as difftype,'' as createtype,'' as billsrctype");
        return select.toString();
    }

    private DataSet getCalStdcostDiffbillDataSet() {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)this.getCalStdcostDiffbillSelects(), (QFilter[])new QFilter[]{this.getCostAdjustFilter(true)}, null);
    }

    private QFilter getCostAdjustFilter(boolean isStdcostdiffbill) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        if (this.filter_calrange != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_calrange) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.calrange", "in", set);
        }
        if (this.billno != null && !this.billno.trim().isEmpty()) {
            q.and("billno", "=", (Object)this.billno);
        }
        q.and("bookdate", ">=", (Object)this.filter_startDate);
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("entryentity.material", "=", (Object)this.materialId);
        q.and("billstatus", "=", (Object)"C");
        q.and("isupdatecost", "=", (Object)"1");
        if (!isStdcostdiffbill) {
            q.and(QFilter.of((String)"difftype <> 'B'", (Object[])new Object[0]));
        }
        q.and(QFilter.of((String)"entryentity.accounttype = 'D' or costaccount.enablestandardcost = '1'", (Object[])new Object[0]));
        q.and("entryentity.invtype.isforwardamount", "=", (Object)true);
        if (isStdcostdiffbill) {
            ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_stdcostdiffbill");
        } else {
            ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costadjustbill");
        }
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("entryentity.lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.project", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invstatus", "in", set);
        }
        if (this.filter_billType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_billType) {
                set.add(info.getPkValue());
            }
            q.and("billtype", "in", set);
        }
        if (this.filter_trackNumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_trackNumber) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.tracknumber", "in", set);
        }
        return q;
    }

    private QFilter getInitBillFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        if (this.filter_calrange != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_calrange) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.calrange", "in", set);
        }
        q.and("billstatus", "=", (Object)"C");
        q.and("entryentity.material", "=", (Object)this.materialId);
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costadjustbill");
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("entryentity.lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.project", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invstatus", "in", set);
        }
        if (this.filter_trackNumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_trackNumber) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.tracknumber", "in", set);
        }
        return q;
    }

    private String getCalStdcostDiffbillSelects() {
        MainEntityType adjustEntity = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        ComboProp createTypeProperty = (ComboProp)adjustEntity.findProperty("createtype");
        List propComboItems = createTypeProperty.getComboItems();
        StringBuilder select = new StringBuilder();
        select.append("period.periodyear as year,period.periodnumber as period,bizdate as bizdate,bookdate,auditdate as audittime,case when isvoucher = '1' then '1' else '0' end  as isvoucher,");
        select.append("billno as billno,case when biztype = 'A' then 'IN' else 'OUT' end as calbilltype,");
        select.append("case ");
        for (ValueMapItem valueMapItem : propComboItems) {
            String value = valueMapItem.getValue();
            select.append(" when createtype = '").append(value).append("' then ").append(this.getStdcostdiffbillCreateTypeStr(value));
        }
        select.append(" else ").append(this.getStdcostdiffbillCreateTypeStr("#"));
        select.append(" end as billtype,entryentity.ownertype as ownertype,entryentity.owner as owner,");
        select.append("entryentity.storageorgunit.number as storageorgnumber,entryentity.storageorgunit.name as storageorgname,");
        select.append("entryentity.warehouse.group.number as warehsgroupnumber,entryentity.warehouse.group.name as warehsgroupname,");
        select.append("entryentity.warehouse.number as warehousenumber,entryentity.warehouse.name as warehousename,entryentity.location.number as locationnumber,entryentity.location.name as locationname,entryentity.lot as lot,entryentity.tracknumber.number as tracknumber,");
        select.append("entryentity.assist as assist,entryentity.project.name as projectname,");
        select.append("0 as periodinqty,0 as periodinamount,");
        select.append("case when biztype = 'A' then  entryentity.adjustamt else 0 end as periodindifferamount,");
        select.append("case when biztype = 'A' and createtype= 'C1' then (entryentity.adjustamt - 2*entryentity.diff_m)  else 0 end as periodinstandardamount,");
        select.append(" 0 as periodoutqty,0 as periodoutamount,");
        select.append("case when biztype = 'B' then  entryentity.adjustamt else 0 end as periodoutdifferamount,");
        select.append("case when biztype = 'B' and createtype= 'C1' then (entryentity.adjustamt - 2*entryentity.diff_m)  else 0 end as periodoutstandardamount,");
        select.append("0 as periodendqty,0 as periodendamount,0 as periodenddifferamount,0 as periodendstandardamount,");
        select.append("0 as unitprice,");
        select.append("0 as periodinqtybak,0 as periodinamountbak,");
        select.append("case when biztype = 'A' then  entryentity.adjustamt else 0 end as periodindifferamountbak,");
        select.append("case when biztype = 'A' and createtype= 'C1'  then (entryentity.adjustamt - 2*entryentity.diff_m)  else 0 end as periodinstandardamountbak,");
        select.append("id as billid,'cal_stdcostdiffbill' as bizentityobject,entryentity.id as entryid,'stdcostdiffbill' as srcobject,' ' as difftype,createtype,billsrctype");
        return select.toString();
    }

    private String getStdcostdiffbillCreateTypeStr(String type) {
        MainEntityType adjustEntity = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        ComboProp createTypeProperty = (ComboProp)adjustEntity.findProperty("createtype");
        List propComboItems = createTypeProperty.getComboItems();
        String title = ResManager.loadKDString((String)"\u672a\u77e5\u7684\u521b\u5efa\u7c7b\u578b\u3002", (String)"StockDifferDetailRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
        for (ValueMapItem valueMapItem : propComboItems) {
            String value = valueMapItem.getValue();
            if (!type.equals(value)) continue;
            title = valueMapItem.getName().toString();
        }
        String createTypeName = ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355(%1$s)", (String)"StockDifferDetailRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]);
        return String.format("'" + createTypeName + "'", title);
    }

    private DataSet unionPeriodBeginDataSet(DataSet dataSet) {
        return dataSet.addField("1", "ordercol_second").union(this.getPeriodBeginDataSet().addField("0", "ordercol_second"));
    }

    private DataSet getPeriodBeginDataSet() {
        DataSet dataSet;
        QFilter q = new QFilter("periodyear*100+periodnumber", ">=", (Object)this.filter_startPeriodNumber);
        q.and("periodyear*100+periodnumber", "<=", (Object)this.filter_endPeriodNumber);
        DynamicObject costAccountInfo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", this.filter_costAccount.get("id"))});
        q.and("periodtype", "=", costAccountInfo.get("calpolicy.periodtype"));
        q.and("isadjustperiod", "=", (Object)false);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{q}, (String)"periodyear asc,periodnumber asc");
        for (DynamicObject info : coll) {
            if (this.periodNumberList.indexOf(info.getInt("periodyear") * 100 + info.getInt("periodnumber")) >= 0) continue;
            this.periodNumberList.add(info.getInt("periodyear") * 100 + info.getInt("periodnumber"));
        }
        DataSet zeroPeriodBeginDataSet = null;
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DateType.LongType)});
        DataSetBuilder billMatCostDataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
        billMatCostDataSetBuilder.append(new Object[]{0L});
        try (DataSet singleDataSet = billMatCostDataSetBuilder.build();){
            for (int i = 0; i < this.periodNumberList.size(); ++i) {
                int periodNumber = this.periodNumberList.get(i);
                int year = periodNumber / 100;
                int month = periodNumber % 100;
                DataSet dataSet2 = singleDataSet.copy().select(new String[]{year + " as year", month + " as month", "0 as periodbeginqty", "0 as periodbeginactualcost", "0 as periodbegincostdiff", "0 as beginstandardcost"});
                zeroPeriodBeginDataSet = i == 0 ? dataSet2 : (zeroPeriodBeginDataSet != null ? zeroPeriodBeginDataSet.union(dataSet2) : dataSet2);
            }
        }
        String selectfields = "year,month,periodbeginqty,periodbeginactualcost,periodbegincostdiff,beginstandardcost";
        if (this.isNewBalance) {
            String moreFields = ",year,month,baseqty as periodbeginqty,actualcost as periodbeginactualcost,costdiff as periodbegincostdiff,standardcost as beginstandardcost";
            String select = CalBalanceModelHelper.getDimFields((boolean)true) + moreFields;
            String[] groupSelect = (CalBalanceModelHelper.getDimFields((boolean)false) + ",year,month").split(",");
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)select, (QFilter[])new QFilter[]{this.getPeriodBeginBalFilter()}, null);
            boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
            dataSet = balCompress ? dataSet.groupBy(groupSelect).sum("periodbeginqty").sum("periodbeginactualcost").sum("periodbegincostdiff").sum("beginstandardcost").finish() : dataSet.groupBy(groupSelect).max("periodbeginqty").sum("periodbeginactualcost").sum("periodbegincostdiff").sum("beginstandardcost").finish();
            dataSet = dataSet.select(selectfields);
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)selectfields, (QFilter[])new QFilter[]{this.getPeriodBeginBalFilter()}, null);
        }
        dataSet = dataSet.groupBy(new String[]{"year", "month"}).sum("periodbeginqty").sum("periodbeginactualcost").sum("periodbegincostdiff").sum("beginstandardcost").finish();
        if (zeroPeriodBeginDataSet != null) {
            zeroPeriodBeginDataSet = zeroPeriodBeginDataSet.join(dataSet, JoinType.LEFT).on("year", "year").on("month", "month").select(new String[]{"year", "month"}, new String[]{"periodbeginqty", "periodbeginactualcost", "periodbegincostdiff", "beginstandardcost"}).finish();
            return zeroPeriodBeginDataSet.select(this.getPeriodBeginFinalSelects().split(","));
        }
        return dataSet.select(this.getPeriodBeginFinalSelects().split(","));
    }

    private DataSet calPeriodEndDataSet(DataSet dataSet) {
        return dataSet.orderBy(new String[]{"year", "period", "ordercol_second", "bookdate", "audittime", "billno desc", "entryid asc"}).select((this.getTempSelects() + ",PreRowValue(periodendqty) + periodinqtybak - periodoutqty as periodendqty,PreRowValue(periodendamount) + periodinamountbak - periodoutamount as periodendamount,PreRowValue(periodenddifferamount) + periodindifferamountbak - periodoutdifferamount as periodenddifferamount,PreRowValue(periodendstandardamount) + periodinstandardamountbak - periodoutstandardamount as periodendstandardamount,unitprice,billid,bizentityobject,ordercol_second").split(","));
    }

    private DataSet filterStartPeriod(DataSet dataSet) {
        DynamicObject startPeriod = this.filterInfo.getDynamicObject("startperiod");
        int startPeriodNumber = startPeriod.getInt("periodyear") * 100 + startPeriod.getInt("periodnumber");
        QFilter q = new QFilter("year*100+period", ">=", (Object)startPeriodNumber);
        dataSet = dataSet.filter(q.toString());
        return dataSet;
    }

    private DataSet unionTotalDataSet(DataSet dataSet) {
        DataSet periodTotalDataSet = dataSet.copy().groupBy(new String[]{"year", "period"}).sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").minP("ordercol_second", "periodendqty").minP("ordercol_second", "periodendamount").minP("ordercol_second", "periodenddifferamount").minP("ordercol_second", "periodendstandardamount").finish().select(new String[]{"year", "period", "periodinqty", "periodinamount", "periodindifferamount", "periodinstandardamount", "periodoutqty", "periodoutamount", "periodoutdifferamount", "periodoutstandardamount", "periodendqty+periodinqty-periodoutqty as periodendqty", "periodendamount+periodinamount-periodoutamount as periodendamount", "periodenddifferamount+periodindifferamount-periodoutdifferamount as periodenddifferamount", "periodendstandardamount+periodinstandardamount-periodoutstandardamount as periodendstandardamount"}).select(this.getPeriodTotalFinalSelects().split(","));
        String validPeriod = null;
        StringBuilder sBuilder = new StringBuilder(16);
        for (Row row : periodTotalDataSet.copy()) {
            int year = row.getInteger("year");
            int period = row.getInteger("period");
            int periodNumber = year * 100 + period;
            sBuilder.append(periodNumber).append(",");
        }
        validPeriod = sBuilder.toString();
        if (!StringUtils.isEmpty((String)validPeriod)) {
            validPeriod = validPeriod.substring(0, validPeriod.length() - 1);
            dataSet = dataSet.filter("year*100+period in (" + validPeriod + ")");
        } else {
            dataSet = dataSet.filter("1 <> 1");
        }
        DataSet yearTotalDataSet = periodTotalDataSet.copy().groupBy(new String[]{"year"}).sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").finish();
        DataSet yearInOutDataSet = this.isNewBalance ? QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_initbill", (String)"period.periodyear as year,entryentity.yearinqty as yearinqty,entryentity.yearincost + entryentity.yearincostdiff as yearinactualcost,entryentity.yearincostdiff as yearincostdiff,case when costaccount.enablestandardcost = '1' or  entryentity.accounttype = 'D' then entryentity.yearincost else 0 end as yearinstandradcost,entryentity.yearissueqty as yearissueqty,entryentity.yearissuecost + entryentity.yearissuecostdiff as yearissueactualcost,entryentity.yearissuecostdiff as yearissuecostdiff,case when costaccount.enablestandardcost = '1' or  entryentity.accounttype = 'D' then entryentity.yearissuecost else 0 end as yearissuestandradcost", (QFilter[])new QFilter[]{this.getInitBillFilter()}, null).groupBy(new String[]{"year"}).sum("yearinqty").sum("yearinactualcost").sum("yearincostdiff").sum("yearinstandradcost").sum("yearissueqty").sum("yearissueactualcost").sum("yearissuecostdiff").sum("yearissuestandradcost").finish() : QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)"year,yearinqty,yearinactualcost,yearincostdiff,yearinstandradcost,yearissueqty,yearissueactualcost,yearissuecostdiff,yearissuestandradcost", (QFilter[])new QFilter[]{this.getPeriodBeginBalFilter()}, null).groupBy(new String[]{"year"}).sum("yearinqty").sum("yearinactualcost").sum("yearincostdiff").sum("yearinstandradcost").sum("yearissueqty").sum("yearissueactualcost").sum("yearissuecostdiff").sum("yearissuestandradcost").finish();
        yearTotalDataSet = yearTotalDataSet.join(yearInOutDataSet, JoinType.LEFT).on("year", "year").select(new String[]{"year", "0 as periodendqty", "0 as periodendamount", "0 as periodenddifferamount", "0 as periodendstandardamount", "periodinqty+yearinqty as periodinqty", "periodinamount+yearinactualcost as periodinamount", "periodindifferamount+yearincostdiff as periodindifferamount", "periodinstandardamount+yearinstandradcost as periodinstandardamount", "periodoutqty+yearissueqty as periodoutqty", "periodoutamount+yearissueactualcost as periodoutamount", "periodoutdifferamount+yearissuecostdiff as periodoutdifferamount", "periodoutstandardamount+yearissuestandradcost as periodoutstandardamount"}).finish().select(this.getYearTotalFinalSelects().split(","));
        return dataSet.addField("0", "ordercol_first").union(periodTotalDataSet.addField("1", "ordercol_second").addField("1", "ordercol_first")).union(yearTotalDataSet.addField("1", "ordercol_second").addField("2", "ordercol_first"));
    }

    private DataSet topSumRow(DataSet dataSet) {
        if (this.topSumRow) {
            if (this.showdetail && !this.onlyShowSumRow) {
                return dataSet.orderBy(new String[]{"year", "period", "ordercol_first desc", "bookdate", "audittime", "billno desc", "entryid asc", "orderval desc", "costelementnumber", "costsubelementnumber"});
            }
            return dataSet.orderBy(new String[]{"year", "period", "ordercol_first desc", "bookdate", "audittime", "billno desc", "entryid asc", "orderval desc"});
        }
        if (this.showdetail && !this.onlyShowSumRow) {
            return dataSet.orderBy(new String[]{"year", "period", "ordercol_first", "bookdate", "audittime", "billno desc", "entryid asc", "orderval asc", "costelementnumber", "costsubelementnumber"});
        }
        return dataSet.orderBy(new String[]{"year", "period", "ordercol_first", "bookdate", "audittime", "billno desc", "entryid asc", "orderval asc"});
    }

    private DataSet onlyShowSumRow(DataSet dataSet) {
        if (this.onlyShowSumRow) {
            return dataSet.filter("ordercol_first <> 0");
        }
        return dataSet;
    }

    private QFilter getPeriodBeginBalFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        if (this.filter_calrange != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_calrange) {
                set.add(info.getPkValue());
            }
            q.and("calrange", "in", set);
        }
        q.and("material", "=", (Object)this.materialId);
        q.and("period", "=", (Object)0);
        q.and("year*100+month", ">=", (Object)this.filter_startPeriodNumber);
        q.and("year*100+month", "<=", (Object)this.filter_endPeriodNumber);
        q.and("invtype.isforwardamount", "=", (Object)true);
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_balance");
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("project", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("invstatus", "in", set);
        }
        if (this.filter_trackNumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_trackNumber) {
                set.add(info.getPkValue());
            }
            q.and("tracknumber", "in", set);
        }
        QFilter qFilter1 = new QFilter("id", "=", this.filter_costAccount.getPkValue());
        DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"enablestandardcost", (QFilter[])new QFilter[]{qFilter1});
        boolean enableStandardCost = costAccount.getBoolean("enablestandardcost");
        if (!enableStandardCost) {
            q.and(QFilter.of((String)"accounttype = 'D'", (Object[])new Object[0]));
        }
        return q;
    }

    private String getPeriodBeginFinalSelects() {
        String s = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"StockDetailRptQueryPlugin_14", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("year as year,month as period,null as bizdate,null as bookdate,null as audittime,'0' as isvoucher,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,null as ownertype,0 as owner,null as storageorgnumber,null as storageorgname,");
        select.append("null as warehsgroupnumber,null as warehsgroupname,");
        select.append("null as warehousenumber,null as warehousename,null as locationnumber,null as locationname,null as lot,null as tracknumber,");
        select.append("null as assist,null as projectname,");
        select.append("0 as periodinqty,0 as periodinamount,0 as periodindifferamount,0 as periodinstandardamount,");
        select.append("0 as periodoutqty,0 as periodoutamount,0 as periodoutdifferamount,0 as periodoutstandardamount,");
        select.append("0 as periodendqty,0 as periodendamount,0 as periodenddifferamount,0 as periodendstandardamount,");
        select.append("0 as unitprice,");
        select.append("periodbeginqty as periodinqtybak,periodbeginactualcost as periodinamountbak,periodbegincostdiff as periodindifferamountbak,beginstandardcost as periodinstandardamountbak,");
        select.append("0 as billid,null as bizentityobject,null as entryid,null as srcobject,'' as difftype,'' as createtype,'' as billsrctype");
        return select.toString();
    }

    private String getPeriodTotalFinalSelects() {
        String s = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"StockDetailRptQueryPlugin_24", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("year as year,period as period,null as bizdate,null as bookdate,null as audittime,'0' as isvoucher,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,null as storageorgnumber,null as storageorgname,null as ownertype,0 as owner,");
        select.append("null as warehsgroupnumber,null as warehsgroupname,");
        select.append("null as warehousenumber,null as warehousename,null as locationnumber,null as locationname,null as lot,null as tracknumber,");
        select.append("null as assist,null as projectname,null as entryid,null as srcobject,'' as difftype,'' as createtype,'' as billsrctype,");
        select.append("periodinqty,periodinamount,periodindifferamount,periodinstandardamount,");
        select.append("periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount,");
        select.append("periodendqty,periodendamount,periodenddifferamount,periodendstandardamount,");
        select.append("0 as unitprice,");
        select.append("0 as billid,null as bizentityobject");
        return select.toString();
    }

    private String getYearTotalFinalSelects() {
        String s = ResManager.loadKDString((String)"\u672c\u5e74\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_31", (String)"fi-cal-report", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        int period = 99;
        if (this.topSumRow) {
            period = 0;
        }
        select.append("year as year,");
        select.append(period);
        select.append(" as period,");
        select.append("null as bizdate,null as bookdate,null as audittime,'0' as isvoucher,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,null as storageorgnumber,null as storageorgname,null as ownertype,0 as owner,");
        select.append("null as warehsgroupnumber,null as warehsgroupname,null as warehousenumber,null as warehousename,null as locationnumber,null as locationname,null as lot,null as tracknumber,");
        select.append("null as assist,null as projectname,null as entryid,null as srcobject,'' as difftype,'' as createtype,'' as billsrctype,");
        select.append("periodinqty,periodinamount,periodindifferamount,periodinstandardamount,");
        select.append("periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount,");
        select.append("periodendqty,periodendamount,0 as periodenddifferamount,periodendstandardamount,");
        select.append("0 as unitprice,");
        select.append("0 as billid,null as bizentityobject");
        return select.toString();
    }

    private String getTempSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,storageorgnumber,storageorgname,");
        select.append("ownertype,owner,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,lot,tracknumber,");
        select.append("assist,projectname,entryid,srcobject,difftype,createtype,billsrctype,");
        select.append("periodinqty,periodinamount,periodindifferamount,periodinstandardamount,");
        select.append("periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount");
        return select.toString();
    }

    private String getAliasSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,ownertype,owner,storageorgnumber,storageorgname,");
        select.append("warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,lot,tracknumber,");
        select.append("assist,projectname,");
        select.append("periodinqty,periodinstandardamount + periodindifferamount as periodinamount,periodindifferamount,periodinstandardamount,");
        select.append("periodoutqty,periodoutstandardamount + periodoutdifferamount as periodoutamount,periodoutdifferamount,periodoutstandardamount,");
        select.append("periodendqty,periodendstandardamount + periodenddifferamount as periodendamount,periodenddifferamount,periodendstandardamount,");
        select.append("unitprice,");
        select.append("periodinqtybak,periodinstandardamountbak +  periodindifferamountbak as periodinamountbak,periodindifferamountbak,periodinstandardamountbak,");
        select.append("billid,bizentityobject,entryid,srcobject,difftype,createtype,billsrctype");
        return select.toString();
    }

    private String getFinalSelects() {
        StringBuilder select = new StringBuilder();
        select.append("year,case when period = 99 then 0 else period end as period,bizdate,bookdate,audittime,isvoucher,");
        select.append("billno,calbilltype,billtype,storageorgnumber,storageorgname,");
        select.append("ownertype,owner,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,lot,tracknumber,");
        select.append("assist as assistproperty,projectname,");
        select.append("periodinqty,periodinamount,periodindifferamount,periodinstandardamount,");
        select.append("periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount,");
        select.append("periodendqty,periodendamount,periodenddifferamount,periodendstandardamount,");
        select.append(this.getPriceSelect("periodinstandardamount", "periodinqty")).append(" as periodinprice,");
        select.append(this.getPriceSelect("periodoutstandardamount", "periodoutqty")).append(" as periodoutprice,");
        select.append(this.getEndPriceSelect("periodendstandardamount", "periodendqty")).append(" as periodendprice,");
        select.append(this.baseUnitId).append(" as baseunitid,").append(this.currencyId).append(" as currencyid,");
        if (this.showdetail && !this.onlyShowSumRow) {
            select.append("costelementnumber,costelementname,costsubelementnumber,costsubelementname,");
        }
        select.append("billid,bizentityobject").append(",").append(this.materialId).append(" as materialid");
        return select.toString();
    }

    private String getEndPriceSelect(String amount, String qty) {
        return "case when  " + qty + " = 0 then 0 else " + amount + "/" + qty + " end ";
    }

    private String getPriceSelect(String amount, String qty) {
        return "case when unitprice <> 0  and " + qty + " <> 0 then unitprice when " + qty + " = 0 then 0 else " + amount + "/" + qty + " end ";
    }

    private void createDecimalColumns(List<AbstractReportColumn> cols) {
        this.createDecimalColumn(cols, this.locale_periodIn, "periodin");
        this.createDecimalColumn(cols, this.locale_periodOut, "periodout");
        this.createDecimalColumn(cols, this.locale_periodEnd, "periodend");
    }

    private void createCostElementColumns(List<AbstractReportColumn> cols) {
        if (this.showdetail && !this.onlyShowSumRow) {
            this.createCostDetailColumns(cols);
        }
    }

    private void createCostDetailColumns(List<AbstractReportColumn> cols) {
        ReportColumn costelementNum = new ReportColumn();
        costelementNum.setCaption(this.locale_costelementNum);
        costelementNum.setWidth(width);
        costelementNum.setFieldKey("costelementnumber");
        costelementNum.setFieldType("text");
        cols.add((AbstractReportColumn)costelementNum);
        ReportColumn costelementName = new ReportColumn();
        costelementName.setCaption(this.locale_costelementName);
        costelementName.setWidth(width);
        costelementName.setFieldKey("costelementname");
        costelementName.setFieldType("text");
        cols.add((AbstractReportColumn)costelementName);
        ReportColumn costsubelementNum = new ReportColumn();
        costsubelementNum.setCaption(this.locale_costsubelementNum);
        costsubelementNum.setWidth(width);
        costsubelementNum.setFieldKey("costsubelementnumber");
        costsubelementNum.setFieldType("text");
        cols.add((AbstractReportColumn)costsubelementNum);
        ReportColumn costsubelementName = new ReportColumn();
        costsubelementName.setCaption(this.locale_costsubelementName);
        costsubelementName.setWidth(width);
        costsubelementName.setFieldKey("costsubelementname");
        costsubelementName.setFieldType("text");
        cols.add((AbstractReportColumn)costsubelementName);
    }

    private void createDecimalColumn(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey);
        cols.add((AbstractReportColumn)groupCol);
        ReportColumn qty = new ReportColumn();
        qty.setCaption(this.locale_qty);
        qty.setWidth(width);
        qty.setFieldKey(fieldKey + "qty");
        qty.setFieldType("qty");
        qty.setMeasureUnitField("baseunitid");
        ReportColumn price = new ReportColumn();
        price.setCaption(this.locale_price);
        price.setWidth(width);
        price.setFieldKey(fieldKey + "price");
        price.setFieldType("price");
        price.setCurrencyField("currencyid");
        ReportColumn standardAmount = new ReportColumn();
        standardAmount.setCaption(this.locale_standardAmount);
        standardAmount.setWidth(width);
        standardAmount.setFieldKey(fieldKey + "standardamount");
        standardAmount.setFieldType("amount");
        standardAmount.setCurrencyField("currencyid");
        ReportColumn differAmount = new ReportColumn();
        differAmount.setCaption(this.locale_differAmount);
        differAmount.setWidth(width);
        differAmount.setFieldKey(fieldKey + "differamount");
        differAmount.setFieldType("amount");
        differAmount.setCurrencyField("currencyid");
        ReportColumn actualAmount = new ReportColumn();
        actualAmount.setCaption(this.locale_actualAmount);
        actualAmount.setWidth(width);
        actualAmount.setFieldKey(fieldKey + "amount");
        actualAmount.setFieldType("amount");
        actualAmount.setCurrencyField("currencyid");
        groupCol.getChildren().add(qty);
        groupCol.getChildren().add(price);
        groupCol.getChildren().add(standardAmount);
        groupCol.getChildren().add(differAmount);
        groupCol.getChildren().add(actualAmount);
    }

    private void createHideColumns(List<AbstractReportColumn> cols) {
        ReportColumn baseUnitId = new ReportColumn();
        baseUnitId.setCaption(this.locale_baseUnit);
        baseUnitId.setWidth(width);
        baseUnitId.setFieldKey("baseunitid");
        baseUnitId.setFieldType("unit");
        baseUnitId.setEntityId("bd_measureunits");
        baseUnitId.setHide(true);
        ReportColumn currencyId = new ReportColumn();
        currencyId.setCaption(this.locale_currency);
        currencyId.setWidth(width);
        currencyId.setFieldKey("currencyid");
        currencyId.setFieldType("currency");
        currencyId.setEntityId("bd_currency");
        currencyId.setHide(true);
        ReportColumn bizEntityObject = new ReportColumn();
        bizEntityObject.setCaption(this.locale_currency);
        bizEntityObject.setWidth(width);
        bizEntityObject.setFieldKey("bizentityobject");
        bizEntityObject.setFieldType("text");
        bizEntityObject.setHide(true);
        ReportColumn billId = new ReportColumn();
        billId.setCaption(this.locale_currency);
        billId.setWidth(width);
        billId.setFieldKey("billid");
        billId.setFieldType("text");
        billId.setHide(true);
        cols.add((AbstractReportColumn)baseUnitId);
        cols.add((AbstractReportColumn)currencyId);
        cols.add((AbstractReportColumn)bizEntityObject);
        cols.add((AbstractReportColumn)billId);
    }

    private DataSet getDetailByBatch(Set<Object> ids, String entityName, String selectFields) {
        if (ids == null || ids.size() < 1) {
            QFilter qFilter = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
        }
        List<Set<Object>> balIdsArray = this.getBatchIdList(ids);
        DataSet detailDataSet = null;
        for (int arrayIndex = 0; arrayIndex < balIdsArray.size(); ++arrayIndex) {
            QFilter qFilter = new QFilter("entryid", "in", balIdsArray.get(arrayIndex));
            DataSet currDetailDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
            detailDataSet = detailDataSet == null ? currDetailDataSet : detailDataSet.union(currDetailDataSet);
        }
        if (detailDataSet == null) {
            QFilter qFilter = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
        }
        return detailDataSet;
    }

    private List<Set<Object>> getBatchIdList(Set<Object> ids) {
        ArrayList<Set<Object>> balIdsArray = new ArrayList<Set<Object>>(16);
        HashSet<Object> balIds = null;
        long index = 0L;
        for (Object id : ids) {
            if (index % 100000L == 0L) {
                balIds = new HashSet<Object>();
                balIdsArray.add(balIds);
            }
            if (balIds != null) {
                balIds.add(id);
            }
            ++index;
        }
        return balIdsArray;
    }
}

