/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.MaterialCategoryHelper;
import kd.fi.cal.common.util.ReportUtil;

public class StockDifferGroupRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(StockDifferGroupRptQueryPlugin.class);
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private DynamicObjectCollection filter_calrange;
    private DynamicObject filter_startPeriod;
    private DynamicObject filter_endPeriod;
    private int filter_startPeriodNumber;
    private int filter_endPeriodNumber;
    private boolean isGroupByPeriod;
    private boolean noShowZeroInOut;
    private boolean showAllZero;
    private String groupType;
    private List<Integer> periodNumberList = new ArrayList<Integer>();
    private boolean onlyShowSumRow;
    private boolean topSumRow;
    private boolean showdetail;
    private long currencyId;
    private String filter_ownertype;
    private DynamicObjectCollection filter_ownerFrom;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private DynamicObjectCollection filter_materialFrom;
    private DynamicObject filter_materialTo;
    private String[] filter_lot;
    private DynamicObjectCollection filter_project;
    private DynamicObjectCollection filter_trackNumber;
    private DynamicObjectCollection filter_invType;
    private DynamicObjectCollection filter_invStatus;
    private DynamicObjectCollection filter_mulMaterialCategory;
    private MaterialCategoryHelper materialCategoryHelper = null;
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private Set<String> exDimFields = new HashSet<String>(16);
    private LocaleString locale_calRangeNum = new LocaleString(this.getLocale_calRangeNum());
    private LocaleString locale_calRangeName = new LocaleString(this.getLocale_calRangeName());
    private LocaleString locale_ownerNum = new LocaleString(this.getLocale_ownerNum());
    private LocaleString locale_ownerName = new LocaleString(this.getLocale_ownerName());
    private LocaleString locale_storageOrgNum = new LocaleString(this.getLocale_storageOrgNum());
    private LocaleString locale_storageOrgName = new LocaleString(this.getLocale_storageOrgName());
    private LocaleString locale_warehouseNum = new LocaleString(this.getLocale_warehouseNum());
    private LocaleString locale_warehouseName = new LocaleString(this.getLocale_warehouseName());
    private LocaleString locale_warehouseGroupNum = new LocaleString(this.getLocale_WarehouseGroupNum());
    private LocaleString locale_warehouseGroupName = new LocaleString(this.getLocale_WarehouseGroupName());
    private LocaleString locale_MaterialCategoryNum = new LocaleString(this.getLocale_MaterialCategoryNum());
    private LocaleString locale_MaterialCategoryName = new LocaleString(this.getLocale_MaterialCategoryName());
    private static final LocaleString locale_trackNum = new LocaleString(StockDifferGroupRptQueryPlugin.getlocale_trackNum());
    private LocaleString locale_locationNum = new LocaleString(this.getLocale_locationNum());
    private LocaleString locale_locationName = new LocaleString(this.getLocale_locationName());
    private LocaleString locale_lot = new LocaleString(this.getLocale_lot());
    private LocaleString locale_assistProperty = new LocaleString(this.getLocale_assistProperty());
    private LocaleString locale_projectNum = new LocaleString(this.getLocale_projectNum());
    private LocaleString locale_materialNum = new LocaleString(this.getLocale_materialNum());
    private LocaleString locale_materialName = new LocaleString(this.getLocale_materialName());
    private LocaleString locale_costelementNum = new LocaleString(this.getLocale_costelementNum());
    private LocaleString locale_costelementName = new LocaleString(this.getLocale_costelementName());
    private LocaleString locale_costsubelementNum = new LocaleString(this.getLocale_costsubelementNum());
    private LocaleString locale_costsubelementName = new LocaleString(this.getLocale_costsubelementName());
    private LocaleString locale_model = new LocaleString(this.getLocale_model());
    private LocaleString locale_baseUnit = new LocaleString(this.getLocale_baseUnit());
    private LocaleString locale_periodBegin = new LocaleString(this.getLocale_periodBegin());
    private LocaleString locale_periodIn = new LocaleString(this.getLocale_periodIn());
    private LocaleString locale_periodOut = new LocaleString(this.getLocale_periodOut());
    private LocaleString locale_periodEnd = new LocaleString(this.getLocale_periodEnd());
    private LocaleString locale_qty = new LocaleString(this.getLocale_qty());
    private LocaleString locale_price = new LocaleString(this.getLocale_price());
    private LocaleString locale_standardAmount = new LocaleString(this.getLocale_standardAmount());
    private LocaleString locale_actualAmount = new LocaleString(this.getLocale_actualAmount());
    private LocaleString locale_actualPrice = new LocaleString(this.getLocale_actualPrice());
    private LocaleString locale_differAmount = new LocaleString(this.getLocale_differAmount());
    private LocaleString locale_currency = new LocaleString(this.getLocale_currency());
    private LocaleString locale_enddiffactualprice = new LocaleString(this.getLocale_enddiffactualprice());
    private LocaleString locale_outdiffactualprice = new LocaleString(this.getLocale_outdiffactualprice());
    private static final LocaleString width = new LocaleString("100px");

    private String getLocale_calRangeNum() {
        return ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u7f16\u7801", (String)"StockGatherRptQueryPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_calRangeName() {
        return ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u540d\u79f0", (String)"StockGatherRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_ownerNum() {
        return ResManager.loadKDString((String)"\u8d27\u4e3b\u7f16\u7801", (String)"StockGatherRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_ownerName() {
        return ResManager.loadKDString((String)"\u8d27\u4e3b\u540d\u79f0", (String)"StockGatherRptQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_storageOrgNum() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801", (String)"StockGatherRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_storageOrgName() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u540d\u79f0", (String)"StockGatherRptQueryPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_warehouseNum() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u7f16\u7801", (String)"StockGatherRptQueryPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_warehouseName() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u540d\u79f0", (String)"StockGatherRptQueryPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_WarehouseGroupNum() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u5206\u7ec4\u7f16\u7801", (String)"StockGatherRptQueryPlugin_41", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_WarehouseGroupName() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u5206\u7ec4\u540d\u79f0", (String)"StockGatherRptQueryPlugin_42", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_MaterialCategoryNum() {
        return ResManager.loadKDString((String)"\u5b58\u8d27\u7c7b\u522b\u7f16\u7801", (String)"StockGatherRptQueryPlugin_55", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_MaterialCategoryName() {
        return ResManager.loadKDString((String)"\u5b58\u8d27\u7c7b\u522b\u540d\u79f0", (String)"StockGatherRptQueryPlugin_56", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_locationNum() {
        return ResManager.loadKDString((String)"\u4ed3\u4f4d\u7f16\u7801", (String)"StockGatherRptQueryPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private static final String getlocale_trackNum() {
        return ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7", (String)"StockGatherRptQueryPlugin_61", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_locationName() {
        return ResManager.loadKDString((String)"\u4ed3\u4f4d\u540d\u79f0", (String)"StockGatherRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_lot() {
        return ResManager.loadKDString((String)"\u6279\u53f7", (String)"StockGatherRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_assistProperty() {
        return ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"StockGatherRptQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_projectNum() {
        return ResManager.loadKDString((String)"\u9879\u76ee\u53f7", (String)"StockGatherRptQueryPlugin_12", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialNum() {
        return ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"StockGatherRptQueryPlugin_13", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialName() {
        return ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"StockGatherRptQueryPlugin_14", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costelementNum() {
        return ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u7f16\u7801", (String)"StockGatherRptQueryPlugin_15", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costelementName() {
        return ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u540d\u79f0", (String)"StockGatherRptQueryPlugin_16", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costsubelementNum() {
        return ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801", (String)"StockGatherRptQueryPlugin_17", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costsubelementName() {
        return ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u540d\u79f0", (String)"StockGatherRptQueryPlugin_18", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_model() {
        return ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"StockGatherRptQueryPlugin_19", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_baseUnit() {
        return ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"StockGatherRptQueryPlugin_20", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodBegin() {
        return ResManager.loadKDString((String)"\u671f\u521d\u7ed3\u5b58", (String)"StockGatherRptQueryPlugin_21", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodIn() {
        return ResManager.loadKDString((String)"\u672c\u671f\u6536\u5165", (String)"StockGatherRptQueryPlugin_22", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodOut() {
        return ResManager.loadKDString((String)"\u672c\u671f\u53d1\u51fa", (String)"StockGatherRptQueryPlugin_23", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodEnd() {
        return ResManager.loadKDString((String)"\u671f\u672b\u7ed3\u5b58", (String)"StockGatherRptQueryPlugin_24", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_qty() {
        return ResManager.loadKDString((String)"\u6570\u91cf", (String)"StockGatherRptQueryPlugin_25", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_price() {
        return ResManager.loadKDString((String)"\u5355\u4f4d\u6807\u51c6\u6210\u672c", (String)"StockDifferGroupRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_standardAmount() {
        return ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c", (String)"StockDifferGroupRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_actualAmount() {
        return ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c", (String)"StockDifferGroupRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_actualPrice() {
        return ResManager.loadKDString((String)"\u5355\u4f4d\u5b9e\u9645\u6210\u672c", (String)"StockDifferGroupRptQueryPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_differAmount() {
        return ResManager.loadKDString((String)"\u5dee\u5f02", (String)"StockDifferGroupRptQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_currency() {
        return ResManager.loadKDString((String)"\u5e01\u79cd", (String)"StockGatherRptQueryPlugin_28", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_enddiffactualprice() {
        return ResManager.loadKDString((String)"\u5355\u4f4d\u5b9e\u9645\u6210\u672c\u5dee\u5f02-\u7ed3\u5b58", (String)"StockDifferGroupRptQueryPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_outdiffactualprice() {
        return ResManager.loadKDString((String)"\u5355\u4f4d\u5b9e\u9645\u6210\u672c\u5dee\u5f02-\u53d1\u51fa", (String)"StockDifferGroupRptQueryPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private void init(ReportQueryParam param) {
        this.filterInfo = param.getFilter();
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.filter_calrange = this.filterInfo.getDynamicObjectCollection("mulcalrange");
        this.filter_startPeriod = this.filterInfo.getDynamicObject("startperiod");
        this.filter_endPeriod = this.filterInfo.getDynamicObject("endperiod");
        this.filter_startPeriodNumber = this.filter_startPeriod.getInt("periodyear") * 100 + this.filter_startPeriod.getInt("periodnumber");
        this.filter_endPeriodNumber = this.filter_endPeriod.getInt("periodyear") * 100 + this.filter_endPeriod.getInt("periodnumber");
        this.isGroupByPeriod = this.filterInfo.getBoolean("groupbyperiod");
        this.noShowZeroInOut = this.filterInfo.getBoolean("noshowzeroinout");
        this.showAllZero = this.filterInfo.getBoolean("showallzero");
        this.groupType = this.filterInfo.getString("mulgrouptype");
        this.showdetail = this.filterInfo.getBoolean("showdetail");
        Object calPolicyId = this.filter_costAccount.getDynamicObject("calpolicy").getPkValue();
        DynamicObject calPolicy = BusinessDataServiceHelper.loadSingleFromCache((Object)calPolicyId, (String)"cal_bd_calpolicy");
        boolean bl = this.showdetail = this.showdetail && calPolicy.getBoolean("calbycostelement");
        if (this.groupType == null) {
            this.groupType = "A";
        }
        this.onlyShowSumRow = this.filterInfo.getBoolean("onlyshowsumrow");
        this.topSumRow = this.filterInfo.getBoolean("topsumrow");
        DynamicObject costAccountInfo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", this.filter_costAccount.get("id"))});
        QFilter q = new QFilter("periodtype", "=", costAccountInfo.get("calpolicy.periodtype"));
        q.and(new QFilter("isadjustperiod", "=", (Object)false));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{q}, (String)"periodyear asc,periodnumber asc");
        for (DynamicObject info : coll) {
            int periodNumber = info.getInt("periodyear") * 100 + info.getInt("periodnumber");
            this.periodNumberList.add(periodNumber);
        }
        this.currencyId = this.filterInfo.getDynamicObject("localcurrency").getLong("id");
        this.filter_ownertype = (String)this.filterInfo.getValue("ownertypehead");
        if (StringUtils.isNotEmpty((String)this.filter_ownertype)) {
            if ("bos_org".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        this.filter_materialFrom = this.filterInfo.getDynamicObjectCollection("mulmaterial");
        this.filter_materialTo = this.filterInfo.getDynamicObject("materialto");
        if (StringUtils.isNotEmpty((String)this.filterInfo.getString("lotnumber"))) {
            this.filter_lot = this.filterInfo.getString("lotnumber").split(";");
        }
        this.filter_project = this.filterInfo.getDynamicObjectCollection("mulproject");
        this.filter_trackNumber = this.filterInfo.getDynamicObjectCollection("multracknum");
        this.filter_invType = this.filterInfo.getDynamicObjectCollection("mulinvtype");
        this.filter_invStatus = this.filterInfo.getDynamicObjectCollection("mulinvstatus");
        this.filter_mulMaterialCategory = this.filterInfo.getDynamicObjectCollection("mulmatcategory");
        this.exDimFields = CalBalanceModelHelper.getExDimField();
    }

    public DataSet query(ReportQueryParam param, Object o) throws Throwable {
        try {
            this.init(param);
            DataSet dataSet = this.getDateSet();
            dataSet = this.insertZeroInOutPeriod(dataSet);
            dataSet = this.groupDataSet(dataSet);
            dataSet = this.groupDataSetByPeriod(dataSet);
            dataSet = this.noShowZeroInOut(dataSet);
            dataSet = this.unionGroupDataSet(dataSet);
            dataSet = this.addActualPrice(dataSet);
            dataSet = this.addDiffActualPrice(dataSet);
            dataSet = this.onlyShowSumRow(dataSet);
            if (this.hasGroup(this.groupType, "C")) {
                dataSet = dataSet.addField("owner", "ownernumber");
            }
            return dataSet;
        }
        catch (Throwable e) {
            StringBuilder sBuilder = new StringBuilder("cal_stockdiffergrouprpt\uff1a");
            if (e instanceof KDBizException) {
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage());
                }
            } else {
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage()).append("\n");
                }
                StackTraceElement[] errs = e.getStackTrace();
                int i = 0;
                for (StackTraceElement err : errs) {
                    if (i == 256) break;
                    sBuilder.append(err.toString()).append("\n");
                    ++i;
                }
            }
            logger.info(sBuilder.toString());
            throw e;
        }
    }

    private DataSet getDateSet() {
        DataSet dataSet;
        DataSet balSet;
        QFilter q = this.getFilter(false);
        StringBuilder exFields = new StringBuilder();
        if (!this.exDimFields.isEmpty()) {
            for (String exField : this.exDimFields) {
                exFields.append(",").append(exField);
            }
        }
        if (this.isNewBalance) {
            balSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)(this.getNewBalSelectFields() + exFields), (QFilter[])new QFilter[]{q}, null);
            if (this.showdetail) {
                dataSet = balSet;
            } else {
                boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
                dataSet = balCompress ? balSet.groupBy((this.getBalNoDetailSelectFields(false) + exFields).split(",")).max("id").sum("periodbeginqty").sum("periodbeginamount").sum("periodbegindifferamount").sum("periodbeginstandardamount").sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").sum("periodendqty").sum("periodendamount").sum("periodenddifferamount").sum("periodendstandardamount").finish() : balSet.groupBy((this.getBalNoDetailSelectFields(false) + exFields).split(",")).max("id").max("periodbeginqty").sum("periodbeginamount").sum("periodbegindifferamount").sum("periodbeginstandardamount").max("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").max("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").max("periodendqty").sum("periodendamount").sum("periodenddifferamount").sum("periodendstandardamount").finish();
                dataSet = dataSet.select(this.getBalNoShowDetailFinalSelectFields());
            }
        } else {
            balSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)this.getBalSelectFields(), (QFilter[])new QFilter[]{q}, null);
            if (this.showdetail) {
                DataSet tempDataSet = balSet.copy();
                HashSet<Object> balIds = new HashSet<Object>();
                for (Row row : tempDataSet) {
                    balIds.add(row.get("id"));
                }
                QFilter qFilter = new QFilter("balid", "in", balIds);
                DataSet adjustDetailDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance_detail", (String)this.getBalDetailSelectFields(), (QFilter[])new QFilter[]{qFilter}, null);
                dataSet = balSet.join(adjustDetailDataSet, JoinType.LEFT).on("id", "balid").select(this.getBalNoDetailSelectFields(true).split(","), this.getBalDetailAllSelectFields().split(",")).finish();
            } else {
                dataSet = balSet;
            }
        }
        dataSet = this.filterNoEnableStandardCostSet(dataSet);
        return dataSet;
    }

    private DataSet filterNoEnableStandardCostSet(DataSet dataSet) {
        QFilter qFilter1 = new QFilter("id", "=", this.filter_costAccount.getPkValue());
        DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"enablestandardcost", (QFilter[])new QFilter[]{qFilter1});
        boolean enableStandardCost = costAccount.getBoolean("enablestandardcost");
        if (!enableStandardCost) {
            dataSet = dataSet.filter("accounttype = 'D'");
        }
        return dataSet;
    }

    private DataSet insertZeroInOutPeriod(DataSet dataSet) {
        DataSet resultDataSet = dataSet;
        DataSet dataSet1 = dataSet.copy();
        DataSet dataSet2 = dataSet.copy();
        HashMap<Integer, StringBuilder> unionMap = new HashMap<Integer, StringBuilder>();
        for (Row row : dataSet1) {
            int i;
            List<Integer> periodList;
            int periodNumber = row.getInteger("periodnumber");
            int endPeriodNumber = row.getInteger("endperiod");
            long id = row.getLong("id");
            if (periodNumber == 0 && endPeriodNumber == 999999) {
                periodList = this.getPeriodNumberList(this.filter_startPeriodNumber, this.filter_endPeriodNumber);
                for (i = 0; i < periodList.size(); ++i) {
                    this.cacheUnionMap(id, periodList.get(i), unionMap);
                }
            }
            if (periodNumber == 0 && endPeriodNumber != 999999 && endPeriodNumber > this.filter_startPeriodNumber) {
                if (this.filter_endPeriodNumber < endPeriodNumber) {
                    periodList = this.getPeriodNumberList(this.filter_startPeriodNumber, this.filter_endPeriodNumber);
                    for (i = 0; i < periodList.size(); ++i) {
                        this.cacheUnionMap(id, periodList.get(i), unionMap);
                    }
                } else {
                    periodList = this.getPeriodNumberList(this.filter_startPeriodNumber, endPeriodNumber);
                    for (i = 0; i < periodList.size() - 1; ++i) {
                        this.cacheUnionMap(id, periodList.get(i), unionMap);
                    }
                }
            }
            if (periodNumber != 0 && endPeriodNumber != 999999) {
                if (this.filter_endPeriodNumber < endPeriodNumber) {
                    periodList = this.getPeriodNumberList(periodNumber, this.filter_endPeriodNumber);
                    for (i = 1; i < periodList.size(); ++i) {
                        this.cacheUnionMap(id, periodList.get(i), unionMap);
                    }
                } else {
                    periodList = this.getPeriodNumberList(periodNumber, endPeriodNumber);
                    for (i = 1; i < periodList.size() - 1; ++i) {
                        this.cacheUnionMap(id, periodList.get(i), unionMap);
                    }
                }
            }
            if (periodNumber == 0 || endPeriodNumber != 999999 || periodNumber >= this.filter_endPeriodNumber) continue;
            periodList = this.getPeriodNumberList(periodNumber, this.filter_endPeriodNumber);
            for (i = 1; i < periodList.size(); ++i) {
                this.cacheUnionMap(id, periodList.get(i), unionMap);
            }
        }
        resultDataSet = this.unionZeroInOutDataSet(resultDataSet, dataSet2, unionMap);
        QFilter q = new QFilter("periodnumber", ">=", (Object)this.filter_startPeriodNumber);
        q.and("periodnumber", "<=", (Object)this.filter_endPeriodNumber);
        return resultDataSet.filter(q.toString());
    }

    private List<Integer> getPeriodNumberList(int startPeriod, int endPeriod) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int period : this.periodNumberList) {
            if (period < startPeriod || period > endPeriod) continue;
            list.add(period);
        }
        return list;
    }

    private DataSet unionZeroInOutDataSet(DataSet dataSet, DataSet dataSet2, Map<Integer, StringBuilder> unionMap) {
        for (Map.Entry<Integer, StringBuilder> entry : unionMap.entrySet()) {
            String id = entry.getValue().toString();
            DataSet zeroInOutDataSet = dataSet2.filter("id in (" + id + ")").select(this.getBalSelectAliasFields(entry.getKey()));
            dataSet = dataSet.union(zeroInOutDataSet);
        }
        return dataSet;
    }

    private String getBalSelectAliasFields(int period) {
        int year = period / 100;
        int month = period % 100;
        String select = "id,accounttype,costaccountnumber,costaccountname,calorgnumber,calorgname," + period + " as periodnumber,0 as endperiod," + year + " as year," + month + " as month,ownertype,owner,storageorgnumber,storageorgname,storageorgid,warehousenumber,warehousename,warehouseid,warehsgroupnumber,warehsgroupname,warehsgroupid,locationnumber,locationname,locationid,invtype,invstatus,materialnumber,materialname,materialid,model,mversion,projectname,projectid,tracknumber,materialcategory,lot,assist,baseunitname,baseunitid,qtyprecision,currencyid,costelementnumber,costelementname,costsubelementnumber,costsubelementname,periodendqty as periodbeginqty,periodendamount as periodbeginamount,periodenddifferamount as periodbegindifferamount,periodendstandardamount as periodbeginstandardamount,0.0 as periodinqty,0.0 as periodinamount,0.0 as periodindifferamount,0.0 as periodinstandardamount,0.0 as periodoutqty,0.0 as periodoutamount,0.0 as periodoutdifferamount,0.0 as periodoutstandardamount,periodendqty,periodendamount,periodenddifferamount,periodendstandardamount";
        return select;
    }

    private void cacheUnionMap(long id, int period, Map<Integer, StringBuilder> unionMap) {
        if (unionMap.containsKey(period)) {
            StringBuilder sb = unionMap.get(period);
            sb.append(",").append(id);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(id);
            unionMap.put(period, sb);
        }
    }

    private DataSet joinOwnerDataSet(DataSet dataSet) {
        DataSet copyDataSet = dataSet.copy();
        HashSet<Long> set = new HashSet<Long>();
        for (Row row : copyDataSet) {
            set.add(row.getLong("ownerid"));
        }
        QFilter q = new QFilter("id", "in", set);
        DataSet ownerSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org", (String)"id,name,number", (QFilter[])q.toArray(), null);
        DataSet supplierSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_supplier", (String)"id,name,number", (QFilter[])q.toArray(), null);
        ownerSet = ownerSet.union(supplierSet);
        return dataSet.join(ownerSet, JoinType.LEFT).on("ownerid", "id").select(this.getBalSelectAliasFields().split(","), new String[]{"number as ownernumber", "name as ownername"}).finish();
    }

    private DataSet groupDataSet(DataSet dataSet) {
        DataSet dataSet1 = dataSet.groupBy(this.getGroupCols().split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodbegindifferamount").sum("periodbeginstandardamount").sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").sum("periodendqty").sum("periodendamount").sum("periodenddifferamount").sum("periodendstandardamount").finish();
        if (!this.showdetail) {
            dataSet1 = dataSet1.groupBy(this.getGroupColsWithOutCostElement().split(",")).max("periodbeginqty").sum("periodbeginamount").sum("periodbegindifferamount").sum("periodbeginstandardamount").max("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").max("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").max("periodendqty").sum("periodendamount").sum("periodenddifferamount").sum("periodendstandardamount").finish();
        }
        dataSet1 = dataSet1.groupBy(this.getGroupCols(true).split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodbegindifferamount").sum("periodbeginstandardamount").sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").sum("periodendqty").sum("periodendamount").sum("periodenddifferamount").sum("periodendstandardamount").finish();
        return dataSet1.select(this.getFinalSelectFields().split(","));
    }

    private String getFinalSelectFields() {
        String select = this.getGroupCols(true);
        select = select + ",periodbeginqty,periodbeginamount,periodbegindifferamount,periodbeginstandardamount," + this.getPriceSelect("periodbeginstandardamount", "periodbeginqty") + " as periodbeginprice,periodinqty,periodinamount,periodindifferamount,periodinstandardamount," + this.getPriceSelect("periodinstandardamount", "periodinqty") + " as periodinprice,periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount," + this.getPriceSelect("periodoutstandardamount", "periodoutqty") + " as periodoutprice,periodendqty,periodendamount,periodenddifferamount,periodendstandardamount," + this.getPriceSelect("periodendstandardamount", "periodendqty") + " as periodendprice";
        return select;
    }

    private String getFinalSelectFieldsWithNoQty() {
        String select = this.getGroupCols(true);
        select = select + ",0 as periodbeginqty,periodbeginamount,periodbegindifferamount,periodbeginstandardamount,0 as periodbeginprice,0 as periodinqty,periodinamount,periodindifferamount,periodinstandardamount,0 as periodinprice,0 as periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount,0 as periodoutprice,0 as periodendqty,periodendamount,periodenddifferamount,periodendstandardamount,0 as periodendprice";
        return select;
    }

    private DataSet groupDataSetByPeriod(DataSet dataSet) {
        if (this.isGroupByPeriod) {
            DataSet dataSet1 = dataSet.groupBy(this.getGroupCols(false).split(",")).minP("periodnumber", "periodbeginqty", "periodbeginqty").minP("periodnumber", "periodbeginamount", "periodbeginamount").minP("periodnumber", "periodbegindifferamount", "periodbegindifferamount").minP("periodnumber", "periodbeginstandardamount", "periodbeginstandardamount").sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").maxP("periodnumber", "periodendqty", "periodendqty").maxP("periodnumber", "periodendamount", "periodendamount").minP("periodnumber", "periodenddifferamount", "periodenddifferamount").maxP("periodnumber", "periodendstandardamount", "periodendstandardamount").finish();
            dataSet1 = dataSet1.addField("concat(concat('" + this.filter_startPeriod.getString("number") + "','-'),'" + this.filter_endPeriod.getString("number") + "')", "periodnumber").addField("0", "year").addField("0", "month");
            return dataSet1.select(this.getFinalSelectFields().split(","));
        }
        return dataSet;
    }

    private DataSet noShowZeroInOut(DataSet dataSet) {
        if (this.noShowZeroInOut) {
            return dataSet.filter("periodinqty <> 0 or periodoutqty <> 0 or periodinstandardamount <> 0 or periodindifferamount <> 0 or periodoutstandardamount <> 0 or periodoutdifferamount <> 0 or periodinamount <> 0 or periodoutamount <> 0 ");
        }
        return dataSet.filter("periodbeginqty <> 0 or periodinqty <> 0 or periodoutqty <> 0 or periodbeginamount <> 0 or periodinamount <> 0 or periodoutamount <> 0 or periodbeginstandardamount <> 0 or periodinstandardamount <> 0 or periodoutstandardamount <> 0 or periodbegindifferamount <> 0 or periodindifferamount <> 0 or periodoutdifferamount <> 0");
    }

    private DataSet unionGroupDataSet(DataSet dataSet) {
        DataSet periodHappenTotalDataSet = dataSet.copy();
        if (this.showdetail) {
            periodHappenTotalDataSet = periodHappenTotalDataSet.groupBy(this.getGroupCols("0").split(",")).max("periodbeginqty").sum("periodbeginamount").sum("periodbegindifferamount").sum("periodbeginstandardamount").max("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").max("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").max("periodendqty").sum("periodendamount").sum("periodenddifferamount").sum("periodendstandardamount").max("qtyprecision").maxP("qtyprecision", "baseunitid").finish();
            String str = "periodbeginstandardamount <>0 or periodbegindifferamount <> 0 or periodinstandardamount <> 0 or periodindifferamount <> 0 or periodoutstandardamount <> 0 or periodoutdifferamount <> 0";
            dataSet = dataSet.filter(str).select(this.getFinalSelectFieldsWithNoQty().split(","));
        } else {
            periodHappenTotalDataSet = periodHappenTotalDataSet.groupBy(this.getGroupCols("0").split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodbegindifferamount").sum("periodbeginstandardamount").sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").sum("periodendqty").sum("periodendamount").sum("periodenddifferamount").sum("periodendstandardamount").max("qtyprecision").maxP("qtyprecision", "baseunitid").finish();
        }
        periodHappenTotalDataSet = periodHappenTotalDataSet.select(this.getFinalSelectFields("0").split(","));
        if (this.isGroupByPeriod) {
            DataSet allTotalDataSet = periodHappenTotalDataSet.copy();
            allTotalDataSet = allTotalDataSet.groupBy(this.getGroupCols("3").split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodbegindifferamount").sum("periodbeginstandardamount").sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").sum("periodendqty").sum("periodendamount").sum("periodenddifferamount").sum("periodendstandardamount").max("qtyprecision").maxP("qtyprecision", "baseunitid").finish();
            allTotalDataSet = allTotalDataSet.select(this.getFinalSelectFields("3").split(","));
            return dataSet.addField("0", "ordercol").addField("0", "ordercol1").union(periodHappenTotalDataSet.addField("0", "ordercol").addField("1", "ordercol1")).union(allTotalDataSet.addField("1", "ordercol").addField("2", "ordercol1")).orderBy(this.getOrders().split(","));
        }
        DataSet periodTotalDataSet = periodHappenTotalDataSet.copy();
        periodTotalDataSet = periodTotalDataSet.groupBy(this.getGroupCols("1").split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodbegindifferamount").sum("periodbeginstandardamount").sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").sum("periodendqty").sum("periodendamount").sum("periodenddifferamount").sum("periodendstandardamount").max("qtyprecision").maxP("qtyprecision", "baseunitid").finish();
        periodTotalDataSet = periodTotalDataSet.select(this.getFinalSelectFields("1").split(","));
        DataSet yearTotalDataSet = periodTotalDataSet.copy();
        yearTotalDataSet = yearTotalDataSet.groupBy(this.getGroupCols("2").split(",")).sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").max("qtyprecision").maxP("qtyprecision", "baseunitid").finish();
        DataSet beginDataSet = null;
        if (this.isNewBalance) {
            beginDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_initbill", (String)"period.periodyear as year,entryentity.yearinqty as yearinqty,entryentity.yearincost + entryentity.yearincostdiff as yearinactualcost,entryentity.yearincostdiff as yearincostdiff,case when costaccount.enablestandardcost = '1' or  entryentity.accounttype = 'D' then entryentity.yearincost else 0 end as yearinstandradcost,entryentity.yearissueqty as yearissueqty,entryentity.yearissuecost + entryentity.yearissuecostdiff as yearissueactualcost,entryentity.yearissuecostdiff as yearissuecostdiff,case when costaccount.enablestandardcost = '1' or  entryentity.accounttype = 'D' then entryentity.yearissuecost else 0 end as yearissuestandradcost", (QFilter[])new QFilter[]{this.getInitBillFilter()}, null).groupBy(new String[]{"year"}).sum("yearinqty").sum("yearinactualcost").sum("yearinstandradcost").sum("yearincostdiff").sum("yearissueqty").sum("yearissueactualcost").sum("yearissuestandradcost").sum("yearissuecostdiff").finish();
        } else {
            beginDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)"id,year,yearinqty,yearinactualcost,yearinstandradcost,yearincostdiff,yearissueqty,yearissueactualcost,yearissuestandradcost,yearissuecostdiff", (QFilter[])new QFilter[]{this.getFilter(true)}, null);
            beginDataSet = beginDataSet.groupBy(new String[]{"year"}).sum("yearinqty").sum("yearinactualcost").sum("yearinstandradcost").sum("yearincostdiff").sum("yearissueqty").sum("yearissueactualcost").sum("yearissuestandradcost").sum("yearissuecostdiff").finish();
        }
        yearTotalDataSet = yearTotalDataSet.join(beginDataSet, JoinType.LEFT).on("year", "year").select(new String[]{"costaccountnumber", "costaccountname", "calorgnumber", "calorgname", "year", "0 as periodbeginqty", "0 as periodbeginamount", "0 as periodbegindifferamount", "0 as periodbeginstandardamount", "periodinqty+yearinqty as periodinqty", "periodinamount+yearinactualcost as periodinamount", "periodindifferamount+yearincostdiff as periodindifferamount", "periodinstandardamount+yearinstandradcost as periodinstandardamount", "periodoutqty+yearissueqty as periodoutqty", "periodoutamount+yearissueactualcost as periodoutamount", "periodoutdifferamount+yearissuecostdiff as periodoutdifferamount", "periodoutstandardamount+yearissuestandradcost as periodoutstandardamount", "0 as periodendqty", "0 as periodendamount", "0 as periodenddifferamount", "0 as periodendstandardamount", "qtyprecision", "baseunitid"}).finish();
        yearTotalDataSet = yearTotalDataSet.select(this.getFinalSelectFields("2").split(","));
        DataSet allTotalDataSet = periodTotalDataSet.copy();
        allTotalDataSet = allTotalDataSet.groupBy(this.getGroupCols("3").split(",")).minP("periodnumber", "periodbeginqty").minP("periodnumber", "periodbeginamount").minP("periodnumber", "periodbegindifferamount").minP("periodnumber", "periodbeginstandardamount").sum("periodinqty").sum("periodinamount").sum("periodindifferamount").sum("periodinstandardamount").sum("periodoutqty").sum("periodoutamount").sum("periodoutdifferamount").sum("periodoutstandardamount").maxP("periodnumber", "periodendqty").maxP("periodnumber", "periodendamount").maxP("periodnumber", "periodenddifferamount").maxP("periodnumber", "periodendstandardamount").max("qtyprecision").maxP("qtyprecision", "baseunitid").finish().select(new String[]{"costaccountnumber", "costaccountname", "calorgnumber", "calorgname", "periodbeginqty", "periodbeginamount", "periodbegindifferamount", "periodbeginstandardamount", "periodendqty+periodoutqty-periodbeginqty as periodinqty", "periodendamount+periodoutamount-periodbeginamount as periodinamount", "periodenddifferamount+periodoutdifferamount-periodbegindifferamount as periodindifferamount", "periodendstandardamount+periodoutstandardamount-periodbeginstandardamount as periodinstandardamount", "periodoutqty", "periodoutamount", "periodoutdifferamount", "periodoutstandardamount", "periodendqty", "periodendamount", "periodenddifferamount", "periodendstandardamount", "qtyprecision", "baseunitid"});
        allTotalDataSet = allTotalDataSet.select(this.getFinalSelectFields("3").split(","));
        return dataSet.addField("0", "ordercol").addField("0", "ordercol1").union(periodHappenTotalDataSet.addField("0", "ordercol").addField("1", "ordercol1")).union(periodTotalDataSet.addField("1", "ordercol").addField("2", "ordercol1")).union(yearTotalDataSet.addField("2", "ordercol").addField("3", "ordercol1")).union(allTotalDataSet.addField("3", "ordercol").addField("4", "ordercol1")).orderBy(this.getOrders().split(","));
    }

    private QFilter getInitBillFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("entryentity.invtype.isforwardamount", "=", (Object)true);
        if (this.filter_calrange != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_calrange) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.calrange", "in", set);
        }
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costadjustbill");
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.location", "in", set);
        }
        if (this.filter_lot != null) {
            q.and("entryentity.lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.project", "in", set);
        }
        if (this.filter_trackNumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_trackNumber) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.tracknumber", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invstatus", "in", set);
        }
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                q.and("entryentity.material", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("entryentity.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("entryentity.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        if (this.filter_mulMaterialCategory != null) {
            HashSet<Long> materialCategorySet = new HashSet<Long>();
            for (DynamicObject materialCategory : this.filter_mulMaterialCategory) {
                materialCategorySet.add(materialCategory.getLong("id"));
            }
            q.and("entryentity.stocktype", "in", materialCategorySet);
        }
        if (this.filter_startPeriod != null) {
            q.and(new QFilter("period", ">=", this.filter_startPeriod.getPkValue()));
        }
        if (this.filter_endPeriod != null) {
            q.and(new QFilter("period", "<=", this.filter_endPeriod.getPkValue()));
        }
        QFilter qFilter1 = new QFilter("id", "=", this.filter_costAccount.getPkValue());
        DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"enablestandardcost", (QFilter[])new QFilter[]{qFilter1});
        boolean enableStandardCost = costAccount.getBoolean("enablestandardcost");
        if (!enableStandardCost) {
            q.and(QFilter.of((String)"entryentity.accounttype = 'D'", (Object[])new Object[0]));
        }
        return q;
    }

    private DataSet onlyShowSumRow(DataSet dataSet) {
        if (this.onlyShowSumRow) {
            return dataSet.filter("ordercol <> 0 or ordercol1 <> 0");
        }
        return dataSet;
    }

    private DataSet addActualPrice(DataSet dataSet) {
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        ArrayList<String> fieldsList = new ArrayList<String>(Arrays.asList(fieldNames));
        fieldsList.add("case when periodendqty != 0 then periodendamount / periodendqty else 0 end as periodendactualprice");
        fieldsList.add("case when periodbeginqty != 0 then periodbeginamount / periodbeginqty else 0 end as periodbeginactualprice");
        fieldsList.add("case when periodinqty != 0 then periodinamount / periodinqty else 0 end as periodinactualprice");
        fieldsList.add("case when periodoutqty != 0 then periodoutamount / periodoutqty else 0 end as periodoutactualprice");
        dataSet = dataSet.select(fieldsList.toArray(new String[fieldsList.size()]));
        return dataSet;
    }

    private DataSet addDiffActualPrice(DataSet dataSet) {
        ArrayList<String> fieldsList = new ArrayList<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
        fieldsList.add("case when (periodbeginqty + periodinqty) != 0 then (periodbeginamount + periodinamount) / (periodbeginqty + periodinqty) else 0 end as beginandinactualprice");
        dataSet = dataSet.select(fieldsList.toArray(new String[fieldsList.size()]));
        fieldsList = new ArrayList<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
        fieldsList.add("case when periodendqty != 0 then (periodendactualprice - beginandinactualprice) else 0 end as enddiffactualprice");
        fieldsList.add("case when periodoutqty != 0 then (periodoutactualprice - beginandinactualprice) else 0 end as outdiffactualprice");
        dataSet = dataSet.select(fieldsList.toArray(new String[fieldsList.size()]));
        dataSet.getRowMeta().getField("enddiffactualprice").setDataType((DataType)new BigDecimalType());
        dataSet.getRowMeta().getField("outdiffactualprice").setDataType((DataType)new BigDecimalType());
        return dataSet;
    }

    private String getGroupCols(String sumType) {
        StringBuilder sql = new StringBuilder();
        sql.append("costaccountnumber,costaccountname,calorgnumber,calorgname");
        if ("0".equals(sumType)) {
            sql.append(",year,month,periodnumber");
            this.appendCommonGroupCols(sql, false);
            if (this.showdetail) {
                sql.append(",materialnumber,materialname,materialid");
            }
        } else if ("1".equals(sumType)) {
            sql.append(",year,month,periodnumber");
        } else if ("2".equals(sumType)) {
            sql.append(",year");
        } else if ("3".equals(sumType)) {
            // empty if block
        }
        return sql.toString();
    }

    private String getFinalSelectFields(String sumType) {
        String select = this.getSelectByGroupCols(sumType);
        select = select + ",periodbeginqty,periodbeginamount,periodbegindifferamount,periodbeginstandardamount," + this.getPriceSelect("periodbeginstandardamount", "periodbeginqty") + " as periodbeginprice,periodinqty,periodinamount,periodindifferamount,periodinstandardamount," + this.getPriceSelect("periodinstandardamount", "periodinqty") + " as periodinprice,periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount," + this.getPriceSelect("periodoutstandardamount", "periodoutqty") + " as periodoutprice,";
        select = select + "periodendqty,periodendamount,periodenddifferamount,periodendstandardamount," + this.getPriceSelect("periodendstandardamount", "periodendqty") + " as periodendprice";
        return select;
    }

    private String getSelectByGroupCols(String sumType) {
        StringBuilder sql = new StringBuilder();
        if ("0".equals(sumType)) {
            String s1 = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"StockGatherRptQueryPlugin_29", (String)"fi-cal-report", (Object[])new Object[0]);
            sql.append("costaccountnumber,costaccountname,calorgnumber,calorgname");
            sql.append(",year,month,periodnumber");
            this.appendCommonGroupCols(sql, false);
            if (this.showdetail) {
                sql.append(",null as costelementnumber");
                sql.append(",'").append(s1).append("' as costelementname");
                sql.append(",null as costsubelementnumber,null as costsubelementname");
                sql.append(",materialnumber,materialname,materialid");
            } else {
                sql.append(",'").append(s1).append("' as materialnumber");
                sql.append(",null as materialname,0 as materialid");
            }
        } else if ("1".equals(sumType)) {
            String s2 = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_30", (String)"fi-cal-report", (Object[])new Object[0]);
            sql.append("null as costaccountnumber,null as costaccountname,null as calorgnumber,null as calorgname");
            sql.append(",year,month,periodnumber");
            this.appendCommonGroupCols(sql, true);
            this.getCostElementField(sql, this.showdetail);
            sql.append(",'").append(s2).append("' as materialnumber");
            sql.append(",null as materialname,0 as materialid");
        } else if ("2".equals(sumType)) {
            String s3 = ResManager.loadKDString((String)"\u672c\u5e74\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_31", (String)"fi-cal-report", (Object[])new Object[0]);
            sql.append("null as costaccountnumber,null as costaccountname,null as calorgnumber,null as calorgname");
            if (this.topSumRow) {
                sql.append(",year,0 as month,year as periodnumber");
            } else {
                sql.append(",year,99 as month,year as periodnumber");
            }
            this.appendCommonGroupCols(sql, true);
            this.getCostElementField(sql, this.showdetail);
            sql.append(",'").append(s3).append("' as materialnumber");
            sql.append(",null as materialname,0 as materialid");
        } else if ("3".equals(sumType)) {
            String s4 = ResManager.loadKDString((String)"\u603b\u8ba1", (String)"StockGatherRptQueryPlugin_32", (String)"fi-cal-report", (Object[])new Object[0]);
            sql.append("null as costaccountnumber,null as costaccountname,null as calorgnumber,null as calorgname");
            if (this.topSumRow) {
                sql.append(",0 as year,0 as month,null as periodnumber");
            } else {
                sql.append(",9999 as year,99 as month,null as periodnumber");
            }
            this.appendCommonGroupCols(sql, true);
            this.getCostElementField(sql, this.showdetail);
            sql.append(",'").append(s4).append("' as materialnumber");
            sql.append(",null as materialname,0 as materialid");
        }
        sql.append(",null as model,null as baseunitname,");
        sql.append("baseunitid as baseunitid,qtyprecision as qtyprecision,").append(this.currencyId).append(" as currencyid");
        return sql.toString();
    }

    private void getCostElementField(StringBuilder sql, Boolean showdetail) {
        if (showdetail.booleanValue()) {
            sql.append(",null as costelementnumber,null as costelementname,null as costsubelementnumber,null as costsubelementname");
        }
    }

    private String getPriceSelect(String amount, String qty) {
        return "case when " + qty + " = 0 then 0 else " + amount + "/" + qty + " end ";
    }

    private String getGroupCols() {
        StringBuilder sql = new StringBuilder();
        sql.append(this.getGroupColsWithOutCostElement());
        sql.append(",costelementnumber,costelementname,costsubelementnumber,costsubelementname");
        return sql.toString();
    }

    private String getGroupCols(boolean havePeriodCol) {
        StringBuilder sql = new StringBuilder();
        sql.append("costaccountnumber,costaccountname,calorgnumber,calorgname");
        if (havePeriodCol) {
            sql.append(",year,month,periodnumber");
        }
        this.appendCommonGroupCols(sql, false);
        if (this.showdetail) {
            sql.append(",costelementnumber,costelementname,costsubelementnumber,costsubelementname");
        }
        sql.append(",materialnumber,materialname,materialid,model,baseunitname,baseunitid,qtyprecision,currencyid");
        return sql.toString();
    }

    private String getGroupColsWithOutCostElement() {
        StringBuilder sql = new StringBuilder();
        sql.append("costaccountnumber,costaccountname,calorgnumber,calorgname");
        sql.append(",year,month,periodnumber");
        sql.append(",ownertype,owner");
        sql.append(",storageorgnumber,storageorgname,storageorgid");
        sql.append(",warehousenumber,warehousename,warehouseid");
        sql.append(",warehsgroupnumber,warehsgroupname,warehsgroupid");
        sql.append(",locationnumber,locationname,locationid,invtype,invstatus");
        sql.append(",lot");
        sql.append(",assist");
        sql.append(",projectname,projectid,tracknumber,materialcategory");
        sql.append(",materialnumber,materialname,materialid,model,baseunitname,baseunitid,qtyprecision,currencyid");
        return sql.toString();
    }

    private String getBalSelectAliasFields() {
        String select = "id,costaccountnumber,costaccountname,calorgnumber,calorgname,periodnumber,endperiod,year,month,ownerid,storageorgnumber,storageorgname,storageorgid,warehousenumber,warehousename,warehouseid,warehsgroupnumber,warehsgroupname,warehsgroupid,locationnumber,locationname,locationid,materialnumber,materialname,materialid,model,projectname,projectid,lot,assist,baseunitname,baseunitid,qtyprecision,currencyid,costelementnumber,costelementname,costsubelementnumber,costsubelementname,periodbeginqty,periodbeginamount,periodbegindifferamount,periodbeginstandardamount,periodinqty,periodinamount,periodindifferamount,periodinstandardamount,periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount,periodendqty,periodendamount,periodenddifferamount,periodendstandardamount";
        return select;
    }

    private String getNewBalSelectFields() {
        String select = "id,accounttype,costaccount.number as costaccountnumber,costaccount.name as costaccountname,calorg.number as calorgnumber,calorg.name as calorgname,period as periodnumber,endperiod as endperiod,year,month,ownertype,owner,storageorgunit.number as storageorgnumber,storageorgunit.name as storageorgname,storageorgunit.id as storageorgid,warehouse.number as warehousenumber,warehouse.name as warehousename,warehouse.id as warehouseid,warehouse.group.number as warehsgroupnumber,warehouse.group.name as warehsgroupname,warehouse.group.id as warehsgroupid,location.number as locationnumber,location.name as locationname,location.id as locationid,invtype,invstatus,material.number as materialnumber,material.name as materialname,material.id as materialid,material.modelnum as model,mversion,project.name as projectname,project.id as projectid,tracknumber.number as tracknumber,stocktype as materialcategory,lot as lot,assist as assist,baseunit.name as baseunitname,baseunit.id as baseunitid,baseunit.precision as qtyprecision,calpolicy.currency.id as currencyid,costelement.number as costelementnumber,costelement.name as costelementname,costsubelement.number as costsubelementnumber,costsubelement.name as costsubelementname,baseqty as periodbeginqty,actualcost as periodbeginamount,costdiff as periodbegindifferamount,standardcost as periodbeginstandardamount,baseqty_in as periodinqty,actualcost_in as periodinamount,costdiff_in as periodindifferamount,standardcost_in as periodinstandardamount,baseqty_out as periodoutqty,actualcost_out as periodoutamount,costdiff_out as periodoutdifferamount,standardcost_out as periodoutstandardamount,baseqty_bal as periodendqty,actualcost_bal as periodendamount,costdiff_bal as periodenddifferamount,standardcost_bal as periodendstandardamount";
        return select;
    }

    private String getBalSelectFields() {
        String select = "id,accounttype,costaccount.number as costaccountnumber,costaccount.name as costaccountname,calorg.number as calorgnumber,calorg.name as calorgname,period as periodnumber,endperiod as endperiod,year,month,ownertype,owner,storageorgunit.number as storageorgnumber,storageorgunit.name as storageorgname,storageorgunit.id as storageorgid,warehouse.number as warehousenumber,warehouse.name as warehousename,warehouse.id as warehouseid,warehouse.group.number as warehsgroupnumber,warehouse.group.name as warehsgroupname,warehouse.group.id as warehsgroupid,location.number as locationnumber,location.name as locationname,location.id as locationid,invtype,invstatus,material.number as materialnumber,material.name as materialname,material.id as materialid,material.modelnum as model,mversion,project.name as projectname,project.id as projectid,tracknumber.number as tracknumber,stocktype as materialcategory,lot as lot,assist as assist,baseunit.name as baseunitname,baseunit.id as baseunitid,baseunit.precision as qtyprecision,calpolicy.currency.id as currencyid";
        if (!this.showdetail) {
            select = select + ",'' as costelementnumber,'' as costelementname,'' as costsubelementnumber,'' as costsubelementname,periodbeginqty as periodbeginqty,beginstandardcost + periodbegincostdiff as periodbeginamount,periodbegincostdiff as periodbegindifferamount,beginstandardcost as periodbeginstandardamount,periodinqty as periodinqty,periodinstandardcost + periodincostdiff as periodinamount,periodincostdiff as periodindifferamount,periodinstandardcost as periodinstandardamount,periodissueqty as periodoutqty,periodissuestandardcost + periodissuecostdiff as periodoutamount,periodissuecostdiff as periodoutdifferamount,periodissuestandardcost as periodoutstandardamount,periodendqty as periodendqty,periodendstandardcost + periodendcostdiff as periodendamount,periodendcostdiff as periodenddifferamount,periodendstandardcost as periodendstandardamount";
        }
        return select;
    }

    private String getBalDetailSelectFields() {
        String select = "balid,costelement.number as costelementnumber,costelement.name as costelementname,costsubelement.number as costsubelementnumber,costsubelement.name as costsubelementname,periodbeginqty as periodbeginqty,periodbeginactualcost as periodbeginamount,periodbegincostdiff as periodbegindifferamount,beginstandardcost as periodbeginstandardamount,periodinqty as periodinqty,periodinactualcost as periodinamount,periodincostdiff as periodindifferamount,periodinstandardcost as periodinstandardamount,periodissueqty as periodoutqty,periodissueactualcost as periodoutamount,periodissuecostdiff as periodoutdifferamount,periodissuestandardcost as periodoutstandardamount,periodendqty as periodendqty,periodendactualcost as periodendamount,periodendcostdiff as periodenddifferamount,periodendstandardcost as periodendstandardamount";
        return select;
    }

    private String getBalNoDetailSelectFields(boolean isNeedId) {
        StringBuilder select = new StringBuilder();
        if (isNeedId) {
            select.append("id,");
        }
        select.append("accounttype,costaccountnumber,costaccountname,calorgnumber,calorgname,periodnumber,endperiod,year,month,ownertype,owner,storageorgnumber,storageorgname,storageorgid,warehousenumber,warehousename,warehouseid,warehsgroupnumber,warehsgroupname,warehsgroupid,locationnumber,locationname,locationid,invtype,invstatus,materialnumber,materialname,materialid,model,mversion,projectname,projectid,tracknumber,materialcategory,lot,assist,baseunitname,baseunitid,qtyprecision,currencyid");
        return select.toString();
    }

    private String getBalNoShowDetailFinalSelectFields() {
        String select = "id,accounttype,costaccountnumber,costaccountname,calorgnumber,calorgname,periodnumber,endperiod,year,month,ownertype,owner,storageorgnumber,storageorgname,storageorgid,warehousenumber,warehousename,warehouseid,warehsgroupnumber,warehsgroupname,warehsgroupid,locationnumber,locationname,locationid,invtype,invstatus,materialnumber,materialname,materialid,model,mversion,projectname,projectid,tracknumber,materialcategory,lot,assist,baseunitname,baseunitid,qtyprecision,currencyid,'' as costelementnumber,'' as costelementname,'' as costsubelementnumber,'' as costsubelementname,periodbeginqty,periodbeginamount,periodbegindifferamount,periodbeginstandardamount,periodinqty,periodinamount,periodindifferamount,periodinstandardamount,periodoutqty,periodoutamount,periodoutdifferamount,periodoutstandardamount,periodendqty,periodendamount,periodenddifferamount,periodendstandardamount";
        return select;
    }

    private String getBalDetailAllSelectFields() {
        String select = "costelementnumber,costelementname,costsubelementnumber,costsubelementname,periodbeginqty,periodbeginstandardamount + periodbegindifferamount as periodbeginamount,periodbegindifferamount,periodbeginstandardamount,periodinqty,periodinstandardamount + periodindifferamount as periodinamount,periodindifferamount,periodinstandardamount,periodoutqty,periodoutstandardamount + periodoutdifferamount as periodoutamount,periodoutdifferamount,periodoutstandardamount,periodendqty,periodendstandardamount + periodenddifferamount as periodendamount,periodenddifferamount,periodendstandardamount";
        return select;
    }

    private QFilter getFilter(boolean onlyBeginData) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        if (this.filter_calrange != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_calrange) {
                set.add(info.getPkValue());
            }
            q.and("calrange", "in", set);
        }
        q.and("invtype.isforwardamount", "=", (Object)true);
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_balance");
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("location", "in", set);
        }
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                q.and("material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        if (this.filter_mulMaterialCategory != null) {
            HashSet<Long> materialCategorySet = new HashSet<Long>();
            for (DynamicObject materialCategory : this.filter_mulMaterialCategory) {
                materialCategorySet.add(materialCategory.getLong("id"));
            }
            q.and("stocktype", "in", materialCategorySet);
        }
        if (this.filter_lot != null) {
            q.and("lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_invType != null) {
            HashSet<Long> invTypeSet = new HashSet<Long>();
            for (DynamicObject invType : this.filter_invType) {
                invTypeSet.add(invType.getLong("id"));
            }
            q.and("invtype.id", "in", invTypeSet);
        }
        if (this.filter_invStatus != null) {
            HashSet<Long> invStatusSet = new HashSet<Long>();
            for (DynamicObject invStatus : this.filter_invStatus) {
                invStatusSet.add(invStatus.getLong("id"));
            }
            q.and("invstatus.id", "in", invStatusSet);
        }
        if (this.filter_project != null) {
            HashSet<Long> projectSet = new HashSet<Long>();
            for (DynamicObject project : this.filter_project) {
                projectSet.add(project.getLong("id"));
            }
            q.and("project.id", "in", projectSet);
        }
        if (this.filter_trackNumber != null) {
            HashSet<Long> trackNumberSet = new HashSet<Long>();
            for (DynamicObject trackNumber : this.filter_trackNumber) {
                trackNumberSet.add(trackNumber.getLong("id"));
            }
            q.and("tracknumber.id", "in", trackNumberSet);
        }
        QFilter q1 = new QFilter("period", "<=", (Object)this.filter_endPeriodNumber);
        q1.and(new QFilter("endperiod", ">=", (Object)this.filter_startPeriodNumber));
        QFilter q2 = new QFilter("period", "=", (Object)0);
        if (onlyBeginData) {
            q.and(q2);
            QFilter qFilter1 = new QFilter("id", "=", this.filter_costAccount.getPkValue());
            DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"enablestandardcost", (QFilter[])new QFilter[]{qFilter1});
            boolean enableStandardCost = costAccount.getBoolean("enablestandardcost");
            if (!enableStandardCost) {
                q.and(QFilter.of((String)"accounttype = 'D'", (Object[])new Object[0]));
            }
        } else {
            q.and(q1);
        }
        return q;
    }

    private void appendCommonGroupCols(StringBuilder sql, boolean isSelectNullField) {
        if (this.hasGroup(this.groupType, "B")) {
            // empty if block
        }
        if (this.hasGroup(this.groupType, "C")) {
            if (isSelectNullField) {
                sql.append(",null as ownertype,0 as owner");
            } else {
                sql.append(",ownertype,owner");
            }
        }
        if (this.hasGroup(this.groupType, "D")) {
            if (isSelectNullField) {
                sql.append(",null as storageorgnumber,null as storageorgname,0 as storageorgid");
            } else {
                sql.append(",storageorgnumber,storageorgname,storageorgid");
            }
        }
        if (this.hasGroup(this.groupType, "E")) {
            if (isSelectNullField) {
                if (!this.hasGroup(this.groupType, "D")) {
                    sql.append(",null as storageorgnumber,null as storageorgname,0 as storageorgid");
                }
                sql.append(",null as warehousenumber,null as warehousename,0 as warehouseid");
            } else {
                if (!this.hasGroup(this.groupType, "D")) {
                    sql.append(",storageorgnumber,storageorgname,storageorgid");
                }
                sql.append(",warehousenumber,warehousename,warehouseid");
            }
        }
        if (this.hasGroup(this.groupType, "F")) {
            if (isSelectNullField) {
                if (!this.hasGroup(this.groupType, "D") && !this.hasGroup(this.groupType, "E")) {
                    sql.append(",null as storageorgnumber,null as storageorgname,0 as storageorgid");
                }
                if (!this.hasGroup(this.groupType, "E")) {
                    sql.append(",null as warehousenumber,null as warehousename,0 as warehouseid");
                }
                sql.append(",null as locationnumber,null as locationname,0 as locationid");
            } else {
                if (!this.hasGroup(this.groupType, "D") && !this.hasGroup(this.groupType, "E")) {
                    sql.append(",storageorgnumber,storageorgname,storageorgid");
                }
                if (!this.hasGroup(this.groupType, "E")) {
                    sql.append(",warehousenumber,warehousename,warehouseid");
                }
                sql.append(",locationnumber,locationname,locationid");
            }
        }
        if (this.hasGroup(this.groupType, "G")) {
            if (isSelectNullField) {
                sql.append(",null as lot");
            } else {
                sql.append(",lot");
            }
        }
        if (this.hasGroup(this.groupType, "H")) {
            if (isSelectNullField) {
                sql.append(",null as assist");
            } else {
                sql.append(",assist");
            }
        }
        if (this.hasGroup(this.groupType, "I")) {
            if (isSelectNullField) {
                sql.append(",null as projectname,0 as projectid");
            } else {
                sql.append(",projectname,projectid");
            }
        }
        if (this.hasGroup(this.groupType, "J")) {
            if (isSelectNullField) {
                sql.append(",null as warehsgroupnumber,null as warehsgroupname,0 as warehsgroupid");
            } else {
                sql.append(",warehsgroupnumber,warehsgroupname,warehsgroupid");
            }
        }
        if (this.hasGroup(this.groupType, "L")) {
            if (isSelectNullField) {
                sql.append(",0 as materialcategory");
            } else {
                sql.append(",materialcategory");
            }
        }
        if (this.hasGroup(this.groupType, "M")) {
            if (isSelectNullField) {
                sql.append(",null as tracknumber");
            } else {
                sql.append(",tracknumber");
            }
        }
    }

    private String getOrders() {
        StringBuilder sql = new StringBuilder();
        sql.append("year,month,periodnumber");
        if (this.topSumRow) {
            sql.append(",ordercol desc");
        } else {
            sql.append(",ordercol");
        }
        this.appendCommonGroupCols(sql, false);
        sql.append(",materialnumber,materialname");
        if (this.topSumRow) {
            sql.append(",ordercol1 desc");
        } else {
            sql.append(",ordercol1");
        }
        sql.append(",model,baseunitname,baseunitid,currencyid");
        return sql.toString();
    }

    private void createColumnsByGroupType(List<AbstractReportColumn> cols) {
        if (this.hasGroup(this.groupType, "B")) {
            this.createCalRangeColumns(cols);
        }
        if (!this.hasGroup(this.groupType, "C")) {
            ReportUtil.hideOwnerColumns(cols);
        }
        if (this.hasGroup(this.groupType, "D")) {
            this.createStorageColumns(cols);
        }
        if (this.hasGroup(this.groupType, "E")) {
            if (!this.hasGroup(this.groupType, "D")) {
                this.createStorageColumns(cols);
            }
            this.createWarehouseColumns(cols);
        }
        if (this.hasGroup(this.groupType, "F")) {
            if (!this.hasGroup(this.groupType, "D") && !this.hasGroup(this.groupType, "E")) {
                this.createStorageColumns(cols);
            }
            if (!this.hasGroup(this.groupType, "E")) {
                this.createWarehouseColumns(cols);
            }
            this.createLocationColumns(cols);
        }
        if (this.hasGroup(this.groupType, "G")) {
            this.createLotColumns(cols);
        }
        if (this.hasGroup(this.groupType, "H")) {
            this.createAssistPropertyColumns(cols);
        }
        if (this.hasGroup(this.groupType, "I")) {
            this.createProjectColumns(cols);
        }
        if (this.hasGroup(this.groupType, "J")) {
            this.createWarehsgroupColumns(cols);
        }
        if (this.hasGroup(this.groupType, "M")) {
            this.createTrackNumColumns(cols);
        }
        if (this.hasGroup(this.groupType, "L")) {
            this.createMaterialCategoryColumns(cols);
        }
    }

    private void createMaterialCategoryColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_MaterialCategoryNum, this.locale_MaterialCategoryName, "materialcategory", "bd_materialcategory");
    }

    private void createGroupTypeColumns(List<AbstractReportColumn> cols, LocaleString numCaption, LocaleString nameCaption, String fieldKey, String entityId) {
        ReportColumn id = ReportColumn.createBaseDataColumn((String)fieldKey, (String)entityId);
        id.setDisplayProp("number");
        id.setCaption(numCaption);
        id.setWidth(width);
        ReportColumn name = ReportColumn.createBaseDataPropColumn((String)(fieldKey + "name"), (String)fieldKey, (String)"name");
        name.setCaption(nameCaption);
        name.setWidth(width);
        cols.add((AbstractReportColumn)id);
        cols.add((AbstractReportColumn)name);
    }

    private void createWarehsgroupColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_warehouseGroupNum, this.locale_warehouseGroupName, "warehsgroup");
    }

    private boolean hasGroup(String groupType, String value) {
        return groupType.indexOf(value) >= 0;
    }

    private void createCostElementColumns(List<AbstractReportColumn> cols) {
        if (this.showdetail) {
            this.createCostDetailColumns(cols);
        }
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        this.createColumnsByGroupType(cols);
        this.createMaterialColumns(cols);
        this.createCostElementColumns(cols);
        this.createBaseUnitColumns(cols);
        this.createDecimalColumns(cols);
        this.createHideColumns(cols);
        this.createDiffColumns(cols);
        return cols;
    }

    private void createCostDetailColumns(List<AbstractReportColumn> cols) {
        ReportColumn costelementNum = new ReportColumn();
        costelementNum.setCaption(this.locale_costelementNum);
        costelementNum.setWidth(width);
        costelementNum.setFieldKey("costelementnumber");
        costelementNum.setFieldType("text");
        cols.add((AbstractReportColumn)costelementNum);
        ReportColumn costelementName = new ReportColumn();
        costelementName.setCaption(this.locale_costelementName);
        costelementName.setWidth(width);
        costelementName.setFieldKey("costelementname");
        costelementName.setFieldType("text");
        cols.add((AbstractReportColumn)costelementName);
        ReportColumn costsubelementNum = new ReportColumn();
        costsubelementNum.setCaption(this.locale_costsubelementNum);
        costsubelementNum.setWidth(width);
        costsubelementNum.setFieldKey("costsubelementnumber");
        costsubelementNum.setFieldType("text");
        cols.add((AbstractReportColumn)costsubelementNum);
        ReportColumn costsubelementName = new ReportColumn();
        costsubelementName.setCaption(this.locale_costsubelementName);
        costsubelementName.setWidth(width);
        costsubelementName.setFieldKey("costsubelementname");
        costsubelementName.setFieldType("text");
        cols.add((AbstractReportColumn)costsubelementName);
    }

    private void createProjectColumns(List<AbstractReportColumn> cols) {
        ReportColumn projectNum = new ReportColumn();
        projectNum.setCaption(this.locale_projectNum);
        projectNum.setWidth(width);
        projectNum.setFieldKey("projectname");
        projectNum.setFieldType("text");
        cols.add((AbstractReportColumn)projectNum);
        ReportColumn projectId = new ReportColumn();
        projectId.setCaption(this.locale_projectNum);
        projectId.setWidth(width);
        projectId.setFieldKey("projectid");
        projectId.setFieldType("text");
        projectId.setHide(true);
        cols.add((AbstractReportColumn)projectId);
    }

    private void createGroupTypeColumns(List<AbstractReportColumn> cols, LocaleString numCaption, LocaleString nameCaption, String fieldKey) {
        ReportColumn number = new ReportColumn();
        number.setCaption(numCaption);
        number.setWidth(width);
        number.setFieldKey(fieldKey + "number");
        number.setFieldType("text");
        ReportColumn name = new ReportColumn();
        name.setCaption(nameCaption);
        name.setWidth(width);
        name.setFieldKey(fieldKey + "name");
        name.setFieldType("text");
        ReportColumn id = new ReportColumn();
        id.setCaption(numCaption);
        id.setWidth(width);
        id.setFieldKey(fieldKey + "id");
        id.setFieldType("text");
        id.setHide(true);
        cols.add((AbstractReportColumn)number);
        cols.add((AbstractReportColumn)name);
        cols.add((AbstractReportColumn)id);
    }

    private void createCalRangeColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_calRangeNum, this.locale_calRangeName, "calrange");
    }

    private void createOwnerColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_ownerNum, this.locale_ownerName, "owner");
    }

    private void createStorageColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_storageOrgNum, this.locale_storageOrgName, "storageorg");
    }

    private void createWarehouseColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_warehouseNum, this.locale_warehouseName, "warehouse");
    }

    private void createLocationColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_locationNum, this.locale_locationName, "location");
    }

    private void createTrackNumColumns(List<AbstractReportColumn> cols) {
        StockDifferGroupRptQueryPlugin.createTextColumn(cols, locale_trackNum, "tracknumber");
    }

    private static void createTextColumn(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumn matGroup = new ReportColumn();
        matGroup.setCaption(groupName);
        matGroup.setFieldKey(fieldKey);
        matGroup.setFieldType("text");
        cols.add((AbstractReportColumn)matGroup);
    }

    private void createMaterialColumns(List<AbstractReportColumn> cols) {
        ReportColumn materialNumber = new ReportColumn();
        materialNumber.setCaption(this.locale_materialNum);
        materialNumber.setWidth(width);
        materialNumber.setFieldKey("materialnumber");
        materialNumber.setFieldType("text");
        ReportColumn materialName = new ReportColumn();
        materialName.setCaption(this.locale_materialName);
        materialName.setWidth(width);
        materialName.setFieldKey("materialname");
        materialName.setFieldType("text");
        Tips tips = new Tips("text", "");
        tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u8054\u67e5\u660e\u7ec6\u8868", (String)"StockGatherRptQueryPlugin_33", (String)"fi-cal-report", (Object[])new Object[0])));
        materialName.setCtlTips(tips);
        materialName.setHyperlink(true);
        ReportColumn model = new ReportColumn();
        model.setCaption(this.locale_model);
        model.setWidth(width);
        model.setFieldKey("model");
        model.setFieldType("text");
        ReportColumn materialid = new ReportColumn();
        materialid.setCaption(this.locale_materialNum);
        materialid.setWidth(width);
        materialid.setFieldKey("materialid");
        materialid.setFieldType("basedata");
        materialid.setEntityId("bd_material");
        materialid.setHide(true);
        cols.add((AbstractReportColumn)materialNumber);
        cols.add((AbstractReportColumn)materialName);
        cols.add((AbstractReportColumn)materialid);
        cols.add((AbstractReportColumn)model);
    }

    private void createBaseUnitColumns(List<AbstractReportColumn> cols) {
        ReportColumn baseUnitName = new ReportColumn();
        baseUnitName.setCaption(this.locale_baseUnit);
        baseUnitName.setWidth(width);
        baseUnitName.setFieldKey("baseunitname");
        baseUnitName.setFieldType("text");
        cols.add((AbstractReportColumn)baseUnitName);
    }

    private void createLotColumns(List<AbstractReportColumn> cols) {
        ReportColumn lot = new ReportColumn();
        lot.setCaption(this.locale_lot);
        lot.setWidth(width);
        lot.setFieldKey("lot");
        lot.setFieldType("text");
        cols.add((AbstractReportColumn)lot);
    }

    private void createDiffColumns(List<AbstractReportColumn> cols) {
        ReportColumn enddiffactualprice = new ReportColumn();
        enddiffactualprice.setCaption(this.locale_enddiffactualprice);
        enddiffactualprice.setWidth(width);
        enddiffactualprice.setFieldKey("enddiffactualprice");
        enddiffactualprice.setFieldType("price");
        enddiffactualprice.setCurrencyField("currencyid");
        cols.add((AbstractReportColumn)enddiffactualprice);
        ReportColumn outdiffactualprice = new ReportColumn();
        outdiffactualprice.setCaption(this.locale_outdiffactualprice);
        outdiffactualprice.setWidth(width);
        outdiffactualprice.setFieldKey("outdiffactualprice");
        outdiffactualprice.setFieldType("price");
        outdiffactualprice.setCurrencyField("currencyid");
        cols.add((AbstractReportColumn)outdiffactualprice);
    }

    private void createAssistPropertyColumns(List<AbstractReportColumn> cols) {
        ReportColumn assist = new ReportColumn();
        assist.setCaption(this.locale_assistProperty);
        assist.setWidth(width);
        assist.setFieldKey("assist");
        assist.setFieldType("flex");
        assist.setRefBasedataProp("materialid");
        assist.setEntityId("bd_auxproperty");
        cols.add((AbstractReportColumn)assist);
    }

    private void createDecimalColumns(List<AbstractReportColumn> cols) {
        this.createDecimalColumn(cols, this.locale_periodBegin, "periodbegin");
        this.createDecimalColumn(cols, this.locale_periodIn, "periodin");
        this.createDecimalColumn(cols, this.locale_periodOut, "periodout");
        this.createDecimalColumn(cols, this.locale_periodEnd, "periodend");
    }

    private void createDecimalColumn(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey);
        cols.add((AbstractReportColumn)groupCol);
        ReportColumn qty = new ReportColumn();
        qty.setCaption(this.locale_qty);
        qty.setWidth(width);
        qty.setFieldKey(fieldKey + "qty");
        qty.setFieldType("qty");
        qty.setMeasureUnitField("baseunitid");
        ReportColumn price = new ReportColumn();
        price.setCaption(this.locale_price);
        price.setWidth(width);
        price.setFieldKey(fieldKey + "price");
        price.setFieldType("price");
        price.setCurrencyField("currencyid");
        ReportColumn standardAmount = new ReportColumn();
        standardAmount.setCaption(this.locale_standardAmount);
        standardAmount.setWidth(width);
        standardAmount.setFieldKey(fieldKey + "standardamount");
        standardAmount.setFieldType("amount");
        standardAmount.setCurrencyField("currencyid");
        ReportColumn differAmount = new ReportColumn();
        differAmount.setCaption(this.locale_differAmount);
        differAmount.setWidth(width);
        differAmount.setFieldKey(fieldKey + "differamount");
        differAmount.setFieldType("amount");
        differAmount.setCurrencyField("currencyid");
        ReportColumn actualAmount = new ReportColumn();
        actualAmount.setCaption(this.locale_actualAmount);
        actualAmount.setWidth(width);
        actualAmount.setFieldKey(fieldKey + "amount");
        actualAmount.setFieldType("amount");
        actualAmount.setCurrencyField("currencyid");
        ReportColumn actualPrice = new ReportColumn();
        actualPrice.setCaption(this.locale_actualPrice);
        actualPrice.setWidth(width);
        actualPrice.setFieldKey(fieldKey + "actualprice");
        actualPrice.setFieldType("price");
        actualPrice.setCurrencyField("currencyid");
        groupCol.getChildren().add(qty);
        groupCol.getChildren().add(price);
        groupCol.getChildren().add(standardAmount);
        groupCol.getChildren().add(differAmount);
        groupCol.getChildren().add(actualAmount);
        groupCol.getChildren().add(actualPrice);
    }

    private void createHideColumns(List<AbstractReportColumn> cols) {
        ReportColumn baseUnitId = new ReportColumn();
        baseUnitId.setCaption(this.locale_baseUnit);
        baseUnitId.setWidth(width);
        baseUnitId.setFieldKey("baseunitid");
        baseUnitId.setFieldType("unit");
        baseUnitId.setEntityId("bd_measureunits");
        baseUnitId.setHide(true);
        ReportColumn currencyId = new ReportColumn();
        currencyId.setCaption(this.locale_currency);
        currencyId.setWidth(width);
        currencyId.setFieldKey("currencyid");
        currencyId.setFieldType("currency");
        currencyId.setEntityId("bd_currency");
        currencyId.setHide(true);
        cols.add((AbstractReportColumn)baseUnitId);
        cols.add((AbstractReportColumn)currencyId);
        ReportColumn year = new ReportColumn();
        year.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e74", (String)"StockGatherRptQueryPlugin_34", (String)"fi-cal-report", (Object[])new Object[0])));
        year.setWidth(width);
        year.setFieldKey("year");
        year.setFieldType("integer");
        year.setHide(true);
        ReportColumn month = new ReportColumn();
        month.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6708", (String)"StockGatherRptQueryPlugin_35", (String)"fi-cal-report", (Object[])new Object[0])));
        month.setWidth(width);
        month.setFieldKey("month");
        month.setFieldType("integer");
        month.setHide(true);
        cols.add((AbstractReportColumn)year);
        cols.add((AbstractReportColumn)month);
    }
}

