/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.ReportUtil;

public class StockEstimateDetailRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(StockEstimateDetailRptQueryPlugin.class);
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private DynamicObject filter_startPeriod;
    private DynamicObject filter_endPeriod;
    private int filter_startPeriodNumber;
    private int filter_endPeriodNumber;
    private long baseUnitId;
    private Map<Long, Long> materialIdAndBaseUnitId;
    private long currencyId;
    private String filter_ownertype;
    private DynamicObjectCollection filter_ownerFrom;
    private String filter_mullot;
    private DynamicObjectCollection filter_trackNumber;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private DynamicObjectCollection filter_supplierFrom;
    private DynamicObject filter_supplierTo;
    private String filter_billno;
    private DynamicObjectCollection filter_billtype;
    private boolean filter_noShowZeroInOut;
    private boolean showPartition;
    private String materialCostorProcessCostSelect = null;
    private String[] filter_dischargeType;
    private boolean filter_ContainAdjustBill;
    private Date filter_endDate;
    private Date filter_startDate;
    private long materialId;
    private List<Long> materialIds;
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private LocaleString local_periodIn = new LocaleString(this.getLocal_periodIn());
    private LocaleString local_periodWriteoff = new LocaleString(this.getLocal_periodWriteoff());
    private LocaleString local_periodNotWriteoff = new LocaleString(this.getLocal_periodNotWriteoff());
    private LocaleString local_periodEnd = new LocaleString(this.getLocal_periodEnd());
    private LocaleString local_qty = new LocaleString(this.getLocal_qty());
    private LocaleString local_price = new LocaleString(this.getLocal_price());
    private LocaleString local_amount = new LocaleString(this.getLocal_amount());
    private LocaleString local_baseUnit = new LocaleString(this.getLocal_baseUnit());
    private LocaleString local_currency = new LocaleString(this.getLocal_currency());
    private static final LocaleString width = new LocaleString("100px");
    private LocaleString locale_assistProperty = new LocaleString(this.getLocale_assistProperty());
    private LocaleString locale_materialNo = new LocaleString(this.getLocale_materialNo());
    private LocaleString locale_materialName = new LocaleString(this.getLocale_materialName());
    private LocaleString locale_materialModel = new LocaleString(this.getLocale_materialModel());
    private LocaleString locale_materialUnit = new LocaleString(this.getLocale_materialUnit());
    private static String[] TOTALGROUP_ONE_MATERIAL = new String[]{"ordercol1", "year", "period", "ordercol2", "bookdate", "auditdate", "billnumber"};
    private static String[] TOTALGROUP_MULTI_MATERIAL = new String[]{"ordercol1", "year", "period", "head_materialnumber", "material", "ordercol2", "bookdate", "auditdate", "billnumber"};
    private static String[] GROUPONE_ONE_MATERIAL = new String[]{"year", "period"};
    private static String[] GROUPONE_MULTI_MATERIAL = new String[]{"material", "year", "period"};
    private static String[] GROUPTHREE_ONE_MATERIAL = new String[]{"ordercol1", "year", "period", "ordercol2"};
    private static String[] GROUPTHREE_MULTI_MATERIAL = new String[]{"material", "ordercol1", "year", "period", "ordercol2"};
    private static String[] GROUPFOUR_ONE_MATERIAL = new String[]{"ordercol1", "year", "period", "ordercol2"};
    private static String[] GROUPFOUR_MULTI_MATERIAL = new String[]{"ordercol1", "material", "year", "period", "ordercol2"};
    private static String[] GROUPFOUR_ORDER_ONE_MATERIAL = new String[]{"year desc", "period desc"};
    private static String[] GROUPFOUR_ORDER_MULTI_MATERIAL = new String[]{"year desc", "material desc", "period desc"};
    private static String[] MATERIAL_FIELDS = new String[]{"head_materialnumber", "head_materialname", "head_baseunit", "head_model"};
    private static String[] WOGSA = new String[]{"writeoffperiod", "ownertype", "owner", "storageorgnumber", "storageorgname", "warehsgroupnumber", "warehsgroupname", "warehousenumber", "warehousename", "locationnumber", "locationname", "bizdate", "auditdate", "bookdate", "billnumber", "supplier", "biztype", "assist", "woqty", "woamount", "lot", "tracknumber"};
    private static String[] SUM_NOT_WRITEOffGSA = new String[]{"allperiodid", "year", "period", "entryid", "ownertype", "owner", "storageorgnumber", "storageorgname", "warehsgroupnumber", "warehsgroupname", "warehousenumber", "warehousename", "locationnumber", "locationname", "bizdate", "bookdate", "billnumber", "supplier", "biztype", "assist", "lot", "tracknumber"};
    private static String[] NOT_WRITEOFFIN = new String[]{"entryid", "inperiod", "writeoffendperiod", "inqty", "inamount", "ownertype", "owner", "storageorgnumber", "storageorgname", "warehsgroupnumber", "warehsgroupname", "warehousenumber", "warehousename", "locationnumber", "locationname", "bizdate", "auditdate", "bookdate", "billnumber", "supplier", "biztype", "assist", "lot", "tracknumber"};
    private static String[] NOT_WRITEOFFLEFT = new String[]{"allperiodid", "year", "period", "entryid", "inperiod", "inqty", "inamount", "ownertype", "owner", "storageorgnumber", "storageorgname", "warehsgroupnumber", "warehsgroupname", "warehousenumber", "warehousename", "locationnumber", "locationname", "bizdate", "auditdate", "bookdate", "billnumber", "supplier", "biztype", "assist", "lot", "tracknumber"};

    private String getLocal_periodIn() {
        return ResManager.loadKDString((String)"\u5165\u5e93", (String)"StockEstimateDetailRptQueryPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_periodWriteoff() {
        return ResManager.loadKDString((String)"\u5df2\u6838\u9500", (String)"StockEstimateDetailRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_periodNotWriteoff() {
        return ResManager.loadKDString((String)"\u672a\u6838\u9500", (String)"StockEstimateDetailRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_periodEnd() {
        return ResManager.loadKDString((String)"\u7ed3\u5b58", (String)"StockEstimateDetailRptQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_qty() {
        return ResManager.loadKDString((String)"\u6570\u91cf", (String)"StockEstimateDetailRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_price() {
        return ResManager.loadKDString((String)"\u5355\u4ef7", (String)"StockEstimateDetailRptQueryPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_amount() {
        return ResManager.loadKDString((String)"\u91d1\u989d", (String)"StockEstimateDetailRptQueryPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_baseUnit() {
        return ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"StockEstimateDetailRptQueryPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_currency() {
        return ResManager.loadKDString((String)"\u5e01\u79cd", (String)"StockEstimateDetailRptQueryPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_assistProperty() {
        return ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"StockEstimateDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_slotName() {
        return ResManager.loadKDString((String)"\u4ed3\u4f4d\u540d\u79f0", (String)"StockGatherRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialNo() {
        return ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"StockDetailRptQueryPlugin_17", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialName() {
        return ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"StockDetailRptQueryPlugin_18", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialModel() {
        return ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"StockGatherRptQueryPlugin_19", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialUnit() {
        return ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"StockGatherRptQueryPlugin_62", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        try {
            this.init(param);
            DataSet periodInDataSet = this.getPeriodInDataSet();
            if (!this.showPartition && this.materialIds.isEmpty()) {
                return periodInDataSet;
            }
            DataSet periodWriteoffDataSet = this.getPeriodWriteoffDataSet();
            DataSet periodNotWriteoffDataSet = this.getPeriodNotWriteoffDataSet();
            DataSet dataSet = this.unionAllDataSet(periodInDataSet, periodWriteoffDataSet, periodNotWriteoffDataSet);
            dataSet = this.unionPeriodBalanceDataSet(dataSet);
            dataSet = this.unionToalDataSet(dataSet);
            String[] orderSelectFields = this.showPartition ? TOTALGROUP_ONE_MATERIAL : TOTALGROUP_MULTI_MATERIAL;
            dataSet = dataSet.orderBy(orderSelectFields);
            dataSet = dataSet.addField("owner", "ownernumber");
            return dataSet;
        }
        catch (Exception e) {
            StringBuilder sBuilder = new StringBuilder("stockDetailRpt=?");
            if (e instanceof KDBizException) {
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage());
                }
            } else {
                StackTraceElement[] errs;
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage()).append("\n");
                }
                for (StackTraceElement err : errs = e.getStackTrace()) {
                    sBuilder.append(err.toString()).append("\n");
                }
            }
            logger.info(sBuilder.toString());
            throw e;
        }
    }

    private void init(ReportQueryParam param) {
        this.filterInfo = param.getFilter();
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.filter_startPeriod = this.filterInfo.getDynamicObject("startperiod");
        this.filter_endPeriod = this.filterInfo.getDynamicObject("endperiod");
        this.filter_startPeriodNumber = this.filter_startPeriod.getInt("periodyear") * 100 + this.filter_startPeriod.getInt("periodnumber");
        this.filter_endPeriodNumber = this.filter_endPeriod.getInt("periodyear") * 100 + this.filter_endPeriod.getInt("periodnumber");
        this.filter_startDate = this.filter_startPeriod.getDate("begindate");
        this.filter_endDate = this.filter_endPeriod.getDate("enddate");
        Object filterInfoValue = this.filterInfo.getFilterItem("currentMaterialId").getValue();
        this.materialId = Long.parseLong((String)filterInfoValue);
        DynamicObjectCollection materialColl = QueryServiceHelper.query((String)"bd_material", (String)"baseunit.id", (QFilter[])new QFilter("id", "=", (Object)this.materialId).toArray());
        if (materialColl.size() > 0) {
            this.baseUnitId = ((DynamicObject)materialColl.get(0)).getLong("baseunit.id");
        }
        this.currencyId = this.filterInfo.getDynamicObject("localcurrency").getLong("id");
        this.filter_mullot = this.filterInfo.getString("mullot");
        this.filter_trackNumber = this.filterInfo.getDynamicObjectCollection("multracknum");
        this.filter_ownertype = (String)this.filterInfo.getValue("ownertypehead");
        if (StringUtils.isNotEmpty((CharSequence)this.filter_ownertype)) {
            if ("bos_org".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        this.filter_supplierFrom = this.filterInfo.getDynamicObjectCollection("mulsupplier");
        this.filter_supplierTo = this.filterInfo.getDynamicObject("supplierto");
        this.filter_billno = this.filterInfo.getString("billno");
        this.filter_billtype = this.filterInfo.getDynamicObjectCollection("mulbilltype");
        this.filter_noShowZeroInOut = this.filterInfo.getBoolean("noshowzeroinout");
        this.filter_ContainAdjustBill = this.filterInfo.getBoolean("containadjustbill");
        String dischargeType = this.filterInfo.getString("muldischargetype");
        if (dischargeType != null && !"".equals(CommonUtils.trimComma((String)dischargeType))) {
            this.filter_dischargeType = CommonUtils.trimComma((String)dischargeType).split(",");
        }
        this.showPartition = this.filterInfo.getBoolean("showpartition");
        if (!this.showPartition) {
            String[] materialIdsString;
            Object filterInfoValues = this.filterInfo.getFilterItem("materialIds").getValue();
            this.materialIds = new ArrayList<Long>(16);
            String[] stringArray = materialIdsString = filterInfoValues == null ? null : ((String)filterInfoValues).split(",");
            if (materialIdsString != null) {
                for (String materialId : materialIdsString) {
                    if (materialId == null || materialId.length() == 0) continue;
                    this.materialIds.add(Long.valueOf(materialId));
                }
            }
            this.materialIdAndBaseUnitId = new HashMap<Long, Long>(16);
            DynamicObjectCollection materialColls = QueryServiceHelper.query((String)"bd_material", (String)"id,baseunit.id", (QFilter[])new QFilter("id", "in", this.materialIds).toArray());
            for (DynamicObject material : materialColls) {
                if (material == null) continue;
                this.materialIdAndBaseUnitId.put(material.getLong("id"), material.getLong("baseunit.id"));
            }
        }
    }

    private String addField(String select, String append) {
        StringBuilder sb = new StringBuilder(select);
        return sb.append(append).toString();
    }

    private String[] addField(String[] selects, String field) {
        String[] container = new String[selects.length + 1];
        System.arraycopy(selects, 0, container, 0, selects.length);
        container[container.length - 1] = field;
        return container;
    }

    private DataSet getPeriodInDataSet() {
        QFilter q = this.getPeriodInFilter();
        DataSet periodInDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getPeriodInSelects(), (QFilter[])q.toArray(), null);
        return periodInDataSet.groupBy(this.getFinalSelects("base").split(",")).sum("periodinqty").sum("periodinamount").min("auditdate").finish().select(this.getFinalSelects("base") + ",auditdate," + this.getFinalSelects("periodin"));
    }

    private QFilter getPeriodInFilter() {
        QFilter q = this.getBaseFilter();
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("bookdate", ">=", (Object)this.filter_startDate);
        q.and("issplitcreate", "=", (Object)false);
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        q.and("isinitbill", "=", (Object)false);
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        return q;
    }

    private String getPeriodInSelects() {
        String s = "period.periodyear as year, period.periodnumber as period, entry.ownertype as ownertype, entry.owner as owner, storageorgunit.number as storageorgnumber, storageorgunit.name as storageorgname, entry.warehouse.group.number as warehsgroupnumber, entry.warehouse.group.name as warehsgroupname, entry.warehouse.number as warehousenumber, entry.warehouse.name as warehousename, entry.location.number as locationnumber, entry.location.name as locationname, bizdate,auditdate,bookdate, billnumber, entry.balancesupplier as supplier, billtype.name as biztype, entry.assist as assist, entry.baseqty as periodinqty," + this.getMaterialCostorProcessCostSelects() + " as periodinamount, entry.lot as lot, entry.tracknumber as tracknumber";
        if (!this.showPartition) {
            s = this.addField(s, ",entry.material as material");
        }
        return s;
    }

    private String getMaterialCostorProcessCostSelects() {
        if (this.materialCostorProcessCostSelect == null) {
            DynamicObject setting = CommonSettingHelper.getSettingObj();
            DynamicObjectCollection ominBizobjects = setting.getDynamicObjectCollection("ominbiztype");
            HashSet<String> set = new HashSet<String>();
            for (DynamicObject bizobject : ominBizobjects) {
                set.add("'" + (String)bizobject.getDynamicObject("fbasedataid").getPkValue() + "'");
            }
            this.materialCostorProcessCostSelect = set.isEmpty() ? "entry.materialcost" : "case when bizentityobject in (" + String.join((CharSequence)",", set) + ") then entry.processcost else entry.materialcost end";
        }
        return this.materialCostorProcessCostSelect;
    }

    private DataSet getPeriodWriteoffDataSet() {
        QFilter q = this.getPeriodWriteoffFilter();
        DataSet periodWriteoffDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getPeriodWriteoffSelects(), (QFilter[])q.toArray(), null);
        if (this.filter_ContainAdjustBill) {
            QFilter costadjustBaseFilter = this.getCostAdjustBaseFilter(false);
            QFilter stdCostAdjustBaseFilter = this.getCostAdjustBaseFilter(true);
            DataSet costAdjustDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjustbill", (String)this.getCostAdjustSelect(), (QFilter[])costadjustBaseFilter.toArray(), null);
            DataSet diffBillDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)this.getCostAdjustSelect(), (QFilter[])stdCostAdjustBaseFilter.toArray(), null);
            periodWriteoffDataSet = periodWriteoffDataSet.union(costAdjustDataSet).union(diffBillDataSet);
        }
        return periodWriteoffDataSet.groupBy(this.getFinalSelects("base").split(",")).sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").min("auditdate").finish().select(this.getFinalSelects("base") + ",auditdate," + this.getFinalSelects("periodwriteoff"));
    }

    private String getCostAdjustSelect() {
        String s = "id,period.periodyear as year, period.periodnumber as period, entryentity.ownertype as ownertype, entryentity.owner as owner,entryentity.storageorgunit.number as storageorgnumber, entryentity.storageorgunit.name as storageorgname, entryentity.warehouse.group.number as warehsgroupnumber, entryentity.warehouse.group.name as warehsgroupname, entryentity.warehouse.number as warehousenumber, entryentity.warehouse.name as warehousename, entryentity.location.number as locationnumber, entryentity.location.name as locationname, bizdate,auditdate,bookdate, billno as billnumber, custsupplier as supplier, billtype.name as biztype, entryentity.assist as assist, 0 as periodinqty,entryentity.adjustamt as periodinamount,0 as periodwriteoffqty,entryentity.adjustamt as periodwriteoffamount, entryentity.lot as lot, entryentity.tracknumber as tracknumber";
        if (!this.showPartition) {
            s = this.addField(s, ",entryentity.material as material");
        }
        return s;
    }

    private QFilter getCostAdjustBaseFilter(boolean isStdCostAdjust) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        if (this.showPartition) {
            q.and("entryentity.material", "=", (Object)this.materialId);
        } else {
            q.and("entryentity.material", "in", this.materialIds);
        }
        if (this.filter_mullot != null && !this.filter_mullot.equals("")) {
            q.and("entryentity.lot", "=", (Object)this.filter_mullot);
        }
        if (this.filter_trackNumber != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_trackNumber) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.tracknumber", "in", set);
        }
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costadjustbill");
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.location", "in", set);
        }
        if (this.filter_supplierFrom != null) {
            q.and("custsupplier", "in", (Object)ReportUtil.getBasedateIdsFromDyColNumers((DynamicObjectCollection)this.filter_supplierFrom, (String)"bd_supplier"));
        }
        if (this.filter_billno.length() >= 1) {
            q.and("entryentity.invbillnum", "like", (Object)(this.filter_billno + "%"));
        }
        if (this.filter_billtype != null) {
            set = new HashSet();
            for (DynamicObject billtype : this.filter_billtype) {
                set.add(billtype.getPkValue());
            }
            q.and("billtype.billformid", "in", set);
        }
        q.and("biztype", "=", (Object)"A");
        q.and("createtype", "in", (Object)new String[]{"B", "U"});
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        if (!isStdCostAdjust) {
            q.and("entryentity.accounttype", "<>", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        }
        return q;
    }

    private QFilter getPeriodWriteoffFilter() {
        QFilter q = this.getBaseFilter();
        q.and("writeoffstatus", "=", (Object)"A");
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    private String getPeriodWriteoffSelects() {
        String s = "id,writeoffperiod.periodyear as year, writeoffperiod.periodnumber as period, entry.ownertype as ownertype, entry.owner as owner,storageorgunit.number as storageorgnumber, storageorgunit.name as storageorgname, entry.warehouse.group.number as warehsgroupnumber, entry.warehouse.group.name as warehsgroupname, entry.warehouse.number as warehousenumber, entry.warehouse.name as warehousename, entry.location.number as locationnumber, entry.location.name as locationname, bizdate,auditdate,bookdate, billnumber, entry.balancesupplier as supplier, billtype.name as biztype, entry.assist as assist, 0 as periodinqty,0 as periodinamount,entry.baseqty as periodwriteoffqty," + this.getMaterialCostorProcessCostSelects() + " as periodwriteoffamount, entry.lot as lot, entry.tracknumber as tracknumber";
        if (!this.showPartition) {
            s = this.addField(s, ",entry.material as material");
        }
        return s;
    }

    private DataSet getPeriodNotWriteoffDataSet() {
        QFilter baseFilter = this.getBaseFilter();
        QFilter inFilter = new QFilter("writeoffperiod", "<=", this.filter_endPeriod.getPkValue());
        inFilter.and("issplitcreate", "=", (Object)false);
        inFilter.and(new QFilter("writeoffendperiod", "=", (Object)0).or("writeoffendperiod", ">", this.filter_startPeriod.getPkValue()));
        inFilter.and(baseFilter);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        inFilter.and(billStatusf);
        DataSet inDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getInSelect(), (QFilter[])inFilter.toArray(), null);
        DataSet inDSCopy = inDS.copy();
        HashSet<Long> ancestorentryidSet = new HashSet<Long>(16);
        for (Row row : inDSCopy) {
            ancestorentryidSet.add(row.getLong("entryid"));
        }
        QFilter woFilter = new QFilter("writeoffstatus", "=", (Object)"A");
        woFilter.and("issplitcreate", "=", (Object)true);
        woFilter.and("entry.ancestorentryid", "in", ancestorentryidSet);
        woFilter.and(baseFilter);
        woFilter.and("writeoffperiod", "<=", this.filter_endPeriod.getPkValue());
        woFilter.and(billStatusf);
        DataSet woDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getWOSelect(), (QFilter[])woFilter.toArray(), null);
        DataSet periodDS = this.getPeriodDataSet();
        DataSet ds = periodDS.join(inDS, JoinType.CROSS).select(new String[]{"allperiodid", "year", "period"}, this.getStringArr("NotWriteOffIn")).finish().where("inperiod <= allperiodid and (writeoffendperiod = 0 or writeoffendperiod > allperiodid)");
        ds = ds.select(this.getFinalSelects("periodnotwoAddzero")).union(ds.join(woDS, JoinType.LEFT).on("entryid", "subentryid").select(this.getStringArr("NotWriteOffLeft"), new String[]{"writeoffperiod", "woqty", "woamount"}).finish().where("writeoffperiod = null or writeoffperiod <= allperiodid").select(this.getFinalSelects("periodnotwonull2zero")));
        ds = ds.groupBy(this.getStringArr("sumNotWriteOffGSA")).max("inqty").max("inamount").sum("woqty").sum("woamount").min("auditdate").finish().select(this.getFinalSelects("base") + ",auditdate," + this.getFinalSelects("periodnotwriteoff")).where("periodnotwriteoffqty <> 0 or periodnotwriteoffamount <> 0");
        return ds;
    }

    private String getWOSelect() {
        String s = "entry.ancestorentryid as subentryid,writeoffperiod,entry.baseqty as woqty," + this.getMaterialCostorProcessCostSelects() + " as woamount";
        if (!this.showPartition) {
            s = this.addField(s, ",entry.material as material");
        }
        return s;
    }

    private String getInSelect() {
        String s = "entry.id as entryid,period as inperiod,writeoffendperiod,entry.ownertype as ownertype, entry.owner as owner, storageorgunit.number as storageorgnumber,storageorgunit.name as storageorgname, entry.warehouse.group.number as warehsgroupnumber, entry.warehouse.group.name as warehsgroupname, entry.warehouse.number as warehousenumber,entry.warehouse.name as warehousename, entry.location.number as locationnumber,entry.location.name as locationname, bizdate,auditdate,bookdate,billnumber,entry.balancesupplier as supplier,billtype.name as biztype, entry.assist as assist, entry.baseqty as inqty," + this.getMaterialCostorProcessCostSelects() + " as inamount, entry.lot as lot, entry.tracknumber as tracknumber";
        if (!this.showPartition) {
            s = this.addField(s, ",entry.material as material");
        }
        return s;
    }

    private DataSet unionAllDataSet(DataSet periodInDataSet, DataSet periodWriteoffDataSet, DataSet periodNotWriteoffDataSet) {
        DataSet dataSet = periodInDataSet.union(periodWriteoffDataSet).union(periodNotWriteoffDataSet).groupBy(this.getFinalSelects("base").split(",")).sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").sum("periodnotwriteoffqty").sum("periodnotwriteoffamount").min("auditdate").finish().select((this.getFinalSelects("base") + ",auditdate," + this.getFinalSelects("calall")).split(","));
        dataSet = dataSet.select(this.getFinalSelects("all"));
        return dataSet.addField("1", "ordercol2");
    }

    private DataSet unionPeriodBalanceDataSet(DataSet dataSet) {
        DataSet beforePeriodDataSet = this.getBeforePeriodDataSet();
        if (!this.filter_noShowZeroInOut) {
            String selectFields = "ownertype,owner,storageorgnumber, storageorgname,warehsgroupnumber,warehsgroupname, warehousenumber, warehousename, locationnumber, locationname, bizdate,auditdate,bookdate, billnumber, supplier, biztype, assist, lot,tracknumber,periodinqty, periodinprice, periodinamount, periodwriteoffqty, periodwriteoffprice, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffprice, periodnotwriteoffamount, ordercol2";
            if (!this.showPartition) {
                selectFields = this.addField(selectFields, ",material");
            }
            DataSet periodDataSet = this.getPeriodDataSet();
            dataSet = periodDataSet.join(dataSet, JoinType.LEFT).on("year", "year").on("period", "period").select(new String[]{"year", "period"}, selectFields.split(",")).finish().select(this.getFinalSelects("allandbeforeperiod"));
        }
        String s = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"StockEstimateDetailRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]);
        if (this.showPartition) {
            dataSet = dataSet.union(dataSet.where("periodinamount <> 0 or periodwriteoffamount <>0 or periodnotwriteoffamount<>0 or periodinqty <> 0 or periodwriteoffqty <>0 or periodnotwriteoffqty<>0").groupBy(new String[]{"year", "period"}).finish().select(("year,period,null as ownertype, 0 as owner, null as storageorgnumber,null as storageorgname,null as warehsgroupnumber,null as warehsgroupname,null as warehousenumber,null as warehousename,null as locationnumber,null as locationname,null as bizdate,null as auditdate,null as bookdate, null as billnumber, null as supplier, '" + s + "' as biztype, null as assist, null as lot,null as tracknumber,0 as periodinqty,0 as periodinprice,0 as periodinamount,0 as periodwriteoffqty,0 as periodwriteoffprice,0 as periodwriteoffamount,0 as periodnotwriteoffqty,0 as periodnotwriteoffprice,0 as periodnotwriteoffamount, 0 as ordercol2").split(",")));
            dataSet = dataSet.join(beforePeriodDataSet, JoinType.LEFT).on("ordercol2", "ordercol2").select((this.getFinalSelects("all") + ",ordercol2").split(","), new String[]{"periodbalanceqty", "periodbalanceamount"}).finish().select(this.getFinalSelects("allandbalancenonull"));
        } else {
            dataSet = dataSet.union(dataSet.where("periodinamount <> 0 or periodwriteoffamount <>0 or periodnotwriteoffamount<>0 or periodinqty <> 0 or periodwriteoffqty <>0 or periodnotwriteoffqty<>0").groupBy(new String[]{"year", "period", "material"}).finish().select(("year,period,null as ownertype, 0 as owner, null as storageorgnumber,null as storageorgname,null as warehsgroupnumber,null as warehsgroupname,null as warehousenumber,null as warehousename,null as locationnumber,null as locationname,null as bizdate,null as auditdate,null as bookdate, null as billnumber, null as supplier, '" + s + "' as biztype, null as assist, null as lot,null as tracknumber, 0 as periodinqty,0 as periodinprice,0 as periodinamount,0 as periodwriteoffqty,0 as periodwriteoffprice,0 as periodwriteoffamount,0 as periodnotwriteoffqty,0 as periodnotwriteoffprice,0 as periodnotwriteoffamount, 0 as ordercol2,material").split(",")));
            dataSet = dataSet.join(beforePeriodDataSet, JoinType.LEFT).on("ordercol2", "ordercol2").on("material", "material").select((this.getFinalSelects("all") + ",ordercol2").split(","), new String[]{"periodbalanceqty", "periodbalanceamount"}).finish().select(this.getFinalSelects("allandbalancenonull"));
        }
        dataSet = this.showPartition ? dataSet.orderBy(new String[]{"year", "period", "ordercol2", "bookdate", "auditdate", "billnumber"}).select((this.getFinalSelects("all") + ",case when PreRowValue(periodbalanceqty)=null then periodbalanceqty else PreRowValue(periodbalanceqty) + periodinqty- periodwriteoffqty end as periodbalanceqty, case when PreRowValue(periodbalanceamount)=null then periodbalanceamount else PreRowValue(periodbalanceamount)+ periodinamount-periodwriteoffamount end as periodbalanceamount,ordercol2,0 as ordercol1").split(",")) : dataSet.orderBy(new String[]{"material", "year", "period", "ordercol2", "bookdate", "auditdate", "billnumber"}).select((this.getFinalSelects("all") + ",case when PreRowValue(material) = material and PreRowValue(periodbalanceqty) != null then PreRowValue(periodbalanceqty) + periodinqty- periodwriteoffqty else periodbalanceqty end as periodbalanceqty, case when PreRowValue(material) = material and PreRowValue(periodbalanceamount) != null then PreRowValue(periodbalanceamount)+ periodinamount-periodwriteoffamount else periodbalanceamount end as periodbalanceamount,ordercol2,0 as ordercol1").split(","));
        DataSet initInDataSet = this.getInitDataSet();
        dataSet = this.showPartition ? dataSet.join(initInDataSet, JoinType.LEFT).on("ordercol1", "ordercol1").select((this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1").split(","), new String[]{"year as rYear", "period as rPeriod", "initqty", "initamount"}).finish().select(this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1,case when rYear = null then 0 else rYear end as rYear, case when rPeriod = null then 0 else rPeriod end as rPeriod,case when initqty = null then 0 else initqty end as initqty, case when initamount = null then 0 else initamount end as initamount").select(this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1,rYear,rPeriod,case when year*100+period >= rYear*100+rPeriod then initqty else 0 end as initqty, case when year*100+period >= rYear*100+rPeriod then initamount else 0 end as initamount") : dataSet.join(initInDataSet, JoinType.LEFT).on("ordercol1", "ordercol1").on("material", "material").select((this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1").split(","), new String[]{"year as rYear", "period as rPeriod", "initqty", "initamount"}).finish().select(this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1,case when rYear = null then 0 else rYear end as rYear, case when rPeriod = null then 0 else rPeriod end as rPeriod,case when initqty = null then 0 else initqty end as initqty, case when initamount = null then 0 else initamount end as initamount").select(this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1,rYear,rPeriod,case when year*100+period >= rYear*100+rPeriod then initqty else 0 end as initqty, case when year*100+period >= rYear*100+rPeriod then initamount else 0 end as initamount");
        String groupFields = this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1";
        if (!this.showPartition) {
            groupFields = this.addField(groupFields, ",material");
        }
        dataSet = dataSet.groupBy(groupFields.split(",")).sum("initqty").sum("initamount").finish().select(this.getFinalSelects("all") + ",periodbalanceqty + initqty as periodbalanceqty,periodbalanceamount + initamount as periodbalanceamount,ordercol2,ordercol1");
        DataSet result = this.showPartition ? dataSet.orderBy(new String[]{"year", "period", "ordercol2 desc"}).select((this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1,case when ordercol2=0 and PreRowValue(ordercol2)=1 then 1 else 0 end as flag").split(",")).where("ordercol2=1 or (ordercol2=0 and (periodbalanceqty <> 0 or periodbalanceamount<>0)) or (flag = 1)").select((this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1").split(",")) : dataSet.orderBy(new String[]{"year", "material", "period", "ordercol2 desc"}).select((this.getFinalSelects("all") + ",periodbalanceqty,periodbalanceamount,ordercol2,ordercol1,case when ordercol2=0 and PreRowValue(ordercol2)=1 then 1 else 0 end as flag").split(",")).where("ordercol2=1 or (ordercol2=0 and (periodbalanceqty <> 0 or periodbalanceamount<>0)) or (flag = 1)").select((this.getFinalSelects("all") + ",periodbalanceqty,0 as periodbalanceprice,periodbalanceamount,ordercol2,ordercol1").split(","));
        return result;
    }

    private DataSet getPeriodDataSet() {
        QFilter q = QFilter.of((String)"periodyear*100+periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber});
        q.and(QFilter.of((String)"periodyear*100+periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        DynamicObject costAccountInfo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", this.filter_costAccount.get("id"))});
        q.and("periodtype", "=", costAccountInfo.get("calpolicy.periodtype"));
        q.and("isadjustperiod", "=", (Object)false);
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)"id as allperiodid,periodyear as year,periodnumber as period", (QFilter[])new QFilter[]{q}, (String)"periodyear asc,periodnumber asc");
    }

    private DataSet getInitDataSet() {
        String selectFields = "year,period,initqty,initamount, Cast(ordercol1 as Integer) as ordercol1";
        if (!this.showPartition) {
            selectFields = this.addField(selectFields, ",material");
        }
        QFilter q = this.getInitFilter();
        DataSet initDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getInitSelects(), (QFilter[])q.toArray(), null).select(selectFields);
        return initDataSet;
    }

    private String getInitSelects() {
        String s = "period.periodyear as year, period.periodnumber as period,entry.baseqty as initqty," + this.getMaterialCostorProcessCostSelects() + " as initamount, 0 as ordercol1";
        if (!this.showPartition) {
            s = this.addField(s, ",entry.material as material");
        }
        return s;
    }

    private QFilter getInitFilter() {
        QFilter q = this.getBaseFilter();
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("issplitcreate", "=", (Object)false);
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        q.and("isinitbill", "=", (Object)true);
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        return q;
    }

    private DataSet getBeforePeriodDataSet() {
        DataSet dataSet;
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        String[] s1 = this.showPartition ? new String[]{"ordercol2"} : new String[]{"material", "ordercol2"};
        DataSet beforePeriodInDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getBeforePeriodInSelect(), (QFilter[])this.getBeforePeriodInFilter1().and(billStatusf).toArray(), null).union(QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getBeforePeriodInSelect(), (QFilter[])this.getBeforePeriodInFilter2().and(billStatusf).toArray(), null)).groupBy(s1).sum("beforeperiodinqty").sum("beforeperiodinamount").finish();
        String[] s2 = this.showPartition ? new String[]{"ordercol2"} : new String[]{"ordercol2", "material"};
        DataSet beforePeriodWriteOffDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getBeforePeriodWriteOffSelect(), (QFilter[])this.getBeforePeriodWriteOffFilter1().and(billStatusf).toArray(), null).union(QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getBeforePeriodWriteOffSelect(), (QFilter[])this.getBeforePeriodWriteOffFilter2().and(billStatusf).toArray(), null)).groupBy(s2).sum("beforeperiodwriteoffqty").sum("beforeperiodwriteoffamount").finish();
        if (this.showPartition) {
            dataSet = beforePeriodInDataSet.join(beforePeriodWriteOffDataSet, JoinType.LEFT).on("ordercol2", "ordercol2").select(new String[]{"beforeperiodinqty", "beforeperiodinamount", "ordercol2"}, new String[]{"beforeperiodwriteoffqty", "beforeperiodwriteoffamount"}).finish().select(this.getFinalSelects("beforeperiod"));
            dataSet = dataSet.select("beforeperiodinqty-beforeperiodwriteoffqty as periodbalanceqty, beforeperiodinamount-beforeperiodwriteoffamount as periodbalanceamount, 0 as ordercol2");
        } else {
            dataSet = beforePeriodInDataSet.join(beforePeriodWriteOffDataSet, JoinType.LEFT).on("ordercol2", "ordercol2").on("material", "material").select(new String[]{"beforeperiodinqty", "beforeperiodinamount", "material", "ordercol2"}, new String[]{"beforeperiodwriteoffqty", "beforeperiodwriteoffamount"}).finish().select(this.getFinalSelects("beforeperiod"));
            dataSet = dataSet.select("beforeperiodinqty-beforeperiodwriteoffqty as periodbalanceqty, beforeperiodinamount-beforeperiodwriteoffamount as periodbalanceamount, material,0 as ordercol2");
        }
        return dataSet;
    }

    private String getBeforePeriodInSelect() {
        String s = this.showPartition ? "entry.baseqty as beforeperiodinqty," + this.getMaterialCostorProcessCostSelects() + " as beforeperiodinamount, 0 as ordercol2" : "entry.baseqty as beforeperiodinqty," + this.getMaterialCostorProcessCostSelects() + " as beforeperiodinamount,entry.material as material,0 as ordercol2";
        return s;
    }

    private String getBeforePeriodWriteOffSelect() {
        String s = this.showPartition ? "entry.baseqty as beforeperiodwriteoffqty," + this.getMaterialCostorProcessCostSelects() + " as beforeperiodwriteoffamount, 0 as ordercol2" : "entry.baseqty as beforeperiodwriteoffqty," + this.getMaterialCostorProcessCostSelects() + " as beforeperiodwriteoffamount,entry.material as material,0 as ordercol2";
        return s;
    }

    private QFilter getBeforePeriodInFilter1() {
        QFilter q = this.getBaseFilter();
        q.and("issplitcreate", "=", (Object)false);
        q.and("bookdate", "<", (Object)this.filter_startDate);
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber  < ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and("writeoffendperiod", "=", (Object)0);
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    private QFilter getBeforePeriodInFilter2() {
        QFilter q = this.getBaseFilter();
        q.and("issplitcreate", "=", (Object)false);
        q.and("bookdate", "<", (Object)this.filter_startDate);
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber < ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"writeoffendperiod.periodyear*100+writeoffendperiod.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    private QFilter getBeforePeriodWriteOffFilter1() {
        QFilter q = this.getBaseFilter();
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber < ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and("writeoffendperiod", "=", (Object)0);
        q.and("writeoffstatus", "=", (Object)"A");
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    private QFilter getBeforePeriodWriteOffFilter2() {
        QFilter q = this.getBaseFilter();
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber < ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"writeoffendperiod.periodyear*100+writeoffendperiod.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and("writeoffstatus", "=", (Object)"A");
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    private DataSet unionToalDataSet(DataSet dataSet) {
        DataSet finalDataSet;
        String fourSecond;
        String fourFirst;
        String[] groupFourSelects;
        String[] orderField;
        String threeSecond;
        String threeFirst;
        DataSet overallTotalDataSet;
        String twoField;
        String s1 = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"StockEstimateDetailRptQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
        String[] groupOneField = this.showPartition ? GROUPONE_ONE_MATERIAL : GROUPONE_MULTI_MATERIAL;
        String oneField = this.showPartition ? "year,period,null as ownertype, 0 as owner,null as storageorgnumber,null as storageorgname,null as warehsgroupnumber,null as warehsgroupname,null as warehousenumber,null as warehousename,null as locationnumber,null as locationname,null as bizdate,null as auditdate, null as bookdate,null as billnumber, null as supplier, '" + s1 + "' as biztype, null as assist, null as lot,null as tracknumber, periodinqty,case when periodinqty = 0 then 0 else periodinamount/periodinqty end as periodinprice,periodinamount,periodwriteoffqty,case when periodwriteoffqty = 0 then 0 else periodwriteoffamount/periodwriteoffqty end as periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,case when periodnotwriteoffqty = 0 then 0 else periodnotwriteoffamount/periodnotwriteoffqty end as periodnotwriteoffprice,periodnotwriteoffamount,0 as periodbalanceqty,0 as periodbalanceamount, 2 as ordercol2, 0 as ordercol1" : "year,period,null as ownertype, 0 as owner,null as storageorgnumber,null as storageorgname,null as warehsgroupnumber,null as warehsgroupname,null as warehousenumber,null as warehousename,null as locationnumber,null as locationname,null as bizdate,null as auditdate, null as bookdate,null as billnumber, null as supplier, '" + s1 + "' as biztype, null as assist, null as lot, null as tracknumber,periodinqty,case when periodinqty = 0 then 0 else periodinamount/periodinqty end as periodinprice,periodinamount,periodwriteoffqty,case when periodwriteoffqty = 0 then 0 else periodwriteoffamount/periodwriteoffqty end as periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,case when periodnotwriteoffqty = 0 then 0 else periodnotwriteoffamount/periodnotwriteoffqty end as periodnotwriteoffprice,periodnotwriteoffamount,material,0 as periodbalanceqty,0 as periodbalanceprice,0 as periodbalanceamount, 2 as ordercol2, 0 as ordercol1";
        DataSet totalDataSet = dataSet.copy().groupBy(groupOneField).sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").sum("periodnotwriteoffqty").sum("periodnotwriteoffamount").finish().select(oneField.split(","));
        String s2 = ResManager.loadKDString((String)"\u603b\u5408\u8ba1", (String)"StockEstimateDetailRptQueryPlugin_12", (String)"fi-cal-report", (Object[])new Object[0]);
        if (this.showPartition) {
            twoField = "0 as year,0 as period,null as ownertype, 0 as owner,null as storageorgnumber,null as storageorgname,null as warehsgroupnumber,null as warehsgroupname,null as warehousenumber,null as warehousename,null as locationnumber,null as locationname,null as bizdate,null as auditdate,null as bookdate, null as billnumber, null as supplier, '" + s2 + "' as biztype, null as assist, null as lot, null as tracknumber,periodinqty,case when periodinqty = 0 then 0 else periodinamount/periodinqty end as periodinprice,periodinamount,periodwriteoffqty,case when periodwriteoffqty = 0 then 0 else periodwriteoffamount/periodwriteoffqty end as periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,case when periodnotwriteoffqty = 0 then 0 else periodnotwriteoffamount/periodnotwriteoffqty end as periodnotwriteoffprice,periodnotwriteoffamount,0 as periodbalanceqty,0 as periodbalanceamount, 2 as ordercol2, 1 as ordercol1";
            overallTotalDataSet = totalDataSet.where("ordercol2=2").groupBy(null).sum("periodinqty").sum("periodinamount").sum("periodnotwriteoffqty").sum("periodnotwriteoffamount").sum("periodwriteoffqty").sum("periodwriteoffamount").finish().select(twoField.split(","));
        } else {
            twoField = "0 as year,0 as period,null as ownertype, 0 as owner,null as storageorgnumber,null as storageorgname,null as warehsgroupnumber,null as warehsgroupname,null as warehousenumber,null as warehousename,null as locationnumber,null as locationname,null as bizdate,null as auditdate,null as bookdate, null as billnumber, null as supplier, '" + s2 + "' as biztype, null as assist, null as lot, null as tracknumber,periodinqty,case when periodinqty = 0 then 0 else periodinamount/periodinqty end as periodinprice,periodinamount,periodwriteoffqty,case when periodwriteoffqty = 0 then 0 else periodwriteoffamount/periodwriteoffqty end as periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,case when periodnotwriteoffqty = 0 then 0 else periodnotwriteoffamount/periodnotwriteoffqty end as periodnotwriteoffprice,periodnotwriteoffamount,null as material,0 as periodbalanceqty,case when periodbalanceqty = 0 then 0 else periodbalanceamount/periodbalanceamount end as periodbalanceprice,0 as periodbalanceamount, 2 as ordercol2, 1 as ordercol1";
            overallTotalDataSet = totalDataSet.where("ordercol2=2").groupBy(null).sum("periodinqty").sum("periodinamount").sum("periodnotwriteoffqty").sum("periodnotwriteoffamount").sum("periodwriteoffqty").sum("periodwriteoffamount").sum("periodbalanceqty").sum("periodbalanceamount").finish().select(twoField.split(","));
        }
        String[] groupThreeFields = this.showPartition ? GROUPTHREE_ONE_MATERIAL : GROUPTHREE_MULTI_MATERIAL;
        if (this.showPartition) {
            threeFirst = "year,period, ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,supplier,biztype, assist, lot,tracknumber, periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffprice,periodnotwriteoffamount,case when ordercol2 = 2 and PreRowValue(ordercol2)=0 then PreRowValue(periodbalanceqty) + periodinqty- periodwriteoffqty else periodbalanceqty end as periodbalanceqty, case when ordercol2 = 2 and PreRowValue(ordercol2)=0 then PreRowValue(periodbalanceamount)+ periodinamount-periodwriteoffamount else periodbalanceamount end as periodbalanceamount,ordercol2,ordercol1";
            threeSecond = "year,period, ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,supplier,biztype, assist, lot, tracknumber,periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodbalanceqty as periodnotwriteoffqty,case when periodbalanceqty = 0 then 0 else periodbalanceamount/periodbalanceqty end as periodnotwriteoffprice,periodbalanceamount as periodnotwriteoffamount,periodbalanceqty, periodbalanceamount,ordercol2,ordercol1";
        } else {
            threeFirst = "year,period, ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,supplier,biztype, assist, lot, tracknumber,periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffprice,periodnotwriteoffamount,material,case when ordercol2 = 2 and PreRowValue(ordercol2)=0 and PreRowValue(material) = material then PreRowValue(periodbalanceqty) + periodinqty- periodwriteoffqty else periodbalanceqty end as periodbalanceqty,periodbalanceprice, case when ordercol2 = 2 and PreRowValue(ordercol2)=0 and PreRowValue(material) = material then PreRowValue(periodbalanceamount)+ periodinamount-periodwriteoffamount else periodbalanceamount end as periodbalanceamount,ordercol2,ordercol1";
            threeSecond = "year,period, ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,supplier,biztype, assist, lot, tracknumber,periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodbalanceqty as periodnotwriteoffqty,case when periodbalanceqty = 0 then 0 else periodbalanceamount/periodbalanceqty end as periodnotwriteoffprice,periodbalanceamount as periodnotwriteoffamount,material,periodbalanceqty,periodbalanceprice,periodbalanceamount,ordercol2,ordercol1";
        }
        totalDataSet = dataSet.copy().where("ordercol2 = 0").union(totalDataSet.copy()).orderBy(groupThreeFields).select(threeFirst.split(",")).select(threeSecond.split(",")).where("ordercol2 = 2");
        if (this.showPartition) {
            orderField = GROUPFOUR_ORDER_ONE_MATERIAL;
            groupFourSelects = GROUPFOUR_ONE_MATERIAL;
            fourFirst = "year,period,ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,supplier, biztype, assist, lot, tracknumber,periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffprice,periodnotwriteoffamount,case when ordercol1 = 1 then PreRowValue(periodbalanceqty) else periodbalanceqty end as periodbalanceqty, case when ordercol1 = 1 then PreRowValue(periodbalanceamount) else periodbalanceamount end as periodbalanceamount,ordercol2,ordercol1";
            fourSecond = "year,period, ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,supplier,biztype, assist, lot, tracknumber,periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodbalanceqty as periodnotwriteoffqty,case when periodbalanceqty = 0 then 0 else periodbalanceamount/periodbalanceqty end as periodnotwriteoffprice,periodbalanceamount as periodnotwriteoffamount,periodbalanceqty, periodbalanceamount,ordercol2,ordercol1";
            overallTotalDataSet = totalDataSet.copy().where("ordercol2 = 2").orderBy(orderField).union(overallTotalDataSet).orderBy(groupFourSelects).select(fourFirst.split(",")).select(fourSecond.split(",")).where("ordercol1 = 1");
        } else {
            orderField = GROUPFOUR_ORDER_MULTI_MATERIAL;
            groupFourSelects = GROUPFOUR_MULTI_MATERIAL;
            fourFirst = "year,period,ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,supplier, biztype, assist, lot, tracknumber,periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffprice,periodnotwriteoffamount,material,periodbalanceqty, periodbalanceprice,periodbalanceamount,ordercol2,ordercol1";
            fourSecond = "year,period, ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,supplier,biztype, assist, lot, tracknumber,periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodbalanceqty as periodnotwriteoffqty,case when periodbalanceqty = 0 then 0 else periodbalanceamount/periodbalanceqty end as periodnotwriteoffprice,periodbalanceamount as periodnotwriteoffamount,material,periodbalanceqty,periodbalanceprice, periodbalanceamount,ordercol2,ordercol1";
            twoField = "0 as year,0 as period,null as ownertype, 0 as owner,null as storageorgnumber,null as storageorgname,null as warehsgroupnumber,null as warehsgroupname,null as warehousenumber,null as warehousename,null as locationnumber,null as locationname,null as bizdate,null as auditdate,null as bookdate, null as billnumber, null as supplier, '" + s2 + "' as biztype, null as assist, null as lot,null as tracknumber, periodinqty,case when periodinqty = 0 then 0 else periodinamount/periodinqty end as periodinprice,periodinamount,periodwriteoffqty,case when periodwriteoffqty = 0 then 0 else periodwriteoffamount/periodwriteoffqty end as periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,case when periodnotwriteoffqty = 0 then 0 else periodnotwriteoffamount/periodnotwriteoffqty end as periodnotwriteoffprice,periodnotwriteoffamount,null as material,periodbalanceqty,case when periodbalanceqty = 0 then 0 else periodbalanceamount/periodbalanceqty end as periodbalanceprice,periodbalanceamount, 2 as ordercol2, 1 as ordercol1";
            String leftTwoField = "0 as year,0 as period,null as ownertype, 0 as owner,null as storageorgnumber,null as storageorgname,null as warehsgroupnumber,null as warehsgroupname,null as warehousenumber,null as warehousename,null as locationnumber,null as locationname,null as bizdate,null as auditdate,null as bookdate, null as billnumber, null as supplier, '" + s2 + "' as biztype, null as assist, null as lot, null as tracknumber,periodinqty,case when periodinqty = 0 then 0 else periodinamount/periodinqty end as periodinprice,periodinamount,periodwriteoffqty,case when periodwriteoffqty = 0 then 0 else periodwriteoffamount/periodwriteoffqty end as periodwriteoffprice,periodwriteoffamount,null as material,2 as ordercol2,1 as ordercol1";
            String rightTwoField = "periodnotwriteoffqty,case when periodnotwriteoffqty = 0 then 0 else periodnotwriteoffamount/periodnotwriteoffqty end as periodnotwriteoffprice,periodnotwriteoffamount,periodbalanceqty,case when periodbalanceqty = 0 then 0 else periodbalanceamount/periodbalanceqty end as periodbalanceprice, periodbalanceamount,2 as ordercol2,1 as ordercol1";
            DataSet leftDataSet = totalDataSet.copy().where("ordercol2=2").groupBy(null).sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").finish().select(leftTwoField.split(","));
            String target = "year * 100 + period";
            DataSet rightDataSet = totalDataSet.copy().where("ordercol2=2").groupBy(new String[]{"material"}).max(target, "period").maxP(target, "periodnotwriteoffqty", "periodnotwriteoffqty").maxP(target, "periodnotwriteoffamount", "periodnotwriteoffamount").maxP(target, "periodbalanceqty", "periodbalanceqty").maxP(target, "periodbalanceamount", "periodbalanceamount").finish();
            DataSet right = rightDataSet.groupBy(null).sum("periodnotwriteoffqty", "periodnotwriteoffqty").sum("periodnotwriteoffamount", "periodnotwriteoffamount").sum("periodbalanceqty", "periodbalanceqty").sum("periodbalanceamount", "periodbalanceamount").finish().select(rightTwoField.split(","));
            DataSet totalData = leftDataSet.join(right, JoinType.LEFT).on("ordercol2", "ordercol2").select(new String[]{"periodinqty", "periodinamount", "periodwriteoffqty", "periodwriteoffamount"}, new String[]{"periodnotwriteoffqty", "periodnotwriteoffamount", "periodbalanceqty", "periodbalanceamount"}).finish();
            overallTotalDataSet = totalData.select(twoField);
            overallTotalDataSet = totalDataSet.copy().where("ordercol2 = 2").orderBy(orderField).union(overallTotalDataSet);
            overallTotalDataSet = overallTotalDataSet.orderBy(groupFourSelects).select(fourFirst.split(",")).select(fourSecond.split(",")).where("ordercol1 = 1");
        }
        if (this.showPartition) {
            finalDataSet = dataSet.union(totalDataSet).union(overallTotalDataSet).select(("year,period,ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,supplier,biztype, assist, lot,tracknumber, periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffprice,periodnotwriteoffamount,periodbalanceqty, periodbalanceamount,case when periodbalanceqty = 0 then 0 else periodbalanceamount/periodbalanceqty end as periodbalanceprice,ordercol2,ordercol1," + this.currencyId + " as currencyid," + this.baseUnitId + " as baseunitid," + this.materialId + " as materialid").split(","));
        } else {
            DataSet lastDataSet;
            String finalSelect = "year,period,ownertype, owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname, bizdate,auditdate,bookdate,billnumber,supplier,biztype, assist, lot, tracknumber,periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffprice,periodnotwriteoffamount,material,periodbalanceqty, periodbalanceamount,case when (periodbalanceqty = null or periodbalanceqty = 0) then 0 else periodbalanceamount/periodbalanceqty end as periodbalanceprice,ordercol2,ordercol1," + this.currencyId + " as currencyid";
            String[] materialFields = MATERIAL_FIELDS;
            finalDataSet = dataSet.union(totalDataSet).union(overallTotalDataSet).select(finalSelect.split(","));
            QFilter filter = new QFilter("id", "in", this.materialIds);
            String materialSelect = "id AS material,number AS head_materialnumber,name AS head_materialname,modelnum AS head_model,baseunit.name AS head_baseunit";
            DataSet materialInfos = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)materialSelect, (QFilter[])filter.toArray(), null);
            DataSet withMaterial = finalDataSet.leftJoin(materialInfos).on("material", "material").select(finalDataSet.getRowMeta().getFieldNames(), materialFields).finish();
            ArrayList<Object[]> list = new ArrayList<Object[]>(16);
            for (Map.Entry<Long, Long> entry : this.materialIdAndBaseUnitId.entrySet()) {
                list.add(new Object[]{entry.getKey(), entry.getValue()});
            }
            RowMeta rowMeta = new RowMeta(new Field[]{new Field("material", (DataType)DataType.LongType), new Field("baseunitid", (DataType)DataType.StringType)});
            DataSet materialUnitDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(list.iterator(), rowMeta);
            finalDataSet = lastDataSet = withMaterial.leftJoin(materialUnitDataSet).on("material", "material").select(withMaterial.getRowMeta().getFieldNames(), new String[]{"baseunitid"}).finish();
        }
        return finalDataSet;
    }

    private QFilter getBaseFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        if (!this.showPartition) {
            q.and("entry.material", "in", this.materialIds);
        } else {
            q.and("entry.material", "=", (Object)this.materialId);
        }
        if (this.filter_mullot != null && !this.filter_mullot.equals("")) {
            q.and("entry.lot", "=", (Object)this.filter_mullot);
        }
        if (this.filter_trackNumber != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_trackNumber) {
                set.add(info.getPkValue());
            }
            q.and("entry.tracknumber", "in", set);
        }
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costrecord");
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entry.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entry.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entry.location", "in", set);
        }
        if (this.filter_supplierFrom != null) {
            q.and("entry.balancesupplier.id", "in", (Object)ReportUtil.getBasedateIdsFromDyColNumers((DynamicObjectCollection)this.filter_supplierFrom, (String)"bd_supplier"));
        }
        if (this.filter_billno.length() >= 1) {
            q.and("billnumber", "=", (Object)this.filter_billno);
        }
        if (this.filter_billtype != null) {
            set = new HashSet();
            for (DynamicObject billtype : this.filter_billtype) {
                set.add(billtype.getPkValue());
            }
            q.and("bizentityobject", "in", set);
        } else {
            DynamicObject setting = CommonSettingHelper.getSettingObj();
            DynamicObjectCollection bizobjects = setting.getDynamicObjectCollection("purbiztype");
            DynamicObjectCollection ominBizobjects = setting.getDynamicObjectCollection("ominbiztype");
            bizobjects.addAll((Collection)ominBizobjects);
            HashSet<Object> set2 = new HashSet<Object>();
            for (DynamicObject bizobject : bizobjects) {
                set2.add(bizobject.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("bizentityobject", "in", set2);
        }
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        if (this.filter_dischargeType != null) {
            q.and("dischargetype", "in", (Object)this.filter_dischargeType);
        }
        return q;
    }

    private String[] getStringArr(String s) {
        switch (s) {
            case "woGSA": {
                String[] r = WOGSA;
                if (!this.showPartition) {
                    r = this.addField(r, "material");
                }
                return r;
            }
            case "sumNotWriteOffGSA": {
                String[] r = SUM_NOT_WRITEOffGSA;
                if (!this.showPartition) {
                    r = this.addField(r, "material");
                }
                return r;
            }
            case "NotWriteOffIn": {
                String[] r = NOT_WRITEOFFIN;
                if (!this.showPartition) {
                    r = this.addField(r, "material");
                }
                return r;
            }
            case "NotWriteOffLeft": {
                String[] r = NOT_WRITEOFFLEFT;
                if (!this.showPartition) {
                    r = this.addField(r, "material");
                }
                return r;
            }
        }
        return null;
    }

    private String getFinalSelects(String s) {
        String string = "";
        switch (s) {
            case "base": {
                if (this.showPartition) {
                    string = "year,period,ownertype,owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,bizdate,bookdate,billnumber,supplier,biztype,assist,lot,tracknumber";
                    break;
                }
                string = "year,period,ownertype,owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,bizdate,bookdate,billnumber,supplier,biztype,assist,lot,tracknumber,material";
                break;
            }
            case "baseNotContainPeriod": {
                string = "ownertype,owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,bizdate,auditdate,bookdate,billnumber,supplier,biztype,assist,lot,tracknumber";
                if (this.showPartition) break;
                string = this.addField(string, ",material");
                break;
            }
            case "periodin": {
                string = "periodinqty, periodinamount, 0 as periodwriteoffqty,0 as periodwriteoffamount,0 as periodnotwriteoffqty,0 as periodnotwriteoffamount";
                break;
            }
            case "periodnotwoAddzero": {
                string = "allperiodid,year,period,entryid,ownertype,owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,bizdate,auditdate,bookdate,billnumber,supplier,biztype,assist,lot,tracknumber,inqty,inamount,0 as woqty,0 as woamount";
                if (this.showPartition) break;
                string = this.addField(string, ",material");
                break;
            }
            case "periodnotwonull2zero": {
                string = "allperiodid,year,period,entryid,ownertype,owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,bizdate,auditdate,bookdate,billnumber,supplier,biztype,assist,lot,tracknumber,inqty,inamount,case when woqty = null then 0 else woqty end as woqty,case when woamount = null then 0 else woamount end as woamount";
                if (this.showPartition) break;
                string = this.addField(string, ",material");
                break;
            }
            case "periodwriteoff": {
                string = "periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount,0 as periodnotwriteoffqty,0 as periodnotwriteoffamount";
                break;
            }
            case "inandwriteoff": {
                string = "periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount";
                break;
            }
            case "periodnotwriteoff": {
                string = "0 as periodinqty, 0 as periodinamount, 0 as periodwriteoffqty,0 as periodwriteoffamount,case when woqty = null then inqty else inqty-woqty end as periodnotwriteoffqty,case when woamount = null then inamount else inamount-woamount end as periodnotwriteoffamount";
                break;
            }
            case "calall": {
                string = "periodinqty, case when periodinqty= 0 or periodinqty= null then 0 else periodinamount/periodinqty end as periodinprice, periodinamount, periodwriteoffqty, case when periodwriteoffqty =0 or periodwriteoffqty =null then 0 else periodwriteoffamount/periodwriteoffqty end as periodwriteoffprice, periodwriteoffamount,case when periodnotwriteoffqty = null then 0 else periodnotwriteoffqty end as periodnotwriteoffqty,case when periodnotwriteoffqty = 0 or periodnotwriteoffqty = null then 0 else periodnotwriteoffamount/periodnotwriteoffqty end as periodnotwriteoffprice,case when periodnotwriteoffamount = null then 0 else periodnotwriteoffamount end as periodnotwriteoffamount";
                break;
            }
            case "alltemp": {
                string = "year, period, storageorgnumber, storageorgname,warehsgroupnumber,warehsgroupname, warehousenumber, warehousename, locationnumber, locationname, bizdate,auditdate,bookdate, billnumber, supplier, biztype, assist, lot,tracknumber, periodinqty, periodinprice, periodinamount, periodwriteoffqty, periodwriteoffprice, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffprice, periodnotwriteoffamount";
                if (this.showPartition) break;
                string = this.addField(string, ",material");
                break;
            }
            case "all": {
                string = "year,period,ownertype,owner,storageorgnumber,storageorgname,warehsgroupnumber,warehsgroupname,warehousenumber,warehousename,locationnumber,locationname,bizdate,auditdate,bookdate,billnumber,supplier,biztype,assist,lot,tracknumber,periodinqty,periodinprice,periodinamount,periodwriteoffqty,periodwriteoffprice,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffprice,periodnotwriteoffamount";
                if (this.showPartition) break;
                string = this.addField(string, ",material");
                break;
            }
            case "beforeperiod": {
                string = "case when beforeperiodinqty = null then 0 else beforeperiodinqty end as beforeperiodinqty, case when beforeperiodinamount = null then 0 else beforeperiodinamount end as beforeperiodinamount, case when beforeperiodwriteoffqty = null then 0 else beforeperiodwriteoffqty end as beforeperiodwriteoffqty, case when beforeperiodwriteoffamount = null then 0 else beforeperiodwriteoffamount end as beforeperiodwriteoffamount,ordercol2";
                if (this.showPartition) break;
                string = this.addField(string, ",material");
                break;
            }
            case "allandbeforeperiod": {
                String s3 = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"StockCostDetailRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]);
                string = "year, period, ownertype,owner, storageorgnumber, storageorgname,warehsgroupnumber,warehsgroupname, warehousenumber, warehousename, locationnumber, locationname, bizdate,auditdate,bookdate,billnumber, supplier, case when ordercol2 <> 1 then '" + s3 + "' else biztype end as biztype, assist, lot,tracknumber, case when ordercol2 <> 1 then 0 else periodinqty end as periodinqty, case when ordercol2 <> 1 then 0 else periodinprice end as periodinprice, case when ordercol2 <> 1 then 0 else periodinamount end as periodinamount, case when ordercol2 <> 1 then 0 else periodwriteoffqty end as periodwriteoffqty, case when ordercol2 <> 1 then 0 else periodwriteoffprice end as periodwriteoffprice, case when ordercol2 <> 1 then 0 else periodwriteoffamount end as periodwriteoffamount, case when ordercol2 <> 1 then 0 else periodnotwriteoffqty end as periodnotwriteoffqty, case when ordercol2 <> 1 then 0 else periodnotwriteoffprice end as periodnotwriteoffprice,case when ordercol2 <> 1 then 0 else periodnotwriteoffamount end as periodnotwriteoffamount, case when ordercol2 <> 1 then 0 else ordercol2 end as ordercol2";
                if (this.showPartition) break;
                string = this.addField(string, ",material");
                break;
            }
            case "allandbalancenonull": {
                string = "year, period, ownertype,owner, storageorgnumber, storageorgname,warehsgroupnumber,warehsgroupname, warehousenumber, warehousename, locationnumber, locationname, bizdate,auditdate,bookdate,billnumber, supplier, biztype, assist, lot,tracknumber, periodinqty, periodinprice, periodinamount, periodwriteoffqty, periodwriteoffprice, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffprice, periodnotwriteoffamount,case when periodbalanceqty = null then 0 else periodbalanceqty end as periodbalanceqty, case when periodbalanceamount = null then 0 else periodbalanceamount end as periodbalanceamount,ordercol2";
                if (this.showPartition) break;
                string = this.addField(string, ",material");
            }
        }
        return string;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        this.insertSelfDefinition(cols);
        this.createColumnCaptions(cols);
        this.createHideColumns(cols);
        return super.getColumns(columns);
    }

    private void insertSelfDefinition(List<AbstractReportColumn> cols) {
        int i;
        ArrayList<AbstractReportColumn> pre = new ArrayList<AbstractReportColumn>(16);
        ArrayList<ReportColumn> middle = new ArrayList<ReportColumn>(16);
        ArrayList<AbstractReportColumn> behind = new ArrayList<AbstractReportColumn>(16);
        for (i = 0; i < cols.size(); ++i) {
            pre.add(cols.get(i));
            String localeValue = cols.get(i).getCaption().getLocaleValue();
            if (localeValue.equals(this.getLocale_slotName())) break;
        }
        ReportColumn head_materialnumber = new ReportColumn();
        head_materialnumber.setCaption(this.locale_materialNo);
        head_materialnumber.setWidth(width);
        head_materialnumber.setFieldKey("head_materialnumber");
        head_materialnumber.setFieldType("text");
        head_materialnumber.setHide(true);
        ReportColumn head_materialname = new ReportColumn();
        head_materialname.setCaption(this.locale_materialName);
        head_materialname.setWidth(width);
        head_materialname.setFieldKey("head_materialname");
        head_materialname.setFieldType("text");
        head_materialname.setHide(true);
        ReportColumn head_model = new ReportColumn();
        head_model.setCaption(this.locale_materialModel);
        head_model.setWidth(width);
        head_model.setFieldKey("head_model");
        head_model.setFieldType("text");
        head_model.setHide(true);
        ReportColumn head_baseunit = new ReportColumn();
        head_baseunit.setCaption(this.locale_materialUnit);
        head_baseunit.setWidth(width);
        head_baseunit.setFieldKey("head_baseunit");
        head_baseunit.setFieldType("text");
        head_baseunit.setHide(true);
        middle.add(head_materialnumber);
        middle.add(head_materialname);
        middle.add(head_model);
        middle.add(head_baseunit);
        ++i;
        while (i < cols.size()) {
            behind.add(cols.get(i));
            ++i;
        }
        cols.clear();
        cols.addAll(pre);
        cols.addAll(middle);
        cols.addAll(behind);
    }

    private void createColumnCaptions(List<AbstractReportColumn> cols) {
        this.createAssistPropertyColumns(cols);
        this.createColumnCaption(cols, this.local_periodIn, "periodin");
        this.createColumnCaption(cols, this.local_periodWriteoff, "periodwriteoff");
        this.createColumnCaption(cols, this.local_periodNotWriteoff, "periodnotwriteoff");
        this.createColumnCaption(cols, this.local_periodEnd, "periodbalance");
    }

    private void createAssistPropertyColumns(List<AbstractReportColumn> cols) {
        ReportColumn assist = new ReportColumn();
        assist.setCaption(this.locale_assistProperty);
        assist.setWidth(width);
        assist.setFieldKey("assist");
        assist.setFieldType("flex");
        assist.setRefBasedataProp("materialid");
        assist.setEntityId("bd_auxproperty");
        cols.add((AbstractReportColumn)assist);
    }

    private void createColumnCaption(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey);
        cols.add((AbstractReportColumn)groupCol);
        ReportColumn qty = new ReportColumn();
        qty.setCaption(this.local_qty);
        qty.setWidth(width);
        qty.setFieldKey(fieldKey + "qty");
        qty.setFieldType("qty");
        qty.setMeasureUnitField("baseunitid");
        ReportColumn price = new ReportColumn();
        price.setCaption(this.local_price);
        price.setWidth(width);
        price.setFieldKey(fieldKey + "price");
        price.setFieldType("price");
        price.setCurrencyField("currencyid");
        ReportColumn amount = new ReportColumn();
        amount.setCaption(this.local_amount);
        amount.setWidth(width);
        amount.setFieldKey(fieldKey + "amount");
        amount.setFieldType("amount");
        amount.setCurrencyField("currencyid");
        groupCol.getChildren().add(qty);
        groupCol.getChildren().add(price);
        groupCol.getChildren().add(amount);
    }

    private void createHideColumns(List<AbstractReportColumn> cols) {
        ReportColumn baseUnitId = new ReportColumn();
        baseUnitId.setCaption(this.local_baseUnit);
        baseUnitId.setWidth(width);
        baseUnitId.setFieldKey("baseunitid");
        baseUnitId.setFieldType("unit");
        baseUnitId.setEntityId("bd_measureunits");
        baseUnitId.setHide(true);
        ReportColumn currencyId = new ReportColumn();
        currencyId.setCaption(this.local_currency);
        currencyId.setWidth(width);
        currencyId.setFieldKey("currencyid");
        currencyId.setFieldType("currency");
        currencyId.setEntityId("bd_currency");
        currencyId.setHide(true);
        ReportColumn bizEntityObject = new ReportColumn();
        bizEntityObject.setCaption(this.local_currency);
        bizEntityObject.setWidth(width);
        bizEntityObject.setFieldKey("bizentityobject");
        bizEntityObject.setFieldType("text");
        bizEntityObject.setHide(true);
        ReportColumn billId = new ReportColumn();
        billId.setCaption(this.local_currency);
        billId.setWidth(width);
        billId.setFieldKey("billid");
        billId.setFieldType("text");
        billId.setHide(true);
        cols.add((AbstractReportColumn)baseUnitId);
        cols.add((AbstractReportColumn)currencyId);
        cols.add((AbstractReportColumn)bizEntityObject);
        cols.add((AbstractReportColumn)billId);
    }
}

