/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.ReportUtil;

public class StockEstimateGroupQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(StockEstimateGroupQueryPlugin.class);
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private DynamicObject filter_startPeriod;
    private long startPeriodId;
    private DynamicObject filter_endPeriod;
    private int filter_startPeriodNumber;
    private int filter_endPeriodNumber;
    private boolean isGroupByPeriod;
    private long currencyId;
    private String materialCostorProcessCostSelect = null;
    private Date filter_endDate;
    private Date filter_startDate;
    private String groupType;
    private String groupByCols;
    private String groupByColsWithOutMaterial;
    private String selectFieldWithOutMaterial;
    private String orderByColWithOutMaterial;
    private String selectField1;
    private String[] orderByCol = null;
    private String strcatlot = "";
    private String filter_ownertype;
    private DynamicObjectCollection filter_ownerFrom;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private DynamicObjectCollection filter_materialFrom;
    private DynamicObject filter_materialTo;
    private DynamicObjectCollection filter_trackNumber;
    private DynamicObjectCollection filter_supplier;
    private boolean filter_ContainAdjustBill;
    private String[] filter_dischargeType;
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private String mgIdField = "mgid";
    private int level;
    private boolean onlyShowSum;
    private boolean sumTop;
    private boolean showAvailable;
    private List<String> mgFieldList = new ArrayList<String>(16);
    private DynamicObject filter_materialGroupStandard;
    private DynamicObjectCollection filter_materialGroups;
    private String splitSign = "!";
    private LocaleString locale_baseUnit = new LocaleString(this.getLocale_baseUnit());
    private LocaleString local_beforeperiod = new LocaleString(this.getLocal_beforeperiod());
    private LocaleString local_periodIn = new LocaleString(this.getLocal_periodIn());
    private LocaleString local_periodWriteoff = new LocaleString(this.getLocal_periodWriteoff());
    private LocaleString local_periodNotWriteoff = new LocaleString(this.getLocal_periodNotWriteoff());
    private LocaleString local_periodEnd = new LocaleString(this.getLocal_periodEnd());
    private LocaleString locale_qty = new LocaleString(this.getLocale_qty());
    private LocaleString locale_price = new LocaleString(this.getLocale_price());
    private LocaleString locale_amount = new LocaleString(this.getLocale_amount());
    private LocaleString locale_currency = new LocaleString(this.getLocale_currency());
    private static final LocaleString width = new LocaleString("100px");
    private LocaleString locale_storageOrgNum = new LocaleString(this.getLocale_storageOrgNum());
    private LocaleString locale_storageOrgName = new LocaleString(this.getLocale_storageOrgName());
    private LocaleString locale_warehouseNum = new LocaleString(this.getLocale_warehouseNum());
    private LocaleString locale_warehouseName = new LocaleString(this.getLocale_warehouseName());
    private LocaleString locale_warehouseGroupNum = new LocaleString(this.getLocale_WarehouseGroupNum());
    private LocaleString locale_warehouseGroupName = new LocaleString(this.getLocale_WarehouseGroupName());
    private LocaleString locale_supplierNum = new LocaleString(this.getLocale_supplierNum());
    private LocaleString locale_supplierName = new LocaleString(this.getLocale_supplierName());
    private LocaleString locale_lotName = new LocaleString(this.getLocale_lotName());
    private LocaleString locale_trackName = new LocaleString(this.getLocale_trackName());
    private LocaleString locale_materialNum = new LocaleString(this.getLocale_materialNum());
    private LocaleString locale_materialName = new LocaleString(this.getLocale_materialName());
    public static final String BASESTR = "mulcalorg,ownertype,owner,lot,tracknumber,period,periodid,materialid,materialname,materialnumber,baseunitid,qtyprecision,supplierid,storageorgid,storageorgnumber,storageorgname,warehouseid,warehousenumber,warehousename,warehsgroupid,warehsgroupnumber,warehsgroupname";
    public static final String BASESTR_NO_PERIOD = "mulcalorg,ownertype,owner,lot,tracknumber,materialid,materialname,materialnumber,baseunitid,qtyprecision,supplierid,storageorgid,storageorgnumber,storageorgname,warehouseid,warehousenumber,warehousename,warehsgroupid,warehsgroupnumber,warehsgroupname";

    private String getLocale_baseUnit() {
        return ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"StockEstimateGroupQueryPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_beforeperiod() {
        return ResManager.loadKDString((String)"\u671f\u521d", (String)"StockEstimateGroupQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_periodIn() {
        return ResManager.loadKDString((String)"\u5165\u5e93", (String)"StockEstimateGroupQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_periodWriteoff() {
        return ResManager.loadKDString((String)"\u5df2\u6838\u9500", (String)"StockEstimateGroupQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_periodNotWriteoff() {
        return ResManager.loadKDString((String)"\u672a\u6838\u9500", (String)"StockEstimateGroupQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocal_periodEnd() {
        return ResManager.loadKDString((String)"\u7ed3\u5b58", (String)"StockEstimateGroupQueryPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_qty() {
        return ResManager.loadKDString((String)"\u6570\u91cf", (String)"StockEstimateGroupQueryPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_price() {
        return ResManager.loadKDString((String)"\u5355\u4ef7", (String)"StockEstimateGroupQueryPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_amount() {
        return ResManager.loadKDString((String)"\u91d1\u989d", (String)"StockEstimateGroupQueryPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_currency() {
        return ResManager.loadKDString((String)"\u5e01\u79cd", (String)"StockEstimateGroupQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_storageOrgNum() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801", (String)"StockEstimateGroupQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_storageOrgName() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u540d\u79f0", (String)"StockEstimateGroupQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_warehouseNum() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u7f16\u7801", (String)"StockEstimateGroupQueryPlugin_12", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_warehouseName() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u540d\u79f0", (String)"StockEstimateGroupQueryPlugin_13", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_WarehouseGroupNum() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u5206\u7ec4\u7f16\u7801", (String)"StockGatherRptQueryPlugin_41", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_WarehouseGroupName() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u5206\u7ec4\u540d\u79f0", (String)"StockGatherRptQueryPlugin_42", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_supplierNum() {
        return ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"StockEstimateGroupQueryPlugin_16", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_supplierName() {
        return ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"StockEstimateGroupQueryPlugin_17", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_lotName() {
        return ResManager.loadKDString((String)"\u6279\u53f7", (String)"StockGatherRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_trackName() {
        return ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7", (String)"StockGatherRptQueryPlugin_61", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialNum() {
        return ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"StockDetailRptQueryPlugin_17", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialName() {
        return ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"StockDetailRptQueryPlugin_18", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    public DataSet query(ReportQueryParam param, Object arg) throws Throwable {
        try {
            this.initData(param);
            DataSet periodinDataset = this.getPeriodInDataSet();
            DataSet writeoffDataset = this.getPeriodWriteoffDataSet();
            DataSet beforeperiodDataset = this.getBeforePeriodDataSet();
            DataSet dataSet = this.unionAllDataset(periodinDataset, writeoffDataset, beforeperiodDataset);
            if (dataSet.copy().isEmpty()) {
                return dataSet;
            }
            dataSet = this.addMaterialGroup(dataSet);
            dataSet = this.addSumAndTotalDataSet(dataSet);
            dataSet = this.sumTop(dataSet);
            dataSet = this.onlyShowSum(dataSet);
            dataSet = this.addOwnerNameDataSet(dataSet);
            dataSet = this.filterSum(dataSet);
            return dataSet;
        }
        catch (Exception e) {
            StringBuilder sBuilder = new StringBuilder("StockEstimateGroupQueryPlugin=?");
            if (e instanceof KDBizException) {
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage());
                }
            } else {
                StackTraceElement[] errs;
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage()).append("\n");
                }
                for (StackTraceElement err : errs = e.getStackTrace()) {
                    sBuilder.append(err.toString()).append("\n");
                }
            }
            logger.info(sBuilder.toString());
            throw e;
        }
    }

    private DataSet filterSum(DataSet dataSet) {
        if (this.showAvailable) {
            dataSet = dataSet.filter("periodendamount <> 0");
        }
        return dataSet;
    }

    private DataSet onlyShowSum(DataSet dataSet) {
        if (this.onlyShowSum) {
            dataSet = dataSet.where("materialid = 0");
        }
        return dataSet;
    }

    private DataSet sumTop(DataSet dataSet) {
        dataSet = this.sumTop ? dataSet.orderBy(("ordercol0 desc,period,ordercol1 desc," + this.orderByColWithOutMaterial + ",ordercol2 desc").split(",")) : dataSet.orderBy(("ordercol0,period,ordercol1," + this.orderByColWithOutMaterial + ",ordercol2").split(","));
        return dataSet;
    }

    /*
     * Exception decompiling
     */
    private DataSet addMaterialGroup(DataSet dataSet) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getMaterialGroupSelects(int i, int level) {
        int j;
        StringBuilder select = new StringBuilder();
        for (j = 1; j <= i; ++j) {
            select.append(",");
            select.append(this.mgIdField).append(j);
        }
        for (j = i + 1; j <= level; ++j) {
            select.append(",");
            select.append("0L as ").append(this.mgIdField).append(j);
        }
        return select.toString();
    }

    private void initData(ReportQueryParam param) {
        this.filterInfo = param.getFilter();
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.filter_startPeriod = this.filterInfo.getDynamicObject("startperiod");
        this.startPeriodId = this.filter_startPeriod.getLong("id");
        this.filter_endPeriod = this.filterInfo.getDynamicObject("endperiod");
        this.filter_startPeriodNumber = this.filter_startPeriod.getInt("periodyear") * 100 + this.filter_startPeriod.getInt("periodnumber");
        this.filter_endPeriodNumber = this.filter_endPeriod.getInt("periodyear") * 100 + this.filter_endPeriod.getInt("periodnumber");
        this.isGroupByPeriod = this.filterInfo.getBoolean("groupbyperiod");
        this.groupType = this.filterInfo.getString("grouptype");
        this.filter_ownertype = (String)this.filterInfo.getValue("ownertypehead");
        if (StringUtils.isNotEmpty((String)this.filter_ownertype)) {
            if ("bos_org".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        this.filter_materialFrom = this.filterInfo.getDynamicObjectCollection("mulmaterial");
        this.filter_materialTo = this.filterInfo.getDynamicObject("materialto");
        this.filter_supplier = this.filterInfo.getDynamicObjectCollection("mulsupplier");
        this.filter_trackNumber = this.filterInfo.getDynamicObjectCollection("multracknum");
        this.currencyId = this.filterInfo.getDynamicObject("localcurrency").getLong("id");
        this.filter_endDate = this.filter_endPeriod.getDate("enddate");
        this.filter_startDate = this.filter_startPeriod.getDate("begindate");
        this.filter_ContainAdjustBill = this.filterInfo.getBoolean("containadjustbill");
        String dischargeType = this.filterInfo.getString("muldischargetype");
        if (dischargeType != null && !"".equals(CommonUtils.trimComma((String)dischargeType))) {
            this.filter_dischargeType = CommonUtils.trimComma((String)dischargeType).split(",");
        }
        this.filter_materialGroupStandard = this.filterInfo.getDynamicObject("materialgroupstandard");
        this.filter_materialGroups = this.filterInfo.getDynamicObjectCollection("mulmaterialgroup");
        this.level = this.filterInfo.getInt("level");
        if (!"H".equals(this.groupType)) {
            this.level = 0;
        }
        this.onlyShowSum = this.filterInfo.getBoolean("onlyshowsum");
        this.showAvailable = this.filterInfo.getBoolean("showavailable");
        this.sumTop = this.filterInfo.getBoolean("sumtop");
        this.splitSign = CommonUtils.getMaterialGroupSplit();
        switch (this.groupType) {
            case "A": 
            case "H": {
                this.groupByCols = "materialid,materialname,materialnumber,baseunitid,qtyprecision";
                this.selectField1 = "0L as materialid, null as materialname";
                this.orderByCol = new String[]{"materialid", "period"};
                this.groupByColsWithOutMaterial = "";
                this.selectFieldWithOutMaterial = "0L as materialid, null as materialname";
                this.orderByColWithOutMaterial = "period";
                break;
            }
            case "B": {
                this.groupByCols = "materialid,materialname,storageorgid,storageorgnumber,storageorgname,materialnumber,baseunitid,qtyprecision";
                this.selectField1 = "0L as materialid, null as materialname, 0L as storageorgid, null as storageorgnumber, null as storageorgname";
                this.orderByCol = new String[]{"materialid", "storageorgid", "period"};
                this.strcatlot = " and PreRowValue(storageorgid) = storageorgid ";
                this.groupByColsWithOutMaterial = "storageorgid,storageorgnumber,storageorgname";
                this.selectFieldWithOutMaterial = "0L as materialid, null as materialname,storageorgid,storageorgnumber,storageorgname";
                this.orderByColWithOutMaterial = "storageorgid";
                break;
            }
            case "C": {
                this.groupByCols = "materialid,materialname,warehouseid,warehousenumber,warehousename,materialnumber,baseunitid,qtyprecision";
                this.selectField1 = "0L as materialid, null as materialname, 0L as warehouseid, null as warehousenumber, null as warehousename";
                this.orderByCol = new String[]{"materialid", "warehouseid", "period"};
                this.strcatlot = " and PreRowValue(warehouseid) = warehouseid ";
                this.groupByColsWithOutMaterial = "warehouseid,warehousenumber,warehousename";
                this.selectFieldWithOutMaterial = "0L as materialid, null as materialname,warehouseid,warehousenumber,warehousename";
                this.orderByColWithOutMaterial = "warehouseid";
                break;
            }
            case "D": {
                this.groupByCols = "materialid,materialname,supplierid,materialnumber,baseunitid,qtyprecision";
                this.selectField1 = "0L as materialid, null as materialname, 0L as supplierid";
                this.orderByCol = new String[]{"materialid", "supplierid", "period"};
                this.strcatlot = " and PreRowValue(supplierid) = supplierid ";
                this.groupByColsWithOutMaterial = "supplierid";
                this.selectFieldWithOutMaterial = "0L as materialid, null as materialname,supplierid";
                this.orderByColWithOutMaterial = "supplierid";
                break;
            }
            case "E": {
                this.groupByCols = "materialid,materialname,ownertype,owner,materialnumber,baseunitid,qtyprecision";
                this.selectField1 = "0L as materialid, null as materialname, null as ownertype, 0 as owner";
                this.orderByCol = new String[]{"materialid", "ownertype", "owner", "period"};
                this.strcatlot = " and PreRowValue(ownertype) = ownertype and PreRowValue(owner) = owner ";
                this.groupByColsWithOutMaterial = "ownertype,owner";
                this.selectFieldWithOutMaterial = "0L as materialid, null as materialname,ownertype,owner";
                this.orderByColWithOutMaterial = "ownertype,owner";
                break;
            }
            case "F": {
                this.groupByCols = "materialid,materialname,lot,materialnumber,baseunitid,qtyprecision";
                this.selectField1 = "0L as materialid, null as materialname, null as lot";
                this.orderByCol = new String[]{"materialid", "lot", "period"};
                this.strcatlot = " and PreRowValue(lot) = lot ";
                this.groupByColsWithOutMaterial = "lot";
                this.selectFieldWithOutMaterial = "0L as materialid, null as materialname, lot";
                this.orderByColWithOutMaterial = "lot";
                break;
            }
            case "G": {
                this.groupByCols = "materialid,materialname,warehsgroupid,warehsgroupnumber,warehsgroupname,materialnumber,baseunitid,qtyprecision";
                this.selectField1 = "0L as materialid, null as materialname, 0L as warehsgroupid, null as warehsgroupnumber, null as warehsgroupname";
                this.orderByCol = new String[]{"materialid", "warehsgroupid", "period"};
                this.strcatlot = " and PreRowValue(warehsgroupid) = warehsgroupid ";
                this.groupByColsWithOutMaterial = "warehsgroupid,warehsgroupnumber,warehsgroupname";
                this.selectFieldWithOutMaterial = "0L as materialid, null as materialname,warehsgroupid, warehsgroupnumber, warehsgroupname";
                this.orderByColWithOutMaterial = "warehsgroupid";
                break;
            }
            case "I": {
                this.groupByCols = "materialid,materialname,tracknumber,materialnumber,baseunitid,qtyprecision";
                this.selectField1 = "0L as materialid, null as materialname, null as tracknumber";
                this.orderByCol = new String[]{"materialid", "tracknumber", "period"};
                this.strcatlot = " and PreRowValue(tracknumber) = tracknumber ";
                this.groupByColsWithOutMaterial = "tracknumber";
                this.selectFieldWithOutMaterial = "0L as materialid, null as materialname,tracknumber";
                this.orderByColWithOutMaterial = "tracknumber";
            }
        }
    }

    private DataSet getPeriodInDataSet() {
        QFilter q = this.getBaseFilter();
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("bookdate", ">=", (Object)this.filter_startDate);
        q.and("issplitcreate", "=", (Object)false);
        q.and("isinitbill", "=", (Object)false);
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getPeriodInSelects(), (QFilter[])new QFilter[]{q}, null);
        dataSet = dataSet.groupBy(BASESTR.split(",")).sum("periodinqty").sum("periodinamount").finish().select("mulcalorg,ownertype,owner,lot,tracknumber,period,periodid,materialid,materialname,materialnumber,baseunitid,qtyprecision,supplierid,storageorgid,storageorgnumber,storageorgname,warehouseid,warehousenumber,warehousename,warehsgroupid,warehsgroupnumber,warehsgroupname, periodinqty, periodinamount, 0 as periodwriteoffqty, 0 as periodwriteoffamount, 0 as periodnotwriteoffqty, 0 as periodnotwriteoffamount, 0 as beforeperiodqty, 0 as beforeperiodamount");
        return dataSet;
    }

    private String getPeriodInSelects() {
        String s = "id,calorg.id as mulcalorg,entry.ownertype as ownertype,entry.owner as owner, entry.lot as lot,entry.tracknumber.number as tracknumber,billnumber, bizdate,bookdate, entry.balancesupplier.masterid as supplierid, billtype.name as biztype, entry.material.id as materialid, entry.material.name as materialname, entry.material.number as materialnumber, entry.baseunit as baseunitid,entry.baseunit.precision as qtyprecision,storageorgunit.id as storageorgid, storageorgunit.number as storageorgnumber, storageorgunit.name as storageorgname, entry.warehouse.id as warehouseid, entry.warehouse.number as warehousenumber, entry.warehouse.name as warehousename, entry.warehouse.group.id as warehsgroupid, entry.warehouse.group.number as warehsgroupnumber, entry.warehouse.group.name as warehsgroupname, to_char(period.periodyear*100+period.periodnumber) as period, period.id as periodid, entry.assist as assist, case when entry.baseqty = null then 0 else entry.baseqty end as periodinqty, entry.location.id as locationid, " + this.getMaterialCostorProcessCostSelects() + " as periodinamount";
        return s;
    }

    private DataSet getPeriodWriteoffDataSet() {
        QFilter q = this.getBaseFilter();
        q.and("writeoffstatus", "=", (Object)"A");
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber >= ? ", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getPeriodWriteoffSelects(), (QFilter[])new QFilter[]{q}, null);
        if (this.filter_ContainAdjustBill) {
            DataSet copyDataSet = dataSet.copy();
            HashSet<Long> costRecordAIdSet = new HashSet<Long>(32);
            for (Row row : copyDataSet) {
                costRecordAIdSet.add(row.getLong("id"));
            }
            QFilter costadjustBaseFilter = this.getCostAdjustBaseFilter(true);
            QFilter diffBillBaseFilter = this.getCostAdjustBaseFilter(false);
            costadjustBaseFilter.and("entryentity.invbillid", "in", costRecordAIdSet);
            diffBillBaseFilter.and("entryentity.invbillid", "in", costRecordAIdSet);
            DataSet costAdjustDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjustbill", (String)this.getCostAdjustSelect(), (QFilter[])costadjustBaseFilter.toArray(), null);
            DataSet diffBillDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)this.getCostAdjustSelect(), (QFilter[])diffBillBaseFilter.toArray(), null);
            costAdjustDataSet = costAdjustDataSet.union(diffBillDataSet);
            DataSet supplier = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_supplier", (String)"id,masterid", null, null);
            costAdjustDataSet = costAdjustDataSet.join(supplier, JoinType.INNER).on("supplierid", "id").select(costAdjustDataSet.getRowMeta().getFieldNames(), new String[]{"masterid"}).finish().select("id,mulcalorg, ownertype,owner,lot,tracknumber,billnumber,bizdate,bookdate,period,periodid, masterid as supplierid,materialid,materialname,materialnumber,baseunitid,qtyprecision,storageorgid,storageorgnumber,storageorgname,warehouseid,warehousenumber,warehousename, warehsgroupid,warehsgroupnumber,warehsgroupname,locationid,assist,biztype, periodinqty,periodinamount,periodwriteoffqty,periodwriteoffamount");
            dataSet = dataSet.union(costAdjustDataSet);
        }
        dataSet = dataSet.groupBy(BASESTR.split(",")).sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").finish().select("mulcalorg,ownertype,owner,lot,tracknumber,period,periodid,materialid,materialname,materialnumber,baseunitid,qtyprecision,supplierid,storageorgid,storageorgnumber,storageorgname,warehouseid,warehousenumber,warehousename,warehsgroupid,warehsgroupnumber,warehsgroupname, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, 0 as periodnotwriteoffqty, 0 as periodnotwriteoffamount, 0 as beforeperiodqty, 0 as beforeperiodamount");
        return dataSet;
    }

    private String getCostAdjustSelect() {
        String s = "id,calorg.id as mulcalorg, entryentity.ownertype as ownertype,entryentity.owner as owner, entryentity.lot as lot, entryentity.tracknumber.number as tracknumber, billno as billnumber, bizdate,bookdate, to_char(period.periodyear*100 + period.periodnumber) as period, period.id as periodid, custsupplier as supplierid, entryentity.material.id as materialid, entryentity.material.name as materialname, entryentity.material.number as materialnumber, entryentity.material.baseunit as baseunitid,entryentity.material.baseunit.precision as qtyprecision,entryentity.storageorgunit.id as storageorgid, entryentity.storageorgunit.number as storageorgnumber, entryentity.storageorgunit.name as storageorgname, entryentity.warehouse.id as warehouseid, entryentity.warehouse.number as warehousenumber, entryentity.warehouse.name as warehousename, entryentity.warehouse.group.id as warehsgroupid, entryentity.warehouse.group.number as warehsgroupnumber, entryentity.warehouse.group.name as warehsgroupname, entryentity.location.id as locationid, entryentity.assist as assist, billtype.name as biztype, 0 as periodinqty,case when entryentity.adjustamt = null then 0 else entryentity.adjustamt end as  periodinamount,0 as periodwriteoffqty, case when entryentity.adjustamt = null then 0 else entryentity.adjustamt end as periodwriteoffamount";
        return s;
    }

    private String getPeriodWriteoffSelects() {
        String s = "id,calorg.id as mulcalorg, entry.ownertype as ownertype,entry.owner as owner, entry.lot as lot, entry.tracknumber.number as tracknumber,billnumber, bizdate, bookdate,to_char(writeoffperiod.periodyear*100 + writeoffperiod.periodnumber) as period, writeoffperiod.id as periodid, entry.balancesupplier.masterid as supplierid, entry.material.id as materialid, entry.material.name as materialname, entry.material.number as materialnumber, entry.baseunit as baseunitid,entry.baseunit.precision as qtyprecision,storageorgunit.id as storageorgid, storageorgunit.number as storageorgnumber, storageorgunit.name as storageorgname, entry.warehouse.id as warehouseid, entry.warehouse.number as warehousenumber, entry.warehouse.name as warehousename, entry.warehouse.group.id as warehsgroupid, entry.warehouse.group.number as warehsgroupnumber, entry.warehouse.group.name as warehsgroupname, entry.location.id as locationid, entry.assist as assist, billtype.name as biztype, 0 as periodinqty,0 as periodinamount,case when entry.baseqty = null then 0 else entry.baseqty end as periodwriteoffqty, " + this.getMaterialCostorProcessCostSelects() + " as periodwriteoffamount";
        return s;
    }

    private String getMaterialCostorProcessCostSelects() {
        if (this.materialCostorProcessCostSelect == null) {
            DynamicObject setting = CommonSettingHelper.getSettingObj();
            DynamicObjectCollection ominBizobjects = setting.getDynamicObjectCollection("ominbiztype");
            HashSet<String> set = new HashSet<String>();
            for (DynamicObject bizobject : ominBizobjects) {
                set.add("'" + (String)bizobject.getDynamicObject("fbasedataid").getPkValue() + "'");
            }
            this.materialCostorProcessCostSelect = set.isEmpty() ? "entry.materialcost" : "case when bizentityobject in (" + String.join((CharSequence)",", set) + ") then entry.processcost else entry.materialcost end";
        }
        return this.materialCostorProcessCostSelect;
    }

    private DataSet getBeforePeriodDataSet() {
        QFilter q1 = this.getBaseFilter();
        q1.and("issplitcreate", "=", (Object)false);
        q1.and("bookdate", "<", (Object)this.filter_startDate);
        q1.and(QFilter.of((String)"period.periodyear*100+period.periodnumber < ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q1.and(billStatusf);
        String periodInSelects = this.getPeriodInSelects();
        DataSet periodInDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)periodInSelects, (QFilter[])q1.toArray(), null);
        periodInDataSet = periodInDataSet.groupBy(BASESTR_NO_PERIOD.split(",")).sum("periodinqty").sum("periodinamount").finish().select("mulcalorg,ownertype,owner,lot,tracknumber,materialid,materialname,materialnumber,baseunitid,qtyprecision,supplierid,storageorgid,storageorgnumber,storageorgname,warehouseid,warehousenumber,warehousename,warehsgroupid,warehsgroupnumber,warehsgroupname, periodinqty, periodinamount, 0 as periodwriteoffqty, 0 as periodwriteoffamount");
        QFilter q2 = this.getBaseFilter();
        q2.and("writeoffstatus", "=", (Object)"A");
        q2.and(QFilter.of((String)"writeoffperiod.periodyear*100+writeoffperiod.periodnumber < ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q2.and(billStatusf);
        String periodWriteoffSelects = this.getPeriodWriteoffSelects();
        DataSet periodWriteOffDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)periodWriteoffSelects, (QFilter[])q2.toArray(), null).groupBy(BASESTR_NO_PERIOD.split(",")).sum("periodwriteoffqty").sum("periodwriteoffamount").finish().select("mulcalorg,ownertype,owner,lot,tracknumber,materialid,materialname,materialnumber,baseunitid,qtyprecision,supplierid,storageorgid,storageorgnumber,storageorgname,warehouseid,warehousenumber,warehousename,warehsgroupid,warehsgroupnumber,warehsgroupname, 0 as periodinqty, 0 as periodinamount, periodwriteoffqty, periodwriteoffamount");
        DataSet dataSet = periodInDataSet.join(periodWriteOffDataSet, JoinType.LEFT).on("mulcalorg", "mulcalorg").on("ownertype", "ownertype").on("owner", "owner").on("lot", "lot").on("tracknumber", "tracknumber").on("materialid", "materialid").on("supplierid", "supplierid").on("storageorgid", "storageorgid").on("warehouseid", "warehouseid").on("warehsgroupid", "warehsgroupid").select("mulcalorg,ownertype,owner,lot,tracknumber,materialid,materialname,materialnumber,baseunitid,qtyprecision,supplierid,storageorgid,storageorgnumber,storageorgname,warehouseid,warehousenumber,warehousename,warehsgroupid,warehsgroupnumber,warehsgroupname, periodinqty, periodinamount".split(","), "periodwriteoffqty, periodwriteoffamount".split(",")).finish().select("mulcalorg,ownertype,owner,lot,tracknumber,materialid,materialname,materialnumber,baseunitid,qtyprecision,supplierid,storageorgid,storageorgnumber,storageorgname,warehouseid,warehousenumber,warehousename,warehsgroupid,warehsgroupnumber,warehsgroupname, case when periodwriteoffqty = null then 0 else periodwriteoffqty end as periodwriteoffqty, case when periodwriteoffamount = null then 0 else periodwriteoffamount end as periodwriteoffamount, case when periodinqty = null then 0 else periodinqty end as periodinqty, case when periodinamount = null then 0 else periodinamount end as periodinamount");
        String period = "'" + this.filter_startPeriodNumber + "'";
        String str = "mulcalorg, ownertype, owner, lot,tracknumber, " + period + " as period, " + this.startPeriodId + " as periodid, materialid, materialname, materialnumber, baseunitid, qtyprecision, supplierid, storageorgid, storageorgnumber, storageorgname, warehouseid, warehousenumber, warehousename, warehsgroupid, warehsgroupnumber, warehsgroupname, 0 as periodinqty, 0 as periodinamount, 0 as periodwriteoffqty, 0 as periodwriteoffamount";
        dataSet = dataSet.select(str + ", 0 as periodnotwriteoffqty, 0 as periodnotwriteoffamount, periodinqty - periodwriteoffqty as beforeperiodqty, periodinamount - periodwriteoffamount as beforeperiodamount");
        str = "mulcalorg, ownertype, owner, lot,tracknumber, period, Cast(periodid as Long) as periodid, materialid, materialname, materialnumber, baseunitid, qtyprecision, supplierid, storageorgid, storageorgnumber, storageorgname, warehouseid, warehousenumber, warehousename, warehsgroupid, warehsgroupnumber, warehsgroupname, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount";
        dataSet = dataSet.select(str + ", periodnotwriteoffqty, periodnotwriteoffamount, beforeperiodqty, beforeperiodamount");
        return dataSet;
    }

    private StringBuilder getGroupBys() {
        StringBuilder groupbys = new StringBuilder();
        groupbys.append("period,periodid,mulcalorg,").append(this.groupByCols);
        return groupbys;
    }

    private StringBuilder getSelects1() {
        StringBuilder groupbys = new StringBuilder();
        groupbys.append("period,periodid,mulcalorg,").append(this.selectField1);
        return groupbys;
    }

    private StringBuilder getSelects2() {
        StringBuilder groupbys = new StringBuilder();
        groupbys.append("null as period,0L as periodid,mulcalorg,").append(this.selectField1);
        return groupbys;
    }

    private DataSet unionAllDataset(DataSet periodinDataset, DataSet periodWriteoffDataset, DataSet beforeperiodDataset) {
        String allCols = "period, periodid, mulcalorg, materialid, materialname, materialnumber, Cast(baseunitid as Long) as baseunitid, Cast(qtyprecision as Integer) as qtyprecision, supplierid, storageorgid, storageorgnumber, storageorgname, warehouseid, warehousenumber, warehousename, warehsgroupid, warehsgroupnumber, warehsgroupname,ownertype, owner, lot, tracknumber,  beforeperiodqty, beforeperiodamount, periodinqty, periodinamount,periodwriteoffqty,  periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount";
        String groupbys = this.getGroupBys().toString();
        DataSet initDataSet = this.getInitDataSet(BASESTR);
        periodinDataset.getRowMeta().getField("beforeperiodqty").setDataType((DataType)DataType.BigDecimalType);
        periodinDataset.getRowMeta().getField("beforeperiodamount").setDataType((DataType)DataType.BigDecimalType);
        DataSet dataSet = periodinDataset.union(new DataSet[]{periodWriteoffDataset, beforeperiodDataset, initDataSet.select(BASESTR + this.getInitUnioinSelect())}).select(allCols);
        DataSet periodDataSet = this.getPeriodDataSet();
        JoinDataSet joinDS = periodDataSet.join(dataSet.groupBy(groupbys.substring(16).split(",")).finish(), JoinType.CROSS).select(new String[]{"period", "periodid"}, groupbys.substring(16).split(",")).finish().join(dataSet, JoinType.LEFT);
        for (String onField : groupbys.split(",")) {
            onField = onField.trim();
            joinDS = joinDS.on(onField, onField);
        }
        dataSet = joinDS.select(groupbys.split(","), new String[]{"beforeperiodqty", "beforeperiodamount", "periodinqty", "periodinamount", "periodwriteoffqty", "periodwriteoffamount", "periodnotwriteoffqty", "periodnotwriteoffamount"}).finish();
        dataSet = dataSet.select(this.getFinalSelects("coverNullToZero"));
        dataSet = dataSet.groupBy(groupbys.split(",")).sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").sum("periodnotwriteoffqty").sum("periodnotwriteoffamount").sum("beforeperiodqty").sum("beforeperiodamount").finish().select(this.getFinalSelects("unionandsum"));
        dataSet = dataSet.orderBy(this.orderByCol);
        dataSet = this.filter_startPeriodNumber == this.filter_endPeriodNumber ? dataSet.select(this.getFinalSelects("periodendOne")) : dataSet.select(this.getFinalSelects("periodendMul")).select(this.getFinalSelects("endTobefore"));
        JoinDataSet joinDataSet = dataSet.join(initDataSet, JoinType.LEFT);
        for (String onField : groupbys.substring(16).split(",")) {
            onField = onField.trim();
            joinDataSet = joinDataSet.on(onField, onField);
        }
        dataSet = joinDataSet.select((groupbys + ",beforeperiodqty,beforeperiodamount,periodinqty,periodinamount,periodwriteoffqty,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffamount,periodendqty,periodendamount").split(","), new String[]{"period as beginperiod", "initqty", "initamount"}).finish().select(groupbys + ", beforeperiodqty, beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount,periodendqty,periodendamount,case when beginperiod = null then '0' else beginperiod end as beginperiod,case when initqty = null then 0 else initqty end as initqty,case when initamount = null then 0 else initamount end as initamount").select(groupbys + ", beforeperiodqty, beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount,periodendqty,periodendamount,beginperiod,case when period < beginperiod then 0 else initqty end as initqty,case when period < beginperiod then 0 else initamount end as initamount");
        dataSet = dataSet.groupBy((groupbys + ",beforeperiodqty,beforeperiodamount,periodinqty,periodinamount,periodwriteoffqty,periodwriteoffamount,periodnotwriteoffqty,periodnotwriteoffamount,periodendqty,periodendamount").split(",")).sum("initqty").sum("initamount").finish().select(groupbys + ", beforeperiodqty+ initqty as beforeperiodqty, beforeperiodamount+initamount as  beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount,periodendqty+initqty as periodendqty,periodendamount+initamount as periodendamount");
        dataSet = dataSet.where("beforeperiodqty<>0 OR beforeperiodamount<>0 OR periodinqty<>0 OR periodinamount<>0 OR periodwriteoffqty<>0 OR periodwriteoffamount<>0 OR periodnotwriteoffqty<>0 OR periodnotwriteoffamount<>0 OR periodendqty<>0 OR periodendamount<>0");
        return dataSet;
    }

    private String getInitUnioinSelect() {
        return ", 0 as beforeperiodqty, 0 as beforeperiodamount, 0 as periodinqty, 0 as periodinamount, 0 as periodwriteoffqty, 0 as periodwriteoffamount, 0 as periodnotwriteoffqty, 0 as periodnotwriteoffamount";
    }

    private DataSet getPeriodDataSet() {
        QFilter q = QFilter.of((String)"periodyear*100+periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber});
        q.and(QFilter.of((String)"periodyear*100+periodnumber <= ? ", (Object[])new Object[]{this.filter_endPeriodNumber}));
        DynamicObject costAccountInfo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", this.filter_costAccount.get("id"))});
        q.and("periodtype", "=", costAccountInfo.get("calpolicy.periodtype"));
        q.and("isadjustperiod", "=", (Object)false);
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)"id as periodid,to_char(periodyear*100+periodnumber) as period", (QFilter[])new QFilter[]{q}, (String)"id asc");
    }

    private DataSet getInitDataSet(String groupbys) {
        QFilter q = this.getBaseFilter();
        q.and("bookdate", "<=", (Object)this.filter_endDate);
        q.and("issplitcreate", "=", (Object)false);
        q.and("isinitbill", "=", (Object)true);
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber >= ?", (Object[])new Object[]{this.filter_startPeriodNumber}));
        q.and(QFilter.of((String)"period.periodyear*100+period.periodnumber <= ?", (Object[])new Object[]{this.filter_endPeriodNumber}));
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getPeriodInSelects(), (QFilter[])new QFilter[]{q}, null);
        dataSet = dataSet.groupBy(groupbys.split(",")).sum("periodinqty", "initqty").sum("periodinamount", "initamount").finish();
        return dataSet;
    }

    private DataSet addSumAndTotalDataSet(DataSet dataSet) {
        StringBuilder materialGroupFields = new StringBuilder();
        StringBuilder materialGroup4SumFields = new StringBuilder();
        for (String field : this.mgFieldList) {
            materialGroupFields.append(",");
            materialGroupFields.append(field);
            materialGroup4SumFields.append(",");
            materialGroup4SumFields.append("0L as ").append(field);
        }
        String s = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"StockEstimateGroupQueryPlugin_24", (String)"fi-cal-report", (Object[])new Object[0]);
        String select = "period,periodid,mulcalorg," + this.selectFieldWithOutMaterial + ", '" + s + "' as materialnumber,baseunitid,qtyprecision, beforeperiodqty, beforeperiodamount, periodinqty, periodinamount,periodwriteoffqty, periodwriteoffamount, periodendqty as periodnotwriteoffqty, periodendamount as periodnotwriteoffamount, periodendqty, periodendamount" + materialGroup4SumFields;
        DataSet groupDataSet = dataSet.copy().where("materialid <> 0").groupBy(("period,periodid,mulcalorg," + this.groupByColsWithOutMaterial).split(",")).sum("beforeperiodqty").sum("beforeperiodamount").sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").sum("periodnotwriteoffqty").sum("periodnotwriteoffamount").sum("periodendqty").sum("periodendamount").maxP("qtyprecision", "baseunitid").max("qtyprecision").finish().select(select);
        String s1 = ResManager.loadKDString((String)"\u672c\u671f\u5c0f\u8ba1", (String)"StockEstimateGroupQueryPlugin_18", (String)"fi-cal-report", (Object[])new Object[0]);
        String string2 = this.getSelects1().toString() + ", '" + s1 + "' as materialnumber,baseunitid,qtyprecision, beforeperiodqty, beforeperiodamount, periodinqty, periodinamount,periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount, periodendqty, periodendamount";
        String string22 = this.getSelects1().toString() + ", '" + s1 + "' as materialnumber,baseunitid,qtyprecision, beforeperiodqty, beforeperiodamount, periodinqty, periodinamount,periodwriteoffqty, periodwriteoffamount, periodendqty as periodnotwriteoffqty, periodendamount as periodnotwriteoffamount, periodendqty, periodendamount" + materialGroup4SumFields;
        DataSet littleDataSet = dataSet.copy().where("materialid <> 0").groupBy(new String[]{"period", "mulcalorg", "periodid"}).sum("beforeperiodqty").sum("beforeperiodamount").sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").sum("periodnotwriteoffqty").sum("periodnotwriteoffamount").sum("periodendqty").sum("periodendamount").maxP("qtyprecision", "baseunitid").max("qtyprecision").finish().select(string2).select(string22);
        String s2 = ResManager.loadKDString((String)"\u603b\u8ba1", (String)"StockEstimateGroupQueryPlugin_19", (String)"fi-cal-report", (Object[])new Object[0]);
        String string3 = this.getSelects2() + ", '" + s2 + "' as materialnumber,baseunitid,qtyprecision, beforeperiodqty, beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, 0 as periodnotwriteoffqty, 0 as periodnotwriteoffamount, periodendqty, periodendamount" + materialGroup4SumFields;
        DataSet totalAllDataSet = littleDataSet.groupBy(new String[]{"mulcalorg"}).sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").max("qtyprecision").maxP("qtyprecision", "baseunitid").finish().select("mulcalorg,baseunitid,qtyprecision,0 as beforeperiodqty,0 as beforeperiodamount,periodinqty,periodinamount,periodwriteoffqty,periodwriteoffamount,0 as periodendqty,0 as periodendamount").union(littleDataSet.orderBy(new String[]{"period desc"}).top(1).select("mulcalorg,baseunitid,qtyprecision,0 as beforeperiodqty,0 as beforeperiodamount,0 as periodinqty,0 as periodinamount,0 as periodwriteoffqty,0 as periodwriteoffamount,periodendqty,periodendamount")).union(littleDataSet.orderBy(new String[]{"period"}).top(1).select("mulcalorg,baseunitid,qtyprecision,beforeperiodqty,beforeperiodamount,0 as periodinqty,0 as periodinamount,0 as periodwriteoffqty,0 as periodwriteoffamount,0 as periodendqty,0 as periodendamount")).groupBy(new String[]{"mulcalorg"}).sum("beforeperiodqty").sum("beforeperiodamount").sum("periodinqty").sum("periodinamount").sum("periodwriteoffqty").sum("periodwriteoffamount").sum("periodendqty").sum("periodendamount").maxP("qtyprecision", "baseunitid").max("qtyprecision").finish().select(string3);
        dataSet = dataSet.addField("0", "ordercol0").addField("0", "ordercol1").addField("0", "ordercol2").union(groupDataSet.addField("0", "ordercol0").addField("0", "ordercol1").addField("1", "ordercol2")).union(littleDataSet.addField("0", "ordercol0").addField("1", "ordercol1").addField("0", "ordercol2")).union(totalAllDataSet.addField("1", "ordercol0").addField("0", "ordercol1").addField("0", "ordercol2")).select(this.getFinalSelects("addprice") + materialGroupFields + ",ordercol0,ordercol1,ordercol2");
        return dataSet;
    }

    private DataSet addOwnerNameDataSet(DataSet dataSet) {
        if (this.isGroupByPeriod) {
            dataSet = dataSet.addField("concat(concat('" + this.filter_startPeriodNumber + "','-'),'" + this.filter_endPeriodNumber + "')", "period");
        }
        if (this.groupType.equals("E")) {
            dataSet = dataSet.addField("owner", "ownernumber");
        }
        return dataSet;
    }

    private String getFinalSelects(String s) {
        String string = this.getGroupBys().toString();
        switch (s) {
            case "unionandsum": {
                string = string + ", beforeperiodqty, beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount";
                break;
            }
            case "coverNullToZero": {
                string = string + ", case when beforeperiodqty = null then 0 else beforeperiodqty end as beforeperiodqty, case when beforeperiodamount = null then 0 else beforeperiodamount end as beforeperiodamount, case when periodinqty = null then 0 else periodinqty end as periodinqty, case when periodinamount = null then 0 else periodinamount end as periodinamount, case when periodwriteoffqty = null then 0 else periodwriteoffqty end as periodwriteoffqty, case when periodwriteoffamount = null then 0 else periodwriteoffamount end as periodwriteoffamount, case when periodnotwriteoffqty = null then 0 else periodnotwriteoffqty end as periodnotwriteoffqty, case when periodnotwriteoffamount = null then 0 else periodnotwriteoffamount end as periodnotwriteoffamount";
                break;
            }
            case "calnotwriteoff": {
                string = ", periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, case when periodinqty <> 0 then periodinqty-periodwriteoffqty else periodnotwriteoffqty end as periodnotwriteoffqty, case when periodinamount <> 0 then periodinamount-periodwriteoffamount else periodnotwriteoffamount end as periodnotwriteoffamount";
                break;
            }
            case "periodendOne": {
                string = string + ", beforeperiodqty, beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount, beforeperiodqty + periodinqty - periodwriteoffqty as periodendqty, beforeperiodamount + periodinamount - periodwriteoffamount as periodendamount";
                break;
            }
            case "periodendMul": {
                string = string + ", beforeperiodqty, beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount, case when PreRowValue(materialid) <> null and  PreRowValue(materialid) = materialid" + this.strcatlot + " \t\tthen PreRowValue(periodendqty) + periodinqty - periodwriteoffqty \t\telse beforeperiodqty + periodinqty - periodwriteoffqty end as periodendqty, case when PreRowValue(materialid) <> null and  PreRowValue(materialid) = materialid" + this.strcatlot + " \t\tthen PreRowValue(periodendamount) + periodinamount - periodwriteoffamount \t\telse beforeperiodamount + periodinamount - periodwriteoffamount end as periodendamount";
                break;
            }
            case "endTobefore": {
                string = string + ", case when PreRowValue(materialid) = materialid " + this.strcatlot + " then PreRowValue(periodendqty) else beforeperiodqty end as beforeperiodqty, case when PreRowValue(materialid) = materialid " + this.strcatlot + " then PreRowValue(periodendamount) else beforeperiodamount end as beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodnotwriteoffqty, periodnotwriteoffamount, periodendqty, periodendamount";
                break;
            }
            case "periodendTonotwriteoff": {
                string = string + ", beforeperiodqty, beforeperiodamount, periodinqty, periodinamount, periodwriteoffqty, periodwriteoffamount, periodendqty, periodendamount, periodendqty as periodnotwriteoffqty, periodendamount as periodnotwriteoffamount";
                break;
            }
            case "addprice": {
                string = string + ", beforeperiodqty, beforeperiodamount, case when beforeperiodqty = 0 then 0 else beforeperiodamount/beforeperiodqty end as beforeperiodprice,  periodinqty, periodinamount, case when periodinqty = 0 then 0 else periodinamount/periodinqty end as periodinprice, periodnotwriteoffqty,  periodwriteoffqty, periodwriteoffamount, case when periodwriteoffqty = 0 then 0 else periodwriteoffamount/periodwriteoffqty end as periodwriteoffprice, periodnotwriteoffamount, case when periodnotwriteoffqty = 0 then 0 else periodnotwriteoffamount/periodnotwriteoffqty end as periodnotwriteoffprice, periodendqty, periodendamount, case when periodendqty = 0 then 0 else periodendamount/periodendqty end as periodendprice, " + this.currencyId + " as currencyid";
                break;
            }
            case "addowner": {
                string = string + ", beforeperiodqty, beforeperiodamount, beforeperiodprice, periodinqty, periodinamount,  periodinprice, periodwriteoffqty, periodwriteoffamount, periodwriteoffprice, periodnotwriteoffqty, periodnotwriteoffamount, periodnotwriteoffprice, periodendqty, periodendamount, periodendprice, currencyid, ownertype, owner";
            }
        }
        return string;
    }

    private QFilter getCostAdjustBaseFilter(boolean isAdjBill) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                q.and("entryentity.material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("entryentity.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("entryentity.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        if (this.filter_materialGroups != null && !this.filter_materialGroups.isEmpty()) {
            set = new HashSet<Object>(this.filter_materialGroups.size());
            for (DynamicObject info : this.filter_materialGroups) {
                set.add(info.getString("longnumber"));
            }
            q.and("entryentity.material.id", "in", (Object)CommonUtils.getMaterialIdsByMatGroups(set, (long)this.filter_materialGroupStandard.getLong("id")));
        }
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costadjustbill");
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.location", "in", set);
        }
        if (this.filter_trackNumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_trackNumber) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.tracknumber", "in", set);
        }
        q.and("biztype", "=", (Object)"A");
        if (isAdjBill) {
            q.and("createtype", "in", (Object)new String[]{"B", "U"});
        }
        q.and("period", ">=", this.filter_startPeriod.getPkValue());
        q.and("period", "<=", this.filter_endPeriod.getPkValue());
        return q;
    }

    private QFilter getBaseFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costrecord");
        if (this.filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entry.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entry.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entry.location", "in", set);
        }
        if (this.filter_trackNumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_trackNumber) {
                set.add(info.getPkValue());
            }
            q.and("entry.tracknumber", "in", set);
        }
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                q.and("entry.material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("entry.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("entry.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        if (this.filter_materialGroups != null && !this.filter_materialGroups.isEmpty()) {
            set = new HashSet(this.filter_materialGroups.size());
            for (DynamicObject info : this.filter_materialGroups) {
                set.add(info.getString("longnumber"));
            }
            q.and("entry.material.id", "in", (Object)CommonUtils.getMaterialIdsByMatGroups(set, (long)this.filter_materialGroupStandard.getLong("id")));
        }
        if (this.filter_supplier != null) {
            q.and("entry.balancesupplier.id", "in", (Object)ReportUtil.getBasedateIdsFromDyColNumers((DynamicObjectCollection)this.filter_supplier, (String)"bd_supplier"));
        }
        if (this.filter_dischargeType != null) {
            q.and("dischargetype", "in", (Object)this.filter_dischargeType);
        }
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection bizobjects = setting.getDynamicObjectCollection("purbiztype");
        DynamicObjectCollection ominBizobjects = setting.getDynamicObjectCollection("ominbiztype");
        bizobjects.addAll((Collection)ominBizobjects);
        HashSet<Object> set2 = new HashSet<Object>();
        for (DynamicObject bizobject : bizobjects) {
            set2.add(bizobject.getDynamicObject("fbasedataid").getPkValue());
        }
        q.and("bizentityobject", "in", set2);
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        return q;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        this.createColumnsByGroupType(cols);
        this.createMaterialGroupColumns(cols);
        this.createMaterialColumns(cols);
        this.createDecimalColumns(cols);
        this.createHideColumns(cols);
        return cols;
    }

    private void createMaterialGroupColumns(List<AbstractReportColumn> cols) {
        if (!"H".equals(this.groupType)) {
            return;
        }
        for (int i = 1; i <= this.level; ++i) {
            ReportColumn materialGroupId = new ReportColumn();
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ea7\u7269\u6599\u5206\u7c7b\u7f16\u7801", (String)"StockGatherRptQueryPlugin_50", (String)"fi-cal-report", (Object[])new Object[0]), i);
            LocaleString locale_materialGroupNum = new LocaleString(msg);
            materialGroupId.setCaption(locale_materialGroupNum);
            materialGroupId.setWidth(width);
            materialGroupId.setFieldKey(this.mgIdField + i);
            materialGroupId.setFieldType("basedata");
            materialGroupId.setEntityId("bd_materialgroup");
            materialGroupId.setDisplayProp("number");
            ReportColumn materialGroupName = ReportColumn.createBaseDataPropColumn((String)("mgname" + i), (String)(this.mgIdField + i), (String)"name");
            String msg1 = String.format(ResManager.loadKDString((String)"%1$s\u7ea7\u7269\u6599\u5206\u7c7b\u540d\u79f0", (String)"StockGatherRptQueryPlugin_51", (String)"fi-cal-report", (Object[])new Object[0]), i);
            LocaleString locale_materialGroupName = new LocaleString(msg1);
            materialGroupName.setCaption(locale_materialGroupName);
            materialGroupName.setWidth(width);
            cols.add((AbstractReportColumn)materialGroupId);
            cols.add((AbstractReportColumn)materialGroupName);
        }
    }

    private void createDecimalColumns(List<AbstractReportColumn> cols) {
        this.createDecimalColumn(cols, this.local_beforeperiod, "beforeperiod");
        this.createDecimalColumn(cols, this.local_periodIn, "periodin");
        this.createDecimalColumn(cols, this.local_periodWriteoff, "periodwriteoff");
        this.createDecimalColumn(cols, this.local_periodNotWriteoff, "periodnotwriteoff");
        this.createDecimalColumn(cols, this.local_periodEnd, "periodend");
    }

    private void createDecimalColumn(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey);
        cols.add((AbstractReportColumn)groupCol);
        ReportColumn qty = new ReportColumn();
        qty.setCaption(this.locale_qty);
        qty.setWidth(width);
        qty.setFieldKey(fieldKey + "qty");
        qty.setFieldType("qty");
        qty.setMeasureUnitField("baseunitid");
        ReportColumn price = new ReportColumn();
        price.setCaption(this.locale_price);
        price.setWidth(width);
        price.setFieldKey(fieldKey + "price");
        price.setFieldType("price");
        price.setCurrencyField("currencyid");
        ReportColumn amount = new ReportColumn();
        amount.setCaption(this.locale_amount);
        amount.setWidth(width);
        amount.setFieldKey(fieldKey + "amount");
        amount.setFieldType("amount");
        amount.setCurrencyField("currencyid");
        groupCol.getChildren().add(qty);
        groupCol.getChildren().add(price);
        groupCol.getChildren().add(amount);
        if ("periodnotwriteoff".equals(fieldKey)) {
            qty.setHide(true);
            price.setHide(true);
            amount.setHide(true);
        }
    }

    private void createHideColumns(List<AbstractReportColumn> cols) {
        ReportColumn baseUnitId = new ReportColumn();
        baseUnitId.setCaption(this.locale_baseUnit);
        baseUnitId.setWidth(width);
        baseUnitId.setFieldKey("baseunitid");
        baseUnitId.setFieldType("unit");
        baseUnitId.setEntityId("bd_measureunits");
        baseUnitId.setHide(true);
        ReportColumn qtyPrecision = new ReportColumn();
        qtyPrecision.setCaption(this.locale_currency);
        qtyPrecision.setWidth(width);
        qtyPrecision.setFieldKey("qtyprecision");
        qtyPrecision.setFieldType("text");
        qtyPrecision.setHide(true);
        ReportColumn currencyId = new ReportColumn();
        currencyId.setCaption(this.locale_currency);
        currencyId.setWidth(width);
        currencyId.setFieldKey("currencyid");
        currencyId.setFieldType("currency");
        currencyId.setEntityId("bd_currency");
        currencyId.setHide(true);
        cols.add((AbstractReportColumn)qtyPrecision);
        cols.add((AbstractReportColumn)baseUnitId);
        cols.add((AbstractReportColumn)currencyId);
        ReportColumn year = new ReportColumn();
        year.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e74", (String)"StockEstimateGroupQueryPlugin_20", (String)"fi-cal-report", (Object[])new Object[0])));
        year.setWidth(width);
        year.setFieldKey("year");
        year.setFieldType("integer");
        year.setHide(true);
        ReportColumn month = new ReportColumn();
        month.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6708", (String)"StockEstimateGroupQueryPlugin_21", (String)"fi-cal-report", (Object[])new Object[0])));
        month.setWidth(width);
        month.setFieldKey("month");
        month.setFieldType("integer");
        month.setHide(true);
        cols.add((AbstractReportColumn)year);
        cols.add((AbstractReportColumn)month);
    }

    private void createMaterialColumns(List<AbstractReportColumn> cols) {
        ReportColumn materialNumber = new ReportColumn();
        materialNumber.setCaption(this.locale_materialNum);
        materialNumber.setWidth(width);
        materialNumber.setFieldKey("materialnumber");
        materialNumber.setFieldType("text");
        ReportColumn materialName = new ReportColumn();
        materialName.setCaption(this.locale_materialName);
        materialName.setWidth(width);
        materialName.setFieldKey("materialname");
        materialName.setFieldType("text");
        Tips tips = new Tips("text", "");
        tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u8054\u67e5\u660e\u7ec6\u8868", (String)"StockGatherRptQueryPlugin_33", (String)"fi-cal-report", (Object[])new Object[0])));
        materialName.setCtlTips(tips);
        materialName.setHyperlink(true);
        ReportColumn materialid = new ReportColumn();
        materialid.setCaption(this.locale_materialNum);
        materialid.setWidth(width);
        materialid.setFieldKey("materialid");
        materialid.setFieldType("basedata");
        materialid.setEntityId("bd_material");
        materialid.setHide(true);
        cols.add((AbstractReportColumn)materialNumber);
        cols.add((AbstractReportColumn)materialName);
        cols.add((AbstractReportColumn)materialid);
    }

    private void createStorageColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_storageOrgNum, this.locale_storageOrgName, "storageorg");
    }

    private void createWarehouseColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_warehouseNum, this.locale_warehouseName, "warehouse");
    }

    private void createSupplierColumns(List<AbstractReportColumn> cols) {
        ReportColumn supplierId = new ReportColumn();
        supplierId.setCaption(this.locale_supplierNum);
        supplierId.setWidth(width);
        supplierId.setFieldKey("supplierid");
        supplierId.setFieldType("basedata");
        supplierId.setEntityId("bd_supplier");
        supplierId.setDisplayProp("number");
        ReportColumn supplierName = ReportColumn.createBaseDataPropColumn((String)"suppliername", (String)"supplierid", (String)"name");
        supplierName.setCaption(this.locale_supplierName);
        supplierName.setWidth(width);
        cols.add((AbstractReportColumn)supplierId);
        cols.add((AbstractReportColumn)supplierName);
    }

    private void createWarehsColumn(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_warehouseGroupNum, this.locale_warehouseGroupName, "warehsgroup");
    }

    private void createColumnsByGroupType(List<AbstractReportColumn> cols) {
        if (this.hasGroup(this.groupType, "B")) {
            this.createStorageColumns(cols);
        }
        if (this.hasGroup(this.groupType, "C")) {
            this.createWarehouseColumns(cols);
        }
        if (this.hasGroup(this.groupType, "D")) {
            this.createSupplierColumns(cols);
        }
        if (!this.hasGroup(this.groupType, "E")) {
            ReportUtil.hideOwnerColumns(cols);
        }
        if (this.hasGroup(this.groupType, "F")) {
            this.createLotColumn(cols);
        }
        if (this.hasGroup(this.groupType, "G")) {
            this.createWarehsColumn(cols);
        }
        if (this.hasGroup(this.groupType, "I")) {
            this.createTrackNumColumn(cols);
        }
    }

    private void createLotColumn(List<AbstractReportColumn> cols) {
        ReportColumn lot = new ReportColumn();
        lot.setCaption(this.locale_lotName);
        lot.setWidth(width);
        lot.setFieldKey("lot");
        lot.setFieldType("text");
        cols.add((AbstractReportColumn)lot);
    }

    private void createTrackNumColumn(List<AbstractReportColumn> cols) {
        ReportColumn lot = new ReportColumn();
        lot.setCaption(this.locale_trackName);
        lot.setWidth(width);
        lot.setFieldKey("tracknumber");
        lot.setFieldType("text");
        cols.add((AbstractReportColumn)lot);
    }

    private boolean hasGroup(String groupType, String value) {
        return groupType.indexOf(value) >= 0;
    }

    private void createGroupTypeColumns(List<AbstractReportColumn> cols, LocaleString numCaption, LocaleString nameCaption, String fieldKey) {
        ReportColumn number = new ReportColumn();
        number.setCaption(numCaption);
        number.setWidth(width);
        number.setFieldKey(fieldKey + "number");
        number.setFieldType("text");
        ReportColumn name = new ReportColumn();
        name.setCaption(nameCaption);
        name.setWidth(width);
        name.setFieldKey(fieldKey + "name");
        name.setFieldType("text");
        ReportColumn id = new ReportColumn();
        id.setCaption(numCaption);
        id.setWidth(width);
        id.setFieldKey(fieldKey + "id");
        id.setFieldType("text");
        id.setHide(true);
        cols.add((AbstractReportColumn)number);
        cols.add((AbstractReportColumn)name);
        cols.add((AbstractReportColumn)id);
    }
}

