/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.util.ArrayUtils;
import kd.fi.cal.common.util.ReportUtil;

public class StockGatherDetailRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(StockGatherDetailRptQueryPlugin.class);
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private DynamicObject filter_period;
    private int filter_periodNumber;
    private String groupType;
    private String filter_ownertype;
    private DynamicObjectCollection filter_ownerFrom;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private DynamicObjectCollection filter_materialFrom;
    private DynamicObject filter_materialTo;
    private String filter_lot;
    private DynamicObjectCollection filter_project;
    private DynamicObjectCollection filter_invType;
    private DynamicObjectCollection filter_invStatus;
    private boolean filter_onlyShowDiff;
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private boolean isCalByCostelement;
    private LocaleString locale_calRangeNum = new LocaleString(this.getLocale_calRangeNum());
    private LocaleString locale_calRangeName = new LocaleString(this.getLocale_calRangeName());
    private LocaleString locale_storageOrgNum = new LocaleString(this.getLocale_storageOrgNum());
    private LocaleString locale_storageOrgName = new LocaleString(this.getLocale_storageOrgName());
    private LocaleString locale_warehouseNum = new LocaleString(this.getLocale_warehouseNum());
    private LocaleString locale_warehsGroupNum = new LocaleString(this.getLocale_WarehsGroupNum());
    private LocaleString locale_warehsGroupName = new LocaleString(this.getLocale_WarehsGroupName());
    private LocaleString locale_warehouseName = new LocaleString(this.getLocale_warehouseName());
    private LocaleString locale_locationNum = new LocaleString(this.getLocale_locationNum());
    private LocaleString locale_locationName = new LocaleString(this.getLocale_locationName());
    private LocaleString locale_lot = new LocaleString(this.getLocale_lot());
    private LocaleString locale_assistProperty = new LocaleString(this.getLocale_assistProperty());
    private LocaleString locale_projectNum = new LocaleString(this.getLocale_projectNum());
    private LocaleString locale_materialNum = new LocaleString(this.getLocale_materialNum());
    private LocaleString locale_materialName = new LocaleString(this.getLocale_materialName());
    private LocaleString locale_baseUnit = new LocaleString(this.getLocale_baseUnit());
    private LocaleString locale_gather = new LocaleString(this.getLocale_gather());
    private LocaleString locale_detail = new LocaleString(this.getLocale_detail());
    private LocaleString locale_diff = new LocaleString(this.getLocale_diff());
    private LocaleString locale_inqty = new LocaleString(this.getLocale_inqty());
    private LocaleString locale_inamount = new LocaleString(this.getLocale_inamount());
    private LocaleString locale_outqty = new LocaleString(this.getLocale_outqty());
    private LocaleString locale_outamount = new LocaleString(this.getLocale_outamount());
    private LocaleString locale_currency = new LocaleString(this.getLocale_currency());
    private static final LocaleString width = new LocaleString("100px");

    private String getLocale_calRangeNum() {
        return ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u7f16\u7801", (String)"StockGatherRptQueryPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_calRangeName() {
        return ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u540d\u79f0", (String)"StockGatherRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_storageOrgNum() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801", (String)"StockGatherRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_storageOrgName() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u540d\u79f0", (String)"StockGatherRptQueryPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_warehouseNum() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u7f16\u7801", (String)"StockGatherRptQueryPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_warehouseName() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u540d\u79f0", (String)"StockGatherRptQueryPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_WarehsGroupNum() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u5206\u7ec4\u7f16\u7801", (String)"StockGatherRptQueryPlugin_41", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_WarehsGroupName() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u5206\u7ec4\u540d\u79f0", (String)"StockGatherRptQueryPlugin_42", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_locationNum() {
        return ResManager.loadKDString((String)"\u4ed3\u4f4d\u7f16\u7801", (String)"StockGatherRptQueryPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_locationName() {
        return ResManager.loadKDString((String)"\u4ed3\u4f4d\u540d\u79f0", (String)"StockGatherRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_lot() {
        return ResManager.loadKDString((String)"\u6279\u53f7", (String)"StockGatherRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_assistProperty() {
        return ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"StockGatherRptQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_projectNum() {
        return ResManager.loadKDString((String)"\u9879\u76ee\u53f7", (String)"StockGatherRptQueryPlugin_12", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialNum() {
        return ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"StockGatherRptQueryPlugin_13", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialName() {
        return ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"StockGatherRptQueryPlugin_14", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_baseUnit() {
        return ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"StockGatherRptQueryPlugin_20", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_gather() {
        return ResManager.loadKDString((String)"\u6536\u53d1\u6c47\u603b", (String)"StockGatherDetailRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_detail() {
        return ResManager.loadKDString((String)"\u6536\u53d1\u660e\u7ec6", (String)"StockGatherDetailRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_diff() {
        return ResManager.loadKDString((String)"\u5dee\u5f02", (String)"StockGatherDetailRptQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_inqty() {
        return ResManager.loadKDString((String)"\u6536\u5165\u6570\u91cf", (String)"StockGatherDetailRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_inamount() {
        return ResManager.loadKDString((String)"\u6536\u5165\u91d1\u989d", (String)"StockGatherDetailRptQueryPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_outqty() {
        return ResManager.loadKDString((String)"\u53d1\u51fa\u6570\u91cf", (String)"StockGatherDetailRptQueryPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_outamount() {
        return ResManager.loadKDString((String)"\u53d1\u51fa\u91d1\u989d", (String)"StockGatherDetailRptQueryPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_currency() {
        return ResManager.loadKDString((String)"\u5e01\u79cd", (String)"StockGatherRptQueryPlugin_28", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private void init(ReportQueryParam param) {
        this.filterInfo = param.getFilter();
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.isCalByCostelement = ReportUtil.isCalByCostelement((long)this.filter_costAccount.getLong("id"));
        this.filter_period = this.filterInfo.getDynamicObject("period");
        this.filter_periodNumber = this.filter_period.getInt("periodyear") * 100 + this.filter_period.getInt("periodnumber");
        this.groupType = this.filterInfo.getString("mulgrouptype");
        if (this.groupType == null) {
            this.groupType = "A";
        }
        if (this.groupType.contains("E") && this.groupType.contains("F") && !this.groupType.contains("D")) {
            this.groupType = this.groupType + "D,";
        }
        this.filter_ownertype = (String)this.filterInfo.getValue("ownertypehead");
        if (StringUtils.isNotEmpty((String)this.filter_ownertype)) {
            if ("bos_org".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        this.filter_materialFrom = this.filterInfo.getDynamicObjectCollection("mulmaterial");
        this.filter_materialTo = this.filterInfo.getDynamicObject("materialto");
        this.filter_lot = this.filterInfo.getString("lotnumber");
        this.filter_project = this.filterInfo.getDynamicObjectCollection("mulproject");
        this.filter_invType = this.filterInfo.getDynamicObjectCollection("mulinvtype");
        this.filter_invStatus = this.filterInfo.getDynamicObjectCollection("mulinvstatus");
        this.filter_onlyShowDiff = this.filterInfo.getBoolean("onlyshowdiff");
    }

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        try {
            this.init(param);
            DataSet detailDataSet = this.getCostRecordDataSet();
            detailDataSet = detailDataSet.union(this.getCostAdjustDataSet());
            detailDataSet = this.groupDataSet(detailDataSet);
            DataSet balDataSet = this.getBalDateSet();
            balDataSet = this.groupDataSet(balDataSet);
            JoinDataSet joinSet = detailDataSet.fullJoin(balDataSet);
            String groupCols = this.getGroupCols();
            Object[] cols = groupCols.split(",");
            Object[] balCols = new String[cols.length];
            StringBuilder finalGroupCols = new StringBuilder();
            int i = 0;
            for (String string : cols) {
                joinSet = joinSet.on(string, string);
                balCols[i] = string + " as d" + string;
                finalGroupCols.append("case when periodinqty is null then d").append(string).append(" else ").append(string).append(" end as ").append(string).append(",");
                ++i;
            }
            DataSet dataSet = joinSet.select((String[])ArrayUtils.concatAll((Object[])cols, (Object[][])new String[][]{{"periodinqty", "periodinamount", "periodoutqty", "periodoutamount"}}), (String[])ArrayUtils.concatAll((Object[])balCols, (Object[][])new String[][]{{"periodinqty as dperiodinqty", "periodinamount as dperiodinamount", "periodoutqty as dperiodoutqty", "periodoutamount as dperiodoutamount"}})).finish();
            dataSet = dataSet.select(finalGroupCols.append("periodinqty,periodinamount,periodoutqty,periodoutamount,").append("dperiodinqty,dperiodinamount,dperiodoutqty,dperiodoutamount,").append("case when periodinqty is null then 0 else periodinqty end - case when dperiodinqty is null then 0 else dperiodinqty end as diffinqty,").append("case when periodinamount is null then 0 else periodinamount end - case when dperiodinamount is null then 0 else dperiodinamount end as diffinamount,").append("case when periodoutqty is null then 0 else periodoutqty end - case when dperiodoutqty is null then 0 else dperiodoutqty end as diffoutqty,").append("case when periodoutamount is null then 0 else periodoutamount end - case when dperiodoutamount is null then 0  else dperiodoutamount end as diffoutamount").toString());
            if (this.filter_onlyShowDiff) {
                dataSet = dataSet.filter("diffinqty <>0 or diffinamount <> 0 or diffoutqty <>0 or diffoutamount <> 0");
            }
            if (this.hasGroup(this.groupType, "C")) {
                dataSet = dataSet.addField("owner", "ownernumber");
            }
            return dataSet;
        }
        catch (Throwable e) {
            StringBuilder sBuilder = new StringBuilder("cal_stockgatherdetailrpt\uff1a");
            if (e instanceof KDBizException) {
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage());
                }
            } else {
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage()).append("\n");
                }
                StackTraceElement[] errs = e.getStackTrace();
                int i = 0;
                for (StackTraceElement err : errs) {
                    if (i == 256) break;
                    sBuilder.append(err.toString()).append("\n");
                    ++i;
                }
            }
            logger.info(sBuilder.toString());
            throw e;
        }
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        this.createColumnsByGroupType(cols);
        this.createMaterialColumns(cols);
        this.createBaseUnitColumns(cols);
        this.createDecimalColumns(cols);
        this.createHideColumns(cols);
        return cols;
    }

    private DataSet getCostRecordDataSet() {
        QFilter q = this.getCostRecordFilter();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getCostRecordSelects(), (QFilter[])new QFilter[]{q}, null);
        return dataSet;
    }

    private QFilter getCostRecordFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("bookdate", ">=", (Object)this.filter_period.getDate("begindate"));
        q.and("bookdate", "<=", (Object)this.filter_period.getDate("enddate"));
        q.and("issplitcreate", "=", (Object)false);
        q.and("isinitbill", "=", (Object)false);
        q.and("period", "=", (Object)this.filter_period.getLong("id"));
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                q.and("entry.material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("entry.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("entry.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costrecord");
        if (this.filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entry.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entry.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entry.location", "in", set);
        }
        if (!StringUtils.isEmpty((String)this.filter_lot)) {
            q.and("entry.lot", "=", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("entry.project", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("entry.invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("entry.invstatus", "in", set);
        }
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        return q;
    }

    private String getCostRecordSelects() {
        StringBuilder select = new StringBuilder();
        select.append("entry.ownertype as ownertype,entry.owner as owner,storageorgunit,");
        select.append("entry.warehouse.id as warehouse,entry.location.id as location,entry.lot as lot,");
        select.append("entry.warehouse.group.id as warehsgroup,");
        select.append("entry.assist as assist,entry.project.id as project,entry.material.id as material,entry.baseunit.id as baseunit,localcurrency.id as currency,");
        select.append("case when calbilltype = 'IN' then entry.baseqty else 0 end as periodinqty,case when (calbilltype = 'IN' and entry.accounttype <> 'D') then entry.actualcost when (calbilltype = 'IN' and entry.accounttype = 'D') then entry.standardcost else 0 end as periodinamount,");
        select.append("case when calbilltype = 'OUT' then entry.baseqty else 0 end as periodoutqty,case when (calbilltype = 'OUT' and entry.accounttype <> 'D') then entry.actualcost when (calbilltype = 'OUT' and entry.accounttype = 'D') then entry.standardcost else 0 end as periodoutamount,");
        select.append("id as billid");
        return select.toString();
    }

    private DataSet getCostAdjustDataSet() {
        DataSet adjustDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjustbill", (String)this.getCostAdjustSelects(), (QFilter[])new QFilter[]{this.getCostAdjustFilter(true)}, null);
        DataSet stdDiffDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)this.getCostAdjustSelects(), (QFilter[])new QFilter[]{this.getCostAdjustFilter(false)}, null);
        return adjustDataSet.union(stdDiffDataSet);
    }

    private QFilter getCostAdjustFilter(boolean isAdjBill) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("billstatus", "=", (Object)"C");
        q.and("isupdatecost", "=", (Object)"1");
        if (isAdjBill) {
            QFilter notStandf = new QFilter("entryentity.accounttype", "<>", (Object)"D");
            notStandf.and(new QFilter("difftype", "=", (Object)"B"));
            q.and(notStandf);
        } else {
            q.and("createtype", "<>", (Object)"C1");
            q.and("entryentity.accounttype", "=", (Object)"D");
        }
        q.and("period", "=", (Object)this.filter_period.getLong("id"));
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                q.and("entryentity.material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("entryentity.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("entryentity.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costadjustbill");
        if (this.filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.location", "in", set);
        }
        if (!StringUtils.isEmpty((String)this.filter_lot)) {
            q.and("entryentity.lot", "=", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_project) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.project", "in", set);
        }
        if (this.filter_invType != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invType) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invtype", "in", set);
        }
        if (this.filter_invStatus != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_invStatus) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.invstatus", "in", set);
        }
        return q;
    }

    private String getCostAdjustSelects() {
        StringBuilder select = new StringBuilder();
        select.append("entryentity.ownertype as ownertype,entryentity.owner as owner,entryentity.storageorgunit.id as storageorgunit,");
        select.append("entryentity.warehouse.id as warehouse,entryentity.location.id as location,entryentity.lot as lot,");
        select.append("entryentity.warehouse.group.id as warehsgroup,");
        select.append("entryentity.assist as assist,entryentity.project.id as project,");
        select.append("entryentity.material.id as material,entryentity.baseunit.id as baseunit,currency.id as currency,");
        select.append("0 as periodinqty,case when biztype = 'A' then entryentity.adjustamt else 0 end as periodinamount,");
        select.append("0 as periodoutqty,case when biztype = 'B' then entryentity.adjustamt else 0 end as periodoutamount,");
        select.append("id as billid");
        return select.toString();
    }

    private QFilter getBalFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("period", "=", (Object)this.filter_periodNumber);
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_balance");
        if (this.filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("location", "in", set);
        }
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                q.and("material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        if (StringUtils.isNotEmpty((String)this.filter_lot)) {
            q.and("lot", "=", (Object)this.filter_lot);
        }
        if (this.filter_invType != null) {
            HashSet<Long> invTypeSet = new HashSet<Long>();
            for (DynamicObject invType : this.filter_invType) {
                invTypeSet.add(invType.getLong("id"));
            }
            q.and("invtype.id", "in", invTypeSet);
        }
        if (this.filter_invStatus != null) {
            HashSet<Long> invStatusSet = new HashSet<Long>();
            for (DynamicObject invStatus : this.filter_invStatus) {
                invStatusSet.add(invStatus.getLong("id"));
            }
            q.and("invstatus.id", "in", invStatusSet);
        }
        if (this.filter_project != null) {
            HashSet<Long> projectSet = new HashSet<Long>();
            for (DynamicObject project : this.filter_project) {
                projectSet.add(project.getLong("id"));
            }
            q.and("project.id", "in", projectSet);
        }
        return q;
    }

    private DataSet getBalDateSet() {
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            String select = CalBalanceModelHelper.getDimFields((boolean)true) + ",baseunit.id as baseunit,calpolicy.currency.id as currency,warehouse.group.id as warehsgroup,baseqty_in as periodinqty,actualcost_in as periodinamount,baseqty_out as periodoutqty,actualcost_out as periodoutamount";
            QFilter q = this.getBalFilter();
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)select, (QFilter[])new QFilter[]{q}, null);
            if (this.isCalByCostelement) {
                String[] groupSelect = (CalBalanceModelHelper.getDimFields((boolean)false) + ",baseunit,currency,warehsgroup").split(",");
                boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
                dataSet = balCompress ? dataSet.groupBy(groupSelect).sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").finish() : dataSet.groupBy(groupSelect).max("periodinqty").sum("periodinamount").max("periodoutqty").sum("periodoutamount").finish();
            }
            return dataSet;
        }
        QFilter q = this.getBalFilter();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)this.getBalSelectFields(), (QFilter[])new QFilter[]{q}, null);
        return dataSet;
    }

    private DataSet groupDataSet(DataSet dataSet) {
        dataSet = dataSet.groupBy(this.getGroupCols().split(",")).sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").finish();
        return dataSet;
    }

    private String getBalSelectFields() {
        String select = "ownertype,owner as owner,storageorgunit.id as storageorgunit,warehouse.id as warehouse,warehouse.group.id as warehsgroup,location.id as location,material.id as material,project.id as project,lot as lot,assist as assist,baseunit.id as baseunit,calpolicy.currency.id as currency,periodinqty as periodinqty,periodinactualcost as periodinamount,periodissueqty as periodoutqty,periodissueactualcost as periodoutamount";
        return select;
    }

    private String getSelectAliasFields() {
        String select = "owner,storageorgnumber,storageorgname,storageorgid,warehousenumber,warehousename,warehouseid,warehsgroupnumber,warehsgroupname,warehsgroupid,locationnumber,locationname,locationid,materialnumber,materialname,materialid,projectnumber,projectid,lot,assist,baseunitname,baseunitid,currencyid,periodinqty,periodinamount,periodoutqty,periodoutamount";
        return select;
    }

    private String getGroupCols() {
        StringBuilder sql = new StringBuilder();
        sql.append("material,baseunit,currency");
        this.appendCommonGroupCols(sql);
        return sql.toString();
    }

    private void appendCommonGroupCols(StringBuilder sql) {
        if (this.hasGroup(this.groupType, "B")) {
            // empty if block
        }
        if (this.hasGroup(this.groupType, "C")) {
            sql.append(",ownertype,owner");
        }
        if (this.hasGroup(this.groupType, "D")) {
            sql.append(",storageorgunit");
        }
        if (this.hasGroup(this.groupType, "J")) {
            sql.append(",warehsgroup");
        }
        if (this.hasGroup(this.groupType, "E")) {
            if (!this.hasGroup(this.groupType, "D")) {
                sql.append(",storageorgunit");
            }
            sql.append(",warehouse");
        }
        if (this.hasGroup(this.groupType, "F")) {
            if (!this.hasGroup(this.groupType, "D") && !this.hasGroup(this.groupType, "E")) {
                sql.append(",storageorgunit");
            }
            if (!this.hasGroup(this.groupType, "E")) {
                sql.append(",warehouse");
            }
            sql.append(",location");
        }
        if (this.hasGroup(this.groupType, "G")) {
            sql.append(",lot");
        }
        if (this.hasGroup(this.groupType, "H")) {
            sql.append(",assist");
        }
        if (this.hasGroup(this.groupType, "I")) {
            sql.append(",project");
        }
    }

    private boolean hasGroup(String groupType, String value) {
        return groupType.indexOf(value) >= 0;
    }

    private void createColumnsByGroupType(List<AbstractReportColumn> cols) {
        if (this.hasGroup(this.groupType, "B")) {
            this.createCalRangeColumns(cols);
        }
        if (!this.hasGroup(this.groupType, "C")) {
            ReportUtil.hideOwnerColumns(cols);
        }
        if (this.hasGroup(this.groupType, "D")) {
            this.createStorageColumns(cols);
        }
        if (this.hasGroup(this.groupType, "E")) {
            if (!this.hasGroup(this.groupType, "D")) {
                this.createStorageColumns(cols);
            }
            this.createWarehouseColumns(cols);
        }
        if (this.hasGroup(this.groupType, "F")) {
            if (!this.hasGroup(this.groupType, "D")) {
                this.createStorageColumns(cols);
            }
            if (!this.hasGroup(this.groupType, "E")) {
                this.createWarehouseColumns(cols);
            }
            this.createLocationColumns(cols);
        }
        if (this.hasGroup(this.groupType, "G")) {
            this.createLotColumns(cols);
        }
        if (this.hasGroup(this.groupType, "H")) {
            this.createAssistPropertyColumns(cols);
        }
        if (this.hasGroup(this.groupType, "I")) {
            this.createProjectColumns(cols);
        }
        if (this.hasGroup(this.groupType, "J")) {
            this.createWarehsgroupColumns(cols);
        }
    }

    private void createWarehsgroupColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_warehsGroupNum, this.locale_warehsGroupName, "warehsgroup", "bd_warehousegroup");
    }

    private void createProjectColumns(List<AbstractReportColumn> cols) {
        ReportColumn projectNum = ReportColumn.createBaseDataColumn((String)"project", (String)"bd_project");
        projectNum.setCaption(this.locale_projectNum);
        projectNum.setWidth(width);
        projectNum.setDisplayProp("number");
        cols.add((AbstractReportColumn)projectNum);
    }

    private void createGroupTypeColumns(List<AbstractReportColumn> cols, LocaleString numCaption, LocaleString nameCaption, String fieldKey, String entityId) {
        ReportColumn number = ReportColumn.createBaseDataColumn((String)fieldKey, (String)entityId);
        number.setCaption(numCaption);
        number.setWidth(width);
        number.setDisplayProp("number");
        ReportColumn name = ReportColumn.createBaseDataPropColumn((String)(fieldKey + "name"), (String)fieldKey, (String)"name");
        name.setCaption(nameCaption);
        name.setWidth(width);
        cols.add((AbstractReportColumn)number);
        cols.add((AbstractReportColumn)name);
    }

    private void createCalRangeColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_calRangeNum, this.locale_calRangeName, "calrange", "cal_bd_calrange");
    }

    private void createStorageColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_storageOrgNum, this.locale_storageOrgName, "storageorgunit", "bos_org");
    }

    private void createWarehouseColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_warehouseNum, this.locale_warehouseName, "warehouse", "bd_warehouse");
    }

    private void createLocationColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_locationNum, this.locale_locationName, "location", "bd_location");
    }

    private void createMaterialColumns(List<AbstractReportColumn> cols) {
        ReportColumn materialName = ReportColumn.createBaseDataColumn((String)"material", (String)"bd_material");
        materialName.setDisplayProp("name");
        materialName.setCaption(this.locale_materialName);
        materialName.setWidth(width);
        Tips tips = new Tips("text", "");
        tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u8054\u67e5\u6c47\u603b\u8868", (String)"StockGatherDetailRptQueryPlugin_8", (String)"fi-cal-report", (Object[])new Object[0])));
        materialName.setCtlTips(tips);
        materialName.setHyperlink(true);
        ReportColumn materialNumber = ReportColumn.createBaseDataPropColumn((String)"materialnum", (String)"material", (String)"number");
        materialNumber.setCaption(this.locale_materialNum);
        materialNumber.setWidth(width);
        cols.add((AbstractReportColumn)materialNumber);
        cols.add((AbstractReportColumn)materialName);
    }

    private void createBaseUnitColumns(List<AbstractReportColumn> cols) {
        ReportColumn baseUnitName = ReportColumn.createBaseDataColumn((String)"baseunit", (String)"bd_measureunits");
        baseUnitName.setCaption(this.locale_baseUnit);
        baseUnitName.setWidth(width);
        cols.add((AbstractReportColumn)baseUnitName);
    }

    private void createLotColumns(List<AbstractReportColumn> cols) {
        ReportColumn lot = new ReportColumn();
        lot.setCaption(this.locale_lot);
        lot.setWidth(width);
        lot.setFieldKey("lot");
        lot.setFieldType("text");
        cols.add((AbstractReportColumn)lot);
    }

    private void createAssistPropertyColumns(List<AbstractReportColumn> cols) {
        ReportColumn assist = new ReportColumn();
        assist.setCaption(this.locale_assistProperty);
        assist.setWidth(width);
        assist.setFieldKey("assist");
        assist.setFieldType("flex");
        assist.setRefBasedataProp("material");
        assist.setEntityId("bd_auxproperty");
        cols.add((AbstractReportColumn)assist);
    }

    private void createDecimalColumns(List<AbstractReportColumn> cols) {
        this.createDecimalColumn(cols, this.locale_detail, "period");
        this.createDecimalColumn(cols, this.locale_gather, "dperiod");
        this.createDecimalColumn(cols, this.locale_diff, "diff");
    }

    private void createDecimalColumn(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey);
        cols.add((AbstractReportColumn)groupCol);
        ReportColumn inqty = new ReportColumn();
        inqty.setCaption(this.locale_inqty);
        inqty.setWidth(width);
        inqty.setFieldKey(fieldKey + "inqty");
        inqty.setFieldType("qty");
        inqty.setMeasureUnitField("baseunit");
        ReportColumn inamount = new ReportColumn();
        inamount.setCaption(this.locale_inamount);
        inamount.setWidth(width);
        inamount.setFieldKey(fieldKey + "inamount");
        inamount.setFieldType("amount");
        inamount.setCurrencyField("currency");
        groupCol.getChildren().add(inqty);
        groupCol.getChildren().add(inamount);
        ReportColumn outqty = new ReportColumn();
        outqty.setCaption(this.locale_outqty);
        outqty.setWidth(width);
        outqty.setFieldKey(fieldKey + "outqty");
        outqty.setFieldType("qty");
        outqty.setMeasureUnitField("baseunit");
        ReportColumn outamount = new ReportColumn();
        outamount.setCaption(this.locale_outamount);
        outamount.setWidth(width);
        outamount.setFieldKey(fieldKey + "outamount");
        outamount.setFieldType("amount");
        outamount.setCurrencyField("currency");
        groupCol.getChildren().add(outqty);
        groupCol.getChildren().add(outamount);
    }

    private void createHideColumns(List<AbstractReportColumn> cols) {
        ReportColumn currencyId = new ReportColumn();
        currencyId.setCaption(this.locale_currency);
        currencyId.setWidth(width);
        currencyId.setFieldKey("currency");
        currencyId.setFieldType("currency");
        currencyId.setEntityId("bd_currency");
        currencyId.setHide(true);
        cols.add((AbstractReportColumn)currencyId);
    }
}

