/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceUncompressHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.MaterialCategoryHelper;
import kd.fi.cal.common.util.ReportUtil;

public class StockGatherRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(StockGatherRptQueryPlugin.class);
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private DynamicObject filter_startPeriod;
    private DynamicObject filter_endPeriod;
    private int filter_startPeriodNumber;
    private int filter_endPeriodNumber;
    private boolean isGroupByPeriod;
    private boolean noShowZeroInOut;
    private boolean showAllZero;
    private String groupType;
    private List<Integer> periodNumberList = new ArrayList<Integer>();
    private boolean onlyShowSumRow;
    private boolean topSumRow;
    private boolean showdetail;
    private long currencyId;
    private String filter_ownertype;
    private DynamicObjectCollection filter_ownerFrom;
    private DynamicObjectCollection filter_mulcalrange;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private DynamicObjectCollection filter_materialFrom;
    private DynamicObject filter_materialTo;
    private String[] filter_lot;
    private DynamicObjectCollection filter_project;
    private DynamicObjectCollection filter_trackNumber;
    private DynamicObjectCollection filter_invType;
    private DynamicObjectCollection filter_invStatus;
    private String filter_mulaccounttype;
    private DynamicObjectCollection filter_mulMaterialCategory;
    private MaterialCategoryHelper materialCategoryHelper = null;
    private String qtyShowCondition;
    private String amountShowCondition;
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private DynamicObject materialgroupstandard;
    private boolean notShowMaterialGroup;
    private boolean hasMaterialGroup;
    private int hierarchylevel;
    private List<String> fieldList = new ArrayList<String>(16);
    private String mgIdField = "mgid";
    private static final List<String> headFieldList = Arrays.asList("materialnumber", "material", "materialmodel", "baseunit");
    private static final String[] otherSelects = new String[]{"warehouse.group.id", "baseunit.precision", "calpolicy.currency", "material.number", "material.modelnum", "stocktype"};
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private LocaleString locale_calRangeNum = new LocaleString(this.getLocale_calRangeNum());
    private LocaleString locale_calRangeName = new LocaleString(this.getLocale_calRangeName());
    private LocaleString locale_ownerNum = new LocaleString(this.getLocale_ownerNum());
    private LocaleString locale_ownerName = new LocaleString(this.getLocale_ownerName());
    private LocaleString locale_storageOrgNum = new LocaleString(this.getLocale_storageOrgNum());
    private LocaleString locale_storageOrgName = new LocaleString(this.getLocale_storageOrgName());
    private LocaleString locale_warehouseNum = new LocaleString(this.getLocale_warehouseNum());
    private LocaleString locale_warehouseName = new LocaleString(this.getLocale_warehouseName());
    private LocaleString locale_warehouseGroupNum = new LocaleString(this.getLocale_WarehouseGroupNum());
    private LocaleString locale_warehouseGroupName = new LocaleString(this.getLocale_WarehouseGroupName());
    private LocaleString locale_MaterialCategoryNum = new LocaleString(this.getLocale_MaterialCategoryNum());
    private LocaleString locale_MaterialCategoryName = new LocaleString(this.getLocale_MaterialCategoryName());
    private LocaleString locale_locationNum = new LocaleString(this.getLocale_locationNum());
    private LocaleString locale_locationName = new LocaleString(this.getLocale_locationName());
    private LocaleString locale_lot = new LocaleString(this.getLocale_lot());
    private LocaleString locale_tracknum = new LocaleString(this.getLocale_tracknum());
    private LocaleString locale_assistProperty = new LocaleString(this.getLocale_assistProperty());
    private LocaleString locale_projectNum = new LocaleString(this.getLocale_projectNum());
    private LocaleString locale_materialNum = new LocaleString(this.getLocale_materialNum());
    private LocaleString locale_materialName = new LocaleString(this.getLocale_materialName());
    private LocaleString locale_materialGroup = new LocaleString(this.getLocale_materialGroup());
    private LocaleString locale_costelementNum = new LocaleString(this.getLocale_costelementNum());
    private LocaleString locale_costelementName = new LocaleString(this.getLocale_costelementName());
    private LocaleString locale_costsubelementNum = new LocaleString(this.getLocale_costsubelementNum());
    private LocaleString locale_costsubelementName = new LocaleString(this.getLocale_costsubelementName());
    private LocaleString locale_model = new LocaleString(this.getLocale_model());
    private LocaleString locale_baseUnit = new LocaleString(this.getLocale_baseUnit());
    private LocaleString locale_periodBegin = new LocaleString(this.getLocale_periodBegin());
    private LocaleString locale_periodIn = new LocaleString(this.getLocale_periodIn());
    private LocaleString locale_periodOut = new LocaleString(this.getLocale_periodOut());
    private LocaleString locale_periodEnd = new LocaleString(this.getLocale_periodEnd());
    private LocaleString locale_qty = new LocaleString(this.getLocale_qty());
    private LocaleString locale_price = new LocaleString(this.getLocale_price());
    private LocaleString locale_amount = new LocaleString(this.getLocale_amount());
    private LocaleString locale_currency = new LocaleString(this.getLocale_currency());
    private static final LocaleString width = new LocaleString("100px");
    private static final int BATCH_SIZE = 100000;

    private String getLocale_calRangeNum() {
        return ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u7f16\u7801", (String)"StockGatherRptQueryPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_calRangeName() {
        return ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u540d\u79f0", (String)"StockGatherRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_ownerNum() {
        return ResManager.loadKDString((String)"\u8d27\u4e3b\u7f16\u7801", (String)"StockGatherRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_ownerName() {
        return ResManager.loadKDString((String)"\u8d27\u4e3b\u540d\u79f0", (String)"StockGatherRptQueryPlugin_3", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_storageOrgNum() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801", (String)"StockGatherRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_storageOrgName() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u540d\u79f0", (String)"StockGatherRptQueryPlugin_5", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_warehouseNum() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u7f16\u7801", (String)"StockGatherRptQueryPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_warehouseName() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u540d\u79f0", (String)"StockGatherRptQueryPlugin_7", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_WarehouseGroupNum() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u5206\u7ec4\u7f16\u7801", (String)"StockGatherRptQueryPlugin_41", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_WarehouseGroupName() {
        return ResManager.loadKDString((String)"\u4ed3\u5e93\u5206\u7ec4\u540d\u79f0", (String)"StockGatherRptQueryPlugin_42", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_MaterialCategoryNum() {
        return ResManager.loadKDString((String)"\u5b58\u8d27\u7c7b\u522b\u7f16\u7801", (String)"StockGatherRptQueryPlugin_55", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_MaterialCategoryName() {
        return ResManager.loadKDString((String)"\u5b58\u8d27\u7c7b\u522b\u540d\u79f0", (String)"StockGatherRptQueryPlugin_56", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_locationNum() {
        return ResManager.loadKDString((String)"\u4ed3\u4f4d\u7f16\u7801", (String)"StockGatherRptQueryPlugin_8", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_locationName() {
        return ResManager.loadKDString((String)"\u4ed3\u4f4d\u540d\u79f0", (String)"StockGatherRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_lot() {
        return ResManager.loadKDString((String)"\u6279\u53f7", (String)"StockGatherRptQueryPlugin_10", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_tracknum() {
        return ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7", (String)"StockGatherRptQueryPlugin_61", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_assistProperty() {
        return ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"StockGatherRptQueryPlugin_11", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_projectNum() {
        return ResManager.loadKDString((String)"\u9879\u76ee\u53f7", (String)"StockGatherRptQueryPlugin_12", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialNum() {
        return ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"StockGatherRptQueryPlugin_13", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialName() {
        return ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"StockGatherRptQueryPlugin_14", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_materialGroup() {
        return ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b", (String)"StockGatherRptQueryPlugin_43", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costelementNum() {
        return ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u7f16\u7801", (String)"StockGatherRptQueryPlugin_15", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costelementName() {
        return ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u540d\u79f0", (String)"StockGatherRptQueryPlugin_16", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costsubelementNum() {
        return ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801", (String)"StockGatherRptQueryPlugin_17", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_costsubelementName() {
        return ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u540d\u79f0", (String)"StockGatherRptQueryPlugin_18", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_model() {
        return ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7", (String)"StockGatherRptQueryPlugin_19", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_baseUnit() {
        return ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"StockGatherRptQueryPlugin_20", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodBegin() {
        return ResManager.loadKDString((String)"\u671f\u521d\u7ed3\u5b58", (String)"StockGatherRptQueryPlugin_21", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodIn() {
        return ResManager.loadKDString((String)"\u672c\u671f\u6536\u5165", (String)"StockGatherRptQueryPlugin_22", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodOut() {
        return ResManager.loadKDString((String)"\u672c\u671f\u53d1\u51fa", (String)"StockGatherRptQueryPlugin_23", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_periodEnd() {
        return ResManager.loadKDString((String)"\u671f\u672b\u7ed3\u5b58", (String)"StockGatherRptQueryPlugin_24", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_qty() {
        return ResManager.loadKDString((String)"\u6570\u91cf", (String)"StockGatherRptQueryPlugin_25", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_price() {
        return ResManager.loadKDString((String)"\u5355\u4ef7", (String)"StockGatherRptQueryPlugin_26", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_amount() {
        return ResManager.loadKDString((String)"\u91d1\u989d", (String)"StockGatherRptQueryPlugin_27", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private String getLocale_currency() {
        return ResManager.loadKDString((String)"\u5e01\u79cd", (String)"StockGatherRptQueryPlugin_28", (String)"fi-cal-report", (Object[])new Object[0]);
    }

    private void init(ReportQueryParam param) {
        this.filterInfo = param.getFilter();
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.filter_startPeriod = this.filterInfo.getDynamicObject("startperiod");
        this.filter_endPeriod = this.filterInfo.getDynamicObject("endperiod");
        this.filter_startPeriodNumber = this.filter_startPeriod.getInt("periodyear") * 100 + this.filter_startPeriod.getInt("periodnumber");
        this.filter_endPeriodNumber = this.filter_endPeriod.getInt("periodyear") * 100 + this.filter_endPeriod.getInt("periodnumber");
        this.isGroupByPeriod = this.filterInfo.getBoolean("groupbyperiod");
        this.noShowZeroInOut = this.filterInfo.getBoolean("noshowzeroinout");
        this.showAllZero = this.filterInfo.getBoolean("showallzero");
        this.groupType = this.filterInfo.getString("mulgrouptype");
        this.showdetail = this.filterInfo.getBoolean("showdetail");
        if (this.groupType == null) {
            this.groupType = "A";
        }
        this.hasMaterialGroup = this.hasGroup(this.groupType, "K");
        this.onlyShowSumRow = this.filterInfo.getBoolean("onlyshowsumrow");
        this.topSumRow = this.filterInfo.getBoolean("topsumrow");
        DynamicObject costAccountInfo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", this.filter_costAccount.get("id"))});
        QFilter q = new QFilter("periodtype", "=", costAccountInfo.get("calpolicy.periodtype"));
        q.and(new QFilter("isadjustperiod", "=", (Object)false));
        q.and("id", ">=", (Object)this.filter_startPeriod.getLong("id"));
        q.and("id", "<=", (Object)this.filter_endPeriod.getLong("id"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{q}, (String)"periodyear asc,periodnumber asc");
        for (DynamicObject info : coll) {
            int periodNumber = info.getInt("periodyear") * 100 + info.getInt("periodnumber");
            this.periodNumberList.add(periodNumber);
        }
        this.currencyId = this.filterInfo.getDynamicObject("localcurrency").getLong("id");
        this.filter_ownertype = (String)this.filterInfo.getValue("ownertypehead");
        if (StringUtils.isNotEmpty((String)this.filter_ownertype)) {
            if ("bos_org".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulowner");
            } else if ("bd_supplier".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulsupplierownerfrom");
            } else if ("bd_customer".equals(this.filter_ownertype)) {
                this.filter_ownerFrom = this.filterInfo.getDynamicObjectCollection("mulcustomerownerfrom");
            }
        }
        this.filter_mulcalrange = this.filterInfo.getDynamicObjectCollection("mulcalrange");
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        this.filter_materialFrom = this.filterInfo.getDynamicObjectCollection("mulmaterial");
        this.filter_materialTo = this.filterInfo.getDynamicObject("materialto");
        if (StringUtils.isNotEmpty((String)this.filterInfo.getString("lotnumber"))) {
            this.filter_lot = this.filterInfo.getString("lotnumber").split(";");
        }
        this.filter_project = this.filterInfo.getDynamicObjectCollection("mulproject");
        this.filter_trackNumber = this.filterInfo.getDynamicObjectCollection("multracknum");
        this.filter_invType = this.filterInfo.getDynamicObjectCollection("mulinvtype");
        this.filter_invStatus = this.filterInfo.getDynamicObjectCollection("mulinvstatus");
        this.qtyShowCondition = this.filterInfo.getString("qtyshowcondition");
        this.amountShowCondition = this.filterInfo.getString("amountshowcondition");
        this.filter_mulaccounttype = this.filterInfo.getString("mulaccounttype");
        this.materialgroupstandard = this.filterInfo.getDynamicObject("materialgroupstandard");
        DynamicObjectCollection filter_materialgroupfrom = this.filterInfo.getDynamicObjectCollection("mulmaterialgroup");
        this.hierarchylevel = this.filterInfo.getInt("level");
        this.notShowMaterialGroup = this.materialgroupstandard == null && (filter_materialgroupfrom == null || filter_materialgroupfrom.size() < 1) && !this.hasMaterialGroup;
        this.filter_mulMaterialCategory = this.filterInfo.getDynamicObjectCollection("mulmatcategory");
    }

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        try {
            this.init(param);
            List headFilters = param.getFilter().getHeadFilters();
            List<QFilter> balanceHeadFilters = this.getBalanceHeadFilters(headFilters);
            this.setProgress(5);
            DataSet dataSet = null;
            for (int periodNumber : this.periodNumberList) {
                if (dataSet == null) {
                    if (this.isNewBalance) {
                        dataSet = this.getNewDataSet(periodNumber, balanceHeadFilters);
                        continue;
                    }
                    dataSet = this.getDataSet(periodNumber, balanceHeadFilters);
                    continue;
                }
                if (this.isNewBalance) {
                    dataSet = dataSet.union(this.getNewDataSet(periodNumber, balanceHeadFilters));
                    continue;
                }
                dataSet = dataSet.union(this.getDataSet(periodNumber, balanceHeadFilters));
            }
            if (dataSet == null) {
                return dataSet;
            }
            this.setProgress(20);
            this.setProgress(30);
            dataSet = this.groupDataSet(dataSet);
            this.setProgress(40);
            dataSet = this.groupDataSetByPeriod(dataSet);
            this.setProgress(50);
            dataSet = this.noShowZeroInOut(dataSet);
            this.setProgress(60);
            dataSet = this.filterByQtyCondition(dataSet);
            this.setProgress(70);
            dataSet = this.filterByAmountCondition(dataSet);
            this.setProgress(80);
            dataSet = this.filterByAllZeroCondition(dataSet);
            this.setProgress(85);
            if (dataSet == null) {
                return dataSet;
            }
            if (this.hasMaterialGroup) {
                dataSet = this.addMaterialGroupInfo(dataSet);
                dataSet = this.addSumAndTotalDataSet(dataSet, balanceHeadFilters);
            } else {
                dataSet = this.unionGroupDataSet(dataSet, balanceHeadFilters);
            }
            this.setProgress(90);
            dataSet = this.onlyShowSumRow(dataSet);
            if (this.hasGroup(this.groupType, "C")) {
                dataSet = dataSet.addField("owner", "ownernumber");
            }
            this.setProgress(95);
            return dataSet;
        }
        catch (Throwable e) {
            StringBuilder sBuilder = new StringBuilder("cal_stockgatherrpt\uff1a");
            if (e instanceof KDBizException) {
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage());
                }
            } else {
                if (e.getMessage() != null) {
                    sBuilder.append(e.getMessage()).append("\n");
                }
                StackTraceElement[] errs = e.getStackTrace();
                int i = 0;
                for (StackTraceElement err : errs) {
                    if (i == 256) break;
                    sBuilder.append(err.toString()).append("\n");
                    ++i;
                }
            }
            logger.info(sBuilder.toString());
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    private DataSet addMaterialGroupInfo(DataSet dataSet) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getMaterialGroupSelects(int i, int level) {
        int j;
        StringBuilder select = new StringBuilder();
        for (j = 1; j <= i; ++j) {
            select.append(",").append(this.mgIdField).append(j);
        }
        for (j = i + 1; j <= level; ++j) {
            select.append(",").append("0L as ").append(this.mgIdField).append(j);
        }
        return select.toString();
    }

    private DataSet addSumAndTotalDataSet(DataSet dataSet, List<QFilter> balanceHeadFilters) {
        StringBuilder materialGroupFieldZero = new StringBuilder(",0 as mgid1");
        for (int i = 1; i <= this.hierarchylevel; ++i) {
            if (i == 1) continue;
            materialGroupFieldZero.append(",0 as mgid");
            materialGroupFieldZero.append(i);
        }
        String mgZeroStr = materialGroupFieldZero.toString();
        StringBuilder orderStr = new StringBuilder("year,month,periodnumber");
        if (this.topSumRow) {
            orderStr.append(",ordercol desc,ordercol1 desc");
        } else {
            orderStr.append(",ordercol,ordercol1");
        }
        if (this.isGroupByPeriod) {
            DataSet allTotalDataSet = dataSet.copy();
            allTotalDataSet = allTotalDataSet.where("material <> 0").groupBy(this.getGroupCols("3").split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").max("qtyprecision").maxP("qtyprecision", "baseunit").sum("periodendqty").sum("periodendamount").finish();
            allTotalDataSet = allTotalDataSet.select(this.getFinalSelectFields("3") + mgZeroStr);
            allTotalDataSet = allTotalDataSet.select(dataSet.getRowMeta().getFieldNames());
            return dataSet.addField("0", "ordercol").addField("0", "ordercol1").union(allTotalDataSet.addField("1", "ordercol").addField("2", "ordercol1")).orderBy(orderStr.toString().split(","));
        }
        DataSet periodTotalDataSet = dataSet.copy();
        periodTotalDataSet = periodTotalDataSet.where("material <> 0").groupBy(this.getGroupCols("1").split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").sum("periodendqty").sum("periodendamount").max("qtyprecision").maxP("qtyprecision", "baseunit").finish();
        periodTotalDataSet = periodTotalDataSet.select(this.getFinalSelectFields("1") + mgZeroStr);
        DataSet yearTotalDataSet = periodTotalDataSet.copy();
        yearTotalDataSet = yearTotalDataSet.groupBy(this.getGroupCols("2").split(",")).sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").max("qtyprecision").maxP("qtyprecision", "baseunit").finish();
        DataSet beginDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_initbill", (String)"id,period.periodyear as year,entryentity.yearinqty as yearinqty,entryentity.yearincost as yearinactualcost,entryentity.yearissueqty as yearissueqty,entryentity.yearissuecost as yearissueactualcost", (QFilter[])new QFilter[]{this.getInitBillFilter()}, null);
        beginDataSet = beginDataSet.groupBy(new String[]{"year"}).sum("yearinqty").sum("yearinactualcost").sum("yearissueqty").sum("yearissueactualcost").finish();
        yearTotalDataSet = yearTotalDataSet.join(beginDataSet, JoinType.LEFT).on("year", "year").select(new String[]{"costaccountid", "calorgid", "year", "0 as periodbeginqty", "0 as periodbeginamount", "periodinqty+yearinqty as periodinqty", "periodinamount+yearinactualcost as periodinamount", "periodoutqty+yearissueqty as periodoutqty", "periodoutamount+yearissueactualcost as periodoutamount", "0 as periodendqty", "0 as periodendamount", "qtyprecision", "baseunit"}).finish();
        yearTotalDataSet = yearTotalDataSet.select(this.getFinalSelectFields("2") + mgZeroStr);
        DataSet allTotalDataSet = periodTotalDataSet.copy();
        allTotalDataSet = allTotalDataSet.groupBy(this.getGroupCols("3").split(",")).minP("periodnumber", "periodbeginqty").minP("periodnumber", "periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").maxP("periodnumber", "periodendqty").maxP("periodnumber", "periodendamount").max("qtyprecision").maxP("qtyprecision", "baseunit").finish().select(new String[]{"costaccountid", "calorgid", "periodbeginqty", "periodbeginamount", "periodendqty+periodoutqty-periodbeginqty as periodinqty", "periodendamount+periodoutamount-periodbeginamount as periodinamount", "periodoutqty", "periodoutamount", "periodendqty", "periodendamount", "qtyprecision", "baseunit"});
        allTotalDataSet = allTotalDataSet.select(this.getFinalSelectFields("3") + mgZeroStr);
        periodTotalDataSet = periodTotalDataSet.select(dataSet.getRowMeta().getFieldNames());
        yearTotalDataSet = yearTotalDataSet.select(dataSet.getRowMeta().getFieldNames());
        allTotalDataSet = allTotalDataSet.select(dataSet.getRowMeta().getFieldNames());
        return dataSet.addField("0", "ordercol").addField("1", "ordercol1").union(periodTotalDataSet.addField("1", "ordercol").addField("2", "ordercol1")).union(yearTotalDataSet.addField("2", "ordercol").addField("3", "ordercol1")).union(allTotalDataSet.addField("3", "ordercol").addField("4", "ordercol1")).orderBy(orderStr.toString().split(","));
    }

    private DataSet addBaseMaterialGroup(DataSet dataSet, DataSet materialGroupDs) {
        if (materialGroupDs == null) {
            return dataSet.addField("0", "group");
        }
        return dataSet.join(materialGroupDs).on("material", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"group"}).finish();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        this.createColumnsByGroupType(cols);
        if (this.hasMaterialGroup) {
            this.createMaterialGroupColumns(cols);
        }
        this.createMaterialColumns(cols);
        this.createBaseUnitColumns(cols);
        this.createDecimalColumns(cols);
        this.createHideColumns(cols);
        return cols;
    }

    private void createMaterialGroupColumns(List<AbstractReportColumn> cols) {
        for (int i = 1; i <= this.hierarchylevel; ++i) {
            ReportColumn materialGroupId = new ReportColumn();
            LocaleString locale_materialGroupNum = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\u7ea7\u7269\u6599\u5206\u7c7b\u7f16\u7801", (String)"StockGatherRptQueryPlugin_47", (String)"fi-cal-report", (Object[])new Object[0]), i));
            materialGroupId.setCaption(locale_materialGroupNum);
            materialGroupId.setWidth(width);
            materialGroupId.setFieldKey(this.mgIdField + i);
            materialGroupId.setFieldType("basedata");
            materialGroupId.setEntityId("bd_materialgroup");
            materialGroupId.setDisplayProp("number");
            ReportColumn materialGroupName = ReportColumn.createBaseDataPropColumn((String)("mgname" + i), (String)(this.mgIdField + i), (String)"name");
            LocaleString locale_materialGroupName = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\u7ea7\u7269\u6599\u5206\u7c7b\u540d\u79f0", (String)"StockGatherRptQueryPlugin_51", (String)"fi-cal-report", (Object[])new Object[0]), i));
            materialGroupName.setCaption(locale_materialGroupName);
            materialGroupName.setWidth(width);
            cols.add((AbstractReportColumn)materialGroupId);
            cols.add((AbstractReportColumn)materialGroupName);
        }
    }

    private DataSet filterByAllZeroCondition(DataSet calDataSet) {
        if (!this.showAllZero) {
            calDataSet = calDataSet.filter("periodbeginqty <> 0 or periodbeginamount <> 0 or periodinqty <> 0 or periodinamount <> 0 or periodoutqty <> 0 or periodoutamount <> 0  or periodendqty <> 0 or periodendamount <> 0");
        }
        return calDataSet;
    }

    private QFilter getFilter(List<QFilter> balanceHeadFilters) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_balance");
        if (this.filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("location", "in", set);
        }
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                q.and("material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        if (this.filter_mulMaterialCategory != null) {
            HashSet<Long> materialCategorySet = new HashSet<Long>();
            for (DynamicObject materialCategory : this.filter_mulMaterialCategory) {
                materialCategorySet.add(materialCategory.getLong("id"));
            }
            q.and("stocktype", "in", materialCategorySet);
        }
        if (this.filter_lot != null) {
            q.and("lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_invType != null) {
            HashSet<Long> invTypeSet = new HashSet<Long>();
            for (DynamicObject invType : this.filter_invType) {
                invTypeSet.add(invType.getLong("id"));
            }
            q.and("invtype.id", "in", invTypeSet);
        }
        if (this.filter_invStatus != null) {
            HashSet<Long> invStatusSet = new HashSet<Long>();
            for (DynamicObject invStatus : this.filter_invStatus) {
                invStatusSet.add(invStatus.getLong("id"));
            }
            q.and("invstatus.id", "in", invStatusSet);
        }
        if (this.filter_project != null) {
            HashSet<Long> projectSet = new HashSet<Long>();
            for (DynamicObject project : this.filter_project) {
                projectSet.add(project.getLong("id"));
            }
            q.and("project.id", "in", projectSet);
        }
        if (this.filter_trackNumber != null) {
            HashSet<Long> trackNumberSet = new HashSet<Long>();
            for (DynamicObject trackNumber : this.filter_trackNumber) {
                trackNumberSet.add(trackNumber.getLong("id"));
            }
            q.and("tracknumber.id", "in", trackNumberSet);
        }
        if (this.filter_mulcalrange != null) {
            HashSet<Long> calrangeIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : this.filter_mulcalrange) {
                calrangeIds.add(dynamicObject.getLong("id"));
            }
            q.and("calrange", "in", calrangeIds);
        }
        if (StringUtils.isNotEmpty((String)this.filter_mulaccounttype)) {
            HashSet<String> accounttypes = new HashSet<String>(16);
            for (String s : this.filter_mulaccounttype.split(",")) {
                if (!StringUtils.isNotEmpty((String)s)) continue;
                accounttypes.add(s);
            }
            if (!accounttypes.isEmpty()) {
                q.and("accounttype", "in", accounttypes);
            }
        }
        for (QFilter balanceHeadFilter : balanceHeadFilters) {
            q.and(balanceHeadFilter);
        }
        return q;
    }

    private QFilter getInitBillFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        ReportUtil.getOwnerFilter((QFilter)q, (String)this.filter_ownertype, (DynamicObjectCollection)this.filter_ownerFrom, (String)"cal_costadjustbill");
        if (this.filter_storageOrg != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.location", "in", set);
        }
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                q.and("entryentity.material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("entryentity.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("entryentity.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        if (this.filter_mulMaterialCategory != null) {
            HashSet<Long> materialCategorySet = new HashSet<Long>();
            for (DynamicObject materialCategory : this.filter_mulMaterialCategory) {
                materialCategorySet.add(materialCategory.getLong("id"));
            }
            q.and("entryentity.stocktype", "in", materialCategorySet);
        }
        if (this.filter_lot != null) {
            q.and("entryentity.lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_invType != null) {
            HashSet<Long> invTypeSet = new HashSet<Long>();
            for (DynamicObject invType : this.filter_invType) {
                invTypeSet.add(invType.getLong("id"));
            }
            q.and("entryentity.invtype.id", "in", invTypeSet);
        }
        if (this.filter_invStatus != null) {
            HashSet<Long> invStatusSet = new HashSet<Long>();
            for (DynamicObject invStatus : this.filter_invStatus) {
                invStatusSet.add(invStatus.getLong("id"));
            }
            q.and("entryentity.invstatus.id", "in", invStatusSet);
        }
        if (this.filter_project != null) {
            HashSet<Long> projectSet = new HashSet<Long>();
            for (DynamicObject project : this.filter_project) {
                projectSet.add(project.getLong("id"));
            }
            q.and("entryentity.project.id", "in", projectSet);
        }
        if (this.filter_trackNumber != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_trackNumber) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.tracknumber", "in", set);
        }
        if (this.filter_mulcalrange != null) {
            HashSet<Long> calrangeIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : this.filter_mulcalrange) {
                calrangeIds.add(dynamicObject.getLong("id"));
            }
            q.and("entryentity.calrange", "in", calrangeIds);
        }
        if (StringUtils.isNotEmpty((String)this.filter_mulaccounttype)) {
            HashSet<String> accounttypes = new HashSet<String>(16);
            for (String s : this.filter_mulaccounttype.split(",")) {
                if (!StringUtils.isNotEmpty((String)s)) continue;
                accounttypes.add(s);
            }
            if (!accounttypes.isEmpty()) {
                q.and("entryentity.accounttype", "in", accounttypes);
            }
        }
        return q;
    }

    private QFilter getBeginFilter(int periodNumber) {
        QFilter q = new QFilter("period", "<", (Object)periodNumber);
        q.and(new QFilter("endperiod", ">=", (Object)periodNumber));
        return q;
    }

    private QFilter getEndFilter(int periodNumber) {
        QFilter q = new QFilter("period", "<=", (Object)periodNumber);
        q.and(new QFilter("endperiod", ">", (Object)periodNumber));
        return q;
    }

    private QFilter getInOutFilter(int periodNumber) {
        QFilter q = new QFilter("period", "=", (Object)periodNumber);
        return q;
    }

    private QFilter getInitFilter() {
        return new QFilter("period", "=", (Object)0);
    }

    private DataSet getDataSet(int periodNumber, List<QFilter> balanceHeadFilters) {
        DataSet materialGroupDs = ReportUtil.getClassifiedMaterialDataSet((FilterInfo)this.filterInfo, (boolean)this.notShowMaterialGroup, (DynamicObject)this.materialgroupstandard);
        QFilter q = this.getFilter(balanceHeadFilters);
        QFilter beginQ = this.getBeginFilter(periodNumber);
        QFilter endQ = this.getEndFilter(periodNumber);
        QFilter InOutQ = this.getInOutFilter(periodNumber);
        DataSet beginDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)this.getBalSelectFields(periodNumber, "0"), (QFilter[])new QFilter[]{q, beginQ}, null);
        DataSet inOutDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)this.getBalSelectFields(periodNumber, "1"), (QFilter[])new QFilter[]{q, InOutQ}, null);
        DataSet endDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)this.getBalSelectFields(periodNumber, "2"), (QFilter[])new QFilter[]{q, endQ}, null);
        if (this.showdetail) {
            DataSet tempBeginDataSet = beginDataSet.copy();
            DataSet detailBeginDataSet = this.getAdjDetailByBatch(tempBeginDataSet);
            beginDataSet = beginDataSet.join(detailBeginDataSet, JoinType.LEFT).on("id", "balid").select(this.getBalAllSelectFields().split(","), this.getBalDetailAllSelectFields("0").split(",")).finish();
            DataSet tempInOutDataSet = inOutDataSet.copy();
            DataSet detailInOutDataSet = this.getAdjDetailByBatch(tempInOutDataSet);
            inOutDataSet = inOutDataSet.join(detailInOutDataSet, JoinType.LEFT).on("id", "balid").select(this.getBalAllSelectFields().split(","), this.getBalDetailAllSelectFields("1").split(",")).finish();
            DataSet tempEndDataSet = endDataSet.copy();
            DataSet detailEndDataSet = this.getAdjDetailByBatch(tempEndDataSet);
            endDataSet = endDataSet.join(detailEndDataSet, JoinType.LEFT).on("id", "balid").select(this.getBalAllSelectFields().split(","), this.getBalDetailAllSelectFields("2").split(",")).finish();
        }
        DataSet unionDataSet = beginDataSet.union(inOutDataSet).union(endDataSet);
        unionDataSet = this.addBaseMaterialGroup(unionDataSet, materialGroupDs);
        unionDataSet = unionDataSet.groupBy(this.getGroupCols().split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").sum("periodendqty").sum("periodendamount").finish();
        return unionDataSet;
    }

    private DataSet getNewDataSet(int periodNumber, List<QFilter> balanceHeadFilters) {
        DataSet materialGroupDs = ReportUtil.getClassifiedMaterialDataSet((FilterInfo)this.filterInfo, (boolean)this.notShowMaterialGroup, (DynamicObject)this.materialgroupstandard);
        QFilter q = this.getFilter(balanceHeadFilters);
        QFilter beginQ = this.getBeginFilter(periodNumber);
        QFilter endQ = this.getEndFilter(periodNumber);
        QFilter InOutQ = this.getInOutFilter(periodNumber);
        String select = CalBalanceModelHelper.getDimFields((boolean)true) + ",id," + periodNumber + " as periodnumber,endperiod as endperiod," + periodNumber / 100 + " as year," + periodNumber % 100 + " as month,warehouse.group.id as warehsgroup,stocktype as materialcategory,baseunit,baseunit.precision as qtyprecision,calpolicy.currency as currency,material.number as materialnumber,material.modelnum as materialmodel,calorg as calorgid,costaccount as costaccountid,";
        String beginSelect = "baseqty_bal as periodbeginqty,actualcost_bal as periodbeginamount,0.0 as periodinqty,0.0 as periodinamount,0.0 as periodoutqty,0.0 as periodoutamount,0.0 as periodendqty,0.0 as periodendamount";
        String inOutSelect = "0.0 as periodbeginqty,0.0 as periodbeginamount,baseqty_in as periodinqty,actualcost_in as periodinamount,baseqty_out as periodoutqty,actualcost_out as periodoutamount,0.0 as periodendqty,0.0 as periodendamount";
        String endSelect = "0.0 as periodbeginqty,0.0 as periodbeginamount,0.0 as periodinqty,0.0 as periodinamount,0.0 as periodoutqty,0.0 as periodoutamount,baseqty_bal as periodendqty,actualcost_bal as periodendamount";
        String[] groupSelect = (CalBalanceModelHelper.getDimFields((boolean)false) + ",periodnumber,endperiod,year,month,warehsgroup,materialcategory,baseunit,qtyprecision,currency,materialnumber,materialmodel,calorgid,costaccountid").split(",");
        DataSet beginDataSet = BalanceUncompressHelper.getBalancDataSetDetail((boolean)false, (boolean)false, Arrays.asList(otherSelects), Collections.singletonList(beginQ.and(q))).select(select + beginSelect);
        beginDataSet = beginDataSet.groupBy(groupSelect).max("periodbeginqty").sum("periodbeginamount").max("periodinqty").sum("periodinamount").max("periodoutqty").sum("periodoutamount").max("periodendqty").sum("periodendamount").finish();
        DataSet inOutDataSet = BalanceUncompressHelper.getBalancDataSetDetail((boolean)false, (boolean)false, Arrays.asList(otherSelects), Collections.singletonList(InOutQ.and(q))).select(select + inOutSelect);
        inOutDataSet = inOutDataSet.groupBy(groupSelect).max("periodbeginqty").sum("periodbeginamount").max("periodinqty").sum("periodinamount").max("periodoutqty").sum("periodoutamount").max("periodendqty").sum("periodendamount").finish();
        DataSet endDataSet = BalanceUncompressHelper.getBalancDataSetDetail((boolean)false, (boolean)false, Arrays.asList(otherSelects), Collections.singletonList(endQ.and(q))).select(select + endSelect);
        endDataSet = endDataSet.groupBy(groupSelect).max("periodbeginqty").sum("periodbeginamount").max("periodinqty").sum("periodinamount").max("periodoutqty").sum("periodoutamount").max("periodendqty").sum("periodendamount").finish();
        DataSet unionDataSet = beginDataSet.union(inOutDataSet).union(endDataSet);
        unionDataSet = this.addBaseMaterialGroup(unionDataSet, materialGroupDs);
        unionDataSet = unionDataSet.groupBy(this.getGroupCols().split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").sum("periodendqty").sum("periodendamount").finish();
        return unionDataSet;
    }

    private DataSet groupDataSet(DataSet dataSet) {
        dataSet = dataSet.groupBy(this.getGroupCols(true).split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").sum("periodendqty").sum("periodendamount").finish();
        return dataSet.select(this.getFinalSelectFields().split(","));
    }

    private String getGroupCols() {
        StringBuilder sql = new StringBuilder();
        sql.append(this.getGroupColsWithOutCostElement());
        return sql.toString();
    }

    private String getGroupColsWithOutCostElement() {
        StringBuilder sql = new StringBuilder();
        sql.append("costaccountid,calorgid");
        sql.append(",year,month,periodnumber");
        sql.append(",ownertype,owner");
        sql.append(",storageorgunit");
        sql.append(",warehouse,warehsgroup");
        sql.append(",materialcategory");
        sql.append(",location");
        sql.append(",lot");
        sql.append(",assist");
        sql.append(",project");
        sql.append(",tracknumber");
        sql.append(",materialnumber,material,materialmodel,baseunit,qtyprecision,currency,group");
        return sql.toString();
    }

    private DataSet groupDataSetByPeriod(DataSet dataSet) {
        if (this.isGroupByPeriod) {
            DataSet dataSet1 = dataSet.groupBy(this.getGroupCols(false).split(",")).minP("periodnumber", "periodbeginqty", "periodbeginqty").minP("periodnumber", "periodbeginamount", "periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").maxP("periodnumber", "periodendqty", "periodendqty").maxP("periodnumber", "periodendamount", "periodendamount").finish();
            dataSet1 = dataSet1.addField("concat(concat('" + this.filter_startPeriod.getString("number") + "','-'),'" + this.filter_endPeriod.getString("number") + "')", "periodnumber").addField("0", "year").addField("0", "month");
            return dataSet1.select(this.getFinalSelectFields().split(","));
        }
        return dataSet;
    }

    private DataSet unionGroupDataSet(DataSet dataSet, List<QFilter> balanceHeadFilters) {
        DataSet periodHappenTotalDataSet = dataSet.copy();
        periodHappenTotalDataSet = periodHappenTotalDataSet.groupBy(this.getGroupCols("0").split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").sum("periodendqty").sum("periodendamount").max("qtyprecision").maxP("qtyprecision", "baseunit").max("material", "materialassist").finish();
        periodHappenTotalDataSet = periodHappenTotalDataSet.select((this.getFinalSelectFields("0") + ",materialassist").split(","));
        if (this.isGroupByPeriod) {
            DataSet allTotalDataSet = periodHappenTotalDataSet.copy();
            allTotalDataSet = allTotalDataSet.groupBy(this.getGroupCols("3").split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").max("qtyprecision").maxP("qtyprecision", "baseunit").sum("periodendqty").sum("periodendamount").finish();
            allTotalDataSet = allTotalDataSet.select(this.getFinalSelectFields("3").split(","));
            return dataSet.addField("material", "materialassist").addField("0", "ordercol").addField("0", "ordercol1").union(periodHappenTotalDataSet.addField("0", "ordercol").addField("1", "ordercol1")).union(allTotalDataSet.addField("0", "materialassist").addField("1", "ordercol").addField("2", "ordercol1")).orderBy(this.getOrders().split(","));
        }
        DataSet periodTotalDataSet = periodHappenTotalDataSet.copy();
        periodTotalDataSet = periodTotalDataSet.groupBy(this.getGroupCols("1").split(",")).sum("periodbeginqty").sum("periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").sum("periodendqty").sum("periodendamount").max("qtyprecision").maxP("qtyprecision", "baseunit").finish();
        periodTotalDataSet = periodTotalDataSet.select(this.getFinalSelectFields("1").split(","));
        DataSet yearTotalDataSet = periodTotalDataSet.copy();
        yearTotalDataSet = yearTotalDataSet.groupBy(this.getGroupCols("2").split(",")).sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").max("qtyprecision").maxP("qtyprecision", "baseunit").finish();
        DataSet beginDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_initbill", (String)"id,period.periodyear as year,entryentity.yearinqty as yearinqty,entryentity.yearincost as yearinactualcost,entryentity.yearissueqty as yearissueqty,entryentity.yearissuecost as yearissueactualcost", (QFilter[])new QFilter[]{this.getInitBillFilter()}, null);
        beginDataSet = beginDataSet.groupBy(new String[]{"year"}).sum("yearinqty").sum("yearinactualcost").sum("yearissueqty").sum("yearissueactualcost").finish();
        yearTotalDataSet = yearTotalDataSet.join(beginDataSet, JoinType.LEFT).on("year", "year").select(new String[]{"costaccountid", "calorgid", "year", "0 as periodbeginqty", "0 as periodbeginamount", "periodinqty+yearinqty as periodinqty", "periodinamount+yearinactualcost as periodinamount", "periodoutqty+yearissueqty as periodoutqty", "periodoutamount+yearissueactualcost as periodoutamount", "0 as periodendqty", "0 as periodendamount", "qtyprecision", "baseunit"}).finish();
        yearTotalDataSet = yearTotalDataSet.select(this.getFinalSelectFields("2").split(","));
        DataSet allTotalDataSet = periodTotalDataSet.copy();
        allTotalDataSet = allTotalDataSet.groupBy(this.getGroupCols("3").split(",")).minP("periodnumber", "periodbeginqty").minP("periodnumber", "periodbeginamount").sum("periodinqty").sum("periodinamount").sum("periodoutqty").sum("periodoutamount").maxP("periodnumber", "periodendqty").maxP("periodnumber", "periodendamount").max("qtyprecision").maxP("qtyprecision", "baseunit").finish().select(new String[]{"costaccountid", "calorgid", "periodbeginqty", "periodbeginamount", "periodendqty+periodoutqty-periodbeginqty as periodinqty", "periodendamount+periodoutamount-periodbeginamount as periodinamount", "periodoutqty", "periodoutamount", "periodendqty", "periodendamount", "qtyprecision", "baseunit"});
        allTotalDataSet = allTotalDataSet.select(this.getFinalSelectFields("3").split(","));
        return dataSet.addField("material", "materialassist").addField("0", "ordercol").addField("0", "ordercol1").union(periodHappenTotalDataSet.addField("0", "ordercol").addField("1", "ordercol1")).union(periodTotalDataSet.addField("0", "materialassist").addField("1", "ordercol").addField("2", "ordercol1")).union(yearTotalDataSet.addField("0", "materialassist").addField("2", "ordercol").addField("3", "ordercol1")).union(allTotalDataSet.addField("0", "materialassist").addField("3", "ordercol").addField("4", "ordercol1")).orderBy(this.getOrders().split(","));
    }

    private DataSet noShowZeroInOut(DataSet dataSet) {
        if (this.noShowZeroInOut) {
            return dataSet.filter("periodinqty <> 0 or periodinamount <> 0 or periodoutqty <> 0 or periodoutamount <> 0");
        }
        return dataSet;
    }

    private DataSet filterByQtyCondition(DataSet dataSet) {
        if (StringUtils.isNotEmpty((String)this.qtyShowCondition)) {
            if ("A".equals(this.qtyShowCondition)) {
                return dataSet.filter("periodendqty = 0");
            }
            if ("B".equals(this.qtyShowCondition)) {
                return dataSet.filter("periodendqty <> 0");
            }
            if ("C".equals(this.qtyShowCondition)) {
                return dataSet.filter("periodendqty > 0");
            }
            if ("D".equals(this.qtyShowCondition)) {
                return dataSet.filter("periodendqty < 0");
            }
        }
        return dataSet;
    }

    private DataSet filterByAmountCondition(DataSet dataSet) {
        if (StringUtils.isNotEmpty((String)this.amountShowCondition)) {
            if ("A".equals(this.amountShowCondition)) {
                return dataSet.filter("periodendamount = 0");
            }
            if ("B".equals(this.amountShowCondition)) {
                return dataSet.filter("periodendamount <> 0");
            }
            if ("C".equals(this.amountShowCondition)) {
                return dataSet.filter("periodendamount > 0");
            }
            if ("D".equals(this.amountShowCondition)) {
                return dataSet.filter("periodendamount < 0");
            }
        }
        return dataSet;
    }

    private DataSet onlyShowSumRow(DataSet dataSet) {
        if (this.onlyShowSumRow) {
            return dataSet.filter("(ordercol <> 0 and ordercol1 <> 0) or material = 0");
        }
        return dataSet;
    }

    private String getBalSelectFields(int periodNumber, String selectType) {
        String select = "id,costaccount as costaccountid,calorg as calorgid," + periodNumber + " as periodnumber,endperiod as endperiod," + periodNumber / 100 + " as year," + periodNumber % 100 + " as month,ownertype,owner,storageorgunit,warehouse,warehouse.group.id as warehsgroup,stocktype as materialcategory,location,material,material.number as materialnumber,material.modelnum as materialmodel,project,tracknumber,lot,assist,baseunit,baseunit.precision as qtyprecision,calpolicy.currency.id as currency,";
        if (!this.showdetail) {
            if ("0".equals(selectType)) {
                select = select + "periodendqty as periodbeginqty,periodendactualcost as periodbeginamount,0.0 as periodinqty,0.0 as periodinamount,0.0 as periodoutqty,0.0 as periodoutamount,0.0 as periodendqty,0.0 as periodendamount";
            } else if ("1".equals(selectType)) {
                select = select + "0.0 as periodbeginqty,0.0 as periodbeginamount,periodinqty as periodinqty,periodinactualcost as periodinamount,periodissueqty as periodoutqty,periodissueactualcost as periodoutamount,0.0 as periodendqty,0.0 as periodendamount";
            } else if ("2".equals(selectType)) {
                select = select + "0.0 as periodbeginqty,0.0 as periodbeginamount,0.0 as periodinqty,0.0 as periodinamount,0.0 as periodoutqty,0.0 as periodoutamount,periodendqty as periodendqty,periodendactualcost as periodendamount";
            }
        }
        return select;
    }

    private String getBalDetailSelectFields() {
        String select = "balid,costelement,costsubelement,periodbeginqty as periodbeginqty,periodbeginactualcost as periodbeginamount,periodinqty as periodinqty,periodinactualcost as periodinamount,periodissueqty as periodoutqty,periodissueactualcost as periodoutamount,periodendqty as periodendqty,periodendactualcost as periodendamount";
        return select;
    }

    private String getBalAllSelectFields() {
        String select = "id,costaccountid,calorgid,periodnumber,endperiod,year,month,ownertype,owner,storageorgunit,warehouse,warehsgroup,materialcategory,location,material,materialnumber,materialmodel,project,tracknumber,lot,assist,baseunit,qtyprecision,currency";
        return select;
    }

    private String getBalDetailAllSelectFields(String selectType) {
        String select = "costelement,costsubelement,";
        if ("0".equals(selectType)) {
            select = select + "periodendqty as periodbeginqty,periodendamount as periodbeginamount,0.0 as periodinqty,0.0 as periodinamount,0.0 as periodoutqty,0.0 as periodoutamount,0.0 as periodendqty,0.0 as periodendamount";
        } else if ("1".equals(selectType)) {
            select = select + "0.0 as periodbeginqty,0.0 as periodbeginamount,periodinqty as periodinqty,periodinamount as periodinamount,periodoutqty as periodoutqty,periodoutamount as periodoutamount,0.0 as periodendqty,0.0 as periodendamount";
        } else if ("2".equals(selectType)) {
            select = select + "0.0 as periodbeginqty,0.0 as periodbeginamount,0.0 as periodinqty,0.0 as periodinamount,0.0 as periodoutqty,0.0 as periodoutamount,periodendqty as periodendqty,periodendamount as periodendamount";
        }
        return select;
    }

    private String getFinalSelectFields() {
        String select = this.getGroupCols(true);
        select = select + ",periodbeginqty,periodbeginamount," + this.getPriceSelect("periodbeginamount", "periodbeginqty") + " as periodbeginprice,periodinqty,periodinamount," + this.getPriceSelect("periodinamount", "periodinqty") + " as periodinprice,periodoutqty,periodoutamount," + this.getPriceSelect("periodoutamount", "periodoutqty") + " as periodoutprice,periodendqty,periodendamount," + this.getPriceSelect("periodendamount", "periodendqty") + " as periodendprice";
        return select;
    }

    private String getFinalSelectFields(String sumType) {
        String select = this.getSelectByGroupCols(sumType);
        select = select + ",periodbeginqty,periodbeginamount," + this.getPriceSelect("periodbeginamount", "periodbeginqty") + " as periodbeginprice,periodinqty,periodinamount," + this.getPriceSelect("periodinamount", "periodinqty") + " as periodinprice,periodoutqty,periodoutamount," + this.getPriceSelect("periodoutamount", "periodoutqty") + " as periodoutprice,";
        select = select + "periodendqty,periodendamount," + this.getPriceSelect("periodendamount", "periodendqty") + " as periodendprice";
        return select;
    }

    private String getPriceSelect(String amount, String qty) {
        return "case when " + qty + " = 0 then 0 else " + amount + "/" + qty + " end ";
    }

    private String getGroupCols(boolean havePeriodCol) {
        StringBuilder sql = new StringBuilder();
        sql.append("costaccountid,calorgid");
        if (havePeriodCol) {
            sql.append(",year,month,periodnumber");
        }
        this.appendCommonGroupCols(sql, false);
        sql.append(",material,materialnumber,materialmodel,baseunit,qtyprecision,currency");
        if (!this.notShowMaterialGroup && !this.hasMaterialGroup) {
            sql.append(",group");
        }
        return sql.toString();
    }

    private String getGroupCols(String sumType) {
        StringBuilder sql = new StringBuilder();
        sql.append("costaccountid,calorgid");
        if ("0".equals(sumType)) {
            sql.append(",year,month,periodnumber");
            this.appendCommonGroupCols(sql, false);
        } else if ("1".equals(sumType)) {
            sql.append(",year,month,periodnumber");
        } else if ("2".equals(sumType)) {
            sql.append(",year");
        } else if ("3".equals(sumType)) {
            // empty if block
        }
        return sql.toString();
    }

    private String getSelectByGroupCols(String sumType) {
        StringBuilder sql = new StringBuilder();
        if ("0".equals(sumType)) {
            String s1 = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"StockGatherRptQueryPlugin_29", (String)"fi-cal-report", (Object[])new Object[0]);
            sql.append("costaccountid,calorgid");
            sql.append(",year,month,periodnumber");
            this.appendCommonGroupCols(sql, false);
            sql.append(",0 as material,'").append(s1).append("' as materialnumber");
        } else if ("1".equals(sumType)) {
            String s2 = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_30", (String)"fi-cal-report", (Object[])new Object[0]);
            sql.append("0 as costaccountid,0 as calorgid");
            sql.append(",year,month,periodnumber");
            this.appendCommonGroupCols(sql, true);
            sql.append(",0 as material,'").append(s2).append("' as materialnumber");
        } else if ("2".equals(sumType)) {
            String s3 = ResManager.loadKDString((String)"\u672c\u5e74\u5408\u8ba1", (String)"StockGatherRptQueryPlugin_31", (String)"fi-cal-report", (Object[])new Object[0]);
            sql.append("0 as costaccountid,0 as calorgid");
            if (this.topSumRow) {
                sql.append(",year,0 as month,year as periodnumber");
            } else {
                sql.append(",year,99 as month,year as periodnumber");
            }
            this.appendCommonGroupCols(sql, true);
            sql.append(",0 as material,'").append(s3).append("' as materialnumber");
        } else if ("3".equals(sumType)) {
            String s4 = ResManager.loadKDString((String)"\u603b\u8ba1", (String)"StockGatherRptQueryPlugin_32", (String)"fi-cal-report", (Object[])new Object[0]);
            sql.append("0 as costaccountid,0 as calorgid");
            if (this.topSumRow) {
                sql.append(",0 as year,0 as month,null as periodnumber");
            } else {
                sql.append(",9999 as year,99 as month,null as periodnumber");
            }
            this.appendCommonGroupCols(sql, true);
            sql.append(",0 as material,'").append(s4).append("' as materialnumber");
        }
        sql.append(",null as materialmodel");
        sql.append(",baseunit,qtyprecision,").append(this.currencyId).append(" as currency");
        if (!this.notShowMaterialGroup && !this.hasMaterialGroup) {
            sql.append(",null as group");
        }
        return sql.toString();
    }

    private String getOrders() {
        StringBuilder sql = new StringBuilder();
        sql.append("year,month,periodnumber");
        if (this.topSumRow) {
            sql.append(",ordercol desc");
        } else {
            sql.append(",ordercol");
        }
        this.appendCommonGroupCols(sql, false);
        if (this.topSumRow) {
            sql.append(",ordercol1 desc");
        } else {
            sql.append(",ordercol1");
        }
        sql.append(",materialnumber,materialmodel,baseunit,currency");
        if (!this.notShowMaterialGroup && !this.hasMaterialGroup) {
            sql.append(",group");
        }
        return sql.toString();
    }

    private void appendCommonGroupCols(StringBuilder sql, boolean isSelectNullField) {
        if (this.hasGroup(this.groupType, "B")) {
            // empty if block
        }
        if (this.hasGroup(this.groupType, "C")) {
            if (isSelectNullField) {
                sql.append(",null as ownertype,0 as owner");
            } else {
                sql.append(",ownertype,owner");
            }
        }
        if (this.hasGroup(this.groupType, "D")) {
            if (isSelectNullField) {
                sql.append(",0 as storageorgunit");
            } else {
                sql.append(",storageorgunit");
            }
        }
        if (this.hasGroup(this.groupType, "E")) {
            if (isSelectNullField) {
                if (!this.hasGroup(this.groupType, "D")) {
                    sql.append(",0 as storageorgunit");
                }
                sql.append(",0 as warehouse");
            } else {
                if (!this.hasGroup(this.groupType, "D")) {
                    sql.append(",storageorgunit");
                }
                sql.append(",warehouse");
            }
        }
        if (this.hasGroup(this.groupType, "F")) {
            if (isSelectNullField) {
                if (!this.hasGroup(this.groupType, "D") && !this.hasGroup(this.groupType, "E")) {
                    sql.append(",0 as storageorgunit");
                }
                if (!this.hasGroup(this.groupType, "E")) {
                    sql.append(",0 as warehouse");
                }
                sql.append(",0 as location");
            } else {
                if (!this.hasGroup(this.groupType, "D") && !this.hasGroup(this.groupType, "E")) {
                    sql.append(",storageorgunit");
                }
                if (!this.hasGroup(this.groupType, "E")) {
                    sql.append(",warehouse");
                }
                sql.append(",location");
            }
        }
        if (this.hasGroup(this.groupType, "G")) {
            if (isSelectNullField) {
                sql.append(",null as lot");
            } else {
                sql.append(",lot");
            }
        }
        if (this.hasGroup(this.groupType, "H")) {
            if (isSelectNullField) {
                sql.append(",null as assist");
            } else {
                sql.append(",assist");
            }
        }
        if (this.hasGroup(this.groupType, "I")) {
            if (isSelectNullField) {
                sql.append(",0 as project");
            } else {
                sql.append(",project");
            }
        }
        if (this.showdetail) {
            if (isSelectNullField) {
                sql.append(",0 as costelement,0 as costsubelement");
            } else {
                sql.append(",costelement,costsubelement");
            }
        }
        if (this.hasGroup(this.groupType, "J")) {
            if (isSelectNullField) {
                sql.append(",0 as warehsgroup");
            } else {
                sql.append(",warehsgroup");
            }
        }
        if (this.hasMaterialGroup) {
            if (isSelectNullField) {
                sql.append(",null as group");
            } else {
                sql.append(",group");
            }
        }
        if (this.hasGroup(this.groupType, "L")) {
            if (isSelectNullField) {
                sql.append(",0 as materialcategory");
            } else {
                sql.append(",materialcategory");
            }
        }
        if (this.hasGroup(this.groupType, "M")) {
            if (isSelectNullField) {
                sql.append(",0l as tracknumber");
            } else {
                sql.append(",tracknumber");
            }
        }
    }

    private boolean hasGroup(String groupType, String value) {
        return groupType.indexOf(value) >= 0;
    }

    private void createColumnsByGroupType(List<AbstractReportColumn> cols) {
        if (this.hasGroup(this.groupType, "B")) {
            this.createCalRangeColumns(cols);
        }
        if (!this.hasGroup(this.groupType, "C")) {
            ReportUtil.hideOwnerColumns(cols);
        }
        if (this.hasGroup(this.groupType, "D")) {
            this.createStorageColumns(cols);
        }
        if (this.hasGroup(this.groupType, "E")) {
            if (!this.hasGroup(this.groupType, "D")) {
                this.createStorageColumns(cols);
            }
            this.createWarehouseColumns(cols);
        }
        if (this.hasGroup(this.groupType, "F")) {
            if (!this.hasGroup(this.groupType, "D") && !this.hasGroup(this.groupType, "E")) {
                this.createStorageColumns(cols);
            }
            if (!this.hasGroup(this.groupType, "E")) {
                this.createWarehouseColumns(cols);
            }
            this.createLocationColumns(cols);
        }
        if (this.hasGroup(this.groupType, "G")) {
            this.createLotColumns(cols);
        }
        if (this.hasGroup(this.groupType, "H")) {
            this.createAssistPropertyColumns(cols);
        }
        if (this.hasGroup(this.groupType, "I")) {
            this.createProjectColumns(cols);
        }
        if (this.hasGroup(this.groupType, "J")) {
            this.createWarehsgroupColumns(cols);
        }
        if (this.hasGroup(this.groupType, "L")) {
            this.createMaterialCategoryColumns(cols);
        }
        if (!this.hasGroup(this.groupType, "M")) {
            for (int i = 0; i < cols.size(); ++i) {
                ReportColumn column = (ReportColumn)cols.get(i);
                String columnName = column.createColumn().get("dataIndex").toString();
                if (!"tracknumber".equals(columnName)) continue;
                column.setHide(true);
            }
        }
    }

    private void createMaterialCategoryColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_MaterialCategoryNum, this.locale_MaterialCategoryName, "materialcategory", "bd_materialcategory");
    }

    private void createCostElementColumns(List<AbstractReportColumn> cols) {
        if (this.showdetail) {
            this.createCostDetailColumns(cols);
        }
    }

    private void createCostDetailColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_costelementName, this.locale_costelementNum, "costelement", "cad_element");
        this.createGroupTypeColumns(cols, this.locale_costsubelementName, this.locale_costsubelementNum, "costsubelement", "cad_subelement");
    }

    private void createProjectColumns(List<AbstractReportColumn> cols) {
        ReportColumn id = ReportColumn.createBaseDataColumn((String)"project", (String)"bd_project");
        id.setCaption(this.locale_projectNum);
        id.setWidth(width);
        cols.add((AbstractReportColumn)id);
    }

    private void createWarehsgroupColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_warehouseGroupNum, this.locale_warehouseGroupName, "warehsgroup", "bd_warehousegroup");
    }

    private void createGroupTypeColumns(List<AbstractReportColumn> cols, LocaleString numCaption, LocaleString nameCaption, String fieldKey, String entityId) {
        ReportColumn id = ReportColumn.createBaseDataColumn((String)fieldKey, (String)entityId);
        id.setDisplayProp("number");
        id.setCaption(numCaption);
        id.setWidth(width);
        ReportColumn name = ReportColumn.createBaseDataPropColumn((String)(fieldKey + "name"), (String)fieldKey, (String)"name");
        name.setCaption(nameCaption);
        name.setWidth(width);
        cols.add((AbstractReportColumn)id);
        cols.add((AbstractReportColumn)name);
    }

    private void createCalRangeColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_calRangeNum, this.locale_calRangeName, "calrange", "cal_bd_calrange");
    }

    private void createStorageColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_storageOrgNum, this.locale_storageOrgName, "storageorgunit", "bos_org");
    }

    private void createWarehouseColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_warehouseNum, this.locale_warehouseName, "warehouse", "bd_warehouse");
    }

    private void createLocationColumns(List<AbstractReportColumn> cols) {
        this.createGroupTypeColumns(cols, this.locale_locationNum, this.locale_locationName, "location", "bd_location");
    }

    private void createMaterialColumns(List<AbstractReportColumn> cols) {
        ReportColumn materialNumber = new ReportColumn();
        materialNumber.setCaption(this.locale_materialNum);
        materialNumber.setWidth(width);
        materialNumber.setFieldKey("materialnumber");
        materialNumber.setFieldType("text");
        ReportColumn materialName = ReportColumn.createBaseDataColumn((String)"material", (String)"bd_material");
        materialName.setDisplayProp("name");
        materialName.setCaption(this.locale_materialName);
        materialName.setWidth(width);
        Tips tips = new Tips("text", "");
        tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u8054\u67e5\u660e\u7ec6\u8868", (String)"StockGatherRptQueryPlugin_33", (String)"fi-cal-report", (Object[])new Object[0])));
        materialName.setCtlTips(tips);
        materialName.setHyperlink(true);
        ReportColumn model = new ReportColumn();
        model.setCaption(this.locale_model);
        model.setWidth(width);
        model.setFieldKey("materialmodel");
        model.setFieldType("text");
        cols.add((AbstractReportColumn)materialNumber);
        cols.add((AbstractReportColumn)materialName);
        cols.add((AbstractReportColumn)model);
    }

    private void createBaseUnitColumns(List<AbstractReportColumn> cols) {
        ReportColumn id = ReportColumn.createBaseDataColumn((String)"baseunit", (String)"bd_measureunits");
        id.setDisplayProp("name");
        id.setCaption(this.locale_baseUnit);
        id.setWidth(width);
        cols.add((AbstractReportColumn)id);
    }

    private void createLotColumns(List<AbstractReportColumn> cols) {
        ReportColumn lot = new ReportColumn();
        lot.setCaption(this.locale_lot);
        lot.setWidth(width);
        lot.setFieldKey("lot");
        lot.setFieldType("text");
        cols.add((AbstractReportColumn)lot);
    }

    private void createAssistPropertyColumns(List<AbstractReportColumn> cols) {
        ReportColumn assist = new ReportColumn();
        assist.setCaption(this.locale_assistProperty);
        assist.setWidth(width);
        assist.setFieldKey("assist");
        assist.setFieldType("flex");
        assist.setRefBasedataProp("material");
        assist.setEntityId("bd_auxproperty");
        cols.add((AbstractReportColumn)assist);
    }

    private void createDecimalColumns(List<AbstractReportColumn> cols) {
        this.createDecimalColumn(cols, this.locale_periodBegin, "periodbegin");
        this.createDecimalColumn(cols, this.locale_periodIn, "periodin");
        this.createDecimalColumn(cols, this.locale_periodOut, "periodout");
        this.createDecimalColumn(cols, this.locale_periodEnd, "periodend");
    }

    private void createDecimalColumn(List<AbstractReportColumn> cols, LocaleString groupName, String fieldKey) {
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(groupName);
        groupCol.setFieldKey(fieldKey);
        cols.add((AbstractReportColumn)groupCol);
        ReportColumn qty = new ReportColumn();
        qty.setCaption(this.locale_qty);
        qty.setWidth(width);
        qty.setFieldKey(fieldKey + "qty");
        qty.setFieldType("qty");
        qty.setMeasureUnitField("baseunit");
        ReportColumn price = new ReportColumn();
        price.setCaption(this.locale_price);
        price.setWidth(width);
        price.setFieldKey(fieldKey + "price");
        price.setFieldType("price");
        price.setCurrencyField("currency");
        ReportColumn amount = new ReportColumn();
        amount.setCaption(this.locale_amount);
        amount.setWidth(width);
        amount.setFieldKey(fieldKey + "amount");
        amount.setFieldType("amount");
        amount.setCurrencyField("currency");
        groupCol.getChildren().add(qty);
        groupCol.getChildren().add(price);
        groupCol.getChildren().add(amount);
    }

    private void createHideColumns(List<AbstractReportColumn> cols) {
        ReportColumn currencyId = new ReportColumn();
        currencyId.setCaption(this.locale_currency);
        currencyId.setWidth(width);
        currencyId.setFieldKey("currency");
        currencyId.setFieldType("currency");
        currencyId.setEntityId("bd_currency");
        currencyId.setHide(true);
        cols.add((AbstractReportColumn)currencyId);
        ReportColumn year = new ReportColumn();
        year.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e74", (String)"StockGatherRptQueryPlugin_34", (String)"fi-cal-report", (Object[])new Object[0])));
        year.setWidth(width);
        year.setFieldKey("year");
        year.setFieldType("integer");
        year.setHide(true);
        ReportColumn month = new ReportColumn();
        month.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6708", (String)"StockGatherRptQueryPlugin_35", (String)"fi-cal-report", (Object[])new Object[0])));
        month.setWidth(width);
        month.setFieldKey("month");
        month.setFieldType("integer");
        month.setHide(true);
        cols.add((AbstractReportColumn)year);
        cols.add((AbstractReportColumn)month);
    }

    private DataSet getAdjDetailByBatch(DataSet adjDataSet) {
        if (adjDataSet.isEmpty()) {
            QFilter qFilter = new QFilter("1", "!=", (Object)"1");
            return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance_detail", (String)this.getBalDetailSelectFields(), (QFilter[])new QFilter[]{qFilter}, null);
        }
        HashSet<Object> balIds = null;
        ArrayList<HashSet<Object>> balIdsArray = new ArrayList<HashSet<Object>>(16);
        long index = 0L;
        for (Row row : adjDataSet) {
            if (index % 100000L == 0L) {
                balIds = new HashSet<Object>();
                balIdsArray.add(balIds);
            }
            if (balIds != null) {
                balIds.add(row.get("id"));
            }
            ++index;
        }
        DataSet adjustDetailDataSet = null;
        for (int arrayIndex = 0; arrayIndex < balIdsArray.size(); ++arrayIndex) {
            QFilter qFilter = new QFilter("balid", "in", balIdsArray.get(arrayIndex));
            DataSet currAdjDetailDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance_detail", (String)this.getBalDetailSelectFields(), (QFilter[])new QFilter[]{qFilter}, null);
            adjustDetailDataSet = adjustDetailDataSet == null ? currAdjDetailDataSet : adjustDetailDataSet.union(currAdjDetailDataSet);
        }
        return adjustDetailDataSet;
    }

    private List<QFilter> getBalanceHeadFilters(List<QFilter> headFilters) {
        ArrayList<QFilter> newHeadFilters = new ArrayList<QFilter>();
        Iterator<QFilter> headFilter = headFilters.iterator();
        while (headFilter.hasNext()) {
            QFilter filter = headFilter.next();
            String property = filter.getProperty();
            if (!headFieldList.contains(property)) continue;
            this.rebuildBalanceHeadFilter(filter);
            List nests = filter.getNests(true);
            for (QFilter.QFilterNest net : nests) {
                QFilter netFilter = net.getFilter();
                this.rebuildBalanceHeadFilter(netFilter);
            }
            newHeadFilters.add(filter);
        }
        return newHeadFilters;
    }

    private void rebuildBalanceHeadFilter(QFilter filter) {
        String property = filter.getProperty();
        int mark = -1;
        switch (property) {
            case "materialnumber": {
                mark = 0;
                break;
            }
            case "material": {
                mark = 1;
                break;
            }
            case "materialmodel": {
                mark = 2;
                break;
            }
            case "baseunit": {
                mark = 3;
            }
        }
        switch (mark) {
            case 0: {
                filter.__setProperty("material.number");
                break;
            }
            case 1: {
                filter.__setProperty("material.name");
                break;
            }
            case 2: {
                filter.__setProperty("material.modelnum");
                break;
            }
            case 3: {
                filter.__setProperty("baseunit.name");
            }
        }
    }
}

