/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.util.ReportUtil;

public class StockTurnOverRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(StockTurnOverRptQueryPlugin.class);
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private DynamicObject filter_startPeriod;
    private DynamicObject filter_endPeriod;
    private int filter_startPeriodNumber;
    private int filter_endPeriodNumber;
    private List<Integer> periodNumberList = new ArrayList<Integer>(16);
    private Map<Integer, Long> periodIdMap = new HashMap<Integer, Long>(16);
    private long currencyId;
    private DynamicObjectCollection filter_owner;
    private DynamicObjectCollection filter_storageOrg;
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private DynamicObjectCollection filter_materialFrom;
    private DynamicObject filter_materialTo;
    private String[] filter_lot;
    private DynamicObjectCollection filter_project;
    private boolean isGroupByPeriod;
    private String groupType;
    private int turnOverDays;
    private Set<Long> materialIds = new HashSet<Long>();

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        this.init(param);
        DataSet dataSet = null;
        DataSet costRecordDataSet = null;
        DataSet costAdjustDataSet = null;
        DataSet recordAdjustDataSet = null;
        for (int periodNumber : this.periodNumberList) {
            dataSet = dataSet == null ? this.getDataSet(periodNumber) : dataSet.union(this.getDataSet(periodNumber));
            costRecordDataSet = costRecordDataSet == null ? this.getCostRecordDataSet(periodNumber) : costRecordDataSet.union(this.getCostRecordDataSet(periodNumber));
            if (costAdjustDataSet == null) {
                costAdjustDataSet = this.getCostAdjustDataSet(periodNumber);
                continue;
            }
            costAdjustDataSet = costAdjustDataSet.union(this.getCostAdjustDataSet(periodNumber));
        }
        if (dataSet == null || dataSet.copy().isEmpty()) {
            return dataSet;
        }
        recordAdjustDataSet = this.unionRecordAdjust(costRecordDataSet, costAdjustDataSet);
        dataSet = this.joinBalDataSet(dataSet, recordAdjustDataSet);
        dataSet = this.groupDataSet(dataSet);
        dataSet = this.groupDataSetByPeriod(dataSet);
        dataSet = this.caculateDataSet(dataSet);
        dataSet = this.joinGroupDataSet(dataSet);
        StringBuilder orderFilelds = new StringBuilder("periodnumber,material,baseunit,currency");
        this.appendCommonGroupCols(orderFilelds, false);
        dataSet = dataSet.orderBy(orderFilelds.toString().split(","));
        dataSet = this.filterByAllZeroAmount(dataSet);
        return dataSet;
    }

    private List<Set<Object>> getEntryIds(DataSet dataSet, String idName) {
        HashSet<Object> entryIds = null;
        ArrayList<Set<Object>> entryIdsArray = new ArrayList<Set<Object>>(16);
        if (dataSet == null || dataSet.isEmpty()) {
            return entryIdsArray;
        }
        long index = 0L;
        for (Row row : dataSet) {
            if (index % 100000L == 0L) {
                entryIds = new HashSet<Object>();
                entryIdsArray.add(entryIds);
            }
            if (entryIds != null) {
                entryIds.add(row.get(idName));
            }
            ++index;
        }
        return entryIdsArray;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        Set<String> hiddenColumn = this.getHiddenColumn();
        for (AbstractReportColumn abstractReportColumn : columns) {
            ReportColumn column;
            if (!(abstractReportColumn instanceof ReportColumn) || !hiddenColumn.contains((column = (ReportColumn)abstractReportColumn).getFieldKey())) continue;
            column.setHide(true);
        }
        return cols;
    }

    private void init(ReportQueryParam param) {
        this.filterInfo = param.getFilter();
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.filter_startPeriod = this.filterInfo.getDynamicObject("startperiod");
        this.filter_endPeriod = this.filterInfo.getDynamicObject("endperiod");
        this.filter_startPeriodNumber = this.filter_startPeriod.getInt("periodyear") * 100 + this.filter_startPeriod.getInt("periodnumber");
        this.filter_endPeriodNumber = this.filter_endPeriod.getInt("periodyear") * 100 + this.filter_endPeriod.getInt("periodnumber");
        this.isGroupByPeriod = this.filterInfo.getBoolean("groupbyperiod");
        this.groupType = this.filterInfo.getString("mulgrouptype");
        if (this.groupType == null) {
            this.groupType = "A";
        }
        DynamicObject costAccountInfo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", this.filter_costAccount.get("id"))});
        QFilter q = new QFilter("periodtype", "=", costAccountInfo.get("calpolicy.periodtype"));
        q.and(new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE));
        q.and("id", ">=", (Object)this.filter_startPeriod.getLong("id"));
        q.and("id", "<=", (Object)this.filter_endPeriod.getLong("id"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{q}, (String)"periodyear asc,periodnumber asc");
        this.turnOverDays = this.isGroupByPeriod ? coll.size() * 30 : 30;
        for (DynamicObject info : coll) {
            int periodNumber = info.getInt("periodyear") * 100 + info.getInt("periodnumber");
            Long periodId = info.getLong("id");
            this.periodIdMap.put(periodNumber, periodId);
            this.periodNumberList.add(periodNumber);
        }
        this.currencyId = this.filterInfo.getDynamicObject("localcurrency").getLong("id");
        this.filter_owner = this.filterInfo.getDynamicObjectCollection("mulowner");
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        this.filter_materialFrom = this.filterInfo.getDynamicObjectCollection("mulmaterial");
        this.filter_materialTo = this.filterInfo.getDynamicObject("materialto");
        if (StringUtils.isNotEmpty((String)this.filterInfo.getString("lotnumber"))) {
            this.filter_lot = this.filterInfo.getString("lotnumber").split(";");
        }
        this.filter_project = this.filterInfo.getDynamicObjectCollection("mulproject");
    }

    private DataSet getCostAdjustDataSet(int periodNumber) {
        QFilter q = this.getAdjustFilter();
        q.and("billtype.billformid", "=", (Object)"im_saloutbill");
        q.and("period", "=", (Object)this.periodIdMap.get(periodNumber));
        q.and("billstatus", "=", (Object)"C");
        QFilter actualQ = new QFilter("entryentity.accounttype", "!=", (Object)"D");
        QFilter standardQ1 = new QFilter("entryentity.accounttype", "=", (Object)"D");
        standardQ1.and("createtype", "!=", (Object)"M");
        QFilter standardQ2 = new QFilter("entryentity.accounttype", "=", (Object)"D");
        standardQ2.and("createtype", "=", (Object)"M");
        standardQ2.and("billsrctype", "=", (Object)"D");
        q.and(actualQ.or(standardQ1).or(standardQ2));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjustbill", (String)this.getCostAdjustSelectFields(periodNumber), (QFilter[])new QFilter[]{q}, null);
        dataSet = dataSet.groupBy(this.getGroupCols().split(",")).sum("actualcost").finish();
        return dataSet;
    }

    private DataSet getCostRecordDataSet(int periodNumber) {
        Long periodId = this.periodIdMap.get(periodNumber);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_period");
        DynamicObject period = BusinessDataServiceHelper.loadSingle((Object)periodId, (DynamicObjectType)entityType);
        QFilter q = this.getFilter(true);
        q.and("issplitcreate", "=", (Object)"0");
        q.and("billtype.billformid", "=", (Object)"im_saloutbill");
        q.and("period", "=", (Object)periodId);
        q.and("bookdate", "<=", (Object)period.getDate("enddate"));
        q.and("bookdate", ">=", (Object)period.getDate("begindate"));
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getCostRecordSelectFields(periodNumber), (QFilter[])new QFilter[]{q}, null);
        dataSet = dataSet.groupBy(this.getGroupCols().split(",")).sum("actualcost").finish();
        return dataSet;
    }

    private DataSet getDataSet(int periodNumber) {
        QFilter q = this.getFilter(false);
        QFilter beginQ = this.getBeginFilter(periodNumber);
        QFilter endQ = this.getEndFilter(periodNumber);
        DataSet unionDataSet = null;
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            DataSet beginDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)this.getNewBalSelectFields(periodNumber, "0"), (QFilter[])new QFilter[]{q, beginQ}, null);
            beginDataSet = beginDataSet.groupBy((CalBalanceModelHelper.getDimFields((boolean)false) + ",costaccountid,calorgid,periodnumber,year,month,baseunit,currency,isstandard,warehsgroup").split(",")).sum("beginstandardcost").sum("periodbegincostdiff").sum("periodbeginamount").sum("periodendamount").sum("periodendstandardcost").sum("periodendcostdiff").finish();
            DataSet endDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)this.getNewBalSelectFields(periodNumber, "1"), (QFilter[])new QFilter[]{q, endQ}, null);
            endDataSet = endDataSet.groupBy((CalBalanceModelHelper.getDimFields((boolean)false) + ",costaccountid,calorgid,periodnumber,year,month,baseunit,currency,isstandard,warehsgroup").split(",")).sum("beginstandardcost").sum("periodbegincostdiff").sum("periodbeginamount").sum("periodendamount").sum("periodendstandardcost").sum("periodendcostdiff").finish();
            unionDataSet = beginDataSet.union(endDataSet);
        } else {
            DataSet beginDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)this.getBalSelectFields(periodNumber, "0"), (QFilter[])new QFilter[]{q, beginQ}, null);
            DataSet endDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)this.getBalSelectFields(periodNumber, "1"), (QFilter[])new QFilter[]{q, endQ}, null);
            unionDataSet = beginDataSet.union(endDataSet);
        }
        unionDataSet = unionDataSet.groupBy(this.getGroupCols().split(",")).sum("beginstandardcost").sum("periodbegincostdiff").sum("periodendstandardcost").sum("periodendcostdiff").sum("periodbeginamount").sum("periodendamount").finish();
        unionDataSet = unionDataSet.select(this.getGroupCols() + ",case when isstandard = 1 then beginstandardcost + periodbegincostdiff else periodbeginamount end as periodbeginamount,case when isstandard = 1 then periodendstandardcost + periodendcostdiff else periodendamount end as periodendamount");
        return unionDataSet;
    }

    private DataSet unionRecordAdjust(DataSet costRecordDataSet, DataSet costAdjustDataSet) {
        return costRecordDataSet.union(costAdjustDataSet).groupBy(this.getGroupCols().split(",")).sum("actualcost").finish();
    }

    private DataSet joinBalDataSet(DataSet dataSet, DataSet recordAdjustDataSet) {
        return dataSet.leftJoin(recordAdjustDataSet).on("costaccountid", "costaccountid").on("calorgid", "calorgid").on("year", "year").on("month", "month").on("periodnumber", "periodnumber").on("ownertype", "ownertype").on("owner", "owner").on("storageorgunit", "storageorgunit").on("warehouse", "warehouse").on("warehsgroup", "warehsgroup").on("location", "location").on("lot", "lot").on("assist", "assist").on("project", "project").on("material", "material").on("baseunit", "baseunit").on("currency", "currency").on("isstandard", "isstandard").select(dataSet.getRowMeta().getFieldNames(), new String[]{"actualcost"}).finish();
    }

    private DataSet groupDataSet(DataSet dataSet) {
        dataSet = dataSet.groupBy(this.getGroupCols(true).replace(",isstandard", "").split(",")).sum("periodbeginamount").sum("periodendamount").sum("actualcost").finish();
        return dataSet.select((this.getGroupCols(true).replace(",isstandard", "") + ",periodbeginamount,periodendamount,actualcost").split(","));
    }

    private DataSet groupDataSetByPeriod(DataSet dataSet) {
        if (this.isGroupByPeriod) {
            DataSet dataSet1 = dataSet.groupBy(this.getGroupCols(false).replace(",isstandard", "").split(",")).sum("periodbeginamount").sum("periodendamount").sum("actualcost").finish();
            dataSet1 = dataSet1.addField("concat(concat('" + this.filter_startPeriod.getString("number") + "','-'),'" + this.filter_endPeriod.getString("number") + "')", "periodnumber").addField("0", "year").addField("0", "month");
            return dataSet1.select((this.getGroupCols(true).replace(",isstandard", "") + ",periodbeginamount,periodendamount,actualcost").split(","));
        }
        return dataSet;
    }

    private DataSet caculateDataSet(DataSet dataSet) {
        String selectFileds = this.getGroupCols(true).replace(",isstandard", "");
        dataSet = dataSet.select((selectFileds + ",periodbeginamount,periodendamount,(periodbeginamount +  periodendamount) / 2 as avgstock,actualcost as salecost").split(","));
        dataSet = dataSet.select((selectFileds + ",periodbeginamount,periodendamount,avgstock,salecost,case when avgstock != 0 then salecost / avgstock else 0 end as turnrate").split(","));
        List<Object[]> dataList = this.getDataList(dataSet);
        dataSet = Algo.create((String)"fi.cal.rpt").createDataSet(dataList.iterator(), dataSet.getRowMeta());
        return dataSet.select((selectFileds + ",periodbeginamount,periodendamount,avgstock,salecost,turnrate,case when turnrate != 0 then " + this.turnOverDays + ".0 / turnrate else 0 end as turndays").split(","));
    }

    private List<Object[]> getDataList(DataSet dataSet) {
        int fieldLength = dataSet.getRowMeta().getFields().length;
        DataSet dataSetCopy = dataSet.copy();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        for (Row row : dataSetCopy) {
            Object[] RowData = new Object[fieldLength];
            for (int i = 0; i < fieldLength; ++i) {
                RowData[i] = row.get(i);
            }
            BigDecimal turnrate = row.getBigDecimal("turnrate");
            if (turnrate != null) {
                turnrate = turnrate.setScale(4, 4);
            }
            RowData[this.getListFieldIndex((String)"turnrate", (DataSet)dataSet)] = turnrate;
            dataList.add(RowData);
        }
        return dataList;
    }

    private int getListFieldIndex(String field, DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!field.equals(fields[i].getName())) continue;
            return i;
        }
        return -1;
    }

    private DataSet joinGroupDataSet(DataSet dataSet) {
        DataSet copyDataSet = dataSet.copy();
        for (Row row : copyDataSet) {
            Long materialId = row.getLong("material");
            this.materialIds.add(materialId);
        }
        QFilter q = new QFilter("standard", "=", (Object)730148448254487552L);
        q.and("material.id", "in", this.materialIds);
        DataSet materialGroupDataSet = QueryServiceHelper.queryDataSet((String)"bd_materialgroupdetail", (String)"bd_materialgroupdetail", (String)"standard,group as materialgroup,material.id as materialid", (QFilter[])q.toArray(), (String)"group desc");
        return dataSet.leftJoin(materialGroupDataSet).on("material", "materialid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialgroup"}).finish();
    }

    private DataSet addCurrency(DataSet dataSet) {
        return dataSet.addField(String.valueOf(this.currencyId), "currency");
    }

    private QFilter getAdjustFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        q.and("billtype.billformid", "=", (Object)"im_saloutbill");
        if (this.filter_owner != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_owner) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.owner", "in", set);
        }
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            q.and("entryentity.warehouse.group", "in", this.warehsGroupSet);
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.warehouse", "in", set);
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            q.and("entryentity.location", "in", set);
        }
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                q.and("entryentity.material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("entryentity.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("entryentity.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        if (this.filter_lot != null) {
            q.and("entryentity.lot", "in", (Object)this.filter_lot);
        }
        if (this.filter_project != null) {
            HashSet<Long> projectSet = new HashSet<Long>();
            for (DynamicObject project : this.filter_project) {
                projectSet.add(project.getLong("id"));
            }
            q.and("entryentity.project.id", "in", projectSet);
        }
        return q;
    }

    private QFilter getFilter(boolean isCostRecord) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        if (this.filter_owner != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_owner) {
                set.add(info.getPkValue());
            }
            if (isCostRecord) {
                q.and("entry.owner", "in", set);
            } else {
                q.and("owner", "in", set);
            }
        }
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (!this.warehsGroupSet.isEmpty()) {
            if (isCostRecord) {
                q.and("entry.warehouse.group", "in", this.warehsGroupSet);
            } else {
                q.and("warehouse.group", "in", this.warehsGroupSet);
            }
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            if (isCostRecord) {
                q.and("entry.warehouse", "in", set);
            } else {
                q.and("warehouse", "in", set);
            }
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            if (isCostRecord) {
                q.and("entry.location", "in", set);
            } else {
                q.and("location", "in", set);
            }
        }
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                if (isCostRecord) {
                    q.and("entry.material.id", "in", materialSet);
                } else {
                    q.and("material.id", "in", materialSet);
                }
            } else if (this.filter_materialFrom.size() == 1) {
                if (isCostRecord) {
                    q.and("entry.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
                } else {
                    q.and("material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
                }
            }
        }
        if (this.filter_materialTo != null) {
            if (isCostRecord) {
                q.and("entry.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
            } else {
                q.and("material.number", "<=", (Object)this.filter_materialTo.getString("number"));
            }
        }
        if (this.filter_lot != null) {
            if (isCostRecord) {
                q.and("entry.lot", "in", (Object)this.filter_lot);
            } else {
                q.and("lot", "in", (Object)this.filter_lot);
            }
        }
        if (this.filter_project != null) {
            HashSet<Long> projectSet = new HashSet<Long>();
            for (DynamicObject project : this.filter_project) {
                projectSet.add(project.getLong("id"));
            }
            if (isCostRecord) {
                q.and("entry.project.id", "in", projectSet);
            } else {
                q.and("project.id", "in", projectSet);
            }
        }
        return q;
    }

    private QFilter getBeginFilter(int periodNumber) {
        QFilter q = new QFilter("period", "<", (Object)periodNumber);
        q.and(new QFilter("endperiod", ">=", (Object)periodNumber));
        return q;
    }

    private QFilter getEndFilter(int periodNumber) {
        QFilter q = new QFilter("period", "<=", (Object)periodNumber);
        q.and(new QFilter("endperiod", ">", (Object)periodNumber));
        return q;
    }

    private String getCostRecordSelectFields(int periodNumber) {
        int year = periodNumber / 100;
        int month = periodNumber % 100;
        String select = "costaccount.id as costaccountid,calorg.id as calorgid," + periodNumber + " as periodnumber," + year + " as year," + month + " as month,entry.ownertype as ownertype,entry.owner as owner,storageorgunit,entry.warehouse as warehouse,entry.warehouse.group.id as warehsgroup,entry.location.id as location,entry.material.id as material,entry.project.id as project,entry.lot as lot,entry.assist as assist,entry.baseunit.id as baseunit,localcurrency.id as currency,case when entry.accounttype = 'D' then entry.standardcost else entry.actualcost end as actualcost,case when entry.accounttype = 'D' then 1 else 0 end as isstandard";
        return select;
    }

    private String getCostAdjustSelectFields(int periodNumber) {
        int year = periodNumber / 100;
        int month = periodNumber % 100;
        String select = "costaccount.id as costaccountid,calorg.id as calorgid," + periodNumber + " as periodnumber," + year + " as year," + month + " as month,entryentity.ownertype as ownertype,entryentity.owner as owner,entryentity.storageorgunit.id as storageorgunit,entryentity.warehouse.id as warehouse,entryentity.warehouse.group.id as warehsgroup,entryentity.location.id as location,entryentity.material.id as material,entryentity.project.id as project,entryentity.lot as lot,entryentity.assist as assist,entryentity.baseunit.id as baseunit,currency.id as currency,entryentity.adjustamt as actualcost,case when entryentity.accounttype = 'D' then 1 else 0 end as isstandard";
        return select;
    }

    private String getBalSelectFields(int periodNumber, String selectType) {
        int year = periodNumber / 100;
        int month = periodNumber % 100;
        String select = "costaccount.id as costaccountid,calorg.id as calorgid," + periodNumber + " as periodnumber," + year + " as year," + month + " as month,ownertype,owner,storageorgunit,warehouse,warehouse.group.id as warehsgroup,location,material,project,lot,assist,baseunit,calpolicy.currency.id as currency,case when accounttype = 'D' then 1 else 0 end as isstandard";
        if ("0".equals(selectType)) {
            select = select + ",periodendstandardcost as beginstandardcost,periodendcostdiff as periodbegincostdiff,periodendactualcost as periodbeginamount,0.0 as periodendamount,0.0 as periodendstandardcost,0.0 as periodendcostdiff";
        } else if ("1".equals(selectType)) {
            select = select + ",0.0 as beginstandardcost,0.0 as periodbegincostdiff,0.0 as periodbeginamount,periodendactualcost as periodendamount,periodendstandardcost as periodendstandardcost,periodendcostdiff as periodendcostdiff";
        }
        return select;
    }

    private String getNewBalSelectFields(int periodNumber, String selectType) {
        int year = periodNumber / 100;
        int month = periodNumber % 100;
        String select = CalBalanceModelHelper.getDimFields((boolean)true) + ",costaccount.id as costaccountid,calorg.id as calorgid," + periodNumber + " as periodnumber," + year + " as year," + month + " as month,baseunit,calpolicy.currency.id as currency,warehouse.group.id as warehsgroup,case when accounttype = 'D' then 1 else 0 end as isstandard";
        if ("0".equals(selectType)) {
            select = select + ",standardcost_bal as beginstandardcost,costdiff_bal as periodbegincostdiff,actualcost_bal as periodbeginamount,0.0 as periodendamount,0.0 as periodendstandardcost,0.0 as periodendcostdiff";
        } else if ("1".equals(selectType)) {
            select = select + ",0.0 as beginstandardcost,0.0 as periodbegincostdiff,0.0 as periodbeginamount,actualcost_bal as periodendamount,standardcost_bal as periodendstandardcost,costdiff_bal as periodendcostdiff";
        }
        return select;
    }

    private String getGroupCols() {
        StringBuilder sql = new StringBuilder();
        sql.append("costaccountid,calorgid");
        sql.append(",year,month,periodnumber");
        sql.append(",ownertype,owner");
        sql.append(",storageorgunit");
        sql.append(",warehouse,warehsgroup");
        sql.append(",location");
        sql.append(",lot");
        sql.append(",assist");
        sql.append(",project");
        sql.append(",material,baseunit,currency,isstandard");
        return sql.toString();
    }

    private String getGroupCols(boolean havePeriodCol) {
        StringBuilder sql = new StringBuilder();
        sql.append("costaccountid,calorgid");
        if (havePeriodCol) {
            sql.append(",year,month,periodnumber");
        }
        this.appendCommonGroupCols(sql, false);
        sql.append(",material,baseunit,currency,isstandard");
        return sql.toString();
    }

    private void appendCommonGroupCols(StringBuilder sql, boolean isSelectNullField) {
        if (this.hasGroup(this.groupType, "B")) {
            if (isSelectNullField) {
                sql.append(",null as ownertype,0 as owner");
            } else {
                sql.append(",ownertype,owner");
            }
        }
        if (this.hasGroup(this.groupType, "C")) {
            if (isSelectNullField) {
                sql.append(",0 as storageorgunit");
            } else {
                sql.append(",storageorgunit");
            }
        }
        if (this.hasGroup(this.groupType, "D")) {
            if (isSelectNullField) {
                if (!this.hasGroup(this.groupType, "C")) {
                    sql.append(",0 as storageorgunit");
                }
                sql.append(",0 as warehouse");
            } else {
                if (!this.hasGroup(this.groupType, "C")) {
                    sql.append(",storageorgunit");
                }
                sql.append(",warehouse");
            }
        }
        if (this.hasGroup(this.groupType, "E")) {
            if (isSelectNullField) {
                if (!this.hasGroup(this.groupType, "C") && !this.hasGroup(this.groupType, "D")) {
                    sql.append(",0 as storageorgunit");
                }
                if (!this.hasGroup(this.groupType, "D")) {
                    sql.append(",0 as warehouse");
                }
                sql.append(",0 as location");
            } else {
                if (!this.hasGroup(this.groupType, "C") && !this.hasGroup(this.groupType, "D")) {
                    sql.append(",storageorgunit");
                }
                if (!this.hasGroup(this.groupType, "D")) {
                    sql.append(",warehouse");
                }
                sql.append(",location");
            }
        }
        if (this.hasGroup(this.groupType, "F")) {
            if (isSelectNullField) {
                sql.append(",0 as warehsgroup");
            } else {
                sql.append(",warehsgroup");
            }
        }
        if (this.hasGroup(this.groupType, "G")) {
            if (isSelectNullField) {
                sql.append(",'' as lot");
            } else {
                sql.append(",lot");
            }
        }
        if (this.hasGroup(this.groupType, "H")) {
            if (isSelectNullField) {
                sql.append(",0 as project");
            } else {
                sql.append(",project");
            }
        }
        if (this.hasGroup(this.groupType, "I")) {
            if (isSelectNullField) {
                sql.append(",0 as assist");
            } else {
                sql.append(",assist");
            }
        }
    }

    private boolean hasGroup(String groupType, String value) {
        return groupType.indexOf(value) >= 0;
    }

    private Set<String> getHiddenColumn() {
        HashSet<String> hiddenColumn = new HashSet<String>();
        if (!this.hasGroup(this.groupType, "B")) {
            hiddenColumn.add("owner");
        }
        if (!(this.hasGroup(this.groupType, "C") || this.hasGroup(this.groupType, "D") || this.hasGroup(this.groupType, "E"))) {
            hiddenColumn.add("storageorg");
        }
        if (!this.hasGroup(this.groupType, "D") && !this.hasGroup(this.groupType, "E")) {
            hiddenColumn.add("warehouse");
        }
        if (!this.hasGroup(this.groupType, "E")) {
            hiddenColumn.add("location");
        }
        if (!this.hasGroup(this.groupType, "F")) {
            hiddenColumn.add("warehsgroup");
        }
        if (!this.hasGroup(this.groupType, "G")) {
            hiddenColumn.add("lot");
        }
        if (!this.hasGroup(this.groupType, "H")) {
            hiddenColumn.add("project");
        }
        if (!this.hasGroup(this.groupType, "I")) {
            hiddenColumn.add("assist");
        }
        return hiddenColumn;
    }

    private DataSet filterByAllZeroAmount(DataSet calDataSet) {
        StringBuilder select = new StringBuilder();
        select.append("salecost <> null or avgstock <> 0");
        calDataSet = calDataSet.filter(select.toString());
        calDataSet = calDataSet.groupBy(calDataSet.getRowMeta().getFieldNames()).finish();
        return calDataSet;
    }
}

