/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.queryplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.StringType;
import kd.bos.algo.input.DbInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.common.util.ReportUtil;

public class TransactionDetailRptQueryPlugin
extends AbstractReportListDataPlugin {
    private FilterInfo filterInfo;
    private DynamicObject filter_costAccount;
    private DynamicObject filter_calorg;
    private Date filter_startdate;
    private Date filter_enddate;
    private DynamicObjectCollection filter_storageOrg;
    private Set<Long> warehsGroupSet = new HashSet<Long>(8);
    private DynamicObjectCollection filter_warehouse;
    private DynamicObjectCollection filter_location;
    private DynamicObjectCollection filter_materialFrom;
    private DynamicObject filter_materialTo;
    private DynamicObjectCollection filter_project;
    private String[] filter_voucherStatus;
    private Set<Boolean> filter_isPost = new HashSet<Boolean>(16);
    private DynamicObjectCollection filter_biztype;
    private DynamicObjectCollection filter_billtype;
    private DynamicObjectCollection filter_invscheme;
    private String[] filter_billno;
    private String[] filter_billnumber;
    private DynamicObjectCollection filter_account;
    private Set<QFilter> filter_costRecord;
    private Set<QFilter> filter_costAdjust;
    private Set<QFilter> filter_stdDiffBill;
    private List<Set<Object>> recordEntryIds;
    private Set<Object> recordIds = new HashSet<Object>(16);
    private List<Set<Object>> adjustEntryIds;
    private Map<String, Boolean> isExEntryField = new HashMap<String, Boolean>(16);
    private Map<String, String> exFieldTypeMap = new HashMap<String, String>(16);
    private Map<String, String> exFieldNameMap = new HashMap<String, String>(16);
    private StringBuilder exRecordSelectFields = new StringBuilder();
    private StringBuilder exAdjustSelectFields = new StringBuilder();
    private static final int BATCH_SIZE = 100000;

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        this.init(param);
        DataSet dataSet = this.getCostRecordDataSet();
        DataSet costAdjustDataSet = null;
        if (this.filter_biztype == null && this.filter_invscheme == null) {
            costAdjustDataSet = this.getCostAdjustDataSet(dataSet.getRowMeta());
        }
        String recordFilter = "isvoucher = true or carryovervoucherid  <> 0l and tempvoucherid <> 0l and dischargevoucherid <> 0l and feevoucherid <> 0l";
        this.recordEntryIds = this.getEntryIds(dataSet.copy().filter(recordFilter), "entryid", "cal_costrecord_subentity");
        if (costAdjustDataSet != null) {
            this.adjustEntryIds = this.getEntryIds(costAdjustDataSet.copy().filter("billentitytype = 'cal_costadjust_subentity' and isvoucher = true"), "entryid", null);
            dataSet = dataSet.union(costAdjustDataSet);
        }
        DataSet detailDataSet = this.getDetailDateSet();
        DataSet voucherDataSet = this.getVoucherDataSet(dataSet.copy().filter("isvoucher = true"), detailDataSet);
        if (voucherDataSet == null || voucherDataSet.isEmpty()) {
            dataSet = dataSet.orderBy(new String[]{"bookdate", "audittime", "billnumber", "billno", "entryseq"});
            return dataSet;
        }
        dataSet = this.filter_account != null || this.filter_voucherStatus != null || !this.filter_isPost.isEmpty() ? voucherDataSet.leftJoin(dataSet).on("sourcebillentryid", "entryid").select(voucherDataSet.getRowMeta().getFieldNames(), dataSet.getRowMeta().getFieldNames()).finish() : voucherDataSet.fullJoin(dataSet).on("sourcebillentryid", "entryid").select(voucherDataSet.getRowMeta().getFieldNames(), dataSet.getRowMeta().getFieldNames()).finish();
        return this.dealOrderAndOtherFields(dataSet);
    }

    private void init(ReportQueryParam param) {
        String entryString;
        String isPost;
        this.filterInfo = param.getFilter();
        this.filter_calorg = this.filterInfo.getDynamicObject("calorg");
        this.filter_costAccount = this.filterInfo.getDynamicObject("costaccount");
        this.filter_startdate = this.filterInfo.getDate("startdate");
        this.filter_enddate = DateUtils.getDayEndTime((Date)this.filterInfo.getDate("enddate"));
        this.filter_account = this.filterInfo.getDynamicObjectCollection("mulaccount");
        this.filter_biztype = this.filterInfo.getDynamicObjectCollection("mulbiztype");
        this.filter_billtype = this.filterInfo.getDynamicObjectCollection("mulbilltype");
        this.filter_invscheme = this.filterInfo.getDynamicObjectCollection("mulinvscheme");
        if (!"".equals(this.filterInfo.getString("billnoid").trim())) {
            this.filter_billno = this.filterInfo.getString("billnoid").split(" ");
        }
        if (!"".equals(this.filterInfo.getString("billnumberid").trim())) {
            this.filter_billnumber = this.filterInfo.getString("billnumberid").split(" ");
        }
        this.filter_storageOrg = this.filterInfo.getDynamicObjectCollection("mulstorageorg");
        this.warehsGroupSet = ReportUtil.getWarehsGroupSet((FilterInfo)this.filterInfo);
        this.filter_warehouse = this.filterInfo.getDynamicObjectCollection("mulwarehouse");
        this.filter_location = this.filterInfo.getDynamicObjectCollection("mullocation");
        this.filter_materialFrom = this.filterInfo.getDynamicObjectCollection("mulmaterial");
        this.filter_materialTo = this.filterInfo.getDynamicObject("materialto");
        this.filter_project = this.filterInfo.getDynamicObjectCollection("mulproject");
        String voucherStatus = this.filterInfo.getString("voucherstatus");
        if (voucherStatus != null && !"".equals(CommonUtils.trimComma((String)voucherStatus))) {
            this.filter_voucherStatus = CommonUtils.trimComma((String)voucherStatus).split(",");
        }
        if ((isPost = this.filterInfo.getString("ispost")) != null && !"".equals(CommonUtils.trimComma((String)isPost))) {
            String[] isPostArray = CommonUtils.trimComma((String)isPost).split(",");
            for (int i = 0; i < isPostArray.length; ++i) {
                this.filter_isPost.add(Boolean.parseBoolean(isPostArray[i]));
            }
        }
        if ((entryString = this.filterInfo.getString("entry")) != null) {
            this.getCostRecordFilter(entryString);
        }
        this.setExtFilter();
        this.setExtCols();
    }

    private DataSet getCostRecordDataSet() {
        QFilter q = this.getFilter(true);
        String selectFields = this.getCostRecordSelectFields();
        if (this.exRecordSelectFields.length() != 0) {
            selectFields = this.exRecordSelectFields + selectFields;
        }
        HashSet<QFilter> recordQfilter = new HashSet<QFilter>(16);
        if (this.filter_costRecord != null) {
            for (QFilter qFilter : this.filter_costRecord) {
                QFilter copyQ = q.copy();
                copyQ.and(qFilter);
                QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
                copyQ.and(billStatusf);
                recordQfilter.add(copyQ);
            }
        } else {
            recordQfilter.add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
        }
        ArrayList<OrmInput> allBillIOs = new ArrayList<OrmInput>(16);
        for (QFilter qFilter : recordQfilter) {
            OrmInput recordbillIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord_subentity", selectFields, new QFilter[]{qFilter});
            allBillIOs.add(recordbillIO);
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet recordDataset = algo.createDataSet((Input[])allBillIOs.toArray(new OrmInput[allBillIOs.size()]));
        recordDataset.getRowMeta().getField("createtype").setDataType((DataType)new StringType());
        recordDataset.getRowMeta().getField("billentitytype").setDataType((DataType)new StringType());
        return recordDataset;
    }

    private DataSet getCostAdjustDataSet(RowMeta rowMeta) {
        QFilter copyQ;
        QFilter q = this.getFilter(false);
        String adjustBillFields = this.getCostAdjustSelectFields();
        String diffBillFields = this.getStdDiffBillSelectFields();
        if (this.exAdjustSelectFields.length() != 0) {
            adjustBillFields = this.exAdjustSelectFields + adjustBillFields;
            diffBillFields = this.exAdjustSelectFields + diffBillFields;
        }
        HashSet<QFilter> adjustQfilter = new HashSet<QFilter>(16);
        HashSet<QFilter> diffBillQfilter = new HashSet<QFilter>(16);
        if (this.filter_costAdjust != null) {
            for (QFilter qFilter : this.filter_costAdjust) {
                copyQ = q.copy();
                copyQ.and(qFilter);
                copyQ.and(new QFilter("entryentity.accounttype", "!=", (Object)AccountTypeEnum.STANDARDCOST.getValue()));
                adjustQfilter.add(copyQ);
            }
        } else {
            adjustQfilter.add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
        }
        if (this.filter_stdDiffBill != null) {
            for (QFilter qFilter : this.filter_stdDiffBill) {
                copyQ = q.copy();
                copyQ.and(qFilter);
                diffBillQfilter.add(copyQ);
            }
        } else {
            diffBillQfilter.add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
        }
        ArrayList<OrmInput> allBillIOs = new ArrayList<OrmInput>(16);
        for (QFilter qFilter : adjustQfilter) {
            OrmInput adjustbillIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costadjust_subentity", adjustBillFields, new QFilter[]{qFilter}, rowMeta);
            allBillIOs.add(adjustbillIO);
        }
        for (QFilter qFilter : diffBillQfilter) {
            OrmInput stdDiffbillIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_stdcostdiffbill", diffBillFields, new QFilter[]{qFilter}, rowMeta);
            allBillIOs.add(stdDiffbillIO);
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet adjustDataSet = algo.createDataSet((Input[])allBillIOs.toArray(new OrmInput[allBillIOs.size()]));
        return adjustDataSet;
    }

    private DataSet getDetailDateSet() {
        DataSet detailDataSet = null;
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, this.recordIds)});){
            OrmInput billIO;
            QFilter qFilter;
            int arrayIndex;
            ctx.set();
            ArrayList<OrmInput> allBillIOs = new ArrayList<OrmInput>(16);
            if (this.recordEntryIds != null && !this.recordEntryIds.isEmpty()) {
                for (arrayIndex = 0; arrayIndex < this.recordEntryIds.size(); ++arrayIndex) {
                    qFilter = new QFilter("entryid", "in", this.recordEntryIds.get(arrayIndex));
                    billIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord_detail", "id as detailid,entryid", new QFilter[]{qFilter});
                    allBillIOs.add(billIO);
                }
            }
            if (this.adjustEntryIds != null && !this.adjustEntryIds.isEmpty()) {
                for (arrayIndex = 0; arrayIndex < this.adjustEntryIds.size(); ++arrayIndex) {
                    qFilter = new QFilter("entryid", "in", this.adjustEntryIds.get(arrayIndex));
                    billIO = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costadjust_detail", "id as detailid,entryid", new QFilter[]{qFilter});
                    allBillIOs.add(billIO);
                }
            }
            if (allBillIOs.size() > 0) {
                Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
                detailDataSet = algo.createDataSet((Input[])allBillIOs.toArray(new OrmInput[allBillIOs.size()]));
            }
            DataSet dataSet = detailDataSet;
            return dataSet;
        }
    }

    private DataSet getVoucherDataSet(DataSet dataSet, DataSet detailDataSet) {
        DataSet voucherBillDataSet = null;
        DataSet voucherDateSet = null;
        DataSet detailEntryDataSet = null;
        DataSet detailDataSetcopy = null;
        HashSet<Object> billIdsSet = new HashSet<Object>();
        HashSet<Long> entryidset = new HashSet<Long>();
        Set<Object> detailidset = new HashSet();
        HashMap<String, Set<Object>> params = new HashMap<String, Set<Object>>();
        dataSet = dataSet.select("id,entryid");
        for (Row row : dataSet) {
            Long entryid = (Long)row.get("entryid");
            Long id = (Long)row.get("id");
            entryidset.add(entryid);
            billIdsSet.add(id);
        }
        if (detailDataSet != null) {
            detailDataSetcopy = detailDataSet.copy();
        }
        detailidset = this.getSetEntryIds(detailDataSetcopy, "detailid");
        params.put("entryidset", entryidset);
        params.put("detailidset", detailidset);
        if (!billIdsSet.isEmpty()) {
            voucherBillDataSet = this.getBizVoucherDataSet(billIdsSet);
        }
        if (voucherBillDataSet == null || voucherBillDataSet.isEmpty()) {
            if (this.filter_account != null) {
                return this.getNewVoucherDataSet();
            }
            return null;
        }
        if (!entryidset.isEmpty()) {
            voucherDateSet = voucherBillDataSet.copy().filter("sourcebillentryid in entryidset", params);
        }
        if (!detailidset.isEmpty()) {
            detailEntryDataSet = voucherBillDataSet.filter("sourcebillentryid in detailidset", params);
        }
        if (detailEntryDataSet != null && detailDataSet != null) {
            detailEntryDataSet = detailEntryDataSet.leftJoin(detailDataSet).on("sourcebillentryid", "detailid").select(detailEntryDataSet.getRowMeta().getFieldNames(), detailDataSet.getRowMeta().getFieldNames()).finish();
            detailEntryDataSet = detailEntryDataSet.select("entryid as sourcebillentryid,account,description,assgrp,debitlocal,creditlocal,glvoucherid,fivouchernum,bookeddate,billstatus,isposted,vouchercreator");
            voucherDateSet = voucherDateSet != null ? voucherDateSet.union(detailEntryDataSet) : detailEntryDataSet;
        }
        if (voucherDateSet == null || voucherDateSet.isEmpty()) {
            if (this.filter_account != null) {
                return this.getNewVoucherDataSet();
            }
            return null;
        }
        voucherDateSet = voucherDateSet.groupBy(new String[]{"glvoucherid", "sourcebillentryid", "account", "fivouchernum", "bookeddate", "billstatus", "isposted", "vouchercreator"}).maxP("assgrp", "description").max("assgrp").sum("debitlocal").sum("creditlocal").finish();
        voucherDateSet = voucherDateSet.select("glvoucherid,sourcebillentryid,account,fivouchernum,bookeddate,billstatus,isposted,vouchercreator,description,assgrp,creditlocal - debitlocal as tempamout1,debitlocal - creditlocal as tempamout2");
        voucherDateSet = voucherDateSet.addField("0", "orderindex");
        voucherDateSet = voucherDateSet.select("glvoucherid,sourcebillentryid,account,fivouchernum,bookeddate,billstatus,isposted,vouchercreator,description,assgrp,case when tempamout2 > 0 then tempamout2 else 0 end as debitlocal,case when tempamout1 > 0 then tempamout1 else 0 end as creditlocal,orderindex");
        voucherDateSet.getRowMeta().getField("isposted").setDataType((DataType)new BooleanType());
        if (this.filter_account != null) {
            DataSet newVoucherDataSet = this.getNewVoucherDataSet();
            return voucherDateSet.union(newVoucherDataSet);
        }
        return voucherDateSet;
    }

    private DataSet getBizVoucherDataSet(Set<Object> idSet) {
        DataSet glVoucherDataSet;
        QFilter glVoucherQ = new QFilter("sourcebill", "in", idSet);
        if (this.filter_voucherStatus != null) {
            glVoucherQ.and("billstatus", "in", (Object)this.filter_voucherStatus);
        }
        if (!this.filter_isPost.isEmpty()) {
            glVoucherQ.and("ispost", "in", this.filter_isPost);
        }
        if ((glVoucherDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"id as glvoucherid,billno as fivouchernum,bookeddate as bookeddate,billstatus as billstatus,ispost as isposted,creator as vouchercreator", (QFilter[])glVoucherQ.toArray(), null)).isEmpty()) {
            return null;
        }
        Set<Object> glVoucherIdSet = this.getSetEntryIds(glVoucherDataSet.copy(), "glvoucherid");
        DBRoute route = new DBRoute("ai");
        SqlBuilder aiSqlBuilder = new SqlBuilder();
        aiSqlBuilder.append("select fid,fglvoucherid from t_ai_bizvoucher where", new Object[0]);
        aiSqlBuilder.appendIn("fglvoucherid", glVoucherIdSet.toArray());
        DataSet aiVoucher = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)route, (SqlBuilder)aiSqlBuilder);
        List<Set<Object>> fidList = this.getEntryIds(aiVoucher.copy(), "fid", null);
        aiVoucher = aiVoucher.leftJoin(glVoucherDataSet).on("fglvoucherid", "glvoucherid").select(new String[]{"fid"}, glVoucherDataSet.getRowMeta().getFieldNames()).finish();
        String sqlSelect = "select fid,fsourcebillentryid as sourcebillentryid,faccountid as account,fdescription as description,fassgrpid as assgrp,flocaldebit as debitlocal,flocalcredit as creditlocal from t_ai_bizvoucherentry ";
        SqlBuilder nullSqlBuilder = new SqlBuilder();
        nullSqlBuilder.append(sqlSelect, new Object[0]);
        nullSqlBuilder.append("where 1 != 1", new Object[0]);
        DataSet nullDataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)route, (SqlBuilder)nullSqlBuilder);
        RowMeta rowMeta = nullDataSet.getRowMeta();
        ArrayList<DbInput> vouchersIO = new ArrayList<DbInput>(fidList.size());
        for (int arrayIndex = 0; arrayIndex < fidList.size(); ++arrayIndex) {
            Object[] fIds = fidList.get(arrayIndex).toArray();
            String sql = sqlSelect;
            sql = sql + "where 1=1 ";
            sql = sql + "and ";
            sql = sql + new QFilter("fid", "in", (Object)fIds).toString();
            if (this.filter_account != null) {
                HashSet<Long> set = new HashSet<Long>();
                for (DynamicObject info : this.filter_account) {
                    long masterId = info.getLong("masterid");
                    set.add(masterId);
                }
                sql = sql + " and ";
                sql = sql + new QFilter("faccountid", "in", set).toString();
            }
            DbInput voucherInput = new DbInput(((Object)((Object)this)).getClass().getName(), route.getRouteKey(), sql, null, rowMeta);
            vouchersIO.add(voucherInput);
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet voucherDateSet = algo.createDataSet((Input[])vouchersIO.toArray(new DbInput[vouchersIO.size()]));
        String leftSelect = "sourcebillentryid,account,description,assgrp,debitlocal,creditlocal";
        String rightSelect = "glvoucherid,fivouchernum,bookeddate,billstatus,isposted,vouchercreator";
        voucherDateSet = voucherDateSet.leftJoin(aiVoucher).on("fid", "fid").select(leftSelect.split(","), rightSelect.split(",")).finish();
        return voucherDateSet;
    }

    private DataSet getNewVoucherDataSet() {
        QFilter voucherQ = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        HashSet<Object> set = new HashSet<Object>();
        for (DynamicObject info : this.filter_account) {
            set.add(info.getPkValue());
        }
        voucherQ.and("sourcesys", "!=", (Object)"/KIUHEXROK3D");
        voucherQ.and("entries.account", "in", set);
        voucherQ.and("org", "=", this.filter_calorg.getPkValue());
        if (this.filter_startdate != null) {
            voucherQ.and(new QFilter("bookeddate", ">=", (Object)this.filter_startdate));
        }
        if (this.filter_enddate != null) {
            voucherQ.and(new QFilter("bookeddate", "<=", (Object)this.filter_enddate));
        }
        DataSet newVoucherDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"id,billno as fivouchernum,bookeddate,billstatus,ispost as isposted,creator as vouchercreator,entries.account as account,entries.edescription as description,entries.assgrp as assgrp,entries.debitlocal as debitlocal,entries.creditlocal as creditlocal", (QFilter[])voucherQ.toArray(), null);
        newVoucherDataSet = newVoucherDataSet.groupBy(new String[]{"id", "account", "fivouchernum", "bookeddate", "billstatus", "isposted", "vouchercreator"}).maxP("assgrp", "description").max("assgrp").sum("debitlocal").sum("creditlocal").finish().select("id as glvoucherid,id as sourcebillentryid,account,fivouchernum,bookeddate,billstatus,isposted,vouchercreator,description,assgrp,creditlocal - debitlocal as tempamout1,debitlocal - creditlocal as tempamout2");
        newVoucherDataSet = newVoucherDataSet.addField("1", "orderindex");
        return newVoucherDataSet.select("glvoucherid,sourcebillentryid,account,fivouchernum,bookeddate,billstatus,isposted,vouchercreator,description,assgrp,case when tempamout2 > 0 then tempamout2 else 0 end as debitlocal,case when tempamout1 > 0 then tempamout1 else 0 end as creditlocal,orderindex");
    }

    private QFilter getFilter(boolean isCostRecord) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.filter_costAccount.getPkValue());
        if (this.filter_startdate != null) {
            q.and(new QFilter("bookdate", ">=", (Object)this.filter_startdate));
        }
        if (this.filter_enddate != null) {
            q.and(new QFilter("bookdate", "<=", (Object)this.filter_enddate));
        }
        if (this.filter_billtype != null) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_billtype) {
                set.add(info.getPkValue());
            }
            q.and("billtype", "in", set);
        }
        if (this.filter_billno != null) {
            q.and("billno", "in", (Object)this.filter_billno);
        }
        if (this.filter_storageOrg != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getPkValue());
            }
            if (isCostRecord) {
                q.and("storageorgunit", "in", set);
            } else {
                q.and("entryentity.storageorgunit", "in", set);
            }
        }
        if (!this.warehsGroupSet.isEmpty()) {
            if (isCostRecord) {
                q.and("entry.warehouse.group", "in", this.warehsGroupSet);
            } else {
                q.and("entryentity.warehouse.group", "in", this.warehsGroupSet);
            }
        }
        if (this.filter_warehouse != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getPkValue());
            }
            if (isCostRecord) {
                q.and("entry.warehouse", "in", set);
            } else {
                q.and("entryentity.warehouse", "in", set);
            }
        }
        if (this.filter_location != null) {
            set = new HashSet();
            for (DynamicObject info : this.filter_location) {
                set.add(info.getPkValue());
            }
            if (isCostRecord) {
                q.and("entry.location", "in", set);
            } else {
                q.and("entryentity.location", "in", set);
            }
        }
        if (this.filter_materialFrom != null) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getLong("id"));
                }
                if (isCostRecord) {
                    q.and("entry.material.id", "in", materialSet);
                } else {
                    q.and("entryentity.material.id", "in", materialSet);
                }
            } else if (this.filter_materialFrom.size() == 1) {
                if (isCostRecord) {
                    q.and("entry.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
                } else {
                    q.and("entryentity.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getString("number"));
                }
            }
        }
        if (this.filter_materialTo != null) {
            if (isCostRecord) {
                q.and("entry.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
            } else {
                q.and("entryentity.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
            }
        }
        if (this.filter_project != null) {
            HashSet<Long> projectSet = new HashSet<Long>();
            for (DynamicObject project : this.filter_project) {
                projectSet.add(project.getLong("id"));
            }
            if (isCostRecord) {
                q.and("entry.project.id", "in", projectSet);
            } else {
                q.and("entryentity.project.id", "in", projectSet);
            }
        }
        if (this.filter_billnumber != null) {
            if (isCostRecord) {
                q.and("billnumber", "in", (Object)this.filter_billnumber);
            } else {
                q.and("entryentity.invbillnum", "in", (Object)this.filter_billnumber);
            }
        }
        if (isCostRecord) {
            if (this.filter_biztype != null) {
                set = new HashSet();
                for (DynamicObject info : this.filter_biztype) {
                    set.add(info.getPkValue());
                }
                q.and("biztype", "in", set);
            }
            if (this.filter_invscheme != null) {
                set = new HashSet();
                for (DynamicObject info : this.filter_invscheme) {
                    set.add(info.getPkValue());
                }
                q.and("invscheme", "in", set);
            }
        }
        if (this.exFieldTypeMap.isEmpty()) {
            return q;
        }
        for (Map.Entry<String, String> mapEntry : this.exFieldTypeMap.entrySet()) {
            String[] strings;
            String str;
            String filterKeyName = mapEntry.getKey();
            String filterType = mapEntry.getValue();
            String filterName = this.exFieldNameMap.get(filterKeyName);
            boolean isEntryField = this.isExEntryField.get(filterKeyName);
            if ("MulBasedataProp".equals(filterType)) {
                DynamicObjectCollection dyc = this.filterInfo.getDynamicObjectCollection(filterKeyName);
                if (dyc == null || dyc.size() <= 0) continue;
                HashSet<Long> idSet = new HashSet<Long>(dyc.size());
                for (DynamicObject dynamicObject : dyc) {
                    idSet.add(dynamicObject.getLong("id"));
                }
                if (isEntryField) {
                    if (isCostRecord) {
                        q.and("entry." + filterName, "in", idSet);
                        continue;
                    }
                    q.and("entryentity." + filterName, "in", idSet);
                    continue;
                }
                q.and(filterName, "in", idSet);
                continue;
            }
            if ("BasedataProp".equals(filterType)) {
                DynamicObject dy = this.filterInfo.getDynamicObject(filterKeyName);
                if (dy == null) continue;
                if (isEntryField) {
                    if (isCostRecord) {
                        q.and("entry." + filterName, "=", dy.getPkValue());
                        continue;
                    }
                    q.and("entryentity." + filterName, "=", dy.getPkValue());
                    continue;
                }
                q.and(filterName, "=", dy.getPkValue());
                continue;
            }
            if (!"TextProp".equals(filterType) || !StringUtils.isNotEmpty((String)(str = this.filterInfo.getString(filterKeyName))) || (strings = str.split("[\\s\\n\\r\\;\\,]+")).length <= 0) continue;
            if (isEntryField) {
                if (isCostRecord) {
                    q.and("entry." + filterName, "in", (Object)strings);
                    continue;
                }
                q.and("entryentity." + filterName, "in", (Object)strings);
                continue;
            }
            q.and(filterName, "in", (Object)strings);
        }
        return q;
    }

    private String getCostRecordSelectFields() {
        String select = "id,isvoucher,'cal_costrecord_subentity' as billentitytype,entry.id as entryid,entry.seq as entryseq,calorg.id as calorgid,calorg.name as calorgname,costaccount.name as costaccountname,billno as billno,period.name as period,bizdate as bizdate,calbilltype as calbilltype,storageorgunit as storageorgunit,billtype as billtype,' ' as createtype,billnumber as billnumber,bizbillid as bizbillid,localcurrency as localcurrencyid,currency as currency,exchangerate as exchangerate,exratedate as exratedate,adminorg as adminorg,invorg as invorg,bizentityobject as bizentityobject,creator as creator,auditdate as auditdate,comment as comment,customer as customer,supplier as supplier,writeoffstatus as writeoffstatus,writeoffdate as writeoffdate,tempvouchernum as tempvouchernum,dischargevouchernum as dischargevouchernum,carryovervouchernum as carryovervouchernum,feevouchernum as feevouchernum,tempvoucherid as tempvoucherid,dischargevoucherid as dischargevoucherid,carryovervoucherid as carryovervoucherid,feevoucherid as feevoucherid,isinitbill as isinitbill,issplitcreate as issplitcreate,bookdate as bookdate,entry.unitmaterialcost as unitmaterialcost,entry.materialcost as materialcost,entry.unitfee as unitfee,entry.fee as fee,entry.unitprocesscost as unitprocesscost,entry.processcost as processcost,entry.unitmanufacturecost as unitmanufacturecost,entry.manufacturecost as manufacturecost,entry.unitresource as unitresource,entry.resource as resource,entry.balancesupplier as balancesupplier,entry.balancecustomer as balancecustomer,entry.calrange as calrange,entry.caldimension as caldimension,entry.accounttype as accounttype,entry.audittime as audittime,entry.baseqty as baseqty,entry.warehouse as warehouse,entry.warehouse.group as warehsgroup,entry.location as location,entry.invtype as invtype,entry.invstatus as invstatus,entry.material.number as materialnumber,entry.material as material,entry.material.modelnum as model,entry.mversion as mversion,entry.assist as assist,entry.lot as lot,entry.project as project,entry.baseunit as baseunit,entry.unitstandardcost as unitstandardcost,entry.standardcost as standardcost,entry.unitactualcost as unitactualcost,entry.actualcost as actualcost,biztype as biztype,invscheme as invscheme";
        return select;
    }

    private String getCostAdjustSelectFields() {
        String select = "id,isvoucher,'cal_costadjust_subentity' as billentitytype,entryentity.id as entryid,case when entryentity.seq = 0 then 1 else entryentity.seq end as entryseq,calorg.id as calorgid,calorg.name as calorgname,costaccount.name as costaccountname,billno as billno,period.name as period,bizdate as bizdate,biztype as calbilltype,entryentity.storageorgunit as storageorgunit,billtype as billtype,createtype as createtype,entryentity.invbillnum as billnumber,entryentity.invbillid as bizbillid,currency as localcurrencyid,currency as currency,1 as exchangerate,entryentity.invbizdate as exratedate,adminorg as adminorg,0L as invorg,case when entryentity.invbizentityobject = 'cal_costrecord' then 'cal_costrecord_subentity' else entryentity.invbizentityobject end as bizentityobject,creator as creator,auditdate as auditdate,remark as comment,case when cstype = 'bd_customer' then custsupplier else 0L end as customer,case when cstype = 'bd_supplier' then custsupplier else 0L end as supplier,' ' as writeoffstatus,null as writeoffdate,' ' as tempvouchernum,' ' as dischargevouchernum,' ' as carryovervouchernum,' ' as feevouchernum,0 as tempvoucherid,0 as dischargevoucherid,0 as carryovervoucherid,0 as feevoucherid,0 as isinitbill,0 as issplitcreate,bookdate as bookdate,0 as unitmaterialcost,0 as materialcost,0 as unitfee,0 as fee,0 as unitprocesscost,0 as processcost,0 as unitmanufacturecost,0 as manufacturecost,0 as unitresource,0 as resource,0L as balancesupplier,0L as balancecustomer,entryentity.calrange as calrange,entryentity.caldimension as caldimension,entryentity.accounttype as accounttype,auditdate as audittime,0 as baseqty,entryentity.warehouse as warehouse,entryentity.warehouse.group as warehsgroup,entryentity.location as location,entryentity.invtype as invtype,entryentity.invstatus as invstatus,entryentity.material.number as materialnumber,entryentity.material as material,entryentity.material.modelnum as model,entryentity.mversion as mversion,entryentity.assist as assist,entryentity.lot as lot,entryentity.project as project,entryentity.baseunit as baseunit,0 as unitstandardcost,case when createtype = 'C1' then entryentity.adjustamt else 0 end as standardcost,0 as unitactualcost,case when createtype = 'C1' then 0 else entryentity.adjustamt end as actualcost,entryentity.invbiztype as biztype,0L as invscheme";
        return select;
    }

    private String getStdDiffBillSelectFields() {
        String select = "id,isvoucher,'cal_stdcostdiffbill' as billentitytype,entryentity.id as entryid,case when entryentity.seq = 0 then 1 else entryentity.seq end as entryseq,calorg.id as calorgid,calorg.name as calorgname,costaccount.name as costaccountname,billno as billno,period.name as period,bizdate as bizdate,biztype as calbilltype,entryentity.storageorgunit as storageorgunit,billtype as billtype,createtype as createtype,entryentity.invbillnum as billnumber,entryentity.invbillid as bizbillid,currency as localcurrencyid,currency as currency,1 as exchangerate,entryentity.invbizdate as exratedate,adminorg as adminorg,0L as invorg,case when entryentity.invbizentityobject = 'cal_costrecord' then 'cal_costrecord_subentity' else entryentity.invbizentityobject end as bizentityobject,creator as creator,auditdate as auditdate,remark as comment,case when cstype = 'bd_customer' then custsupplier else 0L end as customer,case when cstype = 'bd_supplier' then custsupplier else 0L end as supplier,' ' as writeoffstatus,null as writeoffdate,' ' as tempvouchernum,' ' as dischargevouchernum,' ' as carryovervouchernum,' ' as feevouchernum,0 as tempvoucherid,0 as dischargevoucherid,0 as carryovervoucherid,0 as feevoucherid,0 as isinitbill,0 as issplitcreate,bookdate as bookdate,0 as unitmaterialcost,0 as materialcost,0 as unitfee,0 as fee,0 as unitprocesscost,0 as processcost,0 as unitmanufacturecost,0 as manufacturecost,0 as unitresource,0 as resource,0L as balancesupplier,0L as balancecustomer,entryentity.calrange as calrange,entryentity.caldimension as caldimension,entryentity.accounttype as accounttype,auditdate as audittime,0 as baseqty,entryentity.warehouse as warehouse,entryentity.warehouse.group as warehsgroup,entryentity.location as location,entryentity.invtype as invtype,entryentity.invstatus as invstatus,entryentity.material.number as materialnumber,entryentity.material as material,entryentity.material.modelnum as model,entryentity.mversion as mversion,entryentity.assist as assist,entryentity.lot as lot,entryentity.project as project,entryentity.baseunit as baseunit,0 as unitstandardcost,case when createtype in ('C1','G') then entryentity.adjustamt else 0 end as standardcost,0 as unitactualcost, case when createtype = 'C1' then 0 else entryentity.adjustamt end as actualcost,entryentity.invbiztype as biztype,0L as invscheme";
        return select;
    }

    private List<Set<Object>> getEntryIds(DataSet dataSet, String idName, String entityName) {
        HashSet<Object> entryIds = null;
        ArrayList<Set<Object>> entryIdsArray = new ArrayList<Set<Object>>(16);
        if (dataSet == null || dataSet.isEmpty()) {
            return entryIdsArray;
        }
        long index = 0L;
        for (Row row : dataSet) {
            if (index % 100000L == 0L) {
                entryIds = new HashSet<Object>();
                entryIdsArray.add(entryIds);
            }
            if (entryIds != null) {
                entryIds.add(row.get(idName));
                if (entityName != null && "cal_costrecord_subentity".equals(entityName)) {
                    this.recordIds.add(row.get("id"));
                }
            }
            ++index;
        }
        return entryIdsArray;
    }

    private Set<Object> getSetEntryIds(DataSet dataSet, String idName) {
        HashSet<Object> entryIds = new HashSet<Object>();
        if (dataSet == null || dataSet.isEmpty()) {
            return entryIds;
        }
        for (Row row : dataSet) {
            entryIds.add(row.get(idName));
        }
        return entryIds;
    }

    private void getCostRecordFilter(String entryString) {
        String[] entryArray = entryString.split(",,");
        ArrayList<String> RecordFilterList = new ArrayList<String>();
        ArrayList<String> AdjustFilterList = new ArrayList<String>();
        ArrayList<String> diffBillFilterList = new ArrayList<String>();
        for (int i = 0; i < entryArray.length; ++i) {
            String tmp = entryArray[i];
            String[] tmps = tmp.split("::");
            String entityObjectId = tmps[0];
            String billFilter = tmps[1];
            if ("cal_costrecord_subentity".equals(entityObjectId) || "cal_costrecord".equals(entityObjectId)) {
                RecordFilterList.add(billFilter);
                continue;
            }
            if ("cal_costadjust_subentity".equals(entityObjectId) || "cal_costadjustbill".equals(entityObjectId)) {
                AdjustFilterList.add(billFilter);
                continue;
            }
            if (!"cal_stdcostdiffbill".equals(entityObjectId)) continue;
            diffBillFilterList.add(billFilter);
        }
        this.filter_costRecord = this.getSchemeFilter(RecordFilterList, "cal_costrecord_subentity");
        this.filter_costAdjust = this.getSchemeFilter(AdjustFilterList, "cal_costadjust_subentity");
        this.filter_stdDiffBill = this.getSchemeFilter(diffBillFilterList, "cal_stdcostdiffbill");
    }

    private Set<QFilter> getSchemeFilter(List<String> filterList, String objectNumber) {
        if (filterList.isEmpty()) {
            return null;
        }
        HashSet<QFilter> filterSet = new HashSet<QFilter>(16);
        for (String filterStr : filterList) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            FilterCondition filterCondition = condition.getFilterCondition();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)objectNumber);
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
            filterBuilder.buildFilter();
            QFilter baseQ = filterBuilder.getQFilter();
            String experss = condition.getExpression();
            if (!"".equals(experss)) {
                QFilter expressFilter = QFilter.of((String)experss, (Object[])new Object[0]);
                if (baseQ != null) {
                    baseQ.and(expressFilter);
                } else {
                    baseQ = expressFilter;
                }
            }
            QFilter valiteQ = baseQ.copy();
            if ("cal_costrecord_subentity".equals(objectNumber)) {
                valiteQ.and("costaccount", "=", (Object)0L);
                valiteQ.and("bookdate", "=", (Object)new Date());
            }
            try {
                QueryServiceHelper.query((String)objectNumber, (String)"id", (QFilter[])valiteQ.toArray());
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u8f93\u5165\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u67e5\u8be2\u3002", (String)"TransactionDetailRptQueryPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            }
            filterSet.add(baseQ);
        }
        return filterSet;
    }

    private void setExtFilter() {
        MainEntityType billEntity = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity");
        MainEntityType rptEntity = MetadataServiceHelper.getDataEntityType((String)"cal_transactiondetailrpt");
        DynamicObject calSettingObject = QueryServiceHelper.queryOne((String)"cal_setting", (String)"costrecordextcols", (QFilter[])QFilter.of((String)"1 = 1", (Object[])new Object[0]).toArray());
        String extFields = (String)calSettingObject.get("costrecordextcols");
        if ("".equals(extFields)) {
            return;
        }
        for (String extField : extFields.split(",")) {
            IDataEntityProperty extFieldProperty = rptEntity.findProperty(extField + "_ft");
            if (extFieldProperty == null) continue;
            this.exFieldNameMap.put(extField + "_ft", extField);
            IDataEntityProperty billFieldProperty = billEntity.findProperty(extField);
            if (billFieldProperty.getParent() instanceof EntryType) {
                this.isExEntryField.put(extField + "_ft", Boolean.TRUE);
            } else {
                this.isExEntryField.put(extField + "_ft", Boolean.FALSE);
            }
            if (extFieldProperty instanceof MulBasedataProp) {
                this.exFieldTypeMap.put(extField + "_ft", "MulBasedataProp");
                continue;
            }
            if (extFieldProperty instanceof BasedataProp) {
                this.exFieldTypeMap.put(extField + "_ft", "BasedataProp");
                continue;
            }
            if (!(extFieldProperty instanceof TextProp)) continue;
            this.exFieldTypeMap.put(extField + "_ft", "TextProp");
        }
    }

    private void setExtCols() {
        MainEntityType billEntity = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity");
        MainEntityType rptEntity = MetadataServiceHelper.getDataEntityType((String)"cal_transactiondetailrpt");
        DynamicObject calSettingObject = QueryServiceHelper.queryOne((String)"cal_setting", (String)"costrecordextcols", (QFilter[])QFilter.of((String)"1 = 1", (Object[])new Object[0]).toArray());
        String extFields = (String)calSettingObject.get("costrecordextcols");
        if (extFields == null) {
            return;
        }
        for (String extField : extFields.split(",")) {
            IDataEntityProperty extFieldProperty = rptEntity.findProperty(extField);
            if (extFieldProperty == null) continue;
            IDataEntityProperty billFieldProperty = billEntity.findProperty(extField);
            if (billFieldProperty.getParent() instanceof EntryType) {
                String recordSelectField = "entry." + extField + " as " + extField + ",";
                String adjustSelectField = "entryentity." + extField + " as " + extField + ",";
                this.exRecordSelectFields.append(recordSelectField);
                this.exAdjustSelectFields.append(adjustSelectField);
                continue;
            }
            String SelectField = extField + " as " + extField + ",";
            this.exRecordSelectFields.append(SelectField);
            this.exAdjustSelectFields.append(SelectField);
        }
    }

    private DataSet dealOrderAndOtherFields(DataSet dataSet) {
        dataSet = dataSet.addField("'gl_voucher' as vouchertype", "vouchertype");
        String[] selectNames = dataSet.getRowMeta().getFieldNames();
        for (int i = 0; i < selectNames.length; ++i) {
            if ("orderindex".equals(selectNames[i])) {
                selectNames[i] = "case when orderindex = 1 then 1 else 0 end as orderindex";
            }
            if (!"fivouchernum".equals(selectNames[i])) continue;
            selectNames[i] = "case when (carryovervouchernum = '' or carryovervouchernum = null) and (tempvouchernum =  '' or tempvouchernum = null) and (dischargevouchernum = '' or dischargevouchernum = null) and (feevouchernum = '' or feevouchernum = null) then fivouchernum else '' end as fivouchernum";
        }
        dataSet = dataSet.select(selectNames);
        dataSet = dataSet.orderBy(new String[]{"orderindex", "bookdate", "audittime", "billnumber", "billno", "entryseq"});
        return dataSet;
    }
}

