/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.treereport.diffanalysisrpt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.report.treereport.diffanalysisrpt.DiffAnalysisRptParam;
import kd.fi.cal.report.treereport.diffanalysisrpt.DiffAnalysisRptRowGroup;
import kd.fi.cal.report.treereport.diffanalysisrpt.enums.DiffAnalysisRptBillTypeEnum;
import kd.fi.cal.report.treereport.diffanalysisrpt.enums.DiffAnalysisRptNodeEnum;

public class DiffAnalysisRptHelper {
    public static DiffAnalysisRptParam initQueryParam(ReportQueryParam param) {
        Object auxPtyIds;
        DiffAnalysisRptParam rptParams = new DiffAnalysisRptParam();
        FilterInfo filterInfo = param.getFilter();
        DynamicObject storageorg = filterInfo.getDynamicObject("storageorg");
        DynamicObject warehouse = filterInfo.getDynamicObject("warehouse");
        DynamicObject location = filterInfo.getDynamicObject("location");
        DynamicObject mulcalorg = filterInfo.getDynamicObject("mulcalorg");
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        DynamicObject material = filterInfo.getDynamicObject("mulmaterial");
        DynamicObject tracknumber = filterInfo.getDynamicObject("multracknumber");
        DynamicObject project = filterInfo.getDynamicObject("mulproject");
        DynamicObject configuredcode = filterInfo.getDynamicObject("mulconfiguredcode");
        DynamicObject period = filterInfo.getDynamicObject("period");
        String lot = filterInfo.getString("filter_lot");
        int periodInt = period.getInt("periodyear") * 100 + period.getInt("periodnumber");
        Map paramMap = param.getCustomParam();
        if (paramMap != null && (auxPtyIds = paramMap.get("auxptyid")) != null) {
            rptParams.setAuxptyIds((List)auxPtyIds);
        }
        rptParams.setCalOrgId(mulcalorg.getLong("id"));
        rptParams.setCostAccountId(costaccount.getLong("id"));
        rptParams.setMaterialId(material.getLong("id"));
        rptParams.setPeriodId(period.getLong("id"));
        rptParams.setPeriodInt(periodInt);
        rptParams.setStartdate(period.getDate("begindate"));
        rptParams.setEnddate(period.getDate("enddate"));
        rptParams.setLot(lot);
        rptParams.setStorageOrgId(storageorg == null ? null : Long.valueOf(storageorg.getLong("id")));
        rptParams.setWarehouseId(warehouse == null ? null : Long.valueOf(warehouse.getLong("id")));
        rptParams.setLocationId(location == null ? null : Long.valueOf(location.getLong("id")));
        rptParams.setTracknumberId(tracknumber == null ? null : Long.valueOf(tracknumber.getLong("id")));
        rptParams.setProjectId(project == null ? null : Long.valueOf(project.getLong("id")));
        rptParams.setConfiguredcodeId(configuredcode == null ? null : Long.valueOf(configuredcode.getLong("id")));
        return rptParams;
    }

    public static RowMeta getAllFieldsRowMeta() {
        QFilter recordQ = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        recordQ.and("id", "=", (Object)0L);
        recordQ.and("bookdate", "=", (Object)DateUtils.getCurrentSystemDate());
        StringBuilder allFieldBuild = new StringBuilder();
        allFieldBuild.append("'' as bizobject,");
        allFieldBuild.append("id as billid,");
        allFieldBuild.append("entry.material as material,");
        allFieldBuild.append("billtype.name as billtypename,");
        allFieldBuild.append("billno,");
        allFieldBuild.append("fivouchernum as vouchernum,");
        allFieldBuild.append("fivoucherid as voucherid,");
        allFieldBuild.append("entry.baseqty as qty,");
        allFieldBuild.append("entry.baseunit as baseunit,");
        allFieldBuild.append("localcurrency as currency,");
        allFieldBuild.append("entry.standardcost as standardamt,");
        allFieldBuild.append("entry.unitstandardcost as standprice,");
        allFieldBuild.append("entry.actualcost as actualamt,");
        allFieldBuild.append("entry.unitactualcost as actualprice,");
        allFieldBuild.append("entry.standardcost - entry.actualcost as diff,");
        allFieldBuild.append("'' as pid,");
        allFieldBuild.append("'' as rowid,");
        allFieldBuild.append("0 as isgroupnode,");
        allFieldBuild.append("'' as rowtype");
        allFieldBuild.append(",0l as groupbillid,");
        allFieldBuild.append("0l as ordertracknumid,");
        allFieldBuild.append("0l as ordermatid");
        allFieldBuild.append(",bookdate,auditdate");
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)"query-buildrowmeta", (String)"cal_costrecord_subentity", (String)allFieldBuild.toString(), (QFilter[])recordQ.toArray(), null);
        return recordDataSet.getRowMeta();
    }

    public static QFilter buildCommonFilter(String entityNum, DiffAnalysisRptParam rptParam) {
        List<Object> auxptyIds;
        String entryName = "entry.";
        if (entityNum.equals("cal_stdcostdiffbill")) {
            entryName = "entryentity.";
        }
        QFilter q = new QFilter("costaccount", "=", (Object)rptParam.getCostAccountId());
        q.and("billstatus", "=", (Object)"C");
        q.and("calorg", "=", (Object)rptParam.getCalOrgId());
        q.and("period", "=", (Object)rptParam.getPeriodId());
        q.and("bookdate", ">=", (Object)rptParam.getStartdate());
        q.and("bookdate", "<=", (Object)rptParam.getEnddate());
        q.and(entryName + "material", "=", (Object)rptParam.getMaterialId());
        if (rptParam.getStorageOrgId() != null) {
            if (entityNum.equals("cal_stdcostdiffbill")) {
                q.and(entryName + "storageorgunit", "=", (Object)rptParam.getStorageOrgId());
            } else {
                q.and("storageorgunit", "=", (Object)rptParam.getStorageOrgId());
            }
        }
        if (rptParam.getWarehouseId() != null) {
            q.and(entryName + "warehouse", "=", (Object)rptParam.getWarehouseId());
        }
        if (rptParam.getLocationId() != null) {
            q.and(entryName + "location", "=", (Object)rptParam.getLocationId());
        }
        if (rptParam.getTracknumberId() != null) {
            q.and(entryName + "tracknumber", "=", (Object)rptParam.getTracknumberId());
        }
        if (rptParam.getProjectId() != null) {
            q.and(entryName + "project", "=", (Object)rptParam.getProjectId());
        }
        if (rptParam.getConfiguredcodeId() != null) {
            q.and(entryName + "configuredcode", "=", (Object)rptParam.getConfiguredcodeId());
        }
        if (StringUtils.isNotEmpty((CharSequence)rptParam.getLot())) {
            q.and(entryName + "lot", "=", (Object)rptParam.getLot());
        }
        if (entityNum.equals("cal_stdcostdiffbill")) {
            q.and(entryName + "adjustamt", "!=", (Object)BigDecimal.ZERO);
        }
        if ((auxptyIds = rptParam.getAuxptyIds()) != null) {
            q.and(entryName + "assist", "in", auxptyIds);
        }
        return q;
    }

    public static String getSelectByRowMeta(Map<String, String> replaceMap, RowMeta rowMeta) {
        StringBuilder selectBuild = new StringBuilder();
        for (String field : rowMeta.getFieldNames()) {
            if (replaceMap != null) {
                for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
                    String key = entry.getKey();
                    if (!field.equals(key)) continue;
                    field = replaceMap.get(key);
                }
            }
            selectBuild.append(field);
            selectBuild.append(",");
        }
        return CommonUtils.trimComma((String)selectBuild.toString());
    }

    public static String getDiffBillBaseSelect() {
        StringBuilder diffSelectBuilder = new StringBuilder();
        diffSelectBuilder.append("entryentity.id as id,bookdate,auditdate,");
        diffSelectBuilder.append("'");
        diffSelectBuilder.append("cal_stdcostdiffbill");
        diffSelectBuilder.append("' as bizobject,");
        diffSelectBuilder.append("id as billid,");
        diffSelectBuilder.append("entryentity.groupdiffbillid as groupbillid,");
        diffSelectBuilder.append("entryentity.material as material,");
        diffSelectBuilder.append("billtype.name as billtypename,");
        diffSelectBuilder.append("billno,");
        diffSelectBuilder.append("vouchernum,");
        diffSelectBuilder.append("voucherid,");
        diffSelectBuilder.append("0 as qty,");
        diffSelectBuilder.append("entryentity.baseunit as baseunit,");
        diffSelectBuilder.append("currency,");
        diffSelectBuilder.append("0 as standardamt,");
        diffSelectBuilder.append("0 as standprice,");
        diffSelectBuilder.append("0 as actualamt,");
        diffSelectBuilder.append("0 as actualprice,");
        diffSelectBuilder.append("0 as diff");
        return diffSelectBuilder.toString();
    }

    public static String getRecordBillBaseSelect() {
        StringBuilder recordSelectBuilder = new StringBuilder();
        recordSelectBuilder.append("entry.id as id,bookdate,auditdate,");
        recordSelectBuilder.append("'");
        recordSelectBuilder.append("cal_costrecord_subentity");
        recordSelectBuilder.append("' as bizobject,");
        recordSelectBuilder.append("id as billid,");
        recordSelectBuilder.append("0l as groupbillid,");
        recordSelectBuilder.append("entry.material as material,");
        recordSelectBuilder.append("billtype.name as billtypename,");
        recordSelectBuilder.append("billno,");
        recordSelectBuilder.append("fivouchernum as vouchernum,");
        recordSelectBuilder.append("fivoucherid as voucherid,");
        recordSelectBuilder.append("entry.baseqty as qty,");
        recordSelectBuilder.append("entry.baseunit as baseunit,");
        recordSelectBuilder.append("localcurrency as currency,");
        recordSelectBuilder.append("entry.standardcost as standardamt,");
        recordSelectBuilder.append("entry.unitstandardcost as standprice,");
        recordSelectBuilder.append("entry.actualcost as actualamt,");
        recordSelectBuilder.append("entry.unitactualcost as actualprice,");
        recordSelectBuilder.append("entry.actualcost - entry.standardcost as diff");
        return recordSelectBuilder.toString();
    }

    public static String getRecordBill4SpecialInBaseSelect() {
        String baseSelect = DiffAnalysisRptHelper.getRecordBillBaseSelect();
        baseSelect = baseSelect.replace("entry.baseqty as qty", "case when calbilltype = 'OUT' then entry.baseqty * -1 else entry.baseqty end as qty");
        baseSelect = baseSelect.replace("entry.standardcost as standardamt", "case when calbilltype = 'OUT' then entry.standardcost * -1 else entry.standardcost end as standardamt");
        baseSelect = baseSelect.replace("entry.unitstandardcost as standprice", "entry.unitstandardcost as standprice");
        baseSelect = baseSelect.replace("entry.actualcost as actualamt", "case when calbilltype = 'OUT' then entry.actualcost * -1 else entry.actualcost end as actualamt");
        baseSelect = baseSelect.replace("entry.unitactualcost as actualprice", "entry.unitactualcost as actualprice");
        baseSelect = baseSelect.replace("entry.actualcost - entry.standardcost as diff", "case when calbilltype = 'OUT' then (entry.actualcost - entry.standardcost) * -1 else entry.actualcost - entry.standardcost end as diff");
        return baseSelect;
    }

    public static String getRecordBill4SaleOutSelect() {
        String baseSelect = DiffAnalysisRptHelper.getRecordBillBaseSelect();
        baseSelect = baseSelect + ",entry.tracknumber.number as tracknumber, entry.tracknumber as tracknumberid";
        return baseSelect;
    }

    public static String getRecordBill4ProduceOutSelect() {
        StringBuilder recordBuilder = new StringBuilder();
        recordBuilder.append(DiffAnalysisRptHelper.getRecordBillBaseSelect());
        recordBuilder.append(",bizentityobject");
        recordBuilder.append(",entry.mainbillid as srcbillid");
        recordBuilder.append(",entry.mainbillentryid as srcbillentryid");
        return recordBuilder.toString();
    }

    public static String getRecordBill4CostCenterSelect() {
        String baseSelect = DiffAnalysisRptHelper.getRecordBillBaseSelect();
        baseSelect = baseSelect + ",entry.ecostcenter.number as costcenternum, entry.ecostcenter.name as costcentername";
        return baseSelect;
    }

    public static String getDiffBill4PdBeginSelect(String billTypeName) {
        String baseSelect = DiffAnalysisRptHelper.getDiffBillBaseSelect();
        baseSelect = baseSelect.replace("billtype.name as billtypename", "'" + billTypeName + "' as billtypename");
        baseSelect = baseSelect.replace("0 as standardamt", "entryentity.adjustamt * -1 as standardamt");
        baseSelect = baseSelect.replace("0 as diff", "entryentity.adjustamt as dif");
        return baseSelect;
    }

    public static String getDiffBill4PurInSelect(String noSharebillTypeName) {
        MainEntityType adjustEntity = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        ComboProp createTypeProperty = (ComboProp)adjustEntity.findProperty("createtype");
        List propComboItems = createTypeProperty.getComboItems();
        StringBuilder createTypetBuilder = new StringBuilder();
        createTypetBuilder.append("case");
        for (ValueMapItem valueMapItem : propComboItems) {
            String value = valueMapItem.getValue();
            createTypetBuilder.append(" when createtype = '");
            createTypetBuilder.append(value);
            createTypetBuilder.append("' then ");
            if ("W".equals(value) || "X".equals(value)) {
                createTypetBuilder.append("'");
                createTypetBuilder.append(noSharebillTypeName);
                createTypetBuilder.append("'");
                continue;
            }
            createTypetBuilder.append(DiffAnalysisRptHelper.getStdcostdiffbillCreateTypeStr(value));
        }
        createTypetBuilder.append(" else ").append(DiffAnalysisRptHelper.getStdcostdiffbillCreateTypeStr("#"));
        createTypetBuilder.append(" end as billtypename");
        String baseSelect = DiffAnalysisRptHelper.getDiffBillBaseSelect();
        baseSelect = baseSelect.replace("billtype.name as billtypename", createTypetBuilder.toString());
        baseSelect = baseSelect.replace("0 as diff", "case when isupdatecost = '1' then entryentity.adjustamt else entryentity.adjustamt * -1 end as diff");
        return baseSelect;
    }

    public static String getDiffBill4TransInSelect() {
        MainEntityType adjustEntity = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        ComboProp createTypeProperty = (ComboProp)adjustEntity.findProperty("createtype");
        List propComboItems = createTypeProperty.getComboItems();
        StringBuilder createTypetBuilder = new StringBuilder();
        createTypetBuilder.append("case");
        for (ValueMapItem valueMapItem : propComboItems) {
            String value = valueMapItem.getValue();
            createTypetBuilder.append(" when createtype = '");
            createTypetBuilder.append(value);
            createTypetBuilder.append("' then ");
            createTypetBuilder.append(DiffAnalysisRptHelper.getStdcostdiffbillCreateTypeStr(value));
        }
        createTypetBuilder.append(" else ").append(DiffAnalysisRptHelper.getStdcostdiffbillCreateTypeStr("#"));
        createTypetBuilder.append(" end as billtypename");
        String baseSelect = DiffAnalysisRptHelper.getDiffBillBaseSelect();
        baseSelect = baseSelect.replace("billtype.name as billtypename", createTypetBuilder.toString());
        baseSelect = baseSelect.replace("0 as diff", "entryentity.adjustamt as diff");
        baseSelect = baseSelect + ",case when entryentity.transtype = 'A' then entryentity.transtype else 'B' end as transtype";
        return baseSelect;
    }

    public static String getDiffBill4ProduceSelect() {
        MainEntityType adjustEntity = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        ComboProp createTypeProperty = (ComboProp)adjustEntity.findProperty("createtype");
        List propComboItems = createTypeProperty.getComboItems();
        StringBuilder createTypetBuilder = new StringBuilder();
        createTypetBuilder.append("case");
        for (ValueMapItem valueMapItem : propComboItems) {
            String value = valueMapItem.getValue();
            createTypetBuilder.append(" when createtype = '");
            createTypetBuilder.append(value);
            createTypetBuilder.append("' then ");
            createTypetBuilder.append(DiffAnalysisRptHelper.getStdcostdiffbillCreateTypeStr(value));
        }
        createTypetBuilder.append(" else ").append(DiffAnalysisRptHelper.getStdcostdiffbillCreateTypeStr("#"));
        createTypetBuilder.append(" end as billtypename");
        String baseSelect = DiffAnalysisRptHelper.getDiffBillBaseSelect();
        baseSelect = baseSelect.replace("billtype.name as billtypename", createTypetBuilder.toString());
        baseSelect = baseSelect.replace("0 as diff", "entryentity.adjustamt as diff");
        return baseSelect;
    }

    public static String getDiffBill4OtherInSelect() {
        return DiffAnalysisRptHelper.getDiffBill4ProduceSelect();
    }

    public static String getDiffBill4SpecialInSelect() {
        MainEntityType adjustEntity = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        ComboProp createTypeProperty = (ComboProp)adjustEntity.findProperty("createtype");
        List propComboItems = createTypeProperty.getComboItems();
        StringBuilder createTypetBuilder = new StringBuilder();
        createTypetBuilder.append("case");
        for (ValueMapItem valueMapItem : propComboItems) {
            String value = valueMapItem.getValue();
            createTypetBuilder.append(" when createtype = '");
            createTypetBuilder.append(value);
            createTypetBuilder.append("' then ");
            createTypetBuilder.append(DiffAnalysisRptHelper.getStdcostdiffbillCreateTypeStr(value));
        }
        createTypetBuilder.append(" else ").append(DiffAnalysisRptHelper.getStdcostdiffbillCreateTypeStr("#"));
        createTypetBuilder.append(" end as billtypename");
        String baseSelect = DiffAnalysisRptHelper.getDiffBillBaseSelect();
        baseSelect = baseSelect.replace("billtype.name as billtypename", createTypetBuilder.toString());
        baseSelect = baseSelect.replace("0 as diff", "case when biztype = 'B' then entryentity.adjustamt * -1 else entryentity.adjustamt end as diff");
        return baseSelect;
    }

    public static String getDiffBill4SaleOutSelect() {
        String saleOutSelect = DiffAnalysisRptHelper.getDiffBill4ProduceSelect();
        saleOutSelect = saleOutSelect + ",entryentity.tracknumber.number as tracknumber, entryentity.tracknumber as tracknumberid";
        saleOutSelect = saleOutSelect.replace("entryentity.adjustamt as diff", "case when createtype = 'G' then 0 else entryentity.adjustamt end as diff");
        saleOutSelect = saleOutSelect.replace("0 as standardamt", "case when createtype = 'G' then entryentity.adjustamt else 0 end as standardamt");
        return saleOutSelect;
    }

    public static String getDiffBill4ProduceOutSelect() {
        StringBuilder selectBuilder = new StringBuilder();
        selectBuilder.append(DiffAnalysisRptHelper.getDiffBill4ProduceSelect());
        selectBuilder.append(",'' as bizentityobject");
        selectBuilder.append(",entryentity.invbillid as srcbillid");
        selectBuilder.append(",entryentity.invbillentryid as srcbillentryid");
        return selectBuilder.toString();
    }

    public static String getDiffBill4SCostCenterSelect() {
        String saleOutSelect = DiffAnalysisRptHelper.getDiffBill4ProduceSelect();
        saleOutSelect = saleOutSelect + ",entryentity.ecostcenter.number as costcenternum, entryentity.ecostcenter.name as costcentername";
        return saleOutSelect;
    }

    private static String getStdcostdiffbillCreateTypeStr(String type) {
        MainEntityType adjustEntity = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        ComboProp createTypeProperty = (ComboProp)adjustEntity.findProperty("createtype");
        List propComboItems = createTypeProperty.getComboItems();
        String title = ResManager.loadKDString((String)"\u672a\u77e5\u7684\u521b\u5efa\u7c7b\u578b\u3002", (String)"StockDifferDetailRptQueryPlugin_2", (String)"fi-cal-report", (Object[])new Object[0]);
        for (ValueMapItem valueMapItem : propComboItems) {
            String value = valueMapItem.getValue();
            if (!type.equals(value)) continue;
            title = valueMapItem.getName().toString();
        }
        String createTypeName = ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355(%1$s)", (String)"StockDifferDetailRptQueryPlugin_4", (String)"fi-cal-report", (Object[])new Object[0]);
        return String.format("'" + createTypeName + "'", title);
    }

    public static void buildGroupData(List<Object[]> rowList, Map<String, DiffAnalysisRptRowGroup> rowGroup, RowMeta rowmeta) {
        DiffAnalysisRptRowGroup periodBeginGroup = rowGroup.get(DiffAnalysisRptNodeEnum.PERIODBEGIN.getValue());
        DiffAnalysisRptHelper.buildData(rowList, periodBeginGroup, rowmeta);
        DiffAnalysisRptRowGroup periodInGroup = rowGroup.get(DiffAnalysisRptNodeEnum.PERIODIN.getValue());
        DiffAnalysisRptHelper.buildData(rowList, periodInGroup, rowmeta);
        DiffAnalysisRptRowGroup periodAccrueGroup = rowGroup.get(DiffAnalysisRptNodeEnum.PERIODACCRUE.getValue());
        DiffAnalysisRptHelper.buildData(rowList, periodAccrueGroup, rowmeta);
        DiffAnalysisRptRowGroup periodOutGroup = rowGroup.get(DiffAnalysisRptNodeEnum.PERIODOUT.getValue());
        DiffAnalysisRptHelper.buildData(rowList, periodOutGroup, rowmeta);
        DiffAnalysisRptRowGroup periodEndGroup = rowGroup.get(DiffAnalysisRptNodeEnum.PERIODEND.getValue());
        DiffAnalysisRptHelper.buildData(rowList, periodEndGroup, rowmeta);
    }

    public static void buildData(List<Object[]> rowList, DiffAnalysisRptRowGroup rowGroup, RowMeta rowmeta) {
        Object[] sumData = DiffAnalysisRptHelper.buildSumData(rowGroup, rowmeta);
        rowList.add(sumData);
        if (rowGroup.getSonRowGroup() != null && !rowGroup.getSonRowGroup().isEmpty()) {
            List<DiffAnalysisRptRowGroup> sonRowGroups = rowGroup.getSonRowGroup();
            for (DiffAnalysisRptRowGroup sonRowGroup : sonRowGroups) {
                DiffAnalysisRptHelper.buildData(rowList, sonRowGroup, rowmeta);
            }
        } else {
            List<Object[]> dtlDataList = DiffAnalysisRptHelper.buildDtlData(rowGroup, rowmeta);
            if (!dtlDataList.isEmpty()) {
                rowList.addAll(dtlDataList);
            }
        }
    }

    public static DataSet putTopRowGroup(String pid, String rowId, String rowType, DataSet sumDS, List<DiffAnalysisRptRowGroup> sonGroups, Map<String, DiffAnalysisRptRowGroup> rowGroupMap) {
        DataSet sumRowDS = DiffAnalysisRptHelper.getGroupDataSet(sumDS);
        sumRowDS = DiffAnalysisRptHelper.reCalActualAmt(sumRowDS);
        DataSet sumRowDSCopy = sumRowDS.copy();
        DiffAnalysisRptRowGroup rowGroup = DiffAnalysisRptHelper.createRowGroup(pid, rowId, rowType, sumRowDS, sonGroups, null, null);
        rowGroupMap.put(rowId, rowGroup);
        return sumRowDSCopy;
    }

    public static DataSet putTopRowGroup(String pid, String rowId, String rowType, DataSet dtlDs, Map<String, DiffAnalysisRptRowGroup> rowGroupMap) {
        RowMeta dtlRowmeta = dtlDs.getRowMeta();
        DataSet sumRowDS = DiffAnalysisRptHelper.getGroupDataSet(dtlDs.copy());
        dtlDs = dtlDs.orderBy(new String[]{"bizobject", "billno"});
        ArrayList<Row> sonRows = new ArrayList<Row>(16);
        for (Row row : dtlDs) {
            sonRows.add(row);
        }
        DataSet sumRowDSCopy = sumRowDS.copy();
        DiffAnalysisRptRowGroup rowGroup = DiffAnalysisRptHelper.createRowGroup(pid, rowId, rowType, sumRowDS, null, dtlRowmeta, sonRows);
        rowGroupMap.put(rowId, rowGroup);
        return sumRowDSCopy;
    }

    public static DataSet collectRowGroup4SumData(String pid, String rowId, String rowType, DataSet sumDS, List<DiffAnalysisRptRowGroup> sonGroups, List<DiffAnalysisRptRowGroup> parentGroups) {
        DataSet sumRowDS = DiffAnalysisRptHelper.getGroupDataSet(sumDS);
        if (sumRowDS.copy().isEmpty()) {
            return sumRowDS;
        }
        DataSet sumRowDSCopy = sumRowDS.copy();
        DiffAnalysisRptRowGroup rowGroup = DiffAnalysisRptHelper.createRowGroup(pid, rowId, rowType, sumRowDS, sonGroups, null, null);
        parentGroups.add(rowGroup);
        return sumRowDSCopy;
    }

    public static DataSet collectRowGroup4DtlData(String pid, String rowId, String rowType, DataSet dtlDS, List<DiffAnalysisRptRowGroup> sonRowGroups) {
        RowMeta dtlRowmeta = dtlDS.getRowMeta();
        DataSet sumRowDS = DiffAnalysisRptHelper.getGroupDataSet(dtlDS.copy());
        sumRowDS = DiffAnalysisRptHelper.reCalActualAmt(sumRowDS);
        dtlDS = dtlDS.orderBy(new String[]{"bizobject", "billno"});
        ArrayList<Row> sonRows = new ArrayList<Row>(16);
        for (Row row : dtlDS) {
            sonRows.add(row);
        }
        if (sonRows.isEmpty()) {
            return sumRowDS;
        }
        DataSet sumRowDSCopy = sumRowDS.copy();
        DiffAnalysisRptRowGroup rowGroup = DiffAnalysisRptHelper.createRowGroup(pid, rowId, rowType, sumRowDS, null, dtlRowmeta, sonRows);
        sonRowGroups.add(rowGroup);
        return sumRowDSCopy;
    }

    public static DataSet setAmountFieldsType(DataSet dataSet) {
        dataSet.getRowMeta().getField("diff").setDataType((DataType)new BigDecimalType());
        dataSet.getRowMeta().getField("qty").setDataType((DataType)new BigDecimalType());
        dataSet.getRowMeta().getField("standardamt").setDataType((DataType)new BigDecimalType());
        dataSet.getRowMeta().getField("standprice").setDataType((DataType)new BigDecimalType());
        dataSet.getRowMeta().getField("actualamt").setDataType((DataType)new BigDecimalType());
        dataSet.getRowMeta().getField("actualprice").setDataType((DataType)new BigDecimalType());
        return dataSet;
    }

    private static DataSet getGroupDataSet(DataSet sumRowDS) {
        List<String> fieldList = Arrays.asList(sumRowDS.getRowMeta().getFieldNames());
        GroupbyDataSet groupDs = sumRowDS.groupBy(new String[]{"material"}).max("baseunit").max("currency").sum("qty").sum("standardamt").sum("standprice").sum("actualamt").sum("actualprice").sum("diff");
        if (fieldList.contains("ordermatid")) {
            groupDs = groupDs.max("ordertracknumid").max("ordermatid");
        }
        sumRowDS = groupDs.finish();
        StringBuilder calPriceBuilder = new StringBuilder();
        calPriceBuilder.append("material,baseunit,currency,qty,standardamt,actualamt,diff,");
        calPriceBuilder.append("case when qty != 0 then standardamt / qty else 0 end as standprice,");
        calPriceBuilder.append("case when qty != 0 then actualamt / qty else 0 end as actualprice");
        if (fieldList.contains("ordermatid")) {
            calPriceBuilder.append(",ordertracknumid,ordermatid");
        }
        sumRowDS = sumRowDS.select(calPriceBuilder.toString());
        return sumRowDS;
    }

    public static DiffAnalysisRptRowGroup createRowGroup(String pid, String rowId, String rowType, DataSet sumRowDS, List<DiffAnalysisRptRowGroup> sonRowGroup, RowMeta dtlRowmeta, List<Row> sonRows) {
        DiffAnalysisRptRowGroup rowGroup = new DiffAnalysisRptRowGroup();
        rowGroup.setPid(pid);
        rowGroup.setRowId(rowId);
        rowGroup.setIsGroupNode(1);
        if (!pid.equals(DiffAnalysisRptNodeEnum.PERIODOUT_PRODUCEOUT.getValue()) && !pid.equals(DiffAnalysisRptNodeEnum.PERIODOUT_WIP.getValue()) || rowId.equals(DiffAnalysisRptNodeEnum.PERIODOUT_PERIODOUT_MATTRACK_NULL.getValue())) {
            rowType = "<nolink>" + rowType;
        }
        rowGroup.setRowType(rowType);
        if (sumRowDS != null && !sumRowDS.isEmpty()) {
            rowGroup.setSumRowMeta(sumRowDS.getRowMeta());
            rowGroup.setGroupSumRow((Row)sumRowDS.iterator().next());
        }
        if (sonRows != null && !sonRows.isEmpty()) {
            rowGroup.setSonRowMeta(dtlRowmeta);
            rowGroup.setSonRows(sonRows);
        } else if (sonRowGroup != null && !sonRowGroup.isEmpty()) {
            rowGroup.setSonRowGroup(sonRowGroup);
        } else {
            rowGroup.setIsGroupNode(0);
        }
        return rowGroup;
    }

    private static Object[] buildSumData(DiffAnalysisRptRowGroup periodBeginGroup, RowMeta rowmeta) {
        Row sumRow = periodBeginGroup.getGroupSumRow();
        boolean isNullSumRow = sumRow == null;
        List<String> sumRowFields = null;
        if (!isNullSumRow) {
            sumRowFields = Arrays.asList(periodBeginGroup.getSumRowMeta().getFieldNames());
        }
        Object[] rowData = new Object[rowmeta.getFieldCount()];
        block12: for (int i = 0; i < rowmeta.getFieldCount(); ++i) {
            Field field = rowmeta.getField(i);
            String fieldName = field.getName();
            DataType fieldType = field.getDataType();
            switch (fieldName) {
                case "pid": {
                    rowData[i] = periodBeginGroup.getPid();
                    continue block12;
                }
                case "rowid": {
                    rowData[i] = periodBeginGroup.getRowId();
                    continue block12;
                }
                case "rowtype": {
                    rowData[i] = periodBeginGroup.getRowType();
                    continue block12;
                }
                case "isgroupnode": {
                    rowData[i] = periodBeginGroup.getIsGroupNode();
                    continue block12;
                }
                default: {
                    Object fieldValue = null;
                    if (!isNullSumRow && sumRowFields != null && sumRowFields.contains(fieldName)) {
                        fieldValue = sumRow.get(fieldName);
                    }
                    if (fieldValue == null) {
                        if (fieldType instanceof BigDecimalType) {
                            fieldValue = BigDecimal.ZERO;
                        } else if (fieldType instanceof LongType) {
                            fieldValue = 0L;
                        } else if (fieldType instanceof StringType) {
                            fieldValue = "";
                        }
                    }
                    rowData[i] = fieldValue;
                }
            }
        }
        return rowData;
    }

    private static List<Object[]> buildDtlData(DiffAnalysisRptRowGroup rowGroup, RowMeta rowmeta) {
        ArrayList<Object[]> dtlDataList = new ArrayList<Object[]>(16);
        List<Row> dtlRows = rowGroup.getSonRows();
        if (dtlRows == null) {
            return dtlDataList;
        }
        List<String> dtlRowFields = Arrays.asList(rowGroup.getSonRowMeta().getFieldNames());
        String rowId = rowGroup.getRowId();
        int index = 0;
        for (Row dtlRow : dtlRows) {
            ++index;
            Object[] rowData = new Object[rowmeta.getFieldCount()];
            block11: for (int i = 0; i < rowmeta.getFieldCount(); ++i) {
                Field field = rowmeta.getField(i);
                String fieldName = field.getName();
                DataType fieldType = field.getDataType();
                switch (fieldName) {
                    case "pid": {
                        rowData[i] = rowGroup.getRowId();
                        continue block11;
                    }
                    case "rowid": {
                        rowData[i] = rowId + index;
                        continue block11;
                    }
                    case "isgroupnode": {
                        rowData[i] = 0;
                        continue block11;
                    }
                    default: {
                        Object fieldValue = null;
                        if (dtlRowFields.contains(fieldName)) {
                            fieldValue = dtlRow.get(fieldName);
                        }
                        if (fieldValue == null) {
                            if (fieldType instanceof BigDecimalType) {
                                fieldValue = BigDecimal.ZERO;
                            } else if (fieldType instanceof LongType) {
                                fieldValue = 0L;
                            } else if (fieldType instanceof StringType) {
                                fieldValue = "";
                            }
                        }
                        rowData[i] = fieldValue;
                    }
                }
            }
            dtlDataList.add(rowData);
        }
        return dtlDataList;
    }

    public static String getBeginBillTypeName(DiffAnalysisRptParam rptParam) {
        String beginBillType = DiffAnalysisRptBillTypeEnum.BALANCE_IN.getDesc();
        Long accountId = rptParam.getCostAccountId();
        DynamicObject startPeriod = PeriodHelper.getStartPeriod((Long)accountId);
        if (startPeriod != null && rptParam.getPeriodId().compareTo(startPeriod.getLong("id")) == 0) {
            beginBillType = DiffAnalysisRptBillTypeEnum.INITBILL.getDesc();
        }
        return beginBillType;
    }

    private static DataSet reCalActualAmt(DataSet dataSet) {
        HashMap<String, String> replaceMap = new HashMap<String, String>(16);
        replaceMap.put("actualamt", "standardamt + diff as actualamt");
        replaceMap.put("actualprice", "case when qty != 0 then (standardamt + diff) / qty else 0 end as actualprice");
        String select = DiffAnalysisRptHelper.getSelectByRowMeta(replaceMap, dataSet.getRowMeta());
        dataSet = dataSet.select(select);
        return dataSet;
    }
}

