/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.treereport.diffanalysisrpt.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.util.ReportUtil;
import kd.fi.cal.report.newreport.base.CalAuxptyFilterHelper;

public class DiffAnalysisRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_diffanalysis_rpt");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("mulcalorg", (Object)calOrgId);
            this.setCostAccountByCalOrg(calOrgId);
        }
        CalAuxptyFilterHelper.setAuxEntryEnable(this.getModel(), (IFormView)this.getView());
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        CalAuxptyFilterHelper.setAuxEntryEnable(this.getModel(), (IFormView)this.getView());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IDataModel model = this.getModel();
        DynamicObject calOrg = (DynamicObject)model.getValue("mulcalorg");
        DynamicObject costAccount = (DynamicObject)model.getValue("costaccount");
        DynamicObject period = (DynamicObject)model.getValue("period");
        DynamicObject material = (DynamicObject)model.getValue("mulmaterial");
        if (calOrg == null || costAccount == null || period == null || material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879", (String)"TransactionDetailRptFormPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermissionHelper.orgPermVerify((Long)userId, (String)"cal_diffanalysis_rpt", (String)"47150e89000000ac", (Long)calOrg.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\u3002", (String)"StockGatherDetailRptQueryPlugin_9", (String)"fi-cal-report", (Object[])new Object[0]));
            return false;
        }
        List<Object> auxptyIds = CalAuxptyFilterHelper.getAuxptyIds(this.getModel());
        HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>(16);
        paramMap.put("auxptyid", auxptyIds);
        queryParam.setCustomParam(paramMap);
        return super.verifyQuery(queryParam);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        CalAuxptyFilterHelper.addAuxdetailbasebdRegister((Object)this);
        this.addF7Listener(this, "mulcalorg", "costaccount", "period", "storageorg", "mulmaterial", "multracknumber", "mulproject", "auxproperty", "auxdetailbd", "warehouse", "location");
        ReportList report = (ReportList)this.getControl("reportlistap");
        report.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("billno".equals(key)) {
                    DiffAnalysisRptFormPlugin.this.hyperLinkBillNoClick(evt);
                } else if ("rowtype".equals(key)) {
                    DiffAnalysisRptFormPlugin.this.hyperLinkRowTypeClick(evt);
                } else if ("vouchernum".equals(key)) {
                    DiffAnalysisRptFormPlugin.this.hyperLinkVoucherNumClick(evt);
                }
            }
        });
    }

    protected void hyperLinkBillNoClick(HyperLinkClickEvent evt) {
        String billid;
        QFilter qFilter;
        DynamicObject row = evt.getRowData();
        Long billId = row.getLong("billid");
        String bizObject = row.getString("bizobject");
        DynamicObject bill = QueryServiceHelper.queryOne((String)bizObject, (String)"id", (QFilter[])(qFilter = new QFilter("id", "=", (Object)billId)).toArray());
        if (bill != null) {
            billid = String.valueOf(bill.get("id"));
            if ("0".equals(billid)) {
                return;
            }
        } else {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId((Object)billid);
        showParameter.setFormId(bizObject);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected void hyperLinkRowTypeClick(HyperLinkClickEvent evt) {
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = this.getView().getQueryParam().getFilter().clone();
        DynamicObject row = evt.getRowData();
        Long ordermatId = row.getLong("ordermatid");
        if (ordermatId == null || Long.compare(ordermatId, 0L) == 0) {
            return;
        }
        DynamicObject matInfo = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_material"));
        matInfo.set("id", (Object)ordermatId);
        filter.getFilterItem("mulmaterial").setValue((Object)matInfo);
        Long orderTrackNumId = row.getLong("ordertracknumid");
        if (orderTrackNumId != null && Long.compare(orderTrackNumId, 0L) != 0) {
            DynamicObject trackNumInfo = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_tracknumber"));
            trackNumInfo.set("id", (Object)orderTrackNumId);
            filter.getFilterItem("multracknumber").setValue((Object)trackNumInfo);
        }
        queryParam.setFilter(filter);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("cal_diffanalysis_rpt");
        showParameter.setQueryParam(queryParam);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected void hyperLinkVoucherNumClick(HyperLinkClickEvent evt) {
        String billid;
        DynamicObject row = evt.getRowData();
        Long voucherId = row.getLong("voucherid");
        QFilter qFilter = new QFilter("id", "=", (Object)voucherId);
        DynamicObject voucher = QueryServiceHelper.queryOne((String)"gl_voucher", (String)"id", (QFilter[])qFilter.toArray());
        if (voucher != null) {
            billid = String.valueOf(voucher.get("id"));
            if ("0".equals(billid)) {
                return;
            }
        } else {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId((Object)billid);
        showParameter.setFormId("gl_voucher");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Names) {
        BasedataEdit f7 = null;
        for (String f7Name : f7Names) {
            f7 = (BasedataEdit)this.getControl(f7Name);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("mulcalorg".equals(key)) {
            this.beforeF7Select4CalOrg(e);
        } else if ("costaccount".equals(key)) {
            this.beforeF7Select4CostAccount(e);
        } else if ("period".equals(key)) {
            this.beforeF7Select4Period(e);
        } else if ("storageorg".equals(key)) {
            this.beforeF7Select4StorageOrg(e);
        } else if ("warehouse".equals(key)) {
            this.beforeF7Select4Warehouse(e);
        } else if ("location".equals(key)) {
            this.beforeF7Select4Location(e);
        } else if ("mulmaterial".equals(key)) {
            ReportF7Helper.beforeF7Select4Material((BeforeF7SelectEvent)e);
        } else if ("multracknumber".equals(key)) {
            ReportUtil.beforeF7Select4MulTrackNum((BeforeF7SelectEvent)e, (IDataModel)this.getModel());
        } else if ("auxproperty".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            CalAuxptyFilterHelper.beforeAuxProperty(showParameter);
        } else if ("auxdetailbd".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            CalAuxptyFilterHelper.beforeAuxpropertydetail(showParameter, (IFormView)this.getView());
        }
    }

    private void beforeF7Select4StorageOrg(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SalesEstimateDetailRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        List storageOrgIds = OrgServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)calOrg.getLong("id"), (Long)0L);
        q = new QFilter("id", "in", (Object)storageOrgIds);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Warehouse(BeforeF7SelectEvent e) {
        List wareHouseList;
        Long[] calOrgWarehouseIds;
        int n;
        Long[] invOrgWarehouseIds;
        QFilter q = new QFilter("id", "=", (Object)-1L);
        IDataModel model = this.getModel();
        Object storageOrgObj = model.getValue("storageorg");
        Object calOrgObj = model.getValue("mulcalorg");
        HashSet<Long> wareHouseIdSet = new HashSet<Long>(16);
        if (storageOrgObj != null && (invOrgWarehouseIds = SCMHelper.getAllWarehouseIDs((String)((DynamicObject)storageOrgObj).getString("number"))) != null) {
            Long[] longArray = invOrgWarehouseIds;
            int n2 = longArray.length;
            for (n = 0; n < n2; ++n) {
                long id = longArray[n];
                wareHouseIdSet.add(id);
            }
        }
        if (calOrgObj != null && (calOrgWarehouseIds = SCMHelper.getAllWarehouseIDs((Object[])(wareHouseList = OrgHelper.getStorageOrgUnitByCalOrg((Long)((DynamicObject)calOrgObj).getLong("id"))).toArray())) != null) {
            Long[] longArray = calOrgWarehouseIds;
            n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long id = longArray[i];
                wareHouseIdSet.add(id);
            }
        }
        if (wareHouseIdSet.size() > 0) {
            q = new QFilter("id", "in", wareHouseIdSet);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Location(BeforeF7SelectEvent e) {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        if (warehouse != null) {
            Object[] wareHouseIdArr = new Object[]{warehouse.getLong("id")};
            q = new QFilter("id", "in", (Object)SCMHelper.getAllLocationIDs((Object[])wareHouseIdArr));
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4Period(BeforeF7SelectEvent e) {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        QFilter q = PeriodHelper.getCostAccountNextPeriodQf((DynamicObject)costAccount);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CostAccount(BeforeF7SelectEvent e) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("mulcalorg");
        QFilter q = new QFilter("id", "=", (Object)-1L);
        q.and("enable", "=", (Object)Character.valueOf('1'));
        if (calOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SalesEstimateDetailRptFormPlugin_6", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        q = new QFilter("calorg", "=", calOrg.getPkValue());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    private void beforeF7Select4CalOrg(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_diffanalysis_rpt", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        if ("mulcalorg".equals(key)) {
            this.calOrgChanged();
        } else if ("costaccount".equals(key)) {
            this.costAccountChanged();
        } else if ("auxproperty".equals(key)) {
            CalAuxptyFilterHelper.handleAuxpropertyChangeEvent(newValue, rowIndex, (IFormView)this.getView());
        } else if ("auxdetailbasebd".equals(key)) {
            CalAuxptyFilterHelper.handleAuxdetailBdChagneEvent(newValue, rowIndex, this.getView().getModel());
        } else if ("storageorg".equals(key)) {
            this.storageOrgChanged();
        } else if ("warehouse".equals(key)) {
            this.warehouseChanged();
        }
    }

    private void costAccountChanged() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("period", null);
            return;
        }
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        if (period == null) {
            return;
        }
        this.getModel().setValue("period", (Object)period.getLong("id"));
    }

    private void calOrgChanged() {
        IDataModel model = this.getModel();
        model.setValue("storageorg", null);
        DynamicObject calOrg = (DynamicObject)model.getValue("mulcalorg");
        if (calOrg == null) {
            model.setValue("costaccount", null);
        } else {
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg.getLong("id"));
            if (costAccount != null) {
                model.setValue("costaccount", (Object)costAccount.getLong("id"));
            } else {
                model.setValue("costaccount", null);
            }
        }
    }

    private void storageOrgChanged() {
        this.getModel().setValue("warehouse", null);
    }

    private void warehouseChanged() {
        this.getModel().setValue("location", null);
    }

    private void setCostAccountByCalOrg(Long calOrg) {
        DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg((Long)calOrg);
        if (costAccount != null) {
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
            if (period != null) {
                this.getModel().setValue("period", (Object)period.getLong("id"));
            }
            this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
        } else {
            this.getModel().setValue("costaccount", null);
        }
    }

    public void click(EventObject evt) {
        CalAuxptyFilterHelper.click(evt, (IFormPlugin)this, this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        CalAuxptyFilterHelper.closedCallBack(evt, this.getView());
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        CalAuxptyFilterHelper.loadOtherEntryFilter(scheme, this.getView().getModel(), this.getView());
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        CalAuxptyFilterHelper.saveEntryFilter((IFormView)this.getView(), "auxentry");
    }
}

