/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.report.treereport.diffanalysisrpt.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.StringType;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalDiffGroupBillHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.report.treereport.diffanalysisrpt.DiffAnalysisRptHelper;
import kd.fi.cal.report.treereport.diffanalysisrpt.DiffAnalysisRptParam;
import kd.fi.cal.report.treereport.diffanalysisrpt.DiffAnalysisRptRowGroup;
import kd.fi.cal.report.treereport.diffanalysisrpt.MatTrackNumGrouoInfo;
import kd.fi.cal.report.treereport.diffanalysisrpt.enums.DiffAnalysisRptBillTypeEnum;
import kd.fi.cal.report.treereport.diffanalysisrpt.enums.DiffAnalysisRptNodeEnum;

public class DiffAnalysisRptQueryPlugin
extends AbstractReportListDataPlugin {
    private DiffAnalysisRptParam rptParam;
    private RowMeta allFieldsRowMeta;
    private MainEntityType diffEntity;
    private QFilter recordBaseQfilter;
    private QFilter diffBaseQfilter;
    private DataSet diffCalDSCopy;
    private List<MatTrackNumGrouoInfo> matTrackInfoList = new ArrayList<MatTrackNumGrouoInfo>(16);
    private static final int BATCH_SIZE = 400;

    public DataSet query(ReportQueryParam param, Object paramObject) throws Throwable {
        this.init(param);
        HashMap<String, DiffAnalysisRptRowGroup> rowGroup = new HashMap<String, DiffAnalysisRptRowGroup>(16);
        DataSet periodBeginDS = this.addPeriodBeginRowGroup(rowGroup);
        DataSet periodInDS = this.addPeriodInRowGroup(rowGroup);
        DataSet periodAccrueDS = this.addPeriodAccrueRowGroup(periodBeginDS.copy(), periodInDS.copy(), rowGroup);
        DataSet periodOutDS = this.addPeriodOutRowGroup(rowGroup);
        this.addPeriodEndRowGroup(periodAccrueDS.copy(), periodOutDS.copy(), rowGroup);
        DataSet dataSet = this.buildData(rowGroup);
        if (CalDiffGroupBillHelper.getIsgroupdiff()) {
            dataSet = this.joinDiffGroupBillVoucher(dataSet);
        }
        return dataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        return columns;
    }

    private DataSet buildData(Map<String, DiffAnalysisRptRowGroup> rowGroup) {
        ArrayList<Object[]> rowList = new ArrayList<Object[]>(16);
        DiffAnalysisRptHelper.buildGroupData(rowList, rowGroup, this.allFieldsRowMeta);
        Algo algo = Algo.create((String)"DiffAnalysisRptQueryPlugin-buildFinalDS");
        return algo.createDataSet(rowList, this.allFieldsRowMeta);
    }

    private void init(ReportQueryParam param) {
        this.rptParam = DiffAnalysisRptHelper.initQueryParam(param);
        this.diffBaseQfilter = DiffAnalysisRptHelper.buildCommonFilter("cal_stdcostdiffbill", this.rptParam);
        this.recordBaseQfilter = DiffAnalysisRptHelper.buildCommonFilter("cal_costrecord_subentity", this.rptParam);
        this.diffEntity = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        this.allFieldsRowMeta = DiffAnalysisRptHelper.getAllFieldsRowMeta();
    }

    private DataSet addPeriodBeginRowGroup(Map<String, DiffAnalysisRptRowGroup> rowGroupMap) {
        DataSet balanceBeginDS = this.getBalanceDS4PeriodBegin();
        DataSet diffBeginDS = this.getDiffDS4PeriodBegin();
        DataSet dtlDs = balanceBeginDS.union(diffBeginDS);
        String pid = "0";
        String rowId = DiffAnalysisRptNodeEnum.PERIODBEGIN.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODBEGIN.getDesc();
        DataSet sumDS = DiffAnalysisRptHelper.putTopRowGroup(pid, rowId, rowType, dtlDs, rowGroupMap);
        return sumDS;
    }

    private DataSet addPeriodInRowGroup(Map<String, DiffAnalysisRptRowGroup> rowGroupMap) {
        ArrayList<DiffAnalysisRptRowGroup> sonGroups = new ArrayList<DiffAnalysisRptRowGroup>(16);
        DataSet purInDS = this.addPeriodIn4PurInRowGroup(sonGroups);
        DataSet transInDS = this.addPeriodIn4TransInRowGroup(sonGroups);
        DataSet produceInDS = this.addPeriodIn4ProduceInRowGroup(sonGroups);
        DataSet otherInDS = this.addPeriodIn4OtherInRowGroup(sonGroups);
        DataSet specialInDS = this.addPeriodIn4SpecialInRowGroup(sonGroups);
        DataSet purInSumDS = purInDS.union(transInDS).union(produceInDS).union(otherInDS).union(specialInDS);
        String pid = "0";
        String rowId = DiffAnalysisRptNodeEnum.PERIODIN.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODIN.getDesc();
        DataSet sumDS = DiffAnalysisRptHelper.putTopRowGroup(pid, rowId, rowType, purInSumDS, sonGroups, rowGroupMap);
        return sumDS;
    }

    private DataSet addPeriodAccrueRowGroup(DataSet periodBeginDS, DataSet periodInDS, Map<String, DiffAnalysisRptRowGroup> rowGroup) {
        DataSet periodAccrue = periodBeginDS.union(periodInDS);
        String pid = "0";
        String rowId = DiffAnalysisRptNodeEnum.PERIODACCRUE.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODACCRUE.getDesc();
        periodAccrue = DiffAnalysisRptHelper.putTopRowGroup(pid, rowId, rowType, periodAccrue, null, rowGroup);
        return periodAccrue;
    }

    private DataSet addPeriodEndRowGroup(DataSet periodAccureDS, DataSet periodOutDS, Map<String, DiffAnalysisRptRowGroup> rowGroup) {
        BigDecimal standAmt = BigDecimal.ZERO;
        BigDecimal actualAmt = BigDecimal.ZERO;
        BigDecimal qty = BigDecimal.ZERO;
        if (periodOutDS.iterator().hasNext()) {
            Row periotOutSumRow = periodOutDS.next();
            BigDecimal rowStandardAmt = periotOutSumRow.getBigDecimal("standardamt");
            BigDecimal rowActualAmt = periotOutSumRow.getBigDecimal("actualamt");
            BigDecimal rowQty = periotOutSumRow.getBigDecimal("qty");
            if (rowStandardAmt != null && rowStandardAmt.compareTo(BigDecimal.ZERO) != 0) {
                standAmt = rowStandardAmt;
            }
            if (rowActualAmt != null && rowActualAmt.compareTo(BigDecimal.ZERO) != 0) {
                actualAmt = rowActualAmt;
            }
            if (rowQty != null && rowQty.compareTo(BigDecimal.ZERO) != 0) {
                qty = rowQty;
            }
        }
        if (qty.compareTo(BigDecimal.ZERO) != 0 || standAmt.compareTo(BigDecimal.ZERO) != 0 || actualAmt.compareTo(BigDecimal.ZERO) != 0) {
            HashMap<String, String> replaceMap = new HashMap<String, String>(16);
            replaceMap.put("qty", "qty - " + qty + " as qty");
            replaceMap.put("standardamt", "standardamt - " + standAmt + " as standardamt");
            replaceMap.put("actualamt", "actualamt - " + actualAmt + " as actualamt");
            String billSelect = DiffAnalysisRptHelper.getSelectByRowMeta(replaceMap, periodAccureDS.getRowMeta());
            periodAccureDS = periodAccureDS.select(billSelect);
            replaceMap.clear();
            replaceMap.put("diff", "actualamt - standardamt as diff");
            replaceMap.put("standprice", "case when qty = 0 then 0 else standardamt /  qty end as standprice");
            replaceMap.put("actualprice", "case when qty = 0 then 0 else actualamt /  qty end as actualprice");
            billSelect = DiffAnalysisRptHelper.getSelectByRowMeta(replaceMap, periodAccureDS.getRowMeta());
            periodAccureDS = periodAccureDS.select(billSelect);
        }
        String pid = "0";
        String rowId = DiffAnalysisRptNodeEnum.PERIODEND.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODEND.getDesc();
        periodAccureDS = DiffAnalysisRptHelper.putTopRowGroup(pid, rowId, rowType, periodAccureDS, null, rowGroup);
        return periodAccureDS;
    }

    private DataSet addPeriodOutRowGroup(Map<String, DiffAnalysisRptRowGroup> rowGroupMap) {
        ArrayList<DiffAnalysisRptRowGroup> sonGroups = new ArrayList<DiffAnalysisRptRowGroup>(16);
        DataSet saleOutDS = this.addPeriodOut4SaleOutRowGroup(sonGroups);
        DataSet produceOutDS = this.addPeriodOut4ProduceOutRowGroup(sonGroups);
        DataSet costCenterDS = this.addPeriodOut4CostCenterRowGroup(sonGroups);
        DataSet transOutDS = this.addPeriodOut4TransOutRowGroup(sonGroups);
        DataSet WIPDS = null;
        if (this.matTrackInfoList != null && !this.matTrackInfoList.isEmpty() && this.diffCalDSCopy != null) {
            WIPDS = this.addPeriodOut4WIPRowGroup(sonGroups);
        }
        DataSet otherOutDS = this.addPeriodOut4OtherOutRowGroup(sonGroups);
        DataSet allOutSumDS = transOutDS.union(otherOutDS);
        if (saleOutDS != null) {
            allOutSumDS = allOutSumDS.union(saleOutDS);
        }
        if (produceOutDS != null) {
            produceOutDS = produceOutDS.select(allOutSumDS.getRowMeta().getFieldNames());
            allOutSumDS = allOutSumDS.union(produceOutDS);
        }
        if (costCenterDS != null) {
            allOutSumDS = allOutSumDS.union(costCenterDS);
        }
        if (WIPDS != null) {
            WIPDS = WIPDS.select(allOutSumDS.getRowMeta().getFieldNames());
            allOutSumDS = allOutSumDS.union(WIPDS);
        }
        String pid = "0";
        String rowId = DiffAnalysisRptNodeEnum.PERIODOUT.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODOUT.getDesc();
        allOutSumDS = DiffAnalysisRptHelper.putTopRowGroup(pid, rowId, rowType, allOutSumDS, sonGroups, rowGroupMap);
        return allOutSumDS;
    }

    private DataSet addPeriodIn4PurInRowGroup(List<DiffAnalysisRptRowGroup> sonGroups) {
        DataSet diffDS = this.getDiffDS4PurIn();
        DataSet reocrdDS = this.getRecordDS4PurIn();
        DataSet sumDS = diffDS.union(reocrdDS);
        String pid = DiffAnalysisRptNodeEnum.PERIODIN.getValue();
        String rowId = DiffAnalysisRptNodeEnum.PERIODIN_PURIN.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODIN_PURIN.getDesc();
        sumDS = DiffAnalysisRptHelper.collectRowGroup4DtlData(pid, rowId, rowType, sumDS, sonGroups);
        return sumDS;
    }

    private DataSet addPeriodIn4TransInRowGroup(List<DiffAnalysisRptRowGroup> sonGroups) {
        DataSet transInDS = this.getDS4Trans(true);
        DataSet[] splitDataSet = transInDS.splitByFilter(new String[]{new QFilter("transtype", "=", (Object)"A").toString(), new QFilter("transtype", "=", (Object)"B").toString()}, false);
        DataSet sameOrgDS = splitDataSet[0];
        sameOrgDS = sameOrgDS.orderBy(new String[]{"bizobject", "billno"});
        DataSet crossOrgDS = splitDataSet[1];
        crossOrgDS = crossOrgDS.orderBy(new String[]{"bizobject", "billno"});
        ArrayList<DiffAnalysisRptRowGroup> sonRowGroups = new ArrayList<DiffAnalysisRptRowGroup>(16);
        String pid = DiffAnalysisRptNodeEnum.PERIODIN_TRANSIN.getValue();
        String rowId = DiffAnalysisRptNodeEnum.PERIODIN_TRANSIN_SAMEORG.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODIN_TRANSIN_SAMEORG.getDesc();
        sameOrgDS = DiffAnalysisRptHelper.collectRowGroup4DtlData(pid, rowId, rowType, sameOrgDS, sonRowGroups);
        rowId = DiffAnalysisRptNodeEnum.PERIODIN_TRANSIN_CROSSORG.getValue();
        rowType = DiffAnalysisRptNodeEnum.PERIODIN_TRANSIN_CROSSORG.getDesc();
        crossOrgDS = DiffAnalysisRptHelper.collectRowGroup4DtlData(pid, rowId, rowType, crossOrgDS, sonRowGroups);
        DataSet sumDS = sameOrgDS.union(crossOrgDS);
        pid = DiffAnalysisRptNodeEnum.PERIODIN.getValue();
        rowId = DiffAnalysisRptNodeEnum.PERIODIN_TRANSIN.getValue();
        rowType = DiffAnalysisRptNodeEnum.PERIODIN_TRANSIN.getDesc();
        transInDS = DiffAnalysisRptHelper.collectRowGroup4SumData(pid, rowId, rowType, sumDS, sonRowGroups, sonGroups);
        return transInDS;
    }

    private DataSet addPeriodIn4ProduceInRowGroup(List<DiffAnalysisRptRowGroup> sonGroups) {
        DataSet produceInDS = this.getDS4ProduceIn();
        String pid = DiffAnalysisRptNodeEnum.PERIODIN.getValue();
        String rowId = DiffAnalysisRptNodeEnum.PERIODIN_PRODUCE.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODIN_PRODUCE.getDesc();
        produceInDS = DiffAnalysisRptHelper.collectRowGroup4DtlData(pid, rowId, rowType, produceInDS, sonGroups);
        return produceInDS;
    }

    private DataSet addPeriodIn4OtherInRowGroup(List<DiffAnalysisRptRowGroup> sonGroups) {
        DataSet otherInDS = this.getDS4Other(true);
        String pid = DiffAnalysisRptNodeEnum.PERIODIN.getValue();
        String rowId = DiffAnalysisRptNodeEnum.PERIODIN_OTHERIN.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODIN_OTHERIN.getDesc();
        otherInDS = DiffAnalysisRptHelper.collectRowGroup4DtlData(pid, rowId, rowType, otherInDS, sonGroups);
        return otherInDS;
    }

    private DataSet addPeriodIn4SpecialInRowGroup(List<DiffAnalysisRptRowGroup> sonGroups) {
        DataSet specialInDS = this.getDS4SpecialIn();
        String pid = DiffAnalysisRptNodeEnum.PERIODIN.getValue();
        String rowId = DiffAnalysisRptNodeEnum.PERIODIN_SPECIALIN.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODIN_SPECIALIN.getDesc();
        specialInDS = DiffAnalysisRptHelper.collectRowGroup4DtlData(pid, rowId, rowType, specialInDS, sonGroups);
        return specialInDS;
    }

    private DataSet addPeriodOut4SaleOutRowGroup(List<DiffAnalysisRptRowGroup> parentGroups) {
        QFilter splitDataSet;
        DataSet saleOutDS = this.getDS4SaleOut();
        DataSet trackNumDSCopy = saleOutDS.copy().groupBy(new String[]{"tracknumber", "tracknumberid"}).finish();
        ArrayList<Long> trackNumIdList = new ArrayList<Long>(16);
        ArrayList<String> filterStringList = new ArrayList<String>(16);
        HashMap<Long, String> trackNumMap = new HashMap<Long, String>(16);
        boolean hasNullTracknum = false;
        for (Row row : trackNumDSCopy) {
            Long tracknumId = row.getLong("tracknumberid");
            if (tracknumId.compareTo(0L) == 0) {
                hasNullTracknum = true;
                continue;
            }
            String tracknumber = row.getString("tracknumber");
            trackNumIdList.add(tracknumId);
            QFilter q = new QFilter("tracknumberid", "=", (Object)tracknumId);
            filterStringList.add(q.toString());
            trackNumMap.put(tracknumId, tracknumber);
        }
        if (hasNullTracknum) {
            trackNumIdList.add(0L);
            QFilter q = new QFilter("tracknumberid", "=", (Object)0L);
            filterStringList.add(q.toString());
            trackNumMap.put(0L, ResManager.loadKDString((String)"\u7a7a", (String)"DiffAnalysisRptQueryPlugin_0", (String)"fi-cal-report", (Object[])new Object[0]));
        }
        if (((DataSet[])(splitDataSet = saleOutDS.splitByFilter(filterStringList.toArray(new String[0]), false))).length == 0) {
            return null;
        }
        ArrayList<DiffAnalysisRptRowGroup> sonRowGroups = new ArrayList<DiffAnalysisRptRowGroup>(16);
        Object sumDS = null;
        int i = 0;
        for (QFilter trackNumDS : splitDataSet) {
            Long trackNumId = (Long)trackNumIdList.get(i);
            String trackNum = (String)trackNumMap.get(trackNumId);
            String pid = DiffAnalysisRptNodeEnum.PERIODOUT_SALEOUT.getValue();
            String rowId = i + DiffAnalysisRptNodeEnum.PERIODOUT_SALEOUT_TRACKNUM.getValue();
            String rowType = DiffAnalysisRptNodeEnum.PERIODOUT_SALEOUT_TRACKNUM.getDesc() + ": " + trackNum;
            trackNumDS = DiffAnalysisRptHelper.collectRowGroup4DtlData(pid, rowId, rowType, (DataSet)trackNumDS, sonRowGroups);
            sumDS = sumDS == null ? trackNumDS : sumDS.union((DataSet)trackNumDS);
            ++i;
        }
        String pid = DiffAnalysisRptNodeEnum.PERIODOUT.getValue();
        String rowId = DiffAnalysisRptNodeEnum.PERIODOUT_SALEOUT.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODOUT_SALEOUT.getDesc();
        sumDS = DiffAnalysisRptHelper.collectRowGroup4SumData(pid, rowId, rowType, sumDS, sonRowGroups, parentGroups);
        return sumDS;
    }

    private DataSet addPeriodOut4ProduceOutRowGroup(List<DiffAnalysisRptRowGroup> parentGroups) {
        String rowType;
        String rowId;
        DataSet recoerdDS = this.getRecordDS4ProduceOut();
        HashSet<Long> orderEntryIdSet = new HashSet<Long>(16);
        DataSet orderBillDS = this.getProduceOrderDS(orderEntryIdSet, recoerdDS.copy());
        recoerdDS = recoerdDS.join(orderBillDS).on("srcbillid", "orderid").on("srcbillentryid", "orderentryid").select(recoerdDS.getRowMeta().getFieldNames(), orderBillDS.getRowMeta().getFieldNames()).finish();
        DataSet diffDS = this.getDiffDS4ProduceOut();
        diffDS = diffDS.leftJoin(recoerdDS).on("srcbillid", "billid").on("srcbillentryid", "id").select(diffDS.getRowMeta().getFieldNames(), orderBillDS.getRowMeta().getFieldNames()).finish();
        DataSet diffCalDS = this.getDiffCalDS(orderEntryIdSet);
        diffCalDS = diffCalDS.join(orderBillDS).on("srcbillentryid", "orderentryid").select(diffCalDS.getRowMeta().getFieldNames(), orderBillDS.getRowMeta().getFieldNames()).finish();
        HashMap<String, String> replaceMap = new HashMap<String, String>(16);
        replaceMap.put("billid", "orderid as billid");
        replaceMap.put("bizobject", "orderentitynum as bizobject");
        String billSelect = DiffAnalysisRptHelper.getSelectByRowMeta(replaceMap, diffCalDS.getRowMeta());
        diffCalDS = diffCalDS.select(billSelect);
        this.diffCalDSCopy = diffCalDS.copy();
        orderBillDS = orderBillDS.groupBy(new String[]{"ordermatnum", "ordermatid", "ordertracknum", "ordertracknumid"}).finish();
        orderBillDS = orderBillDS.orderBy(new String[]{"ordermatnum", "ordertracknum"});
        HashMap<Long, String> matIdAndNumMap = new HashMap<Long, String>(16);
        HashMap<Long, String> trackIdAndNumMap = new HashMap<Long, String>(16);
        ArrayList<Long> matIdList = new ArrayList<Long>(16);
        ArrayList<Long> trackIdList = new ArrayList<Long>(16);
        ArrayList<String> filterStringList = new ArrayList<String>(16);
        int index = 0;
        for (Row row : orderBillDS) {
            if (index % 400 == 0) {
                matIdList = new ArrayList(16);
                trackIdList = new ArrayList(16);
                filterStringList = new ArrayList(16);
                MatTrackNumGrouoInfo matTrackInfo = new MatTrackNumGrouoInfo();
                matTrackInfo.setMatIdList(matIdList);
                matTrackInfo.setTrackIdList(trackIdList);
                matTrackInfo.setMatIdAndNumMap(matIdAndNumMap);
                matTrackInfo.setTrackIdAndNumMap(trackIdAndNumMap);
                matTrackInfo.setFilterStringList(filterStringList);
                this.matTrackInfoList.add(matTrackInfo);
            }
            Long matId = row.getLong("ordermatid");
            Long trackId = row.getLong("ordertracknumid");
            String matNum = row.getString("ordermatnum");
            String trackNum = row.getString("ordertracknum");
            if (trackNum == null) {
                trackNum = ResManager.loadKDString((String)"\u65e0\u8ddf\u8e2a\u53f7", (String)"DiffAnalysisRptQueryPlugin_1", (String)"fi-cal-report", (Object[])new Object[0]);
            }
            QFilter q = new QFilter("ordermatid", "=", (Object)matId);
            q.and("ordertracknumid", "=", (Object)trackId);
            filterStringList.add(q.toString());
            matIdList.add(matId);
            trackIdList.add(trackId);
            matIdAndNumMap.put(matId, matNum);
            trackIdAndNumMap.put(trackId, trackNum);
            ++index;
        }
        recoerdDS = recoerdDS.union(diffDS).union(diffCalDS);
        DataSet[] dSArray = recoerdDS.splitByFilter(new String[]{new QFilter("ordermatid", "!=", null).toString(), new QFilter("ordermatid", "=", null).toString()}, false);
        DataSet hasOrderDS = dSArray[0];
        DataSet noOrderDS = dSArray[1];
        if (hasOrderDS == null && noOrderDS == null) {
            return null;
        }
        DataSet sumDS = null;
        ArrayList<DataSet> sumDSList = new ArrayList<DataSet>(16);
        ArrayList<DiffAnalysisRptRowGroup> sonRowGroups = new ArrayList<DiffAnalysisRptRowGroup>(16);
        int trackNumIndex = 0;
        if (hasOrderDS != null) {
            int batchseq = 0;
            for (MatTrackNumGrouoInfo matTrackinfo : this.matTrackInfoList) {
                DataSet orderDS = null;
                orderDS = batchseq == this.matTrackInfoList.size() ? hasOrderDS : hasOrderDS.copy();
                DataSet[] splitDataSet = orderDS.splitByFilter(matTrackinfo.getFilterStringList().toArray(new String[0]), false);
                if (splitDataSet.length != 0) {
                    int i = 0;
                    for (DataSet groupDS : splitDataSet) {
                        Long matId = matTrackinfo.getMatIdList().get(i);
                        String matNum = matTrackinfo.getMatIdAndNumMap().get(matId);
                        Long trackId = matTrackinfo.getTrackIdList().get(i);
                        String trackNum = matTrackinfo.getTrackIdAndNumMap().get(trackId);
                        String pid = DiffAnalysisRptNodeEnum.PERIODOUT_PRODUCEOUT.getValue();
                        String rowId2 = trackNumIndex + DiffAnalysisRptNodeEnum.PERIODOUT_PERIODOUT_MATTRACK.getValue();
                        String rowType2 = matNum + " (" + trackNum + ")";
                        groupDS = DiffAnalysisRptHelper.collectRowGroup4DtlData(pid, rowId2, rowType2, groupDS, sonRowGroups);
                        if (sumDS == null) {
                            sumDS = groupDS;
                        } else {
                            sumDSList.add(groupDS);
                        }
                        ++i;
                        ++trackNumIndex;
                    }
                }
                ++batchseq;
            }
        }
        if (sumDS != null && !sumDSList.isEmpty()) {
            sumDS = sumDS.union(sumDSList.toArray(new DataSet[0]));
        }
        if (noOrderDS != null) {
            String pid = DiffAnalysisRptNodeEnum.PERIODOUT_PRODUCEOUT.getValue();
            rowId = DiffAnalysisRptNodeEnum.PERIODOUT_PERIODOUT_MATTRACK_NULL.getValue();
            rowType = DiffAnalysisRptNodeEnum.PERIODOUT_PERIODOUT_MATTRACK_NULL.getDesc();
            noOrderDS = DiffAnalysisRptHelper.collectRowGroup4DtlData(pid, rowId, rowType, noOrderDS, sonRowGroups);
            sumDS = sumDS == null ? noOrderDS : sumDS.union(noOrderDS);
        }
        String pid = DiffAnalysisRptNodeEnum.PERIODOUT.getValue();
        rowId = DiffAnalysisRptNodeEnum.PERIODOUT_PRODUCEOUT.getValue();
        rowType = DiffAnalysisRptNodeEnum.PERIODOUT_PRODUCEOUT.getDesc();
        sumDS = DiffAnalysisRptHelper.collectRowGroup4SumData(pid, rowId, rowType, sumDS, sonRowGroups, parentGroups);
        return sumDS;
    }

    private DataSet addPeriodOut4CostCenterRowGroup(List<DiffAnalysisRptRowGroup> parentGroups) {
        DataSet costCenterDS = this.getDS4CostCenter();
        DataSet centerDSCopy = costCenterDS.copy().groupBy(new String[]{"costcenternum", "costcentername"}).finish();
        ArrayList<String> centerNumList = new ArrayList<String>(16);
        ArrayList<String> filterStringList = new ArrayList<String>(16);
        HashMap<String, String> centerNumNameMap = new HashMap<String, String>(16);
        for (Row row : centerDSCopy) {
            String centerNum = row.getString("costcenternum");
            String centerName = row.getString("costcentername");
            centerNumList.add(centerNum);
            DataSet[] q = new QFilter("costcenternum", "=", (Object)centerNum);
            filterStringList.add(q.toString());
            centerNumNameMap.put(centerNum, centerName);
        }
        DataSet[] splitDataSet = costCenterDS.splitByFilter(filterStringList.toArray(new String[0]), false);
        if (splitDataSet.length == 0) {
            return null;
        }
        ArrayList<DiffAnalysisRptRowGroup> sonRowGroups = new ArrayList<DiffAnalysisRptRowGroup>(16);
        DataSet sumDS = null;
        int i = 0;
        for (DataSet centerDS : splitDataSet) {
            String centerNum = (String)centerNumList.get(i);
            String centerName = (String)centerNumNameMap.get(centerNum);
            String pid = DiffAnalysisRptNodeEnum.PERIODOUT_COSTCENTER.getValue();
            String rowId = i + DiffAnalysisRptNodeEnum.PERIODOUT_COSTCENTER_CENTERNUM.getValue();
            String rowType = String.format(DiffAnalysisRptNodeEnum.PERIODOUT_COSTCENTER_CENTERNUM.getDesc(), centerNum, centerName);
            centerDS = DiffAnalysisRptHelper.collectRowGroup4DtlData(pid, rowId, rowType, centerDS, sonRowGroups);
            sumDS = sumDS == null ? centerDS : sumDS.union(centerDS);
            ++i;
        }
        String pid = DiffAnalysisRptNodeEnum.PERIODOUT.getValue();
        String rowId = DiffAnalysisRptNodeEnum.PERIODOUT_COSTCENTER.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODOUT_COSTCENTER.getDesc();
        sumDS = DiffAnalysisRptHelper.collectRowGroup4SumData(pid, rowId, rowType, sumDS, sonRowGroups, parentGroups);
        return sumDS;
    }

    private DataSet addPeriodOut4TransOutRowGroup(List<DiffAnalysisRptRowGroup> sonGroups) {
        DataSet transOutDS = this.getDS4Trans(false);
        DataSet[] splitDataSet = transOutDS.splitByFilter(new String[]{new QFilter("transtype", "=", (Object)"A").toString(), new QFilter("transtype", "=", (Object)"B").toString()}, false);
        DataSet sameOrgDS = splitDataSet[0];
        sameOrgDS = sameOrgDS.orderBy(new String[]{"bizobject", "billno"});
        DataSet crossOrgDS = splitDataSet[1];
        crossOrgDS = crossOrgDS.orderBy(new String[]{"bizobject", "billno"});
        ArrayList<DiffAnalysisRptRowGroup> sonRowGroups = new ArrayList<DiffAnalysisRptRowGroup>(16);
        String pid = DiffAnalysisRptNodeEnum.PERIODOUT_TRANSOUT.getValue();
        String rowId = DiffAnalysisRptNodeEnum.PERIODOUT_TRANSOUT_SAMEORG.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODOUT_TRANSOUT_SAMEORG.getDesc();
        sameOrgDS = DiffAnalysisRptHelper.collectRowGroup4DtlData(pid, rowId, rowType, sameOrgDS, sonRowGroups);
        rowId = DiffAnalysisRptNodeEnum.PERIODOUT_TRANSOUT_CROSSORG.getValue();
        rowType = DiffAnalysisRptNodeEnum.PERIODOUT_TRANSOUT_CROSSORG.getDesc();
        crossOrgDS = DiffAnalysisRptHelper.collectRowGroup4DtlData(pid, rowId, rowType, crossOrgDS, sonRowGroups);
        DataSet sumDS = sameOrgDS.union(crossOrgDS);
        pid = DiffAnalysisRptNodeEnum.PERIODOUT.getValue();
        rowId = DiffAnalysisRptNodeEnum.PERIODOUT_TRANSOUT.getValue();
        rowType = DiffAnalysisRptNodeEnum.PERIODOUT_TRANSOUT.getDesc();
        transOutDS = DiffAnalysisRptHelper.collectRowGroup4SumData(pid, rowId, rowType, sumDS, sonRowGroups, sonGroups);
        return transOutDS;
    }

    private DataSet addPeriodOut4WIPRowGroup(List<DiffAnalysisRptRowGroup> parentGroups) {
        this.diffCalDSCopy = this.diffCalDSCopy.filter("ordermatid != null and ordermatid != 0l");
        String billTypeName = "'" + DiffAnalysisRptBillTypeEnum.WIPBILL.getDesc() + "' as billtypename";
        HashMap<String, String> replaceMap = new HashMap<String, String>(16);
        replaceMap.put("billtypename", billTypeName);
        replaceMap.put("qty", "qty * -1 as qty");
        replaceMap.put("standardamt", "standardamt * -1 as standardamt");
        replaceMap.put("actualamt", "actualamt * -1 as actualamt");
        replaceMap.put("diff", "diff * -1 as diff");
        String billSelect = DiffAnalysisRptHelper.getSelectByRowMeta(replaceMap, this.diffCalDSCopy.getRowMeta());
        this.diffCalDSCopy = this.diffCalDSCopy.select(billSelect);
        DataSet sumDS = null;
        ArrayList<DataSet> sumDSList = new ArrayList<DataSet>(16);
        ArrayList<DiffAnalysisRptRowGroup> sonRowGroups = new ArrayList<DiffAnalysisRptRowGroup>(16);
        int trackNumIndex = 0;
        int batchseq = 0;
        for (MatTrackNumGrouoInfo matTrackInfo : this.matTrackInfoList) {
            DataSet diffCalDS = null;
            diffCalDS = batchseq == this.matTrackInfoList.size() ? this.diffCalDSCopy : this.diffCalDSCopy.copy();
            DataSet[] splitDataSet = diffCalDS.splitByFilter(matTrackInfo.getFilterStringList().toArray(new String[0]), false);
            if (splitDataSet.length == 0) {
                return null;
            }
            int i = 0;
            for (DataSet groupDS : splitDataSet) {
                Long matId = matTrackInfo.getMatIdList().get(i);
                String matNum = matTrackInfo.getMatIdAndNumMap().get(matId);
                Long trackId = matTrackInfo.getTrackIdList().get(i);
                String trackNum = matTrackInfo.getTrackIdAndNumMap().get(trackId);
                String pid = DiffAnalysisRptNodeEnum.PERIODOUT_WIP.getValue();
                String rowId = trackNumIndex + DiffAnalysisRptNodeEnum.PERIODOUT_WIP_MATTRACK.getValue();
                String rowType = matNum + " (" + trackNum + ")";
                groupDS = DiffAnalysisRptHelper.collectRowGroup4DtlData(pid, rowId, rowType, groupDS, sonRowGroups);
                if (sumDS == null) {
                    sumDS = groupDS;
                } else {
                    sumDSList.add(groupDS);
                }
                ++i;
                ++trackNumIndex;
            }
            ++batchseq;
        }
        if (sumDS != null && !sumDSList.isEmpty()) {
            sumDS = sumDS.union(sumDSList.toArray(new DataSet[0]));
        }
        String pid = DiffAnalysisRptNodeEnum.PERIODOUT.getValue();
        String rowId = DiffAnalysisRptNodeEnum.PERIODOUT_WIP.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODOUT_WIP.getDesc();
        if (sumDS != null && parentGroups != null) {
            sumDS = DiffAnalysisRptHelper.collectRowGroup4SumData(pid, rowId, rowType, sumDS, sonRowGroups, parentGroups);
        }
        return sumDS;
    }

    private DataSet addPeriodOut4OtherOutRowGroup(List<DiffAnalysisRptRowGroup> sonGroups) {
        DataSet otherOutDS = this.getDS4Other(false);
        String pid = DiffAnalysisRptNodeEnum.PERIODOUT.getValue();
        String rowId = DiffAnalysisRptNodeEnum.PERIODOUT_OTHER.getValue();
        String rowType = DiffAnalysisRptNodeEnum.PERIODOUT_OTHER.getDesc();
        otherOutDS = DiffAnalysisRptHelper.collectRowGroup4DtlData(pid, rowId, rowType, otherOutDS, sonGroups);
        return otherOutDS;
    }

    private DataSet getBalanceDS4PeriodBegin() {
        List<Object> auxptyIds;
        QFilter balanceQ = new QFilter("costaccount", "=", (Object)this.rptParam.getCostAccountId());
        balanceQ.and("material", "=", (Object)this.rptParam.getMaterialId());
        balanceQ.and("period", "<", (Object)this.rptParam.getPeriodInt());
        balanceQ.and("endperiod", ">=", (Object)this.rptParam.getPeriodInt());
        if (this.rptParam.getStorageOrgId() != null) {
            balanceQ.and("storageorgunit", "=", (Object)this.rptParam.getStorageOrgId());
        }
        if (this.rptParam.getWarehouseId() != null) {
            balanceQ.and("warehouse", "=", (Object)this.rptParam.getWarehouseId());
        }
        if (this.rptParam.getLocationId() != null) {
            balanceQ.and("location", "=", (Object)this.rptParam.getLocationId());
        }
        if (this.rptParam.getTracknumberId() != null) {
            balanceQ.and("tracknumber", "=", (Object)this.rptParam.getTracknumberId());
        }
        if (this.rptParam.getProjectId() != null) {
            balanceQ.and("project", "=", (Object)this.rptParam.getProjectId());
        }
        if (this.rptParam.getConfiguredcodeId() != null) {
            balanceQ.and("configuredcode", "=", (Object)this.rptParam.getConfiguredcodeId());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.rptParam.getLot())) {
            balanceQ.and("lot", "=", (Object)this.rptParam.getLot());
        }
        if ((auxptyIds = this.rptParam.getAuxptyIds()) != null) {
            balanceQ.and("assist", "in", auxptyIds);
        }
        DataSet calBalanceSet = null;
        if (CalBalanceModelHelper.isNewBalance()) {
            String newBalSelect = CalBalanceModelHelper.getDimFields((boolean)true) + ",id,currency,baseunit,baseqty_bal as periodendqty,standardcost_bal as periodendstandardcost,costdiff_bal as periodendcostdiff,actualcost_bal as periodendactualcost";
            String[] groupSelect = (CalBalanceModelHelper.getDimFields((boolean)false) + ",baseunit,currency").split(",");
            calBalanceSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)newBalSelect, (QFilter[])new QFilter[]{balanceQ}, null);
            boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
            calBalanceSet = balCompress ? calBalanceSet.groupBy(groupSelect).sum("periodendqty").max("id").sum("periodendstandardcost").sum("periodendcostdiff").sum("periodendactualcost").finish() : calBalanceSet.groupBy(groupSelect).max("periodendqty").max("id").sum("periodendstandardcost").sum("periodendcostdiff").sum("periodendactualcost").finish();
        } else {
            calBalanceSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)"id,material,baseunit,currency,periodendqty,periodendstandardcost,periodendcostdiff,periodendactualcost", (QFilter[])new QFilter[]{balanceQ}, null);
        }
        calBalanceSet = calBalanceSet.groupBy(new String[]{"material", "baseunit", "currency"}).max("id").sum("periodendqty").sum("periodendstandardcost").sum("periodendcostdiff").sum("periodendactualcost").finish();
        StringBuilder balanceSelectBuilder = new StringBuilder();
        balanceSelectBuilder.append("id,null as bookdate,null as auditdate,");
        balanceSelectBuilder.append("'' as bizobject,");
        balanceSelectBuilder.append("id as billid,");
        balanceSelectBuilder.append("0l as groupbillid,");
        balanceSelectBuilder.append("material,");
        balanceSelectBuilder.append("'");
        balanceSelectBuilder.append(DiffAnalysisRptHelper.getBeginBillTypeName(this.rptParam));
        balanceSelectBuilder.append("' as billtypename,");
        balanceSelectBuilder.append("'' as billno,");
        balanceSelectBuilder.append("' ' as vouchernum,");
        balanceSelectBuilder.append("0l as voucherid,");
        balanceSelectBuilder.append("periodendqty as qty,");
        balanceSelectBuilder.append("baseunit,");
        balanceSelectBuilder.append("currency,");
        balanceSelectBuilder.append("periodendstandardcost as standardamt,");
        balanceSelectBuilder.append("case when periodendqty != 0 then periodendstandardcost / periodendqty else 0 end as standprice,");
        balanceSelectBuilder.append("periodendactualcost as actualamt,");
        balanceSelectBuilder.append("case when periodendqty != 0 then periodendactualcost / periodendqty else 0 end as actualprice,");
        balanceSelectBuilder.append("periodendcostdiff as diff");
        return calBalanceSet.select(balanceSelectBuilder.toString());
    }

    private DataSet getDiffDS4PeriodBegin() {
        QFilter diffQ = this.diffBaseQfilter.copy();
        diffQ.and("createtype", "=", (Object)"C1");
        diffQ.and("entryentity.queuetype", "=", (Object)"0");
        String billTypeName = this.diffEntity.getDisplayName() + DiffAnalysisRptBillTypeEnum.DIFF_CALUPDATE.getDesc();
        String diffSelect = DiffAnalysisRptHelper.getDiffBill4PdBeginSelect(billTypeName);
        return QueryServiceHelper.queryDataSet((String)"PDBEGIN-QUERYDIFF", (String)"cal_stdcostdiffbill", (String)diffSelect, (QFilter[])diffQ.toArray(), null);
    }

    private DataSet getDiffDS4PurIn() {
        QFilter diffQ = this.diffBaseQfilter.copy();
        HashSet<String> billtypeSet = new HashSet<String>(16);
        billtypeSet.add("im_purinbill");
        billtypeSet.add("im_ospurinbill");
        diffQ.and("billtype.billformid", "in", billtypeSet);
        diffQ.and("biztype", "=", (Object)"A");
        QFilter updateCostQfilter = new QFilter("isupdatecost", "=", (Object)true);
        updateCostQfilter.and("createtype", "!=", (Object)"X");
        updateCostQfilter.and("createtype", "!=", (Object)"W");
        QFilter nullBillNoQfilter = new QFilter("isupdatecost", "=", (Object)true);
        nullBillNoQfilter.and("createtype", "=", (Object)"W");
        nullBillNoQfilter.and("entryentity.invbillnum", "=", (Object)"");
        QFilter notUpdateCostQfilter = new QFilter("isupdatecost", "=", (Object)false);
        notUpdateCostQfilter.and("createtype", "!=", (Object)"A");
        diffQ.and(updateCostQfilter.or(nullBillNoQfilter).or(notUpdateCostQfilter));
        String billTypeName = this.diffEntity.getDisplayName() + DiffAnalysisRptBillTypeEnum.DIFF_NOSHARE.getDesc();
        String diffSelect = DiffAnalysisRptHelper.getDiffBill4PurInSelect(billTypeName);
        DataSet diffDS = QueryServiceHelper.queryDataSet((String)"PURIN-QUERYDIFF", (String)"cal_stdcostdiffbill", (String)diffSelect, (QFilter[])diffQ.toArray(), null);
        return diffDS;
    }

    private DataSet getRecordDS4PurIn() {
        QFilter recordQ = this.recordBaseQfilter.copy();
        HashSet<String> billtypeSet = new HashSet<String>(16);
        billtypeSet.add("im_purinbill");
        billtypeSet.add("im_ospurinbill");
        billtypeSet.add("im_mdc_ominbill");
        recordQ.and("bizentityobject", "in", billtypeSet);
        recordQ.and("isinitbill", "=", (Object)false);
        recordQ.and("issplitcreate", "=", (Object)false);
        recordQ.and("calbilltype", "=", (Object)"IN");
        String recordSelect = DiffAnalysisRptHelper.getRecordBillBaseSelect();
        DataSet recordDS = QueryServiceHelper.queryDataSet((String)"PURIN-QUERYRECORD", (String)"cal_costrecord_subentity", (String)recordSelect, (QFilter[])recordQ.toArray(), null);
        return recordDS;
    }

    private DataSet getDS4ProduceIn() {
        HashSet<String> produceInBills = new HashSet<String>(16);
        produceInBills.add("im_mdc_mftmanuinbill");
        produceInBills.add("im_mdc_mftreturnbill");
        produceInBills.add("im_mdc_omcmplinbill");
        produceInBills.add("im_productinbill");
        QFilter recordQ = this.recordBaseQfilter.copy();
        recordQ.and("bizentityobject", "in", produceInBills);
        recordQ.and("isinitbill", "=", (Object)false);
        recordQ.and("issplitcreate", "=", (Object)false);
        recordQ.and("calbilltype", "=", (Object)"IN");
        String recordSelect = DiffAnalysisRptHelper.getRecordBillBaseSelect();
        recordSelect = recordSelect + ",entry.mainbillnumber as mainbillnum";
        DataSet recordDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)recordSelect, (QFilter[])recordQ.toArray(), null);
        StringBuilder sBuilder = new StringBuilder();
        for (String fieldName : recordDS.getRowMeta().getFieldNames()) {
            if ("billtypename".equals(fieldName)) {
                fieldName = "case when mainbillnum = '' then billtypename else billtypename + '(' + mainbillnum + ')' end as billtypename";
            }
            if ("mainbillnum".equals(fieldName)) continue;
            sBuilder.append(fieldName);
            sBuilder.append(",");
        }
        recordDS = recordDS.select(CommonUtils.trimComma((String)sBuilder.toString()));
        QFilter diffQ = this.diffBaseQfilter.copy();
        diffQ.and("billtype.billformid", "in", produceInBills);
        diffQ.and("biztype", "=", (Object)"A");
        diffQ.and("createtype", "!=", (Object)"X");
        QFilter notUpdateCostQfilter = new QFilter("isupdatecost", "=", (Object)false);
        notUpdateCostQfilter.and("createtype", "!=", (Object)"A");
        notUpdateCostQfilter.or("isupdatecost", "=", (Object)true);
        diffQ.and(notUpdateCostQfilter);
        String diffSelect = DiffAnalysisRptHelper.getDiffBill4ProduceSelect();
        DataSet diffDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)diffSelect, (QFilter[])diffQ.toArray(), null);
        return recordDS.union(diffDS);
    }

    private DataSet getDS4Other(boolean isInBill) {
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(16);
        HashSet<String> otherInBills = new HashSet<String>(16);
        otherInBills.add("im_assembbill");
        otherInBills.add("im_disassemblebill");
        otherInBills.add("im_adjustbill");
        otherInBills.add("im_locationtransfer");
        otherInBills.add("im_osmaterialreqoutbill");
        if (isInBill) {
            otherInBills.add("im_otherinbill");
        } else {
            otherInBills.add("im_otheroutbill");
        }
        QFilter recordQ = this.recordBaseQfilter.copy();
        recordQ.and("isinitbill", "=", (Object)false);
        recordQ.and("issplitcreate", "=", (Object)false);
        if (isInBill) {
            recordQ.and("calbilltype", "=", (Object)"IN");
        } else {
            recordQ.and("calbilltype", "=", (Object)"OUT");
        }
        QFilter recordReOutQ = new QFilter("bizentityobject", "=", (Object)"im_materialreqoutbill");
        recordReOutQ.and("entry.ecostcenter.orgduty", "not in", (Object)new int[]{4, 5});
        String recordSelect = DiffAnalysisRptHelper.getRecordBillBaseSelect();
        QFilter diffQ = this.diffBaseQfilter.copy();
        diffQ.and("createtype", "!=", (Object)"X");
        QFilter notUpdateCostQfilter = new QFilter("isupdatecost", "=", (Object)false);
        notUpdateCostQfilter.and("createtype", "!=", (Object)"A");
        notUpdateCostQfilter.or("isupdatecost", "=", (Object)true);
        diffQ.and(notUpdateCostQfilter);
        if (isInBill) {
            diffQ.and("biztype", "=", (Object)"A");
        } else {
            diffQ.and("biztype", "=", (Object)"B");
        }
        QFilter diffReOutQ = new QFilter("billtype.billformid", "=", (Object)"im_materialreqoutbill");
        diffReOutQ.and("entryentity.ecostcenter.orgduty", "not in", (Object)new int[]{4, 5});
        String diffSelect = DiffAnalysisRptHelper.getDiffBill4OtherInSelect();
        OrmInput recordInput = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord_subentity", recordSelect, recordQ.copy().and("bizentityobject", "in", otherInBills).toArray());
        OrmInput recordInputReOut = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord_subentity", recordSelect, recordQ.and(recordReOutQ).toArray());
        OrmInput diffInput = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_stdcostdiffbill", diffSelect, diffQ.copy().and("billtype.billformid", "in", otherInBills).toArray());
        OrmInput diffInputReOut = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_stdcostdiffbill", diffSelect, diffQ.and(diffReOutQ).toArray());
        billIOs.add(recordInput);
        billIOs.add(recordInputReOut);
        billIOs.add(diffInput);
        billIOs.add(diffInputReOut);
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet otherInDS = algo.createDataSet((Input[])billIOs.toArray(new OrmInput[billIOs.size()]));
        otherInDS = DiffAnalysisRptHelper.setAmountFieldsType(otherInDS);
        return otherInDS;
    }

    private DataSet getDS4SpecialIn() {
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(16);
        QFilter recordQ = this.recordBaseQfilter.copy();
        recordQ.and("bizentityobject", "=", (Object)"im_saloutbill");
        recordQ.and("isinitbill", "=", (Object)false);
        recordQ.and("issplitcreate", "=", (Object)false);
        recordQ.and("entry.queuetype", "=", (Object)"0");
        String recordSelect = DiffAnalysisRptHelper.getRecordBill4SpecialInBaseSelect();
        QFilter diffQ = this.diffBaseQfilter.copy();
        diffQ.and("billtype.billformid", "=", (Object)"im_saloutbill");
        diffQ.and("entryentity.queuetype", "=", (Object)"0");
        diffQ.and("createtype", "!=", (Object)"X");
        QFilter notUpdateCostQfilter = new QFilter("isupdatecost", "=", (Object)false);
        notUpdateCostQfilter.and("createtype", "!=", (Object)"A");
        notUpdateCostQfilter.or("isupdatecost", "=", (Object)true);
        diffQ.and(notUpdateCostQfilter);
        String diffSelect = DiffAnalysisRptHelper.getDiffBill4SpecialInSelect();
        OrmInput recordInput = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord_subentity", recordSelect, recordQ.toArray());
        OrmInput diffInput = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_stdcostdiffbill", diffSelect, diffQ.toArray());
        billIOs.add(recordInput);
        billIOs.add(diffInput);
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet specialInDS = algo.createDataSet((Input[])billIOs.toArray(new OrmInput[billIOs.size()]));
        specialInDS = DiffAnalysisRptHelper.setAmountFieldsType(specialInDS);
        return specialInDS;
    }

    private DataSet getDS4SaleOut() {
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(16);
        QFilter recordQ = this.recordBaseQfilter.copy();
        recordQ.and("bizentityobject", "=", (Object)"im_saloutbill");
        recordQ.and("isinitbill", "=", (Object)false);
        recordQ.and("issplitcreate", "=", (Object)false);
        recordQ.and("entry.queuetype", "=", (Object)"1");
        String recordSelect = DiffAnalysisRptHelper.getRecordBill4SaleOutSelect();
        QFilter diffQ = this.diffBaseQfilter.copy();
        diffQ.and("billtype.billformid", "=", (Object)"im_saloutbill");
        diffQ.and("entryentity.queuetype", "=", (Object)"1");
        diffQ.and("createtype", "!=", (Object)"X");
        QFilter notUpdateCostQfilter = new QFilter("isupdatecost", "=", (Object)false);
        notUpdateCostQfilter.and("createtype", "!=", (Object)"A");
        notUpdateCostQfilter.or("isupdatecost", "=", (Object)true);
        diffQ.and(notUpdateCostQfilter);
        String diffSelect = DiffAnalysisRptHelper.getDiffBill4SaleOutSelect();
        OrmInput recordInput = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord_subentity", recordSelect, recordQ.toArray());
        OrmInput diffInput = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_stdcostdiffbill", diffSelect, diffQ.toArray());
        billIOs.add(recordInput);
        billIOs.add(diffInput);
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet saleOutDS = algo.createDataSet((Input[])billIOs.toArray(new OrmInput[billIOs.size()]));
        saleOutDS = DiffAnalysisRptHelper.setAmountFieldsType(saleOutDS);
        return saleOutDS;
    }

    private DataSet getRecordDS4ProduceOut() {
        HashSet<String> entityNums = new HashSet<String>(16);
        entityNums.add("im_mdc_mftproorder");
        entityNums.add("im_mdc_mftfeedorder");
        entityNums.add("im_mdc_mftreturnorder");
        entityNums.add("im_mdc_omoutbill");
        entityNums.add("im_mdc_omfeedbill");
        entityNums.add("im_mdc_omreturnbill");
        QFilter recordQ = this.recordBaseQfilter.copy();
        recordQ.and("bizentityobject", "in", entityNums);
        recordQ.and("isinitbill", "=", (Object)false);
        recordQ.and("issplitcreate", "=", (Object)false);
        recordQ.and("calbilltype", "=", (Object)"OUT");
        String recordSelect = DiffAnalysisRptHelper.getRecordBill4ProduceOutSelect();
        DataSet recordProduceDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)recordSelect, (QFilter[])recordQ.toArray(), null);
        return recordProduceDS;
    }

    private DataSet getDiffDS4ProduceOut() {
        HashSet<String> entityNums = new HashSet<String>(16);
        entityNums.add("im_mdc_mftproorder");
        entityNums.add("im_mdc_mftfeedorder");
        entityNums.add("im_mdc_mftreturnorder");
        entityNums.add("im_mdc_omoutbill");
        entityNums.add("im_mdc_omfeedbill");
        entityNums.add("im_mdc_omreturnbill");
        QFilter diffQ = this.diffBaseQfilter.copy();
        diffQ.and("billtype.billformid", "in", entityNums);
        diffQ.and("biztype", "=", (Object)"B");
        diffQ.and("createtype", "!=", (Object)"X");
        QFilter notUpdateCostQfilter = new QFilter("isupdatecost", "=", (Object)false);
        notUpdateCostQfilter.and("createtype", "!=", (Object)"A");
        notUpdateCostQfilter.or("isupdatecost", "=", (Object)true);
        diffQ.and(notUpdateCostQfilter);
        String diffSelect = DiffAnalysisRptHelper.getDiffBill4ProduceOutSelect();
        DataSet diffDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_stdcostdiffbill", (String)diffSelect, (QFilter[])diffQ.toArray(), null);
        return diffDS;
    }

    private DataSet getProduceOrderDS(Set<Long> orderEntryIdSet, DataSet recoerdDS) {
        HashSet<Long> pomBillIDSet = new HashSet<Long>(16);
        HashSet<Long> pomBillEntryIDSet = new HashSet<Long>(16);
        HashSet<Long> omBillIDSet = new HashSet<Long>(16);
        HashSet<Long> omBillEntryIDSet = new HashSet<Long>(16);
        DataSet mainBillDS = recoerdDS.groupBy(new String[]{"bizentityobject", "srcbillid", "srcbillentryid"}).finish();
        for (Row row : mainBillDS) {
            String entityNum = row.getString("bizentityobject");
            Long mainBillID = row.getLong("srcbillid");
            Long mainBillEntryID = row.getLong("srcbillentryid");
            if (mainBillID.compareTo(0L) == 0) continue;
            orderEntryIdSet.add(mainBillEntryID);
            if (entityNum.equals("im_mdc_mftproorder") || entityNum.equals("im_mdc_mftfeedorder") || entityNum.equals("im_mdc_mftreturnorder")) {
                pomBillIDSet.add(mainBillID);
                pomBillEntryIDSet.add(mainBillEntryID);
                continue;
            }
            omBillIDSet.add(mainBillID);
            omBillEntryIDSet.add(mainBillEntryID);
        }
        if (orderEntryIdSet.isEmpty()) {
            StringBuilder orderEntryIdSetBuilder = new StringBuilder();
            orderEntryIdSetBuilder.append("id as orderid,");
            orderEntryIdSetBuilder.append("treeentryentity.id as orderentryid,");
            orderEntryIdSetBuilder.append("treeentryentity.material.masterid.number as ordermatnum,");
            orderEntryIdSetBuilder.append("treeentryentity.material.masterid as ordermatid,");
            orderEntryIdSetBuilder.append("treeentryentity.tracknumber.number as ordertracknum,");
            orderEntryIdSetBuilder.append("treeentryentity.tracknumber as ordertracknumid,");
            orderEntryIdSetBuilder.append("'' as orderentitynum");
            return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pom_mftorder", (String)orderEntryIdSetBuilder.toString(), (QFilter[])QFilter.of((String)"1 != 1", (Object[])new Object[0]).toArray(), null);
        }
        ArrayList<OrmInput> orderBillIOs = new ArrayList<OrmInput>(16);
        if (!pomBillIDSet.isEmpty()) {
            QFilter pomQ = new QFilter("id", "in", pomBillIDSet);
            pomQ.and("treeentryentity.id", "in", pomBillEntryIDSet);
            StringBuilder pomBillIDSetBuilder = new StringBuilder();
            pomBillIDSetBuilder.append("id as orderid,");
            pomBillIDSetBuilder.append("treeentryentity.id as orderentryid,");
            pomBillIDSetBuilder.append("treeentryentity.material.masterid.number as ordermatnum,");
            pomBillIDSetBuilder.append("treeentryentity.material.masterid as ordermatid,");
            pomBillIDSetBuilder.append("treeentryentity.tracknumber.number as ordertracknum,");
            pomBillIDSetBuilder.append("treeentryentity.tracknumber as ordertracknumid,");
            pomBillIDSetBuilder.append("'pom_mftorder' as orderentitynum");
            String pomSelect = pomBillIDSetBuilder.toString();
            OrmInput pomInput = new OrmInput(((Object)((Object)this)).getClass().getName(), "pom_mftorder", pomSelect, pomQ.toArray());
            orderBillIOs.add(pomInput);
        }
        if (!omBillIDSet.isEmpty()) {
            QFilter omQ = new QFilter("id", "in", omBillIDSet);
            omQ.and("treeentryentity.id", "in", omBillEntryIDSet);
            StringBuilder omBillIDSetBuilder = new StringBuilder();
            omBillIDSetBuilder.append("id as orderid,");
            omBillIDSetBuilder.append("treeentryentity.id as orderentryid,");
            omBillIDSetBuilder.append("treeentryentity.material.masterid.number as ordermatnum,");
            omBillIDSetBuilder.append("treeentryentity.material.masterid as ordermatid,");
            omBillIDSetBuilder.append("treeentryentity.tracknumber.number as ordertracknum,");
            omBillIDSetBuilder.append("treeentryentity.tracknumber as ordertracknumid,");
            omBillIDSetBuilder.append("'om_mftorder' as orderentitynum");
            String omSelect = omBillIDSetBuilder.toString();
            OrmInput omInput = new OrmInput(((Object)((Object)this)).getClass().getName(), "om_mftorder", omSelect, omQ.toArray());
            orderBillIOs.add(omInput);
        }
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet orderBillDS = algo.createDataSet((Input[])orderBillIOs.toArray(new OrmInput[orderBillIOs.size()]));
        orderBillDS.getRowMeta().getField("orderentitynum").setDataType((DataType)new StringType());
        return orderBillDS;
    }

    private DataSet getDiffCalDS(Set<Long> orderEntryIdSet) {
        QFilter q = new QFilter("costaccount", "=", (Object)this.rptParam.getCostAccountId());
        q.and("org", "=", (Object)this.rptParam.getCalOrgId());
        q.and("period", "=", (Object)this.rptParam.getPeriodId());
        q.and("costobject.probill", "in", orderEntryIdSet);
        q.and("entryentity2.material2", "=", (Object)this.rptParam.getMaterialId());
        q.and("entryentity2.endqty2", "!=", (Object)BigDecimal.ZERO);
        StringBuilder selectBuilder = new StringBuilder();
        selectBuilder.append("entryentity2.id as id,null as bookdate,null as auditdate,");
        selectBuilder.append("'' as bizobject,");
        selectBuilder.append("id as billid,");
        selectBuilder.append("0l as groupbillid,");
        selectBuilder.append("entryentity2.material2 as material,");
        selectBuilder.append("'");
        selectBuilder.append(DiffAnalysisRptBillTypeEnum.ORDERBILL.getDesc());
        selectBuilder.append("' as billtypename,");
        selectBuilder.append("costobject.srcbillnumber as billno,");
        selectBuilder.append("'' as vouchernum,");
        selectBuilder.append("0l as voucherid,");
        selectBuilder.append("entryentity2.endqty2  * -1 as qty,");
        selectBuilder.append("entryentity2.baseunit2 as baseunit,");
        selectBuilder.append("currency,");
        selectBuilder.append("entryentity2.endamt2 * -1 as standardamt,");
        selectBuilder.append("case when entryentity2.endqty2 != 0 then entryentity2.endamt2 / entryentity2.endqty2 else 0 end as standprice,");
        selectBuilder.append("entryentity2.enddiffqty2 as actualamt,");
        selectBuilder.append("entryentity2.enddiffqty2 as actualprice,");
        selectBuilder.append("(entryentity2.enddiffqty2 + entryentity2.endmadediff2 + entryentity2.endmadeupamt2 + entryentity2.endunjoindiffamt2 + entryentity2.endstdcostupamt2 + entryentity2.endorddiff2 + entryentity2.endinvoicediff2 + entryentity2.endfeediff2 + entryentity2.endfalldiff2  + entryentity2.endotherdiff2) * -1 as diff,");
        selectBuilder.append("'' as bizentityobject,");
        selectBuilder.append("0l as srcbillid,");
        selectBuilder.append("costobject.probill as srcbillentryid");
        DataSet diffCalDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sca_diffcalcresult", (String)selectBuilder.toString(), (QFilter[])q.toArray(), null);
        HashMap<String, String> replaceMap = new HashMap<String, String>(16);
        replaceMap.put("actualamt", "standardamt + diff as actualamt");
        replaceMap.put("actualprice", "case when qty != 0 then (standardamt + diff) / qty else 0 end as actualprice");
        String calSelect = DiffAnalysisRptHelper.getSelectByRowMeta(replaceMap, diffCalDS.getRowMeta());
        diffCalDS = diffCalDS.select(calSelect);
        return diffCalDS;
    }

    private DataSet getDS4CostCenter() {
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(16);
        QFilter recordQ = this.recordBaseQfilter.copy();
        recordQ.and("bizentityobject", "=", (Object)"im_materialreqoutbill");
        recordQ.and("isinitbill", "=", (Object)false);
        recordQ.and("issplitcreate", "=", (Object)false);
        recordQ.and("calbilltype", "=", (Object)"OUT");
        recordQ.and("entry.ecostcenter.orgduty", "in", (Object)new int[]{4, 5});
        String recordSelect = DiffAnalysisRptHelper.getRecordBill4CostCenterSelect();
        QFilter diffQ = this.diffBaseQfilter.copy();
        diffQ.and("billtype.billformid", "=", (Object)"im_materialreqoutbill");
        diffQ.and("biztype", "=", (Object)"B");
        diffQ.and("entryentity.ecostcenter.orgduty", "in", (Object)new int[]{4, 5});
        diffQ.and("createtype", "!=", (Object)"X");
        QFilter notUpdateCostQfilter = new QFilter("isupdatecost", "=", (Object)false);
        notUpdateCostQfilter.and("createtype", "!=", (Object)"A");
        notUpdateCostQfilter.or("isupdatecost", "=", (Object)true);
        diffQ.and(notUpdateCostQfilter);
        String diffSelect = DiffAnalysisRptHelper.getDiffBill4SCostCenterSelect();
        OrmInput recordInput = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord_subentity", recordSelect, recordQ.toArray());
        OrmInput diffInput = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_stdcostdiffbill", diffSelect, diffQ.toArray());
        billIOs.add(recordInput);
        billIOs.add(diffInput);
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet saleOutDS = algo.createDataSet((Input[])billIOs.toArray(new OrmInput[billIOs.size()]));
        saleOutDS = DiffAnalysisRptHelper.setAmountFieldsType(saleOutDS);
        return saleOutDS;
    }

    private DataSet getDS4Trans(boolean isInBill) {
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(16);
        HashSet<String> entityNums = new HashSet<String>(16);
        entityNums.add("im_transinbill");
        entityNums.add("im_transoutbill");
        entityNums.add("im_transdirbill");
        QFilter recordQ = this.recordBaseQfilter.copy();
        recordQ.and("bizentityobject", "in", entityNums);
        recordQ.and("isinitbill", "=", (Object)false);
        recordQ.and("issplitcreate", "=", (Object)false);
        if (isInBill) {
            recordQ.and("calbilltype", "=", (Object)"IN");
        } else {
            recordQ.and("calbilltype", "=", (Object)"OUT");
        }
        String recordSelect = DiffAnalysisRptHelper.getRecordBillBaseSelect();
        recordSelect = recordSelect + ",transtype";
        QFilter diffQ = this.diffBaseQfilter.copy();
        diffQ.and("billtype.billformid", "in", entityNums);
        if (isInBill) {
            diffQ.and("biztype", "=", (Object)"A");
        } else {
            diffQ.and("biztype", "=", (Object)"B");
        }
        diffQ.and("createtype", "!=", (Object)"X");
        QFilter notUpdateCostQfilter = new QFilter("isupdatecost", "=", (Object)false);
        notUpdateCostQfilter.and("createtype", "!=", (Object)"A");
        notUpdateCostQfilter.or("isupdatecost", "=", (Object)true);
        diffQ.and(notUpdateCostQfilter);
        String diffSelect = DiffAnalysisRptHelper.getDiffBill4TransInSelect();
        OrmInput recordInput = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord_subentity", recordSelect, recordQ.toArray());
        OrmInput diffInput = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_stdcostdiffbill", diffSelect, diffQ.toArray());
        billIOs.add(recordInput);
        billIOs.add(diffInput);
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSet transDS = algo.createDataSet((Input[])billIOs.toArray(new OrmInput[billIOs.size()]));
        transDS = DiffAnalysisRptHelper.setAmountFieldsType(transDS);
        return transDS;
    }

    private DataSet joinDiffGroupBillVoucher(DataSet dataSet) {
        List<Object> auxptyIds;
        QFilter q = new QFilter("costaccount", "=", (Object)this.rptParam.getCostAccountId());
        q.and("billstatus", "=", (Object)"C");
        q.and("calorg", "=", (Object)this.rptParam.getCalOrgId());
        q.and("period", "=", (Object)this.rptParam.getPeriodId());
        q.and("material", "=", (Object)this.rptParam.getMaterialId());
        if (this.rptParam.getStorageOrgId() != null) {
            q.and("storageorgunit", "=", (Object)this.rptParam.getStorageOrgId());
        }
        if (this.rptParam.getWarehouseId() != null) {
            q.and("warehouse", "=", (Object)this.rptParam.getWarehouseId());
        }
        if (this.rptParam.getLocationId() != null) {
            q.and("location", "=", (Object)this.rptParam.getLocationId());
        }
        if (this.rptParam.getTracknumberId() != null) {
            q.and("tracknumber", "=", (Object)this.rptParam.getTracknumberId());
        }
        if (this.rptParam.getProjectId() != null) {
            q.and("project", "=", (Object)this.rptParam.getProjectId());
        }
        if (this.rptParam.getConfiguredcodeId() != null) {
            q.and("configuredcode", "=", (Object)this.rptParam.getConfiguredcodeId());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.rptParam.getLot())) {
            q.and("lot", "=", (Object)this.rptParam.getLot());
        }
        if ((auxptyIds = this.rptParam.getAuxptyIds()) != null) {
            q.and("assist", "in", auxptyIds);
        }
        q.and("isvoucher", "=", (Object)true);
        String diffGroupSelect = "id as groupbillid,voucherid as groupvoucherid,vouchernum as groupvouchernum";
        DataSet groupDS = QueryServiceHelper.queryDataSet((String)"PDBEGIN-QUERYDIFFGROUP", (String)"cal_costdiffgroupbill", (String)diffGroupSelect, (QFilter[])q.toArray(), null);
        dataSet = dataSet.leftJoin(groupDS).on("groupbillid", "groupbillid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"groupvoucherid", "groupvouchernum"}).finish();
        HashMap<String, String> replaceMap = new HashMap<String, String>(16);
        replaceMap.put("voucherid", "case when groupvoucherid != null then groupvoucherid else voucherid end as voucherid");
        replaceMap.put("vouchernum", "case when groupvouchernum != null then groupvouchernum else vouchernum end as vouchernum");
        String billSelect = DiffAnalysisRptHelper.getSelectByRowMeta(replaceMap, dataSet.getRowMeta());
        dataSet = dataSet.select(billSelect);
        return dataSet;
    }
}

