/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.helper.DomainBalHelper;
import kd.fi.cal.mservice.api.AcaVoucherSynService;

public class AcaVoucherSynServiceImpl
implements AcaVoucherSynService {
    private static final Log logger = LogFactory.getLog(AcaVoucherSynServiceImpl.class);
    private static final String creatType = "0";
    private static final String deleteType = "1";

    public List<Map<String, String>> voucherSynProcess(String operateType, Long costAccountId, List<Map<String, String>> paramList) {
        boolean needUpdateDomainBal;
        long start = System.currentTimeMillis();
        logger.info("AcaVoucherSynServiceImpl voucherSynProcess param,operateType==>{},costAccountId==>{},paramList==>{}", new Object[]{operateType, costAccountId, paramList});
        ArrayList<Map<String, String>> returnList = new ArrayList<Map<String, String>>(paramList.size());
        if (!this.checkParams(operateType, costAccountId, paramList, returnList)) {
            return returnList;
        }
        QFilter filter = this.buildFilter(costAccountId, paramList);
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,calorg,costaccount,vouchertype,dischargetype,bizbillid,isfivoucher,fivouchernum,fivoucherid", (QFilter[])new QFilter[]{filter});
        HashMap<String, DynamicObject> costRecordMap = new HashMap<String, DynamicObject>(costRecords.size());
        HashSet<Long> allBillIds = new HashSet<Long>(16);
        for (DynamicObject costRecord : costRecords) {
            costRecordMap.put(costRecord.getString("costaccount") + "@" + costRecord.getString("bizbillid"), costRecord);
            allBillIds.add(costRecord.getLong("id"));
        }
        if (creatType.equals(operateType)) {
            List voucherIds = paramList.stream().map(r -> Long.parseLong((String)r.get("voucherId"))).collect(Collectors.toList());
            DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id,period,period.periodyear as periodyear,period.periodnumber as periodnumber,createtime", (QFilter[])new QFilter[]{new QFilter("id", "in", voucherIds)});
            HashMap<Long, DynamicObject> voucherMap = new HashMap<Long, DynamicObject>(voucherIds.size());
            for (DynamicObject voucher : vouchers) {
                voucherMap.put(voucher.getLong("id"), voucher);
            }
            this.writeBackVoucherToRecord(returnList, costAccountId, paramList, costRecordMap, voucherMap);
            boolean needUpdateDomainBal2 = new DomainBalHelper().needUpdateDomainBal();
            if (needUpdateDomainBal2) {
                new BalanceOpInvoker().invokeCostRecordUpdateBalOp(allBillIds, null);
            }
            logger.info("AcaVoucherSynServiceImpl voucherSynProcess time consuming==>{},return result==>{}", (Object)(System.currentTimeMillis() - start), returnList);
            return returnList;
        }
        if (deleteType.equals(operateType)) {
            List recordIds = costRecords.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            DynamicObjectCollection calVoucher = QueryServiceHelper.query((String)"cal_voucher", (String)"costrecordid,vouchersource", (QFilter[])new QFilter[]{new QFilter("costrecordid", "in", recordIds)});
            HashMap<Long, String> voucherSourceMap = new HashMap<Long, String>(calVoucher.size());
            for (DynamicObject dynamicObject : calVoucher) {
                voucherSourceMap.put(dynamicObject.getLong("costrecordid"), dynamicObject.getString("vouchersource"));
            }
            this.deleteCalVoucherAndUpdateRecord(returnList, costAccountId, paramList, costRecordMap, voucherSourceMap);
        }
        if (needUpdateDomainBal = new DomainBalHelper().needUpdateDomainBal()) {
            new BalanceOpInvoker().invokeCostRecordUpdateBalOp(allBillIds, null);
        }
        logger.info("AcaVoucherSynServiceImpl voucherSynProcess time consuming==>{},return result==>{}", (Object)(System.currentTimeMillis() - start), returnList);
        return returnList;
    }

    private void writeBackVoucherToRecord(List<Map<String, String>> returnList, Long costAccountId, List<Map<String, String>> paramList, Map<String, DynamicObject> costRecordMap, Map<Long, DynamicObject> voucherMap) {
        ArrayList<Object[]> updateParam = new ArrayList<Object[]>(paramList.size());
        ArrayList<DynamicObject> calVoucherList = new ArrayList<DynamicObject>(paramList.size());
        for (Map<String, String> param : paramList) {
            HashMap<String, String> returnMap = new HashMap<String, String>(1);
            returnMap.put("billNo", param.get("billNo"));
            DynamicObject record = costRecordMap.get(costAccountId.toString() + "@" + param.get("bizBillId"));
            if (record != null) {
                if (record.getBoolean("isfivoucher")) {
                    returnMap.put("status", creatType);
                    returnMap.put("msg", ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002", (String)"AcaVoucherSynServiceImpl_2", (String)"fi-cal-mservice", (Object[])new Object[0]));
                } else {
                    updateParam.add(new Object[]{Long.parseLong(param.get("voucherId")), param.get("voucherNum"), record.getLong("id")});
                    this.buildCalVoucher(calVoucherList, param, record, voucherMap);
                    returnMap.put("status", deleteType);
                    returnMap.put("msg", ResManager.loadKDString((String)"\u51ed\u8bc1\u53cd\u5199\u6210\u529f", (String)"AcaVoucherSynServiceImpl_3", (String)"fi-cal-mservice", (Object[])new Object[0]));
                }
            } else {
                returnMap.put("status", creatType);
                returnMap.put("msg", ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"AcaVoucherSynServiceImpl_4", (String)"fi-cal-mservice", (Object[])new Object[0]));
            }
            returnList.add(returnMap);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                List splitList;
                if (!updateParam.isEmpty()) {
                    splitList = Lists.partition(updateParam, (int)100);
                    String updateSql = "update t_cal_calcostrecord set fisfivoucher = '1',fisvoucher = '1',ffivoucherid = ?,ffivouchernum = ? where fid = ?";
                    for (List list : splitList) {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateSql, (List)list);
                    }
                }
                if (!calVoucherList.isEmpty()) {
                    splitList = Lists.partition(calVoucherList, (int)100);
                    for (List list : splitList) {
                        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.info("\u5b9e\u9645\u6210\u672c\u51ed\u8bc1\u53cd\u5199\u53d1\u751f\u5f02\u5e38==>{}", (Object)e);
                throw e;
            }
        }
    }

    private void deleteCalVoucherAndUpdateRecord(List<Map<String, String>> returnList, Long costAccountId, List<Map<String, String>> paramList, Map<String, DynamicObject> costRecordMap, Map<Long, String> voucherSourceMap) {
        ArrayList<Object[]> updateParam = new ArrayList<Object[]>(paramList.size());
        for (Map<String, String> param : paramList) {
            HashMap<String, String> returnMap = new HashMap<String, String>(1);
            returnMap.put("billNo", param.get("billNo"));
            DynamicObject record = costRecordMap.get(costAccountId.toString() + "@" + param.get("bizBillId"));
            if (record != null) {
                if (!record.getBoolean("isfivoucher")) {
                    returnMap.put("status", deleteType);
                    returnMap.put("msg", ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u672a\u751f\u6210\u51ed\u8bc1\u3002", (String)"AcaVoucherSynServiceImpl_5", (String)"fi-cal-mservice", (Object[])new Object[0]));
                } else {
                    String voucherSource = voucherSourceMap.get(record.getLong("id"));
                    if (!"E".equals(voucherSource)) {
                        returnMap.put("status", creatType);
                        returnMap.put("msg", ResManager.loadKDString((String)"\u5b58\u8d27\u6838\u7b97\u4e2d\u5f53\u524d\u51ed\u8bc1\u4e0d\u4e3a\u6210\u672c\u53cd\u5199\u751f\u6210\uff0c\u4e0d\u652f\u6301\u5220\u9664\u3002", (String)"AcaVoucherSynServiceImpl_6", (String)"fi-cal-mservice", (Object[])new Object[0]));
                    } else {
                        updateParam.add(new Object[]{record.getLong("id")});
                        returnMap.put("status", deleteType);
                        returnMap.put("msg", ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1\u6210\u529f", (String)"AcaVoucherSynServiceImpl_7", (String)"fi-cal-mservice", (Object[])new Object[0]));
                    }
                }
            } else {
                returnMap.put("status", creatType);
                returnMap.put("msg", ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"AcaVoucherSynServiceImpl_8", (String)"fi-cal-mservice", (Object[])new Object[0]));
            }
            returnList.add(returnMap);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (!updateParam.isEmpty()) {
                    List splitList = Lists.partition(updateParam, (int)100);
                    String updateRecordSql = "update t_cal_calcostrecord set fisfivoucher = '0',fisvoucher = '0',ffivoucherid = 0,ffivouchernum = ' ' where fid = ?";
                    String deleteCalVoucherSql = "delete from t_cal_voucher where fcostrecordid = ?";
                    for (List listParam : splitList) {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateRecordSql, (List)listParam);
                        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)deleteCalVoucherSql, (List)listParam);
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.info("\u5b9e\u9645\u6210\u672c\u51ed\u8bc1\u5220\u9664\u53d1\u751f\u5f02\u5e38==>{}", (Object)e);
                throw e;
            }
        }
    }

    private void buildCalVoucher(List<DynamicObject> calVoucherList, Map<String, String> param, DynamicObject record, Map<Long, DynamicObject> voucherMap) {
        DynamicObject voucher = voucherMap.get(Long.parseLong(param.get("voucherId")));
        if (voucher != null) {
            DynamicObject calVoucher = BusinessDataServiceHelper.newDynamicObject((String)"cal_voucher");
            calVoucher.set("costaccount_id", (Object)record.getLong("costaccount"));
            calVoucher.set("calorg_id", (Object)record.getLong("calorg"));
            calVoucher.set("costrecordid", (Object)record.getLong("id"));
            calVoucher.set("vouchertype", record.get("vouchertype"));
            calVoucher.set("dischargetype", (Object)record.getString("dischargetype"));
            calVoucher.set("year", voucher.get("periodyear"));
            calVoucher.set("period", voucher.get("periodnumber"));
            calVoucher.set("periodid", voucher.get("period"));
            calVoucher.set("voucherid", (Object)voucher.getLong("id"));
            calVoucher.set("createtime", voucher.get("createtime"));
            calVoucher.set("vouchernum", (Object)param.get("voucherNum"));
            calVoucher.set("createmode", (Object)0);
            calVoucher.set("vouchersource", (Object)"E");
            calVoucherList.add(calVoucher);
        }
    }

    private QFilter buildFilter(Long costAccountId, List<Map<String, String>> paramList) {
        ArrayList<Long> bizBillIds = new ArrayList<Long>(paramList.size());
        for (Map<String, String> map : paramList) {
            bizBillIds.add(Long.parseLong(map.get("bizBillId")));
        }
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
        filter.and("bizbillid", "in", bizBillIds);
        return filter;
    }

    private boolean checkParams(String operateType, Long costAccountId, List<Map<String, String>> paramList, List<Map<String, String>> returnList) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        for (Map<String, String> param : paramList) {
            if (!creatType.equals(operateType) && !deleteType.equals(operateType) || costAccountId == null || param.get("billNo") == null || param.get("bizBillId") == null || param.get("voucherNum") == null) {
                map.put("status", creatType);
                map.put("msg", ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u3002", (String)"AcaVoucherSynServiceImpl_1", (String)"fi-cal-mservice", (Object[])new Object[0]));
                returnList.add(map);
                return false;
            }
            if (!creatType.equals(operateType) || param.get("voucherId") != null) continue;
            map.put("status", creatType);
            map.put("msg", ResManager.loadKDString((String)"\u51ed\u8bc1\u53cd\u5199\u65f6\uff0c\u51ed\u8bc1ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AcaVoucherSynServiceImpl_9", (String)"fi-cal-mservice", (Object[])new Object[0]));
            returnList.add(map);
            return false;
        }
        return true;
    }
}

