/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceUncompressHelper;
import kd.fi.cal.business.formula.StandGroupBaseDataConverter;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class Cal4BcmRptFormulaCalculator {
    private Set<String> resultFieldSet = null;
    private String formula = null;
    private QFilter billBaseFilter = new QFilter("id", "=", (Object)0L);
    private String calEntityObject = null;
    private Map<String, QFilter> singleFilterMap = null;
    private Map<String, String> selectFieldMap = null;
    private List<String> paramNameList = null;
    private Map<String, List<Object>> paramListMap = null;
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private String entryName = "";
    private String calEntryEntity = "";
    private Date commStartDate = null;
    private Date commEndDate = null;
    private String orgNums = "";
    private int commfy;
    private int commperiod;
    String[] groupSelect = null;
    private static final String BASEGROUPSTANDARD = "JBFLBZ";

    public String getResultJson(String formulaName, String paramJson) throws ParseException, IOException {
        this.resultFieldSet = new HashSet<String>(16);
        this.singleFilterMap = new HashMap<String, QFilter>(16);
        this.selectFieldMap = new HashMap<String, String>(16);
        this.formula = formulaName;
        this.Init();
        this.resolveParams(formulaName, paramJson);
        String resultJson = "";
        if (this.paramListMap != null && !this.paramListMap.isEmpty() && this.paramNameList != null) {
            this.getQueryFilter();
            resultJson = this.getQueryResultJson();
        }
        return resultJson;
    }

    private void Init() {
        if ("CostRec".equals(this.formula)) {
            this.calEntityObject = "cal_costrecord";
            this.entryName = "entry.";
            this.calEntryEntity = ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55", (String)"Cal4BcmRptFormulaCalculator_1", (String)"fi-cal-mservice", (Object[])new Object[0]);
            this.resultFieldSet.add("entry.actualcost");
            this.resultFieldSet.add("entry.baseqty");
            this.billBaseFilter = new QFilter("isinitbill", "=", (Object)Boolean.FALSE);
            this.billBaseFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            this.billBaseFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        } else if ("CostAdj".equals(this.formula)) {
            this.calEntityObject = "cal_costadjustbill";
            this.entryName = "entryentity.";
            this.calEntryEntity = ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"Cal4BcmRptFormulaCalculator_2", (String)"fi-cal-mservice", (Object[])new Object[0]);
            this.resultFieldSet.add("entryentity.adjustamt");
            this.billBaseFilter = new QFilter("billstatus", "=", (Object)"C");
        } else if ("Calbalance".equals(this.formula)) {
            if (this.isNewBalance) {
                this.calEntityObject = "cal_bal";
                this.calEntryEntity = ResManager.loadKDString((String)"\u5b58\u8d27\u7ed3\u5b58\u4fe1\u606f", (String)"Cal4BcmRptFormulaCalculator_4", (String)"fi-cal-mservice", (Object[])new Object[0]);
                this.resultFieldSet.add("baseqty_bal");
                this.resultFieldSet.add("standardcost_bal");
                this.resultFieldSet.add("actualcost_bal");
                this.groupSelect = CalBalanceModelHelper.getDimFields((boolean)false).split(",");
            } else {
                this.calEntityObject = "cal_balance";
                this.calEntryEntity = ResManager.loadKDString((String)"\u5b58\u8d27\u7ed3\u5b58\u4fe1\u606f", (String)"Cal4BcmRptFormulaCalculator_4", (String)"fi-cal-mservice", (Object[])new Object[0]);
                this.resultFieldSet.add("periodendqty");
                this.resultFieldSet.add("periodendstandardcost");
                this.resultFieldSet.add("periodendactualcost");
            }
        }
    }

    private String getQueryResultJson() {
        HashMap resultMap = new HashMap();
        HashMap<String, Object> singleMap = null;
        for (Map.Entry<String, QFilter> map : this.singleFilterMap.entrySet()) {
            String key = map.getKey();
            QFilter singleFilter = map.getValue();
            String selectField = this.selectFieldMap.get(key);
            singleMap = new HashMap<String, Object>();
            if (StringUtils.isNotEmpty((String)selectField)) {
                if (this.calEntityObject.equals("cal_bal")) {
                    boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
                    if (!balCompress) {
                        DataSet resultDataset = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.calEntityObject, (String)(CalBalanceModelHelper.getDimFields((boolean)false) + ",baseqty_bal,standardcost_bal,actualcost_bal"), (QFilter[])singleFilter.toArray(), null).groupBy(this.groupSelect).max("baseqty_bal").sum("standardcost_bal").sum("actualcost_bal").finish().groupBy().sum(selectField).finish();
                        Throwable throwable = null;
                        try {
                            BigDecimal value = null;
                            for (Row row : resultDataset) {
                                value = row.getBigDecimal(selectField);
                            }
                            if (value == null) continue;
                            singleMap.put("v", value);
                            singleMap.put("type", 1);
                            resultMap.put(key, singleMap);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (resultDataset == null) continue;
                            if (throwable != null) {
                                try {
                                    resultDataset.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            resultDataset.close();
                            continue;
                        }
                    }
                    ArrayList<QFilter> ql = new ArrayList<QFilter>();
                    ql.add(singleFilter);
                    DataSet resultDataset = BalanceUncompressHelper.getBalancDataSetDetail((boolean)false, (boolean)true, null, ql).groupBy(this.groupSelect).max("baseqty_bal").sum("standardcost_bal").sum("actualcost_bal").finish().select(CalBalanceModelHelper.getDimFields((boolean)false) + ",baseqty_bal,standardcost_bal,actualcost_bal").groupBy().sum(selectField).finish();
                    Object object = null;
                    try {
                        BigDecimal value = null;
                        for (Row row : resultDataset) {
                            value = row.getBigDecimal(selectField);
                        }
                        if (value == null) continue;
                        singleMap.put("v", value);
                        singleMap.put("type", 1);
                        resultMap.put(key, singleMap);
                        continue;
                    }
                    catch (Throwable value) {
                        object = value;
                        throw value;
                    }
                    finally {
                        if (resultDataset == null) continue;
                        if (object != null) {
                            try {
                                resultDataset.close();
                            }
                            catch (Throwable value) {
                                ((Throwable)object).addSuppressed(value);
                            }
                            continue;
                        }
                        resultDataset.close();
                        continue;
                    }
                }
                DataSet resultDataset = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.calEntityObject, (String)selectField, (QFilter[])singleFilter.toArray(), null).groupBy().sum(selectField).finish();
                Throwable throwable = null;
                try {
                    BigDecimal value = null;
                    for (Row row : resultDataset) {
                        value = row.getBigDecimal(selectField);
                    }
                    if (value == null) continue;
                    singleMap.put("v", value);
                    singleMap.put("type", 1);
                    resultMap.put(key, singleMap);
                    continue;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (resultDataset == null) continue;
                    if (throwable != null) {
                        try {
                            resultDataset.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    resultDataset.close();
                    continue;
                }
            }
            String message = String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u53d6\u6570\u7c7b\u578b\u5b57\u6bb5\u5728\u201c%1$s\u201d\u4e2d\u662f\u5426\u5b58\u5728\u3002", (String)"Cal4BcmRptFormulaCalculator_5", (String)"fi-cal-mservice", (Object[])new Object[0]), this.calEntryEntity);
            singleMap.put("v", message);
            singleMap.put("type", -1);
            resultMap.put(key, singleMap);
        }
        return kd.bos.login.actions.SerializationUtils.toJsonString(resultMap);
    }

    private void getQueryFilter() throws ParseException {
        int size = this.paramNameList.size();
        for (Map.Entry<String, List<Object>> map : this.paramListMap.entrySet()) {
            String paramId = map.getKey();
            List<Object> params = map.getValue();
            if ("Calbalance".equals(this.formula)) {
                this.getSingleFilter4Bal(params, paramId);
                continue;
            }
            this.getSingleFilter(params, paramId);
        }
    }

    private void getSingleFilter4Bal(List<Object> paramValues, String paramId) {
        int year = 0;
        int period = 0;
        QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        int size = paramValues.size();
        String selectField = null;
        String materialstandard = null;
        String materialgroup = null;
        String material = null;
        String customdim = null;
        String customdimVal = null;
        for (int i = 0; i < size; ++i) {
            String value = paramValues.get(i).toString();
            String number = this.paramNameList.get(i);
            QFilter qtemp = null;
            if (StringUtils.isNotEmpty((String)value)) {
                if ("materialstandard".equals(number)) {
                    materialstandard = value;
                } else if ("materialgroup".equals(number)) {
                    materialgroup = value;
                } else if (number.contains("material")) {
                    material = value;
                } else if ("selectfield".equals(number)) {
                    if (this.isNewBalance) {
                        if ("periodendqty".equals(value)) {
                            selectField = "baseqty_bal";
                        } else if ("periodendstandardcost".equals(value)) {
                            selectField = "standardcost_bal";
                        } else if ("periodendactualcost".equals(value)) {
                            selectField = "actualcost_bal";
                        }
                    } else {
                        selectField = value;
                    }
                } else if ("customdimension1".equals(number)) {
                    customdim = value;
                } else if ("customdimensionvalue1".equals(number)) {
                    customdimVal = value;
                } else if ("year".equals(number)) {
                    year = Integer.parseInt(value);
                } else if ("period".equals(number)) {
                    period = Integer.parseInt(value);
                } else {
                    qtemp = new QFilter(number, "in", (Object)value.trim().split(","));
                }
            } else if ("calorg.number".equals(number)) {
                qtemp = new QFilter("calorg.number", "in", (Object)this.orgNums.split(","));
            }
            if (qtemp == null) continue;
            q.and(qtemp);
        }
        int periodNumber = year > 1000 ? (period <= 0 ? year * 100 + this.commperiod + period : year * 100 + period) : (period <= 0 ? (this.commfy + year) * 100 + this.commperiod + period : (this.commfy + year) * 100 + period);
        q.and("period", "<=", (Object)periodNumber);
        q.and("endperiod", ">", (Object)periodNumber);
        QFilter materialFilter = this.getMaterialFilter(materialstandard, materialgroup, material, customdim, customdimVal);
        q.and(materialFilter);
        this.singleFilterMap.put(paramId, q);
        if (this.resultFieldSet.contains(selectField)) {
            this.selectFieldMap.put(paramId, selectField);
        }
    }

    private void getSingleFilter(List<Object> paramValues, String paramId) throws ParseException {
        QFilter q = this.billBaseFilter.copy();
        int size = paramValues.size();
        String selectField = null;
        String materialstandard = null;
        String materialgroup = null;
        String material = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, String> fieldKeyValueMap = new HashMap<String, String>(16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.calEntityObject);
        for (int i = 0; i < size; ++i) {
            String value = paramValues.get(i).toString();
            String number = this.paramNameList.get(i);
            fieldKeyValueMap.put(number, value);
            IDataEntityProperty property = entityType.findProperty(number);
            IDataEntityProperty noEntryNumberProperty = entityType.findProperty(number.replace(this.entryName, "").replace(".number", ""));
            QFilter qtemp = null;
            if (StringUtils.isNotEmpty((String)value)) {
                if ("startdate".equals(number)) {
                    qtemp = new QFilter("bookdate", ">=", (Object)formatter.parse(value));
                } else if ("enddate".equals(number)) {
                    Date enddate = formatter.parse(value);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(enddate);
                    calendar.add(5, 1);
                    enddate = calendar.getTime();
                    qtemp = new QFilter("bookdate", "<", (Object)enddate);
                } else if ("materialstandard".equals(number)) {
                    materialstandard = value;
                } else if ("materialgroup".equals(number)) {
                    materialgroup = value;
                } else if (number.contains(".material")) {
                    material = value;
                } else if ("selectfield".equals(number)) {
                    if (!value.contains("entry")) {
                        value = this.entryName + value;
                    }
                    selectField = value;
                } else {
                    String typePropName;
                    String typeValue;
                    if (property != null && property.getParent() instanceof EntryType) {
                        number = property.getParent().getName() + "." + number;
                    }
                    if (property != null || noEntryNumberProperty != null) {
                        qtemp = new QFilter(number, "in", (Object)value.trim().split(","));
                    }
                    if (noEntryNumberProperty instanceof ItemClassProp && StringUtils.isNotEmpty((String)(typeValue = (String)fieldKeyValueMap.get(typePropName = ((ItemClassProp)noEntryNumberProperty).getTypePropName())))) {
                        Set<Long> baseDataIds = this.getBaseDataIds(value, typeValue);
                        qtemp = new QFilter(number.replace(".number", ""), "in", baseDataIds);
                    }
                }
            } else if ("startdate".equals(number)) {
                qtemp = new QFilter("bookdate", ">=", (Object)this.commStartDate);
            } else if ("enddate".equals(number)) {
                qtemp = new QFilter("bookdate", "<", (Object)this.commEndDate);
            } else if ("calorg.number".equals(number)) {
                qtemp = new QFilter("calorg.number", "in", (Object)this.orgNums.split(","));
            }
            if (qtemp == null) continue;
            if (q == null) {
                q = qtemp;
                continue;
            }
            q.and(qtemp);
        }
        QFilter customerFilter = this.getStandGroupBaseFilter(fieldKeyValueMap, "customerstandard", "customergroup", "customer", "bd_customer", "bd_customergroupdetail");
        q.and(customerFilter);
        QFilter supplierFilter = this.getStandGroupBaseFilter(fieldKeyValueMap, "supplierstandard", "suppliergroup", "supplier", "bd_supplier", "bd_suppliergroupdetail");
        q.and(supplierFilter);
        QFilter materialFilter = this.getMaterialFilter(materialstandard, materialgroup, material, null, null);
        q.and(materialFilter);
        QFilter configFilter = this.getConfigFilter(fieldKeyValueMap);
        q.and(configFilter);
        this.singleFilterMap.put(paramId, q);
        this.selectFieldMap.put(paramId, selectField);
        if (StringUtils.isNotEmpty(selectField)) {
            this.resultFieldSet.add(selectField);
        }
    }

    private QFilter getConfigFilter(Map<String, String> fieldKeyValueMap) {
        String filterTag;
        QFilter configNumFilter;
        DynamicObject filterConfigDyc;
        QFilter configFilter = null;
        String filterConfigNum = fieldKeyValueMap.get("filterconfig");
        if (StringUtils.isNotEmpty((String)filterConfigNum) && (filterConfigDyc = QueryServiceHelper.queryOne((String)"cal_filter_config", (String)"filter_tag", (QFilter[])new QFilter[]{configNumFilter = new QFilter("number", "=", (Object)filterConfigNum)})) != null && StringUtils.isNotEmpty((String)(filterTag = filterConfigDyc.getString("filter_tag")))) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterTag, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)this.calEntityObject), filterCondition);
            filterBuilder.buildFilter();
            configFilter = filterBuilder.getQFilter();
        }
        return configFilter;
    }

    private QFilter getStandGroupBaseFilter(Map<String, String> fieldKeyValueMap, String standKey, String groupKey, String baseKey, String baseEntity, String groupDetailEntity) {
        boolean isAllEmpty;
        if (!fieldKeyValueMap.containsKey(standKey)) {
            return null;
        }
        String baseNumKey = baseKey + ".number";
        String standardValue = fieldKeyValueMap.get(standKey);
        String groupValue = fieldKeyValueMap.get(groupKey);
        String baseDataValue = fieldKeyValueMap.get(baseNumKey);
        boolean bl = isAllEmpty = (BASEGROUPSTANDARD.equals(standardValue) || StringUtils.isEmpty((String)standardValue)) && StringUtils.isEmpty((String)groupValue) && StringUtils.isEmpty((String)baseDataValue);
        if (isAllEmpty) {
            return null;
        }
        if (StringUtils.isEmpty((String)standardValue)) {
            standardValue = BASEGROUPSTANDARD;
        }
        Set<Long> srcBaseDataIds = this.getBaseDataIds(baseDataValue, baseEntity);
        StandGroupBaseDataConverter customerConverter = new StandGroupBaseDataConverter(groupDetailEntity, baseKey);
        customerConverter.setBaseIds(srcBaseDataIds);
        Set baseDataIds = customerConverter.getBaseDataIdsByStandGroupNum(standardValue, Arrays.asList(groupValue.split(",")));
        if (StringUtils.isNotEmpty((String)baseDataValue)) {
            baseDataIds.retainAll(srcBaseDataIds);
        }
        QFilter baseDataFilter = new QFilter(baseKey, "=", (Object)0L);
        if (!baseDataIds.isEmpty()) {
            baseDataFilter = new QFilter(baseKey, "in", (Object)baseDataIds);
        }
        return baseDataFilter;
    }

    private QFilter getMaterialFilter(String materialstandard, String materialgroup, String material, String customdim, String customdimVal) {
        boolean isAllEmpty;
        QFilter q = QFilter.of((String)"1=1", (Object[])new Object[0]);
        boolean bl = isAllEmpty = BASEGROUPSTANDARD.equals(materialstandard) && StringUtils.isEmpty((String)materialgroup) && StringUtils.isEmpty((String)material) && StringUtils.isEmpty((String)customdimVal) && StringUtils.isEmpty((String)customdim);
        if (isAllEmpty) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)materialstandard) && StringUtils.isNotEmpty((String)materialgroup)) {
            QFilter groupFilter = new QFilter("number", "=", (Object)materialgroup);
            groupFilter.and("standard.number", "=", (Object)materialstandard);
            DynamicObject materialDetail = QueryServiceHelper.queryOne((String)"bd_materialgroup", (String)"id,number,longnumber", (QFilter[])groupFilter.toArray());
            if (materialDetail != null) {
                String goupLongNum = materialDetail.getString("longnumber");
                q.and("group.longnumber", "like", (Object)(goupLongNum + "%"));
            }
        }
        if (material != null && !material.isEmpty()) {
            q.and("material.number", "in", (Object)material.split(","));
        }
        HashSet<String> matSet = new HashSet<String>(1024);
        if (customdim != null) {
            QFilter matFilter = q.copy();
            matFilter.and(customdim + ".number", "=", (Object)customdimVal);
            DataSet materialDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_material", (String)"number", (QFilter[])matFilter.toArray(), null);
            for (Row row : materialDs) {
                matSet.add(row.getString("number"));
            }
            q.and("material.number", "in", matSet);
        }
        if (StringUtils.isNotEmpty((String)materialstandard)) {
            q.and("standard.number", "=", (Object)materialstandard);
        }
        String materialField = this.entryName + "material.number";
        HashSet<String> materialSet = new HashSet<String>(16);
        try (DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialgroupdetail", (String)"standard.number,group.longnumber,material.number", (QFilter[])q.toArray(), null).groupBy(new String[]{"group.longnumber", "material.number"}).finish();){
            for (Row row : materialDataSet) {
                materialSet.add(row.getString("material.number"));
            }
        }
        QFilter materialFilter = new QFilter(this.entryName + "material", "=", (Object)0L);
        if (!materialSet.isEmpty()) {
            materialFilter = new QFilter(materialField, "in", materialSet);
        }
        return materialFilter;
    }

    private void resolveParams(String formulaName, String paramJson) throws ParseException {
        Map paramMap = (Map)kd.bos.login.actions.SerializationUtils.fromJsonString((String)paramJson, Map.class);
        Map commParam = (Map)paramMap.get("commParam");
        int fy = (Integer)commParam.get("fy");
        int month = (Integer)commParam.get("period");
        this.commfy = fy;
        this.commperiod = month;
        String startDateStr = (String)commParam.get("startDate");
        String endDateStr = (String)commParam.get("endDate");
        if (StringUtils.isNotEmpty((String)startDateStr) && StringUtils.isNotEmpty((String)endDateStr)) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            this.commStartDate = formatter.parse(startDateStr);
            Calendar calendar = Calendar.getInstance();
            Date enddate = formatter.parse(endDateStr);
            calendar.setTime(enddate);
            calendar.add(5, 1);
            this.commEndDate = calendar.getTime();
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.set(fy, month - 1, 1, 0, 0, 0);
            this.commStartDate = calendar.getTime();
            calendar.add(2, 1);
            this.commEndDate = calendar.getTime();
        }
        this.orgNums = (String)commParam.get("org");
        this.paramListMap = (Map)paramMap.get("param");
        this.paramNameList = (List)commParam.get("formulaParamNames");
    }

    private Set<Long> getBaseDataIds(String paramValue, String baseEntityId) {
        HashSet<Long> ids = new HashSet<Long>(16);
        if (StringUtils.isEmpty((String)paramValue)) {
            return ids;
        }
        try (DataSet baseDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)baseEntityId, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)paramValue.split(","))}, null);){
            for (Row row : baseDs) {
                ids.add(row.getLong("id"));
            }
        }
        return ids;
    }
}

