/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.mservice.api.CalApBill2StdBillVoucherService;

public class CalApBill2StdBillVoucherServiceImpl
implements CalApBill2StdBillVoucherService {
    private static final Log logger = LogFactory.getLog(CalApBill2StdBillVoucherServiceImpl.class);

    public String getDataSetCacheId(Map<String, Set<Long>> apBillIdMap) {
        logger.info(apBillIdMap.toString());
        ArrayList apInputs = new ArrayList(4);
        for (Map.Entry<String, Set<Long>> entry : apBillIdMap.entrySet()) {
            String entity = entry.getKey();
            Set<Long> apbillIds = entry.getValue();
            Lists.partition(Arrays.asList(apbillIds.toArray()), (int)5000).forEach(list -> {
                OrmInput input = new OrmInput(this.getClass().getName(), entity, "id as apbillid,bookdate,org", new QFilter("id", "in", list).toArray());
                apInputs.add(input);
            });
        }
        if (apInputs.isEmpty()) {
            return null;
        }
        DataSet apDataSet = Algo.create((String)this.getClass().getName()).createDataSet(apInputs.toArray(new Input[0]));
        HashSet<Object> orgs = new HashSet<Object>(4);
        Date minBookdate = null;
        for (Row row : apDataSet.copy()) {
            Long orgid = row.getLong("org");
            Date bookdate = row.getDate("bookdate");
            orgs.add(orgid);
            if (minBookdate != null && !minBookdate.after(bookdate)) continue;
            minBookdate = bookdate;
        }
        DataSet costAccountDS = AccountingSysHelper.getAccountingSysCostaccountDataSetByOwners(orgs);
        HashSet<Long> costAccountIds = new HashSet<Long>(4);
        for (Row row : costAccountDS) {
            costAccountIds.add(row.getLong("costaccount"));
        }
        QFilter costAccountFilter = new QFilter("costaccount", "in", costAccountIds);
        costAccountFilter.and("bookdate", ">=", (Object)minBookdate);
        costAccountFilter.and("ischargeoff", "=", (Object)false);
        logger.info(costAccountFilter.toString());
        ArrayList stdBillInputs = new ArrayList(4);
        for (Map.Entry<String, Set<Long>> entry : apBillIdMap.entrySet()) {
            Set<Long> apbillIds = entry.getValue();
            Lists.partition(Arrays.asList(apbillIds.toArray()), (int)5000).forEach(list -> {
                QFilter srcFilter = new QFilter("entryentity.srcbillid", "in", list);
                OrmInput input = new OrmInput(this.getClass().getName(), "cal_stdcostdiffbill", "id as stdbillid,isvoucher,voucherid,entryentity.owner as owner,entryentity.srcbillid as srcbillid,entryentity.groupdiffbillid as groupdiffbillid", new QFilter[]{srcFilter, costAccountFilter});
                stdBillInputs.add(input);
            });
        }
        if (stdBillInputs.isEmpty()) {
            return null;
        }
        DataSet stdBillDataSet = Algo.create((String)this.getClass().getName()).createDataSet(stdBillInputs.toArray(new Input[0]));
        DataSet resultDS = null;
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ISGROUPDIFFBILL).booleanValue()) {
            DataSet[] stdBillDataSets = stdBillDataSet.splitByFilter(new String[]{"isvoucher = TRUE"}, true);
            HashSet<Long> groupdiffbillids = new HashSet<Long>(4);
            for (Row row : stdBillDataSets[1].copy()) {
                groupdiffbillids.add(row.getLong("groupdiffbillid"));
            }
            ArrayList stdGroupBillInputs = new ArrayList(4);
            Lists.partition(Arrays.asList(groupdiffbillids.toArray()), (int)5000).forEach(list -> {
                QFilter idFilter = new QFilter("id", "in", list);
                idFilter.and("isvoucher", "=", (Object)true);
                OrmInput input = new OrmInput(this.getClass().getName(), "cal_costdiffgroupbill", "id as stdgroupbillid,isvoucher,voucherid", new QFilter[]{idFilter});
                stdGroupBillInputs.add(input);
            });
            if (!stdGroupBillInputs.isEmpty()) {
                DataSet stdBillGroupDataSet = Algo.create((String)this.getClass().getName()).createDataSet(stdGroupBillInputs.toArray(new Input[0]));
                stdBillGroupDataSet = stdBillDataSets[1].join(stdBillGroupDataSet, JoinType.INNER).on("groupdiffbillid", "stdgroupbillid").select(new String[]{"owner", "srcbillid"}, new String[]{"voucherid"}).finish();
                stdBillDataSets[0] = stdBillDataSets[0].select("owner,srcbillid,voucherid").union(stdBillGroupDataSet);
            }
            resultDS = apDataSet.join(stdBillDataSets[0], JoinType.INNER).on("apbillid", "srcbillid").on("org", "owner").select(new String[]{"apbillid"}, new String[]{"voucherid"}).finish();
        } else {
            stdBillDataSet = stdBillDataSet.where("isvoucher = TRUE");
            resultDS = apDataSet.join(stdBillDataSet, JoinType.INNER).on("apbillid", "srcbillid").on("org", "owner").select(new String[]{"apbillid"}, new String[]{"voucherid"}).finish();
        }
        resultDS = resultDS.distinct();
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout(3600L, TimeUnit.SECONDS);
        CachedDataSet cache = resultDS.cache(cacheHint);
        String cacheId = cache.getCacheId();
        return cacheId;
    }
}

