/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.business.service.CalProcessHandle;
import kd.fi.cal.business.wf.WfHelper;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.ScmParamsHelper;
import kd.fi.cal.common.helper.StopSyncBizBillHelper;
import kd.fi.cal.mservice.AbstractService;
import kd.fi.cal.mservice.mq.PublishMqContext;

public class CalBizServiceImpl
extends AbstractService {
    public CalBizServiceImpl() {
        this.setServiceType("B");
    }

    public Map doService(String actionName, Map params, DynamicObject[] bizBills) throws Exception {
        bizBills = this.filterStopSycBill(actionName, params, bizBills);
        PublishMqContext mqPublishContext = new PublishMqContext(actionName, params, bizBills, this.getServiceType());
        mqPublishContext.publish();
        return null;
    }

    @Override
    public Map doService(String actionName, Map params, Set<Long> bizBillIds, String entityName) throws Exception {
        boolean isWF;
        StringBuilder selects = new StringBuilder();
        boolean isAuditOrUnAudit = ActionEnum.UN_AUDIT.getValue().equals(actionName) || ActionEnum.AUDIT.getValue().equals(actionName) || ActionEnum.RESYNC.getValue().equals(actionName);
        boolean bl = isWF = ActionEnum.PUR_WRITEOFF.getValue().equals(actionName) || ActionEnum.SALE_WRITEOFF.getValue().equals(actionName);
        if (isAuditOrUnAudit) {
            String orgName = MetadataServiceHelper.getDataEntityType((String)entityName).getMainOrg();
            selects.append("id").append(",");
            selects.append("billno").append(",");
            selects.append("billstatus").append(",");
            selects.append("auditor").append(",");
            selects.append("modifytime").append(",");
            selects.append("auditdate").append(",");
            String bizTimeName = "biztime";
            String bookDateName = "bookdate";
            boolean isContainBizDate = EntityMetadataCache.getDataEntityType((String)entityName).getProperties().containsKey((Object)bizTimeName);
            boolean isContainBookDate = EntityMetadataCache.getDataEntityType((String)entityName).getProperties().containsKey((Object)bookDateName);
            if (isContainBizDate) {
                selects.append(bizTimeName).append(",");
            }
            if (isContainBookDate) {
                selects.append(bookDateName).append(",");
            }
            selects.append(orgName);
        } else {
            if (isWF) {
                new WfHelper().invokeBatchWfByIds(actionName, entityName, bizBillIds);
                return null;
            }
            if (ActionEnum.REESTIMATE.getValue().equals(actionName)) {
                String orgInfo = "id,org,entry.id,entry.e_srcbillid,isadjust,billno,bookdate,bizdate";
                selects.append(orgInfo);
            }
        }
        DynamicObject[] bizBills = null;
        bizBills = selects.length() > 0 ? BusinessDataServiceHelper.load((String)entityName, (String)selects.toString(), (QFilter[])new QFilter("id", "in", bizBillIds).toArray()) : BusinessDataServiceHelper.load((Object[])bizBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
        this.doService(actionName, params, bizBills);
        return null;
    }

    @Override
    public Map doServiceSync(String actionName, Map params, DynamicObject[] bizBills) throws Exception {
        Map<Long, String> result = this.invokeCalService(actionName, params, bizBills);
        return result;
    }

    @Override
    public Map doServiceSync(List<Object[]> syncParams) throws Exception {
        Map<Object, Object> result = new HashMap(16);
        if (syncParams == null || syncParams.isEmpty()) {
            return result;
        }
        for (Object[] item : syncParams) {
            result = this.invokeCalService((String)item[0], (Map)item[1], (DynamicObject[])item[2]);
        }
        return result;
    }

    private Map<Long, String> invokeCalService(String actionName, Map params, DynamicObject[] bizBills) {
        bizBills = this.filterStopSycBill(actionName, params, bizBills);
        Map<Long, String> result = new HashMap<Long, String>(16);
        if (params == null) {
            params = new HashMap<String, String>(16);
        }
        params.put("noretry", "TRUE");
        CalProcessHandle calProcessHandle = new CalProcessHandle(actionName, params, bizBills);
        calProcessHandle.handle();
        result = this.filterErrorInfo(result, calProcessHandle);
        return result;
    }

    private DynamicObject[] filterStopSycBill(String actionName, Map params, DynamicObject[] bizBills) {
        boolean isAuditOrUnAudit;
        boolean bl = isAuditOrUnAudit = ActionEnum.UN_AUDIT.getValue().equals(actionName) || ActionEnum.AUDIT.getValue().equals(actionName);
        if (isAuditOrUnAudit) {
            StopSyncBizBillHelper stophelper = new StopSyncBizBillHelper("inv");
            bizBills = stophelper.doStop4Inv(actionName, params, bizBills, this.getServiceType());
        }
        return bizBills;
    }

    private Map<Long, String> filterErrorInfo(Map<Long, String> result, CalProcessHandle calProcessHandle) {
        boolean isBizFinInt = ScmParamsHelper.isEnable((String)"INV0005");
        if (!isBizFinInt) {
            return calProcessHandle.getResult();
        }
        Map errorBillIdMsgMap = calProcessHandle.getErrorBillIdMsgMap();
        for (Map.Entry errBillIdMsgEnt : errorBillIdMsgMap.entrySet()) {
            Long key = (Long)errBillIdMsgEnt.getKey();
            ErrorMsg error = (ErrorMsg)errBillIdMsgEnt.getValue();
            if (isBizFinInt && "5".equals(error.getErrorType())) continue;
            result.put(key, error.getErrorMsg());
        }
        return result;
    }
}

