/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.ScmParamsHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.mservice.api.CalBookDateUpdateService;

public class CalBookDateUpdateServiceImpl
implements CalBookDateUpdateService {
    public void updateRecordBookDate(Set<Long> invBillsSet, Date closeDate) {
        if (invBillsSet == null || invBillsSet.isEmpty()) {
            return;
        }
        try (TXHandle t = TX.requiresNew();){
            DynamicObject[] costRecords;
            HashSet<Long> accountIdSet = new HashSet<Long>(16);
            HashSet<Long> inCalBillIdSet = new HashSet<Long>(16);
            HashSet<Long> outCalBillIdSet = new HashSet<Long>(16);
            Date nextDate = DateUtils.addDateTime((Date)closeDate, (int)5, (int)1);
            nextDate = DateUtils.getDayStartTime((Date)nextDate);
            for (DynamicObject dynamicObject : costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)"id,costaccount,bookdate,period,writeoffdate,writeoffperiod,isinitbill,calbilltype,calbillid,bizdate", (QFilter[])new QFilter("bizbillid", "in", invBillsSet).toArray())) {
                accountIdSet.add(dynamicObject.getLong("costaccount_id"));
            }
            if (accountIdSet.isEmpty()) {
                return;
            }
            boolean isBizDateEqualBookDate = ScmParamsHelper.isEnable((String)"INV0004");
            Map accountCRTPeriodMap = PeriodHelper.getCurrentPeriods(new HashSet(accountIdSet));
            Map<Long, DynamicObject> accountNXTPeriodMap = this.getAccountPeriodMap(accountIdSet, nextDate);
            for (DynamicObject costRecord : costRecords) {
                String calBillType;
                Long costAccountId = costRecord.getLong("costaccount_id");
                DynamicObject period = accountNXTPeriodMap.get(costAccountId);
                if (period == null) continue;
                Date bookdate = nextDate;
                Long periodId = period.getLong("id");
                Date writeOffDate = nextDate;
                Long writeoffPeriodid = period.getLong("id");
                Boolean isInitBill = costRecord.getBoolean("isinitbill");
                if (isInitBill.booleanValue()) {
                    DynamicObject currentPeriod = (DynamicObject)accountCRTPeriodMap.get(costAccountId);
                    if (currentPeriod == null) continue;
                    Date crtFirstDate = currentPeriod.getDate("begindate");
                    if (nextDate.before(crtFirstDate)) {
                        periodId = currentPeriod.getLong("id");
                        writeOffDate = crtFirstDate;
                        writeoffPeriodid = currentPeriod.getLong("id");
                    }
                }
                costRecord.set("period", (Object)periodId);
                costRecord.set("writeoffdate", (Object)writeOffDate);
                costRecord.set("writeoffperiod", (Object)writeoffPeriodid);
                if (isInitBill.booleanValue()) continue;
                costRecord.set("bookdate", (Object)bookdate);
                if (isBizDateEqualBookDate) {
                    costRecord.set("bizdate", (Object)bookdate);
                }
                if ("IN".equals(calBillType = costRecord.getString("calbilltype"))) {
                    inCalBillIdSet.add(costRecord.getLong("calbillid"));
                    continue;
                }
                outCalBillIdSet.add(costRecord.getLong("calbillid"));
            }
            if (costRecords.length > 0) {
                SaveServiceHelper.save((DynamicObject[])costRecords);
            }
            String string = this.getUpdateBillSql(inCalBillIdSet, "t_cal_incalbill", "fbookdate");
            String updateOutBillSql = this.getUpdateBillSql(outCalBillIdSet, "t_cal_outcalbill", "fbookdate");
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
            updateParams.add(new Object[]{nextDate});
            if (string != null) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)string, updateParams);
                if (isBizDateEqualBookDate) {
                    String string2 = this.getUpdateBillSql(inCalBillIdSet, "t_cal_incalbill", "fbizdate");
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)string2, updateParams);
                }
            }
            if (updateOutBillSql != null) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateOutBillSql, updateParams);
                if (isBizDateEqualBookDate) {
                    updateOutBillSql = this.getUpdateBillSql(outCalBillIdSet, "t_cal_outcalbill", "fbizdate");
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateOutBillSql, updateParams);
                }
            }
        }
    }

    private Map<Long, DynamicObject> getAccountPeriodMap(Set<Long> accountIdSet, Date nextDate) {
        HashMap<Long, DynamicObject> accountNextPeriodMap = new HashMap<Long, DynamicObject>(16);
        for (Long costAccountId : accountIdSet) {
            DynamicObject period = PeriodHelper.getPeriodByDate((Date)nextDate, (Long)costAccountId);
            if (period == null) continue;
            accountNextPeriodMap.put(costAccountId, period);
        }
        return accountNextPeriodMap;
    }

    private String getUpdateBillSql(Set<Long> billIdSet, String tableName, String field) {
        if (billIdSet.isEmpty()) {
            return null;
        }
        StringBuilder billIdBuilder = new StringBuilder();
        for (Long inId : billIdSet) {
            billIdBuilder.append(inId.toString());
            billIdBuilder.append(',');
        }
        String billIdString = CommonUtils.trimComma((String)billIdBuilder.toString());
        return "update " + tableName + " set " + field + " = ? where fid in (" + billIdString + ")";
    }
}

