/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.business.service.SyncLockHelper;
import kd.fi.cal.chargeoff.CalChargeOffHelper;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.mservice.api.CalChargeOffService;

public class CalChargeOffServiceImpl
implements CalChargeOffService {
    public Map<Long, Long> chargeOffWriteRecord(Set<Long> srcWriteOffRecordIds, Date bizDate, Date bookedDate, Date chargeOffDate, String chargeOffReason) {
        HashMap<Long, Long> result = new HashMap(16);
        QFilter q = new QFilter("id", "in", srcWriteOffRecordIds);
        q.and("billtype", "!=", (Object)"im_mdc_omcmplinbill");
        DynamicObject[] arRecords = BusinessDataServiceHelper.load((String)"ar_verifyrecord", (String)"id,org,billdate,billid,billno,billtype,billentryid,entry.e_billid,entry.e_billtype,entry.e_billno", (QFilter[])q.toArray());
        DynamicObject[] apRecords = BusinessDataServiceHelper.load((String)"ap_verifyrecord", (String)"id,org,billdate,billid,billno,billtype,billentryid,entry.e_billid,entry.e_billtype,entry.e_billno", (QFilter[])q.toArray());
        String actionName = null;
        DynamicObject[] records = null;
        if (arRecords != null && arRecords.length > 0) {
            actionName = ActionEnum.SALE_WRITEOFF.getValue();
            records = arRecords;
        }
        if (apRecords != null && apRecords.length > 0) {
            actionName = ActionEnum.PUR_WRITEOFF.getValue();
            records = apRecords;
        }
        if (records == null || records.length == 0) {
            return new HashMap<Long, Long>(4);
        }
        try (SyncLockHelper syncLockHelper = new SyncLockHelper(actionName, records);){
            List mutErrors = syncLockHelper.lock();
            StringBuilder sb = new StringBuilder();
            HashSet<String> errMsgs = new HashSet<String>(16);
            for (ErrorMsg err : mutErrors) {
                errMsgs.add(err.getErrorMsg());
            }
            for (String errMsg : errMsgs) {
                sb.append(errMsg);
            }
            if (sb.length() > 0) {
                throw new KDBizException(sb.toString());
            }
            try (TXHandle tx = TX.requiresNew();){
                try {
                    result = new CalChargeOffHelper().chargeOffWriteRecord(srcWriteOffRecordIds, bizDate, bookedDate, chargeOffDate, chargeOffReason);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
        return result;
    }

    public void chargeOffWriteRecord4RollBack(Set<Long> srcWriteOffRecordIds, Map<Long, Long> writeOffEndPeriodMap) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                new CalChargeOffHelper().chargeOffWriteRecord4RollBack(srcWriteOffRecordIds, writeOffEndPeriodMap);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }
}

