/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.business.service.CalServiceHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.mservice.AbstractService;

public class CalCheckServiceImpl
extends AbstractService {
    private static final Log logger = LogFactory.getLog(CalCheckServiceImpl.class);

    public CalCheckServiceImpl() {
        this.setServiceType("A");
    }

    public Map doService(String actionName, Map params, DynamicObject[] bizBills) throws Exception {
        return this.doInnerService(this.getServiceType(), actionName, params, bizBills);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map doInnerService(String serviceType, String actionName, Map params, DynamicObject[] bizBills) throws Exception {
        try {
            Throwable throwable = null;
            try (TXHandle h = TX.requiresNew();){
                HashMap<Object, String> map = new HashMap<Object, String>();
                List errList = CalServiceHelper.doBizChain((String)serviceType, (String)actionName, (Map)params, (DynamicObject[])bizBills);
                StringBuilder errorMsg = new StringBuilder();
                if (errList.size() > 0) {
                    for (ErrorMsg msg : errList) {
                        if (msg.getId() != null && msg.getId() != 0L) {
                            map.put(msg.getId(), msg.getErrorMsg());
                            continue;
                        }
                        errorMsg.append(msg.getErrorMsg()).append("\r\n");
                    }
                }
                if (errorMsg.length() > 0) {
                    map.put("error", errorMsg.toString());
                }
                if (!map.isEmpty()) {
                    h.markRollback();
                }
                HashMap<Object, String> hashMap = map;
                return hashMap;
            }
            catch (Exception e) {
                try {
                    logger.info(actionName + "\u6838\u7b97\u6821\u9a8c\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + this.getErrorMsg(e));
                    h.markRollback();
                    throw e;
                    catch (Throwable e2) {
                        logger.info(actionName + "\u6838\u7b97\u6821\u9a8c\u63a5\u53e3\u8c03\u7528\u5931\u8d25Throwable\uff1a" + this.getErrorMsg(new Exception(e2)));
                        h.markRollback();
                        throw e2;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (Exception e) {
            logger.info(actionName + "\u6838\u7b97\u6821\u9a8c\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + this.getErrorMsg(e));
            throw e;
        }
    }

    public String getErrorMsg(Exception e) {
        return CommonUtils.getLogMessage((Throwable)e);
    }
}

