/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.mservice.api.CalCloseService;

public class CalCloseServiceImpl
implements CalCloseService {
    private static final Log logger = LogFactory.getLog(CalCloseServiceImpl.class);

    public Map<String, Map<Long, Object[]>> getOwnerCloseDate(Set<Long> ownerIds) {
        logger.info("\u5e93\u5b58\u8c03\u7528\u6838\u7b97\u63a5\u53e3\u83b7\u53d6\u5173\u8d26\u65e5\u671f");
        HashMap<String, Map<Long, Object[]>> resultMap = new HashMap<String, Map<Long, Object[]>>(2);
        resultMap.put("closeDate", new HashMap(16));
        resultMap.put("startDate", new HashMap(16));
        resultMap.put("hasInit", new HashMap(16));
        QFilter ownerf = new QFilter("owner", "in", ownerIds);
        ownerf.and("isleaf", "=", (Object)true);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_closeaccounttable", (String)"owner,owner.name,owner.number,closedate", (QFilter[])new QFilter[]{ownerf});
        for (DynamicObject info : coll) {
            ((Map)resultMap.get("closeDate")).put(info.getLong("owner"), new Object[]{info.getDate("closedate")});
        }
        DataSet costAccountsData = AccountingSysHelper.getAccountingSysCostaccountDataSetByOwners(ownerIds);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        for (Row row : costAccountsData.copy()) {
            costAccountIds.add(row.getLong("costaccount"));
        }
        QFilter filter = new QFilter("entry.costaccount.id", "in", costAccountIds);
        DataSet beginDateData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_sysctrlentity", (String)"entry.costaccount.id as costaccountid,entry.costaccount.name ,entry.costaccount.number,entry.startperiod.begindate as startperioddate,entry.currentperiod.begindate as crtperioddate", (QFilter[])new QFilter[]{filter}, null);
        beginDateData = beginDateData.select("costaccountid,entry.costaccount.name,entry.costaccount.number,crtperioddate,case when crtperioddate = null then startperioddate else crtperioddate end as begindate");
        DataSet ownerBeginDateData = costAccountsData.leftJoin(beginDateData).on("costaccount", "costaccountid").select(new String[]{"owner"}, new String[]{"entry.costaccount.name", "entry.costaccount.number", "begindate", "crtperioddate"}).finish();
        ownerBeginDateData = ownerBeginDateData.filter("entry.costaccount.number is not null").orderBy(new String[]{"begindate"});
        for (Row row : ownerBeginDateData) {
            if (row.getDate("crtperioddate") != null) {
                ((Map)resultMap.get("hasInit")).put(row.getLong("owner"), null);
            }
            if (row.getDate("begindate") == null) continue;
            Date maxBeginDate = row.getDate("begindate");
            String costAccountNumber = row.getString("entry.costaccount.number");
            String costAccountName = row.getString("entry.costaccount.name");
            ((Map)resultMap.get("startDate")).put(row.getLong("owner"), new Object[]{maxBeginDate, costAccountNumber, costAccountName});
        }
        for (Map.Entry startDateInfoMap : ((Map)resultMap.get("startDate")).entrySet()) {
            WriteLogHelper.writeInfoLog((Log)logger, (String)("ownerId\uff1a" + startDateInfoMap.getKey() + ",maxBeginDate:" + ((Object[])startDateInfoMap.getValue())[0]), (Object[])new Object[0]);
        }
        logger.info("\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u7684\u8d27\u4e3bid\uff1a" + ((Map)resultMap.get("hasInit")).keySet().toString());
        return resultMap;
    }

    public Map<Long, Date> getAcctOrgCloseDate(Set<Long> acctOrgIds) {
        HashMap<Long, Date> acctOrgIdCloseDateMap = new HashMap<Long, Date>(acctOrgIds.size());
        DynamicObjectCollection accSysColl = AccountingSysHelper.getAccountingSysColls(new ArrayList<Long>(acctOrgIds), null);
        HashSet<Long> ownerIds = new HashSet<Long>(16);
        HashMap<Long, Set> ownerIdAcctOrgIdsMap = new HashMap<Long, Set>(acctOrgIds.size());
        for (DynamicObject accSysInfo : accSysColl) {
            Set ownerIdAcctOrgIds = ownerIdAcctOrgIdsMap.computeIfAbsent(accSysInfo.getLong("ownerid"), k -> new HashSet(16));
            ownerIdAcctOrgIds.add(accSysInfo.getLong("calorgid"));
            ownerIds.add(accSysInfo.getLong("ownerid"));
        }
        QFilter ownerf = new QFilter("owner", "in", ownerIds);
        ownerf.and("isleaf", "=", (Object)true);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_closeaccounttable", (String)"owner,owner.name,owner.number,closedate", (QFilter[])new QFilter[]{ownerf});
        for (DynamicObject info : coll) {
            Long ownerId = info.getLong("owner");
            Set ownerAcctOrgIds = (Set)ownerIdAcctOrgIdsMap.get(ownerId);
            for (Long acctOrgId : ownerAcctOrgIds) {
                Date maxCloseDate = (Date)acctOrgIdCloseDateMap.get(acctOrgId);
                if (maxCloseDate == null) {
                    acctOrgIdCloseDateMap.put(acctOrgId, info.getDate("closedate"));
                    continue;
                }
                if (!maxCloseDate.before(info.getDate("closedate"))) continue;
                acctOrgIdCloseDateMap.put(acctOrgId, info.getDate("closedate"));
            }
        }
        return acctOrgIdCloseDateMap;
    }

    public Map<Long, Object[]> getAcctPeriodStartDate(Set<Long> ownerIds) {
        if (null == ownerIds || ownerIds.size() == 0) {
            return null;
        }
        HashMap<Long, Object[]> resultMap = new HashMap<Long, Object[]>(ownerIds.size());
        for (Long ownerId : ownerIds) {
            Long[] costAccountIds = AccountingSysHelper.getCostAccounts((Long)ownerId);
            if (costAccountIds == null || costAccountIds.length <= 0) continue;
            QFilter filter = new QFilter("entry.costaccount.id", "in", (Object)costAccountIds);
            DataSet beginDateColl = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_sysctrlentity", (String)"entry.costaccount.name,entry.costaccount.number,entry.currentperiod.begindate", (QFilter[])new QFilter[]{filter}, null);
            beginDateColl = beginDateColl.orderBy(new String[]{"entry.currentperiod.begindate"});
            for (Row row : beginDateColl) {
                Date maxBeginDate = row.getDate("entry.currentperiod.begindate");
                String costaccountNumber = row.getString("entry.costaccount.number");
                String costaccountName = row.getString("entry.costaccount.name");
                Object[] result = new Object[]{maxBeginDate, costaccountNumber, costaccountName};
                resultMap.put(ownerId, result);
            }
        }
        return resultMap;
    }
}

