/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cal.business.bizfinint.BizFinIntHelper;
import kd.fi.cal.business.bizfinint.BizFinIntOrderRedisLock;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.AccountTypeExplainHelper;
import kd.fi.cal.mservice.api.ICalCommonService;

public class CalCommonServiceImpl
implements ICalCommonService {
    private static final Log logger = LogFactory.getLog(CalCommonServiceImpl.class);

    public Map<String, Map<String, Object>> getAccountTypeByBillIds(String entity, Collection<Long> billIds) {
        AccountTypeExplainHelper accountTypeExplainHelper = new AccountTypeExplainHelper(entity);
        accountTypeExplainHelper.setBillIds(billIds);
        accountTypeExplainHelper.setExplainFromDb(true);
        Map entryFieldValueMap = accountTypeExplainHelper.explain();
        return entryFieldValueMap;
    }

    public Map<String, Boolean> getRealTimeAccountTypeByBillDycs(DynamicObject[] billDycs) {
        HashMap<String, Boolean> entryContainRealTimeAcctMap = new HashMap<String, Boolean>(16);
        if (billDycs == null || billDycs.length < 1) {
            return entryContainRealTimeAcctMap;
        }
        AccountTypeExplainHelper accountTypeExplainHelper = new AccountTypeExplainHelper();
        accountTypeExplainHelper.setBillDycs(billDycs);
        Map entryFieldValueMap = accountTypeExplainHelper.explain();
        for (Map.Entry entryFieldValueEntry : entryFieldValueMap.entrySet()) {
            String accountType = (String)((Map)entryFieldValueEntry.getValue()).get("accounttype");
            if (!accountType.equals(AccountTypeEnum.MOVE_ADD_AVERAGE.getValue()) && !accountType.equals(AccountTypeEnum.FIN_FOUT.getValue()) && !accountType.equals(AccountTypeEnum.STANDARDCOST.getValue())) continue;
            entryContainRealTimeAcctMap.put((String)entryFieldValueEntry.getKey(), Boolean.TRUE);
        }
        return entryContainRealTimeAcctMap;
    }

    public Map<String, Map<String, Object>> getAccountTypeByBillDycs(DynamicObject[] billDycs) {
        Map<String, Map<String, Object>> entryFieldValueMap = new HashMap<String, Map<String, Object>>(0);
        if (billDycs == null || billDycs.length < 1) {
            return entryFieldValueMap;
        }
        AccountTypeExplainHelper accountTypeExplainHelper = new AccountTypeExplainHelper();
        accountTypeExplainHelper.setBillDycs(billDycs);
        entryFieldValueMap = accountTypeExplainHelper.explain();
        return entryFieldValueMap;
    }

    public void releaseLockByBizId(Set<String> reqIds, Set<Long> bizBillIds) {
        new BizFinIntOrderRedisLock().releaseLockByBizId(reqIds, bizBillIds);
    }

    public void reverseByBizId(Set<String> reqIds, Set<Long> bizBillIds) {
        logger.info("\u4e1a\u8d22\u4e00\u4f53\u5316\u56de\u6eda\u63a5\u53e3\u5f00\u59cb\uff1areqIds\uff1a" + reqIds + "\uff0cbizBillIds\uff1a" + bizBillIds);
        new BizFinIntHelper().doReverseByReqId(reqIds, bizBillIds);
        logger.info("\u4e1a\u8d22\u4e00\u4f53\u5316\u56de\u6eda\u63a5\u53e3\u7ed3\u675f\uff1a");
    }
}

