/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.calculate.in.FeeShareCostAdjustBillHelper;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.mservice.api.CalCostAdjustBillService;

public class CalCostAdjustBillServiceImpl
implements CalCostAdjustBillService {
    private static final Log logger = LogFactory.getLog(CalCostAdjustBillServiceImpl.class);

    public Map createBill(Map map) {
        try (TXHandle tx = TX.required();){
            String errMsg = null;
            Set costAdjustBillIds = null;
            try {
                FeeShareCostAdjustBillHelper feeShareCostAdjustBillHelper;
                Set params;
                String createType = (String)map.get("createtype");
                if (CostAdjustBilCreateTypeEnum.FEE_SHARE.getValue().equals(createType)) {
                    params = (Set)map.get("params");
                    logger.info("\u8d39\u7528\u5206\u644a" + params);
                    feeShareCostAdjustBillHelper = new FeeShareCostAdjustBillHelper(params);
                    feeShareCostAdjustBillHelper.createBill();
                    costAdjustBillIds = feeShareCostAdjustBillHelper.getAdjustBillIds();
                } else if (CostAdjustBilCreateTypeEnum.FEE_ESTIMATE.getValue().equals(createType)) {
                    params = (Set)map.get("params");
                    logger.info("\u8d39\u7528\u6682\u4f30" + params);
                    feeShareCostAdjustBillHelper = new FeeShareCostAdjustBillHelper(params, false);
                    feeShareCostAdjustBillHelper.createBill();
                    costAdjustBillIds = feeShareCostAdjustBillHelper.getAdjustBillIds();
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
                errMsg = CommonUtils.getLogMessage((Throwable)e, (int)2000);
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            if (StringUtils.isEmpty((String)errMsg)) {
                resultMap.put("success", true);
                resultMap.put("costAdjustBillIds", costAdjustBillIds);
            } else {
                resultMap.put("success", false);
                resultMap.put("errMsg", errMsg);
            }
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
    }
}

