/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.cal.business.calculate.out.CalIntimeBufferPoolHelper;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.business.service.SyncLockHelper;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.mservice.api.CalCostAdjustDeleteService;

public class CalCostAdjustDeleteServiceImpl
implements CalCostAdjustDeleteService {
    private static final Log logger = LogFactory.getLog(CalCostAdjustDeleteServiceImpl.class);

    public void deleteCostAdjust(Set<Long> apIds) {
        if (apIds.isEmpty()) {
            return;
        }
        String orgInfo = "id,org,entry.id,entry.e_srcbillid,isadjust,billno,bookdate,bizdate";
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"ap_busbill", (String)orgInfo, (QFilter[])new QFilter("id", "in", apIds).toArray());
        try (SyncLockHelper syncLockHelper = new SyncLockHelper(ActionEnum.UN_REESTIMATE.getValue(), load);){
            syncLockHelper.setNoRetry(true);
            List mutErrors = syncLockHelper.lock();
            StringBuilder sb = new StringBuilder();
            HashSet<String> errMsgs = new HashSet<String>(16);
            for (ErrorMsg err : mutErrors) {
                errMsgs.add(err.getErrorMsg());
            }
            for (String errMsg : errMsgs) {
                sb.append(errMsg);
            }
            if (sb.length() > 0) {
                throw new KDBizException(sb.toString());
            }
            logger.info("\u6682\u4f30\u8c03\u4ef7\u8c03\u7528\u6838\u7b97\u5220\u9664\u8c03\u6574\u5355\u63a5\u53e3\u5f00\u59cb\u3002\u3002\u3002" + System.currentTimeMillis());
            this.deleteAPCostAdjust(apIds);
            this.deleteApstdcostdiffbill(apIds);
        }
    }

    private void deleteAPCostAdjust(Set<Long> apIds) {
        logger.info("deleteAPCostAdjust\u5220\u9664\u6682\u4f30\u8c03\u6574\u5355{} ", apIds);
        Set calCostAdjustIds = new HashSet<Long>(16);
        QFilter createTypeFilter = new QFilter("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.PUR_ADJUSTESTIMATE.getValue());
        QFilter adjustIdFilter = new QFilter("entryentity.srcbillid", "in", apIds);
        DynamicObjectCollection costAdjusts = QueryServiceHelper.query((String)"cal_costadjust_subentity", (String)"id,billno", (QFilter[])new QFilter[]{adjustIdFilter, createTypeFilter}, null);
        if (costAdjusts == null || costAdjusts.isEmpty()) {
            return;
        }
        for (DynamicObject costAdjust : costAdjusts) {
            calCostAdjustIds.add(costAdjust.getLong("id"));
        }
        Object[] calCostAdjustIdsArr = calCostAdjustIds.toArray(new Long[0]);
        OperateOption op = OperateOption.create();
        op.setVariableValue("unwriteoff", "true");
        op.setVariableValue("ishasright", "true");
        op.setVariableValue("ignoreValidation", "true");
        logger.info("\u6682\u4f30\u91cd\u4f30\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u5f00\u59cb:" + ((DynamicObject)costAdjusts.get(0)).getString("billno"));
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costadjust_subentity", (Object[])calCostAdjustIdsArr, (OperateOption)op);
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            List errors = result.getAllErrorOrValidateInfo();
            if (!errors.isEmpty()) {
                msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff1a", (String)"PurUnWriteOffServiceProcess_0", (String)"fi-cal-business", (Object[])new Object[0]));
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
            }
            throw new KDBizException(msg.toString());
        }
        calCostAdjustIds = CalIntimeBufferPoolHelper.removeBufferPoolRevBill((String)"cal_costadjust_subentity", calCostAdjustIds);
        logger.info("\u6682\u4f30\u8c03\u4ef7\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a\u6210\u672c\u8c03\u6574\u5355\u5220\u9664\u5f00\u59cb:" + calCostAdjustIds);
        if (!calCostAdjustIds.isEmpty()) {
            QFilter deleteFilter = new QFilter("id", "in", calCostAdjustIds);
            DeleteServiceHelper.delete((String)"cal_costadjustbill", (QFilter[])new QFilter[]{deleteFilter});
        }
    }

    private void deleteApstdcostdiffbill(Set<Long> apIds) {
        logger.info("deleteApstdcostdiffbill\u5220\u9664\u6682\u4f30\u8c03\u6574\u5355{} ", apIds);
        Set stdcostdiffbillIds = new HashSet<Long>(16);
        QFilter createTypeFilter = new QFilter("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.PUR_ADJUSTESTIMATE.getValue());
        QFilter adjustIdFilter = new QFilter("entryentity.srcbillid", "in", apIds);
        DynamicObjectCollection stdcostdiffbills = QueryServiceHelper.query((String)"cal_stdcostdiffbill", (String)"id,billno", (QFilter[])new QFilter[]{adjustIdFilter, createTypeFilter}, null);
        if (stdcostdiffbills == null || stdcostdiffbills.isEmpty()) {
            return;
        }
        for (DynamicObject stdcostdiff : stdcostdiffbills) {
            stdcostdiffbillIds.add(stdcostdiff.getLong("id"));
        }
        Object[] stdcostdiffbillIdsArr = stdcostdiffbillIds.toArray(new Long[0]);
        OperateOption op = OperateOption.create();
        op.setVariableValue("unwriteoff", "true");
        op.setVariableValue("ishasright", "true");
        op.setVariableValue("ignoreValidation", "true");
        logger.info("\u6682\u4f30\u91cd\u4f30\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u53cd\u5ba1\u6838\u5f00\u59cb:" + ((DynamicObject)stdcostdiffbills.get(0)).getString("billno"));
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_stdcostdiffbill", (Object[])stdcostdiffbillIdsArr, (OperateOption)op);
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            List errors = result.getAllErrorOrValidateInfo();
            if (!errors.isEmpty()) {
                msg.append(ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff1a", (String)"PurUnWriteOffServiceProcess_3", (String)"fi-cal-mservice", (Object[])new Object[0]));
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
            }
            throw new KDBizException(msg.toString());
        }
        stdcostdiffbillIds = CalIntimeBufferPoolHelper.removeBufferPoolRevBill((String)"cal_stdcostdiffbill", stdcostdiffbillIds);
        logger.info("\u6682\u4f30\u8c03\u4ef7\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u5220\u9664\u5f00\u59cb:" + stdcostdiffbillIds);
        if (!stdcostdiffbillIds.isEmpty()) {
            QFilter deleteFilter = new QFilter("id", "in", stdcostdiffbillIds);
            DeleteServiceHelper.delete((String)"cal_stdcostdiffbill", (QFilter[])new QFilter[]{deleteFilter});
        }
    }
}

