/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.mservice.MaterialCostUpdator;

public class CalCostPriceServiceHelper {
    private static final String PARAMKEY_QTY = "qty";
    private static final String PARAMKEY_FILTER = "filter";
    private static final String PARAMKEY_PRICE = "price";
    private static final String PARAMKEY_COST = "cost";
    private static final String PARAMKEY_COSTACCOUNT = "costaccount";
    private static final Long IM_PURINBILL_STD_BT_S = 366348248593474560L;
    private Map<Long, Long> currentPeriodCache = new HashMap<Long, Long>();

    Map<String, Object> checkBizLegality(List<Map<String, Object>> paramList) {
        List<Map<String, Object>> params = this.resolveParams(paramList);
        LinkedList<String> errorInfos = new LinkedList<String>();
        for (Map<String, Object> paramMap : params) {
            String content;
            DataSet sumDataSet;
            BigDecimal currentTotalQty;
            BigDecimal qty = (BigDecimal)paramMap.get(PARAMKEY_QTY);
            BigDecimal price = (BigDecimal)paramMap.get(PARAMKEY_PRICE);
            BigDecimal cost = (BigDecimal)paramMap.get(PARAMKEY_COST);
            Long costaccount = (Long)paramMap.get(PARAMKEY_COSTACCOUNT);
            QFilter filter = new QFilter(PARAMKEY_COSTACCOUNT, "=", (Object)costaccount);
            QFilter exFilter = (QFilter)paramMap.get(PARAMKEY_FILTER);
            if (exFilter != null) {
                filter = filter.and(exFilter);
            }
            QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
            filter.and(billStatusf);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)"id,billno,calorg,costaccount,costaccount.costtype as costtype,period,issplitcreate,issplit,issubbillinvoiceverify,billtype,isvoucher,localcurrency.amtprecision as amtprecision,entry.id as entryid,entry.material as material,entry.baseqty as baseqty,entry.materialcost as materialcost,entry.processcost as processcost,entry.fee as fee,entry.resource as resource,entry.manufacturecost as manufacturecost,entry.actualcost as actualcost,entry.accounttype as accounttype,entry.fatherentryid as fatherentryid,entry.ancestorentryid as ancestorentryid", (QFilter[])filter.toArray(), null);
            DataSet rootBillSet = dataSet.copy().filter("issplitcreate = false");
            if (rootBillSet.isEmpty()) {
                errorInfos.add(ResManager.loadKDString((String)"\u4f9d\u636e\u8fc7\u6ee4\u6761\u4ef6\u6ca1\u6709\u67e5\u8be2\u51fa\u4efb\u4f55\u5355\u636e\u3002", (String)"MaterialCostUpdateServiceImpl_0", (String)"fi-cal-mservice", (Object[])new Object[0]));
            }
            if ((currentTotalQty = (sumDataSet = rootBillSet.copy().groupBy().sum("baseqty", "baseqty").finish()).next().getBigDecimal("baseqty")).compareTo(qty) != 0) {
                String content2 = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u66f4\u65b0\u671f\u671b\u603b\u6570\u91cf%1$s\u4e0e\u5b9e\u9645\u603b\u6570\u91cf%2$s\u4e0d\u4e00\u81f4", (String)"MaterialCostUpdateServiceImpl_9", (String)"fi-cal-mservice", (Object[])new Object[0]), qty.stripTrailingZeros().toPlainString(), currentTotalQty.stripTrailingZeros().toPlainString());
                errorInfos.add(content2);
            }
            DataSet accountTypeSet = rootBillSet.copy().filter("accounttype in ('" + AccountTypeEnum.FIN_FOUT.getValue() + "','" + AccountTypeEnum.MOVE_ADD_AVERAGE + "')");
            while (accountTypeSet.hasNext()) {
                String content3 = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u8ba1\u4ef7\u65b9\u6cd5\u4e3a\u5b9e\u65f6\u79fb\u52a8\u6216\u5148\u8fdb\u5148\u51fa\u4e0d\u5141\u8bb8\u66f4\u65b0", (String)"MaterialCostUpdateServiceImpl_10", (String)"fi-cal-mservice", (Object[])new Object[0]), accountTypeSet.next().getString("billno"));
                errorInfos.add(content3);
            }
            DataSet voucherSet = rootBillSet.copy().filter("isvoucher = true");
            while (voucherSet.hasNext()) {
                String content4 = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5df2\u751f\u6210\u51ed\u8bc1\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"MaterialCostUpdateServiceImpl_11", (String)"fi-cal-mservice", (Object[])new Object[0]), voucherSet.next().getString("billno"));
                errorInfos.add(content4);
            }
            DataSet periodSet = rootBillSet.copy();
            while (periodSet.hasNext()) {
                Row row = periodSet.next();
                if (row.getLong("period").equals(this.getCurrentPeriodID(row.getLong(PARAMKEY_COSTACCOUNT)))) continue;
                content = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u4e3a\u5f80\u671f\u5355\u636e\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"MaterialCostUpdateServiceImpl_12", (String)"fi-cal-mservice", (Object[])new Object[0]), row.getString("billno"));
                errorInfos.add(content);
            }
            DataSet invoiceSet = rootBillSet.copy().filter("billtype = " + IM_PURINBILL_STD_BT_S).filter("issubbillinvoiceverify = true");
            while (invoiceSet.hasNext()) {
                content = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5b50\u5355\u5df2\u53d1\u7968\u6838\u9500\u4e0d\u5141\u8bb8\u66f4\u65b0", (String)"MaterialCostUpdateServiceImpl_13", (String)"fi-cal-mservice", (Object[])new Object[0]), invoiceSet.next().getString("billno"));
                errorInfos.add(content);
            }
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        if (errorInfos.isEmpty()) {
            resultMap.put("success", true);
        } else {
            resultMap.put("success", false);
            resultMap.put("errmsg", ((Object)errorInfos).toString());
        }
        return resultMap;
    }

    public void updateCalCostRecord(List<Map<String, Object>> paramList) {
        List<Map<String, Object>> params = this.resolveParams(paramList);
        new MaterialCostUpdator().updateMaterialCost(params);
    }

    private List<Map<String, Object>> resolveParams(List<Map<String, Object>> paramList) {
        try (AlgoContext context = Algo.newContext();){
            HashSet<String> entityObjects = new HashSet<String>(16);
            HashSet<Object> billIds = new HashSet<Object>(16);
            HashSet<Object> entryIds = new HashSet<Object>(16);
            for (Map<String, Object> map : paramList) {
                String entityObject = (String)map.get("entityobject");
                Object billId = map.get("billid");
                Object entryId = map.get("entryid");
                if (StringUtils.isNotEmpty((String)entityObject)) {
                    entityObjects.add(entityObject);
                }
                if (billId != null) {
                    billIds.add(billId);
                }
                if (entryId == null) continue;
                entryIds.add(entryId);
            }
            QFilter costRecordFilter = new QFilter("bizentityobject", "in", entityObjects);
            costRecordFilter.and("bizbillid", "in", billIds);
            costRecordFilter.and("entry.bizbillentryid", "in", entryIds);
            costRecordFilter.and("issplitcreate", "=", (Object)false);
            QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
            costRecordFilter.and(billStatusf);
            ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(16);
            try (DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"costaccount,bizentityobject,bizbillid,exchangerate,entry.bizbillentryid", (QFilter[])costRecordFilter.toArray(), null);){
                for (Map<String, Object> map : paramList) {
                    String entityObject = (String)map.get("entityobject");
                    Object billId = map.get("billid");
                    Object entryId = map.get("entryid");
                    BigDecimal cost = (BigDecimal)map.get(PARAMKEY_COST);
                    BigDecimal qty = (BigDecimal)map.get(PARAMKEY_QTY);
                    DataSet tempDataSet = costRecordDataSet.copy();
                    QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
                    if (StringUtils.isNotEmpty((String)entityObject)) {
                        qFilter.and("bizentityobject", "=", (Object)entityObject);
                    }
                    if (billId != null) {
                        qFilter.and("bizbillid", "=", billId);
                    }
                    if (entryId != null) {
                        qFilter.and("entry.bizbillentryid", "=", entryId);
                    }
                    tempDataSet = tempDataSet.where(qFilter.toString());
                    for (Row row : tempDataSet) {
                        Object costAccount = row.get(PARAMKEY_COSTACCOUNT);
                        BigDecimal exchangerate = row.getBigDecimal("exchangerate");
                        cost = cost.multiply(exchangerate);
                        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                        paramMap.put(PARAMKEY_COSTACCOUNT, costAccount);
                        paramMap.put(PARAMKEY_FILTER, qFilter);
                        paramMap.put(PARAMKEY_QTY, qty);
                        paramMap.put(PARAMKEY_COST, cost);
                        params.add(paramMap);
                    }
                }
            }
            ArrayList<Map<String, Object>> arrayList = params;
            return arrayList;
        }
    }

    protected Long getCurrentPeriodID(Long costAccountID) {
        Long periodId = this.currentPeriodCache.get(costAccountID);
        if (periodId == null) {
            periodId = PeriodHelper.getCurrentPeriod((Long)costAccountID).getLong("id");
            this.currentPeriodCache.put(costAccountID, periodId);
        }
        return periodId;
    }
}

