/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceDimFieldParser;
import kd.fi.cal.business.costprice.CostPrice4Others;
import kd.fi.cal.business.costprice.CostPrice4SCMHelper;
import kd.fi.cal.business.costprice.DayAvgPriceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalFieldMapHelper;
import kd.fi.cal.mservice.CalCostPriceServiceHelper;
import kd.fi.cal.mservice.api.CalCostPriceService;

public class CalCostPriceServiceImpl
implements CalCostPriceService {
    private static Log log = LogFactory.getLog(CalCostPriceServiceImpl.class);

    public Map<Object, Map<String, Object>> getPrice(Map<Object, Map<String, Object>> params) {
        log.info("\u7ec4\u7ec7\u95f4\u4ea4\u6613\u53d6\u4ef7\u53c2\u6570\u4e3a:" + params);
        if (params == null || params.isEmpty()) {
            return null;
        }
        log.info("\u7ec4\u7ec7\u95f4\u4ea4\u6613\u53d6\u4ef7\u53c2\u6570\u5171" + params.size() + "\u7ec4");
        try (AlgoContext context = Algo.newContext();){
            if (CalDbParamServiceHelper.getBoolean((String)"costprice_scm_new").booleanValue()) {
                Map curResMap;
                QFilter schemeFilter = new QFilter("priceobject", "=", (Object)"G");
                schemeFilter.and("enable", "=", (Object)"1");
                int size = CalDbParamServiceHelper.getInteger((String)"costprice_scm_size");
                HashMap resMap = new HashMap(16);
                HashMap<Object, Map<String, Object>> curParams = new HashMap<Object, Map<String, Object>>(16);
                for (Map.Entry<Object, Map<String, Object>> entry : params.entrySet()) {
                    curParams.put(entry.getKey(), entry.getValue());
                    if (curParams.size() < size) continue;
                    Map curResMap2 = new CostPrice4Others().getPriceFromEntryParmsMap(curParams, schemeFilter);
                    if (curResMap2 != null) {
                        resMap.putAll(curResMap2);
                    }
                    curParams.clear();
                }
                if (curParams.size() > 0 && (curResMap = new CostPrice4Others().getPriceFromEntryParmsMap(curParams, schemeFilter)) != null) {
                    resMap.putAll(curResMap);
                }
                log.info("\u7ec4\u7ec7\u95f4\u4ea4\u6613\u53d6\u4ef7\u7ed3\u679c\u4e3a:" + resMap);
                log.info("\u7ec4\u7ec7\u95f4\u4ea4\u6613\u53d6\u4ef7\u7ed3\u679c\u5171" + (resMap == null ? 0 : resMap.size()) + "\u7ec4");
                HashMap hashMap = resMap;
                return hashMap;
            }
            Map map = new CostPrice4SCMHelper().getCostPriceFromMap4SCM(params);
            log.info("\u7ec4\u7ec7\u95f4\u4ea4\u6613\u53d6\u4ef7\u7ed3\u679c\u4e3a:" + map);
            log.info("\u7ec4\u7ec7\u95f4\u4ea4\u6613\u53d6\u4ef7\u7ed3\u679c\u5171" + (map == null ? 0 : map.size()) + "\u7ec4");
            Map map2 = map;
            return map2;
        }
    }

    public Map<Object, Map<String, Object>> getPrice4ExtSys(String priceObject, Map<Object, Map<String, Object>> params) {
        log.info("\u5916\u90e8\u5355\u636e\u53d6\u4ef7\u3010" + priceObject + "\u3011\u53d6\u4ef7\u53c2\u6570\u4e3a:" + params);
        if (StringUtils.isEmpty((String)priceObject) || params == null || params.isEmpty()) {
            return null;
        }
        log.info("\u5916\u90e8\u5355\u636e\u53d6\u4ef7\u3010" + priceObject + "\u3011\u53d6\u4ef7\u53c2\u6570\u5171" + params.size() + "\u7ec4");
        try (AlgoContext context = Algo.newContext();){
            if (CalDbParamServiceHelper.getBoolean((String)"costprice_scm_new").booleanValue()) {
                Map curResMap;
                QFilter schemeFilter = new QFilter("priceobject", "=", (Object)priceObject);
                schemeFilter.and("enable", "=", (Object)"1");
                int size = CalDbParamServiceHelper.getInteger((String)"costprice_scm_size");
                HashMap resMap = new HashMap(16);
                HashMap<Object, Map<String, Object>> curParams = new HashMap<Object, Map<String, Object>>(16);
                for (Map.Entry<Object, Map<String, Object>> entry : params.entrySet()) {
                    curParams.put(entry.getKey(), entry.getValue());
                    if (curParams.size() < size) continue;
                    Map curResMap2 = new CostPrice4Others().getPriceFromEntryParmsMap(curParams, schemeFilter);
                    if (curResMap2 != null) {
                        resMap.putAll(curResMap2);
                    }
                    curParams.clear();
                }
                if (curParams.size() > 0 && (curResMap = new CostPrice4Others().getPriceFromEntryParmsMap(curParams, schemeFilter)) != null) {
                    resMap.putAll(curResMap);
                }
                log.info("\u5916\u90e8\u5355\u636e\u53d6\u4ef7\u3010" + priceObject + "\u3011\u53d6\u4ef7\u7ed3\u679c\u4e3a:" + resMap);
                log.info("\u5916\u90e8\u5355\u636e\u53d6\u4ef7\u3010" + priceObject + "\u3011\u53d6\u4ef7\u7ed3\u679c\u5171" + (resMap == null ? 0 : resMap.size()) + "\u7ec4");
                HashMap hashMap = resMap;
                return hashMap;
            }
            Map map = new CostPrice4SCMHelper().getCostPriceFromMap4ExtSys(priceObject, params);
            log.info("\u5916\u90e8\u5355\u636e\u53d6\u4ef7\u3010" + priceObject + "\u3011\u53d6\u4ef7\u7ed3\u679c\u4e3a:" + map);
            log.info("\u5916\u90e8\u5355\u636e\u53d6\u4ef7\u3010" + priceObject + "\u3011\u53d6\u4ef7\u7ed3\u679c\u5171" + (map == null ? 0 : map.size()) + "\u7ec4");
            Map map2 = map;
            return map2;
        }
    }

    public Map<String, Map<String, String>> getBillFields(Set<String> billTypes) {
        log.info("\u5355\u636e\u7c7b\u578b\uff1a" + billTypes + "\u83b7\u53d6\u6838\u7b97\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e");
        Map map = new CalFieldMapHelper().getBillFields(billTypes);
        log.info("\u5355\u636e\u7c7b\u578b\uff1a" + billTypes + "\u83b7\u53d6\u5b57\u6bb5\u6620\u5c04\u4e3a:" + map);
        return map;
    }

    @Deprecated
    public Map<String, Map<String, String>> getBizBillFields(Set<String> billTypes) {
        log.info("\u5355\u636e\u7c7b\u578b\uff1a" + billTypes + "\u83b7\u53d6\u6838\u7b97\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e");
        Map map = new CalFieldMapHelper().getBizBillFields(billTypes);
        log.info("\u5355\u636e\u7c7b\u578b\uff1a" + billTypes + "\u83b7\u53d6\u5b57\u6bb5\u6620\u5c04\u4e3a:" + map);
        return map;
    }

    public Map<String, Map<String, Set<String>>> getBizBillField2CalBillFields(Set<String> billTypes) {
        log.info("\u5355\u636e\u7c7b\u578b\uff1a" + billTypes + "\u83b7\u53d6\u6838\u7b97\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e");
        Map map = new CalFieldMapHelper().getBizBillField2CalBillFields(billTypes);
        log.info("\u5355\u636e\u7c7b\u578b\uff1a" + billTypes + "\u83b7\u53d6\u5b57\u6bb5\u6620\u5c04\u4e3a:" + map);
        return map;
    }

    public Map<String, Object> checkBizLegality(List<Map<String, Object>> paramList) {
        try (AlgoContext context = Algo.newContext();){
            Map<String, Object> map = new CalCostPriceServiceHelper().checkBizLegality(paramList);
            return map;
        }
    }

    public void updateCalCostRecord(List<Map<String, Object>> paramList) {
        new CalCostPriceServiceHelper().updateCalCostRecord(paramList);
    }

    public Map<String, BigDecimal> getDayAvgPrice(Set<Long> calOrgIds, Date calDate, Set<Long> matIds, QFilter dimFilter) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u6307\u5b9a\u65e5\u671f\u52a0\u6743\u5355\u4ef7\u63a5\u53e3,calOrgIds==>{},calDate==>{},matIds==>{},dimFilter==>{}", new Object[]{calOrgIds, calDate, matIds, dimFilter});
        DayAvgPriceHelper helper = new DayAvgPriceHelper(calOrgIds, calDate, matIds, dimFilter);
        Map calOrgMatAvgPriceMap = helper.getDayAvgPrice();
        log.info("\u7ed3\u675f\u83b7\u53d6\u6307\u5b9a\u65e5\u671f\u52a0\u6743\u5355\u4ef7\u63a5\u53e3calOrgMatAvgPriceMap==>{}", (Object)calOrgMatAvgPriceMap);
        return calOrgMatAvgPriceMap;
    }

    public String getPeriodBeginCostPriceByCache(Long costAccountId, Long periodId, Set<Long> storageorgunitIds, Set<Long> materialids, boolean isdetail) {
        log.info("\u671f\u521d\u52a0\u6743\u5e73\u5747\u4ef7\u4f20\u5165\u53c2\u6570costAccountId\uff1a" + costAccountId + "periodId:" + periodId + "storageorgunitIds:" + storageorgunitIds + "isdetail:" + isdetail);
        if (costAccountId == null || costAccountId == 0L || periodId == null || periodId == 0L) {
            return null;
        }
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period", (String)"id,periodyear,periodnumber");
        int periodInt = period.getInt("periodyear") * 100 + period.getInt("periodnumber");
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
        filter.and("endperiod", ">=", (Object)periodInt);
        filter.and("period", "<", (Object)periodInt);
        if (storageorgunitIds != null && !storageorgunitIds.isEmpty()) {
            filter.and("storageorgunit", "in", storageorgunitIds);
        }
        String entityName = "cal_balance_subentity";
        Set balanceDimSet = new BalanceDimFieldParser().getBalanceFields(false, false);
        balanceDimSet.add("calorg");
        balanceDimSet.remove("costelement");
        balanceDimSet.remove("costsubelement");
        String selectFields = ",entryentity.costelement as costelement,entryentity.costsubelement as costsubelement,periodendqty as baseqty,entryentity.sub_periodendactualcost as actualcost";
        if (CalBalanceModelHelper.isNewBalance()) {
            entityName = "cal_bal";
            selectFields = ",costelement,costsubelement,baseqty_bal as baseqty,actualcost_bal as actualcost";
        }
        String selects = String.join((CharSequence)",", balanceDimSet) + selectFields;
        String entity = entityName;
        DataSet dataSet = null;
        if (materialids == null || materialids.isEmpty()) {
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)selects, (QFilter[])filter.toArray(), null);
        } else {
            ArrayList inputs = new ArrayList(16);
            Lists.partition(Arrays.asList(materialids.toArray(new Long[0])), (int)CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.MATERIAL_BATCH_SIZE)).forEach(list -> {
                QFilter partFilter = new QFilter("material", "in", list);
                partFilter.and(filter);
                OrmInput input = new OrmInput(this.getClass().getName(), entity, selects, partFilter.toArray());
                inputs.add(input);
            });
            if (inputs.isEmpty()) {
                return null;
            }
            dataSet = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        }
        if (!isdetail) {
            dataSet = dataSet.groupBy(balanceDimSet.toArray(new String[0])).max("baseqty").sum("actualcost").finish();
        }
        dataSet = dataSet.where("baseqty <> 0 or actualcost <> 0");
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout((long)CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.COSTPRICE_CACHE_TIMEOUT).intValue(), TimeUnit.SECONDS);
        CachedDataSet cache = dataSet.cache(cacheHint);
        String cacheId = cache.getCacheId();
        log.info("\u671f\u521d\u52a0\u6743\u5e73\u5747\u4ef7\u8fd4\u56decacheId\uff1a" + cacheId);
        return cacheId;
    }
}

