/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceDimFieldParser;
import kd.fi.cal.business.balance.BalanceUncompressHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CostUpdateApplyBillAuditHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;

public class CalCostUpdateHelper {
    private static final Log logger = LogFactory.getLog(CalCostUpdateHelper.class);
    private Long costTypeId = 0L;
    private Set<Map<String, Object>> maps = null;
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private int i = 0;
    private Long srcbillid = 0L;
    private Date bookdate = null;

    public CalCostUpdateHelper(Long costTypeId, Set<Map<String, Object>> maps) {
        this.costTypeId = costTypeId;
        this.maps = maps;
        logger.info("\u6807\u51c6\u6210\u672c\u66f4\u65b0\u670d\u52a1\u4f20\u5165\u53c2\u6570\u6210\u672c\u7c7b\u578b\uff1a" + costTypeId + "maps:" + maps);
    }

    public Map<String, Object> updateCost() {
        DataSet balanceDataSet;
        this.i = 0;
        String result = "1";
        String msg = "";
        HashSet<String> filters = new HashSet<String>(this.maps.size());
        HashSet<Object> materials = new HashSet<Object>(this.maps.size());
        HashMap<String, BigDecimal> oldPriceMap = new HashMap<String, BigDecimal>(this.maps.size());
        HashMap<String, BigDecimal> newPriceMap = new HashMap<String, BigDecimal>(this.maps.size());
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map<String, Object> map : this.maps) {
            Date effectdate;
            WriteLogHelper.writeInfoLog((Log)logger, (String)("CalCostUpdateHelper map\uff1a" + map), (Object[])new Object[0]);
            Object material = map.get("materialid");
            QFilter q = new QFilter("material", "=", material);
            for (Map.Entry<String, Object> entryValue : map.entrySet()) {
                String key = entryValue.getKey();
                Object value = entryValue.getValue();
                if ("materialid".equals(key) || null == value || "oldprice".equals(key) || "newprice".equals(key) || "effectdate".equals(key) || "updatebillid".equals(key)) continue;
                if ("elementid".equals(key)) {
                    q.and("costelement", "=", value);
                    continue;
                }
                if ("subelementid".equals(key)) {
                    q.and("costsubelement", "=", value);
                    continue;
                }
                if ("matverisoinid".equals(key)) {
                    if (value.equals(0L)) continue;
                    q.and("mversion", "=", value);
                    continue;
                }
                if ("auxpropid".equals(key)) {
                    if (value.equals(0L)) continue;
                    q.and("assist", "=", value);
                    continue;
                }
                if (value instanceof Long) {
                    if (value.equals(0L)) continue;
                    q.and(key, "=", value);
                    continue;
                }
                if (StringUtils.isEmpty((String)String.valueOf(value))) continue;
                q.and(key, "=", value);
            }
            String key = q.toString();
            WriteLogHelper.writeInfoLog((Log)logger, (String)("CalCostUpdateHelper updateCost key\uff1a" + key), (Object[])new Object[0]);
            filters.add(key);
            materials.add(material);
            oldPriceMap.put(key, (BigDecimal)map.get("oldprice"));
            newPriceMap.put(key, (BigDecimal)map.get("newprice"));
            Object updateBillId = map.get("updatebillid");
            if (updateBillId instanceof String) {
                this.srcbillid = Long.valueOf((String)updateBillId);
            } else if (updateBillId instanceof Long) {
                this.srcbillid = (Long)updateBillId;
            }
            if ((effectdate = (Date)map.get("effectdate")) == null) continue;
            this.bookdate = DateUtils.getDayStartTime((Date)effectdate);
        }
        if (this.bookdate == null) {
            this.bookdate = DateUtils.getDayStartTime((Date)TimeServiceHelper.now());
        }
        Set balanceDimSet = new BalanceDimFieldParser().getBalanceFields(false, false);
        balanceDimSet.add("calorg");
        balanceDimSet.add("id");
        balanceDimSet.add("baseunit");
        balanceDimSet.remove("costelement");
        balanceDimSet.remove("costsubelement");
        String entityName = "cal_balance_subentity";
        String selectFields = ",calpolicy.currency as currency,calpolicy.currency.amtprecision as amtprecision,periodendqty,entryentity.costelement as costelement,entryentity.costsubelement as costsubelement,entryentity.sub_periodendstandardcost as periodendstandardcost";
        if (this.isNewBalance) {
            entityName = "cal_bal";
            selectFields = ",calpolicy.currency as currency,calpolicy.currency.amtprecision as amtprecision,baseqty_bal as periodendqty,costelement,costsubelement,standardcost_bal as periodendstandardcost";
        }
        selectFields = String.join((CharSequence)",", balanceDimSet) + selectFields;
        QFilter baseFilter = new QFilter("material", "in", materials);
        baseFilter.and("endperiod", "=", (Object)999999);
        boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        ArrayList<QFilter> ql = null;
        if (this.isNewBalance) {
            if (!balCompress) {
                baseFilter.and("baseqty_bal", "!=", (Object)0);
            } else {
                ql = new ArrayList<QFilter>();
            }
        } else {
            baseFilter.and("periodendqty", "!=", (Object)0);
        }
        baseFilter.and("accounttype", "=", (Object)"D");
        baseFilter.and("invtype.isforwardamount", "=", (Object)true);
        Date nowTime = TimeServiceHelper.now();
        ArrayList<OrmInput> billIOs = null;
        QFilter costtypeorgFilter = new QFilter("costtype", "=", (Object)this.costTypeId);
        costtypeorgFilter.and("bizstatus", "=", (Object)"1");
        costtypeorgFilter.and("effectdate", "<=", (Object)nowTime);
        costtypeorgFilter.and("invaliddate", ">", (Object)nowTime);
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_bd_costtypeorg", (String)"costaccount,calorg,storageorgunit", (QFilter[])costtypeorgFilter.toArray());
        if (null == infos || infos.length <= 0) {
            resultMap.put("result", "1");
            return resultMap;
        }
        billIOs = new ArrayList<OrmInput>(infos.length);
        ArrayList<String> balanceSplitFilters = new ArrayList<String>(4);
        ArrayList diffalloccolsList = new ArrayList(4);
        for (DynamicObject info : infos) {
            DynamicObject costaccount = info.getDynamicObject("costaccount");
            DynamicObject calorg = info.getDynamicObject("calorg");
            QFilter infoQFilter = new QFilter("costaccount", "=", costaccount.getPkValue());
            QFilter balanceSplitFilter = new QFilter("costaccount", "=", costaccount.getPkValue());
            Long calorgid = calorg.getLong("id");
            boolean multifactoryaccountFlag = ParamsHelper.getMultifactoryaccountByCalOrg((Long)calorgid);
            if (!multifactoryaccountFlag) {
                infoQFilter.and("calorg", "=", calorg.getPkValue());
            } else {
                DynamicObject storageorg = info.getDynamicObject("storageorgunit");
                if (storageorg != null) {
                    infoQFilter.and("storageorgunit", "=", storageorg.getPkValue());
                    balanceSplitFilter.and("storageorgunit", "=", storageorg.getPkValue());
                }
            }
            balanceSplitFilters.add(balanceSplitFilter.toString());
            Object diffalloccols = ParamsHelper.getAppParam((long)calorg.getLong("id"), (String)"diffalloccols");
            HashSet<String> diffalloccolSet = new HashSet<String>(4);
            diffalloccolSet.add("calorg");
            diffalloccolSet.add("material");
            if (diffalloccols != null && StringUtils.isNotEmpty((String)diffalloccols.toString())) {
                String[] stringArray = diffalloccols.toString().split(",");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s = stringArray[i];
                    if (!StringUtils.isNotEmpty((String)s)) continue;
                    diffalloccolSet.add(s);
                }
            }
            diffalloccolsList.add(diffalloccolSet);
            infoQFilter.and(baseFilter);
            if (!this.isNewBalance || !balCompress) {
                OrmInput billIO = new OrmInput(this.getClass().getName(), entityName, selectFields, new QFilter[]{infoQFilter});
                billIOs.add(billIO);
                continue;
            }
            if (ql == null) continue;
            ql.add(infoQFilter);
        }
        if (!this.isNewBalance || !balCompress) {
            Algo algo = Algo.create((String)this.getClass().getName());
            balanceDataSet = algo.createDataSet((Input[])billIOs.toArray(new OrmInput[billIOs.size()]));
        } else {
            ArrayList<String> otherFields = new ArrayList<String>();
            otherFields.add("calpolicy.currency");
            otherFields.add("calpolicy.currency.amtprecision");
            otherFields.add("costelement");
            otherFields.add("costsubelement");
            balanceDataSet = BalanceUncompressHelper.getBalancDataSetDetail((boolean)false, (boolean)true, otherFields, ql).where(new QFilter("baseqty_bal", "!=", (Object)0).toString()).select(selectFields);
        }
        DataSet[] dataSets = balanceDataSet.splitByFilter(balanceSplitFilters.toArray(new String[0]), false);
        DataSet dataSet0 = null;
        ArrayList<DataSet> dataSetList = new ArrayList<DataSet>(4);
        for (int i = 0; i < dataSets.length; ++i) {
            DataSet dataSet = dataSets[i];
            Set diffalloccolSet = (Set)diffalloccolsList.get(i);
            DataSet dataSetCopy = dataSet.copy().groupBy(diffalloccolSet.toArray(new String[0])).sum("periodendqty", "zeroline").finish();
            dataSetCopy = dataSetCopy.where("zeroline = 0");
            JoinDataSet joinDataSet = dataSet.join(dataSetCopy, JoinType.LEFT);
            Iterator multifactoryaccountFlag = diffalloccolSet.iterator();
            while (multifactoryaccountFlag.hasNext()) {
                String s = (String)multifactoryaccountFlag.next();
                joinDataSet.on(s, s);
            }
            dataSet = joinDataSet.select(dataSet.getRowMeta().getFieldNames(), new String[]{"zeroline"}).finish().where("zeroline is null");
            if (dataSet0 == null) {
                dataSet0 = dataSet;
                continue;
            }
            dataSetList.add(dataSet);
        }
        if (null == dataSet0) {
            resultMap.put("result", "1");
            return resultMap;
        }
        balanceDataSet = dataSetList.isEmpty() ? dataSet0 : dataSet0.union(dataSetList.toArray(new DataSet[0]));
        HashSet<Object> balIds = new HashSet<Object>();
        DataSet tempDataSet = balanceDataSet.copy();
        for (Row row : tempDataSet) {
            balIds.add(row.get("id"));
        }
        if (balIds.isEmpty()) {
            resultMap.put("result", "1");
            return resultMap;
        }
        DataSet headDataSet = balanceDataSet.copy().groupBy(new String[]{"calorg", "costaccount", "currency", "amtprecision"}).finish();
        HashSet<DynamicObject> costUpadateApplyBills = new HashSet<DynamicObject>();
        for (Row row : headDataSet) {
            Long calorg = Long.valueOf(row.getString("calorg"));
            AppParam appParam = new AppParam("/KIUHEXROK3D", calorg);
            appParam.setViewType(OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
            int size = (Integer)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"maxnumberentries");
            Object costaccount = row.get("costaccount");
            int amtprecision = row.getInteger("amtprecision");
            DynamicObject costUpdateApplyBill = this.createNewBill(row);
            DynamicObjectCollection entry = costUpdateApplyBill.getDynamicObjectCollection("entryentity");
            tempDataSet = balanceDataSet.copy().where("costaccount==" + costaccount.toString());
            for (String filter : filters) {
                DataSet entryDataset = tempDataSet.copy().where(filter.replaceAll("'", ""));
                BigDecimal oldPrice = (BigDecimal)oldPriceMap.get(filter);
                BigDecimal newPrice = (BigDecimal)newPriceMap.get(filter);
                int seq = 1;
                for (Row row2 : entryDataset) {
                    if (entry.size() >= size) {
                        costUpadateApplyBills.add(costUpdateApplyBill);
                        costUpdateApplyBill = this.createNewBill(row);
                        entry = costUpdateApplyBill.getDynamicObjectCollection("entryentity");
                    }
                    BigDecimal qty = row2.getBigDecimal("periodendqty");
                    BigDecimal oldAmt = qty.multiply(oldPrice).setScale(amtprecision, RoundingMode.HALF_UP);
                    BigDecimal newAmt = qty.multiply(newPrice).setScale(amtprecision, RoundingMode.HALF_UP);
                    BigDecimal costdiff = newAmt.subtract(oldAmt);
                    if (costdiff.compareTo(BigDecimal.ZERO) == 0) continue;
                    DynamicObject entryInfo = entry.addNew();
                    entryInfo.set("seq", (Object)seq);
                    entryInfo.set("storageorgunit", row2.get("storageorgunit"));
                    entryInfo.set("material", row2.get("material"));
                    entryInfo.set("mversion", row2.get("mversion"));
                    entryInfo.set("assist", row2.get("assist"));
                    entryInfo.set("lot", row2.get("lot"));
                    entryInfo.set("baseunit", row2.get("baseunit"));
                    entryInfo.set("baseqty", (Object)qty);
                    entryInfo.set("unitcost", (Object)oldPrice);
                    entryInfo.set("cost", (Object)oldAmt);
                    entryInfo.set("newunitcost", (Object)newPrice);
                    entryInfo.set("newcost", (Object)newAmt);
                    entryInfo.set("costdiff", (Object)costdiff);
                    entryInfo.set("ownertype", row2.get("ownertype"));
                    entryInfo.set("owner", row2.get("owner"));
                    entryInfo.set("project", row2.get("project"));
                    entryInfo.set("configuredcode", row2.get("configuredcode"));
                    entryInfo.set("warehouse", row2.get("warehouse"));
                    entryInfo.set("location", row2.get("location"));
                    entryInfo.set("tracknumber", row2.get("tracknumber"));
                    entryInfo.set("invtype", row2.get("invtype"));
                    entryInfo.set("invstatus", row2.get("invstatus"));
                    entryInfo.set("costelement", row2.get("costelement"));
                    entryInfo.set("costsubelement", row2.get("costsubelement"));
                    ++seq;
                }
            }
            if (entry.size() <= 0) continue;
            costUpadateApplyBills.add(costUpdateApplyBill);
        }
        if (!costUpadateApplyBills.isEmpty()) {
            try (TXHandle h = TX.required();){
                try {
                    DynamicObject[] bills = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])costUpadateApplyBills.toArray(new DynamicObject[0]));
                    HashSet<Object> billids = new HashSet<Object>(bills.length);
                    for (DynamicObject dynamicObject : bills) {
                        billids.add(dynamicObject.getPkValue());
                    }
                    MainEntityType updateApplyEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costupdateapplybill");
                    bills = BusinessDataServiceHelper.load((Object[])billids.toArray(), (DynamicObjectType)updateApplyEntityType);
                    new CostUpdateApplyBillAuditHelper().exeAudit(bills);
                }
                catch (Exception e) {
                    result = "0";
                    logger.error("\u6210\u672c\u66f4\u65b0\u5931\u8d25", (Throwable)e);
                    h.markRollback();
                    msg = CommonUtils.getLogMessage((Throwable)e, (int)240);
                }
            }
        }
        resultMap.put("result", result);
        resultMap.put("msg", msg);
        return resultMap;
    }

    private DynamicObject createNewBill(Row row) {
        Object calorg = row.get("calorg");
        Object costaccount = row.get("costaccount");
        Object currency = row.get("currency");
        String billNo = new BillNoHelper().getBillNo("cal_costupdateapplybill");
        if (StringUtils.isEmpty((String)billNo)) {
            billNo = "CBGXSQ" + String.valueOf(System.currentTimeMillis()).substring(2) + this.i++;
        }
        DynamicObject costUpdateApplyBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_costupdateapplybill");
        costUpdateApplyBill.set("billno", (Object)billNo);
        costUpdateApplyBill.set("bizdate", (Object)this.bookdate);
        costUpdateApplyBill.set("bookdate", (Object)this.bookdate);
        costUpdateApplyBill.set("calorg", calorg);
        costUpdateApplyBill.set("costaccount", costaccount);
        costUpdateApplyBill.set("currency", currency);
        costUpdateApplyBill.set("billstatus", (Object)"C");
        costUpdateApplyBill.set("srcsys", (Object)"B");
        costUpdateApplyBill.set("sumtype", (Object)"A");
        costUpdateApplyBill.set("creator", (Object)RequestContext.get().getUserId());
        costUpdateApplyBill.set("createtime", (Object)TimeServiceHelper.now());
        costUpdateApplyBill.set("modifier", (Object)RequestContext.get().getUserId());
        costUpdateApplyBill.set("modifytime", (Object)TimeServiceHelper.now());
        costUpdateApplyBill.set("auditor", (Object)RequestContext.get().getUserId());
        costUpdateApplyBill.set("auditdate", (Object)TimeServiceHelper.now());
        costUpdateApplyBill.set("srcbillentity", (Object)"cad_costupdateestablished");
        costUpdateApplyBill.set("srcbillid", (Object)this.srcbillid);
        return costUpdateApplyBill;
    }
}

