/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceDimFieldParser;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.StopSyncSettingModifyHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.mservice.CalCostUpdateHelper;
import kd.fi.cal.mservice.api.CalCostUpdateService;

public class CalCostUpdateServiceImpl
implements CalCostUpdateService {
    private static final Log logger = LogFactory.getLog(CalCostUpdateServiceImpl.class);
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    public Map<String, String> stopSyncBizBill(Long costTypeId, Set<Long> matids) {
        logger.info("----------\u6210\u672c\u4f20\u5165\u53c2\u6570\uff1a\u505c\u6b62\u670d\u52a1" + costTypeId + "\n" + matids);
        return this.modifyStopSyncBizBill(costTypeId, matids, true);
    }

    private Map<String, String> modifyStopSyncBizBill(Long costTypeId, Set<Long> matids, boolean isStop) {
        Date nowTime = TimeServiceHelper.now();
        QFilter costtypeorgFilter = new QFilter("costtype", "=", (Object)costTypeId);
        costtypeorgFilter.and("bizstatus", "=", (Object)"1");
        costtypeorgFilter.and("effectdate", "<=", (Object)nowTime);
        costtypeorgFilter.and("invaliddate", ">", (Object)nowTime);
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_bd_costtypeorg", (String)"calorg,costaccount,storageorgunit", (QFilter[])costtypeorgFilter.toArray());
        String result = "1";
        String msg = "";
        for (DynamicObject info : infos) {
            HashSet<Long> calorgIdSet = new HashSet<Long>();
            DynamicObject calorg = info.getDynamicObject("calorg");
            Long calorgid = calorg.getLong("id");
            calorgIdSet.add(calorgid);
            boolean multifactoryaccountFlag = ParamsHelper.getMultifactoryaccountByCalOrg((Long)calorgid);
            if (!multifactoryaccountFlag) {
                try {
                    if (calorgIdSet.isEmpty()) continue;
                    new StopSyncSettingModifyHelper().modifySetting(calorgIdSet, null, "D", null, matids, isStop, nowTime);
                }
                catch (Exception e) {
                    result = "0";
                    msg = e.getMessage();
                }
                continue;
            }
            DynamicObject storageorg = info.getDynamicObject("storageorgunit");
            if (storageorg == null) continue;
            try {
                if (calorgIdSet.isEmpty()) continue;
                Long storageorgid = storageorg.getLong("id");
                new StopSyncSettingModifyHelper().modifySetting(calorgIdSet, storageorgid, "D", null, matids, isStop, nowTime);
            }
            catch (Exception e) {
                result = "0";
                msg = e.getMessage();
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("result", result);
        map.put("msg", msg);
        Long time = nowTime.getTime();
        map.put("time", time.toString());
        logger.info("\u6210\u672c\u66f4\u65b0\u542f\u505c\u670d\u52a1\u7ed3\u679c\uff1a" + (isStop ? "\u505c\u6b62" : "\u542f\u52a8") + map);
        return map;
    }

    public Map<String, Object> getMaterialQty(Long costTypeId, List<Map<String, Object>> dimensions) {
        boolean success = true;
        String msg = "";
        HashSet mapSet = new HashSet();
        try {
            DataSet balanceDataSet = this.getBalanceDataSet(costTypeId, dimensions);
            for (Row row : balanceDataSet) {
                Long assist;
                HashMap<String, Object> map = new HashMap<String, Object>();
                Long calorg = row.getLong("calorg");
                Long costaccount = row.getLong("costaccount");
                Long warehouse = row.getLong("warehouse");
                Long material = row.getLong("material");
                Long mversion = row.getLong("mversion");
                Long configuredcode = row.getLong("configuredcode");
                Long tracknumber = row.getLong("tracknumber");
                Long project = row.getLong("project");
                String lot = row.getString("lot");
                if (mversion == null) {
                    mversion = 0L;
                }
                if ((assist = row.getLong("assist")) == null) {
                    assist = 0L;
                }
                if (configuredcode == null) {
                    configuredcode = 0L;
                }
                if (tracknumber == null) {
                    tracknumber = 0L;
                }
                if (project == null) {
                    project = 0L;
                }
                if (!row.getBoolean("enablestandardcost").booleanValue() && !"D".equals(row.getString("accounttype"))) continue;
                BigDecimal qty = row.getBigDecimal("periodendqty");
                map.put("accountorgid", calorg);
                map.put("costaccountid", costaccount);
                map.put("warehouseid", warehouse);
                map.put("materialid", material);
                map.put("matverisoinid", mversion);
                map.put("auxpropid", assist);
                map.put("qty", qty);
                map.put("configuredcode", configuredcode);
                map.put("tracknumber", tracknumber);
                map.put("project", project);
                map.put("lot", lot);
                mapSet.add(map);
            }
        }
        catch (Exception e) {
            success = false;
            msg = e.getMessage();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (success) {
            map.put("result", "1");
            map.put("msg", msg);
            map.put("resultset", mapSet);
        } else {
            map.put("result", "0");
            map.put("msg", msg);
        }
        return map;
    }

    private DataSet getBalanceDataSet(Long costTypeId, List<Map<String, Object>> dimensions) {
        String entityName = "cal_balance";
        Set balanceDimSet = new BalanceDimFieldParser().getBalanceFields(false, false);
        balanceDimSet.add("calorg");
        String selectFields = ",periodendqty,accounttype,costaccount.enablestandardcost as enablestandardcost";
        if (this.isNewBalance) {
            entityName = "cal_bal";
            selectFields = ",baseqty_bal as periodendqty,accounttype,costaccount.enablestandardcost as enablestandardcost";
        }
        selectFields = String.join((CharSequence)",", balanceDimSet) + selectFields;
        QFilter baseFilter = new QFilter("endperiod", "=", (Object)999999);
        this.setBalanceQfilterParam(dimensions, baseFilter);
        if (this.isNewBalance) {
            baseFilter.and("baseqty_bal", "!=", (Object)0);
            baseFilter.and("costsubelement", "=", (Object)CostElementHelper.getDefaultMaterialElements()[0]);
        } else {
            baseFilter.and("periodendqty", "!=", (Object)0);
        }
        baseFilter.and("accounttype", "=", (Object)"D");
        baseFilter.and("invtype.isforwardamount", "=", (Object)true);
        Date nowTime = TimeServiceHelper.now();
        QFilter costtypeorgFilter = new QFilter("costtype", "=", (Object)costTypeId);
        costtypeorgFilter.and("bizstatus", "=", (Object)"1");
        costtypeorgFilter.and("effectdate", "<=", (Object)nowTime);
        costtypeorgFilter.and("invaliddate", ">", (Object)nowTime);
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_bd_costtypeorg", (String)"costaccount,calorg,storageorgunit", (QFilter[])costtypeorgFilter.toArray());
        if (null == infos || infos.length <= 0) {
            return null;
        }
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(infos.length);
        ArrayList<String> balanceSplitFilters = new ArrayList<String>(4);
        ArrayList diffalloccolsList = new ArrayList(4);
        for (DynamicObject info : infos) {
            DynamicObject costaccount = info.getDynamicObject("costaccount");
            QFilter infoQFilter = new QFilter("costaccount", "=", costaccount.getPkValue());
            QFilter balanceSplitFilter = new QFilter("costaccount", "=", costaccount.getPkValue());
            DynamicObject calorg = info.getDynamicObject("calorg");
            Long calorgid = calorg.getLong("id");
            boolean multifactoryaccountFlag = ParamsHelper.getMultifactoryaccountByCalOrg((Long)calorgid);
            if (!multifactoryaccountFlag) {
                infoQFilter.and("calorg", "=", calorg.getPkValue());
            } else {
                DynamicObject storageorg = info.getDynamicObject("storageorgunit");
                if (storageorg != null) {
                    infoQFilter.and("storageorgunit", "=", storageorg.getPkValue());
                    balanceSplitFilter.and("storageorgunit", "=", storageorg.getPkValue());
                }
            }
            balanceSplitFilters.add(balanceSplitFilter.toString());
            Object diffalloccols = ParamsHelper.getAppParam((long)calorg.getLong("id"), (String)"diffalloccols");
            HashSet<String> diffalloccolSet = new HashSet<String>(4);
            diffalloccolSet.add("calorg");
            diffalloccolSet.add("material");
            if (diffalloccols != null && StringUtils.isNotEmpty((String)diffalloccols.toString())) {
                for (String s : diffalloccols.toString().split(",")) {
                    if (!StringUtils.isNotEmpty((String)s)) continue;
                    diffalloccolSet.add(s);
                }
            }
            diffalloccolsList.add(diffalloccolSet);
            infoQFilter.and(baseFilter);
            OrmInput billIO = new OrmInput(this.getClass().getName(), entityName, selectFields, new QFilter[]{infoQFilter});
            billIOs.add(billIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet balanceDataSet = null;
        if (billIOs != null && billIOs.size() > 0) {
            balanceDataSet = algo.createDataSet((Input[])billIOs.toArray(new OrmInput[billIOs.size()]));
            DataSet[] dataSets = balanceDataSet.splitByFilter(balanceSplitFilters.toArray(new String[0]), false);
            DataSet dataSet0 = null;
            ArrayList<DataSet> dataSetList = new ArrayList<DataSet>(4);
            for (int i = 0; i < dataSets.length; ++i) {
                DataSet dataSet = dataSets[i];
                Set diffalloccolSet = (Set)diffalloccolsList.get(i);
                DataSet dataSetCopy = dataSet.copy().groupBy(diffalloccolSet.toArray(new String[0])).sum("periodendqty", "zeroline").finish();
                dataSetCopy = dataSetCopy.where("zeroline = 0");
                JoinDataSet joinDataSet = dataSet.join(dataSetCopy, JoinType.LEFT);
                for (String s : diffalloccolSet) {
                    joinDataSet.on(s, s);
                }
                dataSet = joinDataSet.select(dataSet.getRowMeta().getFieldNames(), new String[]{"zeroline"}).finish().where("zeroline is null");
                if (dataSet0 == null) {
                    dataSet0 = dataSet;
                    continue;
                }
                dataSetList.add(dataSet);
            }
            if (dataSetList.isEmpty()) {
                balanceDataSet = dataSet0;
            } else if (dataSet0 != null) {
                balanceDataSet = dataSet0.union(dataSetList.toArray(new DataSet[0]));
            }
        }
        return balanceDataSet;
    }

    private void setBalanceQfilterParam(List<Map<String, Object>> dimensions, QFilter baseFilter) {
        HashSet<Object> materialSet = new HashSet<Object>(16);
        HashSet<Object> mversionSet = new HashSet<Object>(16);
        HashSet<Object> assistSet = new HashSet<Object>(16);
        HashSet<Object> projectSet = new HashSet<Object>(16);
        HashSet<Object> tracknumberSet = new HashSet<Object>(16);
        HashSet<Object> configuredcodeSet = new HashSet<Object>(16);
        HashSet<Object> lotSet = new HashSet<Object>(16);
        for (Map<String, Object> param : dimensions) {
            Object lot;
            Object configuredcode;
            Object tracknumber;
            Object project;
            Object assist;
            Object mversion;
            Object material = param.get("material");
            if (material != null) {
                materialSet.add(material);
            }
            if ((mversion = param.get("mversion")) != null) {
                mversionSet.add(mversion);
            }
            if ((assist = param.get("assist")) != null) {
                assistSet.add(assist);
            }
            if ((project = param.get("project")) != null) {
                projectSet.add(project);
            }
            if ((tracknumber = param.get("tracknumber")) != null) {
                tracknumberSet.add(tracknumber);
            }
            if ((configuredcode = param.get("configuredcode")) != null) {
                configuredcodeSet.add(configuredcode);
            }
            if ((lot = param.get("lot")) == null || StringUtils.isEmpty((String)String.valueOf(lot))) continue;
            lotSet.add(lot);
        }
        if (materialSet != null && materialSet.size() > 0) {
            baseFilter.and("material", "in", materialSet);
        }
        if (mversionSet != null && mversionSet.size() > 0) {
            baseFilter.and("mversion", "in", mversionSet);
        }
        if (assistSet != null && assistSet.size() > 0) {
            baseFilter.and("assist", "in", assistSet);
        }
        if (projectSet != null && projectSet.size() > 0) {
            baseFilter.and("project", "in", projectSet);
        }
        if (tracknumberSet != null && tracknumberSet.size() > 0) {
            baseFilter.and("tracknumber", "in", tracknumberSet);
        }
        if (configuredcodeSet != null && configuredcodeSet.size() > 0) {
            baseFilter.and("configuredcode", "in", configuredcodeSet);
        }
        if (lotSet != null && lotSet.size() > 0) {
            baseFilter.and("lot", "in", lotSet);
        }
    }

    public Map<String, Object> updateCost(Long costTypeId, Set<Map<String, Object>> maps) {
        Map<String, Object> updateCostResultMap = new CalCostUpdateHelper(costTypeId, maps).updateCost();
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(16);
        for (Map<String, Object> param : maps) {
            HashMap<String, Object> keyCols = new HashMap<String, Object>(7);
            keyCols.put("material", param.get("materialid"));
            keyCols.put("mversion", param.get("matverisoinid"));
            keyCols.put("assist", param.get("auxpropid"));
            keyCols.put("project", param.get("project"));
            keyCols.put("tracknumber", param.get("tracknumber"));
            keyCols.put("configuredcode", param.get("configuredcode"));
            keyCols.put("lot", param.get("lot"));
            params.add(keyCols);
        }
        Map<String, Object> map = this.getMaterialQty(costTypeId, params);
        if ("0".equals(updateCostResultMap.get("result"))) {
            map.put("result", "0");
            String msg = (String)map.get("msg");
            String updateCostResultMsg = (String)updateCostResultMap.get("msg");
            msg = StringUtils.isEmpty((String)msg) ? updateCostResultMsg : updateCostResultMsg + "\\r\\n" + msg;
            map.put("msg", msg);
        }
        map.put("effectivetime", TimeServiceHelper.now());
        return map;
    }

    public Map<String, String> startSyncBizBill(Long costTypeid, Set<Long> matids) {
        logger.info("----------\u6210\u672c\u4f20\u5165\u53c2\u6570\uff1a\u542f\u52a8\u670d\u52a1" + costTypeid + "\n" + matids);
        return this.modifyStopSyncBizBill(costTypeid, matids, false);
    }

    public Set<Long> checkCaldimensioncols(Long costTypeId, Map<Long, String> matKeycols) {
        String[] caldimensionFieldsStrs;
        logger.info("CalCostUpdateServiceImpl checkCaldimensioncols-\u6210\u672c\u4f20\u5165\u53c2\u6570\uff1a" + costTypeId + "," + matKeycols);
        HashSet<Long> materialSet = new HashSet<Long>(16);
        String caldimensionFieldsStr = CommonSettingHelper.getCalDimensionStr();
        HashSet<String> caldimensionFieldSet = new HashSet<String>(16);
        if (!StringUtils.isEmpty((String)caldimensionFieldsStr) && (caldimensionFieldsStrs = caldimensionFieldsStr.split(",")) != null && caldimensionFieldsStrs.length != 0) {
            for (String caldimensionField : caldimensionFieldsStrs) {
                if (StringUtils.isEmpty((String)caldimensionField)) continue;
                caldimensionFieldSet.add(caldimensionField);
            }
        }
        for (Map.Entry<Long, String> matKeycol : matKeycols.entrySet()) {
            String[] matKeyColStrs;
            Long materialid = matKeycol.getKey();
            String matKeyColStr = matKeycol.getValue();
            if (StringUtils.isEmpty((String)matKeyColStr) || null == (matKeyColStrs = matKeyColStr.split(",")) || matKeyColStrs.length == 0) continue;
            HashSet<String> keyColsset = new HashSet<String>(16);
            for (String matKeyCol : matKeyColStrs) {
                if (StringUtils.isEmpty((String)matKeyCol)) continue;
                keyColsset.add(matKeyCol);
            }
            WriteLogHelper.writeInfoLog((Log)logger, (String)("CalCostUpdateServiceImpl checkCaldimensioncols caldimensionFieldSet:" + caldimensionFieldSet + ",keyColsset:" + keyColsset), (Object[])new Object[0]);
            if (caldimensionFieldSet.containsAll(keyColsset)) continue;
            materialSet.add(materialid);
        }
        return materialSet;
    }
}

