/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cal.business.calculate.billgroup.GroupCompletedHelper;
import kd.fi.cal.mservice.api.CalGroupCompletedService;

public class CalGroupCompletedServiceImpl
implements CalGroupCompletedService {
    private static Log log = LogFactory.getLog(CalGroupCompletedServiceImpl.class);

    public void doService(Long bizEntryId, boolean isCompleted) throws Exception {
        try (TXHandle h1 = TX.requiresNew();){
            try {
                log.info("\u8c03\u62e8\u5b8c\u6210\u63a5\u53e3" + bizEntryId + isCompleted);
                QFilter filter = new QFilter("entry.bizbillentryid", "=", (Object)bizEntryId);
                String selectProperties = "entry.id,entry.bizbillentryid,entry.islastentry,bizbillid,id";
                DynamicObject[] calBillArr = BusinessDataServiceHelper.load((String)"cal_incalbill", (String)selectProperties, (QFilter[])filter.toArray());
                Set calEntryIdSet = GroupCompletedHelper.updateCalBill((Long)bizEntryId, (boolean)isCompleted, (DynamicObject[])calBillArr);
                calBillArr = BusinessDataServiceHelper.load((String)"cal_outcalbill", (String)selectProperties, (QFilter[])filter.toArray());
                calEntryIdSet.addAll(GroupCompletedHelper.updateCalBill((Long)bizEntryId, (boolean)isCompleted, (DynamicObject[])calBillArr));
                if (isCompleted) {
                    GroupCompletedHelper.updateGroupRecord((Set)calEntryIdSet, null);
                } else {
                    GroupCompletedHelper.updateGroupRecord(null, (Set)calEntryIdSet);
                }
            }
            catch (Exception e) {
                h1.markRollback();
                throw e;
            }
        }
    }

    public void batchDoService(Set<Long> trueEntryIds, Set<Long> falseEntryIds) throws Exception {
        try (TXHandle h1 = TX.requiresNew();){
            try {
                DynamicObject[] calBillArr;
                QFilter filter;
                log.info("\u8c03\u62e8\u5b8c\u6210\u63a5\u53e3" + trueEntryIds + falseEntryIds);
                Set trueCalEntryIds = null;
                Set falseCalEntryIds = null;
                String selectProperties = "entry.id,entry.bizbillentryid,entry.islastentry,bizbillid,id";
                if (trueEntryIds != null && !trueEntryIds.isEmpty()) {
                    filter = new QFilter("entry.bizbillentryid", "in", trueEntryIds);
                    calBillArr = BusinessDataServiceHelper.load((String)"cal_incalbill", (String)selectProperties, (QFilter[])filter.toArray());
                    trueCalEntryIds = GroupCompletedHelper.updateCalBill(trueEntryIds, (boolean)true, (DynamicObject[])calBillArr);
                    calBillArr = BusinessDataServiceHelper.load((String)"cal_outcalbill", (String)selectProperties, (QFilter[])filter.toArray());
                    trueCalEntryIds.addAll(GroupCompletedHelper.updateCalBill(trueEntryIds, (boolean)true, (DynamicObject[])calBillArr));
                }
                if (falseEntryIds != null && !falseEntryIds.isEmpty()) {
                    filter = new QFilter("entry.bizbillentryid", "in", falseEntryIds);
                    calBillArr = BusinessDataServiceHelper.load((String)"cal_incalbill", (String)selectProperties, (QFilter[])filter.toArray());
                    falseCalEntryIds = GroupCompletedHelper.updateCalBill(falseEntryIds, (boolean)false, (DynamicObject[])calBillArr);
                    calBillArr = BusinessDataServiceHelper.load((String)"cal_outcalbill", (String)selectProperties, (QFilter[])filter.toArray());
                    falseCalEntryIds.addAll(GroupCompletedHelper.updateCalBill(falseEntryIds, (boolean)false, (DynamicObject[])calBillArr));
                }
                GroupCompletedHelper.updateGroupRecord(trueCalEntryIds, falseCalEntryIds);
            }
            catch (Exception e) {
                h1.markRollback();
                throw e;
            }
        }
    }

    public void doService(Long bizBillId, Long bizEntryId, boolean isCompleted) throws Exception {
        try (TXHandle h1 = TX.requiresNew();){
            try {
                log.info("\u8c03\u62e8\u5b8c\u6210\u63a5\u53e3" + bizBillId + bizEntryId + isCompleted);
                QFilter filter = new QFilter("entry.bizbillentryid", "=", (Object)bizEntryId);
                filter.and("bizbillid", "=", (Object)bizBillId);
                String selectProperties = "entry.id,entry.bizbillentryid,entry.islastentry,bizbillid,id";
                DynamicObject[] calBillArr = BusinessDataServiceHelper.load((String)"cal_incalbill", (String)selectProperties, (QFilter[])filter.toArray());
                Set calEntryIdSet = GroupCompletedHelper.updateCalBill((Long)bizEntryId, (boolean)isCompleted, (DynamicObject[])calBillArr);
                calBillArr = BusinessDataServiceHelper.load((String)"cal_outcalbill", (String)selectProperties, (QFilter[])filter.toArray());
                calEntryIdSet.addAll(GroupCompletedHelper.updateCalBill((Long)bizEntryId, (boolean)isCompleted, (DynamicObject[])calBillArr));
                if (isCompleted) {
                    GroupCompletedHelper.updateGroupRecord((Set)calEntryIdSet, null);
                } else {
                    GroupCompletedHelper.updateGroupRecord(null, (Set)calEntryIdSet);
                }
            }
            catch (Exception e) {
                h1.markRollback();
                throw e;
            }
        }
    }

    public void batchDoService(Set<Long> bizBillIds, Set<Long> trueEntryIds, Set<Long> falseEntryIds) throws Exception {
        try (TXHandle h1 = TX.requiresNew();){
            try {
                DynamicObject[] calBillArr;
                QFilter filter;
                log.info("\u8c03\u62e8\u5b8c\u6210\u63a5\u53e3" + bizBillIds + trueEntryIds + falseEntryIds);
                Set trueCalEntryIds = null;
                Set falseCalEntryIds = null;
                String selectProperties = "entry.id,entry.bizbillentryid,entry.islastentry,bizbillid,id";
                if (trueEntryIds != null && !trueEntryIds.isEmpty()) {
                    filter = new QFilter("entry.bizbillentryid", "in", trueEntryIds);
                    filter.and("bizbillid", "in", bizBillIds);
                    calBillArr = BusinessDataServiceHelper.load((String)"cal_incalbill", (String)selectProperties, (QFilter[])filter.toArray());
                    trueCalEntryIds = GroupCompletedHelper.updateCalBill(trueEntryIds, (boolean)true, (DynamicObject[])calBillArr);
                    calBillArr = BusinessDataServiceHelper.load((String)"cal_outcalbill", (String)selectProperties, (QFilter[])filter.toArray());
                    trueCalEntryIds.addAll(GroupCompletedHelper.updateCalBill(trueEntryIds, (boolean)true, (DynamicObject[])calBillArr));
                }
                if (falseEntryIds != null && !falseEntryIds.isEmpty()) {
                    filter = new QFilter("entry.bizbillentryid", "in", falseEntryIds);
                    filter.and("bizbillid", "in", bizBillIds);
                    calBillArr = BusinessDataServiceHelper.load((String)"cal_incalbill", (String)selectProperties, (QFilter[])filter.toArray());
                    falseCalEntryIds = GroupCompletedHelper.updateCalBill(falseEntryIds, (boolean)false, (DynamicObject[])calBillArr);
                    calBillArr = BusinessDataServiceHelper.load((String)"cal_outcalbill", (String)selectProperties, (QFilter[])filter.toArray());
                    falseCalEntryIds.addAll(GroupCompletedHelper.updateCalBill(falseEntryIds, (boolean)false, (DynamicObject[])calBillArr));
                }
                GroupCompletedHelper.updateGroupRecord(trueCalEntryIds, falseCalEntryIds);
            }
            catch (Exception e) {
                h1.markRollback();
                throw e;
            }
        }
    }
}

