/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cal.business.calculate.in.CalFeeShareStrategy;
import kd.fi.cal.business.service.SyncLockHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.lock.RedisBatchLock;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.mservice.api.CalNewFeeShareService;

public class CalNewFeeShareServiceImpl
implements CalNewFeeShareService {
    private static Log log = LogFactory.getLog(CalNewFeeShareServiceImpl.class);
    private static final String REDIS_KEY = "cal_new_feeshare";

    public void execute(List<DynamicObject> feeShareRecords) {
        try (SyncLockHelper syncLockHelper = new SyncLockHelper(ActionEnum.FEESHARE_NEW.getValue(), feeShareRecords.toArray(new DynamicObject[0]));){
            if (feeShareRecords == null || feeShareRecords.size() == 0) {
                return;
            }
            List mutErrors = syncLockHelper.lock();
            if (!mutErrors.isEmpty()) {
                throw new KDBizException(mutErrors.toString());
            }
            CalFeeShareStrategy calFeeShareStrategy = new CalFeeShareStrategy(feeShareRecords);
            calFeeShareStrategy.execute();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
    }

    public void execute4Ids(Set<Long> feeShareRecordIds) {
        block16: {
            if (feeShareRecordIds == null || feeShareRecordIds.size() == 0) {
                return;
            }
            if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.NEW_FEESHARE_USE_DBLOCK).booleanValue()) {
                try (TXHandle tx = TX.required();){
                    this.excuteFeeShareUseDBLock(feeShareRecordIds);
                    break block16;
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    throw e;
                }
            }
            this.excuteFeeShareUseRedisLock(feeShareRecordIds);
        }
    }

    private void excuteFeeShareUseDBLock(Set<Long> feeShareRecordIds) {
        this.updateFeeShareRecordId(feeShareRecordIds);
        int feesahre_batchsize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.NEW_FEESHARE_BATCHSIZE);
        MainEntityType feeRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_feeshare_newrecord");
        Lists.partition(Arrays.asList(feeShareRecordIds.toArray(new Long[0])), (int)feesahre_batchsize).forEach(ids -> {
            try {
                DynamicObject[] records = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)feeRecordEntityType);
                CalFeeShareStrategy calFeeShareStrategy = new CalFeeShareStrategy(Arrays.asList(records));
                calFeeShareStrategy.execute();
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw e;
            }
        });
    }

    private void updateFeeShareRecordId(Set<Long> feeShareRecordIds) {
        List<Long> ids = Arrays.asList(feeShareRecordIds.toArray(new Long[0]));
        ids.sort(Comparator.naturalOrder());
        ArrayList<Object[]> params = new ArrayList<Object[]>(4);
        for (Long id : ids) {
            params.add(new Object[]{id});
        }
        Lists.partition(params, (int)500).forEach(subParams -> DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"update t_cal_feerecord set fid = fid where fid = ?", (List)subParams));
    }

    private void excuteFeeShareUseRedisLock(Set<Long> feeShareRecordIds) {
        int expire_time = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.NEW_FEESHARE_REDISLOCK_EXPIRETIME);
        int feesahre_batchsize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.NEW_FEESHARE_BATCHSIZE);
        log.info("\u65b0\u8d39\u7528\u5206\u644a\u5171" + feeShareRecordIds.size() + "/" + feesahre_batchsize + "=" + (feeShareRecordIds.size() / feesahre_batchsize + 1) + "\u6279");
        try (RedisBatchLock batchLock = new RedisBatchLock(REDIS_KEY, expire_time, REDIS_KEY);){
            DynamicObject[] records = BusinessDataServiceHelper.load((Object[])feeShareRecordIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_feeshare_newrecord"));
            HashSet<String> costRecordEIds = new HashSet<String>(16);
            for (DynamicObject record : records) {
                DynamicObjectCollection entry = record.getDynamicObjectCollection("entry");
                for (DynamicObject entryRow : entry) {
                    boolean isMainBill = entryRow.getBoolean("ismianbill");
                    if (isMainBill) continue;
                    costRecordEIds.add(entryRow.getString("billentryid"));
                }
            }
            batchLock.setLockKeys(costRecordEIds);
            Map lockFailIdMsgMap = new HashMap(4);
            for (int i = 1; i <= 8; ++i) {
                lockFailIdMsgMap.clear();
                batchLock.lock();
                lockFailIdMsgMap = batchLock.getLockFailIdMsgMap();
                if (lockFailIdMsgMap.isEmpty()) break;
                if (i <= 7) {
                    try {
                        Thread.sleep(i * 5000);
                    }
                    catch (InterruptedException interruptedException) {
                        WriteLogHelper.writeErrorLog((Log)log, (String)"CalNewFeeShareServiceImpl-execute4Ids", (Throwable)interruptedException);
                    }
                }
                batchLock.unlock();
            }
            if (lockFailIdMsgMap != null && !lockFailIdMsgMap.isEmpty()) {
                String erroMsg = ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u8d39\u7528\u5206\u644a\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"CalNewFeeShareServiceImpl_0", (String)"fi-cal-mservice", (Object[])new Object[0]);
                throw new KDBizException(erroMsg);
            }
            Lists.partition(Arrays.asList(records), (int)feesahre_batchsize).forEach(list -> {
                try {
                    CalFeeShareStrategy calFeeShareStrategy = new CalFeeShareStrategy(list);
                    calFeeShareStrategy.execute();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    throw e;
                }
            });
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
    }
}

