/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.AlarmLevel;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.DataCheckTask;
import kd.fi.cal.business.datacheck.DataCheckTaskEntry;
import kd.fi.cal.business.datacheck.DataCheckTaskExecutor;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.mservice.api.CalOutDataCheckService;

public class CalOutDataCheckServiceImpl
implements CalOutDataCheckService {
    private static final String MATSETKEY = "materialSetListMap";
    private static final String CALORGKEY = "calOrgIdMap";
    private static final String CALRANGEKEY = "calRangeIdMap";
    private static final String COSTACCOUNTKEY = "costAccountIdMap";
    private static final String STARTDATEKEY = "startDateMap";
    private static final String ENDDATEKEY = "endDateMap";
    private static final String PERIODKEY = "periodMap";
    private static final String PERIODIDKEY = "periodIdMap";
    private static final String ISALLMATKEY = "isAllMaterialMap";
    private static final String ISNEEDCALLATERKEY = "isNeedCalculatedLaterMap";
    private static final String VOUCHERdWEIGHTDVAGATS = "voucherdutweightedavgat";

    public void doCalOutDataCheck(Map<String, Map<Integer, Object>> calOutRangeMap, Map<Long, String> checkItems, String taskId, Long checkTaskId) {
        Map<Integer, Object> matSetListMap = calOutRangeMap.get(MATSETKEY);
        Map<Integer, Object> calOrgIdMap = calOutRangeMap.get(CALORGKEY);
        Map<Integer, Object> calRangeIdMap = calOutRangeMap.get(CALRANGEKEY);
        Map<Integer, Object> costAccountIdMap = calOutRangeMap.get(COSTACCOUNTKEY);
        Map<Integer, Object> startDateMap = calOutRangeMap.get(STARTDATEKEY);
        Map<Integer, Object> endDateMap = calOutRangeMap.get(ENDDATEKEY);
        Map<Integer, Object> periodMap = calOutRangeMap.get(PERIODKEY);
        Map<Integer, Object> periodIdMap = calOutRangeMap.get(PERIODIDKEY);
        Map<Integer, Object> isAllMaterialMap = calOutRangeMap.get(ISALLMATKEY);
        Map<Integer, Object> isNeedCalLaterMap = calOutRangeMap.get(ISNEEDCALLATERKEY);
        Map<Integer, Object> voucherdutMap = calOutRangeMap.get(VOUCHERdWEIGHTDVAGATS);
        ArrayList<DataCheckParam> checkParamList = new ArrayList<DataCheckParam>(matSetListMap.size());
        HashSet<Long> allCalOrgSet = new HashSet<Long>(16);
        HashSet<Long> allCostAccountSet = new HashSet<Long>(16);
        for (int i = 0; i < matSetListMap.size(); ++i) {
            HashSet<Long> materialSet = new HashSet<Long>(16);
            List matSetList = (List)matSetListMap.get(i);
            if (matSetList != null && !matSetList.isEmpty()) {
                Iterator iterator = matSetList.iterator();
                while (iterator.hasNext()) {
                    Set matSet = (Set)iterator.next();
                    for (Object mat : matSet) {
                        materialSet.add(Long.valueOf(mat.toString()));
                    }
                }
            }
            HashSet<Long> iterator = new HashSet<Long>(16);
            iterator.add((Long)calOrgIdMap.get(i));
            HashSet<Long> costAccountSet = new HashSet<Long>(16);
            costAccountSet.add((Long)costAccountIdMap.get(i));
            DataCheckParam checkParam = new DataCheckParam();
            checkParam.setMaterial(materialSet);
            checkParam.setCalorg(iterator);
            checkParam.setCalRangeId((Long)calRangeIdMap.get(i));
            checkParam.setCostAccount(costAccountSet);
            checkParam.setPeriod((Integer)periodMap.get(i));
            checkParam.setPeriodId((Long)periodIdMap.get(i));
            checkParam.setAllMaterial(((Boolean)isAllMaterialMap.get(i)).booleanValue());
            checkParam.setNeedCalculatedLater(((Boolean)isNeedCalLaterMap.get(i)).booleanValue());
            checkParam.setStartDate((Date)startDateMap.get(i));
            checkParam.setEndDate((Date)endDateMap.get(i));
            checkParam.setVoucherDutWeighteDavgat(((Boolean)voucherdutMap.get(i)).booleanValue());
            checkParam.setMsgStatus(",A,B,C");
            HashSet<Long> msgReceivers = new HashSet<Long>(16);
            msgReceivers.add(Long.valueOf(RequestContext.get().getUserId()));
            checkParam.setMsgReceiver(msgReceivers);
            allCalOrgSet.add((Long)calOrgIdMap.get(i));
            allCostAccountSet.add((Long)costAccountIdMap.get(i));
            checkParamList.add(checkParam);
        }
        DataCheckTask task = new DataCheckTask();
        Map checkItemMap = BusinessDataServiceHelper.loadFromCache((String)"cal_datacheck_item", (String)"plugin,tips", (QFilter[])new QFilter("id", "in", checkItems.keySet()).toArray());
        for (Map.Entry entry : checkItemMap.entrySet()) {
            DynamicObject checkItem = (DynamicObject)entry.getValue();
            Long checkItemId = (Long)entry.getKey();
            task.addDataCheckTaskEntry(new DataCheckTaskEntry(checkItemId, checkItem.getString("plugin"), checkItem.getString("tips"), AlarmLevel.getByValue((String)checkItems.get(checkItemId))));
        }
        DataSet calorgSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_org", (String)"id,name", (QFilter[])new QFilter("id", "in", allCalOrgSet).toArray(), null);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter("id", "in", allCostAccountSet).toArray(), null);
        String calOrgNames = this.getNamesString(calorgSet);
        String costAccountNames = this.getNamesString(dataSet);
        task.setPlanId(Long.valueOf(taskId));
        task.setPlanType("cal_task");
        task.setTaskId(checkTaskId);
        task.setCalorg(calOrgNames);
        task.setCostaccount(costAccountNames);
        task.setPurpose("D");
        DataCheckTaskExecutor executor = new DataCheckTaskExecutor();
        executor.commitSync(task, checkParamList);
    }

    private String getNamesString(DataSet dataSet) {
        StringBuilder names = new StringBuilder();
        for (Row row : dataSet) {
            names.append(row.getString("name"));
            names.append(',');
        }
        String nameString = CommonUtils.trimComma((String)names.toString());
        if (nameString.length() > 254) {
            nameString = nameString.substring(0, 254);
            return CommonUtils.trimComma((String)nameString);
        }
        return nameString;
    }
}

