/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.cal.business.calculate.out.CalIntimeBufferPoolHelper;
import kd.fi.cal.mservice.CalStandardCostDiffBillServiceHelper;
import kd.fi.cal.mservice.CostAdjustBillServiceHelper;
import kd.fi.cal.mservice.api.CalStandardCostDiffBillService;

public class CalStandardCostDiffBillServiceImpl
implements CalStandardCostDiffBillService {
    private static final String[] DIFFALLOC_CREATETYPE = new String[]{"G", "H", "K", "M", "P", "Q", "R", "S", "T", "C"};
    private static final Log logger = LogFactory.getLog(CalStandardCostDiffBillServiceImpl.class);

    public Map<String, Map<String, Object>> buildDiffBill(Set<Map<String, Object>> params) throws KDBizException {
        return new CalStandardCostDiffBillServiceHelper().buildDiffBill(params);
    }

    public Map<String, Map<String, Object>> buildCostAdjustBill(Set<Map<String, Object>> params) throws KDBizException {
        return new CostAdjustBillServiceHelper().buildCostAdjustBill(params);
    }

    public Map<String, Object> deleteDiffBill(Map<String, Object> commonParam, Set<Long> matIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String periodId = (String)commonParam.get("periodId");
        long period = periodId == null ? 0L : Long.parseLong(periodId);
        String costAccountId = (String)commonParam.get("costaccountId");
        long costAccount = costAccountId == null ? 0L : Long.parseLong(costAccountId);
        QFilter filter = new QFilter("period.id", "=", (Object)period);
        filter.and("costaccount.id", "=", (Object)costAccount);
        filter.and("biztype", "=", (Object)"A");
        filter.and("billsrctype", "=", (Object)"D");
        if (matIds != null && matIds.size() > 0) {
            filter.and("entryentity.material.id", "in", matIds);
        } else {
            filter.and("entryentity.material.id", "=", (Object)0L);
        }
        QFilter deleteFilter = new QFilter("billstatus", "!=", (Object)"C");
        DeleteServiceHelper.delete((String)"cal_stdcostdiffbill", (QFilter[])new QFilter[]{filter, deleteFilter});
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)"C");
        HashSet<Long> auditBillids = new HashSet<Long>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stdcostdiffbill", (String)"id", (QFilter[])new QFilter[]{filter, auditFilter}, null);){
            for (Row row : ds) {
                auditBillids.add(row.getLong("id"));
            }
        }
        logger.info("--------------DiffAllocHelper.deleteAllocResult OUT->delete all adjBillsList size:" + auditBillids.size());
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignoreValidation", "true");
        option.setVariableValue("diffAlloc", "true");
        Lists.partition(new ArrayList(auditBillids), (int)5000).forEach(list -> {
            long beginTime = System.currentTimeMillis();
            OperationResult operResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_stdcostdiffbill", (Object[])list.toArray(), (OperateOption)option);
            List idList = operResult.getSuccessPkIds();
            if (operResult.isSuccess()) {
                Set deleteIds = new HashSet<Long>(16);
                for (Object id : idList) {
                    deleteIds.add((Long)id);
                }
                if (!(deleteIds = CalIntimeBufferPoolHelper.removeBufferPoolRevBill((String)"cal_stdcostdiffbill", deleteIds)).isEmpty()) {
                    QFilter deleFilter = new QFilter("id", "in", deleteIds);
                    DeleteServiceHelper.delete((String)"cal_stdcostdiffbill", (QFilter[])deleFilter.toArray());
                }
            } else if (operResult.getAllErrorOrValidateInfo() != null && operResult.getAllErrorOrValidateInfo().size() > 0) {
                ArrayList<String> errors = new ArrayList<String>(operResult.getAllErrorOrValidateInfo().size());
                for (IOperateInfo operatorInfo : operResult.getAllErrorOrValidateInfo()) {
                    errors.add(operatorInfo.getMessage());
                    result.put(operatorInfo.getPkValue().toString(), operatorInfo.getMessage());
                    logger.error("--------------DiffAllocHelper.deleteAllocResult OUT->delete lot adjBillList size:" + errors);
                }
            }
            long endTime = System.currentTimeMillis();
            logger.info("--------------DiffAllocHelper.deleteAllocResult OUT->delete lot adjBillList size:" + list.size());
            logger.info("--------------DiffAllocHelper.deleteAllocResult OUT->delete lot adjBillList time:" + (endTime - beginTime));
        });
        return result;
    }

    public Map<String, Object> deleteCostAdjustBill(Map<String, Object> commonParam, Set<Long> matIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String periodId = (String)commonParam.get("periodId");
        long period = periodId == null ? 0L : Long.parseLong(periodId);
        String costAccountId = (String)commonParam.get("costaccountId");
        long costAccount = costAccountId == null ? 0L : Long.parseLong(costAccountId);
        QFilter filter = new QFilter("period.id", "=", (Object)period);
        filter.and("costaccount.id", "=", (Object)costAccount);
        filter.and("biztype", "=", (Object)"A");
        filter.and("billsrctype", "=", (Object)"D");
        filter.and("difftype", "in", (Object)DIFFALLOC_CREATETYPE);
        if (matIds != null && matIds.size() > 0) {
            filter.and("entryentity.material.id", "in", matIds);
        } else {
            filter.and("entryentity.material.id", "=", (Object)0L);
        }
        QFilter deleteFilter = new QFilter("billstatus", "!=", (Object)"C");
        DeleteServiceHelper.delete((String)"cal_costadjust_subentity", (QFilter[])new QFilter[]{filter, deleteFilter});
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)"C");
        HashSet<Long> auditBillids = new HashSet<Long>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_subentity", (String)"id", (QFilter[])new QFilter[]{filter, auditFilter}, null);){
            for (Row row : ds) {
                auditBillids.add(row.getLong("id"));
            }
        }
        logger.info("--------------DiffAllocHelper.deleteAllocResult OUT->delete all adjBillsList size:" + auditBillids.size());
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("diffAlloc", "true");
        Lists.partition(new ArrayList(auditBillids), (int)5000).forEach(list -> {
            long beginTime = System.currentTimeMillis();
            OperationResult operResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costadjust_subentity", (Object[])list.toArray(), (OperateOption)option);
            List idList = operResult.getSuccessPkIds();
            if (operResult.isSuccess()) {
                Set deleteIds = new HashSet<Long>(16);
                for (Object id : idList) {
                    deleteIds.add((Long)id);
                }
                if (!(deleteIds = CalIntimeBufferPoolHelper.removeBufferPoolRevBill((String)"cal_costadjust_subentity", deleteIds)).isEmpty()) {
                    QFilter deleFilter = new QFilter("id", "in", deleteIds);
                    DeleteServiceHelper.delete((String)"cal_costadjust_subentity", (QFilter[])deleFilter.toArray());
                }
            } else if (operResult.getAllErrorOrValidateInfo() != null && operResult.getAllErrorOrValidateInfo().size() > 0) {
                ArrayList<String> errors = new ArrayList<String>(operResult.getAllErrorOrValidateInfo().size());
                for (IOperateInfo operatorInfo : operResult.getAllErrorOrValidateInfo()) {
                    errors.add(operatorInfo.getMessage());
                    result.put(operatorInfo.getPkValue().toString(), operatorInfo.getMessage());
                    logger.error("--------------DiffAllocHelper.deleteAllocResult OUT->delete lot adjBillList size:" + errors);
                }
            }
            long endTime = System.currentTimeMillis();
            logger.info("--------------DiffAllocHelper.deleteAllocResult OUT->delete lot adjBillList size:" + list.size());
            logger.info("--------------DiffAllocHelper.deleteAllocResult OUT->delete lot adjBillList time:" + (endTime - beginTime));
        });
        return result;
    }
}

