/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.account.ReconciliationParam;
import kd.fi.cal.common.helper.BalanceDistinctValidatorHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.mservice.api.CalSystemCtrlBizService;

public class CalSystemCtrlBizServiceImpl
implements CalSystemCtrlBizService {
    private static final String ISSUCESS = "isSuccess";
    private static final String MESSAGE = "message";
    private static final String STACKTRACE = "stackTrace";
    private static final String ENTRY = "entry";
    private static final String ISENABLED = "isenabled";
    private static final String CURRENTPERIOD = "currentperiod";
    private static final String STARTPERIOD = "startperiod";
    private static final String COSTACCOUNT = "costaccount";
    private static final String ID = "id";
    private static final String DATA = "data";
    private static final String CHECKTYPE = "checkType";
    private static final String ISPASS = "isPass";
    private DynamicObject billData = null;
    private DynamicObjectCollection billDataEntry = null;
    private static final Log LOGGER = LogFactory.getLog(CalSystemCtrlBizServiceImpl.class);
    private List<String> costAccount = new ArrayList<String>(8);

    public String doUnInitBiz(String jsonData) {
        return this.doBizService(jsonData, false);
    }

    public String doInitBiz(String jsonData) {
        return this.doBizService(jsonData, true);
    }

    public String doCheckCost(String jsonData) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>(16);
        List billList = (List)SerializationUtils.fromJsonString((String)jsonData, ArrayList.class);
        for (Map item : billList) {
            JSONObject mainObj = (JSONObject)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)item), JSONObject.class);
            String id = mainObj.getString(ID);
            this.getData(Long.parseLong(id));
            result.add(CalSystemCtrlBizServiceImpl.getSuccess(this.checkBizCost(mainObj), id));
        }
        return SerializationUtils.toJsonString(result);
    }

    private String doBizService(String jsonData, Boolean isInit) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>(16);
        List billList = (List)SerializationUtils.fromJsonString((String)jsonData, ArrayList.class);
        for (Map item : billList) {
            this.costAccount = new ArrayList<String>(8);
            String id = "";
            JSONObject mainObj = null;
            String orgName = "";
            try {
                mainObj = (JSONObject)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)item), JSONObject.class);
                id = String.valueOf(mainObj.get((Object)ID));
                this.getData(Long.parseLong(id));
                orgName = this.billData.getString("org.name");
                if (Boolean.TRUE.equals(isInit)) {
                    this.distinctValidator(mainObj);
                }
                this.initBizValidator(mainObj, isInit);
            }
            catch (KDBizException kex) {
                LOGGER.info("CalSystemCtrlBizServiceImpl doBizService : ", (Object)kex);
                result.add(CalSystemCtrlBizServiceImpl.getFail(kex.getMessage(), this.costAccount, orgName));
                continue;
            }
            catch (Exception ex) {
                LOGGER.error("CalSystemCtrlBizServiceImpl doBizService : ", (Throwable)ex);
                result.add(CalSystemCtrlBizServiceImpl.getError(ex, this.costAccount, orgName));
                continue;
            }
            this.doInitBizOperate(mainObj, isInit);
            result.add(CalSystemCtrlBizServiceImpl.getSuccess(this.costAccount, orgName));
        }
        return SerializationUtils.toJsonString(result);
    }

    private void distinctValidator(JSONObject mainObj) {
        List entry = (List)mainObj.get((Object)ENTRY);
        int indexLen = entry.size();
        HashSet<Long> costAccountIds = new HashSet<Long>(indexLen);
        HashMap<Long, Long> costAcc2Period = new HashMap<Long, Long>(indexLen);
        String orgName = this.billData.getString("org.name");
        for (DynamicObject item : this.billDataEntry) {
            String billEntryId = item.getString(ID);
            if (!entry.contains(billEntryId)) continue;
            Long l = item.getLong("costaccount.id");
            Boolean isenabled = item.getBoolean(ISENABLED);
            Long periodid = item.getLong("startperiod.id");
            if (!Boolean.FALSE.equals(isenabled)) continue;
            costAccountIds.add(l);
            costAcc2Period.put(l, periodid);
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"B");
        QFilter cosAccPeriodFilter = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
        for (Map.Entry entry2 : costAcc2Period.entrySet()) {
            QFilter filter = new QFilter(COSTACCOUNT, "=", entry2.getKey());
            filter.and("period", "=", entry2.getValue());
            cosAccPeriodFilter.or(filter);
        }
        DynamicObjectCollection initCalColl = QueryServiceHelper.query((String)"cal_initbill", (String)"id,costaccount.name,period", (QFilter[])new QFilter[]{statusFilter, cosAccPeriodFilter});
        HashSet<String> hashSet = new HashSet<String>();
        for (Object initCal : initCalColl) {
            hashSet.add(initCal.getString("costaccount.name"));
        }
        if (!hashSet.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String costAccName : hashSet) {
                sb.append(costAccName).append(",");
            }
            String costAcc = sb.toString();
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u5728\u542f\u7528\u671f\u95f4\u5185\u8fd8\u5b58\u5728\u5df2\u63d0\u4ea4\u72b6\u6001\u7684\u521d\u59cb\u6838\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlBizServiceImpl_4", (String)"fi-cal-mservice", (Object[])new Object[0]), orgName, costAcc.substring(0, costAcc.length() - 1));
            throw new KDBizException(msg);
        }
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (!costAccountIds.isEmpty() && !isNewBalance) {
            BalanceDistinctValidatorHelper helper = new BalanceDistinctValidatorHelper(costAccountIds);
            helper.mergeDuplicateDimensions();
            helper.distinctValidator();
        }
    }

    private void doInitBizOperate(JSONObject mainObj, Boolean isInit) {
        String id = mainObj.getString(ID);
        List entry = (List)mainObj.get((Object)ENTRY);
        DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cal_sysctrlentity", (String)"entry.isenabled,entry.startperiod,entry.currentperiod,entry.costaccount");
        DynamicObjectCollection dataEntry = data.getDynamicObjectCollection(ENTRY);
        for (DynamicObject item : dataEntry) {
            String billEntryId = item.getString(ID);
            if (!entry.contains(billEntryId)) continue;
            this.costAccount.add(item.getString("costaccount.name"));
            if (Boolean.TRUE.equals(isInit)) {
                Long startperiod = item.getLong("startperiod.id");
                item.set(CURRENTPERIOD, (Object)startperiod);
                item.set(STARTPERIOD, (Object)startperiod);
            } else {
                item.set(CURRENTPERIOD, null);
            }
            item.set(ISENABLED, (Object)isInit);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
    }

    private void initBizValidator(JSONObject mainObj, Boolean isInit) {
        List entry = (List)mainObj.get((Object)ENTRY);
        String orgName = this.billData.getString("org.name");
        for (DynamicObject item : this.billDataEntry) {
            String errorMsg;
            String billEntryId = item.getString(ID);
            if (!entry.contains(billEntryId)) continue;
            String costAccountName = item.getString("costaccount.name");
            Boolean isenabled = item.getBoolean(ISENABLED);
            if (isInit.booleanValue()) {
                if (!isenabled.booleanValue()) continue;
                errorMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u8bb0\u5f55\u5df2\u7ecf\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlBizServiceImpl_5", (String)"fi-cal-mservice", (Object[])new Object[0]), orgName, costAccountName);
                throw new KDBizException(errorMsg);
            }
            if (Boolean.FALSE.equals(isenabled)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u8bb0\u5f55\u672a\u542f\u7528,\u4e0d\u5141\u8bb8\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlBizServiceImpl_6", (String)"fi-cal-mservice", (Object[])new Object[0]), orgName, costAccountName);
                throw new KDBizException(errorMsg);
            }
            Long startperiod = item.getLong("startperiod.id");
            Long currentperiod = item.getLong("currentperiod.id");
            if (currentperiod == 0L || startperiod.equals(currentperiod)) continue;
            String errorMsg2 = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u8bb0\u5f55\u5f53\u524d\u671f\u95f4\u4e0d\u662f\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CalSystemCtrlBizServiceImpl_7", (String)"fi-cal-mservice", (Object[])new Object[0]), orgName, costAccountName);
            throw new KDBizException(errorMsg2);
        }
    }

    private void getData(Long id) {
        this.billData = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cal_sysctrlentity", (String)"org,entry.seq,entry.isenabled,entry.startperiod,entry.currentperiod,entry.costaccount");
        this.billDataEntry = this.billData.getDynamicObjectCollection(ENTRY);
    }

    private Map<String, Map<String, Object>> checkBizCost(JSONObject mainObj) {
        HashMap<String, Map<String, Object>> checkResult = new HashMap<String, Map<String, Object>>(16);
        List entry = (List)mainObj.get((Object)ENTRY);
        Long orgid = this.billData.getLong("org.id");
        String orgNumber = this.billData.getString("org.number");
        String orgName = this.billData.getString("org.name");
        for (DynamicObject item : this.billDataEntry) {
            String billEntryId = item.getString(ID);
            if (!entry.contains(billEntryId)) continue;
            HashMap<String, Object> rowResult = new HashMap<String, Object>();
            Long costaccountid = item.getLong("costaccount.id");
            String costaccountName = item.getString("costaccount.name");
            Long periodid = item.getLong("startperiod.id");
            rowResult.put("orgName", orgName);
            rowResult.put("orgNumber", orgNumber);
            rowResult.put(ID, billEntryId);
            rowResult.put(COSTACCOUNT, costaccountName);
            ReconciliationParam param = new ReconciliationParam();
            param.setPeriodId(periodid);
            param.setAppNumber("cal");
            param.setBizBookId(costaccountid);
            param.setOrgId(orgid);
            param.setInit(true);
            QFilter filter = new QFilter("entry.costaccount", "=", (Object)costaccountid);
            DynamicObject dy = QueryServiceHelper.queryOne((String)"cal_accountparamssetting", (String)"entry.endinitcheck", (QFilter[])new QFilter[]{filter});
            if (dy == null) {
                rowResult.put(CHECKTYPE, "N");
                rowResult.put(ISPASS, false);
                checkResult.put(billEntryId, rowResult);
                continue;
            }
            String checkType = dy.getString("entry.endinitcheck");
            rowResult.put(CHECKTYPE, checkType);
            try {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"ReconciliationService", (String)"execute", (Object[])new Object[]{SerializationUtils.toJsonString((Object)param)});
                rowResult.put(ISPASS, true);
            }
            catch (KDBizException e) {
                ErrorCode ec = e.getErrorCode();
                String code = ec.getCode();
                if ("2".equals(code)) {
                    rowResult.put(ISPASS, false);
                }
                rowResult.put(ISPASS, true);
            }
            checkResult.put(billEntryId, rowResult);
        }
        return checkResult;
    }

    private static JSONObject getFail(String message, Object data, String id) {
        JSONObject obj = new JSONObject();
        obj.put(ISSUCESS, (Object)false);
        obj.put(MESSAGE, (Object)message);
        obj.put(DATA, data);
        obj.put(STACKTRACE, null);
        obj.put(ID, (Object)id);
        return obj;
    }

    private static JSONObject getError(Exception ex, Object data, String id) {
        JSONObject obj = new JSONObject();
        obj.put(ISSUCESS, (Object)false);
        obj.put(MESSAGE, (Object)ex.getMessage());
        obj.put(DATA, data);
        obj.put(STACKTRACE, (Object)ex.getStackTrace());
        obj.put(ID, (Object)id);
        return obj;
    }

    private static JSONObject getSuccess(Object data, String id) {
        JSONObject obj = new JSONObject();
        obj.put(ISSUCESS, (Object)true);
        obj.put(MESSAGE, null);
        obj.put(DATA, data);
        obj.put(STACKTRACE, null);
        obj.put(ID, (Object)id);
        return obj;
    }
}

