/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.mservice.api.CalWriteOffParentCostService;

public class CalWriteOffParentCostServiceImpl
implements CalWriteOffParentCostService {
    private static final Log logger = LogFactory.getLog(CalWriteOffParentCostServiceImpl.class);

    public Map<Long, Map<String, BigDecimal>> getParentCost(Map<Long, Set<Long>> parentAndChildRecordIdMap) {
        logger.info("CalWriteOffParentCostServiceImpl-\u5f00\u59cb\u83b7\u53d6\u6210\u672c");
        if (parentAndChildRecordIdMap.isEmpty()) {
            return null;
        }
        HashSet childRecordIdSet = new HashSet(16);
        for (Map.Entry<Long, Set<Long>> entry : parentAndChildRecordIdMap.entrySet()) {
            if (entry.getValue() == null) continue;
            childRecordIdSet.addAll(entry.getValue());
        }
        if (childRecordIdSet.isEmpty()) {
            logger.info("CalWriteOffParentCostServiceImpl-\u6ca1\u6709\u5b50\u9879\u6838\u9500\u8bb0\u5f55id");
            return null;
        }
        QFilter recordQ = new QFilter("entry.writeoffid", "in", childRecordIdSet);
        recordQ.and("issplitcreate", "=", (Object)Boolean.TRUE);
        recordQ.and("costaccount.ismainaccount", "=", (Object)Boolean.TRUE);
        DataSet costDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)"entry.writeoffid as writeoffid,entry.unitactualcost as unitactualcost,entry.actualcost as actualcost", (QFilter[])recordQ.toArray(), null);
        HashMap<Long, BigDecimal> unitCostMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> actualCostMap = new HashMap<Long, BigDecimal>(16);
        for (Row row : costDs) {
            Long writeoffId = row.getLong("writeoffid");
            unitCostMap.put(writeoffId, row.getBigDecimal("unitactualcost"));
            actualCostMap.put(writeoffId, row.getBigDecimal("actualcost"));
        }
        HashMap<Long, Map<String, BigDecimal>> parentCostMap = new HashMap<Long, Map<String, BigDecimal>>(16);
        for (Map.Entry<Long, Set<Long>> entry : parentAndChildRecordIdMap.entrySet()) {
            HashMap<String, BigDecimal> costMap = new HashMap<String, BigDecimal>(16);
            costMap.put("baseUnitActualCost", BigDecimal.ZERO);
            costMap.put("actualCost", BigDecimal.ZERO);
            Long parentId = entry.getKey();
            Set<Long> childIdSet = entry.getValue();
            if (childIdSet == null || childIdSet.isEmpty()) {
                parentCostMap.put(parentId, costMap);
                continue;
            }
            for (Long childId : childIdSet) {
                BigDecimal unitCost = (BigDecimal)unitCostMap.get(childId);
                BigDecimal actualCost = (BigDecimal)actualCostMap.get(childId);
                if (unitCost != null) {
                    costMap.put("baseUnitActualCost", ((BigDecimal)costMap.get("baseUnitActualCost")).add(unitCost));
                }
                if (actualCost == null) continue;
                costMap.put("actualCost", ((BigDecimal)costMap.get("actualCost")).add(actualCost));
            }
            parentCostMap.put(parentId, costMap);
        }
        return parentCostMap;
    }
}

