/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.gl.autoclose.CloseContext;
import kd.bos.ext.fi.gl.autoclose.CloseResult;
import kd.bos.ext.fi.gl.autoclose.ICloseService;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.account.CloseAccountFacade;
import kd.fi.cal.business.account.SettleAccountFacade;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.CloseAccountParam;
import kd.fi.cal.common.model.SimpleSettleAccountParam;

public class CloseServiceImpl
implements ICloseService {
    private String DLOCK_KEY = "settleaccount_cal";
    private static final Log LOGGER = LogFactory.getLog(CloseServiceImpl.class);
    private static final Long CLOSETASK_ID = 1255063777360084992L;
    private static final Long SETTLETASK_ID = 1266490172376219648L;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CloseResult closePeriod(CloseContext closeContext) {
        FormShowParameter errorFormShowParameter;
        HashSet<String> errorMsg;
        CloseResult result;
        block54: {
            HashMap<Long, DynamicObject> orgIdAndDynamic;
            HashMap<Long, DynamicObject> costAccountAndDynamic;
            HashMap<Long, DynamicObject> costAccountAndCurrentPeriod;
            HashMap<DynamicObjectCollection, HashMap<Long, String>> allCheckItemMap;
            DynamicObject closePeriodDynamic;
            Long bookTypeID;
            Long orgID = closeContext.getOrgID();
            CloseContext.CloseType closeType = closeContext.getCloseType();
            result = new CloseResult();
            errorMsg = new HashSet<String>();
            errorFormShowParameter = null;
            String bookTypeName = null;
            switch (closeType) {
                case ACCOUNT_CLOSE: {
                    Long closePeriodID = closeContext.getClosePeriodID();
                    bookTypeID = closeContext.getBookTypeID();
                    if (closePeriodID == null || closePeriodID == 0L) {
                        errorMsg.add("closePeriodId : null");
                        result.setSuccess(Boolean.FALSE.booleanValue());
                        result.setErrorMessages(new ArrayList(errorMsg));
                        return result;
                    }
                    if (bookTypeID == null) {
                        errorMsg.add("bookTypeId : null");
                        result.setSuccess(Boolean.FALSE.booleanValue());
                        result.setErrorMessages(new ArrayList(errorMsg));
                        return result;
                    }
                    LOGGER.info("CloseServiceImpl\u7ed3\u8d26\u671f\u95f4id : " + closePeriodID + " \u8d26\u7c3f\u7c7b\u522bid : " + bookTypeID + " \u7ec4\u7ec7id : " + orgID);
                    if (!this.doValidate(orgID)) {
                        errorMsg.add(ResManager.loadKDString((String)"\u65e0\u201c\u671f\u672b\u7ed3\u8d26\u201d\u7684\u201c\u7ed3\u8d26\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SettleAccountPlugin_22", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                    }
                    if (errorMsg.isEmpty()) {
                        long costAccountId;
                        DynamicObjectCollection entrys;
                        closePeriodDynamic = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,number,periodyear,periodnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)closePeriodID)});
                        DynamicObjectCollection checkItems = QueryServiceHelper.query((String)"cal_datacheck_task", (String)"purpose,entryentity.checkitem,entryentity.entryenable,entryentity.level", (QFilter[])new QFilter("id", "in", (Object)new Long[]{1255063777360084992L, 1266490172376219648L}).toArray(), (String)"purpose asc,entryentity.checkitem.number asc");
                        allCheckItemMap = new HashMap<DynamicObjectCollection, HashMap<Long, String>>(16);
                        if (checkItems != null && !checkItems.isEmpty()) {
                            for (DynamicObject checkItem : checkItems) {
                                Long checkItemId;
                                Boolean ischeck = checkItem.getBoolean("entryentity.entryenable");
                                if (!ischeck.booleanValue() || (checkItemId = Long.valueOf(checkItem.getLong("entryentity.checkitem"))) == null) continue;
                                Long itemId = checkItemId;
                                String string = checkItem.getString("entryentity.level");
                                DynamicObjectCollection purpose = checkItem.getString("purpose");
                                HashMap<Long, String> checkItemMap = (HashMap<Long, String>)allCheckItemMap.get(purpose);
                                if (checkItemMap == null) {
                                    checkItemMap = new HashMap<Long, String>(16);
                                }
                                checkItemMap.put(itemId, string);
                                allCheckItemMap.put(purpose, checkItemMap);
                            }
                        }
                        costAccountAndCurrentPeriod = new HashMap<Long, DynamicObject>();
                        costAccountAndDynamic = new HashMap<Long, DynamicObject>();
                        orgIdAndDynamic = new HashMap<Long, DynamicObject>();
                        DynamicObjectCollection costAccountSettings = BusinessDataServiceHelper.load((String)"cal_sysctrlentity", (String)"org,entry.costaccount,entry.startperiod,entry.currentperiod", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgID), new QFilter("entry.currentperiod", "!=", null)}, null);
                        if (costAccountSettings == null || ((DynamicObject[])costAccountSettings).length == 0) {
                            String s = ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u542f\u7528\u4e2d\u7684\u6210\u672c\u8d26\u7c3f\uff0c\u6216\u6210\u672c\u8d26\u7c3f\u672a\u521d\u59cb\u5316\u3002", (String)"CloseServiceImpl_1", (String)"fi-cal-mservice", (Object[])new Object[0]);
                            errorMsg.add(s);
                        }
                        if (costAccountSettings == null || ((DynamicObject[])costAccountSettings).length == 0) break;
                        DynamicObject orgDynamic = costAccountSettings[0].getDynamicObject("org");
                        orgIdAndDynamic.put(orgID, orgDynamic);
                        HashSet<Long> hashSet = new HashSet<Long>();
                        for (DynamicObject costAccountSetting : costAccountSettings) {
                            entrys = costAccountSetting.getDynamicObjectCollection("entry");
                            for (DynamicObject entry : entrys) {
                                costAccountId = entry.getDynamicObject("costaccount").getLong("id");
                                hashSet.add(costAccountId);
                            }
                        }
                        if (!hashSet.isEmpty()) {
                            DynamicObjectCollection costAccountDynamics = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name,number,booktype,enable", (QFilter[])new QFilter[]{new QFilter("id", "in", hashSet), new QFilter("enable", "=", (Object)"1")}, null);
                            if (costAccountDynamics == null || costAccountDynamics.isEmpty()) {
                                String orgName = orgDynamic.getString("name");
                                bookTypeName = this.getBookTypeFromCacheOrDB(bookTypeID, null);
                                String msg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%1$s\uff0c\u7c7b\u578b\uff1a%2$s\uff0c\u7ed3\u8d26\u5931\u8d25\u3002\u539f\u56e0\uff1a\u6210\u672c\u8d26\u7c3f\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u7ed3\u8d26\u3002", (String)"CloseServiceImpl_2", (String)"fi-cal-mservice", (Object[])new Object[0]), orgName, bookTypeName);
                                errorMsg.add(msg);
                            } else {
                                for (DynamicObject costAccountDynamic : costAccountDynamics) {
                                    Long bookTypeId = costAccountDynamic.getLong("booktype");
                                    if (bookTypeId == null || !bookTypeID.equals(bookTypeId)) continue;
                                    costAccountAndDynamic.put(costAccountDynamic.getLong("id"), costAccountDynamic);
                                }
                            }
                        }
                        for (DynamicObject costAccountSetting : costAccountSettings) {
                            entrys = costAccountSetting.getDynamicObjectCollection("entry");
                            for (DynamicObject entry : entrys) {
                                costAccountId = entry.getDynamicObject("costaccount").getLong("id");
                                Long bookTypeId = costAccountAndDynamic.get(costAccountId) == null ? null : Long.valueOf(((DynamicObject)costAccountAndDynamic.get(costAccountId)).getLong("booktype"));
                                if (bookTypeId == null || !bookTypeID.equals(bookTypeId)) continue;
                                DynamicObject currentPeriod = entry.getDynamicObject("currentperiod");
                                costAccountAndCurrentPeriod.put(costAccountId, currentPeriod);
                            }
                        }
                        break;
                    }
                    break block54;
                }
                case BIZ_CLOSE: {
                    Map map;
                    Date bizCloseDate = closeContext.getBizCloseDate();
                    if (bizCloseDate == null) {
                        errorMsg.add("bizCloseDate : null");
                        result.setSuccess(Boolean.FALSE.booleanValue());
                        result.setErrorMessages(new ArrayList(errorMsg));
                        return result;
                    }
                    LOGGER.info("CloseServiceImpl\u7ed3\u8d26\u7ec4\u7ec7id : " + orgID + " \u5173\u8d26\u65e5\u671f : " + bizCloseDate);
                    ArrayList<CloseAccountParam> params = new ArrayList<CloseAccountParam>(16);
                    DynamicObjectCollection checkItems = QueryServiceHelper.query((String)"cal_datacheck_task", (String)"purpose,entryentity.checkitem,entryentity.entryenable,entryentity.level", (QFilter[])new QFilter("id", "in", (Object)1255063777360084992L).toArray(), (String)"purpose asc,entryentity.checkitem.number asc");
                    HashMap<String, HashMap<Long, String>> allCheckItemMap2 = new HashMap<String, HashMap<Long, String>>(16);
                    if (checkItems != null && !checkItems.isEmpty()) {
                        for (DynamicObject checkItem : checkItems) {
                            Long checkItemId;
                            Boolean ischeck = checkItem.getBoolean("entryentity.entryenable");
                            if (!ischeck.booleanValue() || (checkItemId = Long.valueOf(checkItem.getLong("entryentity.checkitem"))) == null) continue;
                            Long l = checkItemId;
                            String level = checkItem.getString("entryentity.level");
                            String purpose = checkItem.getString("purpose");
                            HashMap<Long, String> checkItemMap = (HashMap<Long, String>)allCheckItemMap2.get(purpose);
                            if (checkItemMap == null) {
                                checkItemMap = new HashMap<Long, String>(16);
                            }
                            checkItemMap.put(l, level);
                            allCheckItemMap2.put(purpose, checkItemMap);
                        }
                    }
                    Set<Long> ownerIds = this.getOwnerByOrg(orgID);
                    MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
                    DynamicObject[] owners = BusinessDataServiceHelper.load((Object[])ownerIds.toArray(), (DynamicObjectType)orgType);
                    Map<Long, DynamicObject> ownerIdLastCloseAcctDycMap = this.getOwnerIdLastCloseAcctDycMap(ownerIds);
                    for (DynamicObject owner : owners) {
                        Date lastCloseDate;
                        CloseAccountParam closeAccountParam = new CloseAccountParam();
                        closeAccountParam.setOwner(owner);
                        closeAccountParam.setCloseDate(bizCloseDate);
                        DynamicObject closeAcctDyc = ownerIdLastCloseAcctDycMap.get(owner.getLong("id"));
                        Date date = lastCloseDate = closeAcctDyc == null ? null : closeAcctDyc.getDate("closedate");
                        if (lastCloseDate == null || !bizCloseDate.after(lastCloseDate)) break;
                        closeAccountParam.setLastCloseDate(lastCloseDate);
                        closeAccountParam.setCheckItems(allCheckItemMap2);
                        closeAccountParam.setUpdateSaveBill(Boolean.FALSE.booleanValue());
                        closeAccountParam.setUpdateSubmitBill(Boolean.FALSE.booleanValue());
                        closeAccountParam.setQuerySchemeId(Long.valueOf(0L));
                        params.add(closeAccountParam);
                    }
                    if ((map = new CloseAccountFacade().doCloseAccount(params.toArray(new CloseAccountParam[0]))) == null || map.isEmpty()) break block54;
                    errorMsg.addAll(map.values());
                    break block54;
                }
                default: {
                    break block54;
                }
            }
            if (costAccountAndCurrentPeriod.isEmpty()) {
                String orgName = ((DynamicObject)orgIdAndDynamic.get(orgID)).getString("name");
                bookTypeName = this.getBookTypeFromCacheOrDB(bookTypeID, bookTypeName);
                String string = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%1$s\uff0c\u7c7b\u578b\uff1a%2$s\uff0c\u7ed3\u8d26\u5931\u8d25\u3002\u539f\u56e0\uff1a\u7c7b\u578b\u4e0d\u5b58\u5728\uff1b\u5efa\u8bae\uff1a\u8bf7\u786e\u8ba4\u6210\u672c\u8d26\u7c3f\u7684\u8d26\u7c3f\u7c7b\u522b\u4e0e\u7c7b\u578b\u662f\u5426\u4e00\u81f4\u3002", (String)"CloseServiceImpl_3", (String)"fi-cal-mservice", (Object[])new Object[0]), orgName, bookTypeName);
                errorMsg.add(string);
            }
            ArrayList<SimpleSettleAccountParam> settleAccountParams = new ArrayList<SimpleSettleAccountParam>();
            boolean bl = false;
            for (Map.Entry entry : costAccountAndDynamic.entrySet()) {
                void var18_32;
                block53: {
                    long costAccountId = (Long)entry.getKey();
                    DynamicObject costAccountDynamic = (DynamicObject)entry.getValue();
                    if (costAccountDynamic != null) {
                        DynamicObject currentPeriod = (DynamicObject)costAccountAndCurrentPeriod.get(costAccountId);
                        int currentPeriodInt = currentPeriod.getInt("periodnumber");
                        int currentYearInt = currentPeriod.getInt("periodyear");
                        int closePeriodInt = closePeriodDynamic.getInt("periodnumber");
                        int closeYearInt = closePeriodDynamic.getInt("periodyear");
                        if (closeYearInt * 100 + closePeriodInt != currentYearInt * 100 + currentPeriodInt) {
                            LOGGER.info("CloseServiceImpl\u7ed3\u8d26 \u671f\u671b\u7ed3\u8d26\u671f\u95f4 : " + (closeYearInt * 100 + closePeriodInt) + "\u4e0d\u7b49\u4e8e\u8d27\u6838\u7b97\u7684\u5f53\u524d\u671f\u95f4 : " + (currentYearInt * 100 + currentPeriodInt));
                            DynamicObject orgDynamic = (DynamicObject)orgIdAndDynamic.get(orgID);
                            String orgName = orgDynamic.getString("name");
                            bookTypeName = this.getBookTypeFromCacheOrDB(bookTypeID, bookTypeName);
                            String format = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%1$s\uff0c\u7c7b\u578b\uff1a%2$s\uff0c\u7ed3\u8d26\u5931\u8d25\u3002\u539f\u56e0\uff1a\u5f53\u524d\u671f\u95f4\u4e0d\u4e00\u81f4\uff1b\u5efa\u8bae\uff1a\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u518d\u64cd\u4f5c\u3002", (String)"CloseServiceImpl_0", (String)"fi-cal-mservice", (Object[])new Object[0]), orgName, bookTypeName);
                            errorMsg.add(format);
                            break;
                        }
                        String costAccountName = costAccountDynamic.getString("name");
                        String costAccountNumber = costAccountDynamic.getString("number");
                        SimpleSettleAccountParam param = new SimpleSettleAccountParam();
                        param.setCheckItems(allCheckItemMap);
                        param.setUpdateSaveBill(Boolean.FALSE.booleanValue());
                        param.setUpdateSubmitBill(Boolean.FALSE.booleanValue());
                        param.setCostAccountId(costAccountId);
                        param.setCostAccountName(costAccountName);
                        param.setCostAccountNum(costAccountNumber);
                        param.setCurrentPeriodId(currentPeriod.getLong("id"));
                        param.setCurrentPeriodNum(currentPeriod.getString("number"));
                        DynamicObject prePeriod = PeriodHelper.getPreviousPeriod((Object)currentPeriod.getLong("id"));
                        DynamicObject nextPeriod = PeriodHelper.getNextPeriod((Object)currentPeriod.getLong("id"));
                        if (nextPeriod != null) {
                            param.setNextPeriodId(nextPeriod.getLong("id"));
                            param.setNextPeriodNum(nextPeriod.getString("number"));
                        }
                        if (prePeriod != null) {
                            param.setPreviousPeriodId(prePeriod.getLong("id"));
                            param.setPreviousPeriodNum(prePeriod.getString("number"));
                        }
                        param.setQuerSchemeId(Long.valueOf(0L));
                        settleAccountParams.add(param);
                        String key = this.DLOCK_KEY + costAccountId;
                        try (DLock lock = DLock.create((String)key, (String)"fi-cal-settleaccount-dlock");){
                            boolean isLocked = lock.tryLock();
                            if (!isLocked) {
                                String msg = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u7ed3\u8d26\u6216\u53cd\u7ed3\u8d26\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SettleAccountTask_5", (String)"fi-cal-formplugin", (Object[])new Object[0]), costAccountName);
                                errorMsg.add(msg);
                                result.setSuccess(Boolean.FALSE.booleanValue());
                                result.setErrorMessages(new ArrayList(errorMsg));
                                CloseResult closeResult = result;
                                return closeResult;
                            }
                            SettleAccountFacade settleAccountFacade = new SettleAccountFacade();
                            settleAccountFacade.setBackgroundInvoke(Boolean.FALSE.booleanValue());
                            settleAccountFacade.setAutoCloseValidateParam(Boolean.TRUE.booleanValue());
                            settleAccountFacade.doSettleAccount(settleAccountParams.toArray(new SimpleSettleAccountParam[0]));
                            List settleAccountErrorMsgs = settleAccountFacade.settleAccountErrorMsgs;
                            Set errorLogIds = settleAccountFacade.errorLogIds;
                            if (settleAccountErrorMsgs != null && !settleAccountErrorMsgs.isEmpty()) {
                                errorMsg.addAll(settleAccountErrorMsgs);
                            }
                            if (errorLogIds == null || errorLogIds.isEmpty()) break block53;
                            int i = 0;
                            for (Object errorLogId : errorLogIds) {
                                errorFormShowParameter = this.createLink((Long)errorLogId);
                                if (++i < 1) continue;
                                break;
                            }
                        }
                        catch (Throwable e) {
                            LOGGER.error("CloseServiceImpl\u7ed3\u8d26\u5931\u8d25 : ", e);
                            String exceptionMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(e));
                            errorMsg.add(exceptionMsg);
                            throw new KDBizException(exceptionMsg);
                        }
                    }
                }
                if (++var18_32 < true) continue;
                break;
            }
        }
        if (!errorMsg.isEmpty()) {
            result.setSuccess(Boolean.FALSE.booleanValue());
        } else {
            result.setSuccess(Boolean.TRUE.booleanValue());
        }
        ArrayList<String> errorMsgs = new ArrayList<String>(errorMsg);
        result.setErrorMessages(errorMsgs);
        result.setDetailFormShowParam(errorFormShowParameter);
        LOGGER.info("CloseServiceImpl errorMsg : " + this.printArray(errorMsgs));
        LOGGER.info("CloseServiceImpl showFormShowParameter : " + errorFormShowParameter);
        if (errorFormShowParameter == null) return result;
        LOGGER.info("CloseServiceImpl showFormShowParameter pageId : " + errorFormShowParameter.getPageId());
        LOGGER.info("CloseServiceImpl showFormShowParameter formId : " + errorFormShowParameter.getFormId());
        return result;
    }

    private String printArray(List<String> errorMsgs) {
        StringBuilder sb = new StringBuilder();
        if (errorMsgs != null && errorMsgs.size() != 0) {
            for (String errorMsg : errorMsgs) {
                sb.append(errorMsg).append(",");
            }
        }
        return sb.toString();
    }

    private FormShowParameter createLink(Long logId) {
        QFilter q = new QFilter("id", "=", (Object)logId);
        DynamicObject log = QueryServiceHelper.queryOne((String)"cal_settleaccountlog", (String)"id,taskid,settletype", (QFilter[])q.toArray());
        if (log.getLong("taskid") == 0L) {
            return null;
        }
        QFilter checkQ = new QFilter("checkplan", "=", (Object)log.getLong("taskid"));
        if ("C".equals(log.getString("settletype"))) {
            checkQ.and("checktask", "in", (Object)CLOSETASK_ID);
        } else {
            checkQ.and("checktask", "in", (Object)SETTLETASK_ID);
        }
        DynamicObjectCollection checkResult = QueryServiceHelper.query((String)"cal_datacheck_result", (String)"id", (QFilter[])checkQ.toArray());
        if (checkResult == null || checkResult.isEmpty()) {
            return null;
        }
        HashSet<Long> rstIdSet = new HashSet<Long>(checkResult.size());
        for (DynamicObject rst : checkResult) {
            rstIdSet.add(rst.getLong("id"));
        }
        if (1 == rstIdSet.size()) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(rstIdSet.iterator().next());
            showParameter.setFormId("cal_datacheck_result");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            return showParameter;
        }
        ListShowParameter listParameter = new ListShowParameter();
        listParameter.setBillFormId("cal_datacheck_result");
        listParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter listQ = new QFilter("id", "in", rstIdSet);
        listParameter.getListFilterParameter().setFilter(listQ);
        return listParameter;
    }

    private String getBookTypeFromCacheOrDB(Long bookTypeID, String pre) {
        if (StringUtils.isEmpty((String)pre)) {
            DynamicObject costAccountTypeDynamic = QueryServiceHelper.queryOne((String)"cal_bd_costaccounttype", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bookTypeID)});
            pre = costAccountTypeDynamic == null ? null : costAccountTypeDynamic.getString("name");
        }
        return pre;
    }

    private Set<Long> getOwnerByOrg(Long orgID) {
        DynamicObjectCollection costAccountSettings = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"org,entry.costaccount", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgID), new QFilter("entry.currentperiod", "!=", null)}, null);
        HashSet<Long> ownerIds = new HashSet<Long>();
        for (DynamicObject costAccountSetting : costAccountSettings) {
            long costAccountId = costAccountSetting.getLong("entry.costaccount");
            AccountingSysHelper accountingSysHelper = new AccountingSysHelper();
            Long[] owners = AccountingSysHelper.getOwners((Long)costAccountId);
            if (owners == null || owners.length == 0) continue;
            for (Long owner : owners) {
                ownerIds.add(owner);
            }
        }
        return ownerIds;
    }

    private boolean doValidate(Long calorgId) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        int result = this.getCalOrgPermission(calorgId, userId, "4730fc9f000001ae");
        return result > 0;
    }

    private int getCalOrgPermission(Long orgId, Long userId, String flag) {
        int result = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"/KIUHEXROK3D", (String)"cal_settleaccount", (String)flag);
        return result;
    }

    public Map<Long, DynamicObject> getOwnerIdLastCloseAcctDycMap(Set<Long> ownerIds) {
        QFilter ownerFilter = new QFilter("owner", "in", ownerIds);
        ownerFilter.and("isleaf", "=", (Object)Boolean.TRUE);
        DynamicObject[] lastCloseAccountDycs = BusinessDataServiceHelper.load((String)"cal_closeaccounttable", (String)"id,calorg,costaccount,owner,isleaf,closedate", (QFilter[])new QFilter[]{ownerFilter});
        HashMap<Long, DynamicObject> ownerIdLastCloseAccountDycMap = new HashMap<Long, DynamicObject>(32);
        for (DynamicObject lastCloseAccountDyc : lastCloseAccountDycs) {
            ownerIdLastCloseAccountDycMap.put((Long)lastCloseAccountDyc.getDynamicObject("owner").getPkValue(), lastCloseAccountDyc);
        }
        return ownerIdLastCloseAccountDycMap;
    }

    public Map<Long, Date> getCalOrgCurPeriodMaxEndDateMap(Set<Long> calOrgIds) {
        QFilter orgFilter = new QFilter("org", "in", calOrgIds);
        QFilter enableFilter = new QFilter("entry.isenabled", "=", (Object)Character.valueOf('1'));
        DataSet calPeriodDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_sysctrlentity", (String)"org,entry.currentperiod.enddate", (QFilter[])new QFilter[]{enableFilter, orgFilter}, null);
        calPeriodDs.groupBy(new String[]{"org"}).max("entry.currentperiod.enddate");
        HashMap<Long, Date> calOrgIdCurPeriodMaxEndateMap = new HashMap<Long, Date>(16);
        for (Row row : calPeriodDs) {
            calOrgIdCurPeriodMaxEndateMap.put(row.getLong("org"), row.getDate("entry.currentperiod.enddate"));
        }
        return calOrgIdCurPeriodMaxEndateMap;
    }
}

