/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.process.inner.CalBillInfo;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalCustomEventCallHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.MulCalBillSyncRuleHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.mservice.api.CostRecordCostUpdateService;

public class CostRecordCostUpdator
implements CostRecordCostUpdateService {
    private static Log logger = LogFactory.getLog(CostRecordCostUpdator.class);
    private static final String PARAMKEY_COSTACCOUNT = "costaccount";
    private static final String PARAMKEY_BIZBILLENTRYID = "bizbillentryid";
    private static final String PARAMKEY_COSTINFO = "costinfo";
    private static final String PARAMKEY_COSTSUBELEMENT = "costsubelement";
    private static final String PARAMKEY_PRICE = "price";
    private static final String PARAMKEY_COST = "cost";
    private static final String PARAMKEY_OUTSOURCETYPE = "outsourcetype";
    private static final String COSTACCOUNT_IDS = "costaccountids";
    private static final String BIZ_BILL_ENTRYIDS = "bizbillentryids";
    private static final String BOOK_TYPE_IDS = "booktypeids";
    private static final String IS_MAIN_ACCOUNT = "ismainaccount";
    private static final String UPDATE_ENTRY_COST = "update t_cal_calcostrecordentry set funitactualcost=? , factualcost = ?, funitmaterialcost = ?, fmaterialcost = ?, funitfee = ?, ffee = ?, funitprocesscost = ?, fprocesscost = ?, fcostpricesource = ?, fdesignatedcost = ? where fentryid = ?";
    private static final String UPDATE_ENTRY_COST_A = "update t_cal_calcostrecordentry set funitmanufacturecost = ?, fmanufacturecost = ?, funitresource = ?, fresource = ? where fentryid = ?";
    private static final String UPDATE_DETAIL_COST = "update t_cal_costrecord_detail set funitactualcost = ? , factualcost = ? where fdetailid = ?";
    private static final String INSERT_DETAIL_COST = "insert into t_cal_costrecord_detail(fdetailid,fentryid,fcostelementid,fcostsubelementid,fmaterialid,fbaseunitid,fbaseqty,funitactualcost,factualcost,fcurrencyid) values(?,?,?,?,?,?,?,?,?,?)";
    private static final String CONNECTOR = "#";
    private static final Long IM_PURINBILL_STD_BT_S = 366348248593474560L;
    private static final String QUERY_FIELDS = "id,billno,costaccount,costaccount.calpolicy.calbycostelement as calbycostelement,costaccount.costtype as costtype,period,issplitcreate,issplit,issubbillinvoiceverify,billtype,isvoucher,localcurrency,localcurrency.priceprecision as priceprecision,localcurrency.amtprecision as amtprecision,entry.id as entryid,entry.seq as seq,entry.baseunit as baseunit,entry.material as material,entry.baseqty as baseqty,entry.bizbillentryid as bizbillentryid,entry.ancestorentryid as ancestorentryid,entry.fatherentryid as fatherentryid,entry.accounttype as accounttype,entry.subentrycostelement.id as detailid,entry.subentrycostelement.costsubelement as costsubelement,entry.costpricesource as costpricesource";
    private static final long DEFAULT_MATERIAL_SUBCOSTELEMENT = 773175233367685120L;
    private static final int BATCH_SIZE = 100000;
    private Map<Long, Long> currentPeriodCache = new HashMap<Long, Long>(16);
    private Map<Long, CostElement> costElementMap = null;
    private Map<Long, List<Long>> rootToLeaf = new HashMap<Long, List<Long>>(16);
    private Map<Long, CostInfo> costUpdateInfoMap = new HashMap<Long, CostInfo>(16);
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private static final String CALRULEFIELDS = "id,number,calbill.id,calbill.number,fieldmap.calfield,fieldmap.sourcefield,fieldmap.isorgfield,fieldmap.orgtype,filter,filter_tag,fieldmap.isextendfield,errortip";
    private static final String COSTACCOUNTFIELDS = "id,name,number,calpolicy,calpolicy.currency,calpolicy.currency.amtprecision,calpolicy.currency.priceprecision,dividebasis,calpolicy.currency.number,calpolicy.currency.name,calpolicy.convertmode,calpolicy.exratetable,calpolicy.calbycostelement,calpolicy.supporttaxamt,calorg,calorg.name,calorg.number";

    public Map<Long, String> updateCostByCostSubElement(List<Map<String, Object>> paramList) {
        if (paramList == null || paramList.isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, Object>> costInfoMap = new HashMap<String, Map<String, Object>>(paramList.size());
        HashMap<Long, Set> entryids = new HashMap<Long, Set>(16);
        for (Map<String, Object> map : paramList) {
            Long l = (Long)map.get(PARAMKEY_COSTACCOUNT);
            Long bizBillEntryId = (Long)map.get(PARAMKEY_BIZBILLENTRYID);
            costInfoMap.put(l + CONNECTOR + bizBillEntryId, map);
            Set billEntryIdSet = entryids.computeIfAbsent(l, k -> new HashSet(16));
            billEntryIdSet.add(bizBillEntryId);
        }
        DataSet dataSet = null;
        for (Map.Entry entry : entryids.entrySet()) {
            dataSet = this.getCostRecordDataSet((Long)entry.getKey(), (Set)entry.getValue(), dataSet);
        }
        if (dataSet == null) {
            return null;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(16);
        DataSet dataSet2 = dataSet.copy().filter("issplitcreate = false");
        HashMap<Long, String> errorInfoMap = new HashMap<Long, String>();
        while (dataSet2.hasNext()) {
            Row row = dataSet2.next();
            Long entryid = row.getLong("entryid");
            Long bizbillentryid = row.getLong(PARAMKEY_BIZBILLENTRYID);
            if (errorInfoMap.containsKey(bizbillentryid)) continue;
            CostInfo costInfo = this.costUpdateInfoMap.get(entryid);
            if (costInfo == null) {
                Long costaccount = row.getLong(PARAMKEY_COSTACCOUNT);
                String billno = row.getString("billno");
                boolean isvoucher = row.getBoolean("isvoucher");
                if (isvoucher) {
                    String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u751f\u6210\u51ed\u8bc1\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"CostRecordCostUpdator_6", (String)"fi-cal-mservice", (Object[])new Object[0]), this.getBillExceptionHead(billno));
                    errorInfoMap.put(bizbillentryid, msg);
                    continue;
                }
                Boolean issubbillinvoiceverify = row.getBoolean("issubbillinvoiceverify");
                Long billtype = row.getLong("billtype");
                if (issubbillinvoiceverify.booleanValue() && IM_PURINBILL_STD_BT_S.equals(billtype)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b50\u5355\u5df2\u53d1\u7968\u6838\u9500\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"MaterialCostUpdateServiceImpl_5", (String)"fi-cal-mservice", (Object[])new Object[0]), billno);
                    errorInfoMap.put(bizbillentryid, msg);
                    continue;
                }
                Long period = row.getLong("period");
                if (period.compareTo(this.getCurrentPeriodID(costaccount)) < 0) {
                    String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e3a\u5f80\u671f\u5355\u636e\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"MaterialCostUpdateServiceImpl_4", (String)"fi-cal-mservice", (Object[])new Object[0]), billno);
                    errorInfoMap.put(bizbillentryid, msg);
                    continue;
                }
                String accounttype = row.getString("accounttype");
                Integer seq = row.getInteger("seq");
                if (AccountTypeEnum.FIN_FOUT.getValue().equals(accounttype) || AccountTypeEnum.MOVE_ADD_AVERAGE.getValue().equals(accounttype)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u8ba1\u4ef7\u65b9\u6cd5\u4e3a\u5b9e\u65f6\u79fb\u52a8\u6216\u5148\u8fdb\u5148\u51fa\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"MaterialCostUpdateServiceImpl_2", (String)"fi-cal-mservice", (Object[])new Object[0]), this.getEntryExceptionHead(billno, seq));
                    errorInfoMap.put(bizbillentryid, msg);
                    continue;
                }
                Map paramMap = (Map)costInfoMap.get(costaccount + CONNECTOR + bizbillentryid);
                List costInfos = (List)paramMap.get(PARAMKEY_COSTINFO);
                costInfo = this.createCostInfo(row, costInfos);
                this.costUpdateInfoMap.put(entryid, costInfo);
            }
            costInfo.setDetailID(row.getLong(PARAMKEY_COSTSUBELEMENT), row.getLong("detailid"));
            arrayList.add(row.getLong("id"));
        }
        this.buildBillRelations(dataSet, errorInfoMap);
        this.calculateChildEntryCost();
        this.updateBillInfos();
        CalCustomEventCallHelper.calApiCostUpdateEventCall(arrayList);
        return errorInfoMap;
    }

    private void updateBillInfos() {
        block38: {
            try (TXHandle handler = TX.requiresNew();){
                IDGenerator idGenerator = new IDGenerator("t_cal_costrecord_detail");
                DBRoute route = new DBRoute("cal");
                ArrayList<Object[]> update_Record_List = new ArrayList<Object[]>(100000);
                ArrayList<Object[]> update_Record_A_List = new ArrayList<Object[]>(100000);
                ArrayList<Object[]> update_Detail_List = new ArrayList<Object[]>(100000);
                ArrayList<Object[]> insert_Detail_List = new ArrayList<Object[]>(100000);
                for (CostInfo costInfo : this.costUpdateInfoMap.values()) {
                    String costpricesource = costInfo.costpricesource;
                    costpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue((String)costpricesource, (String)CostPriceSourceTypeEnum.COST_PAY_ABLE_SPECIFICATION.getValue());
                    if (update_Record_List.size() >= 100000) {
                        DB.executeBatch((DBRoute)route, (String)UPDATE_ENTRY_COST, update_Record_List);
                        update_Record_List.clear();
                    }
                    update_Record_List.add(new Object[]{costInfo.unitActualCost, costInfo.actualCost, costInfo.unitMaterialCost, costInfo.materialCost, costInfo.unitFee, costInfo.fee, costInfo.unitProcessCost, costInfo.processCost, costpricesource, CostPriceSourceTypeEnum.COST_PAY_ABLE_SPECIFICATION.getDesignated(), costInfo.entryid});
                    if (update_Record_A_List.size() >= 100000) {
                        DB.executeBatch((DBRoute)route, (String)UPDATE_ENTRY_COST_A, update_Record_A_List);
                        update_Record_A_List.clear();
                    }
                    update_Record_A_List.add(new Object[]{costInfo.unitManufactureCost, costInfo.manufactureCost, costInfo.unitResource, costInfo.resource, costInfo.entryid});
                    for (Map.Entry entry : costInfo.subElementCostMap.entrySet()) {
                        Long subElementId = (Long)entry.getKey();
                        BigDecimal price = (BigDecimal)((Object[])entry.getValue())[0];
                        BigDecimal cost = (BigDecimal)((Object[])entry.getValue())[1];
                        Object detailId = ((Object[])entry.getValue())[2];
                        if (detailId == null) {
                            if (insert_Detail_List.size() >= 100000) {
                                DB.executeBatch((DBRoute)route, (String)INSERT_DETAIL_COST, insert_Detail_List);
                                insert_Detail_List.clear();
                            }
                            insert_Detail_List.add(new Object[]{idGenerator.getId(), costInfo.entryid, this.getCostElement(subElementId).id, subElementId, costInfo.material, costInfo.baseunit, costInfo.baseqty, price, cost, costInfo.currency});
                            continue;
                        }
                        if (update_Detail_List.size() >= 100000) {
                            DB.executeBatch((DBRoute)route, (String)UPDATE_DETAIL_COST, update_Detail_List);
                            update_Detail_List.clear();
                        }
                        update_Detail_List.add(new Object[]{price, cost, detailId});
                    }
                }
                if (!update_Record_List.isEmpty()) {
                    DB.executeBatch((DBRoute)route, (String)UPDATE_ENTRY_COST, update_Record_List);
                }
                if (!update_Record_A_List.isEmpty()) {
                    DB.executeBatch((DBRoute)route, (String)UPDATE_ENTRY_COST_A, update_Record_A_List);
                }
                if (!update_Detail_List.isEmpty()) {
                    DB.executeBatch((DBRoute)route, (String)UPDATE_DETAIL_COST, update_Detail_List);
                }
                if (!insert_Detail_List.isEmpty()) {
                    DB.executeBatch((DBRoute)route, (String)INSERT_DETAIL_COST, insert_Detail_List);
                }
                if (this.isNewBalance) {
                    HashSet<Long> idSet = new HashSet<Long>();
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id", (QFilter[])new QFilter("entry.id", "in", this.costUpdateInfoMap.keySet()).toArray(), null);){
                        for (Row row : dataSet) {
                            idSet.add(row.getLong("id"));
                        }
                    }
                    new BalanceOpInvoker().invokeCostRecordUpdateBalOp(idSet, BalanceSourceEnum.COST_UPDATE_INTERFACE);
                    break block38;
                }
                BalanceCalculator calculator = new BalanceCalculator();
                calculator.updateBalance4Others(this.costUpdateInfoMap.keySet().toArray(), BalanceSourceEnum.COST_UPDATE_INTERFACE);
            }
        }
    }

    private void calculateChildEntryCost() {
        for (Map.Entry<Long, List<Long>> entry : this.rootToLeaf.entrySet()) {
            Long rootId = entry.getKey();
            CostInfo rootCostInfo = this.costUpdateInfoMap.get(rootId);
            BigDecimal rootQty = rootCostInfo.baseqty;
            List<Long> childSet = entry.getValue();
            int size = childSet.size();
            HashMap<Long, BigDecimal> currentTotalCost = new HashMap<Long, BigDecimal>();
            for (int i = 0; i < size; ++i) {
                Long childId = childSet.get(i);
                CostInfo childCostInfo = this.costUpdateInfoMap.get(childId);
                for (Map.Entry elementEntry : rootCostInfo.subElementCostMap.entrySet()) {
                    Long subElementId = (Long)elementEntry.getKey();
                    BigDecimal price = (BigDecimal)((Object[])elementEntry.getValue())[0];
                    BigDecimal cost = (BigDecimal)((Object[])elementEntry.getValue())[1];
                    BigDecimal childCost = null;
                    childCost = cost.multiply(childCostInfo.baseqty).divide(rootQty, childCostInfo.amtprecision, RoundingMode.HALF_UP);
                    BigDecimal currentTotalElementCost = (BigDecimal)currentTotalCost.get(subElementId);
                    currentTotalElementCost = currentTotalElementCost == null ? childCost : currentTotalElementCost.add(childCost);
                    currentTotalCost.put(subElementId, childCost);
                    this.addCostInfoBySubElement(childCostInfo, (Long)elementEntry.getKey(), price, childCost, null, false);
                }
            }
        }
    }

    private void buildBillRelations(DataSet dataSet, Map<Long, String> errorInfoMap) {
        DataSet childBillSet = dataSet.filter("issplitcreate = true");
        while (childBillSet.hasNext()) {
            Row row = childBillSet.next();
            Long entryid = row.getLong("entryid");
            Long rootId = row.getLong("ancestorentryid");
            Long bizbillentryid = row.getLong(PARAMKEY_BIZBILLENTRYID);
            if (errorInfoMap.containsKey(bizbillentryid)) continue;
            this.costUpdateInfoMap.put(entryid, this.createCostInfo(row, null));
            if (row.getBoolean("issplit").booleanValue()) continue;
            List childIdSet = this.rootToLeaf.computeIfAbsent(rootId, k -> new LinkedList());
            childIdSet.add(entryid);
        }
    }

    private DataSet getCostRecordDataSet(Long costAccount, Set<Long> bizBillEntryIds, DataSet dataSet) {
        QFilter filter = new QFilter(PARAMKEY_COSTACCOUNT, "=", (Object)costAccount);
        filter = filter.and("entry.bizbillentryid", "in", bizBillEntryIds);
        DataSet tempDataSet = QueryServiceHelper.queryDataSet((String)CostRecordCostUpdator.class.getName(), (String)"cal_costrecord_subentity", (String)QUERY_FIELDS, (QFilter[])filter.toArray(), (String)"entry.id");
        dataSet = dataSet == null ? tempDataSet : dataSet.union(tempDataSet);
        return dataSet;
    }

    private Long getCurrentPeriodID(Long costAccountID) {
        Long periodId = this.currentPeriodCache.get(costAccountID);
        if (periodId == null) {
            periodId = PeriodHelper.getCurrentPeriod((Long)costAccountID).getLong("id");
            this.currentPeriodCache.put(costAccountID, periodId);
        }
        return periodId;
    }

    private String getEntryExceptionHead(String billno, Integer seq) {
        String content = String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%1$s\u3011\u7b2c%2$s\u884c\u5206\u5f55", (String)"CostRecordCostUpdator_41", (String)"fi-cal-mservice", (Object[])new Object[0]), billno, seq);
        return content;
    }

    private String getBillExceptionHead(String billno) {
        String content = String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%1$s\u3011", (String)"CostRecordCostUpdator_51", (String)"fi-cal-mservice", (Object[])new Object[0]), billno);
        return content;
    }

    private CostElement getCostElement(Long costSubElement) {
        if (this.costElementMap != null) {
            return this.costElementMap.get(costSubElement);
        }
        this.costElementMap = new HashMap<Long, CostElement>();
        QFilter q = new QFilter("syncflag", "=", (Object)"1");
        try (DataSet subElementSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_subelement", (String)"id,name,type", (QFilter[])q.toArray(), null);
             DataSet relationSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_elementdetail", (String)"element,subelement", null, null);
             DataSet finalSet = subElementSet.join(relationSet, JoinType.INNER).on("id", "subelement").select(new String[]{"id", "name", "type", "element"}).finish();){
            while (finalSet.hasNext()) {
                Row row = finalSet.next();
                Long id = row.getLong("id");
                this.costElementMap.put(id, new CostElement(row.getLong("element"), row.getString("type")));
            }
        }
        return this.costElementMap.get(costSubElement);
    }

    private CostInfo createCostInfo(Row row, List<Map<String, Object>> costInfos) {
        CostInfo info = new CostInfo();
        info.entryid = row.getLong("entryid");
        info.material = row.getLong("material");
        info.baseunit = row.getLong("baseunit");
        info.calbycostelement = row.getBoolean("calbycostelement");
        info.amtprecision = row.getInteger("amtprecision");
        info.currency = row.getLong("localcurrency");
        BigDecimal qty = row.getBigDecimal("baseqty");
        info.baseqty = qty;
        info.costpricesource = row.getString("costpricesource");
        if (costInfos == null) {
            return info;
        }
        boolean isWWCostType = false;
        for (Map<String, Object> costInfo : costInfos) {
            String ww_costtype = (String)costInfo.get(PARAMKEY_OUTSOURCETYPE);
            if (StringUtils.isEmpty((String)ww_costtype)) continue;
            isWWCostType = true;
            break;
        }
        for (Map<String, Object> costInfo : costInfos) {
            Long costsubelement = (Long)costInfo.get(PARAMKEY_COSTSUBELEMENT);
            BigDecimal price = (BigDecimal)costInfo.get(PARAMKEY_PRICE);
            BigDecimal cost = (BigDecimal)costInfo.get(PARAMKEY_COST);
            String ww_costtype = (String)costInfo.get(PARAMKEY_OUTSOURCETYPE);
            if (price == null) {
                Integer pricePrecision = row.getInteger("priceprecision");
                price = cost.divide(qty, (int)pricePrecision, RoundingMode.HALF_UP);
            }
            if (cost == null) {
                Integer amtPrecision = row.getInteger("amtprecision");
                cost = price.multiply(qty).setScale((int)amtPrecision, RoundingMode.HALF_UP);
            }
            this.addCostInfoBySubElement(info, costsubelement, price, cost, ww_costtype, isWWCostType);
        }
        return info;
    }

    private void addCostInfoBySubElement(CostInfo costInfo, Long costsubelement, BigDecimal price, BigDecimal cost, String ww_costtype, boolean isWWCostType) {
        CostElement element;
        if (!costInfo.calbycostelement) {
            costsubelement = 773175233367685120L;
        }
        if ((element = this.getCostElement(costsubelement)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u540c\u6b65\u5b58\u8d27\u6838\u7b97\u7684\u6210\u672c\u5b50\u8981\u7d20\uff0c\u8bf7\u68c0\u67e5\u6210\u672c\u5b50\u8981\u7d20\u57fa\u7840\u6570\u636e\u3002", (String)"MaterialCostUpdateServiceImpl_19", (String)"fi-cal-mservice", (Object[])new Object[0]));
        }
        Object[] costArr = (Object[])costInfo.subElementCostMap.get(costsubelement);
        if (costArr == null) {
            costArr = new Object[]{price, cost, null};
            costInfo.subElementCostMap.put(costsubelement, costArr);
        } else {
            costArr[0] = ((BigDecimal)costArr[0]).add(price);
            costArr[1] = ((BigDecimal)costArr[1]).add(cost);
        }
        if (isWWCostType && !costInfo.calbycostelement) {
            if ("D".equals(ww_costtype)) {
                costInfo.unitMaterialCost = costInfo.unitMaterialCost.add(price);
                costInfo.materialCost = costInfo.materialCost.add(cost);
            } else if ("B".equals(ww_costtype)) {
                costInfo.unitFee = costInfo.unitFee.add(price);
                costInfo.fee = costInfo.fee.add(cost);
            } else if ("C".equals(ww_costtype)) {
                costInfo.unitManufactureCost = costInfo.unitManufactureCost.add(price);
                costInfo.manufactureCost = costInfo.manufactureCost.add(cost);
            } else if ("A".equals(ww_costtype)) {
                costInfo.unitProcessCost = costInfo.unitProcessCost.add(price);
                costInfo.processCost = costInfo.processCost.add(cost);
            } else {
                costInfo.unitMaterialCost = costInfo.unitMaterialCost.add(price);
                costInfo.materialCost = costInfo.materialCost.add(cost);
            }
        } else if (element.type.equals("001")) {
            costInfo.unitMaterialCost = costInfo.unitMaterialCost.add(price);
            costInfo.materialCost = costInfo.materialCost.add(cost);
        } else if (element.type.equals("002")) {
            costInfo.unitFee = costInfo.unitFee.add(price);
            costInfo.fee = costInfo.fee.add(cost);
        } else if (element.type.equals("003")) {
            costInfo.unitManufactureCost = costInfo.unitManufactureCost.add(price);
            costInfo.manufactureCost = costInfo.manufactureCost.add(cost);
        } else if (element.type.equals("004")) {
            costInfo.unitResource = costInfo.unitResource.add(price);
            costInfo.resource = costInfo.resource.add(cost);
        } else {
            costInfo.unitProcessCost = costInfo.unitProcessCost.add(price);
            costInfo.processCost = costInfo.processCost.add(cost);
        }
        costInfo.unitActualCost = costInfo.unitActualCost.add(price);
        costInfo.actualCost = costInfo.actualCost.add(cost);
    }

    public List<Map<String, Object>> getRecordCost(Map<String, Object> param) {
        if (null == param || param.isEmpty()) {
            logger.info("CostRecordCostServiceImpl getRecordCost params is null");
            return null;
        }
        Set bizbillentryidsSet = new HashSet(16);
        logger.info("CostRecordCostUpdator getRecordCost bizbillentryids=" + param.get(BIZ_BILL_ENTRYIDS));
        if (param.get(BIZ_BILL_ENTRYIDS) != null) {
            bizbillentryidsSet = (Set)param.get(BIZ_BILL_ENTRYIDS);
        }
        if (bizbillentryidsSet.isEmpty()) {
            logger.info("CostRecordCostServiceImpl getRecordCost bizbillentryidsSet is null");
            return null;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        QFilter costRecordQ = new QFilter("billstatus", "=", (Object)"C");
        costRecordQ.and("issplitcreate", "=", (Object)Boolean.FALSE);
        logger.info("CostRecordCostUpdator getRecordCost costaccount=" + param.get(COSTACCOUNT_IDS));
        Object costAccountPaId = null;
        if (param.get(COSTACCOUNT_IDS) != null) {
            costAccountPaId = param.get(COSTACCOUNT_IDS);
            costRecordQ.and(PARAMKEY_COSTACCOUNT, "=", costAccountPaId);
        }
        logger.info("CostRecordCostUpdator getRecordCost booktypeids=" + param.get(BOOK_TYPE_IDS));
        Object booktypePaId = null;
        if (param.get(BOOK_TYPE_IDS) != null) {
            booktypePaId = param.get(BOOK_TYPE_IDS);
            costRecordQ.and("costaccount.booktype", "=", booktypePaId);
        }
        logger.info("CostRecordCostUpdator getRecordCost ismainaccount=" + param.get(IS_MAIN_ACCOUNT));
        if (param.get(IS_MAIN_ACCOUNT) != null) {
            boolean ismainaccount = (Boolean)param.get(IS_MAIN_ACCOUNT);
            costRecordQ.and("costaccount.ismainaccount", "=", (Object)ismainaccount);
        }
        QFilter entryQFilter = new QFilter("entry.bizbillentryid", "in", bizbillentryidsSet);
        DataSet costRecordEntryDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,entry.id", (QFilter[])entryQFilter.toArray(), null);
        HashSet<Long> billIdSet = new HashSet<Long>(16);
        HashSet<Long> billEntryIdSet = new HashSet<Long>(16);
        for (Row row : costRecordEntryDataSet) {
            billIdSet.add(row.getLong("id"));
            billEntryIdSet.add(row.getLong("entry.id"));
        }
        costRecordQ.and("id", "in", billIdSet);
        costRecordQ.and("entry.id", "in", billEntryIdSet);
        DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,costaccount,localcurrency,bizbillid,entry.bizbillentryid as bizbillentryid,entry.iscalculated as iscalculated,entry.unitstandardcost as unitstandardcost,entry.standardcost as standardcost,entry.unitactualcost as unitactualcost,entry.actualcost as actualcost,entry.unitmaterialcost as unitmaterialcost,entry.materialcost as materialcost,entry.unitfee as unitfee,entry.fee as fee,entry.unitprocesscost as unitprocesscost,entry.processcost as processcost,entry.unitmanufacturecost as unitmanufacturecost,entry.manufacturecost as manufacturecost", (QFilter[])costRecordQ.toArray(), null);
        for (Row row : costRecordDataSet) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            Long recordId = row.getLong("id");
            resultMap.put("recordId", recordId);
            Long costaccountId = row.getLong(PARAMKEY_COSTACCOUNT);
            resultMap.put(PARAMKEY_COSTACCOUNT, costaccountId);
            Long localcurrencyId = row.getLong("localcurrency");
            resultMap.put("localcurrency", localcurrencyId);
            Long bizbillid = row.getLong("bizbillid");
            resultMap.put("bizbillid", bizbillid);
            Long bizbillentryid = row.getLong(PARAMKEY_BIZBILLENTRYID);
            resultMap.put(PARAMKEY_BIZBILLENTRYID, bizbillentryid);
            boolean iscalculated = row.getBoolean("iscalculated");
            resultMap.put("iscalculated", iscalculated);
            BigDecimal unitstandardcost = row.getBigDecimal("unitstandardcost");
            resultMap.put("unitstandardcost", unitstandardcost);
            BigDecimal standardcost = row.getBigDecimal("standardcost");
            resultMap.put("standardcost", standardcost);
            BigDecimal unitactualcost = row.getBigDecimal("unitactualcost");
            resultMap.put("unitactualcost", unitactualcost);
            BigDecimal actualcost = row.getBigDecimal("actualcost");
            resultMap.put("actualcost", actualcost);
            BigDecimal unitmaterialcost = row.getBigDecimal("unitmaterialcost");
            resultMap.put("unitmaterialcost", unitmaterialcost);
            BigDecimal materialcost = row.getBigDecimal("materialcost");
            resultMap.put("materialcost", materialcost);
            BigDecimal unitfee = row.getBigDecimal("unitfee");
            resultMap.put("unitfee", unitfee);
            BigDecimal fee = row.getBigDecimal("fee");
            resultMap.put("fee", fee);
            BigDecimal unitprocesscost = row.getBigDecimal("unitprocesscost");
            resultMap.put("unitprocesscost", unitprocesscost);
            BigDecimal processcost = row.getBigDecimal("processcost");
            resultMap.put("processcost", processcost);
            BigDecimal unitmanufacturecost = row.getBigDecimal("unitmanufacturecost");
            resultMap.put("unitmanufacturecost", unitmanufacturecost);
            BigDecimal manufacturecost = row.getBigDecimal("manufacturecost");
            resultMap.put("manufacturecost", manufacturecost);
            result.add(resultMap);
        }
        return result;
    }

    public Map<Long, String> updateRecordCost(String bizEntityObject, List<Map<String, Object>> costMapList) {
        HashMap<Long, String> errorInfoMap = new HashMap<Long, String>();
        if (StringUtils.isEmpty((String)bizEntityObject)) {
            errorInfoMap.put(-1L, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CostRecordCostUpdator_4", (String)"fi-cal-mservice", (Object[])new Object[0]));
            return errorInfoMap;
        }
        if (null == costMapList || costMapList.isEmpty()) {
            errorInfoMap.put(-1L, ResManager.loadKDString((String)"\u6210\u672c\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CostRecordCostUpdator_5", (String)"fi-cal-mservice", (Object[])new Object[0]));
            return errorInfoMap;
        }
        Collection<DynamicObject> rules = this.getCalBillRules(bizEntityObject);
        if (null == rules || rules.isEmpty()) {
            errorInfoMap.put(-1L, ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u6620\u5c04\u5173\u7cfb\u3002", (String)"CostRecordCostUpdator_10", (String)"fi-cal-mservice", (Object[])new Object[0]));
            return errorInfoMap;
        }
        DataSet costRecordds = this.getCheckCostRecordDataSet(costMapList);
        HashSet<Long> costaccountIdSet = new HashSet<Long>(16);
        this.checkCostRecordInfo(errorInfoMap, costRecordds, costaccountIdSet);
        if (!errorInfoMap.isEmpty()) {
            return errorInfoMap;
        }
        Map<Long, DynamicObject> costaccountMap = this.getCostAccountMap(costaccountIdSet);
        HashSet<DynamicObject> costRecordAllSet = new HashSet<DynamicObject>(16);
        Map<Long, Set<Long>> billIdRuleIdsMap = this.getBillIdRuleIdsMap(bizEntityObject, costMapList);
        HashMap<Long, DynamicObject> ruleIdRuleDycMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject ruleDyc : rules) {
            ruleIdRuleDycMap.put(ruleDyc.getLong("id"), ruleDyc);
        }
        ArrayList<Long> recordeIds = new ArrayList<Long>(16);
        for (Map<String, Object> param : costMapList) {
            Object bizbillid = param.get("bizbillid");
            HashSet ruleIds = billIdRuleIdsMap.get(bizbillid);
            ruleIds = ruleIds == null ? new HashSet(0) : ruleIds;
            for (Long ruleId : ruleIds) {
                DynamicObject[] costRecords;
                Map<String, BigDecimal> resultMap;
                DynamicObject calbillEntryInfo;
                DynamicObject rule = (DynamicObject)ruleIdRuleDycMap.get(ruleId);
                String calBillNumber = rule.getDynamicObject("calbill").getString("number");
                CalBillInfo calBillInfo = new CalBillInfo(calBillNumber);
                String calBillEntryKey = calBillInfo.getEntrykey();
                Object bizbillentryid = param.get(PARAMKEY_BIZBILLENTRYID);
                DynamicObject entryColl = this.updateCalbillInfo(bizbillentryid, calbillEntryInfo = this.getCalBillInfo(calBillNumber, bizbillid, bizbillentryid), resultMap = this.getFieldMapping(rule, calBillInfo, bizEntityObject, param), calBillEntryKey);
                if (null == entryColl) continue;
                QFilter dbQFilter = new QFilter("bizbillid", "=", bizbillid);
                dbQFilter.and("entry.bizbillentryid", "=", bizbillentryid);
                for (DynamicObject costRecord : costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)"id,costaccount,costaccount.calpolicy,biztype,entry.id,entry.baseqty,entry.unitstandardcost,entry.standardcost,entry.materialcost,entry.fee,entry.manufacturecost,entry.processcost,entry.actualcost,entry.unitmaterialcost,entry.unitfee,entry.unitmanufacturecost,entry.unitprocesscost,entry.unitactualcost,entry.costpricesource as costpricesource", (QFilter[])dbQFilter.toArray())) {
                    BigDecimal interCostAmt;
                    Long costaccountId = costRecord.getDynamicObject(PARAMKEY_COSTACCOUNT).getLong("id");
                    DynamicObject costaccount = costaccountMap.get(costaccountId);
                    boolean supportTaxAmt = costaccount.getBoolean("calpolicy.supporttaxamt");
                    BigDecimal calMaterialCost = BigDecimal.ZERO;
                    Set purBizEntityNumSet = CommonSettingHelper.getBizEntityNumbers((String)"purbiztype");
                    String bizEntityNumber = calbillEntryInfo.getDynamicObject("bizentityobject").getString("number");
                    boolean isPur = purBizEntityNumSet.contains(bizEntityNumber);
                    Set ominBizEntityNumSet = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
                    boolean isOmin = ominBizEntityNumSet.contains(bizEntityNumber);
                    calMaterialCost = isPur ? ((interCostAmt = entryColl.getBigDecimal("intercostamt")) != null && interCostAmt.compareTo(BigDecimal.ZERO) != 0 ? interCostAmt : (supportTaxAmt ? entryColl.getBigDecimal("localtaxamount") : entryColl.getBigDecimal("materialcost"))) : entryColl.getBigDecimal("materialcost");
                    BigDecimal materialcost = BigDecimal.ZERO;
                    BigDecimal unitMaterialCost = BigDecimal.ZERO;
                    long billLocalCurrencyId = calbillEntryInfo.getDynamicObject("localcurrency").getLong("id");
                    long localCurrencyId = costaccount.getLong("calpolicy.currency");
                    boolean isSameLocalCurrency = localCurrencyId == billLocalCurrencyId;
                    int pricePrecision = 10;
                    BigDecimal baseqty = entryColl.getBigDecimal("baseqty");
                    if (isSameLocalCurrency) {
                        materialcost = calMaterialCost;
                        if (baseqty.compareTo(BigDecimal.ZERO) != 0) {
                            unitMaterialCost = materialcost.divide(baseqty, pricePrecision, 4);
                        }
                    } else {
                        materialcost = this.convertAmount(calMaterialCost, isSameLocalCurrency, billLocalCurrencyId, localCurrencyId, calbillEntryInfo, costaccount);
                        if (baseqty.compareTo(BigDecimal.ZERO) != 0) {
                            unitMaterialCost = materialcost.divide(baseqty, pricePrecision, 4);
                        }
                    }
                    if (materialcost.compareTo(BigDecimal.ZERO) == 0 && entryColl.getBigDecimal("unitmaterialcost").compareTo(BigDecimal.ZERO) != 0) {
                        unitMaterialCost = entryColl.getBigDecimal("unitmaterialcost");
                    }
                    BigDecimal unitFee = entryColl.getBigDecimal("unitfee");
                    BigDecimal fee = entryColl.getBigDecimal("fee");
                    if ((fee = this.convertAmount(fee, isSameLocalCurrency, billLocalCurrencyId, localCurrencyId, calbillEntryInfo, costaccount)).compareTo(BigDecimal.ZERO) != 0 && baseqty.compareTo(BigDecimal.ZERO) != 0) {
                        unitFee = fee.divide(baseqty, pricePrecision, 4);
                    }
                    BigDecimal unitProcessCost = entryColl.getBigDecimal("unitprocesscost");
                    BigDecimal processCost = isOmin && supportTaxAmt ? entryColl.getBigDecimal("localtaxamount") : entryColl.getBigDecimal("processcost");
                    if ((processCost = this.convertAmount(processCost, isSameLocalCurrency, billLocalCurrencyId, localCurrencyId, calbillEntryInfo, costaccount)).compareTo(BigDecimal.ZERO) != 0 && baseqty.compareTo(BigDecimal.ZERO) != 0) {
                        unitProcessCost = processCost.divide(baseqty, pricePrecision, 4);
                    }
                    this.updateCostRecordEntry(costRecord, materialcost, unitMaterialCost, unitFee, fee, unitProcessCost, processCost);
                    costRecordAllSet.add(costRecord);
                    recordeIds.add(costRecord.getLong("id"));
                }
            }
        }
        if (!costRecordAllSet.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])costRecordAllSet.toArray(new DynamicObject[0]));
            this.updateCostSubElement(costaccountMap, costRecordAllSet);
        }
        CalCustomEventCallHelper.calApiCostUpdateEventCall(recordeIds);
        return errorInfoMap;
    }

    private Map<Long, Set<Long>> getBillIdRuleIdsMap(String bizEntityObject, List<Map<String, Object>> costMapList) {
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (Map<String, Object> param : costMapList) {
            Object bizbillid = param.get("bizbillid");
            bizBillIds.add((Long)bizbillid);
        }
        Map billIdRuleIdMap = new MulCalBillSyncRuleHelper().getBillIdRuleIdMap(bizEntityObject, bizBillIds);
        return billIdRuleIdMap;
    }

    private DynamicObject updateCalbillInfo(Object bizbillentryid, DynamicObject calbillEntryInfo, Map<String, BigDecimal> resultMap, String calBillEntryKey) {
        DynamicObject entryColl = null;
        DynamicObjectCollection entryCols = calbillEntryInfo.getDynamicObjectCollection(calBillEntryKey);
        for (DynamicObject dynamicObject : entryCols) {
            Long bizbillentryidt = dynamicObject.getLong(PARAMKEY_BIZBILLENTRYID);
            if (bizbillentryidt != Long.parseLong(bizbillentryid + "")) continue;
            for (Map.Entry<String, BigDecimal> entryMap : resultMap.entrySet()) {
                entryColl = dynamicObject;
                dynamicObject.set(entryMap.getKey(), (Object)entryMap.getValue());
                entryColl.set(entryMap.getKey(), (Object)entryMap.getValue());
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calbillEntryInfo});
        return entryColl;
    }

    private DynamicObject getCalBillInfo(String calBillNumber, Object bizbillid, Object bizbillentryid) {
        QFilter filters = new QFilter("bizbillid", "=", bizbillid);
        filters.and("entry.bizbillentryid", "=", bizbillentryid);
        DynamicObject calbillEntryInfo = BusinessDataServiceHelper.loadSingle((String)calBillNumber, (String)"id,entry.id,bizbillid,entry.bizbillentryid,entry.intercostamt,entry.localtaxamount,entry.materialcost,entry.baseqty,entry.unitmaterialcost,entry.unitfee,entry.fee,entry.unitprocesscost,entry.processcost,entry.localtax,entry.taxamount,bizentityobject,entry.localamount,localcurrency", (QFilter[])filters.toArray());
        return calbillEntryInfo;
    }

    private Map<Long, DynamicObject> getCostAccountMap(Set<Long> costaccountIdSet) {
        HashMap<Long, DynamicObject> costaccountMap = new HashMap<Long, DynamicObject>(16);
        if (!costaccountIdSet.isEmpty()) {
            QFilter costaccountqf = new QFilter("id", "in", costaccountIdSet);
            DynamicObjectCollection costaccountColl = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)COSTACCOUNTFIELDS, (QFilter[])costaccountqf.toArray());
            for (DynamicObject costaccount : costaccountColl) {
                Long costaccountId = costaccount.getLong("id");
                costaccountMap.put(costaccountId, costaccount);
            }
        }
        return costaccountMap;
    }

    private DataSet getCheckCostRecordDataSet(List<Map<String, Object>> costMapList) {
        HashSet<Object> bizbillidSet = new HashSet<Object>(16);
        HashSet<Object> bizbillentryidSet = new HashSet<Object>(16);
        for (Map<String, Object> param : costMapList) {
            Object bizbillid = param.get("bizbillid");
            Object bizbillentryid = param.get(PARAMKEY_BIZBILLENTRYID);
            if (null == bizbillid || null == bizbillentryid) continue;
            bizbillidSet.add(bizbillid);
            bizbillentryidSet.add(bizbillentryid);
        }
        QFilter bizQFilter = new QFilter("bizbillid", "in", bizbillidSet);
        bizQFilter.and("entry.bizbillentryid", "in", bizbillentryidSet);
        DataSet costRecordds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)"id,costaccount,period,isvoucher,billno,entry.seq as seq,entry.accounttype as accounttype,entry.bizbillentryid as bizbillentryid,issubbillinvoiceverify", (QFilter[])bizQFilter.toArray(), null);
        return costRecordds;
    }

    private void checkCostRecordInfo(Map<Long, String> errorInfoMap, DataSet costRecordds, Set<Long> costaccountIdSet) {
        for (Row row : costRecordds) {
            String billno = row.getString("billno");
            Long bizbillentryid = row.getLong(PARAMKEY_BIZBILLENTRYID);
            Long costaccountId = row.getLong(PARAMKEY_COSTACCOUNT);
            if (errorInfoMap.containsKey(bizbillentryid)) continue;
            boolean isvoucher = row.getBoolean("isvoucher");
            if (isvoucher) {
                String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u751f\u6210\u51ed\u8bc1\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"CostRecordCostUpdator_6", (String)"fi-cal-mservice", (Object[])new Object[0]), this.getBillExceptionHead(billno));
                errorInfoMap.put(bizbillentryid, msg);
                continue;
            }
            Long period = row.getLong("period");
            if (period.compareTo(this.getCurrentPeriodID(costaccountId)) < 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e3a\u5f80\u671f\u5355\u636e\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"CostRecordCostUpdator_7", (String)"fi-cal-mservice", (Object[])new Object[0]), this.getBillExceptionHead(billno));
                errorInfoMap.put(bizbillentryid, msg);
                continue;
            }
            String accounttype = row.getString("accounttype");
            Integer seq = row.getInteger("seq");
            if (AccountTypeEnum.FIN_FOUT.getValue().equals(accounttype) || AccountTypeEnum.MOVE_ADD_AVERAGE.getValue().equals(accounttype) || AccountTypeEnum.STANDARDCOST.getValue().equals(accounttype)) {
                String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u8ba1\u4ef7\u65b9\u6cd5\u4e3a\u5b9e\u65f6\u79fb\u52a8\u6216\u5148\u8fdb\u5148\u51fa\u6216\u6807\u51c6\u6210\u672c\u6cd5\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"CostRecordCostUpdator_8", (String)"fi-cal-mservice", (Object[])new Object[0]), this.getEntryExceptionHead(billno, seq));
                errorInfoMap.put(bizbillentryid, msg);
                continue;
            }
            Boolean issubbillinvoiceverify = row.getBoolean("issubbillinvoiceverify");
            if (issubbillinvoiceverify.booleanValue()) {
                String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b50\u5355\u5df2\u53d1\u7968\u6838\u9500\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"CostRecordCostUpdator_9", (String)"fi-cal-mservice", (Object[])new Object[0]), this.getBillExceptionHead(billno));
                errorInfoMap.put(bizbillentryid, msg);
                continue;
            }
            costaccountIdSet.add(costaccountId);
        }
    }

    private void updateCostRecordEntry(DynamicObject costRecord, BigDecimal materialcost, BigDecimal unitMaterialCost, BigDecimal unitFee, BigDecimal fee, BigDecimal unitProcessCost, BigDecimal processCost) {
        DynamicObjectCollection costRecordEntrys = costRecord.getDynamicObjectCollection("entry");
        for (DynamicObject costRecordEntry : costRecordEntrys) {
            String costpricesource = costRecordEntry.getString("costpricesource");
            costpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue((String)costpricesource, (String)CostPriceSourceTypeEnum.COST_PAY_ABLE_SPECIFICATION.getValue());
            costRecordEntry.set("costpricesource", (Object)costpricesource);
            costRecordEntry.set("designatedcost", (Object)CostPriceSourceTypeEnum.COST_PAY_ABLE_SPECIFICATION.getDesignated());
            costRecordEntry.set("materialcost", (Object)materialcost);
            costRecordEntry.set("unitmaterialcost", (Object)unitMaterialCost);
            costRecordEntry.set("fee", (Object)fee);
            costRecordEntry.set("unitfee", (Object)unitFee);
            costRecordEntry.set("processcost", (Object)processCost);
            costRecordEntry.set("unitprocesscost", (Object)unitProcessCost);
            costRecordEntry.set("actualcost", (Object)costRecordEntry.getBigDecimal("processcost").add(costRecordEntry.getBigDecimal("materialcost")).add(costRecordEntry.getBigDecimal("fee")));
            costRecordEntry.set("unitactualcost", (Object)costRecordEntry.getBigDecimal("unitprocesscost").add(costRecordEntry.getBigDecimal("unitmaterialcost")).add(costRecordEntry.getBigDecimal("unitfee")));
        }
    }

    private void updateCostSubElement(Map<Long, DynamicObject> costaccountMap, Set<DynamicObject> costRecordAllSet) {
        String updateActualSql = "update t_cal_costrecord_detail set funitactualcost = ?,factualcost = ? where fentryid = ? and fcostelementid = ? and fcostsubelementid = ?";
        ArrayList<Object[]> actualParamList = new ArrayList<Object[]>(1024);
        HashSet<Long> ids = new HashSet<Long>(16);
        Long[] materialDefualtElements = CostElementHelper.getDefaultMaterialElements();
        Map<String, Long[]> subElementTypeMap = this.getDefaultSubElementTypeMap();
        Set notUpdBalBizType = CommonSettingHelper.getNotUpdBalBizType();
        for (DynamicObject info : costRecordAllSet) {
            ids.add(info.getLong("id"));
            Long costaccountId = info.getDynamicObject(PARAMKEY_COSTACCOUNT).getLong("id");
            DynamicObject costaccount = costaccountMap.get(costaccountId);
            boolean calbycostelement = costaccount.getBoolean("calpolicy.calbycostelement");
            Long biztypeId = info.getLong("biztype_id");
            boolean notUpdBal = notUpdBalBizType.contains(biztypeId);
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                BigDecimal actualCost = entry.getBigDecimal("materialcost");
                BigDecimal unitActualCost = entry.getBigDecimal("unitmaterialcost");
                long entryId = entry.getLong("id");
                long materialCostSubElement = materialDefualtElements[0];
                long materialCostElement = materialDefualtElements[1];
                if (!calbycostelement) {
                    actualCost = entry.getBigDecimal("actualcost");
                    unitActualCost = entry.getBigDecimal("unitactualcost");
                    actualParamList.add(new Object[]{unitActualCost, actualCost, entryId, materialCostElement, materialCostSubElement});
                    continue;
                }
                this.syncSubEleActCost(actualParamList, subElementTypeMap, entry, entryId);
                if (notUpdBal) {
                    Long[] outSourceProcessElements = CostElementHelper.getOutSourceProcessElements();
                    actualParamList.add(new Object[]{unitActualCost, actualCost, entryId, outSourceProcessElements[1], outSourceProcessElements[0]});
                    continue;
                }
                actualParamList.add(new Object[]{unitActualCost, actualCost, entryId, materialCostElement, materialCostSubElement});
            }
        }
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, ids)});){
            ctx.set();
            if (actualParamList.size() > 0) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateActualSql, actualParamList);
            }
        }
    }

    private Collection<DynamicObject> getCalBillRules(String bizbillentityname) {
        QFilter filter = new QFilter("sourcebill.number", "=", (Object)bizbillentityname);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] billRules = BusinessDataServiceHelper.load((String)"cal_calbillrule", (String)CALRULEFIELDS, (QFilter[])filter.toArray());
        HashSet<DynamicObject> billRuleSet = new HashSet<DynamicObject>(billRules.length);
        for (DynamicObject rull : billRules) {
            if (rull == null) continue;
            billRuleSet.add(rull);
        }
        return billRuleSet;
    }

    private Map<String, BigDecimal> getFieldMapping(DynamicObject rule, CalBillInfo calBillInfo, String bizEntityObject, Map<String, Object> param) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(16);
        for (DynamicObject ruleEntry : rule.getDynamicObjectCollection("fieldmap")) {
            String bizFieldName = ruleEntry.getString("sourcefield");
            if (StringUtils.isEmpty((String)bizFieldName) || !param.containsKey(bizFieldName)) continue;
            String calFieldName = ruleEntry.getString("calfield");
            IDataEntityProperty calEntity = calBillInfo.getType().findProperty(calFieldName);
            MainEntityType bizbillentitytype = EntityMetadataCache.getDataEntityType((String)bizEntityObject);
            IDataEntityProperty bizEntity = bizbillentitytype.findProperty(bizFieldName.split("\\.")[0]);
            if (calEntity == null || bizEntity == null) continue;
            IDataEntityType parentyCalEntity = calEntity.getParent();
            IDataEntityType parentBizEntity = bizEntity.getParent();
            if (parentyCalEntity instanceof LinkEntryType || parentBizEntity instanceof LinkEntryType || !(parentyCalEntity instanceof EntryType)) continue;
            resultMap.put(calFieldName, new BigDecimal(String.valueOf(param.get(bizFieldName))));
        }
        return resultMap;
    }

    private BigDecimal convertAmount(BigDecimal amount, boolean isSameLocalCurrency, long billLocalCurrencyId, long localCurrencyId, DynamicObject calBill, DynamicObject costAccount) {
        BigDecimal newAmount = amount;
        BigDecimal exchangeRate = null;
        String convertMode = "1";
        int amtPrecision = costAccount.getInt("calpolicy.currency.amtprecision");
        String convertMode4sourceUSD = null;
        String convertMode4TargetUSD = null;
        BigDecimal exchangeRate4sourceUSD = null;
        BigDecimal exchangeRate4TargetUSD = null;
        if (!isSameLocalCurrency) {
            if (billLocalCurrencyId == 0L) {
                exchangeRate = BigDecimal.ONE;
            } else {
                boolean isIndirect;
                Date date = calBill.getDate("bookdate");
                Date exratedate = calBill.getDate("exratedate");
                if (exratedate != null) {
                    date = exratedate;
                }
                if (isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)billLocalCurrencyId, (Long)localCurrencyId, (Date)date)) {
                    convertMode = "2";
                }
                Object exratetable = costAccount.get("calpolicy.exratetable");
                if (calBill.getLong("exratetable_id") != 0L) {
                    exratetable = calBill.getLong("exratetable_id");
                }
                if (null == (exchangeRate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)billLocalCurrencyId, (Long)localCurrencyId, (Long)Long.valueOf(exratetable.toString()), (Date)date, (boolean)isIndirect))) {
                    boolean isIndirect4sourceUSD = BaseDataServiceHelper.getRateConversionConfig((Long)6L, (Long)localCurrencyId, (Date)date);
                    exchangeRate4sourceUSD = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)6L, (Long)localCurrencyId, (Long)Long.valueOf(exratetable.toString()), (Date)date, (boolean)isIndirect4sourceUSD);
                    convertMode4sourceUSD = "1";
                    if (isIndirect4sourceUSD) {
                        convertMode4sourceUSD = "2";
                    }
                    boolean isIndirect4TargetUSD = BaseDataServiceHelper.getRateConversionConfig((Long)billLocalCurrencyId, (Long)6L, (Date)date);
                    convertMode4TargetUSD = "1";
                    if (isIndirect4TargetUSD) {
                        convertMode4TargetUSD = "2";
                    }
                    exchangeRate4TargetUSD = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)billLocalCurrencyId, (Long)6L, (Long)Long.valueOf(exratetable.toString()), (Date)date, (boolean)isIndirect4TargetUSD);
                }
            }
            newAmount = exchangeRate != null ? this.getTargetAmount(exchangeRate, convertMode, amount, amtPrecision) : this.getTargetAmount(exchangeRate4sourceUSD, convertMode4sourceUSD, this.getTargetAmount(exchangeRate4TargetUSD, convertMode4TargetUSD, amount, amtPrecision), amtPrecision);
        }
        return newAmount;
    }

    private BigDecimal getTargetAmount(BigDecimal exchangeRate, String convertMode, BigDecimal sourceAmount, int amtPrecision) {
        BigDecimal targetAmount = BigDecimal.ZERO;
        if (sourceAmount == null || sourceAmount.compareTo(BigDecimal.ZERO) == 0) {
            return targetAmount;
        }
        if (exchangeRate != null) {
            targetAmount = "1".equals(convertMode) ? sourceAmount.multiply(exchangeRate).setScale(amtPrecision, 4) : sourceAmount.divide(exchangeRate, amtPrecision, 4);
        }
        return targetAmount;
    }

    private Map<String, Long[]> getDefaultSubElementTypeMap() {
        HashMap<String, Long[]> subElementTypeMap = new HashMap<String, Long[]>(16);
        QFilter defaultf = new QFilter("defaultvalue", "=", (Object)Boolean.TRUE);
        QFilter subTypef = new QFilter("type", "in", (Object)new String[]{"002", "005"});
        QFilter q = new QFilter("syncflag", "=", (Object)"1");
        DataSet subElementDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_subelement", (String)"id,type", (QFilter[])new QFilter[]{defaultf, subTypef, q}, null);
        DataSet detailDs = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_elementdetail", (String)"element,subelement", null, null);
        try (DataSet subElementTypeDs = subElementDs.join(detailDs).on("id", "subelement").select(new String[]{"id", "type"}, new String[]{"element"}).finish();){
            for (Row row : subElementTypeDs) {
                subElementTypeMap.put(row.getString("type"), new Long[]{row.getLong("id"), row.getLong("element")});
            }
        }
        return subElementTypeMap;
    }

    private void syncSubEleActCost(List<Object[]> actualParamList, Map<String, Long[]> subElementTypeMap, DynamicObject entry, long entryId) {
        Object[] processSubElement;
        Long[] feeSubElement;
        BigDecimal feeCost = entry.getBigDecimal("fee");
        BigDecimal feeUnitActualCost = entry.getBigDecimal("unitfee");
        if (feeCost.compareTo(BigDecimal.ZERO) != 0 && (feeSubElement = subElementTypeMap.get("002")) != null) {
            actualParamList.add(new Object[]{feeUnitActualCost, feeCost, entryId, feeSubElement[1], feeSubElement[0]});
        }
        BigDecimal processCost = entry.getBigDecimal("processcost");
        BigDecimal processUnitActualCost = entry.getBigDecimal("unitprocesscost");
        if (processUnitActualCost.compareTo(BigDecimal.ZERO) != 0 && (processSubElement = (Object[])subElementTypeMap.get("005")) != null) {
            actualParamList.add(new Object[]{processUnitActualCost, processCost, entryId, processSubElement[1], processSubElement[0]});
        }
    }

    private static class CostElement {
        private Long id;
        private String type;

        private CostElement(Long id, String type) {
            this.id = id;
            this.type = type;
        }
    }

    private static class CostInfo {
        private Long entryid;
        private Long material;
        private Long baseunit;
        private BigDecimal baseqty;
        private boolean calbycostelement;
        private int amtprecision;
        private Long currency;
        private BigDecimal unitActualCost = BigDecimal.ZERO;
        private BigDecimal actualCost = BigDecimal.ZERO;
        private BigDecimal unitMaterialCost = BigDecimal.ZERO;
        private BigDecimal materialCost = BigDecimal.ZERO;
        private BigDecimal unitProcessCost = BigDecimal.ZERO;
        private BigDecimal processCost = BigDecimal.ZERO;
        private BigDecimal unitFee = BigDecimal.ZERO;
        private BigDecimal fee = BigDecimal.ZERO;
        private BigDecimal unitManufactureCost = BigDecimal.ZERO;
        private BigDecimal manufactureCost = BigDecimal.ZERO;
        private BigDecimal unitResource = BigDecimal.ZERO;
        private BigDecimal resource = BigDecimal.ZERO;
        private Map<Long, Object[]> subElementCostMap = new HashMap<Long, Object[]>();
        private String costpricesource;

        private CostInfo() {
        }

        private void setDetailID(Long subElementId, Long detailId) {
            Object[] obj = this.subElementCostMap.get(subElementId);
            if (obj == null) {
                obj = new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, detailId};
                this.subElementCostMap.put(subElementId, obj);
            } else {
                obj[2] = detailId;
            }
        }
    }
}

