/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.AlarmLevel;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.DataCheckTask;
import kd.fi.cal.business.datacheck.DataCheckTaskEntry;
import kd.fi.cal.business.datacheck.DataCheckTaskExecutor;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.mservice.api.DiffActCostIsSameCheckService;

public class DiffActCostIsSameCheckServiceImpl
implements DiffActCostIsSameCheckService {
    public static final Long actCostItemId = 1700755030392542208L;
    public static final Long actCostTaskId = 1701567723173311488L;
    public static final List<Long> groupItemIds = Lists.newArrayList((Object[])new Long[]{1700758642074163200L, 1700759221307544576L});
    public static final Long groupTaskId = 1700776738197444608L;

    public Map<String, String> checkActCostIsSame(Long reportId, Long orgId, Long costAccount, Set<Long> materialIds) {
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        DataCheckParam checkParam = new DataCheckParam();
        checkParam.setCalorg((Set)Sets.newHashSet((Object[])new Long[]{orgId}));
        checkParam.setCostAccount((Set)Sets.newHashSet((Object[])new Long[]{costAccount}));
        checkParam.setMaterial(materialIds);
        DataCheckTask task = new DataCheckTask();
        Map checkItemMap = BusinessDataServiceHelper.loadFromCache((String)"cal_datacheck_item", (String)"plugin,tips", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)actCostItemId)});
        for (Map.Entry checkItemEntry : checkItemMap.entrySet()) {
            DynamicObject checkItem = (DynamicObject)checkItemEntry.getValue();
            Long checkItemId = (Long)checkItemEntry.getKey();
            task.addDataCheckTaskEntry(new DataCheckTaskEntry(checkItemId, checkItem.getString("plugin"), checkItem.getString("tips"), AlarmLevel.WARNING));
        }
        DataSet calOrgSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_org", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray(), null);
        DataSet costAccountSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)costAccount).toArray(), null);
        task.setPlanId(reportId);
        task.setPlanType("cal_task");
        task.setTaskId(actCostTaskId);
        task.setCalorg(this.getNamesString(calOrgSet));
        task.setCostaccount(this.getNamesString(costAccountSet));
        task.setPurpose("E");
        DataCheckTaskExecutor executor = new DataCheckTaskExecutor();
        executor.commitSync(task, checkParam);
        resultMap.put("success", this.getCheckStatus(reportId));
        return resultMap;
    }

    private void triggerGroupCheck(Long reportId, Long orgId, Long costAccount) {
        DataCheckParam checkParam = new DataCheckParam();
        checkParam.setCalorg((Set)Sets.newHashSet((Object[])new Long[]{orgId}));
        checkParam.setCostAccount((Set)Sets.newHashSet((Object[])new Long[]{costAccount}));
        DataCheckTask task = new DataCheckTask();
        Map checkItemMap = BusinessDataServiceHelper.loadFromCache((String)"cal_datacheck_item", (String)"plugin,tips", (QFilter[])new QFilter[]{new QFilter("id", "in", groupItemIds)});
        for (Map.Entry checkItemEntry : checkItemMap.entrySet()) {
            DynamicObject checkItem = (DynamicObject)checkItemEntry.getValue();
            Long checkItemId = (Long)checkItemEntry.getKey();
            task.addDataCheckTaskEntry(new DataCheckTaskEntry(checkItemId, checkItem.getString("plugin"), checkItem.getString("tips"), AlarmLevel.WARNING));
        }
        DataSet calOrgSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_org", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray(), null);
        DataSet costAccountSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)costAccount).toArray(), null);
        task.setPlanId(reportId);
        task.setPlanType("cal_task");
        task.setTaskId(groupTaskId);
        task.setCalorg(this.getNamesString(calOrgSet));
        task.setCostaccount(this.getNamesString(costAccountSet));
        task.setPurpose("E");
        DataCheckTaskExecutor executor = new DataCheckTaskExecutor();
        executor.commitSync(task, checkParam);
    }

    private String getNamesString(DataSet dataSet) {
        StringBuilder names = new StringBuilder();
        for (Row row : dataSet) {
            names.append(row.getString("name"));
            names.append(',');
        }
        String nameString = CommonUtils.trimComma((String)names.toString());
        if (nameString.length() > 254) {
            nameString = nameString.substring(0, 254);
            return CommonUtils.trimComma((String)nameString);
        }
        return nameString;
    }

    private String getCheckStatus(Long reportId) {
        String flag = "true";
        QFilter q = new QFilter("checkplan", "=", (Object)reportId);
        q.and("checktask", "=", (Object)actCostTaskId);
        DataSet checkResultDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_datacheck_result", (String)"id,entryentity.entrystatus", (QFilter[])q.toArray(), null);
        for (Row row : checkResultDataSet) {
            String status = row.getString("entryentity.entrystatus");
            if ("D".equals(status)) continue;
            flag = "false";
            break;
        }
        return flag;
    }
}

