/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.util.CommonUtils;

public class FiApVoucherWriteBack {
    private static final Log logger = LogFactory.getLog(FiApVoucherWriteBack.class);
    private String voucherOperationValue;
    private Map<Long, Set<Long>> voucherBillMap;
    private Set<Long> recordAllIdSet = new HashSet<Long>(16);
    private Set<Long> recordChargeOffCostIdSet = new HashSet<Long>(16);
    private Map<Long, String> voucherNumMap;
    private Set<String> hasDapVouTypeIdStrs = new HashSet<String>(16);

    public void fiApWriteBack(String voucherOperationValue, Set<Long> ids, long voucherid, String voucherNumber) {
        HashMap<Long, Set<Long>> voucherBillMap = new HashMap<Long, Set<Long>>(8);
        voucherBillMap.put(voucherid, ids);
        HashMap<Long, String> voucherNumMap = new HashMap<Long, String>(8);
        voucherNumMap.put(voucherid, voucherNumber);
        this.batchFiApWriteBack(voucherOperationValue, voucherBillMap, voucherNumMap);
    }

    public void batchFiApWriteBack(String voucherOperationValue, Map<Long, Set<Long>> voucherBillMap, Map<Long, String> voucherNumMap) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.doBatchFiApWriteBack(voucherOperationValue, voucherBillMap, voucherNumMap);
            }
            catch (Throwable e) {
                tx.markRollback();
                logger.error("FiApVoucherWriteBack-batchFiApWriteBack", e);
                throw e;
            }
        }
    }

    private void doBatchFiApWriteBack(String voucherOperationValue, Map<Long, Set<Long>> voucherBillMap, Map<Long, String> voucherNumMap) {
        long startTime = TimeServiceHelper.now().getTime();
        this.voucherNumMap = voucherNumMap;
        this.voucherBillMap = voucherBillMap;
        this.voucherOperationValue = voucherOperationValue;
        if ("7".equals(this.voucherOperationValue)) {
            this.voucherOperationValue = "1";
        }
        this.hasDapVouTypeIdStrs = this.getDbDapVouTypeIdStrSet();
        HashSet<Long> srcApBillIdSet = new HashSet<Long>(16);
        for (Set<Long> set : this.voucherBillMap.values()) {
            srcApBillIdSet.addAll(set);
        }
        HashSet<Long> apBillIds = new HashSet<Long>(16);
        HashSet<Long> chargeOffedApBillIds = new HashSet<Long>(16);
        HashMap<Long, Long> apfinapbillSouMap = new HashMap<Long, Long>(16);
        this.splitApBillIds(srcApBillIdSet, apBillIds, chargeOffedApBillIds, apfinapbillSouMap);
        Map<Long, Set<Long>> notChargeOffVouIdCostRecIdsMap = this.getNotChargeOffVouIdCostRecIdsMap(apBillIds);
        this.doWriteBack(notChargeOffVouIdCostRecIdsMap, false, apfinapbillSouMap);
        Map<Long, Set<Long>> chargeOffVouIdCostRecIdsMap = this.getChargeOffVouIdCostRecIdsMap(chargeOffedApBillIds);
        this.doWriteBack(chargeOffVouIdCostRecIdsMap, true, apfinapbillSouMap);
        logger.info("fiApWriteBack-\u51c6\u5907\u6570\u636e\u8017\u65f6\uff1a" + (TimeServiceHelper.now().getTime() - startTime) + "ms");
    }

    private void splitApBillIds(Set<Long> srcApBillIdSet, Set<Long> apBillIds, Set<Long> chargeOffedApBillIds, Map<Long, Long> apfinapbillSouMap) {
        QFilter billIdF = new QFilter("id", "in", srcApBillIdSet);
        DataSet apBillDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ap_finapbill", (String)"id,iswrittenoff,sourcebillid", (QFilter[])new QFilter[]{billIdF}, null);
        for (Row row : apBillDs) {
            Long billId = row.getLong("id");
            Long sourcebillid = row.getLong("sourcebillid");
            if (row.getBoolean("iswrittenoff").booleanValue()) {
                chargeOffedApBillIds.add(billId);
                apfinapbillSouMap.put(sourcebillid, billId);
                continue;
            }
            apBillIds.add(billId);
        }
    }

    private Map<Long, Set<Long>> getChargeOffVouIdCostRecIdsMap(Set<Long> apBillIdSet) {
        Map<Long, Set<Long>> vouIdCostRecIdsMap = new HashMap<Long, Set<Long>>(16);
        if (apBillIdSet.isEmpty()) {
            return vouIdCostRecIdsMap;
        }
        Map<Long, Set<Long>> chargeOffApBillIdsMap = this.getChargeOffApBillIds(apBillIdSet);
        HashSet<Long> allChargeOffedApIds = new HashSet<Long>(16);
        for (Set<Long> chargeOffedApIds : chargeOffApBillIdsMap.values()) {
            allChargeOffedApIds.addAll(chargeOffedApIds);
        }
        HashSet<Long> purBillIds = new HashSet<Long>(16);
        Map<Long, Set<Long>> chargeOffedApIdWfRecIds = this.getChargeOffedApIdWfRecIdsMap(allChargeOffedApIds, purBillIds);
        HashSet<Long> allChargeOffedRecIds = new HashSet<Long>(16);
        for (Set<Long> wfRecIds : chargeOffedApIdWfRecIds.values()) {
            allChargeOffedRecIds.addAll(wfRecIds);
        }
        HashMap<Long, Set<Long>> wfRecIdCostRecIdsMap = new HashMap<Long, Set<Long>>(16);
        Set<Long> recordAllIdSet = this.getChargeOffCostRecIdsAndWfRecMap(allChargeOffedRecIds, purBillIds, wfRecIdCostRecIdsMap);
        this.recordAllIdSet = recordAllIdSet;
        if (wfRecIdCostRecIdsMap.isEmpty()) {
            return vouIdCostRecIdsMap;
        }
        Map<Long, Set<Long>> apBillIdWfRecIdsMap = this.getChargeOffApIdRecIdsMap(chargeOffApBillIdsMap, chargeOffedApIdWfRecIds);
        vouIdCostRecIdsMap = this.getVouIdCostRecIdMap(apBillIdWfRecIdsMap, wfRecIdCostRecIdsMap);
        return vouIdCostRecIdsMap;
    }

    private Map<Long, Set<Long>> getChargeOffApIdRecIdsMap(Map<Long, Set<Long>> chargeOffApBillIdsMap, Map<Long, Set<Long>> chargeOffedApIdWfRecIds) {
        HashMap<Long, Set<Long>> apBillIdWfRecIdsMap = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry<Long, Set<Long>> entry : chargeOffApBillIdsMap.entrySet()) {
            Long chargeOffApId = entry.getKey();
            Set<Long> chargeOffedApIds = entry.getValue();
            Set wfRecIds = apBillIdWfRecIdsMap.computeIfAbsent(chargeOffApId, k -> new HashSet(16));
            for (Long chargeOffedApId : chargeOffedApIds) {
                Set<Long> chargeOffedWfRecIds = chargeOffedApIdWfRecIds.get(chargeOffedApId);
                if (chargeOffedWfRecIds == null || chargeOffedWfRecIds.isEmpty()) continue;
                wfRecIds.addAll(chargeOffedWfRecIds);
            }
        }
        return apBillIdWfRecIdsMap;
    }

    private Map<Long, Set<Long>> getChargeOffedApIdWfRecIdsMap(Set<Long> allChargeOffedApIds, Set<Long> purBillIds) {
        HashMap<Long, Set<Long>> chargeOffedApIdWfRecIds = new HashMap<Long, Set<Long>>(16);
        QFilter chargeOffAssBillIdF = new QFilter("entry.e_billid", "in", allChargeOffedApIds);
        HashSet<String> billtypeSet = new HashSet<String>(16);
        billtypeSet.add("im_purinbill");
        billtypeSet.add("im_mdc_ominbill");
        billtypeSet.add("im_ospurinbill");
        QFilter mainBillTypeF = new QFilter("billtype", "in", billtypeSet);
        QFilter chargeOffassBillTypeF = new QFilter("entry.e_billtype", "=", (Object)"ap_finapbill");
        QFilter chargeOffedF = new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{chargeOffAssBillIdF, mainBillTypeF, chargeOffassBillTypeF, chargeOffedF};
        DataSet chargeOffDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ap_verifyrecord", (String)"id,billid,entry.e_billid as e_billid", (QFilter[])filters, null);
        for (Row row : chargeOffDs) {
            Set chargeOffedWfRecIds = chargeOffedApIdWfRecIds.computeIfAbsent(row.getLong("e_billid"), k -> new HashSet(16));
            chargeOffedWfRecIds.add(row.getLong("id"));
            purBillIds.add(row.getLong("billid"));
        }
        return chargeOffedApIdWfRecIds;
    }

    private Map<Long, Set<Long>> getChargeOffApBillIds(Set<Long> apBillIdSet) {
        HashMap<Long, Set<Long>> chargeOffApBillIdsMap = new HashMap<Long, Set<Long>>(16);
        QFilter assBillIdF = new QFilter("entry.e_billid", "in", apBillIdSet);
        QFilter billTypeF = new QFilter("billtype", "=", (Object)"ap_finapbill");
        QFilter assBillTypeF = new QFilter("entry.e_billtype", "=", (Object)"ap_finapbill");
        DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ap_verifyrecord", (String)"billid,entry.e_billid as e_billid", (QFilter[])new QFilter[]{assBillIdF, billTypeF, assBillTypeF}, null);
        for (Row row : billDs) {
            Set chargeOffedApIds = chargeOffApBillIdsMap.computeIfAbsent(row.getLong("e_billid"), k -> new HashSet(16));
            chargeOffedApIds.add(row.getLong("billid"));
        }
        return chargeOffApBillIdsMap;
    }

    private Map<Long, Set<Long>> getNotChargeOffVouIdCostRecIdsMap(Set<Long> apBillIdSet) {
        Map<Long, Set<Long>> vouIdCostRecIdsMap = new HashMap<Long, Set<Long>>(16);
        if (apBillIdSet.isEmpty()) {
            return vouIdCostRecIdsMap;
        }
        HashMap<Long, Set<Long>> apBillIdWfRecIdsMap = new HashMap<Long, Set<Long>>(16);
        HashSet<Long> writeOffAllIdSet = new HashSet<Long>(16);
        HashSet<Long> mainBillIdSet = new HashSet<Long>(16);
        this.getWriteOffIdAndPurInIds(apBillIdSet, apBillIdWfRecIdsMap, writeOffAllIdSet, mainBillIdSet);
        if (writeOffAllIdSet.isEmpty()) {
            return vouIdCostRecIdsMap;
        }
        HashMap<Long, Set<Long>> wfRecIdCostRecIdsMap = new HashMap<Long, Set<Long>>(writeOffAllIdSet.size());
        Set<Long> recordAllIdSet = this.getCostRecIdsAndWfRecMap(writeOffAllIdSet, mainBillIdSet, wfRecIdCostRecIdsMap, false);
        this.recordAllIdSet = recordAllIdSet;
        if (wfRecIdCostRecIdsMap.isEmpty()) {
            return vouIdCostRecIdsMap;
        }
        vouIdCostRecIdsMap = this.getVouIdCostRecIdMap(apBillIdWfRecIdsMap, wfRecIdCostRecIdsMap);
        return vouIdCostRecIdsMap;
    }

    private void doWriteBack(Map<Long, Set<Long>> vouIdCostRecIdsMap, boolean isChargeOff, Map<Long, Long> apfinapbillSouMap) {
        if (vouIdCostRecIdsMap.isEmpty()) {
            logger.info("fiApWriteBack-doWriteBack-\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        Long startTime = TimeServiceHelper.now().getTime();
        logger.info("fiApWriteBack-doWriteBack- start");
        Map<Long, DynamicObject> voucherIdVouInfoDycMap = this.getVouIdVouInfoMap();
        Map<Long, Set<Long>> voucherAdjustBillIdsMap = this.getVouAdjIdsMap(vouIdCostRecIdsMap, isChargeOff, apfinapbillSouMap);
        HashSet<DynamicObject> needAddDapTrackSet = new HashSet<DynamicObject>(this.voucherBillMap.size());
        HashSet<DynamicObject> needAddCalVoucherSet = new HashSet<DynamicObject>(this.voucherBillMap.size());
        ArrayList<Object[]> updateCostRecParamList = new ArrayList<Object[]>(this.recordAllIdSet.size());
        int costRecordSize = this.recordAllIdSet.size();
        String voucherOperation = this.getVoucherOperationName();
        Map.Entry<Long, String> firstVoucher = this.voucherNumMap.entrySet().iterator().next();
        logger.info("fiApWriteBack-\u5f00\u59cb" + voucherOperation + "\u53cd\u5199\uff0c\u51ed\u8bc1id\u4e3a" + firstVoucher.getKey() + ",\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5355\u91cf\u4e3a" + costRecordSize + "\u6761\uff1a");
        Set<Long> needDelVouIds = this.collectUpdateData(vouIdCostRecIdsMap, voucherIdVouInfoDycMap, needAddDapTrackSet, needAddCalVoucherSet, updateCostRecParamList);
        this.updateCostRec2Db(needDelVouIds, needAddDapTrackSet, needAddCalVoucherSet, updateCostRecParamList);
        this.batchCostAdjustWriteBack(voucherAdjustBillIdsMap, voucherIdVouInfoDycMap, true);
        logger.info("fiApWriteBack-\u7ed3\u675f" + voucherOperation + "\u53cd\u5199\uff0c\u51ed\u8bc1id\u4e3a" + firstVoucher.getKey() + "\uff0c\u5355\u91cf\u4e3a" + costRecordSize + "\u6761\uff0c\u8017\u65f6\uff1a" + (TimeServiceHelper.now().getTime() - startTime) + "ms");
    }

    private Set<Long> getCostRecIdsAndWfRecMap(Set<Long> writeOffAllIdSet, Set<Long> mainBillIdSet, Map<Long, Set<Long>> writeOffIdCostRecIdMap, boolean isChargeOffed) {
        HashSet<Long> recordAllIdSet = new HashSet<Long>(writeOffAllIdSet.size());
        QFilter q = new QFilter("entry.writeoffid", "in", writeOffAllIdSet);
        q.and("dischargetype", "in", (Object)new String[]{"A", "B"});
        q.and("bizbillid", "in", mainBillIdSet);
        q.and("ischargeoff", "=", (Object)isChargeOffed);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,entry.writeoffid", (QFilter[])new QFilter[]{q}, null);){
            for (Row row : dataSet) {
                recordAllIdSet.add(row.getLong("id"));
                Set<Long> records = writeOffIdCostRecIdMap.get(row.getLong("entry.writeoffid"));
                if (records == null) {
                    records = new HashSet<Long>(16);
                    writeOffIdCostRecIdMap.put(row.getLong("entry.writeoffid"), records);
                }
                records.add(row.getLong("id"));
            }
        }
        return recordAllIdSet;
    }

    private Set<Long> getChargeOffCostRecIdsAndWfRecMap(Set<Long> writeOffAllIdSet, Set<Long> mainBillIdSet, Map<Long, Set<Long>> writeOffIdCostRecIdMap) {
        HashSet<Long> recordAllIdSet = new HashSet<Long>(writeOffAllIdSet.size());
        QFilter q = new QFilter("entry.writeoffid", "in", writeOffAllIdSet);
        q.and("dischargetype", "in", (Object)new String[]{"A", "B"});
        q.and("bizbillid", "in", mainBillIdSet);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,entry.writeoffid,ischargeoff", (QFilter[])new QFilter[]{q}, null);){
            for (Row row : dataSet) {
                boolean ischargeoff = row.getBoolean("ischargeoff");
                if (ischargeoff) {
                    recordAllIdSet.add(row.getLong("id"));
                    Set<Long> records = writeOffIdCostRecIdMap.get(row.getLong("entry.writeoffid"));
                    if (records == null) {
                        records = new HashSet<Long>(16);
                        writeOffIdCostRecIdMap.put(row.getLong("entry.writeoffid"), records);
                    }
                    records.add(row.getLong("id"));
                    continue;
                }
                this.recordChargeOffCostIdSet.add(row.getLong("id"));
            }
        }
        return recordAllIdSet;
    }

    private void updateCostRec2Db(Set<Long> delVouchers, Set<DynamicObject> dapTrackSet, Set<DynamicObject> calVoucherSet, List<Object[]> paramList) {
        block83: {
            block84: {
                Throwable throwable;
                TXHandle h1;
                List splitList;
                block82: {
                    Throwable throwable2;
                    TXHandle h12;
                    List splitList2;
                    if (!"1".equals(this.voucherOperationValue)) break block82;
                    if (!paramList.isEmpty()) {
                        splitList2 = CommonUtils.getSplitList(paramList);
                        for (List list : splitList2) {
                            h12 = TX.requiresNew();
                            throwable2 = null;
                            try {
                                String updateSql = "update t_cal_calcostrecord set fisfivoucher = '1',ffivouchernum = ?,ffivoucherid = ? where fid = ?";
                                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateSql, (List)list);
                            }
                            catch (Throwable updateSql) {
                                throwable2 = updateSql;
                                throw updateSql;
                            }
                            finally {
                                if (h12 == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        h12.close();
                                    }
                                    catch (Throwable updateSql) {
                                        throwable2.addSuppressed(updateSql);
                                    }
                                    continue;
                                }
                                h12.close();
                            }
                        }
                    }
                    if (!dapTrackSet.isEmpty()) {
                        splitList2 = CommonUtils.getSplitDynList(dapTrackSet);
                        for (Set set : splitList2) {
                            h12 = TX.requiresNew();
                            throwable2 = null;
                            try {
                                SaveServiceHelper.save((DynamicObject[])set.toArray(new DynamicObject[0]));
                            }
                            catch (Throwable updateSql) {
                                throwable2 = updateSql;
                                throw updateSql;
                            }
                            finally {
                                if (h12 == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        h12.close();
                                    }
                                    catch (Throwable updateSql) {
                                        throwable2.addSuppressed(updateSql);
                                    }
                                    continue;
                                }
                                h12.close();
                            }
                        }
                    }
                    if (!calVoucherSet.isEmpty()) {
                        splitList2 = CommonUtils.getSplitDynList(calVoucherSet);
                        for (Set set : splitList2) {
                            h12 = TX.requiresNew();
                            throwable2 = null;
                            try {
                                SaveServiceHelper.save((DynamicObject[])set.toArray(new DynamicObject[0]));
                            }
                            catch (Throwable updateSql) {
                                throwable2 = updateSql;
                                throw updateSql;
                            }
                            finally {
                                if (h12 == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        h12.close();
                                    }
                                    catch (Throwable updateSql) {
                                        throwable2.addSuppressed(updateSql);
                                    }
                                    continue;
                                }
                                h12.close();
                            }
                        }
                    }
                    if (this.recordAllIdSet.isEmpty()) break block83;
                    splitList2 = CommonUtils.getSplitList(this.recordAllIdSet);
                    for (Set set : splitList2) {
                        h12 = TX.requiresNew();
                        throwable2 = null;
                        try {
                            this.writeBackIsVoucherSelect(set);
                        }
                        catch (Throwable updateSql) {
                            throwable2 = updateSql;
                            throw updateSql;
                        }
                        finally {
                            if (h12 == null) continue;
                            if (throwable2 != null) {
                                try {
                                    h12.close();
                                }
                                catch (Throwable updateSql) {
                                    throwable2.addSuppressed(updateSql);
                                }
                                continue;
                            }
                            h12.close();
                        }
                    }
                    break block83;
                }
                if (!"2".equals(this.voucherOperationValue)) break block84;
                if (!delVouchers.isEmpty()) {
                    splitList = CommonUtils.getSplitList(delVouchers);
                    for (Set set : splitList) {
                        h1 = TX.requiresNew();
                        throwable = null;
                        try {
                            this.delCalVouchers(set);
                        }
                        catch (Throwable updateSql) {
                            throwable = updateSql;
                            throw updateSql;
                        }
                        finally {
                            if (h1 == null) continue;
                            if (throwable != null) {
                                try {
                                    h1.close();
                                }
                                catch (Throwable updateSql) {
                                    throwable.addSuppressed(updateSql);
                                }
                                continue;
                            }
                            h1.close();
                        }
                    }
                }
                if (this.recordAllIdSet.isEmpty()) break block83;
                splitList = CommonUtils.getSplitList(this.recordAllIdSet);
                for (Set set : splitList) {
                    h1 = TX.requiresNew();
                    throwable = null;
                    try {
                        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_calcostrecord set fisfivoucher = '0',ffivouchernum = ' ',ffivoucherid = 0 where fid in (" + StringUtils.join((Object[])set.toArray(), (char)',') + ")"));
                        this.writeBackIsVoucherUncheck(set);
                    }
                    catch (Throwable updateSql) {
                        throwable = updateSql;
                        throw updateSql;
                    }
                    finally {
                        if (h1 == null) continue;
                        if (throwable != null) {
                            try {
                                h1.close();
                            }
                            catch (Throwable updateSql) {
                                throwable.addSuppressed(updateSql);
                            }
                            continue;
                        }
                        h1.close();
                    }
                }
                break block83;
            }
            if (!paramList.isEmpty()) {
                List splitList = CommonUtils.getSplitList(paramList);
                for (List list : splitList) {
                    TXHandle h1 = TX.requiresNew();
                    Throwable throwable = null;
                    try {
                        String updateSql = "update t_cal_calcostrecord set ffivouchernum = ? where fid = ?";
                        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateSql, (List)list);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (h1 == null) continue;
                        if (throwable != null) {
                            try {
                                h1.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        h1.close();
                    }
                }
            }
        }
    }

    private Set<Long> collectUpdateData(Map<Long, Set<Long>> voucherRecordIdsMap, Map<Long, DynamicObject> voucherMap, Set<DynamicObject> dapTrackSet, Set<DynamicObject> calVoucherSet, List<Object[]> paramList) {
        HashSet<Long> delVouchers = new HashSet<Long>(this.voucherBillMap.size());
        Map<Long, Set<DynamicObject>> voucherRecordInfosMap = this.getVouIdCostRecInfoMap(voucherRecordIdsMap);
        Set<String> hasVoucherSet = this.getDbVouRecIdStrSet();
        for (Map.Entry<Long, Set<Long>> entry : this.voucherBillMap.entrySet()) {
            Long voucherid = entry.getKey();
            String voucherNumber = this.voucherNumMap.get(voucherid);
            Set<Long> recordIdSet = voucherRecordIdsMap.get(voucherid);
            Set<DynamicObject> costRecords = voucherRecordInfosMap.get(voucherid);
            if (recordIdSet == null || recordIdSet.isEmpty()) continue;
            if ("1".equals(this.voucherOperationValue)) {
                DynamicObject voucher = voucherMap.get(voucherid);
                for (Long recordId : recordIdSet) {
                    paramList.add(new Object[]{voucher.get("billno"), voucher.getPkValue(), recordId});
                }
                dapTrackSet.addAll(this.getDapTracks("cal_costrecord_subentity", voucher, recordIdSet));
                calVoucherSet.addAll(this.getCalVouchers(costRecords, hasVoucherSet, voucher, "C", "A"));
                continue;
            }
            if ("2".equals(this.voucherOperationValue)) {
                delVouchers.add(voucherid);
                continue;
            }
            for (Long recordId : recordIdSet) {
                paramList.add(new Object[]{voucherNumber, recordId});
            }
        }
        return delVouchers;
    }

    private Set<String> getDbDapVouTypeIdStrSet() {
        HashSet<String> hasDapVouTypeIdStrs = new HashSet<String>(16);
        if ("2".equals(this.voucherOperationValue)) {
            return hasDapVouTypeIdStrs;
        }
        QFilter vouIdF = new QFilter("voucherid", "in", this.voucherBillMap.keySet());
        QFilter billTypeF = new QFilter("billType", "in", (Object)new String[]{"cal_costrecord_subentity", "cal_costrecord", "cal_costadjust_subentity", "cal_costadjustbill"});
        DataSet hasDapDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ai_daptracker", (String)"voucherid,billType,sourcebillid", (QFilter[])new QFilter[]{vouIdF, billTypeF}, null);
        for (Row row : hasDapDs) {
            Long vouId = row.getLong("voucherid");
            String billType = row.getString("billType");
            Long billId = row.getLong("sourcebillid");
            String VouTypeIdStr = vouId + billType + billId;
            hasDapVouTypeIdStrs.add(VouTypeIdStr);
        }
        return hasDapVouTypeIdStrs;
    }

    private String getVoucherOperationName() {
        String voucherOperation = "";
        if ("1".equals(this.voucherOperationValue)) {
            voucherOperation = ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1", (String)"VoucherWriteBackServiceImpl_1", (String)"fi-cal-mservice", (Object[])new Object[0]);
        } else if ("2".equals(this.voucherOperationValue)) {
            voucherOperation = ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1", (String)"VoucherWriteBackServiceImpl_2", (String)"fi-cal-mservice", (Object[])new Object[0]);
        }
        return voucherOperation;
    }

    private Map<Long, Set<Long>> getVouAdjIdsMap(Map<Long, Set<Long>> voucherRecordIdsMap, boolean isChargeOff, Map<Long, Long> apfinapbillSouMap) {
        HashMap<Long, Set<Long>> voucherAdjustBillIdsMap = new HashMap<Long, Set<Long>>(voucherRecordIdsMap.size());
        HashMap<Long, Long> recordAdjustIdMap = new HashMap<Long, Long>(16);
        HashMap appAdjustBillIdsMap = new HashMap(voucherRecordIdsMap.size());
        if (isChargeOff) {
            QFilter q = new QFilter("entryentity.invbillid", "in", this.recordChargeOffCostIdSet);
            q.and("ischargeoff", "=", (Object)isChargeOff);
            Throwable throwable = null;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjustbill", (String)"id,entryentity.invbillid,entryentity.srcbillid", (QFilter[])new QFilter[]{q}, (String)null);){
                Iterator iterator = dataSet.iterator();
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    recordAdjustIdMap.put(row.getLong("entryentity.invbillid"), row.getLong("id"));
                    Long id = row.getLong("id");
                    Long srcbillid = row.getLong("entryentity.srcbillid");
                    if (!appAdjustBillIdsMap.containsKey(srcbillid)) {
                        HashSet<Long> hashSet = new HashSet<Long>(10);
                        hashSet.add(id);
                        appAdjustBillIdsMap.put(srcbillid, hashSet);
                        continue;
                    }
                    ((Set)appAdjustBillIdsMap.get(srcbillid)).add(id);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            for (Map.Entry entry : appAdjustBillIdsMap.entrySet()) {
                Set adjustIds = (Set)entry.getValue();
                Long appid = (Long)entry.getKey();
                Long tarappid = apfinapbillSouMap.get(appid);
                for (Map.Entry entry2 : this.voucherBillMap.entrySet()) {
                    Set appids = (Set)entry2.getValue();
                    if (appids == null || !appids.contains(tarappid)) continue;
                    voucherAdjustBillIdsMap.put((Long)entry2.getKey(), adjustIds);
                }
            }
        } else {
            QFilter q = new QFilter("entryentity.invbillid", "in", this.recordAllIdSet);
            q.and("ischargeoff", "=", (Object)isChargeOff);
            Throwable throwable = null;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjustbill", (String)"id,entryentity.invbillid", (QFilter[])new QFilter[]{q}, null);){
                for (Row row : dataSet) {
                    recordAdjustIdMap.put(row.getLong("entryentity.invbillid"), row.getLong("id"));
                }
            }
            catch (Throwable adjustIds) {
                Throwable throwable4 = adjustIds;
                throw adjustIds;
            }
            for (Map.Entry<Long, Set<Long>> entry : voucherRecordIdsMap.entrySet()) {
                Set<Long> costRecordIds = entry.getValue();
                HashSet<Long> costAdjustIds = new HashSet<Long>(costRecordIds.size());
                for (Long costRecordId : costRecordIds) {
                    Long l = (Long)recordAdjustIdMap.get(costRecordId);
                    if (l == null) continue;
                    costAdjustIds.add(l);
                }
                voucherAdjustBillIdsMap.put(entry.getKey(), costAdjustIds);
            }
        }
        return voucherAdjustBillIdsMap;
    }

    private Set<String> getDbVouRecIdStrSet() {
        HashSet<String> hasVoucherSet = new HashSet<String>(16);
        QFilter q = new QFilter("voucherid", "in", this.voucherBillMap.keySet());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_voucher", (String)"voucherid,vouchertype,id,costrecordid", (QFilter[])new QFilter[]{q}, null);){
            for (Row row : dataSet) {
                String key = String.valueOf(row.getLong("voucherid")) + "_" + String.valueOf(row.getLong("costrecordid"));
                hasVoucherSet.add(key);
            }
        }
        return hasVoucherSet;
    }

    private Map<Long, DynamicObject> getVouIdVouInfoMap() {
        HashMap<Long, DynamicObject> voucherMap = new HashMap<Long, DynamicObject>(this.voucherBillMap.size());
        if (!"2".equals(this.voucherOperationValue)) {
            DynamicObject[] vouchers;
            for (DynamicObject voucher : vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,billno,org,booktype,bizdate,bookeddate,createtime,vouchertype,period.periodyear,period.periodnumber", (QFilter[])new QFilter("id", "in", this.voucherBillMap.keySet()).toArray())) {
                voucherMap.put(voucher.getLong("id"), voucher);
            }
        }
        return voucherMap;
    }

    private Map<Long, Set<DynamicObject>> getVouIdCostRecInfoMap(Map<Long, Set<Long>> voucherRecordIdsMap) {
        HashMap<Long, Set<DynamicObject>> voucherRecordInfosMap = new HashMap<Long, Set<DynamicObject>>(16);
        HashMap<Long, DynamicObject> costRecordMap = new HashMap<Long, DynamicObject>(32);
        DynamicObjectCollection allCostRecords = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,vouchertype,bizentityobject,calorg,costaccount,dischargetype", (QFilter[])new QFilter[]{new QFilter("id", "in", this.recordAllIdSet)});
        for (DynamicObject info : allCostRecords) {
            costRecordMap.put(info.getLong("id"), info);
        }
        for (Map.Entry<Long, Set<Long>> entry : voucherRecordIdsMap.entrySet()) {
            Long voucherId = entry.getKey();
            Set<Long> billIds = entry.getValue();
            HashSet<DynamicObject> billSet = new HashSet<DynamicObject>(billIds.size());
            for (Long id : billIds) {
                DynamicObject billInfo = (DynamicObject)costRecordMap.get(id);
                if (billInfo == null) continue;
                billSet.add(billInfo);
            }
            voucherRecordInfosMap.put(voucherId, billSet);
        }
        return voucherRecordInfosMap;
    }

    private Map<Long, Set<Long>> getVouIdCostRecIdMap(Map<Long, Set<Long>> apBillWriteRecordMap, Map<Long, Set<Long>> writeOffRecordMap) {
        HashMap<Long, Set<Long>> voucherRecordIdsMap = new HashMap<Long, Set<Long>>(this.voucherBillMap.size());
        for (Map.Entry<Long, Set<Long>> entry : this.voucherBillMap.entrySet()) {
            Set<Long> apBillIds = entry.getValue();
            HashSet<Long> recordIds = new HashSet<Long>(16);
            for (Long apBillId : apBillIds) {
                Set<Long> writeOffIds = apBillWriteRecordMap.get(apBillId);
                if (writeOffIds == null) continue;
                for (Long writeOffId : writeOffIds) {
                    Set<Long> recordIdSet = writeOffRecordMap.get(writeOffId);
                    if (recordIdSet == null) continue;
                    recordIds.addAll(recordIdSet);
                }
            }
            voucherRecordIdsMap.put(entry.getKey(), recordIds);
        }
        return voucherRecordIdsMap;
    }

    private void getWriteOffIdAndPurInIds(Set<Long> apBillIdSet, Map<Long, Set<Long>> apBillIdWfRecIdsMap, Set<Long> writeOffAllIdSet, Set<Long> mainBillIdSet) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ap_verifyrecord", (String)"id,billid,entry.e_billid", (QFilter[])new QFilter[]{new QFilter("entry.e_billid", "in", apBillIdSet)}, null);){
            for (Row row : dataSet) {
                Set<Long> writeOffIdSet = apBillIdWfRecIdsMap.get(row.getLong("entry.e_billid"));
                if (writeOffIdSet == null) {
                    writeOffIdSet = new HashSet<Long>(16);
                    apBillIdWfRecIdsMap.put(row.getLong("entry.e_billid"), writeOffIdSet);
                }
                writeOffIdSet.add(row.getLong("id"));
                writeOffAllIdSet.add(row.getLong("id"));
                mainBillIdSet.add(row.getLong("billid"));
            }
        }
    }

    private Set<DynamicObject> getDapTracks(String billType, DynamicObject voucher, Set set) {
        HashSet<DynamicObject> trackersToSave = new HashSet<DynamicObject>(set.size());
        for (Object id : set) {
            Object vouId = voucher.getPkValue();
            String vouTypeIdStr = vouId + billType + id;
            if (this.hasDapVouTypeIdStrs.contains(vouTypeIdStr)) continue;
            DynamicObject daptracker = BusinessDataServiceHelper.newDynamicObject((String)"ai_daptracker");
            daptracker.set("billtype", (Object)billType);
            daptracker.set("sourcebillid", id);
            daptracker.set("createdate", (Object)new Date());
            daptracker.set("voucherid", voucher.getPkValue());
            daptracker.set("org", voucher.get("org"));
            daptracker.set("booktype", voucher.get("booktype"));
            trackersToSave.add(daptracker);
        }
        return trackersToSave;
    }

    public void batchCostAdjustWriteBack(Map<Long, Set<Long>> voucherAdjustBillIdsMap) {
        Map<Long, DynamicObject> voucherMap = this.getVouIdVouInfoMap();
        this.batchCostAdjustWriteBack(voucherAdjustBillIdsMap, voucherMap, false);
    }

    private void batchCostAdjustWriteBack(Map<Long, Set<Long>> voucherAdjustBillIdsMap, Map<Long, DynamicObject> voucherMap, boolean isAddDap) {
        block53: {
            Throwable throwable;
            TXHandle h1;
            List splitList;
            ArrayList<Object[]> paramList;
            block54: {
                HashSet<Long> allAdjustIds;
                block52: {
                    paramList = new ArrayList<Object[]>(voucherAdjustBillIdsMap.size());
                    HashSet<DynamicObject> dapTracks = new HashSet<DynamicObject>(voucherAdjustBillIdsMap.size());
                    allAdjustIds = new HashSet<Long>(voucherAdjustBillIdsMap.size());
                    for (Set<Long> set : voucherAdjustBillIdsMap.values()) {
                        allAdjustIds.addAll(set);
                    }
                    for (Map.Entry entry : voucherAdjustBillIdsMap.entrySet()) {
                        Long voucherId = (Long)entry.getKey();
                        Set costAdjustSet = (Set)entry.getValue();
                        if (costAdjustSet.isEmpty()) continue;
                        DynamicObject voucher = voucherMap.get(voucherId);
                        if ("1".equals(this.voucherOperationValue)) {
                            for (Long costAdjustId : costAdjustSet) {
                                paramList.add(new Object[]{voucher.getString("billno"), voucher.getPkValue(), costAdjustId});
                            }
                            if (!isAddDap) continue;
                            dapTracks.addAll(this.getDapTracks("cal_costadjust_subentity", voucher, costAdjustSet));
                            continue;
                        }
                        if ("2".equals(this.voucherOperationValue)) continue;
                        String voucherNum = this.voucherNumMap.get(voucherId);
                        if (StringUtils.isEmpty((CharSequence)voucherNum)) {
                            voucherNum = voucher.getString("billno");
                        }
                        for (Long costAdjustId : costAdjustSet) {
                            paramList.add(new Object[]{voucherNum, costAdjustId});
                        }
                    }
                    if (!"1".equals(this.voucherOperationValue)) break block52;
                    if (!paramList.isEmpty()) {
                        splitList = CommonUtils.getSplitList(paramList);
                        for (List list : splitList) {
                            h1 = TX.requiresNew();
                            throwable = null;
                            try {
                                String updateSql2 = "update t_cal_costadjustbill set fisvoucher = '1',fvouchernum = ?,fvoucherid = ? where fid = ?";
                                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateSql2, (List)list);
                            }
                            catch (Throwable updateSql2) {
                                throwable = updateSql2;
                                throw updateSql2;
                            }
                            finally {
                                if (h1 == null) continue;
                                if (throwable != null) {
                                    try {
                                        h1.close();
                                    }
                                    catch (Throwable updateSql2) {
                                        throwable.addSuppressed(updateSql2);
                                    }
                                    continue;
                                }
                                h1.close();
                            }
                        }
                    }
                    if (dapTracks.isEmpty()) break block53;
                    splitList = CommonUtils.getSplitDynList(dapTracks);
                    for (Set set : splitList) {
                        h1 = TX.requiresNew();
                        throwable = null;
                        try {
                            SaveServiceHelper.save((DynamicObject[])set.toArray(new DynamicObject[0]));
                        }
                        catch (Throwable updateSql2) {
                            throwable = updateSql2;
                            throw updateSql2;
                        }
                        finally {
                            if (h1 == null) continue;
                            if (throwable != null) {
                                try {
                                    h1.close();
                                }
                                catch (Throwable updateSql2) {
                                    throwable.addSuppressed(updateSql2);
                                }
                                continue;
                            }
                            h1.close();
                        }
                    }
                    break block53;
                }
                if (!"2".equals(this.voucherOperationValue)) break block54;
                if (allAdjustIds.isEmpty()) break block53;
                splitList = CommonUtils.getSplitList(allAdjustIds);
                for (Set set : splitList) {
                    h1 = TX.requiresNew();
                    throwable = null;
                    try {
                        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_costadjustbill set fisvoucher = '0',fvouchernum = ' ',fvoucherid = 0 where fid in (" + StringUtils.join((Object[])set.toArray(), (char)',') + ")"));
                    }
                    catch (Throwable updateSql2) {
                        throwable = updateSql2;
                        throw updateSql2;
                    }
                    finally {
                        if (h1 == null) continue;
                        if (throwable != null) {
                            try {
                                h1.close();
                            }
                            catch (Throwable updateSql2) {
                                throwable.addSuppressed(updateSql2);
                            }
                            continue;
                        }
                        h1.close();
                    }
                }
                break block53;
            }
            if (!paramList.isEmpty()) {
                splitList = CommonUtils.getSplitList(paramList);
                for (List list : splitList) {
                    h1 = TX.requiresNew();
                    throwable = null;
                    try {
                        String updateSql = "update t_cal_costadjustbill set fvouchernum = ? where fid = ?";
                        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateSql, (List)list);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (h1 == null) continue;
                        if (throwable != null) {
                            try {
                                h1.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        h1.close();
                    }
                }
            }
        }
    }

    private void delCalVouchers(Set<Long> voucherIds) {
        DeleteServiceHelper.delete((String)"cal_voucher", (QFilter[])new QFilter[]{new QFilter("voucherid", "in", voucherIds)});
    }

    private Set<DynamicObject> getCalVouchers(Set<DynamicObject> costRecords, Set<String> hasVoucherSet, DynamicObject voucher, String vouchersource, String voucherType) {
        HashSet<DynamicObject> set = new HashSet<DynamicObject>(costRecords.size());
        for (DynamicObject costRecord : costRecords) {
            Long costRecordId = costRecord.getLong("id");
            String voucherid = String.valueOf(voucher.getPkValue());
            String hasKey = voucherid + "_" + String.valueOf(costRecordId);
            if (hasVoucherSet.contains(hasKey)) continue;
            DynamicObject calVoucher = BusinessDataServiceHelper.newDynamicObject((String)"cal_voucher");
            DynamicObject period = voucher.getDynamicObject("period");
            calVoucher.set("year", period.get("periodyear"));
            calVoucher.set("period", period.get("periodnumber"));
            calVoucher.set("periodid", (Object)period);
            calVoucher.set("costaccount_id", (Object)costRecord.getLong("costaccount"));
            calVoucher.set("calorg_id", (Object)costRecord.getLong("calorg"));
            calVoucher.set("costrecordid", (Object)costRecord.getLong("id"));
            calVoucher.set("voucherid", voucher.getPkValue());
            calVoucher.set("vouchernum", voucher.get("billno"));
            if (voucherType != null) {
                calVoucher.set("vouchertype", (Object)voucherType);
            } else {
                calVoucher.set("vouchertype", (Object)"A");
            }
            calVoucher.set("createtime", voucher.get("createtime"));
            calVoucher.set("dischargetype", (Object)costRecord.getString("dischargetype"));
            calVoucher.set("createmode", (Object)0);
            calVoucher.set("vouchersource", (Object)vouchersource);
            set.add(calVoucher);
        }
        return set;
    }

    private void writeBackIsVoucherSelect(Set<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        DynamicObject[] ancestorRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"id,issplitcreate,entry.ancestorbillid", (QFilter[])new QFilter[]{idFilter});
        HashSet<Long> ancestorAndSelfIds = new HashSet<Long>();
        for (DynamicObject record : ancestorRecords) {
            Long selfId = record.getLong("id");
            if (record.getBoolean("issplitcreate")) {
                DynamicObjectCollection recordEntry = record.getDynamicObjectCollection("entry");
                if (recordEntry.size() <= 0) continue;
                ancestorAndSelfIds.add(((DynamicObject)recordEntry.get(0)).getLong("ancestorbillid"));
                continue;
            }
            ancestorAndSelfIds.add(selfId);
        }
        if (ancestorAndSelfIds.size() > 0) {
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_calcostrecord set fisvoucher = '1' where fid in (" + StringUtils.join((Object[])ancestorAndSelfIds.toArray(), (char)',') + ") and fisvoucher = '0'"));
        }
    }

    private void writeBackIsVoucherUncheck(Set<Long> ids) {
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, ids)});){
            ctx.set();
            QFilter idFilter = new QFilter("id", "in", ids);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,issplitcreate,entry.ancestorbillid,isinitbill,dischargetype,isfivoucher,istempvoucher,isdischargevoucher,iscostcarryover,isfeevoucher", (QFilter[])new QFilter[]{idFilter}, null);
            HashSet<Long> ancestorIds = new HashSet<Long>(ids.size());
            HashSet<Long> writebackIds = new HashSet<Long>(ids.size());
            for (Row row : dataSet) {
                boolean isNotVoucher;
                boolean bl = isNotVoucher = row.getBoolean("isfivoucher") == false && row.getBoolean("istempvoucher") == false && row.getBoolean("isdischargevoucher") == false && row.getBoolean("iscostcarryover") == false && row.getBoolean("isfeevoucher") == false;
                if (row.getBoolean("isinitbill").booleanValue() && DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(row.getString("dischargetype"))) {
                    boolean bl2 = isNotVoucher = row.getBoolean("isfivoucher") == false && row.getBoolean("isdischargevoucher") == false && row.getBoolean("iscostcarryover") == false && row.getBoolean("isfeevoucher") == false;
                }
                if (!isNotVoucher) continue;
                if (row.getBoolean("issplitcreate").booleanValue()) {
                    ancestorIds.add(row.getLong("entry.ancestorbillid"));
                    continue;
                }
                ancestorIds.add(row.getLong("id"));
            }
            QFilter ancFilter = new QFilter("entry.ancestorbillid", "in", ancestorIds);
            DataSet ancNoVouchDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,issplitcreate,entry.ancestorbillid,isinitbill,dischargetype,isfivoucher,istempvoucher,isdischargevoucher,iscostcarryover,isfeevoucher", (QFilter[])new QFilter[]{ancFilter}, null);
            QFilter filter = new QFilter("id", "in", ancestorIds);
            DataSet noVoucherDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,issplitcreate,entry.ancestorbillid,isinitbill,dischargetype,isfivoucher,istempvoucher,isdischargevoucher,iscostcarryover,isfeevoucher", (QFilter[])new QFilter[]{filter}, null);
            noVoucherDataSet = noVoucherDataSet.union(ancNoVouchDataSet);
            for (Row row : noVoucherDataSet) {
                boolean isVoucher;
                boolean bl = isVoucher = row.getBoolean("isfivoucher") != false || row.getBoolean("istempvoucher") != false || row.getBoolean("isdischargevoucher") != false || row.getBoolean("iscostcarryover") != false || row.getBoolean("isfeevoucher") != false;
                if (row.getBoolean("isinitbill").booleanValue() && DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(row.getString("dischargetype"))) {
                    boolean bl3 = isVoucher = row.getBoolean("isfivoucher") != false || row.getBoolean("isdischargevoucher") != false || row.getBoolean("iscostcarryover") != false || row.getBoolean("isfeevoucher") != false;
                }
                if (!isVoucher) continue;
                if (row.getBoolean("issplitcreate").booleanValue()) {
                    ancestorIds.remove(row.getLong("entry.ancestorbillid"));
                    continue;
                }
                ancestorIds.remove(row.getLong("id"));
            }
            writebackIds.addAll(ancestorIds);
            if (writebackIds.size() > 0) {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_calcostrecord set fisvoucher = '0' where fid in (" + StringUtils.join((Object[])writebackIds.toArray(), (char)',') + ") and fisvoucher = '1'"));
            }
        }
    }
}

