/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class MaterialCostUpdator {
    private static final String BILL_CKECK_ERROR_CODE = "bill-check";
    private static final String PARAMKEY_QTY = "qty";
    private static final String PARAMKEY_FILTER = "filter";
    private static final String PARAMKEY_PRICE = "price";
    private static final String PARAMKEY_COST = "cost";
    private static final String PARAMKEY_COSTACCOUNT = "costaccount";
    private static final Long IM_PURINBILL_STD_BT_S = 366348248593474560L;
    private static final String UPDATE_ENTRY_COST = "update t_cal_calcostrecordentry set  fmaterialcost = fmaterialcost+? ,factualcost = factualcost+?  where fentryid = ?";
    private static final String UPDATE_DETAIL_COST = "update t_cal_costrecord_detail set factualcost = factualcost+? where fentryid = ? and fcostsubelementid = ?";
    private static final String UPDATE_ENTRY_UNITCOST = "update t_cal_calcostrecordentry set funitmaterialcost = fmaterialcost/fbaseqty ,funitactualcost = factualcost/fbaseqty where fentryid = ?";
    private static final String UPDATE_DETAIL_UNITCOST = "update t_cal_costrecord_detail set funitactualcost = factualcost/fbaseqty where fentryid = ?";
    private Map<Long, Object[]> updateEntryObjs = new HashMap<Long, Object[]>();
    private Map<Long, Object[]> updateDetailObjs = new HashMap<Long, Object[]>();
    private Set<Long> updateEntryIdSet = new HashSet<Long>();
    private Map<String, Long[]> subElementMap = new HashMap<String, Long[]>();
    private Map<Long, Long> currentPeriodCache = new HashMap<Long, Long>();
    private List<String> errorInfos = new LinkedList<String>();
    private Map<Long, Set<Long>> rootToLeaf = new HashMap<Long, Set<Long>>();
    private Map<Long, BigDecimal> childQtyMap = new HashMap<Long, BigDecimal>();
    private Map<Long, Boolean> costAccountIsByElementMap = new HashMap<Long, Boolean>();
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    public void updateMaterialCost(List<Map<String, Object>> paramList) throws KDBizException {
        block49: {
            try (AlgoContext context = Algo.newContext();){
                for (Map<String, Object> paramMap : paramList) {
                    DataSet dataSet;
                    DataSet rootBillSet;
                    List<String> errorList;
                    Iterator<Long> qty = (BigDecimal)paramMap.get(PARAMKEY_QTY);
                    BigDecimal price = (BigDecimal)paramMap.get(PARAMKEY_PRICE);
                    BigDecimal cost = (BigDecimal)paramMap.get(PARAMKEY_COST);
                    Long costaccount = (Long)paramMap.get(PARAMKEY_COSTACCOUNT);
                    QFilter filter = new QFilter(PARAMKEY_COSTACCOUNT, "=", (Object)costaccount);
                    QFilter exFilter = (QFilter)paramMap.get(PARAMKEY_FILTER);
                    if (exFilter != null) {
                        filter = filter.and(exFilter);
                    }
                    if ((errorList = this.checkBizLegality(rootBillSet = (dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)"id,billno,calorg,costaccount,costaccount.costtype as costtype,period,issplitcreate,issplit,issubbillinvoiceverify,billtype,isvoucher,localcurrency.amtprecision as amtprecision,entry.id as entryid,entry.material as material,entry.baseqty as baseqty,entry.materialcost as materialcost,entry.processcost as processcost,entry.fee as fee,entry.resource as resource,entry.manufacturecost as manufacturecost,entry.actualcost as actualcost,entry.accounttype as accounttype,entry.fatherentryid as fatherentryid,entry.ancestorentryid as ancestorentryid", (QFilter[])filter.toArray(), null)).copy().filter("issplitcreate = false"), (BigDecimal)((Object)qty))).size() > 0) {
                        this.errorInfos.addAll(errorList);
                        continue;
                    }
                    DataSet childBillSet = dataSet.filter("issplitcreate = true");
                    this.buildBillRelations(childBillSet);
                    if (price == null) {
                        price = cost.divide((BigDecimal)((Object)qty), 10, RoundingMode.HALF_UP);
                    }
                    this.batchBuildElementCache(rootBillSet);
                    BigDecimal currentTotalQty = BigDecimal.ZERO;
                    BigDecimal currentTotalCost = BigDecimal.ZERO;
                    while (rootBillSet.hasNext()) {
                        Row row = rootBillSet.next();
                        Long entryId = row.getLong("entryid");
                        Long material = row.getLong("material");
                        Long costType = row.getLong("costtype");
                        BigDecimal baseqty = row.getBigDecimal("baseqty");
                        int amtPrecision = row.getInteger("amtprecision");
                        BigDecimal newMaterialCost = null;
                        currentTotalQty = currentTotalQty.add(baseqty);
                        newMaterialCost = cost != null && currentTotalQty.compareTo((BigDecimal)((Object)qty)) == 0 ? cost.subtract(currentTotalCost).setScale(amtPrecision, RoundingMode.HALF_UP) : price.multiply(baseqty).setScale(amtPrecision, RoundingMode.HALF_UP);
                        BigDecimal materialCost = row.getBigDecimal("materialcost");
                        BigDecimal costDiff = newMaterialCost.subtract(materialCost);
                        currentTotalCost = currentTotalCost.add(newMaterialCost);
                        this.putCostUpdateInfo(costDiff, entryId, baseqty, amtPrecision, material, costType, costaccount);
                    }
                }
            }
            DBRoute route = new DBRoute("cal");
            TXHandle handle = TX.requiresNew();
            Object object = null;
            try {
                ArrayList<Object[]> unitcostParams;
                if (!this.updateEntryObjs.isEmpty()) {
                    DB.executeBatch((DBRoute)route, (String)UPDATE_ENTRY_COST, new ArrayList<Object[]>(this.updateEntryObjs.values()));
                    unitcostParams = new ArrayList<Object[]>(16);
                    for (Long entryid : this.updateEntryObjs.keySet()) {
                        unitcostParams.add(new Object[]{entryid});
                    }
                    DB.executeBatch((DBRoute)route, (String)UPDATE_ENTRY_UNITCOST, unitcostParams);
                }
                if (!this.updateDetailObjs.isEmpty()) {
                    DB.executeBatch((DBRoute)route, (String)UPDATE_DETAIL_COST, new ArrayList<Object[]>(this.updateDetailObjs.values()));
                    unitcostParams = new ArrayList(16);
                    for (Long entryid : this.updateDetailObjs.keySet()) {
                        unitcostParams.add(new Object[]{entryid});
                    }
                    DB.executeBatch((DBRoute)route, (String)UPDATE_DETAIL_UNITCOST, unitcostParams);
                }
                if (this.updateEntryIdSet.isEmpty()) break block49;
                if (this.isNewBalance) {
                    HashSet<Long> idSet = new HashSet<Long>();
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id", (QFilter[])new QFilter("entry.id", "in", this.updateEntryIdSet).toArray(), null);){
                        for (Row row : dataSet) {
                            idSet.add(row.getLong("id"));
                        }
                    }
                    new BalanceOpInvoker().invokeCostRecordUpdateBalOp(idSet, BalanceSourceEnum.COST_UPDATE_INTERFACE);
                    break block49;
                }
                new BalanceCalculator().updateBalance4Others(this.updateEntryIdSet.toArray(), BalanceSourceEnum.COST_UPDATE_INTERFACE);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (handle != null) {
                    if (object != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        handle.close();
                    }
                }
            }
        }
        if (!this.errorInfos.isEmpty()) {
            ErrorCode errorcode = new ErrorCode(BILL_CKECK_ERROR_CODE, String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38\uff1a%1$s", (String)"MaterialCostUpdator_1", (String)"fi-cal-mservice", (Object[])new Object[0]), this.errorInfos.toArray()));
            throw new KDBizException(errorcode, this.errorInfos.toArray());
        }
    }

    private void putCostUpdateInfo(BigDecimal costDiff, Long entryId, BigDecimal qty, int amtPrecision, Long material, Long costType, Long costaccount) {
        if (costDiff.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        this.updateEntryIdSet.add(entryId);
        this.updateEntryObjs.put(entryId, new Object[]{costDiff, costDiff, entryId});
        this.updateDetailObjs.put(entryId, new Object[]{costDiff, entryId, this.getSubElementID(costaccount, material, costType)});
        Set<Long> leafEntryIDs = this.rootToLeaf.get(entryId);
        if (leafEntryIDs == null || leafEntryIDs.isEmpty()) {
            return;
        }
        BigDecimal dividedCost = BigDecimal.ZERO;
        HashMap parentCostCache = new HashMap();
        for (Long l : leafEntryIDs) {
            BigDecimal cost = null;
            cost = costDiff.multiply(this.childQtyMap.get(l)).divide(qty, amtPrecision, RoundingMode.HALF_UP);
            this.updateEntryObjs.put(l, new Object[]{cost, cost, l});
            this.updateDetailObjs.put(l, new Object[]{cost, l, this.getSubElementID(costaccount, material, costType)});
            dividedCost = dividedCost.add(cost);
        }
        for (Map.Entry entry : parentCostCache.entrySet()) {
            Long childEntryId = (Long)entry.getKey();
            BigDecimal childCost = (BigDecimal)entry.getValue();
            this.updateEntryObjs.put((Long)entry.getKey(), new Object[]{childCost, childCost, childEntryId});
            this.updateDetailObjs.put((Long)entry.getKey(), new Object[]{childCost, childEntryId, this.getSubElementID(costaccount, material, costType)});
        }
    }

    protected final void putRootToLeafRelation(Long rootId, Long leafId) {
        Set<Long> leafIds = this.rootToLeaf.get(rootId);
        if (leafIds == null) {
            leafIds = new HashSet<Long>();
            this.rootToLeaf.put(rootId, leafIds);
        }
        leafIds.add(leafId);
    }

    protected final void buildBillRelations(DataSet childBillSet) {
        while (childBillSet.hasNext()) {
            Row row = childBillSet.next();
            Long entryId = row.getLong("entryid");
            Long rootId = row.getLong("ancestorentryid");
            BigDecimal qty = row.getBigDecimal("baseqty");
            this.childQtyMap.put(entryId, qty);
            if (row.getBoolean("issplit").booleanValue()) continue;
            this.putRootToLeafRelation(rootId, entryId);
        }
    }

    protected void batchBuildElementCache(DataSet rootBill) {
        this.subElementMap.putAll(CostElementHelper.getCostElementsByMaterial((DataSet)rootBill.copy()));
    }

    protected final long getSubElementID(Long costaccount, Long material, Long costType) {
        if (!this.isByElement(costaccount).booleanValue()) {
            return CostElementHelper.getDefaultMaterialElements()[0];
        }
        String key = costType + "|" + material;
        Long[] elements = this.subElementMap.get(key);
        if (elements == null) {
            elements = CostElementHelper.getDefaultMaterialElements();
            this.subElementMap.put(key, elements);
        }
        return elements[0];
    }

    protected final Boolean isByElement(Long costaccount) {
        Boolean isByElement = this.costAccountIsByElementMap.get(costaccount);
        if (isByElement == null) {
            isByElement = ParamsHelper.getCostElementByCostAccount((long)costaccount);
            this.costAccountIsByElementMap.put(costaccount, isByElement);
        }
        return isByElement;
    }

    protected final List<String> checkBizLegality(DataSet rootBillSet, BigDecimal qty) {
        String content;
        LinkedList<String> errorInfos = new LinkedList<String>();
        if (rootBillSet.isEmpty()) {
            errorInfos.add(ResManager.loadKDString((String)"\u4f9d\u636e\u8fc7\u6ee4\u6761\u4ef6\u6ca1\u6709\u67e5\u8be2\u51fa\u4efb\u4f55\u5355\u636e\u3002", (String)"MaterialCostUpdateServiceImpl_0", (String)"fi-cal-mservice", (Object[])new Object[0]));
            return errorInfos;
        }
        DataSet sumDataSet = rootBillSet.copy().groupBy().sum("baseqty", "baseqty").finish();
        BigDecimal currentTotalQty = sumDataSet.next().getBigDecimal("baseqty");
        if (currentTotalQty.compareTo(qty) != 0) {
            String content2 = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u66f4\u65b0\u671f\u671b\u603b\u6570\u91cf%1$s\u4e0e\u5b9e\u9645\u603b\u6570\u91cf%2$s\u4e0d\u4e00\u81f4\u3002", (String)"MaterialCostUpdateServiceImpl_14", (String)"fi-cal-mservice", (Object[])new Object[0]), qty.stripTrailingZeros().toPlainString(), currentTotalQty.stripTrailingZeros().toPlainString());
            errorInfos.add(content2);
            return errorInfos;
        }
        DataSet accountTypeSet = rootBillSet.copy().filter("accounttype in ('" + AccountTypeEnum.FIN_FOUT.getValue() + "','" + AccountTypeEnum.MOVE_ADD_AVERAGE + "')");
        while (accountTypeSet.hasNext()) {
            String content3 = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u8ba1\u4ef7\u65b9\u6cd5\u4e3a\u5b9e\u65f6\u79fb\u52a8\u6216\u5148\u8fdb\u5148\u51fa\u4e0d\u5141\u8bb8\u66f4\u65b0", (String)"MaterialCostUpdateServiceImpl_15", (String)"fi-cal-mservice", (Object[])new Object[0]), accountTypeSet.next().getString("billno"));
            errorInfos.add(content3);
        }
        DataSet voucherSet = rootBillSet.copy().filter("isvoucher = true");
        while (voucherSet.hasNext()) {
            String content4 = String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s\u5df2\u751f\u6210\u51ed\u8bc1\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"MaterialCostUpdateServiceImpl_16", (String)"fi-cal-mservice", (Object[])new Object[0]), voucherSet.next().getString("billno"));
            errorInfos.add(content4);
        }
        DataSet periodSet = rootBillSet.copy();
        while (periodSet.hasNext()) {
            Row row = periodSet.next();
            if (row.getLong("period").compareTo(this.getCurrentPeriodID(row.getLong(PARAMKEY_COSTACCOUNT))) >= 0) continue;
            content = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u4e3a\u5f80\u671f\u5355\u636e\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"MaterialCostUpdateServiceImpl_17", (String)"fi-cal-mservice", (Object[])new Object[0]), row.getString("billno"));
            errorInfos.add(content);
        }
        DataSet invoiceSet = rootBillSet.copy().filter("billtype = " + IM_PURINBILL_STD_BT_S).filter("issubbillinvoiceverify = true");
        while (invoiceSet.hasNext()) {
            content = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5b50\u5355\u5df2\u53d1\u7968\u6838\u9500\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"MaterialCostUpdateServiceImpl_18", (String)"fi-cal-mservice", (Object[])new Object[0]), invoiceSet.next().getString("billno"));
            errorInfos.add(content);
        }
        return errorInfos;
    }

    protected Long getCurrentPeriodID(Long costAccountID) {
        Long periodId = this.currentPeriodCache.get(costAccountID);
        if (periodId == null) {
            periodId = PeriodHelper.getCurrentPeriod((Long)costAccountID).getLong("id");
            this.currentPeriodCache.put(costAccountID, periodId);
        }
        return periodId;
    }
}

