/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.mservice.api.OutsourcedCostTraceableService;

public class OutsourcedCostTraceableServiceImpl
implements OutsourcedCostTraceableService {
    private Log logger = LogFactory.getLog(OutsourcedCostTraceableServiceImpl.class);

    public void doTraceCost(Long costAccountId, Long periodId, Set<Long> matIds) {
        QFilter metaFilter = new QFilter("number", "=", (Object)"ynzy_cal_price_revbil_ext");
        boolean exist = QueryServiceHelper.exists((String)"bos_formmeta", (QFilter[])metaFilter.toArray());
        this.logger.info("cal_price_revbil is exist\uff1a" + exist);
        if (!exist) {
            return;
        }
        String algoKey = "kd.macc.sca.algox.task.DiffCostAllocProcessor.getFallPrice";
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
        filter.and("periodid.id", "=", (Object)periodId);
        filter.and("billstatus", "=", (Object)"C");
        HashSet<Long> bizBilltypes = new HashSet<Long>(16);
        bizBilltypes.add(988376671919052800L);
        bizBilltypes.add(989633164802705408L);
        bizBilltypes.add(989633630873884672L);
        filter.and("entry.ynzy_issueentry.ynzy_bizbilltype", "in", bizBilltypes);
        filter.and("entry.material", "in", matIds);
        this.logger.info("price_revbil quer filter\uff1a" + filter.toString());
        DataSet omproordData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cal_price_revbill", (String)this.getOmproordfields(), (QFilter[])filter.toArray(), null);
        this.logger.info("OutsourcedCostTraceableServiceImpl\uff1aomproordData query success.");
        omproordData = OutsourcedCostTraceableServiceImpl.changFiledDataType(omproordData, "omproorderentryid", Long.class);
        omproordData = OutsourcedCostTraceableServiceImpl.changFiledDataType(omproordData, "omproorderbillid", Long.class);
        if (omproordData.isEmpty()) {
            this.logger.info("OutsourcedCostTraceableServiceImpl\uff1aomproordData is empty.");
            return;
        }
        HashSet<Long> omproordEntryIds = new HashSet<Long>(100);
        HashSet<Long> omproordBillIds = new HashSet<Long>(100);
        for (Row row : omproordData.copy()) {
            omproordEntryIds.add(row.getLong("omproorderentryid"));
            omproordBillIds.add(row.getLong("omproorderbillid"));
        }
        QFilter costRecordFilter = new QFilter("entry.bizbillentryid", "in", omproordEntryIds);
        costRecordFilter.and("bizbillid", "in", omproordBillIds);
        DataSet costRecordData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cal_costrecord_subentity", (String)"entry.id as entryid,entry.bizbillentryid as bizbillentryid ", (QFilter[])costRecordFilter.toArray(), null);
        this.logger.info("OutsourcedCostTraceableServiceImpl\uff1acostRecordData query success.");
        if (costRecordData.isEmpty()) {
            this.logger.info("OutsourcedCostTraceableServiceImpl\uff1acostRecordData is empty.");
            omproordData.close();
            return;
        }
        JoinDataSet costRecordFallJoinData = costRecordData.leftJoin(omproordData);
        costRecordFallJoinData.on("bizbillentryid", "omproorderentryid");
        DataSet costRecordFallData = costRecordFallJoinData.select(new String[]{"entryid"}, new String[]{"adjustamt"}).finish().filter("adjustamt is not null");
        HashSet<Long> costRecordFallEntryIds = new HashSet<Long>(100);
        for (Row row : costRecordFallData.copy()) {
            costRecordFallEntryIds.add(row.getLong("entryid"));
        }
        QFilter groupFilter = new QFilter("entryentity.costrecordentryid", "in", costRecordFallEntryIds);
        groupFilter.and("entryentity.type", "=", (Object)"0");
        DataSet acctGroupData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cal_account_grouprecord", (String)"id,entryentity.costrecordentryid as costrecordentryid ", (QFilter[])groupFilter.toArray(), null);
        this.logger.info("OutsourcedCostTraceableServiceImpl\uff1aacctGroupData query success.");
        if (acctGroupData.isEmpty()) {
            this.logger.info("OutsourcedCostTraceableServiceImpl\uff1aacctGroupData is empty.");
            omproordData.close();
            costRecordData.close();
            costRecordFallData.close();
            return;
        }
        costRecordFallJoinData = costRecordFallData.leftJoin(acctGroupData);
        costRecordFallJoinData.on("entryid", "costrecordentryid");
        costRecordFallData = costRecordFallJoinData.select(new String[]{"adjustamt"}, new String[]{"id as groupid"}).finish();
        HashSet<Long> groupIds = new HashSet<Long>(100);
        for (Row row : acctGroupData.copy()) {
            groupIds.add(row.getLong("id"));
        }
        QFilter targGroupFilter = new QFilter("id", "in", groupIds);
        targGroupFilter.and("entryentity.type", "=", (Object)"1");
        DataSet targAcctGroupData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cal_account_grouprecord", (String)"id,entryentity.costrecordentryid as costrecordentryid, entryentity.costaccount as costaccountid, entryentity.period.begindate as begindate,entryentity.period.enddate as enddate", (QFilter[])targGroupFilter.toArray(), null);
        this.logger.info("OutsourcedCostTraceableServiceImpl\uff1atargAcctGroupData query success.");
        if (targAcctGroupData.isEmpty()) {
            this.logger.info("OutsourcedCostTraceableServiceImpl\uff1atargAcctGroupData is empty.");
            omproordData.close();
            costRecordData.close();
            costRecordFallData.close();
            acctGroupData.close();
            return;
        }
        costRecordFallJoinData = costRecordFallData.leftJoin(targAcctGroupData);
        costRecordFallJoinData.on("groupid", "id");
        costRecordFallData = costRecordFallJoinData.select(new String[]{"adjustamt"}, new String[]{"costrecordentryid", "costaccountid", "begindate", "enddate"}).finish().filter("costrecordentryid is not null");
        HashSet<Long> inBillIds = new HashSet<Long>(16);
        HashSet<Long> costaccountIds = new HashSet<Long>(16);
        Date startDate = null;
        Date endDate = null;
        for (Row row : costRecordFallData.copy()) {
            inBillIds.add(row.getLong("costrecordentryid"));
            costaccountIds.add(row.getLong("costaccountid"));
            Date beginBizDate = row.getDate("begindate");
            Date enddate = row.getDate("enddate");
            if (startDate == null || startDate.after(beginBizDate)) {
                startDate = beginBizDate;
            }
            if (endDate != null && !endDate.before(enddate)) continue;
            endDate = enddate;
        }
        QFilter inBillFilter = new QFilter("entry.id", "in", inBillIds);
        inBillFilter.and("costaccount", "in", costaccountIds);
        inBillFilter.and("bizdate", ">=", startDate);
        inBillFilter.and("bizdate", "<=", endDate);
        costRecordData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cal_costrecord_subentity", (String)this.getCostRecordFields(), (QFilter[])inBillFilter.toArray(), null);
        this.logger.info("OutsourcedCostTraceableServiceImpl\uff1acostRecordData query success.");
        costRecordFallJoinData = costRecordFallData.leftJoin(costRecordData);
        costRecordFallJoinData.on("costrecordentryid", "entryid");
        costRecordFallData = costRecordFallJoinData.select(new String[]{"adjustamt"}, costRecordData.getRowMeta().getFieldNames()).finish().filter("entryid is not null");
        GroupbyDataSet groupData = costRecordFallData.groupBy(costRecordData.getRowMeta().getFieldNames());
        groupData.sum("adjustamt");
        costRecordFallData = groupData.finish();
        this.logger.info("OutsourcedCostTraceableServiceImpl\uff1acreateAdjust begin.");
        DataSet[] costRecordFallDatas = costRecordFallData.splitByFilter(new String[]{"accounttype = 'D'"}, Boolean.TRUE.booleanValue());
        this.createStdCostDiffBill(costRecordFallDatas[0]);
        this.createAdjust(costRecordFallDatas[1]);
        this.logger.info("OutsourcedCostTraceableServiceImpl\uff1acreateAdjust end.");
    }

    /*
     * WARNING - void declaration
     */
    private void createAdjust(DataSet fallDataSet) {
        if (fallDataSet == null || fallDataSet.isEmpty()) {
            return;
        }
        HashMap<Object, DynamicObject> adjustBills = new HashMap<Object, DynamicObject>(16);
        Long[] defualtElementIds = CostElementHelper.getDefaultMaterialElements();
        for (Row row : fallDataSet) {
            void var7_7;
            Long inbillId = row.getLong("id");
            Object var7_8 = null;
            if (adjustBills.containsKey(inbillId)) {
                DynamicObject dynamicObject = (DynamicObject)adjustBills.get(inbillId);
            } else {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjust_subentity");
                long costAdjustId = DBServiceHelper.genLongIds((String)"t_cal_costadjustbill", (int)1)[0];
                dynamicObject.set("id", (Object)costAdjustId);
                dynamicObject.set("period_id", row.get("periodid"));
                dynamicObject.set("calorg_id", row.get("calorgid"));
                dynamicObject.set("costaccount_id", row.get("costaccountid"));
                dynamicObject.set("billstatus", (Object)"B");
                dynamicObject.set("billsrctype", (Object)"D");
                dynamicObject.set("biztype", (Object)"A");
                dynamicObject.set("bizdate", row.get("enddate"));
                dynamicObject.set("bookdate", row.get("enddate"));
                dynamicObject.set("billtype_id", row.get("billtypeid"));
                dynamicObject.set("cstype", row.get("cstype"));
                dynamicObject.set("difftype", (Object)"B");
                dynamicObject.set("createtype", (Object)"W");
                dynamicObject.set("currency_id", row.get("currencyid"));
                dynamicObject.set("adminorg_id", row.get("adminorg"));
                dynamicObject.set("custsupplier", row.get("supplier"));
                dynamicObject.set("remark", (Object)ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u81ea\u52a8\u751f\u6210_\u59d4\u5916\u8ffd\u6eaf", (String)"CostAdjustBillHelper_0", (String)"fi-calx-algox", (Object[])new Object[0]));
                String number = "ZBTZ" + costAdjustId;
                dynamicObject.set("billno", (Object)number);
                String userId = RequestContext.get().getUserId();
                Date date = TimeServiceHelper.now();
                dynamicObject.set("creator", (Object)userId);
                dynamicObject.set("createtime", (Object)date);
                dynamicObject.set("modifier", (Object)userId);
                dynamicObject.set("modifytime", (Object)date);
                dynamicObject.set("auditor", (Object)userId);
                dynamicObject.set("auditdate", (Object)date);
                adjustBills.put(inbillId, dynamicObject);
            }
            Long inbillEntryId = row.getLong("entryid");
            DynamicObjectCollection entrys = var7_7.getDynamicObjectCollection("entryentity");
            boolean isExitsEntry = false;
            for (DynamicObject entry : entrys) {
                if (inbillEntryId.compareTo(entry.getLong("invbillentryid")) != 0) continue;
                entry.set("adjustamt", (Object)entry.getBigDecimal("adjustamt").add(row.getBigDecimal("adjustamt")));
                DynamicObjectCollection detailEntrys = entry.getDynamicObjectCollection("subentryentity");
                BigDecimal detailAdjAmt = ((DynamicObject)detailEntrys.get(0)).getBigDecimal("sub_adjustamt");
                ((DynamicObject)detailEntrys.get(0)).set("sub_adjustamt", (Object)detailAdjAmt.add(row.getBigDecimal("adjustamt")));
                isExitsEntry = true;
                break;
            }
            if (isExitsEntry) continue;
            DynamicObject newEntry = entrys.addNew();
            long costAdjustEntryId = DBServiceHelper.genLongIds((String)"t_cal_costadjustbillentry", (int)1)[0];
            newEntry.set("id", (Object)costAdjustEntryId);
            newEntry.set("seq", (Object)entrys.size());
            newEntry.set("storageorgunit_id", row.get("storageorgunit"));
            newEntry.set("material_id", row.get("material"));
            newEntry.set("assist_id", row.get("assist"));
            newEntry.set("lot", row.get("lot"));
            newEntry.set("baseunit_id", row.get("baseunit"));
            newEntry.set("warehouse_id", row.get("warehouse"));
            newEntry.set("location_id", row.get("location"));
            newEntry.set("invtype", row.get("invtype"));
            newEntry.set("invbilltype", row.get("billtypeid"));
            newEntry.set("invstatus", row.get("invstatus"));
            newEntry.set("ownertype", row.get("ownertype"));
            newEntry.set("owner_id", row.get("owner"));
            newEntry.set("project_id", row.get("project"));
            newEntry.set("calrange_id", row.get("calrange"));
            newEntry.set("caldimension_id", row.get("caldimensionid"));
            newEntry.set("accounttype", row.get("accounttype"));
            newEntry.set("adjustamt", row.get("adjustamt"));
            newEntry.set("invbillid", row.get("id"));
            newEntry.set("invbillentryid", row.get("entryid"));
            newEntry.set("invbillnum", row.get("billno"));
            newEntry.set("invbizentityobject", (Object)"cal_costrecord");
            newEntry.set("inventryseq", row.get("seq"));
            newEntry.set("invbiztype", row.get("biztype"));
            newEntry.set("transtype", row.get("transtype"));
            newEntry.set("tracknumber", row.get("tracknumber"));
            newEntry.set("configuredcode", row.get("configuredcode"));
            newEntry.set("noupdatecalfields", row.get("noupdatecalfields"));
            DynamicObjectCollection detailEntrys = newEntry.getDynamicObjectCollection("subentryentity");
            DynamicObject newEntryDetail = detailEntrys.addNew();
            newEntryDetail.set("seq", (Object)detailEntrys.size());
            newEntryDetail.set("costelement", (Object)defualtElementIds[1]);
            newEntryDetail.set("costsubelement", (Object)defualtElementIds[0]);
            newEntryDetail.set("sub_currency", row.get("currencyid"));
            newEntryDetail.set("sub_adjustamt", (Object)((BigDecimal)row.get("adjustamt")));
        }
        HashSet<DynamicObject> adjustbils = new HashSet<DynamicObject>(16);
        HashSet<Object> pkIds = new HashSet<Object>(16);
        for (Map.Entry entry : adjustBills.entrySet()) {
            adjustbils.add((DynamicObject)entry.getValue());
            pkIds.add(((DynamicObject)entry.getValue()).getPkValue());
        }
        DataSet elementData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cad_elementdetail", (String)"element as elementid,subelement as subelementid", null, null);
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>(16);
        for (Row row : elementData) {
            hashMap.put(row.getLong("subelementid"), row.getLong("elementid"));
        }
        this.appendElement(adjustbils, hashMap);
        SaveServiceHelper.save((DynamicObject[])adjustbils.toArray(new DynamicObject[0]));
        OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (Object[])pkIds.toArray());
    }

    /*
     * WARNING - void declaration
     */
    private void createStdCostDiffBill(DataSet fallDataSet) {
        if (fallDataSet == null || fallDataSet.isEmpty()) {
            return;
        }
        HashMap<Object, DynamicObject> adjustBills = new HashMap<Object, DynamicObject>(16);
        Long[] defualtElementIds = CostElementHelper.getDefaultMaterialElements();
        for (Row row : fallDataSet) {
            void var7_7;
            Long inbillId = row.getLong("id");
            Object var7_8 = null;
            if (adjustBills.containsKey(inbillId)) {
                DynamicObject dynamicObject = (DynamicObject)adjustBills.get(inbillId);
            } else {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cal_stdcostdiffbill");
                long costAdjustId = DBServiceHelper.genLongIds((String)"t_cal_stdcostdiff", (int)1)[0];
                dynamicObject.set("id", (Object)costAdjustId);
                dynamicObject.set("period_id", row.get("periodid"));
                dynamicObject.set("calorg_id", row.get("calorgid"));
                dynamicObject.set("costaccount_id", row.get("costaccountid"));
                dynamicObject.set("billstatus", (Object)"B");
                dynamicObject.set("billsrctype", (Object)"D");
                dynamicObject.set("biztype", (Object)"A");
                dynamicObject.set("bizdate", row.get("enddate"));
                dynamicObject.set("bookdate", row.get("enddate"));
                dynamicObject.set("billtype_id", row.get("billtypeid"));
                dynamicObject.set("cstype", row.get("cstype"));
                dynamicObject.set("createtype", (Object)"W");
                dynamicObject.set("currency_id", row.get("currencyid"));
                dynamicObject.set("adminorg_id", row.get("adminorg"));
                dynamicObject.set("custsupplier", row.get("supplier"));
                dynamicObject.set("remark", (Object)ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u81ea\u52a8\u751f\u6210_\u59d4\u5916\u8ffd\u6eaf", (String)"CostAdjustBillHelper_0", (String)"fi-calx-algox", (Object[])new Object[0]));
                String number = "ZBTZ" + costAdjustId;
                dynamicObject.set("billno", (Object)number);
                String userId = RequestContext.get().getUserId();
                Date date = TimeServiceHelper.now();
                dynamicObject.set("creator", (Object)userId);
                dynamicObject.set("createtime", (Object)date);
                dynamicObject.set("modifier", (Object)userId);
                dynamicObject.set("modifytime", (Object)date);
                dynamicObject.set("auditor", (Object)userId);
                dynamicObject.set("auditdate", (Object)date);
                adjustBills.put(inbillId, dynamicObject);
            }
            Long inbillEntryId = row.getLong("entryid");
            DynamicObjectCollection entrys = var7_7.getDynamicObjectCollection("entryentity");
            boolean isExitsEntry = false;
            for (DynamicObject entry : entrys) {
                if (inbillEntryId.compareTo(entry.getLong("invbillentryid")) != 0) continue;
                entry.set("adjustamt", (Object)entry.getBigDecimal("adjustamt").add(row.getBigDecimal("adjustamt")));
                DynamicObjectCollection detailEntrys = entry.getDynamicObjectCollection("subentryentity");
                BigDecimal detailAdjAmt = ((DynamicObject)detailEntrys.get(0)).getBigDecimal("sub_adjustamt");
                ((DynamicObject)detailEntrys.get(0)).set("sub_adjustamt", (Object)detailAdjAmt.add(row.getBigDecimal("adjustamt")));
                isExitsEntry = true;
                break;
            }
            if (isExitsEntry) continue;
            DynamicObject newEntry = entrys.addNew();
            long costAdjustEntryId = DBServiceHelper.genLongIds((String)"t_cal_stdcostdiff", (int)1)[0];
            newEntry.set("id", (Object)costAdjustEntryId);
            newEntry.set("seq", (Object)entrys.size());
            newEntry.set("storageorgunit_id", row.get("storageorgunit"));
            newEntry.set("material_id", row.get("material"));
            newEntry.set("assist_id", row.get("assist"));
            newEntry.set("lot", row.get("lot"));
            newEntry.set("baseunit_id", row.get("baseunit"));
            newEntry.set("warehouse_id", row.get("warehouse"));
            newEntry.set("location_id", row.get("location"));
            newEntry.set("invtype", row.get("invtype"));
            newEntry.set("invbilltype", row.get("billtypeid"));
            newEntry.set("invstatus", row.get("invstatus"));
            newEntry.set("ownertype", row.get("ownertype"));
            newEntry.set("owner_id", row.get("owner"));
            newEntry.set("project_id", row.get("project"));
            newEntry.set("calrange_id", row.get("calrange"));
            newEntry.set("caldimension_id", row.get("caldimensionid"));
            newEntry.set("accounttype", row.get("accounttype"));
            newEntry.set("adjustamt", row.get("adjustamt"));
            newEntry.set("diff_c", row.get("adjustamt"));
            newEntry.set("invbillid", row.get("id"));
            newEntry.set("invbillentryid", row.get("entryid"));
            newEntry.set("invbillnum", row.get("billno"));
            newEntry.set("invbizentityobject", (Object)"cal_costrecord");
            newEntry.set("inventryseq", row.get("seq"));
            newEntry.set("invbiztype", row.get("biztype"));
            newEntry.set("transtype", row.get("transtype"));
            newEntry.set("tracknumber", row.get("tracknumber"));
            newEntry.set("configuredcode", row.get("configuredcode"));
            newEntry.set("noupdatecalfields", row.get("noupdatecalfields"));
            DynamicObjectCollection detailEntrys = newEntry.getDynamicObjectCollection("subentryentity");
            DynamicObject newEntryDetail = detailEntrys.addNew();
            newEntryDetail.set("seq", (Object)detailEntrys.size());
            newEntryDetail.set("costelement_id", (Object)defualtElementIds[1]);
            newEntryDetail.set("costsubelement_id", (Object)defualtElementIds[0]);
            newEntryDetail.set("sub_currency_id", row.get("currencyid"));
            newEntryDetail.set("sub_adjustamt", (Object)((BigDecimal)row.get("adjustamt")));
            newEntryDetail.set("ddiff_c", (Object)((BigDecimal)row.get("adjustamt")));
        }
        HashSet<DynamicObject> adjustbils = new HashSet<DynamicObject>(16);
        HashSet<Object> pkIds = new HashSet<Object>(16);
        for (Map.Entry entry : adjustBills.entrySet()) {
            adjustbils.add((DynamicObject)entry.getValue());
            pkIds.add(((DynamicObject)entry.getValue()).getPkValue());
        }
        DataSet elementData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cad_elementdetail", (String)"element as elementid,subelement as subelementid", null, null);
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>(16);
        for (Row row : elementData) {
            hashMap.put(row.getLong("subelementid"), row.getLong("elementid"));
        }
        this.appendStdCostDiffBillElement(adjustbils, hashMap);
        SaveServiceHelper.save((DynamicObject[])adjustbils.toArray(new DynamicObject[0]));
        OperationServiceHelper.executeOperate((String)"audit", (String)"cal_stdcostdiffbill", (Object[])pkIds.toArray());
    }

    private String getOmproordfields() {
        return "0-entry.ynzy_issueentry.ynzy_issueamount AS adjustamt,entry.ynzy_issueentry.ynzy_bizbillentryid AS omproorderentryid,entry.ynzy_issueentry.ynzy_bizbillid AS omproorderbillid";
    }

    private String getCostRecordFields() {
        return "id,entry.id AS entryid,billno,entry.seq as seq,period.id as periodid,calorg.id as calorgid,costaccount.id as costaccountid,period.enddate as enddate,billtype.id as billtypeid,'bd_supplier' as cstype,entry.accounttype as accounttype,localcurrency.id as currencyid,adminorg.id as adminorg,supplier.id as supplier,storageorgunit.id as storageorgunit,entry.material as material,entry.assist as assist,entry.lot as lot,entry.baseunit as baseunit,entry.warehouse as warehouse,entry.location as location,entry.invtype as invtype,entry.invstatus as invstatus,entry.ownertype as ownertype,entry.owner as owner,entry.project project,entry.calrange as calrange,entry.caldimension as caldimensionid,biztype,transtype,entry.tracknumber as tracknumber,entry.configuredcode as configuredcode,entry.noupdatecalfields as noupdatecalfields";
    }

    public static <T> DataSet changFiledDataType(DataSet dataSet, String filedName, Class<T> T) {
        dataSet = dataSet.select(OutsourcedCostTraceableServiceImpl.arraysToString(OutsourcedCostTraceableServiceImpl.addFileds(OutsourcedCostTraceableServiceImpl.removeFiled(dataSet.getRowMeta().getFieldNames(), filedName), "cast(" + filedName + " as " + T.getSimpleName() + ")as " + filedName + "")));
        return dataSet;
    }

    public static String arraysToString(String[] sourceFileds) {
        String arrayS = Arrays.toString(sourceFileds);
        return arrayS.substring(1, arrayS.length() - 1);
    }

    public static String[] addFileds(String[] source, String ... addFiled) {
        return (String[])ArrayUtils.addAll((Object[])source, (Object[])addFiled);
    }

    public static String[] removeFiled(String[] source, String ... removeFileds) {
        HashSet<String> removeFiledSet = new HashSet<String>(removeFileds.length);
        for (String removeFiled : removeFileds) {
            removeFiledSet.add(removeFiled);
        }
        ArrayList<String> fileds = new ArrayList<String>(source.length);
        for (String string : source) {
            if (removeFiledSet.contains(string)) continue;
            fileds.add(string);
        }
        return fileds.toArray(new String[fileds.size()]);
    }

    private void appendStdCostDiffBillElement(Set<DynamicObject> adjBills, Map<Long, Long> elementMap) {
        if (adjBills == null || adjBills.isEmpty()) {
            return;
        }
        for (DynamicObject bill : adjBills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            if (entrys.isEmpty()) continue;
            for (DynamicObject entry : entrys) {
                DynamicObjectCollection details = entry.getDynamicObjectCollection("subentryentity");
                HashSet<Long> subelements = new HashSet<Long>(16);
                for (DynamicObject detail : details) {
                    subelements.add(detail.getLong("costsubelement"));
                }
                WriteLogHelper.writeInfoLog((Log)this.logger, (String)("OutsourcedCostTraceableServiceImpl appendStdCostDiffBillElement\uff1asubelements=" + subelements), (Object[])new Object[0]);
                for (Map.Entry<Long, Long> element : elementMap.entrySet()) {
                    if (subelements.contains(element.getKey())) continue;
                    DynamicObject detail = details.addNew();
                    detail.set("seq", (Object)details.size());
                    detail.set("costelement_id", (Object)element.getValue());
                    detail.set("costsubelement_id", (Object)element.getKey());
                    detail.set("sub_currency_id", bill.get("currency"));
                    detail.set("sub_adjustamt", (Object)BigDecimal.ZERO);
                }
            }
        }
    }

    private void appendElement(Set<DynamicObject> adjBills, Map<Long, Long> elementMap) {
        if (adjBills == null || adjBills.isEmpty()) {
            return;
        }
        for (DynamicObject bill : adjBills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            if (entrys.isEmpty()) continue;
            for (DynamicObject entry : entrys) {
                DynamicObjectCollection details = entry.getDynamicObjectCollection("subentryentity");
                HashSet<Long> subelements = new HashSet<Long>(16);
                for (DynamicObject detail : details) {
                    subelements.add(detail.getLong("costsubelement"));
                }
                for (Map.Entry<Long, Long> element : elementMap.entrySet()) {
                    if (subelements.contains(element.getKey())) continue;
                    DynamicObject detail = details.addNew();
                    detail.set("seq", (Object)details.size());
                    detail.set("costelement", (Object)element.getValue());
                    detail.set("costsubelement", (Object)element.getKey());
                    detail.set("sub_currency", bill.get("currency"));
                    detail.set("sub_adjustamt", (Object)BigDecimal.ZERO);
                }
            }
        }
    }
}

