/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.mservice.api.IReSyncService;

public class ReSyncServiceImpl
implements IReSyncService {
    public Map<Long, String> check(String formId, Collection<Long> bizBillIds, Map params) {
        Map<Long, String> checkBillIdMsgMap = new HashMap<Long, String>(16);
        if (bizBillIds == null || bizBillIds.isEmpty()) {
            return checkBillIdMsgMap;
        }
        checkBillIdMsgMap = this.doCheck(bizBillIds, params);
        return checkBillIdMsgMap;
    }

    private Map<Long, String> checkAcctType(Collection<Long> bizBillIds) {
        HashMap<Long, String> realTimeBizBillIdAcctNameMap = new HashMap<Long, String>(16);
        if (bizBillIds.isEmpty()) {
            return realTimeBizBillIdAcctNameMap;
        }
        QFilter bizBillIdF = new QFilter("bizbillid", "in", bizBillIds);
        QFilter billStatusF = new QFilter("billstatus", "=", (Object)"C");
        QFilter acctF = new QFilter("entry.accounttype", "in", (Object)new String[]{AccountTypeEnum.MOVE_ADD_AVERAGE.getValue(), AccountTypeEnum.FIN_FOUT.getValue(), AccountTypeEnum.STANDARDCOST.getValue()});
        QFilter acctEnableF = new QFilter("costaccount.enable", "=", (Object)"1");
        try (DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"bizbillid,costaccount.name", (QFilter[])new QFilter[]{bizBillIdF, billStatusF, acctF, acctEnableF}, null);){
            for (Row row : costRecordDs) {
                String acctName = (String)realTimeBizBillIdAcctNameMap.get(row.getLong("bizbillid"));
                if (acctName == null) {
                    acctName = row.getString("costaccount.name");
                } else if (!acctName.contains(row.getString("costaccount.name"))) {
                    acctName = acctName + "\u3001" + row.getString("costaccount.name");
                }
                realTimeBizBillIdAcctNameMap.put(row.getLong("bizbillid"), acctName);
            }
        }
        return realTimeBizBillIdAcctNameMap;
    }

    private Map<Long, String> doCheck(Collection<Long> bizBillIds, Map params) {
        HashMap<Long, String> checkBillIdMsgMap = new HashMap<Long, String>(16);
        HashMap<Long, Integer> costRecordIdPeriodMap = new HashMap<Long, Integer>(16);
        HashMap<Long, Long> costRecordIdAcctIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> costRecordIdBizBillIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, String> costRecordIdAcctNameMap = new HashMap<Long, String>(16);
        String splitBillMsg = ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5df2\u88ab\u62c6\u5355\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u540c\u6b65\u3002", (String)"ReSyncServiceImpl_0", (String)"fi-cal-mservice", (Object[])new Object[0]);
        String voucherMsg = ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u540c\u6b65\u3002", (String)"ReSyncServiceImpl_1", (String)"fi-cal-mservice", (Object[])new Object[0]);
        String beforePeriodMsg = ResManager.loadKDString((String)"\u5f80\u671f\u5355\u636e\u4e0d\u5141\u8bb8\u91cd\u65b0\u540c\u6b65\u3002", (String)"ReSyncServiceImpl_2", (String)"fi-cal-mservice", (Object[])new Object[0]);
        String realMatMsg = ResManager.loadKDString((String)"\u5b58\u5728\u5b9e\u65f6\u79fb\u52a8\u52a0\u6743\u5e73\u5747\u6cd5\u3001\u5148\u8fdb\u5148\u51fa\u8ba1\u4ef7\u6cd5\u3001\u6807\u51c6\u6210\u672c\u6cd5\u6838\u7b97\u7684\u7269\u6599\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u540c\u6b65\u3002", (String)"ReSyncServiceImpl_3", (String)"fi-cal-mservice", (Object[])new Object[0]);
        String acctMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\uff1a\u3010%1$s\u3011\u5df2\u7ed3\u8d26\uff0c%2$s", (String)"ReSyncServiceImpl_10", (String)"fi-cal-mservice", (Object[])new Object[0]);
        String acctNameMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\uff1a\u3010%1$s\u3011\uff0c%2$s", (String)"ReSyncServiceImpl_11", (String)"fi-cal-mservice", (Object[])new Object[0]);
        QFilter idF = new QFilter("bizbillid", "in", bizBillIds);
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(idF);
        QFilter isSpritCreateF = new QFilter("issplitcreate", "=", (Object)Boolean.FALSE);
        QFilter acctEnableF = new QFilter("costaccount.enable", "=", (Object)"1");
        HashMap<Long, String> isVoucherBizBillIdAcctNameMap = new HashMap<Long, String>(16);
        try (DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,bizbillid,issplit,isvoucher,costaccount,period,period.periodyear periodyear, period.periodnumber periodnumber,costaccount.name", (QFilter[])new QFilter[]{idF, isSpritCreateF, acctEnableF}, null);){
            for (Row row : costRecordDs) {
                if (row.getBoolean("issplit").booleanValue()) {
                    checkBillIdMsgMap.put(row.getLong("bizbillid"), splitBillMsg);
                    continue;
                }
                if (row.getBoolean("isvoucher").booleanValue()) {
                    Long bizBillId = row.getLong("bizbillid");
                    String acctName = (String)isVoucherBizBillIdAcctNameMap.get(bizBillId);
                    acctName = acctName == null ? row.getString("costaccount.name") : acctName + "\u3001" + row.getString("costaccount.name");
                    isVoucherBizBillIdAcctNameMap.put(bizBillId, acctName);
                    checkBillIdMsgMap.put(bizBillId, String.format(acctNameMsg, acctName, voucherMsg));
                    continue;
                }
                costRecordIdPeriodMap.put(row.getLong("id"), row.getInteger("periodyear") * 100 + row.getInteger("periodnumber"));
                costRecordIdAcctIdMap.put(row.getLong("id"), row.getLong("costaccount"));
                costRecordIdBizBillIdMap.put(row.getLong("id"), row.getLong("bizbillid"));
                costRecordIdAcctNameMap.put(row.getLong("id"), row.getString("costaccount.name"));
            }
        }
        Map acctPeriods = PeriodHelper.getSysPeriods(new HashSet(costRecordIdAcctIdMap.values()));
        HashMap<Long, String> befordBizBillIdAcctNameMap = new HashMap<Long, String>(16);
        for (Map.Entry costRecordIdAcctId : costRecordIdAcctIdMap.entrySet()) {
            Integer billPeriod = (Integer)costRecordIdPeriodMap.get(costRecordIdAcctId.getKey());
            DynamicObject acctPeriodDyc = (DynamicObject)acctPeriods.get(costRecordIdAcctId.getValue());
            if (acctPeriodDyc == null) continue;
            int acctPeriod = acctPeriodDyc.getInt("periodyear") * 100 + acctPeriodDyc.getInt("periodnumber");
            if (billPeriod >= acctPeriod) continue;
            Long bizBillId = (Long)costRecordIdBizBillIdMap.get(costRecordIdAcctId.getKey());
            String acctName = (String)befordBizBillIdAcctNameMap.get(bizBillId);
            acctName = acctName == null ? (String)costRecordIdAcctNameMap.get(costRecordIdAcctId.getKey()) : acctName + "\u3001" + (String)costRecordIdAcctNameMap.get(costRecordIdAcctId.getKey());
            befordBizBillIdAcctNameMap.put(bizBillId, acctName);
            checkBillIdMsgMap.put(bizBillId, String.format(acctMsg, acctName, beforePeriodMsg));
        }
        boolean checkAcctType = true;
        if (params != null && "TRUE".equals(params.get("nocheckacct"))) {
            checkAcctType = false;
        }
        if (checkAcctType) {
            bizBillIds.removeAll(checkBillIdMsgMap.keySet());
            Map<Long, String> realTimeBizBillIdAcctNameMap = this.checkAcctType(bizBillIds);
            for (Map.Entry<Long, String> bizBillIdAcctName : realTimeBizBillIdAcctNameMap.entrySet()) {
                checkBillIdMsgMap.put(bizBillIdAcctName.getKey(), String.format(acctNameMsg, bizBillIdAcctName.getValue(), realMatMsg));
            }
        }
        bizBillIds.removeAll(checkBillIdMsgMap.keySet());
        this.checkFeeOrShare(bizBillIds, checkBillIdMsgMap);
        bizBillIds.removeAll(checkBillIdMsgMap.keySet());
        this.checkCostestimatebill(bizBillIds, checkBillIdMsgMap);
        return checkBillIdMsgMap;
    }

    private void checkFeeOrShare(Collection<Long> bizBillIds, Map<Long, String> checkBillIdMsgMap) {
        if (bizBillIds.isEmpty()) {
            return;
        }
        String hasEsMsg = ResManager.loadKDString((String)"\u5355\u636e\u5df2\u8d39\u7528\u6682\u4f30\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u540c\u6b65\u3002", (String)"ReSyncServiceImpl_4", (String)"fi-cal-mservice", (Object[])new Object[0]);
        String hasShareMsg = ResManager.loadKDString((String)"\u5355\u636e\u5df2\u8d39\u7528\u5206\u644a\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u540c\u6b65\u3002", (String)"ReSyncServiceImpl_5", (String)"fi-cal-mservice", (Object[])new Object[0]);
        QFilter acctEnableF = new QFilter("costaccount.enable", "=", (Object)"1");
        DynamicObject[] costrecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"id,billno,bizbillid,entry.bizbillentryid,subentryentity.id,subentryentityest.id", (QFilter[])new QFilter("bizbillid", "in", bizBillIds).and(acctEnableF).toArray());
        HashSet<Object> costRecordIdSet = new HashSet<Object>(costrecords.length);
        HashSet<Long> bizbillentryidSet = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : costrecords) {
            costRecordIdSet.add(dynamicObject.getPkValue());
            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                bizbillentryidSet.add(entry.getLong("bizbillentryid"));
            }
        }
        HashSet<Long> hasEsCRIds = new HashSet<Long>(4);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjustbill", (String)"entryentity.invbillid", (QFilter[])new QFilter("entryentity.invbillid", "in", costRecordIdSet).and("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.FEE_ESTIMATE.getValue()).and(acctEnableF).toArray(), null);){
            for (Row row : dataSet) {
                hasEsCRIds.add(row.getLong("entryentity.invbillid"));
            }
        }
        HashSet<Long> hasShareCRIds = new HashSet<Long>(4);
        Throwable throwable = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjustbill", (String)"entryentity.invbillid", (QFilter[])new QFilter("entryentity.invbillid", "in", costRecordIdSet).and("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.FEE_SHARE.getValue()).and(acctEnableF).toArray(), null);){
            for (Row row : dataSet) {
                hasShareCRIds.add(row.getLong("entryentity.invbillid"));
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        HashSet<Long> hasShareBizEntryIds = new HashSet<Long>(4);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_feeshare_newrecord", (String)"entry.bizbillentryid", (QFilter[])new QFilter("entry.bizbillentryid", "in", bizbillentryidSet).and("entry.ismianbill", "=", (Object)"1").toArray(), null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                hasShareBizEntryIds.add(row.getLong("entry.bizbillentryid"));
            }
        }
        catch (Throwable throwable4) {
            object = throwable4;
            throw throwable4;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable5) {
                        ((Throwable)object).addSuppressed(throwable5);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        for (DynamicObject costrecord3 : costrecords) {
            Long costrecordid = costrecord3.getLong("id");
            DynamicObjectCollection entrys = costrecord3.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Long bizbillentryid = entry.getLong("bizbillentryid");
                if (hasShareBizEntryIds.contains(bizbillentryid)) {
                    checkBillIdMsgMap.put(costrecord3.getLong("bizbillid"), hasShareMsg);
                    continue;
                }
                DynamicObjectCollection estimateEntry = entry.getDynamicObjectCollection("subentryentityest");
                DynamicObjectCollection divideEntry = entry.getDynamicObjectCollection("subentryentity");
                if (estimateEntry != null && !estimateEntry.isEmpty() || hasEsCRIds.contains(costrecordid)) {
                    checkBillIdMsgMap.put(costrecord3.getLong("bizbillid"), hasEsMsg);
                }
                if ((divideEntry == null || divideEntry.isEmpty()) && !hasShareCRIds.contains(costrecordid)) continue;
                checkBillIdMsgMap.put(costrecord3.getLong("bizbillid"), hasShareMsg);
            }
        }
    }

    private void checkCostestimatebill(Collection<Long> bizBillIds, Map<Long, String> checkBillIdMsgMap) {
        if (bizBillIds.isEmpty()) {
            return;
        }
        String costestimateBillMsg = ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u4f30\u8c03\u4ef7\u7684\u6210\u672c\u8c03\u6574\u5355\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u540c\u6b65\u3002", (String)"ReSyncServiceImpl_9", (String)"fi-cal-mservice", (Object[])new Object[0]);
        QFilter acctEnableF = new QFilter("costaccount.enable", "=", (Object)"1");
        DynamicObject[] costrecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"id,bizbillid", (QFilter[])new QFilter("bizbillid", "in", bizBillIds).and(acctEnableF).toArray());
        if (costrecords != null && costrecords.length > 0) {
            DynamicObject[] costadjustbills;
            HashSet<Object> costRecordIdSet = new HashSet<Object>(costrecords.length);
            for (DynamicObject costrecord : costrecords) {
                costRecordIdSet.add(costrecord.getPkValue());
            }
            HashSet<Long> costestimateBillIds = new HashSet<Long>(16);
            if (costRecordIdSet.size() > 0 && (costadjustbills = BusinessDataServiceHelper.load((String)"cal_costadjustbill", (String)"entryentity.invbillid", (QFilter[])new QFilter("entryentity.invbillid", "in", costRecordIdSet).and("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.PUR_ADJUSTESTIMATE.getValue()).and(acctEnableF).toArray())) != null && costadjustbills.length > 0) {
                for (DynamicObject costadjustbill : costadjustbills) {
                    Long costRecordId = costadjustbill.getLong("entryentity.invbillid");
                    costestimateBillIds.add(costRecordId);
                }
            }
            if (costestimateBillIds.size() > 0) {
                for (DynamicObject costrecord : costrecords) {
                    Long id = costrecord.getLong("id");
                    Long bizbillid = costrecord.getLong("bizbillid");
                    if (!costestimateBillIds.contains(id)) continue;
                    checkBillIdMsgMap.put(bizbillid, costestimateBillMsg);
                }
            }
        }
    }
}

