/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cal.business.helper.NewRepairStandardCostHelper;
import kd.fi.cal.business.helper.RepairStandardCostHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.mservice.api.RepairStandardCostService;

public class RepairStandardCostServiceImpl
implements RepairStandardCostService {
    private static final Log logger = LogFactory.getLog(RepairStandardCostServiceImpl.class);

    public void repairStandardCostCreateDiffBill(Long calorgId, Long costaccountId, Long periodId, Set<Long> calrangeIds, Set<Long> materialIds, Set<String> allocDimKeyCols, String allDims) {
        try (AlgoContext context = Algo.newContext();){
            this.checkParam(calorgId, costaccountId, periodId);
            DynamicObject period = BusinessDataServiceHelper.loadSingle((Object)periodId, (String)"bd_period");
            if (null == period) {
                throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"RepairStandardCostServiceImpl_3", (String)"fi-cal-mservice", (Object[])new Object[0]));
            }
            int repairstandmodel = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.REPAIR_STANDARD_MODEL);
            DataSet balanceDataSet = null;
            if (repairstandmodel == 1) {
                String[] balanceFields;
                NewRepairStandardCostHelper repairStandardCostHelper = new NewRepairStandardCostHelper(calorgId);
                balanceDataSet = repairStandardCostHelper.getBalanceDataSet(costaccountId, period, calrangeIds, materialIds, null, calorgId, null, allocDimKeyCols, allDims);
                if (null == balanceDataSet) {
                    logger.info("RepairStandardCostServiceImpl repairStandardCostCreateDiffBill balanceDataSet is null");
                    return;
                }
                balanceDataSet = balanceDataSet.filter("costsubelement != 0");
                StringBuilder newFieldsb = new StringBuilder();
                StringBuilder newFieldGsb = new StringBuilder();
                for (String field : balanceFields = balanceDataSet.getRowMeta().getFieldNames()) {
                    if ("periodendstandardcost".equals(field) || "unitstandardcost".equals(field) || "periodendqty".equals(field)) continue;
                    newFieldsb.append(field);
                    newFieldsb.append(",");
                    if ("costelement".equals(field) || "costsubelement".equals(field) || "id".equals(field)) continue;
                    newFieldGsb.append(field);
                    newFieldGsb.append(",");
                }
                String newFieldStr = newFieldsb.substring(0, newFieldsb.length() - 1);
                String newFieldGStr = newFieldGsb.substring(0, newFieldGsb.length() - 1);
                DataSet costInfoDataSet = repairStandardCostHelper.getMatCostInfoDataSet(calorgId, materialIds, period, costaccountId, null, null, balanceDataSet.copy(), newFieldGStr);
                if (null == costInfoDataSet || costInfoDataSet.copy().isEmpty()) {
                    logger.info("RepairStandardCostServiceImpl repairStandardCostCreateDiffBill costInfoDataSet is null");
                    return;
                }
                DataSet balanceDataSetCopy = balanceDataSet.copy();
                costInfoDataSet = costInfoDataSet.select(balanceDataSet.getRowMeta().getFieldNames());
                String groupSts = newFieldStr.replace(",id,", ",") + ",periodendstandardcost,unitstandardcost,periodendqty";
                costInfoDataSet = costInfoDataSet.groupBy(groupSts.split(",")).finish();
                DataSet allDataSet = balanceDataSet.select(costInfoDataSet.getRowMeta().getFieldNames()).union(costInfoDataSet).groupBy(newFieldStr.replace(",id,", ",").split(",")).sum("periodendstandardcost").sum("unitstandardcost").sum("periodendqty").finish();
                allDataSet = allDataSet.filter("periodendstandardcost != 0");
                repairStandardCostHelper.createDiffBill(balanceDataSetCopy, allDataSet, calorgId, (Object)costaccountId, period.getDate("begindate"), newFieldGStr);
            } else {
                RepairStandardCostHelper repairStandardCostHelper = new RepairStandardCostHelper(calorgId);
                balanceDataSet = repairStandardCostHelper.getBalanceDataSet(costaccountId, period, calrangeIds, materialIds, null, calorgId, null, allocDimKeyCols, allDims);
                if (null == balanceDataSet) {
                    logger.info("RepairStandardCostServiceImpl repairStandardCostCreateDiffBill balanceDataSet is null");
                    return;
                }
                balanceDataSet = balanceDataSet.filter("costsubelement != 0");
                StringBuilder newFieldsb = new StringBuilder();
                StringBuilder newFieldGsb = new StringBuilder();
                String[] balanceFields = balanceDataSet.getRowMeta().getFieldNames();
                for (String field : balanceFields) {
                    if ("periodendstandardcost".equals(field) || "unitstandardcost".equals(field) || "periodendqty".equals(field)) continue;
                    newFieldsb.append(field);
                    newFieldsb.append(",");
                    if ("costelement".equals(field) || "costsubelement".equals(field) || "id".equals(field)) continue;
                    newFieldGsb.append(field);
                    newFieldGsb.append(",");
                }
                String newFieldStr = newFieldsb.substring(0, newFieldsb.length() - 1);
                String newFieldGStr = newFieldGsb.substring(0, newFieldGsb.length() - 1);
                DataSet costInfoDataSet = repairStandardCostHelper.getMatCostInfoDataSet(calorgId, materialIds, period, costaccountId, null, null, balanceDataSet.copy(), newFieldGStr);
                if (null == costInfoDataSet || costInfoDataSet.copy().isEmpty()) {
                    logger.info("RepairStandardCostServiceImpl repairStandardCostCreateDiffBill costInfoDataSet is null");
                    return;
                }
                DataSet balanceDataSetCopy = balanceDataSet.copy();
                costInfoDataSet = costInfoDataSet.select(balanceDataSet.getRowMeta().getFieldNames());
                String groupSts = newFieldStr.replace(",id,", ",") + ",periodendstandardcost,unitstandardcost,periodendqty";
                costInfoDataSet = costInfoDataSet.groupBy(groupSts.split(",")).finish();
                DataSet allDataSet = balanceDataSet.select(costInfoDataSet.getRowMeta().getFieldNames()).union(costInfoDataSet).groupBy(newFieldStr.replace(",id,", ",").split(",")).sum("periodendstandardcost").sum("unitstandardcost").sum("periodendqty").finish();
                repairStandardCostHelper.createDiffBill(balanceDataSetCopy, allDataSet, calorgId, (Object)costaccountId, period.getDate("begindate"), newFieldGStr);
            }
        }
        catch (Exception e) {
            logger.error("RepairStandardCostServiceImpl repairStandardCostCreateDiffBill", (Throwable)e);
            throw new KDBizException("RepairStandardCostServiceImpl.repairStandardCostCreateDiffBill throw exception");
        }
    }

    private void checkParam(Long calorgId, Long costaccountId, Long periodId) {
        if (null == calorgId) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"RepairStandardCostServiceImpl_1", (String)"fi-cal-mservice", (Object[])new Object[0]));
        }
        if (null == costaccountId) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"RepairStandardCostServiceImpl_2", (String)"fi-cal-mservice", (Object[])new Object[0]));
        }
        if (null == periodId) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"RepairStandardCostServiceImpl_3", (String)"fi-cal-mservice", (Object[])new Object[0]));
        }
    }
}

