/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.helper.DomainBalHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.DeleteVoucherValidHelper;
import kd.fi.cal.common.helper.PeriodVoucherValidHelper;
import kd.fi.cal.common.model.CalBatchDelCRVoucherInfo;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.mservice.FiApVoucherWriteBack;
import kd.fi.cal.mservice.api.VoucherWriteBackService;

public class VoucherWriteBackServiceImpl
implements VoucherWriteBackService {
    private static final Log logger = LogFactory.getLog(VoucherWriteBackServiceImpl.class);

    public void costRecordWriteBack(String VoucherOperationValue, Set<Long> ids, long voucherid, String voucherNumber) {
        HashMap<Long, Set<Long>> voucherBillMap = new HashMap<Long, Set<Long>>(8);
        voucherBillMap.put(voucherid, ids);
        HashMap<Long, String> voucherNumMap = new HashMap<Long, String>(8);
        voucherNumMap.put(voucherid, voucherNumber);
        this.batchCostRecordWriteBack(VoucherOperationValue, voucherBillMap, voucherNumMap);
    }

    public void batchCostRecordWriteBack(String VoucherOperationValue, Map<Long, Set<Long>> voucherBillMap, Map<Long, String> voucherNumMap) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.doBbatchCostRecordWriteBack(VoucherOperationValue, voucherBillMap, voucherNumMap);
            }
            catch (Throwable e) {
                tx.markRollback();
                logger.error("VoucherWriteBackServiceImpl-batchCostRecordWriteBack", e);
                throw e;
            }
        }
    }

    private void doBbatchCostRecordWriteBack(String VoucherOperationValue, Map<Long, Set<Long>> voucherBillMap, Map<Long, String> voucherNumMap) {
        boolean needUpdateDomainBal;
        Serializable billSet;
        long startTime = System.currentTimeMillis();
        HashMap voucherCostRecordsMap = new HashMap(voucherBillMap.size());
        HashSet<Long> allBillIds = new HashSet<Long>(voucherBillMap.size());
        for (Set<Long> set : voucherBillMap.values()) {
            allBillIds.addAll(set);
        }
        HashMap<Long, DynamicObject> costRecordMap = new HashMap<Long, DynamicObject>(32);
        HashSet<Long> delVouchers = new HashSet<Long>(voucherBillMap.size());
        DynamicObjectCollection allCostRecords = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,bizbillid,vouchertype,bizentityobject,calorg,costaccount,dischargetype", (QFilter[])new QFilter[]{new QFilter("id", "in", allBillIds)});
        if (allCostRecords.isEmpty()) {
            logger.info("costRecordWriteBack-\u5bf9\u5e94\u7684\u6210\u672c\u8bb0\u5f55\u5df2\u4e0d\u5b58\u5728");
            return;
        }
        for (DynamicObject info : allCostRecords) {
            costRecordMap.put(info.getLong("id"), info);
        }
        allBillIds.clear();
        for (Map.Entry<Long, Set<Long>> entry : voucherBillMap.entrySet()) {
            Long voucherId = entry.getKey();
            Set<Long> billIds = entry.getValue();
            billSet = new HashSet<DynamicObject>(billIds.size());
            for (Long id : billIds) {
                DynamicObject billInfo = (DynamicObject)costRecordMap.get(id);
                if (billInfo == null) continue;
                billSet.add(billInfo);
                allBillIds.add(id);
            }
            voucherCostRecordsMap.put(voucherId, billSet);
        }
        String calVoucherType = "";
        HashSet<String> hasVoucherSet = new HashSet<String>(16);
        QFilter q = new QFilter("voucherid", "in", voucherBillMap.keySet());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_voucher", (String)"voucherid,vouchertype,id,costrecordid", (QFilter[])new QFilter[]{q}, null);
        billSet = null;
        try {
            for (Row row : dataSet) {
                calVoucherType = row.getString("vouchertype");
                String key = String.valueOf(row.getLong("voucherid")) + "_" + String.valueOf(row.getLong("costrecordid"));
                hasVoucherSet.add(key);
            }
        }
        catch (Throwable throwable) {
            billSet = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (billSet != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)billSet).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        HashMap<Long, DynamicObject> voucherMap = new HashMap<Long, DynamicObject>(voucherBillMap.size());
        if ("1".equals(VoucherOperationValue)) {
            DynamicObject[] vouchers;
            for (DynamicObject voucher : vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,billno,org,booktype,bizdate,bookeddate,createtime,vouchertype,period.periodyear,period.periodnumber", (QFilter[])new QFilter("id", "in", voucherBillMap.keySet()).toArray())) {
                voucherMap.put(voucher.getLong("id"), voucher);
            }
        }
        String isvoucherCol = "fisfivoucher";
        String vouchernumCol = "ffivouchernum";
        String voucherIdCol = "ffivoucherid";
        String voucherType = "";
        DynamicObject firstCostRecord = (DynamicObject)allCostRecords.get(0);
        Long costAccountId = firstCostRecord.getLong("costaccount");
        voucherType = "1".equals(VoucherOperationValue) ? firstCostRecord.getString("vouchertype") : calVoucherType;
        if (StringUtils.isBlank((CharSequence)voucherType)) {
            voucherType = "A";
            logger.info("costRecordWriteBack-\u51ed\u8bc1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u51ed\u8bc1\u7c7b\u578b\u4e3a" + voucherType);
        }
        if ("A".equals(voucherType)) {
            isvoucherCol = "fisfivoucher";
            vouchernumCol = "ffivouchernum";
            voucherIdCol = "ffivoucherid";
        } else if ("B".equals(voucherType)) {
            isvoucherCol = "fistempvoucher";
            vouchernumCol = "ftempvouchernum";
            voucherIdCol = "ftempvoucherid";
        } else if ("C".equals(voucherType)) {
            isvoucherCol = "fisdischargevoucher";
            vouchernumCol = "fdischargevouchernum";
            voucherIdCol = "fdischargevoucherid";
        } else if ("D".equals(voucherType)) {
            isvoucherCol = "fiscostcarryover";
            vouchernumCol = "fcarryovervouchernum";
            voucherIdCol = "fcarryovervoucherid";
        } else if ("E".equals(voucherType)) {
            isvoucherCol = "fisfeevoucher";
            vouchernumCol = "ffeevouchernum";
            voucherIdCol = "ffeevoucherid";
        }
        String voucherOperation = "";
        voucherOperation = "1".equals(VoucherOperationValue) ? ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1", (String)"VoucherWriteBackServiceImpl_1", (String)"fi-cal-mservice", (Object[])new Object[0]) : ("2".equals(VoucherOperationValue) ? ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1", (String)"VoucherWriteBackServiceImpl_2", (String)"fi-cal-mservice", (Object[])new Object[0]) : VoucherOperationValue);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(voucherBillMap.size());
        HashSet<DynamicObject> calVouchers = new HashSet<DynamicObject>(allBillIds.size());
        int costRecordSize = allBillIds.size();
        Map.Entry<Long, String> firstVoucher = voucherNumMap.entrySet().iterator().next();
        logger.info("costRecordWriteBack-\u5f00\u59cb" + voucherOperation + "\u53cd\u5199\uff0c\u7b2c\u4e00\u5f20\u51ed\u8bc1id\u4e3a" + firstVoucher.getKey() + "\uff0c\u51ed\u8bc1\u53f7\u4e3a" + firstVoucher.getValue() + "\uff0c\u5355\u91cf\u4e3a" + costRecordSize + "\u6761");
        HashSet<Long> logVouIds = new HashSet<Long>(16);
        HashMap<String, Set<Long>> bizEntityBillMap = new HashMap<String, Set<Long>>(16);
        HashMap<String, Set<Long>> bizEntityBizBillMap = new HashMap<String, Set<Long>>(16);
        HashSet<Long> allUpdateBillIds = new HashSet<Long>(16);
        Integer batchNum = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.COMMON_SPLITBATCHNUM);
        if (batchNum == null) {
            batchNum = 1000;
        }
        for (Map.Entry<Long, Set<Long>> entry : voucherBillMap.entrySet()) {
            Long voucherId = entry.getKey();
            Set costRecords = (Set)voucherCostRecordsMap.get(voucherId);
            if (null == costRecords || costRecords.isEmpty()) {
                if (!"2".equals(VoucherOperationValue)) continue;
                delVouchers.add(voucherId);
                continue;
            }
            Set<Long> billIds = entry.getValue();
            String voucherNumber = voucherNumMap.get(voucherId);
            logVouIds.add(voucherId);
            if ("1".equals(VoucherOperationValue)) {
                DynamicObject voucher = (DynamicObject)voucherMap.get(voucherId);
                for (Long billId : billIds) {
                    paramList.add(new Object[]{voucher.get("billno"), voucher.getPkValue(), billId});
                }
                calVouchers.addAll(this.getCalVouchers(costRecords, hasVoucherSet, voucher, "A", voucherType));
            } else if ("2".equals(VoucherOperationValue)) {
                delVouchers.add(voucherId);
            } else {
                for (Long billId : billIds) {
                    paramList.add(new Object[]{voucherNumber, billId});
                }
            }
            for (DynamicObject info : costRecords) {
                String bizEntity = info.getString("bizentityobject");
                Long billId = info.getLong("id");
                HashSet<Long> idSet = (HashSet<Long>)bizEntityBillMap.get(bizEntity);
                HashSet<Long> bizBillIdSet = (HashSet<Long>)bizEntityBizBillMap.get(bizEntity);
                if (idSet == null) {
                    idSet = new HashSet<Long>(16);
                    bizEntityBillMap.put(bizEntity, idSet);
                }
                if (bizBillIdSet == null) {
                    bizBillIdSet = new HashSet<Long>(16);
                    bizEntityBizBillMap.put(bizEntity, bizBillIdSet);
                }
                idSet.add(billId);
                bizBillIdSet.add(info.getLong("bizbillid"));
            }
            allUpdateBillIds.addAll(billIds);
            if (paramList.size() <= batchNum && delVouchers.size() <= batchNum) continue;
            TXHandle tx = TX.requiresNew();
            Object object = null;
            try {
                this.updateDeleteVouchers(VoucherOperationValue, allUpdateBillIds, delVouchers, isvoucherCol, vouchernumCol, voucherIdCol, voucherType, costAccountId, bizEntityBillMap, bizEntityBizBillMap, paramList, calVouchers);
                allUpdateBillIds.clear();
                delVouchers.clear();
                bizEntityBillMap.clear();
                bizEntityBizBillMap.clear();
                paramList.clear();
                calVouchers.clear();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx == null) continue;
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    continue;
                }
                tx.close();
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            this.updateDeleteVouchers(VoucherOperationValue, allUpdateBillIds, delVouchers, isvoucherCol, vouchernumCol, voucherIdCol, voucherType, costAccountId, bizEntityBillMap, bizEntityBizBillMap, paramList, calVouchers);
        }
        logger.info("costRecordWriteBack-\u51ed\u8bc1\u7c7b\u578b\u4e3a" + voucherType + "\uff0c\u51ed\u8bc1id\u4e3a==>{}" + logVouIds);
        if ("1".equals(VoucherOperationValue)) {
            boolean needUpdateDomainBal2 = new DomainBalHelper().needUpdateDomainBal();
            if (needUpdateDomainBal2) {
                new BalanceOpInvoker().invokeCostRecordUpdateBalOp(allBillIds, null);
            }
        } else if ("2".equals(VoucherOperationValue) && (needUpdateDomainBal = new DomainBalHelper().needUpdateDomainBal())) {
            new BalanceOpInvoker().invokeCostRecordUpdateBalOp(allBillIds, null);
        }
        logger.info("costRecordWriteBack-\u7ed3\u675f" + voucherOperation + "\u53cd\u5199\uff0c\u7b2c\u4e00\u5f20\u51ed\u8bc1id\u4e3a" + firstVoucher.getKey() + "\uff0c\u5355\u91cf\u4e3a" + costRecordSize + "\u6761\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
    }

    private void updateDeleteVouchers(String VoucherOperationValue, Set<Long> allBillIds, Set<Long> delVouchers, String isvoucherCol, String vouchernumCol, String voucherIdCol, String voucherType, Long costAccountId, Map<String, Set<Long>> bizEntityBillMap, Map<String, Set<Long>> bizEntityBizBillMap, List<Object[]> paramList, Set<DynamicObject> calVouchers) {
        if ("1".equals(VoucherOperationValue)) {
            if (!paramList.isEmpty()) {
                String updateSql = "update t_cal_calcostrecord set " + isvoucherCol + " = '1'," + vouchernumCol + "= ?," + voucherIdCol + " = ? where fid = ?";
                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateSql, paramList);
            }
            if (!calVouchers.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])calVouchers.toArray(new DynamicObject[0]));
            }
            if (!allBillIds.isEmpty()) {
                for (Map.Entry<String, Set<Long>> e : bizEntityBillMap.entrySet()) {
                    Object splitBizBillSet2;
                    String bizEntity = e.getKey();
                    Set<Long> idSet = e.getValue();
                    Set<Long> bizBillIdSet = bizEntityBizBillMap.get(bizEntity);
                    List splitBizBillList = CommonUtils.getSplitList(bizBillIdSet);
                    for (Object splitBizBillSet2 : splitBizBillList) {
                        if (!"im_saloutbill".equals(bizEntity) || !"A".equals(voucherType)) continue;
                        this.writeChildVoucher4Salout(costAccountId, (Set<Long>)splitBizBillSet2, true, "isfivoucher");
                    }
                    List splitList = CommonUtils.getSplitList(idSet);
                    splitBizBillSet2 = splitList.iterator();
                    while (splitBizBillSet2.hasNext()) {
                        Set billIdSet = (Set)splitBizBillSet2.next();
                        if ("B".equals(voucherType)) {
                            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_calcostrecord set fisdischargevoucher = '0' where fdischargetype = 'B' and fid in (" + StringUtils.join((Object[])billIdSet.toArray(), (char)',') + ")"));
                            this.writeChildVoucher4Temp(billIdSet, true, "istempvoucher");
                        }
                        this.writeBackIsVoucherSelect(billIdSet);
                    }
                }
            }
        } else if ("2".equals(VoucherOperationValue)) {
            if (!delVouchers.isEmpty()) {
                this.delCalVouchers(delVouchers, allBillIds);
            }
            if (!allBillIds.isEmpty()) {
                for (Map.Entry<String, Set<Long>> e : bizEntityBillMap.entrySet()) {
                    String bizEntity = e.getKey();
                    Set<Long> idSet = e.getValue();
                    Set<Long> bizBillIdSet = bizEntityBizBillMap.get(bizEntity);
                    List splitBizBillList = CommonUtils.getSplitList(bizBillIdSet);
                    for (Set splitBizBillSet : splitBizBillList) {
                        if (!"im_saloutbill".equals(bizEntity) || !"A".equals(voucherType)) continue;
                        this.writeChildVoucher4Salout(costAccountId, splitBizBillSet, false, "isfivoucher");
                    }
                    List splitList = CommonUtils.getSplitList(idSet);
                    Iterator iterator = splitList.iterator();
                    while (iterator.hasNext()) {
                        Set billIdSet = (Set)iterator.next();
                        ArrayList<Object[]> paramValList = new ArrayList<Object[]>(billIdSet.size());
                        for (Long id : billIdSet) {
                            Object[] val = new Object[]{id};
                            paramValList.add(val);
                        }
                        String updateSql = "update t_cal_calcostrecord set " + isvoucherCol + " = '0'," + vouchernumCol + " = ' '," + voucherIdCol + " = 0 where fid = ?";
                        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateSql, paramValList);
                        if ("B".equals(voucherType)) {
                            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_calcostrecord set fisdischargevoucher = '1' where fdischargetype = 'B' and fdischargevouchernum !=' ' and fid in (" + StringUtils.join((Object[])billIdSet.toArray(), (char)',') + ")"));
                            this.writeChildVoucher4Temp(billIdSet, false, "istempvoucher");
                        }
                        this.writeBackIsVoucherUncheck(billIdSet);
                    }
                }
            }
        } else if (!paramList.isEmpty()) {
            String updateSql = "update t_cal_calcostrecord set " + vouchernumCol + " = ? where fid = ? ";
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateSql, paramList);
        }
    }

    private void deleteCostRecordQueueVoucher(Set<Long> ids) {
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,isfivoucher,istempvoucher,isdischargevoucher,isfeevoucher,iscostcarryover", (QFilter[])new QFilter("id", "in", ids).toArray());
        HashSet<Long> mergeIds = new HashSet<Long>();
        for (DynamicObject costRecord : costRecords) {
            if (costRecord.getBoolean("isfivoucher") || costRecord.getBoolean("istempvoucher") || costRecord.getBoolean("isdischargevoucher") || costRecord.getBoolean("isfeevoucher") || costRecord.getBoolean("iscostcarryover")) continue;
            mergeIds.add(costRecord.getLong("id"));
        }
        if (mergeIds.isEmpty()) {
            return;
        }
    }

    public void fiApWriteBack(String VoucherOperationValue, Set<Long> ids, long voucherid, String voucherNumber) {
        HashMap<Long, Set<Long>> voucherBillMap = new HashMap<Long, Set<Long>>(8);
        voucherBillMap.put(voucherid, ids);
        HashMap<Long, String> voucherNumMap = new HashMap<Long, String>(8);
        voucherNumMap.put(voucherid, voucherNumber);
        new FiApVoucherWriteBack().batchFiApWriteBack(VoucherOperationValue, voucherBillMap, voucherNumMap);
    }

    public void batchFiApWriteBack(String VoucherOperationValue, Map<Long, Set<Long>> voucherBillMap, Map<Long, String> voucherNumMap) {
        new FiApVoucherWriteBack().batchFiApWriteBack(VoucherOperationValue, voucherBillMap, voucherNumMap);
    }

    public void writeOffWriteBack(String voucherOperationValue, Long writeOffId, long voucherId, String voucherNumber) {
        block83: {
            long startTime = System.currentTimeMillis();
            String voucherOperation = "";
            if ("1".equals(voucherOperationValue)) {
                voucherOperation = ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1", (String)"VoucherWriteBackServiceImpl_1", (String)"fi-cal-mservice", (Object[])new Object[0]);
            } else if ("2".equals(voucherOperationValue)) {
                voucherOperation = ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1", (String)"VoucherWriteBackServiceImpl_2", (String)"fi-cal-mservice", (Object[])new Object[0]);
            }
            try (TXHandle h = TX.requiresNew();){
                if (writeOffId == null) {
                    return;
                }
                QFilter arQfilter = new QFilter("id", "=", (Object)writeOffId);
                DynamicObject arVerifyRecord = QueryServiceHelper.queryOne((String)"ar_verifyrecord", (String)"id,verifyrelation", (QFilter[])new QFilter[]{arQfilter});
                if (arVerifyRecord == null) {
                    logger.info("writeOffWriteBack-\u5f02\u5e38\uff0c\u6838\u9500id\u5bf9\u5e94\u7684\u6838\u9500\u8bb0\u5f55\u4e0d\u5b58\u5728\u5f53\u524d\u65f6\u95f4\uff1a" + System.currentTimeMillis());
                    return;
                }
                String voucherType = this.getVoucherTypeByVerifyRelation(arVerifyRecord.getString("verifyrelation"));
                if (voucherType == null) {
                    logger.info("writeOffWriteBack: writeOffId=" + writeOffId + "\u5bf9\u5e94\u7684\u6838\u9500\u5173\u7cfb\u4e0d\u662f \u51fa\u5e93\u6838\u9500\u3001\u5165\u5e93\u6838\u9500\u3001\u51fa\u5e93\u7ea2\u51b2\u7c7b\u578b\uff0c\u9ed8\u8ba4\u4e0d\u53cd\u5199\u51ed\u8bc1\u3002\u5f53\u524d\u65f6\u95f4\uff1a" + System.currentTimeMillis());
                    return;
                }
                try {
                    Throwable throwable;
                    HashSet<Long> writeOffIds = new HashSet<Long>();
                    writeOffIds.add(writeOffId);
                    HashSet<Long> recordIdSet = new HashSet<Long>();
                    QFilter q = new QFilter("entry.writeoffid", "in", writeOffIds);
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id", (QFilter[])new QFilter[]{q}, null);){
                        for (Row row : dataSet) {
                            recordIdSet.add(row.getLong("id"));
                        }
                    }
                    if (recordIdSet.isEmpty()) break block83;
                    int costRecordSize = recordIdSet.size();
                    logger.info("writeOffWriteBack-\u5f00\u59cb" + voucherOperation + "\u53cd\u5199\uff0c\u51ed\u8bc1id\u4e3a" + voucherId + ",\u5355\u91cf\u4e3a" + costRecordSize + "\u6761\uff1a");
                    if (StringUtils.isBlank((CharSequence)voucherType)) {
                        voucherType = "A";
                    }
                    String isvoucherCol = "fisfivoucher";
                    String vouchernumCol = "ffivouchernum";
                    String voucherIdCol = "ffivoucherid";
                    if ("A".equals(voucherType)) {
                        isvoucherCol = "fisfivoucher";
                        vouchernumCol = "ffivouchernum";
                        voucherIdCol = "ffivoucherid";
                    } else if ("B".equals(voucherType)) {
                        isvoucherCol = "fistempvoucher";
                        vouchernumCol = "ftempvouchernum";
                        voucherIdCol = "ftempvoucherid";
                    } else if ("C".equals(voucherType)) {
                        isvoucherCol = "fisdischargevoucher";
                        vouchernumCol = "fdischargevouchernum";
                        voucherIdCol = "fdischargevoucherid";
                    } else if ("D".equals(voucherType)) {
                        isvoucherCol = "fiscostcarryover";
                        vouchernumCol = "fcarryovervouchernum";
                        voucherIdCol = "fcarryovervoucherid";
                    } else if ("E".equals(voucherType)) {
                        isvoucherCol = "fisfeevoucher";
                        vouchernumCol = "ffeevouchernum";
                        voucherIdCol = "ffeevoucherid";
                    }
                    DynamicObject voucher = null;
                    if ("1".equals(voucherOperationValue)) {
                        voucher = BusinessDataServiceHelper.loadSingle((Object)voucherId, (String)"gl_voucher", (String)"id,billno,org,booktype,bizdate,bookeddate,createtime,vouchertype,period.periodyear,period.periodnumber");
                        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_calcostrecord set " + isvoucherCol + " = '1'," + vouchernumCol + " = ?," + voucherIdCol + " = ? where fid in (" + StringUtils.join((Object[])recordIdSet.toArray(), (char)',') + ")"), (Object[])new Object[]{voucher.get("billno"), voucher.getPkValue()});
                        Set<String> hasVoucherSet = this.addCalVouchers(recordIdSet, voucher, "C", voucherType);
                        throwable = null;
                        try (TXHandle h1 = TX.requiresNew();){
                            this.addDapTracks("cal_costrecord_subentity", voucher, recordIdSet, hasVoucherSet);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        this.writeBackIsVoucherSelect(recordIdSet);
                    } else if ("2".equals(voucherOperationValue)) {
                        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_calcostrecord set " + isvoucherCol + " = '0'," + vouchernumCol + " = ' '," + voucherIdCol + " = 0 where fid in (" + StringUtils.join((Object[])recordIdSet.toArray(), (char)',') + ")"));
                        this.deleteCostRecordQueueVoucher(recordIdSet);
                        this.delCalVouchers(voucherId);
                        this.writeBackIsVoucherUncheck(recordIdSet);
                    } else {
                        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_calcostrecord set ffivouchernum = ? where fid in (" + StringUtils.join((Object[])recordIdSet.toArray(), (char)',') + ")"), (Object[])new Object[]{voucherNumber});
                    }
                    HashSet<Long> costAdjustSet = new HashSet<Long>();
                    q = new QFilter("entryentity.invbillid", "in", recordIdSet);
                    throwable = null;
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjustbill", (String)"id", (QFilter[])new QFilter[]{q}, null);){
                        for (Row row : dataSet) {
                            costAdjustSet.add(row.getLong("id"));
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    if (!costAdjustSet.isEmpty()) {
                        this.costAdjustWriteBack(voucherOperationValue, costAdjustSet, voucher, voucherNumber, true);
                    }
                    logger.info("writeOffWriteBack-\u7ed3\u675f" + voucherOperation + "\u53cd\u5199\uff0c\u51ed\u8bc1id\u4e3a" + voucherId + "\uff0c\u5355\u91cf\u4e3a" + costRecordSize + "\u6761\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    private String getVoucherTypeByVerifyRelation(String verifyRelation) {
        String voucherType = null;
        if ("arsalout".equals(verifyRelation) || "arsalreturn".equals(verifyRelation)) {
            voucherType = "D";
        } else if ("salself".equals(verifyRelation)) {
            voucherType = "A";
        }
        return voucherType;
    }

    public void costAdjustWriteBack(String VoucherOperationValue, Set<Long> ids, long voucherid, String voucherNumber) {
        HashMap<Long, Set<Long>> voucherBillMap = new HashMap<Long, Set<Long>>(8);
        voucherBillMap.put(voucherid, ids);
        HashMap<Long, String> voucherNumMap = new HashMap<Long, String>(8);
        voucherNumMap.put(voucherid, voucherNumber);
        this.batchCostAdjustWriteBack(VoucherOperationValue, voucherBillMap, voucherNumMap);
    }

    private void costAdjustWriteBack(String VoucherOperationValue, Set<Long> costAdjustSet, DynamicObject voucher, String voucherNumber, boolean isAddDap) {
        if ("1".equals(VoucherOperationValue)) {
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_costadjustbill set fisvoucher = '1',fvouchernum = ?,fvoucherid = ? where fid in (" + StringUtils.join((Object[])costAdjustSet.toArray(), (char)',') + ")"), (Object[])new Object[]{voucher.get("billno"), voucher.getPkValue()});
            if (isAddDap) {
                try (TXHandle h1 = TX.requiresNew();){
                    this.addDapTracks("cal_costadjust_subentity", voucher, costAdjustSet, null);
                }
            }
        } else if ("2".equals(VoucherOperationValue)) {
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_costadjustbill set fisvoucher = '0',fvouchernum = ' ',fvoucherid = 0 where fid in (" + StringUtils.join((Object[])costAdjustSet.toArray(), (char)',') + ")"));
        } else {
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_costadjustbill set fvouchernum = ? where fid in (" + StringUtils.join((Object[])costAdjustSet.toArray(), (char)',') + ")"), (Object[])new Object[]{voucherNumber});
        }
    }

    public void batchCostAdjustWriteBack(String VoucherOperationValue, Map<Long, Set<Long>> voucherAdjustBillIdsMap, Map<Long, String> voucherNumMap) {
        HashMap<Long, DynamicObject> voucherMap = new HashMap<Long, DynamicObject>(voucherAdjustBillIdsMap.size());
        if (!"2".equals(VoucherOperationValue)) {
            DynamicObject[] vouchers;
            for (DynamicObject voucher : vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,billno,org,booktype,bizdate,bookeddate,createtime,vouchertype,period.periodyear,period.periodnumber", (QFilter[])new QFilter("id", "in", voucherAdjustBillIdsMap.keySet()).toArray())) {
                voucherMap.put(voucher.getLong("id"), voucher);
            }
        }
        this.batchCostAdjustWriteBack(VoucherOperationValue, voucherAdjustBillIdsMap, voucherMap, false, voucherNumMap);
    }

    private void batchCostAdjustWriteBack(String VoucherOperationValue, Map<Long, Set<Long>> voucherAdjustBillIdsMap, Map<Long, DynamicObject> voucherMap, boolean isAddDap, Map<Long, String> voucherNumMap) {
        block53: {
            Throwable throwable;
            TXHandle h1;
            List splitList;
            ArrayList<Object[]> paramList;
            block54: {
                HashSet<Long> allAdjustIds;
                block52: {
                    paramList = new ArrayList<Object[]>(voucherAdjustBillIdsMap.size());
                    HashSet<DynamicObject> dapTracks = new HashSet<DynamicObject>(voucherAdjustBillIdsMap.size());
                    allAdjustIds = new HashSet<Long>(voucherAdjustBillIdsMap.size());
                    for (Set<Long> set : voucherAdjustBillIdsMap.values()) {
                        allAdjustIds.addAll(set);
                    }
                    for (Map.Entry entry : voucherAdjustBillIdsMap.entrySet()) {
                        Long voucherId = (Long)entry.getKey();
                        Set costAdjustSet = (Set)entry.getValue();
                        if (costAdjustSet.isEmpty()) continue;
                        DynamicObject voucher = voucherMap.get(voucherId);
                        if ("1".equals(VoucherOperationValue)) {
                            for (Long costAdjustId : costAdjustSet) {
                                paramList.add(new Object[]{voucher.getString("billno"), voucher.getPkValue(), costAdjustId});
                            }
                            if (!isAddDap) continue;
                            dapTracks.addAll(this.getDapTracks("cal_costadjust_subentity", voucher, costAdjustSet));
                            continue;
                        }
                        if ("2".equals(VoucherOperationValue)) continue;
                        String voucherNum = voucherNumMap.get(voucherId);
                        if (StringUtils.isEmpty((CharSequence)voucherNum)) {
                            voucherNum = voucher.getString("billno");
                        }
                        for (Long costAdjustId : costAdjustSet) {
                            paramList.add(new Object[]{voucherNum, costAdjustId});
                        }
                    }
                    if (!"1".equals(VoucherOperationValue)) break block52;
                    if (!paramList.isEmpty()) {
                        splitList = CommonUtils.getSplitList(paramList);
                        for (List list : splitList) {
                            h1 = TX.requiresNew();
                            throwable = null;
                            try {
                                String updateSql2 = "update t_cal_costadjustbill set fisvoucher = '1',fvouchernum = ?,fvoucherid = ? where fid = ?";
                                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateSql2, (List)list);
                            }
                            catch (Throwable updateSql2) {
                                throwable = updateSql2;
                                throw updateSql2;
                            }
                            finally {
                                if (h1 == null) continue;
                                if (throwable != null) {
                                    try {
                                        h1.close();
                                    }
                                    catch (Throwable updateSql2) {
                                        throwable.addSuppressed(updateSql2);
                                    }
                                    continue;
                                }
                                h1.close();
                            }
                        }
                    }
                    if (dapTracks.isEmpty()) break block53;
                    splitList = CommonUtils.getSplitDynList(dapTracks);
                    for (Set set : splitList) {
                        h1 = TX.requiresNew();
                        throwable = null;
                        try {
                            SaveServiceHelper.save((DynamicObject[])set.toArray(new DynamicObject[0]));
                        }
                        catch (Throwable updateSql2) {
                            throwable = updateSql2;
                            throw updateSql2;
                        }
                        finally {
                            if (h1 == null) continue;
                            if (throwable != null) {
                                try {
                                    h1.close();
                                }
                                catch (Throwable updateSql2) {
                                    throwable.addSuppressed(updateSql2);
                                }
                                continue;
                            }
                            h1.close();
                        }
                    }
                    break block53;
                }
                if (!"2".equals(VoucherOperationValue)) break block54;
                if (allAdjustIds.isEmpty()) break block53;
                splitList = CommonUtils.getSplitList(allAdjustIds);
                for (Set set : splitList) {
                    h1 = TX.requiresNew();
                    throwable = null;
                    try {
                        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_costadjustbill set fisvoucher = '0',fvouchernum = ' ',fvoucherid = 0 where fid in (" + StringUtils.join((Object[])set.toArray(), (char)',') + ")"));
                    }
                    catch (Throwable updateSql2) {
                        throwable = updateSql2;
                        throw updateSql2;
                    }
                    finally {
                        if (h1 == null) continue;
                        if (throwable != null) {
                            try {
                                h1.close();
                            }
                            catch (Throwable updateSql2) {
                                throwable.addSuppressed(updateSql2);
                            }
                            continue;
                        }
                        h1.close();
                    }
                }
                break block53;
            }
            if (!paramList.isEmpty()) {
                splitList = CommonUtils.getSplitList(paramList);
                for (List list : splitList) {
                    h1 = TX.requiresNew();
                    throwable = null;
                    try {
                        String updateSql = "update t_cal_costadjustbill set fvouchernum = ? where fid = ?";
                        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateSql, (List)list);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (h1 == null) continue;
                        if (throwable != null) {
                            try {
                                h1.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        h1.close();
                    }
                }
            }
        }
    }

    public void batchGroupDiffBillWriteBack(String VoucherOperationValue, Map<Long, Set<Long>> voucherAdjustBillIdsMap, Map<Long, String> voucherNumMap) {
        HashMap<Long, DynamicObject> voucherMap = new HashMap<Long, DynamicObject>(voucherAdjustBillIdsMap.size());
        if (!"2".equals(VoucherOperationValue)) {
            DynamicObject[] vouchers;
            for (DynamicObject voucher : vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,billno,org,booktype,bizdate,bookeddate,createtime,vouchertype,period.periodyear,period.periodnumber", (QFilter[])new QFilter("id", "in", voucherAdjustBillIdsMap.keySet()).toArray())) {
                voucherMap.put(voucher.getLong("id"), voucher);
            }
        }
        this.batchGroupDiffBillWriteBack(VoucherOperationValue, voucherAdjustBillIdsMap, voucherMap, false, voucherNumMap);
    }

    private void batchGroupDiffBillWriteBack(String VoucherOperationValue, Map<Long, Set<Long>> voucherGroupDiffBillIdsMap, Map<Long, DynamicObject> voucherMap, boolean isAddDap, Map<Long, String> voucherNumMap) {
        block53: {
            Throwable throwable;
            TXHandle h1;
            List splitList;
            ArrayList<Object[]> paramList;
            block54: {
                HashSet<Long> allGroupBillIds;
                block52: {
                    paramList = new ArrayList<Object[]>(voucherGroupDiffBillIdsMap.size());
                    HashSet<DynamicObject> dapTracks = new HashSet<DynamicObject>(voucherGroupDiffBillIdsMap.size());
                    allGroupBillIds = new HashSet<Long>(voucherGroupDiffBillIdsMap.size());
                    for (Set<Long> set : voucherGroupDiffBillIdsMap.values()) {
                        allGroupBillIds.addAll(set);
                    }
                    for (Map.Entry entry : voucherGroupDiffBillIdsMap.entrySet()) {
                        Long voucherId = (Long)entry.getKey();
                        Set GroupDiffSet = (Set)entry.getValue();
                        if (GroupDiffSet.isEmpty()) continue;
                        DynamicObject voucher = voucherMap.get(voucherId);
                        if ("1".equals(VoucherOperationValue)) {
                            for (Long GroupDifftId : GroupDiffSet) {
                                paramList.add(new Object[]{voucher.getString("billno"), voucher.getPkValue(), GroupDifftId});
                            }
                            if (!isAddDap) continue;
                            dapTracks.addAll(this.getDapTracks("cal_costdiffgroupbill", voucher, GroupDiffSet));
                            continue;
                        }
                        if ("2".equals(VoucherOperationValue)) continue;
                        String voucherNum = voucherNumMap.get(voucherId);
                        if (StringUtils.isEmpty((CharSequence)voucherNum)) {
                            voucherNum = voucher.getString("billno");
                        }
                        for (Long GroupDiffId : GroupDiffSet) {
                            paramList.add(new Object[]{voucherNum, GroupDiffId});
                        }
                    }
                    if (!"1".equals(VoucherOperationValue)) break block52;
                    if (!paramList.isEmpty()) {
                        splitList = CommonUtils.getSplitList(paramList);
                        for (List list : splitList) {
                            h1 = TX.requiresNew();
                            throwable = null;
                            try {
                                String updateSql2 = "update t_cal_diffgroupbill set fisvoucher = '1',fvouchernum = ?,fvoucherid = ? where fid = ?";
                                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateSql2, (List)list);
                            }
                            catch (Throwable updateSql2) {
                                throwable = updateSql2;
                                throw updateSql2;
                            }
                            finally {
                                if (h1 == null) continue;
                                if (throwable != null) {
                                    try {
                                        h1.close();
                                    }
                                    catch (Throwable updateSql2) {
                                        throwable.addSuppressed(updateSql2);
                                    }
                                    continue;
                                }
                                h1.close();
                            }
                        }
                    }
                    if (dapTracks.isEmpty()) break block53;
                    splitList = CommonUtils.getSplitDynList(dapTracks);
                    for (Set set : splitList) {
                        h1 = TX.requiresNew();
                        throwable = null;
                        try {
                            SaveServiceHelper.save((DynamicObject[])set.toArray(new DynamicObject[0]));
                        }
                        catch (Throwable updateSql2) {
                            throwable = updateSql2;
                            throw updateSql2;
                        }
                        finally {
                            if (h1 == null) continue;
                            if (throwable != null) {
                                try {
                                    h1.close();
                                }
                                catch (Throwable updateSql2) {
                                    throwable.addSuppressed(updateSql2);
                                }
                                continue;
                            }
                            h1.close();
                        }
                    }
                    break block53;
                }
                if (!"2".equals(VoucherOperationValue)) break block54;
                if (allGroupBillIds.isEmpty()) break block53;
                splitList = CommonUtils.getSplitList(allGroupBillIds);
                for (Set set : splitList) {
                    h1 = TX.requiresNew();
                    throwable = null;
                    try {
                        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_diffgroupbill set fisvoucher = '0',fvouchernum = ' ',fvoucherid = 0 where fid in (" + StringUtils.join((Object[])set.toArray(), (char)',') + ")"));
                    }
                    catch (Throwable updateSql2) {
                        throwable = updateSql2;
                        throw updateSql2;
                    }
                    finally {
                        if (h1 == null) continue;
                        if (throwable != null) {
                            try {
                                h1.close();
                            }
                            catch (Throwable updateSql2) {
                                throwable.addSuppressed(updateSql2);
                            }
                            continue;
                        }
                        h1.close();
                    }
                }
                break block53;
            }
            if (!paramList.isEmpty()) {
                splitList = CommonUtils.getSplitList(paramList);
                for (List list : splitList) {
                    h1 = TX.requiresNew();
                    throwable = null;
                    try {
                        String updateSql = "update t_cal_diffgroupbill set fvouchernum = ? where fid = ?";
                        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateSql, (List)list);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (h1 == null) continue;
                        if (throwable != null) {
                            try {
                                h1.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        h1.close();
                    }
                }
            }
        }
    }

    public String validate4DelCRVoucher(String VoucherOperationValue, long voucherid) {
        QFilter q = new QFilter("voucherid", "=", (Object)voucherid);
        String voucherType = null;
        String voucherSource = null;
        HashSet<Long> costRecordIdSet = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_voucher", (String)"costrecordid,vouchertype,vouchersource", (QFilter[])new QFilter[]{q}, null);){
            for (Row row : dataSet) {
                if (voucherType == null) {
                    voucherType = row.getString("vouchertype");
                }
                if (voucherSource == null) {
                    voucherSource = row.getString("vouchersource");
                }
                long costRecordId = row.getLong("costrecordid");
                costRecordIdSet.add(costRecordId);
            }
        }
        if (costRecordIdSet.isEmpty()) {
            return null;
        }
        if ("B".equals(voucherSource)) {
            return ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\u7684\u51ed\u8bc1\u3002", (String)"VoucherWriteBackServiceImpl_0", (String)"fi-cal-mservice", (Object[])new Object[0]);
        }
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord", (String)DeleteVoucherValidHelper.costRecordSelect(), (QFilter[])new QFilter[]{new QFilter("id", "in", costRecordIdSet)});
        HashSet<Long> costAccountIdSet = new HashSet<Long>();
        for (DynamicObject record : costRecords) {
            costAccountIdSet.add(record.getLong("costaccount"));
        }
        DeleteVoucherValidHelper delHelper = new DeleteVoucherValidHelper(costAccountIdSet, null);
        PeriodVoucherValidHelper voucherHelper = new PeriodVoucherValidHelper(costAccountIdSet);
        if ("A".equals(voucherType)) {
            return delHelper.doValidate(costRecords, voucherid, false, voucherHelper);
        }
        if ("B".equals(voucherType)) {
            return delHelper.doTempValidate(costRecords, voucherid, voucherHelper, null);
        }
        if ("C".equals(voucherType)) {
            return delHelper.doDischargeValidate(costRecords, voucherid, voucherHelper);
        }
        if ("D".equals(voucherType)) {
            return delHelper.doCarryOverValidate(costRecords, voucherid, voucherHelper);
        }
        if ("E".equals(voucherType)) {
            return delHelper.doFeeValidate(costRecords, voucherid, voucherHelper);
        }
        return null;
    }

    public Map<Long, String> validateBatch4DelCRVoucher(Set<Long> voucherids) {
        DynamicObject[] vocherPeriods;
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        QFilter qFilter = new QFilter("voucherid", "in", voucherids);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_voucher", (String)"costrecordid,vouchersource,voucherid,vouchertype", (QFilter[])new QFilter[]{qFilter}, null);
        HashSet<Long> allCostRecordId = new HashSet<Long>(16);
        HashMap<Long, String> vouchersourceMap = new HashMap<Long, String>(16);
        HashMap<Long, String> vouchertypeMap = new HashMap<Long, String>(16);
        HashMap vouchercostRecordIdMap = new HashMap(16);
        for (Row row : dataSet) {
            HashSet<Long> costRecordIds;
            Long costRecordId = row.getLong("costrecordid");
            allCostRecordId.add(costRecordId);
            Long voucherid = row.getLong("voucherid");
            vouchersourceMap.put(voucherid, row.getString("vouchersource"));
            vouchertypeMap.put(voucherid, row.getString("vouchertype"));
            if (vouchercostRecordIdMap.containsKey(voucherid)) {
                costRecordIds = (Set)vouchercostRecordIdMap.get(voucherid);
                costRecordIds.add(costRecordId);
                continue;
            }
            costRecordIds = new HashSet<Long>(16);
            costRecordIds.add(costRecordId);
            vouchercostRecordIdMap.put(voucherid, costRecordIds);
        }
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord", (String)DeleteVoucherValidHelper.costRecordSelect(), (QFilter[])new QFilter[]{new QFilter("id", "in", allCostRecordId)});
        HashMap<Long, Object> costRecordMap = new HashMap<Long, Object>(16);
        HashMap<Long, Long> costAccountIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> costRecordIdMap = new HashMap<Long, Long>(16);
        for (Object costRecord : costRecords) {
            Long costRecordId = costRecord.getLong("id");
            costRecordIdMap.put(costRecordId, costRecordId);
            costRecordMap.put(costRecordId, costRecord);
            Long costaccountid = costRecord.getLong("costaccount");
            costAccountIdMap.put(costRecordId, costaccountid);
        }
        HashMap<Long, CalBatchDelCRVoucherInfo> infoMap = new HashMap<Long, CalBatchDelCRVoucherInfo>(16);
        for (Long vendorstrid : voucherids) {
            CalBatchDelCRVoucherInfo info = new CalBatchDelCRVoucherInfo();
            DynamicObject[] beanCostRecordIds = new HashSet(16);
            HashSet beanCostAccountIds = new HashSet(16);
            DynamicObjectCollection beanCostRecords = new DynamicObjectCollection();
            info.setVoucherId(vendorstrid);
            info.setVoucherSource((String)vouchersourceMap.get(vendorstrid));
            info.setVoucherType((String)vouchertypeMap.get(vendorstrid));
            Set costrecordIds = (Set)vouchercostRecordIdMap.get(vendorstrid);
            if (null == costrecordIds || costrecordIds.size() <= 0) continue;
            for (Long id : costrecordIds) {
                if (costRecordIdMap.get(id) != null) {
                    beanCostRecordIds.add(costRecordIdMap.get(id));
                }
                if (costAccountIdMap.get(id) != null) {
                    beanCostAccountIds.add(costAccountIdMap.get(id));
                }
                if (costRecordMap.get(id) == null) continue;
                beanCostRecords.add(costRecordMap.get(id));
            }
            info.setCostRecordIdSet((Set)beanCostRecordIds);
            info.setCostAccountIdSet(beanCostAccountIds);
            info.setCostRecords(beanCostRecords);
            infoMap.put(vendorstrid, info);
        }
        QFilter vocherPeriodFilter = new QFilter("id", "in", voucherids);
        HashMap<Long, DynamicObject> vocherPeriodMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject vocherPeriodInfo : vocherPeriods = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,period.begindate,period.enddate,period.periodyear,period.periodnumber", (QFilter[])new QFilter[]{vocherPeriodFilter})) {
            Long id = vocherPeriodInfo.getLong("id");
            DynamicObject vocherPeriod = vocherPeriodInfo.getDynamicObject("period");
            vocherPeriodMap.put(id, vocherPeriod);
        }
        ArrayList infoList = new ArrayList(16);
        for (Map.Entry mapEntry : infoMap.entrySet()) {
            infoList.add(mapEntry.getValue());
        }
        for (CalBatchDelCRVoucherInfo delCRVoucherInfo : infoList) {
            String errorVouchertypee;
            StringBuilder errorMsg = new StringBuilder();
            Set costRecordIdSets = delCRVoucherInfo.getCostRecordIdSet();
            if (null == costRecordIdSets || costRecordIdSets.isEmpty()) continue;
            String voucherSource = delCRVoucherInfo.getVoucherSource();
            if ("B".equals(voucherSource)) {
                errorMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\u7684\u51ed\u8bc1\u3002", (String)"VoucherWriteBackServiceImpl_0", (String)"fi-cal-mservice", (Object[])new Object[0]));
                continue;
            }
            Set costAccountIdSets = delCRVoucherInfo.getCostAccountIdSet();
            DeleteVoucherValidHelper delHelper = new DeleteVoucherValidHelper(costAccountIdSets, null);
            PeriodVoucherValidHelper voucherHelper = new PeriodVoucherValidHelper(costAccountIdSets);
            String vouchertypeStr = delCRVoucherInfo.getVoucherType();
            DynamicObjectCollection costRecordCollection = delCRVoucherInfo.getCostRecords();
            Long vendorId = delCRVoucherInfo.getVoucherId();
            if ("A".equals(vouchertypeStr)) {
                String errorVouchertypea = delHelper.doValidate(costRecordCollection, vendorId.longValue(), false, voucherHelper);
                if (!StringUtils.isBlank((CharSequence)errorVouchertypea)) {
                    errorMsg.append(errorVouchertypea);
                }
            } else if ("B".equals(vouchertypeStr)) {
                String errorVouchertypeb = delHelper.doTempValidate(costRecordCollection, vendorId.longValue(), voucherHelper, vocherPeriodMap);
                if (!StringUtils.isBlank((CharSequence)errorVouchertypeb)) {
                    errorMsg.append(errorVouchertypeb);
                }
            } else if ("C".equals(vouchertypeStr)) {
                String errorVouchertypec = delHelper.doDischargeValidate(costRecordCollection, vendorId.longValue(), voucherHelper);
                if (!StringUtils.isBlank((CharSequence)errorVouchertypec)) {
                    errorMsg.append(errorVouchertypec);
                }
            } else if ("D".equals(vouchertypeStr)) {
                String errorVouchertyped = delHelper.doCarryOverValidate(costRecordCollection, vendorId.longValue(), voucherHelper);
                if (!StringUtils.isBlank((CharSequence)errorVouchertyped)) {
                    errorMsg.append(errorVouchertyped);
                }
            } else if ("E".equals(vouchertypeStr) && !StringUtils.isBlank((CharSequence)(errorVouchertypee = delHelper.doFeeValidate(costRecordCollection, vendorId.longValue(), voucherHelper)))) {
                errorMsg.append(errorVouchertypee);
            }
            if (errorMsg.length() <= 0) continue;
            resultMap.put(vendorId, errorMsg.toString());
        }
        return resultMap;
    }

    private void addDapTracks(String billType, DynamicObject voucher, Set set, Set<String> hasVoucherSet) {
        ArrayList<DynamicObject> trackersToSave = new ArrayList<DynamicObject>(set.size());
        for (Object id : set) {
            String key = String.valueOf(voucher.getPkValue()) + "_" + String.valueOf(id);
            if (hasVoucherSet != null && hasVoucherSet.contains(key)) continue;
            DynamicObject daptracker = BusinessDataServiceHelper.newDynamicObject((String)"ai_daptracker");
            daptracker.set("billtype", (Object)billType);
            daptracker.set("sourcebillid", id);
            daptracker.set("createdate", (Object)new Date());
            daptracker.set("voucherid", voucher.getPkValue());
            daptracker.set("org", voucher.get("org"));
            daptracker.set("booktype", voucher.get("booktype"));
            trackersToSave.add(daptracker);
        }
        SaveServiceHelper.save((IDataEntityType)((DynamicObject)trackersToSave.get(0)).getDataEntityType(), (Object[])trackersToSave.toArray());
    }

    private Set<DynamicObject> getDapTracks(String billType, DynamicObject voucher, Set set) {
        HashSet<DynamicObject> trackersToSave = new HashSet<DynamicObject>(set.size());
        for (Object id : set) {
            DynamicObject daptracker = BusinessDataServiceHelper.newDynamicObject((String)"ai_daptracker");
            daptracker.set("billtype", (Object)billType);
            daptracker.set("sourcebillid", id);
            daptracker.set("createdate", (Object)new Date());
            daptracker.set("voucherid", voucher.getPkValue());
            daptracker.set("org", voucher.get("org"));
            daptracker.set("booktype", voucher.get("booktype"));
            trackersToSave.add(daptracker);
        }
        return trackersToSave;
    }

    private Set<String> addCalVouchers(Set<Long> ids, DynamicObject voucher, String vouchersource, String voucherType) {
        DynamicObject[] costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"id,vouchertype,calorg,costaccount,dischargetype,vouchertype", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        QFilter vendorQFilter = new QFilter("costrecordid", "in", ids);
        vendorQFilter.and("voucherid", "=", voucher.getPkValue());
        DataSet hasVoucherDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_voucher", (String)"id,costrecordid,voucherid", (QFilter[])new QFilter[]{vendorQFilter}, null);
        HashSet<String> hasVoucherSet = new HashSet<String>(16);
        for (Row row : hasVoucherDataSet) {
            String key = String.valueOf(row.getLong("voucherid")) + "_" + String.valueOf(row.getLong("costrecordid"));
            hasVoucherSet.add(key);
        }
        HashSet<DynamicObject> set = new HashSet<DynamicObject>(costRecords.length);
        for (DynamicObject costRecord : costRecords) {
            Long costRecordId = costRecord.getLong("id");
            String voucherid = String.valueOf(voucher.getPkValue());
            String hasKey = voucherid + "_" + String.valueOf(costRecordId);
            if (hasVoucherSet.contains(hasKey)) continue;
            DynamicObject calVoucher = BusinessDataServiceHelper.newDynamicObject((String)"cal_voucher");
            DynamicObject period = voucher.getDynamicObject("period");
            calVoucher.set("year", period.get("periodyear"));
            calVoucher.set("period", period.get("periodnumber"));
            calVoucher.set("periodid", (Object)period);
            calVoucher.set("costaccount", costRecord.get("costaccount"));
            calVoucher.set("calorg", costRecord.get("calorg"));
            calVoucher.set("costrecordid", costRecord.getPkValue());
            calVoucher.set("voucherid", voucher.getPkValue());
            calVoucher.set("vouchernum", voucher.get("billno"));
            if (voucherType != null) {
                calVoucher.set("vouchertype", (Object)voucherType);
            } else {
                calVoucher.set("vouchertype", (Object)"A");
            }
            calVoucher.set("createtime", voucher.get("createtime"));
            calVoucher.set("dischargetype", (Object)costRecord.getString("dischargetype"));
            calVoucher.set("createmode", (Object)0);
            calVoucher.set("vouchersource", (Object)vouchersource);
            set.add(calVoucher);
        }
        SaveServiceHelper.save((DynamicObject[])set.toArray(new DynamicObject[0]));
        return hasVoucherSet;
    }

    private Set<DynamicObject> getCalVouchers(Set<DynamicObject> costRecords, Set<String> hasVoucherSet, DynamicObject voucher, String vouchersource, String voucherType) {
        HashSet<DynamicObject> set = new HashSet<DynamicObject>(costRecords.size());
        for (DynamicObject costRecord : costRecords) {
            Long costRecordId = costRecord.getLong("id");
            String voucherid = String.valueOf(voucher.getPkValue());
            String hasKey = voucherid + "_" + String.valueOf(costRecordId);
            if (hasVoucherSet.contains(hasKey)) continue;
            DynamicObject calVoucher = BusinessDataServiceHelper.newDynamicObject((String)"cal_voucher");
            DynamicObject period = voucher.getDynamicObject("period");
            calVoucher.set("year", period.get("periodyear"));
            calVoucher.set("period", period.get("periodnumber"));
            calVoucher.set("periodid", (Object)period);
            calVoucher.set("costaccount_id", (Object)costRecord.getLong("costaccount"));
            calVoucher.set("calorg_id", (Object)costRecord.getLong("calorg"));
            calVoucher.set("costrecordid", (Object)costRecord.getLong("id"));
            calVoucher.set("voucherid", voucher.getPkValue());
            calVoucher.set("vouchernum", voucher.get("billno"));
            if (voucherType != null) {
                calVoucher.set("vouchertype", (Object)voucherType);
            } else {
                calVoucher.set("vouchertype", (Object)"A");
            }
            calVoucher.set("createtime", voucher.get("createtime"));
            calVoucher.set("dischargetype", (Object)costRecord.getString("dischargetype"));
            calVoucher.set("createmode", (Object)0);
            calVoucher.set("vouchersource", (Object)vouchersource);
            set.add(calVoucher);
        }
        return set;
    }

    private void delCalVouchers(long voucherId) {
        DeleteServiceHelper.delete((String)"cal_voucher", (QFilter[])new QFilter[]{new QFilter("voucherid", "=", (Object)voucherId)});
    }

    private void delCalVouchers(Set<Long> voucherIds, Set<Long> allBillIds) {
        DeleteServiceHelper.delete((String)"cal_voucher", (QFilter[])new QFilter[]{new QFilter("voucherid", "in", voucherIds), new QFilter("costrecordid", "in", allBillIds)});
    }

    private void writeChildVoucher4Salout(Long costAccountId, Set<Long> ids, boolean isGenerate, String voucherType) {
        if (ids.size() == 0) {
            return;
        }
        String isVoucher = "1";
        if (!isGenerate) {
            isVoucher = "0";
        }
        QFilter subBillQfilter = new QFilter("bizbillid", "in", ids);
        subBillQfilter.and("issplitcreate", "=", (Object)Boolean.TRUE);
        subBillQfilter.and("costaccount", "=", (Object)costAccountId);
        DynamicObject[] subCostRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)voucherType, (QFilter[])new QFilter[]{subBillQfilter});
        if (subCostRecords != null && subCostRecords.length > 0) {
            for (DynamicObject record : subCostRecords) {
                record.set(voucherType, (Object)isVoucher);
            }
            SaveServiceHelper.save((DynamicObject[])subCostRecords);
        }
    }

    private void writeChildVoucher4Temp(Set<Long> ids, boolean isGenerate, String voucherType) {
        DynamicObject[] subCostRecords;
        HashMap<Long, Long> writeoffperiodMap = new HashMap<Long, Long>(32);
        HashMap<Long, Boolean> spiltCreateMap = new HashMap<Long, Boolean>(32);
        QFilter q = new QFilter("id", "in", ids);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"entry.ancestorbillid,writeoffperiod,id,issplitcreate", (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                if (row.getLong("entry.ancestorbillid") == 0L) {
                    writeoffperiodMap.put(row.getLong("id"), row.getLong("writeoffperiod"));
                    spiltCreateMap.put(row.getLong("id"), row.getBoolean("issplitcreate"));
                    continue;
                }
                writeoffperiodMap.put(row.getLong("entry.ancestorbillid"), row.getLong("writeoffperiod"));
                spiltCreateMap.put(row.getLong("entry.ancestorbillid"), row.getBoolean("issplitcreate"));
            }
        }
        QFilter idFilter = new QFilter("entry.ancestorbillid", "in", writeoffperiodMap.keySet());
        QFilter typeFilter = new QFilter("dischargetype", "=", (Object)"A");
        QFilter[] costRecordQ = new QFilter[]{idFilter, typeFilter};
        HashSet<Long> subBillIdSet = new HashSet<Long>(32);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id", (QFilter[])costRecordQ, null);){
            for (Row row : dataSet) {
                subBillIdSet.add(row.getLong("id"));
            }
        }
        if (subBillIdSet.size() == 0) {
            return;
        }
        String isVoucher = "1";
        if (!isGenerate) {
            isVoucher = "0";
        }
        QFilter subBillQfilter = new QFilter("id", "in", subBillIdSet);
        subBillQfilter.and("issplitcreate", "=", (Object)Boolean.TRUE);
        for (DynamicObject record : subCostRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)("writeoffperiod,entry.ancestorbillid," + voucherType), (QFilter[])new QFilter[]{subBillQfilter})) {
            long ancestorbillid = ((DynamicObject)record.getDynamicObjectCollection("entry").get(0)).getLong("ancestorbillid");
            long writeoffperiod = record.getDynamicObject("writeoffperiod").getLong("id");
            if (((Boolean)spiltCreateMap.get(ancestorbillid)).booleanValue() && writeoffperiod <= (Long)writeoffperiodMap.get(ancestorbillid)) continue;
            record.set(voucherType, (Object)isVoucher);
        }
        SaveServiceHelper.save((DynamicObject[])subCostRecords);
    }

    private void writeBackIsVoucherSelect(Set<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        DynamicObject[] ancestorRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"id,issplitcreate,entry.ancestorbillid", (QFilter[])new QFilter[]{idFilter});
        HashSet<Long> ancestorAndSelfIds = new HashSet<Long>();
        for (DynamicObject record : ancestorRecords) {
            Long selfId = record.getLong("id");
            if (record.getBoolean("issplitcreate")) {
                DynamicObjectCollection recordEntry = record.getDynamicObjectCollection("entry");
                if (recordEntry.size() <= 0) continue;
                ancestorAndSelfIds.add(((DynamicObject)recordEntry.get(0)).getLong("ancestorbillid"));
                continue;
            }
            ancestorAndSelfIds.add(selfId);
        }
        if (ancestorAndSelfIds.size() > 0) {
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_calcostrecord set fisvoucher = '1' where fid in (" + StringUtils.join((Object[])ancestorAndSelfIds.toArray(), (char)',') + ") and fisvoucher = '0'"));
        }
    }

    private void writeBackIsVoucherUncheck(Set<Long> ids) {
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, ids)});){
            ctx.set();
            QFilter idFilter = new QFilter("id", "in", ids);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,issplitcreate,entry.ancestorbillid,isinitbill,dischargetype,isfivoucher,istempvoucher,isdischargevoucher,iscostcarryover,isfeevoucher", (QFilter[])new QFilter[]{idFilter}, null);
            HashSet<Long> ancestorIds = new HashSet<Long>(ids.size());
            HashSet<Long> writebackIds = new HashSet<Long>(ids.size());
            for (Row row : dataSet) {
                boolean isNotVoucher;
                boolean bl = isNotVoucher = row.getBoolean("isfivoucher") == false && row.getBoolean("istempvoucher") == false && row.getBoolean("isdischargevoucher") == false && row.getBoolean("iscostcarryover") == false && row.getBoolean("isfeevoucher") == false;
                if (row.getBoolean("isinitbill").booleanValue() && DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(row.getString("dischargetype"))) {
                    boolean bl2 = isNotVoucher = row.getBoolean("isfivoucher") == false && row.getBoolean("isdischargevoucher") == false && row.getBoolean("iscostcarryover") == false && row.getBoolean("isfeevoucher") == false;
                }
                if (!isNotVoucher) continue;
                if (row.getBoolean("issplitcreate").booleanValue()) {
                    ancestorIds.add(row.getLong("entry.ancestorbillid"));
                    continue;
                }
                ancestorIds.add(row.getLong("id"));
            }
            QFilter ancFilter = new QFilter("entry.ancestorbillid", "in", ancestorIds);
            DataSet ancNoVouchDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,issplitcreate,entry.ancestorbillid,isinitbill,dischargetype,isfivoucher,istempvoucher,isdischargevoucher,iscostcarryover,isfeevoucher", (QFilter[])new QFilter[]{ancFilter}, null);
            QFilter filter = new QFilter("id", "in", ancestorIds);
            DataSet noVoucherDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,issplitcreate,entry.ancestorbillid,isinitbill,dischargetype,isfivoucher,istempvoucher,isdischargevoucher,iscostcarryover,isfeevoucher", (QFilter[])new QFilter[]{filter}, null);
            noVoucherDataSet = noVoucherDataSet.union(ancNoVouchDataSet);
            for (Row row : noVoucherDataSet) {
                boolean isVoucher;
                boolean bl = isVoucher = row.getBoolean("isfivoucher") != false || row.getBoolean("istempvoucher") != false || row.getBoolean("isdischargevoucher") != false || row.getBoolean("iscostcarryover") != false || row.getBoolean("isfeevoucher") != false;
                if (row.getBoolean("isinitbill").booleanValue() && DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(row.getString("dischargetype"))) {
                    boolean bl3 = isVoucher = row.getBoolean("isfivoucher") != false || row.getBoolean("isdischargevoucher") != false || row.getBoolean("iscostcarryover") != false || row.getBoolean("isfeevoucher") != false;
                }
                if (!isVoucher) continue;
                if (row.getBoolean("issplitcreate").booleanValue()) {
                    ancestorIds.remove(row.getLong("entry.ancestorbillid"));
                    continue;
                }
                ancestorIds.remove(row.getLong("id"));
            }
            writebackIds.addAll(ancestorIds);
            if (writebackIds.size() > 0) {
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_calcostrecord set fisvoucher = '0' where fid in (" + StringUtils.join((Object[])writebackIds.toArray(), (char)',') + ") and fisvoucher = '1'"));
            }
        }
    }

    public String validateDelCRCostAdjust(Set<Long> ids) {
        return null;
    }

    public void batchDiffBillWriteBack(String VoucherOperationValue, Map<Long, Set<Long>> voucherAdjustBillIdsMap, Map<Long, String> voucherNumMap) {
        HashMap<Long, DynamicObject> voucherMap = new HashMap<Long, DynamicObject>(voucherAdjustBillIdsMap.size());
        if (!"2".equals(VoucherOperationValue)) {
            DynamicObject[] vouchers;
            for (DynamicObject voucher : vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,billno,org,booktype,bizdate,bookeddate,createtime,vouchertype,period.periodyear,period.periodnumber", (QFilter[])new QFilter("id", "in", voucherAdjustBillIdsMap.keySet()).toArray())) {
                voucherMap.put(voucher.getLong("id"), voucher);
            }
        }
        this.batchDiffBillWriteBack(VoucherOperationValue, voucherAdjustBillIdsMap, voucherMap, false, voucherNumMap);
    }

    private void batchDiffBillWriteBack(String VoucherOperationValue, Map<Long, Set<Long>> voucherGroupDiffBillIdsMap, Map<Long, DynamicObject> voucherMap, boolean isAddDap, Map<Long, String> voucherNumMap) {
        block53: {
            Throwable throwable;
            TXHandle h1;
            List splitList;
            ArrayList<Object[]> paramList;
            block54: {
                HashSet<Long> allGroupBillIds;
                block52: {
                    paramList = new ArrayList<Object[]>(voucherGroupDiffBillIdsMap.size());
                    HashSet<DynamicObject> dapTracks = new HashSet<DynamicObject>(voucherGroupDiffBillIdsMap.size());
                    allGroupBillIds = new HashSet<Long>(voucherGroupDiffBillIdsMap.size());
                    for (Set<Long> set : voucherGroupDiffBillIdsMap.values()) {
                        allGroupBillIds.addAll(set);
                    }
                    for (Map.Entry entry : voucherGroupDiffBillIdsMap.entrySet()) {
                        Long voucherId = (Long)entry.getKey();
                        Set GroupDiffSet = (Set)entry.getValue();
                        if (GroupDiffSet.isEmpty()) continue;
                        DynamicObject voucher = voucherMap.get(voucherId);
                        if ("1".equals(VoucherOperationValue)) {
                            for (Long GroupDifftId : GroupDiffSet) {
                                paramList.add(new Object[]{voucher.getString("billno"), voucher.getPkValue(), GroupDifftId});
                            }
                            if (!isAddDap) continue;
                            dapTracks.addAll(this.getDapTracks("cal_stdcostdiffbill", voucher, GroupDiffSet));
                            continue;
                        }
                        if ("2".equals(VoucherOperationValue)) continue;
                        String voucherNum = voucherNumMap.get(voucherId);
                        if (StringUtils.isEmpty((CharSequence)voucherNum)) {
                            voucherNum = voucher.getString("billno");
                        }
                        for (Long GroupDiffId : GroupDiffSet) {
                            paramList.add(new Object[]{voucherNum, GroupDiffId});
                        }
                    }
                    if (!"1".equals(VoucherOperationValue)) break block52;
                    if (!paramList.isEmpty()) {
                        splitList = CommonUtils.getSplitList(paramList);
                        for (List list : splitList) {
                            h1 = TX.requiresNew();
                            throwable = null;
                            try {
                                String updateSql2 = "update t_cal_stdcostdiff set fisvoucher = '1',fvouchernum = ?,fvoucherid = ? where fid = ?";
                                DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateSql2, (List)list);
                            }
                            catch (Throwable updateSql2) {
                                throwable = updateSql2;
                                throw updateSql2;
                            }
                            finally {
                                if (h1 == null) continue;
                                if (throwable != null) {
                                    try {
                                        h1.close();
                                    }
                                    catch (Throwable updateSql2) {
                                        throwable.addSuppressed(updateSql2);
                                    }
                                    continue;
                                }
                                h1.close();
                            }
                        }
                    }
                    if (dapTracks.isEmpty()) break block53;
                    splitList = CommonUtils.getSplitDynList(dapTracks);
                    for (Set set : splitList) {
                        h1 = TX.requiresNew();
                        throwable = null;
                        try {
                            SaveServiceHelper.save((DynamicObject[])set.toArray(new DynamicObject[0]));
                        }
                        catch (Throwable updateSql2) {
                            throwable = updateSql2;
                            throw updateSql2;
                        }
                        finally {
                            if (h1 == null) continue;
                            if (throwable != null) {
                                try {
                                    h1.close();
                                }
                                catch (Throwable updateSql2) {
                                    throwable.addSuppressed(updateSql2);
                                }
                                continue;
                            }
                            h1.close();
                        }
                    }
                    break block53;
                }
                if (!"2".equals(VoucherOperationValue)) break block54;
                if (allGroupBillIds.isEmpty()) break block53;
                splitList = CommonUtils.getSplitList(allGroupBillIds);
                for (Set set : splitList) {
                    h1 = TX.requiresNew();
                    throwable = null;
                    try {
                        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_stdcostdiff set fisvoucher = '0',fvouchernum = ' ',fvoucherid = 0 where fid in (" + StringUtils.join((Object[])set.toArray(), (char)',') + ")"));
                    }
                    catch (Throwable updateSql2) {
                        throwable = updateSql2;
                        throw updateSql2;
                    }
                    finally {
                        if (h1 == null) continue;
                        if (throwable != null) {
                            try {
                                h1.close();
                            }
                            catch (Throwable updateSql2) {
                                throwable.addSuppressed(updateSql2);
                            }
                            continue;
                        }
                        h1.close();
                    }
                }
                break block53;
            }
            if (!paramList.isEmpty()) {
                splitList = CommonUtils.getSplitList(paramList);
                for (List list : splitList) {
                    h1 = TX.requiresNew();
                    throwable = null;
                    try {
                        String updateSql = "update t_cal_stdcostdiff set fvouchernum = ? where fid = ?";
                        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateSql, (List)list);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (h1 == null) continue;
                        if (throwable != null) {
                            try {
                                h1.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        h1.close();
                    }
                }
            }
        }
    }
}

