/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.groupdiffbill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalDiffGroupBillHelper;
import kd.fi.cal.common.helper.CalDiffGroupSettingHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.mservice.api.CalGroupDiffBillService;
import kd.fi.cal.mservice.groupdiffbill.GroupDiffBillGroupFunction;
import kd.fi.cal.mservice.groupdiffbill.MatchingSettingGroupFunction;
import org.apache.commons.lang.StringUtils;

public class CalGroupDiffBillServiceImpl
implements CalGroupDiffBillService {
    private static final Log logger = LogFactory.getLog(CalGroupDiffBillServiceImpl.class);

    public Map<String, Set<Long>> DeleteSingleDimDiffGroupBill(Set<Long> diffGroupIdSet, Map<Long, Set<Long>> diffBillAndGroupBillMap) {
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>(16);
        new CalDiffGroupBillHelper();
        Set hasVoucherDiffBillIds = CalDiffGroupBillHelper.getHasVoucherDiffBill(diffGroupIdSet, diffBillAndGroupBillMap);
        for (Long l : hasVoucherDiffBillIds) {
            diffBillAndGroupBillMap.remove(l);
        }
        diffGroupIdSet.clear();
        for (Map.Entry entry : diffBillAndGroupBillMap.entrySet()) {
            diffGroupIdSet.addAll((Collection)entry.getValue());
        }
        resultMap.put("hasvoucherdiffbill", hasVoucherDiffBillIds);
        logger.info("\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u5dee\u5f02\u5355\u6761\u6570\uff1a" + hasVoucherDiffBillIds.size());
        if (diffGroupIdSet.isEmpty()) {
            logger.info("\u6ca1\u6709\u672a\u751f\u6210\u51ed\u8bc1\u7684\u5408\u5e76\u5355");
            return resultMap;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costdiffgroupbill", (Object[])diffGroupIdSet.toArray(new Object[0]), (OperateOption)option);
        DeleteServiceHelper.delete((String)"cal_costdiffgroupbill", (QFilter[])new QFilter[]{new QFilter("id", "in", diffGroupIdSet)});
        try (ShardingHintContext shardingHintContext = ShardingHintContext.createAndSet((String)"t_cal_stdcostdiff", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, diffBillAndGroupBillMap.keySet())});){
            shardingHintContext.set();
            List<Set<Long>> batchDiffIdList = this.getBatchIds(diffGroupIdSet, 5000);
            for (Set<Long> batchDiffIdSet : batchDiffIdList) {
                String updateSql = "UPDATE t_cal_stdcostdiffentry SET FGROUPDIFFBILLNUM = ' ',FGROUPDIFFBILLID = 0 WHERE FGROUPDIFFBILLID in (" + StringUtils.join(batchDiffIdSet, (String)",") + ")";
                DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql);
            }
        }
        return resultMap;
    }

    public Map<String, Set<Long>> DeleteAllDimDiffGroupBill(Map<Long, Set<Long>> groupDiffBillMap) {
        logger.info("\u5f00\u59cb\u6267\u884c\u751f\u6210\u5220\u9664\u5408\u5e76\u5355\u5355\u670d\u52a1\uff0c\u5408\u5e76\u5355\u6761\u6570: " + groupDiffBillMap.size());
        HashMap<String, Set<Long>> diffBillMap = new HashMap<String, Set<Long>>(16);
        QFilter q = new QFilter("id", "in", groupDiffBillMap.keySet());
        q.and("isvoucher", "=", (Object)true);
        DataSet hasVoucherGroupBillDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costdiffgroupbill", (String)"id", (QFilter[])q.toArray(), null);
        HashSet hasVoucherDiffBillEntryIds = new HashSet(16);
        Set<Object> noVoucherDiffGroupBillIds = new HashSet(16);
        HashSet<Long> noVoucherDiffBillEntryIds = new HashSet<Long>(16);
        for (Row row : hasVoucherGroupBillDs) {
            Long groupDiffBillId = row.getLong("id");
            hasVoucherDiffBillEntryIds.addAll(groupDiffBillMap.remove(groupDiffBillId));
        }
        noVoucherDiffGroupBillIds = groupDiffBillMap.keySet();
        for (Map.Entry<Long, Set<Long>> entry : groupDiffBillMap.entrySet()) {
            noVoucherDiffBillEntryIds.addAll((Collection)entry.getValue());
        }
        diffBillMap.put("hasvoucherbill", hasVoucherDiffBillEntryIds);
        diffBillMap.put("novoucherbill", noVoucherDiffBillEntryIds);
        logger.info("\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u5dee\u5f02\u5355\u6761\u6570\uff1a" + hasVoucherDiffBillEntryIds.size());
        logger.info("\u672a\u751f\u6210\u51ed\u8bc1\u7684\u5dee\u5f02\u5355\u6761\u6570\uff1a" + noVoucherDiffBillEntryIds.size());
        if (noVoucherDiffGroupBillIds.isEmpty()) {
            return diffBillMap;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costdiffgroupbill", (Object[])noVoucherDiffGroupBillIds.toArray(new Object[0]), (OperateOption)option);
        DeleteServiceHelper.delete((String)"cal_costdiffgroupbill", (QFilter[])new QFilter[]{new QFilter("id", "in", noVoucherDiffGroupBillIds)});
        List<Set<Long>> batchDiffIdList = this.getBatchIds(noVoucherDiffBillEntryIds, 5000);
        for (Set<Long> batchDiffIdSet : batchDiffIdList) {
            String updateSql = "UPDATE t_cal_stdcostdiffentry SET FGROUPDIFFBILLNUM = ' ',FGROUPDIFFBILLID = 0 WHERE fentryid in (" + StringUtils.join(batchDiffIdSet, (String)",") + ")";
            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql);
        }
        return diffBillMap;
    }

    public void createDiffGroupBill(Map<String, Set<Long>> diffBillIdMap) {
        logger.info("\u5f00\u59cb\u6267\u884c\u751f\u6210\u5408\u5e76\u5355\u670d\u52a1 ");
        Set<Long> diffBillIdSet = null;
        Set<Long> diffBillEntryIdSet = null;
        boolean isheadbill = false;
        if (diffBillIdMap.get("diffbillid") != null) {
            diffBillIdSet = diffBillIdMap.get("diffbillid");
            isheadbill = true;
        } else if (diffBillIdMap.get("diffbillentryid") != null) {
            diffBillEntryIdSet = diffBillIdMap.get("diffbillentryid");
        } else {
            logger.info("\u4f20\u5165\u7684\u5dee\u5f02\u5355id\u548c\u5dee\u5f02\u5355\u5206\u5f55id\u90fd\u4e3a\u7a7a");
            return;
        }
        CalDiffGroupSettingHelper groupSettingHelper = new CalDiffGroupSettingHelper();
        Set groupDimSet = groupSettingHelper.getAllEnableGroupDims();
        logger.info("\u5408\u5e76\u5355\u914d\u7f6e\u603b\u7ef4\u5ea6\uff1a" + groupDimSet.toString());
        groupDimSet.addAll(groupSettingHelper.getAmountFields());
        String selectFields = this.getAllSelectField(groupDimSet);
        if (isheadbill) {
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_cal_stdcostdiff", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, diffBillIdSet)});){
                ctx.set();
                this.doCreateDiffBill(groupSettingHelper, selectFields, diffBillIdSet, diffBillEntryIdSet, isheadbill);
            }
        } else {
            this.doCreateDiffBill(groupSettingHelper, selectFields, diffBillIdSet, diffBillEntryIdSet, isheadbill);
        }
    }

    private void doCreateDiffBill(CalDiffGroupSettingHelper groupSettingHelper, String selectFields, Set<Long> diffBillIdSet, Set<Long> diffBillEntryIdSet, boolean isheadbill) {
        List<Set<Long>> batchIdList = null;
        batchIdList = isheadbill ? this.getBatchIds(diffBillIdSet, 5000) : this.getBatchIds(diffBillEntryIdSet, 5000);
        if (batchIdList.isEmpty()) {
            return;
        }
        DataSet diffBillDataSet = null;
        for (Set<Long> idSet : batchIdList) {
            QFilter billQ = null;
            billQ = isheadbill ? new QFilter("id", "in", idSet) : new QFilter("entryentity.id", "in", idSet);
            DataSet datsSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stdcostdiffbill", (String)selectFields, (QFilter[])billQ.toArray(), null);
            if (diffBillDataSet == null) {
                diffBillDataSet = datsSet;
                continue;
            }
            diffBillDataSet = diffBillDataSet.union(datsSet);
        }
        if (diffBillDataSet == null) {
            logger.info("\u672a\u627e\u5230\u5dee\u5f02\u5355\u6570\u636e");
            return;
        }
        DynamicObjectCollection groupSettings = CalDiffGroupSettingHelper.getAllEnableSetting(null);
        diffBillDataSet = diffBillDataSet.groupBy(new String[]{"bizentityobject", "biztype"}).reduceGroup((ReduceGroupFunction)new MatchingSettingGroupFunction(groupSettings, diffBillDataSet.getRowMeta()));
        DataSet[] dataSetArray = diffBillDataSet.splitByFilter(new String[]{"groupsettingid = 0l", "groupsettingid <> 0l"}, false);
        DataSet noMatchBillDs = dataSetArray[0];
        DataSet hasMatchBillDs = dataSetArray[1];
        ArrayList<DynamicObject> groupDiffBillList = new ArrayList<DynamicObject>(16);
        HashMap<Long, Set<Long>> groupDiffBillIdMap = new HashMap<Long, Set<Long>>(16);
        this.buildGroupBill4NoMatchingBill(noMatchBillDs, groupDiffBillList, groupDiffBillIdMap);
        this.buildGroupBill4HasMatchingBill(hasMatchBillDs, groupDiffBillList, groupDiffBillIdMap);
        if (groupDiffBillList.isEmpty()) {
            logger.info("\u672a\u751f\u6210\u5408\u5e76\u5355");
            return;
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("ignoreValidation", "true");
        op.setVariableValue("ishasright", "true");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"cal_costdiffgroupbill", (DynamicObject[])groupDiffBillList.toArray(new DynamicObject[0]), (OperateOption)op);
        if (!saveResult.isSuccess()) {
            throw new KDBizException(saveResult.getMessage() + saveResult.getAllErrorOrValidateInfo());
        }
        HashMap billNoMap = new HashMap(16);
        ArrayList groupDiffBillIds = new ArrayList(groupDiffBillIdMap.keySet());
        int BATCH_SIZE = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.QUERY_IN_SPRITSIZE);
        Lists.partition(groupDiffBillIds, (int)BATCH_SIZE).forEach(list -> {
            DataSet billNoDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costdiffgroupbill", (String)"id,billno", (QFilter[])new QFilter("id", "in", list).toArray(), null);
            for (Row row : billNoDs) {
                billNoMap.put(row.getLong("id"), row.getString("billno"));
            }
        });
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costdiffgroupbill", (Object[])groupDiffBillIdMap.keySet().toArray(), (OperateOption)op);
        if (!auditResult.isSuccess()) {
            throw new KDBizException(auditResult.getMessage() + auditResult.getAllErrorOrValidateInfo());
        }
        for (Map.Entry groupDiffBillEntry : groupDiffBillIdMap.entrySet()) {
            Long groupBillId = (Long)groupDiffBillEntry.getKey();
            Set diffBillSet = (Set)groupDiffBillEntry.getValue();
            List<Set<Long>> batchDiffIdList = this.getBatchIds(diffBillSet, 5000);
            for (Set<Long> batchDiffIdSet : batchDiffIdList) {
                String billNo = billNoMap.get(groupBillId) == null ? " " : (String)billNoMap.get(groupBillId);
                StringBuilder sqlBuilder = new StringBuilder();
                sqlBuilder.append("UPDATE t_cal_stdcostdiffentry SET FGROUPDIFFBILLID = ");
                sqlBuilder.append(groupBillId);
                sqlBuilder.append(",FGROUPDIFFBILLNUM = '");
                sqlBuilder.append(billNo);
                sqlBuilder.append("' WHERE fentryid in (");
                sqlBuilder.append(StringUtils.join(batchDiffIdSet, (String)","));
                sqlBuilder.append(')');
                DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sqlBuilder.toString());
            }
        }
    }

    private String getAllSelectField(Set<String> groupDimSet) {
        StringBuilder selectFieldBuilder = new StringBuilder();
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_stdcostdiffbill");
        for (String groupDim : groupDimSet) {
            IDataEntityProperty fieldProperty = entitytype.findProperty(groupDim);
            if (fieldProperty.getParent() instanceof EntryType) {
                selectFieldBuilder.append(fieldProperty.getParent().getName());
                selectFieldBuilder.append('.');
                selectFieldBuilder.append(groupDim);
                selectFieldBuilder.append(" as ");
            }
            selectFieldBuilder.append(groupDim);
            selectFieldBuilder.append(',');
        }
        selectFieldBuilder.append("billtype.billformid as bizentityobject,");
        selectFieldBuilder.append("id,");
        selectFieldBuilder.append("entryentity.id as entryid,");
        selectFieldBuilder.append("0l as groupsettingid,");
        selectFieldBuilder.append("' ' as groupdims,");
        selectFieldBuilder.append("0l as groupbillid,");
        selectFieldBuilder.append("' ' as diffbillids,");
        return CommonUtils.trimComma((String)selectFieldBuilder.toString());
    }

    private void buildGroupBill4HasMatchingBill(DataSet hasMatchBillDs, List<DynamicObject> groupDiffBillList, Map<Long, Set<Long>> groupDiffBillIdMap) {
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_costdiffgroupbill");
        DataSet groupSettingDS = hasMatchBillDs.copy().groupBy(new String[]{"groupsettingid", "groupdims"}).finish().select("groupsettingid,groupdims");
        ArrayList<String> filterList = new ArrayList<String>(16);
        HashMap<Integer, String> groupDimsSortMap = new HashMap<Integer, String>(16);
        int i = 0;
        for (Row row : groupSettingDS) {
            QFilter q = new QFilter("groupsettingid", "=", (Object)row.getLong("groupsettingid"));
            filterList.add(q.toString());
            groupDimsSortMap.put(i, row.getString("groupdims"));
            ++i;
        }
        if (filterList.isEmpty()) {
            logger.info("\u5339\u914d\u5230\u5408\u5e76\u914d\u7f6e\u7684\u5dee\u5f02\u5355\u4e3a\u7a7a");
            return;
        }
        DataSet[] groupDiffBillsArray = hasMatchBillDs.splitByFilter(filterList.toArray(new String[0]), false);
        int j = 0;
        for (DataSet groupDiffBills : groupDiffBillsArray) {
            String groupDims = CalDiffGroupSettingHelper.AddDefaultGroupDims((String)((String)groupDimsSortMap.get(j)));
            DataSet[] diffBillDSArray = groupDiffBills.splitByFilter(new String[]{new QFilter("createtype", "=", (Object)"W").toString(), new QFilter("createtype", "!=", (Object)"W").toString()}, false);
            DataSet diffShareBillDs = diffBillDSArray[0];
            DataSet otherDiffBillDs = diffBillDSArray[1];
            diffShareBillDs = diffShareBillDs.groupBy(groupDims.split(",")).reduceGroup((ReduceGroupFunction)new GroupDiffBillGroupFunction(hasMatchBillDs.getRowMeta()));
            otherDiffBillDs = otherDiffBillDs.groupBy((groupDims + ",id").split(",")).reduceGroup((ReduceGroupFunction)new GroupDiffBillGroupFunction(hasMatchBillDs.getRowMeta()));
            this.buildGroupBillByDiffDs(diffShareBillDs, groupDims, entitytype, groupDiffBillList, groupDiffBillIdMap);
            this.buildGroupBillByDiffDs(otherDiffBillDs, groupDims, entitytype, groupDiffBillList, groupDiffBillIdMap);
            ++j;
        }
    }

    private void buildGroupBill4NoMatchingBill(DataSet noMatchBillDs, List<DynamicObject> groupDiffBillList, Map<Long, Set<Long>> groupDiffBillIdMap) {
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)"cal_costdiffgroupbill");
        HashSet<Long> noMatchBillEntryIds = new HashSet<Long>(16);
        for (Row row : noMatchBillDs) {
            noMatchBillEntryIds.add(row.getLong("entryid"));
        }
        if (noMatchBillEntryIds.isEmpty()) {
            logger.info("\u672a\u5339\u914d\u5230\u5408\u5e76\u914d\u7f6e\u7684\u5dee\u5f02\u5355\u4e3a\u7a7a");
            return;
        }
        Set allFields = entitytype.getAllFields().keySet();
        allFields.remove("org");
        allFields.remove("billno");
        String selectFields = CommonUtils.getSelectFieldByEntity((String)"cal_stdcostdiffbill", (String[])allFields.toArray(new String[0]));
        selectFields = selectFields + ",entryentity.id as entryid";
        List<Set<Long>> batchIdList = this.getBatchIds(noMatchBillEntryIds, 5000);
        if (batchIdList.isEmpty()) {
            return;
        }
        DataSet diffBillDataSet = null;
        for (Set<Long> idSet : batchIdList) {
            QFilter billQ = new QFilter("entryentity.id", "in", idSet);
            DataSet datsSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stdcostdiffbill", (String)selectFields, (QFilter[])billQ.toArray(), null);
            if (diffBillDataSet == null) {
                diffBillDataSet = datsSet;
                continue;
            }
            diffBillDataSet = diffBillDataSet.union(datsSet);
        }
        if (diffBillDataSet == null) {
            return;
        }
        for (Row row : diffBillDataSet) {
            DynamicObject diffGroupBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_costdiffgroupbill");
            Long groupBillId = DB.genLongId((String)"t_cal_diffgroupbill");
            diffGroupBill.set("id", (Object)groupBillId);
            diffGroupBill.set("billno", (Object)("HBCYD-" + groupBillId));
            for (String field : allFields) {
                diffGroupBill.set(field, row.get(field));
            }
            diffGroupBill.set("billstatus", (Object)"B");
            Date date = TimeServiceHelper.now();
            diffGroupBill.set("createtime", (Object)date);
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            diffGroupBill.set("creator_id", (Object)userId);
            groupDiffBillList.add(diffGroupBill);
            HashSet<Long> diffBillSet = new HashSet<Long>(16);
            Long entryId = row.getLong("entryid");
            diffBillSet.add(entryId);
            groupDiffBillIdMap.put(groupBillId, diffBillSet);
        }
    }

    private void buildGroupBillByDiffDs(DataSet diffBills, String groupDims, MainEntityType entitytype, List<DynamicObject> groupDiffBillList, Map<Long, Set<Long>> groupDiffBillIdMap) {
        for (Row row : diffBills) {
            DynamicObject diffGroupBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_costdiffgroupbill");
            Long billId = row.getLong("groupbillid");
            diffGroupBill.set("id", (Object)billId);
            diffGroupBill.set("billno", (Object)("HBCYD-" + billId));
            diffGroupBill.set("billstatus", (Object)"B");
            Date date = TimeServiceHelper.now();
            diffGroupBill.set("createtime", (Object)date);
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            diffGroupBill.set("creator_id", (Object)userId);
            for (String groupDim : groupDims.split(",")) {
                Object dimvalue = row.get(groupDim);
                if (entitytype.getProperty(groupDim) instanceof BasedataProp) {
                    groupDim = groupDim + "_id";
                }
                diffGroupBill.set(groupDim, dimvalue);
            }
            for (String amountField : CalDiffGroupSettingHelper.getAmountFields()) {
                diffGroupBill.set(amountField, row.get(amountField));
            }
            groupDiffBillList.add(diffGroupBill);
            HashSet<Long> diffBillSet = new HashSet<Long>(16);
            String diffbillids = row.getString("diffbillids");
            for (String diffBillId : diffbillids.split(",")) {
                diffBillSet.add(Long.valueOf(diffBillId));
            }
            groupDiffBillIdMap.put(row.getLong("groupbillid"), diffBillSet);
        }
    }

    private List<Set<Long>> getBatchIds(Set<Long> diffBillIdSet, int batzhSize) {
        HashSet<Long> batchIds = null;
        ArrayList<Set<Long>> batchIdlist = new ArrayList<Set<Long>>(16);
        long index = 0L;
        for (Long diffBillId : diffBillIdSet) {
            if (index % (long)batzhSize == 0L) {
                batchIds = new HashSet<Long>(16);
                batchIdlist.add(batchIds);
            }
            if (batchIds != null) {
                batchIds.add(diffBillId);
            }
            ++index;
        }
        return batchIdlist;
    }
}

