/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.groupdiffbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.db.DB;
import kd.fi.cal.common.helper.CalDiffGroupSettingHelper;

public class GroupDiffBillGroupFunction
extends ReduceGroupFunction {
    private RowMeta rowMeta;

    public GroupDiffBillGroupFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public Iterator<Object[]> reduce(Iterator<Row> iterator) {
        CalDiffGroupSettingHelper groupSettingHelper = new CalDiffGroupSettingHelper();
        Set amountFieldSet = groupSettingHelper.getAmountFields();
        ArrayList<Integer> amountFiledIdxList = new ArrayList<Integer>(16);
        for (String amountField : amountFieldSet) {
            int amt_Idx = this.rowMeta.getFieldIndex(amountField);
            amountFiledIdxList.add(amt_Idx);
        }
        int entryid_Idx = this.rowMeta.getFieldIndex("entryid");
        int groupbillid_Idx = this.rowMeta.getFieldIndex("groupbillid");
        int diffbillids_Idx = this.rowMeta.getFieldIndex("diffbillids");
        if (!iterator.hasNext()) {
            return null;
        }
        Row firstRow = iterator.next();
        RowX firstRowX = this.getRowx(firstRow);
        HashMap<Integer, BigDecimal> amountIdxAndValueMap = new HashMap<Integer, BigDecimal>(16);
        for (Integer amountFieldIdx : amountFiledIdxList) {
            amountIdxAndValueMap.put(amountFieldIdx, firstRowX.getBigDecimal(amountFieldIdx.intValue()));
        }
        StringBuilder diffBillIdBuilder = new StringBuilder();
        diffBillIdBuilder.append(String.valueOf(firstRowX.getLong(entryid_Idx)));
        while (iterator.hasNext()) {
            Row row = iterator.next();
            RowX rowX = this.getRowx(row);
            for (Integer amountFieldIdx : amountFiledIdxList) {
                BigDecimal amount = (BigDecimal)amountIdxAndValueMap.get(amountFieldIdx);
                amount = amount == null ? BigDecimal.ZERO : amount;
                amount = amount.add(rowX.getBigDecimal(amountFieldIdx.intValue()));
                amountIdxAndValueMap.put(amountFieldIdx, amount);
            }
            diffBillIdBuilder.append(',');
            diffBillIdBuilder.append(String.valueOf(rowX.getLong(entryid_Idx)));
        }
        for (Integer amountFieldIdx : amountFiledIdxList) {
            firstRowX.set(amountFieldIdx.intValue(), amountIdxAndValueMap.get(amountFieldIdx));
        }
        firstRowX.set(diffbillids_Idx, (Object)diffBillIdBuilder.toString());
        firstRowX.set(groupbillid_Idx, (Object)DB.genLongId((String)"t_cal_diffgroupbill"));
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        dataList.add(firstRowX.values());
        return dataList.iterator();
    }

    private RowX getRowx(Row row) {
        Field[] fields = this.getResultRowMeta().getFields();
        Object[] values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = row.get(fields[i].getName());
        }
        return new RowX(values);
    }
}

