/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.groupdiffbill;

import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.cal.common.util.CommonUtils;

public class MatchingSettingGroupFunction
extends ReduceGroupFunction {
    private DynamicObjectCollection groupSettings;
    private RowMeta rowMeta;

    public MatchingSettingGroupFunction(DynamicObjectCollection groupSettings, RowMeta rowMeta) {
        this.groupSettings = groupSettings;
        this.rowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public Iterator<Object[]> reduce(Iterator<Row> iterator) {
        int bizEntityObjectIdx = this.rowMeta.getFieldIndex("bizentityobject");
        int calOrgIdx = this.rowMeta.getFieldIndex("calorg");
        int bizTypeIdx = this.rowMeta.getFieldIndex("biztype");
        int groupSettingIdx = this.rowMeta.getFieldIndex("groupsettingid");
        int groupDimIdx = this.rowMeta.getFieldIndex("groupdims");
        String bizEntityObject = null;
        String bizType = null;
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        while (iterator.hasNext()) {
            Row row = iterator.next();
            RowX rowX = this.getRowx(row);
            if (bizEntityObject == null) {
                bizEntityObject = rowX.getString(bizEntityObjectIdx);
            }
            if (bizType == null) {
                bizType = rowX.getString(bizTypeIdx);
            }
            Long calOrgId = rowX.getLong(calOrgIdx);
            Long matchId = 0L;
            String groupDims = " ";
            for (DynamicObject groupSetting : this.groupSettings) {
                String settingBizObject = groupSetting.getString("bizentityobject.number");
                String settingBizType = groupSetting.getString("biztype");
                Long settingOrgId = groupSetting.getLong("orgentry.org");
                if (!settingBizObject.equals(bizEntityObject) || !settingBizType.equals(bizType)) continue;
                if (settingOrgId == null || Long.compare(settingOrgId, 0L) == 0) {
                    if (matchId.compareTo(0L) != 0) continue;
                    matchId = groupSetting.getLong("id");
                    groupDims = CommonUtils.trimComma((String)groupSetting.getString("groupdims"));
                    continue;
                }
                if (calOrgId.compareTo(settingOrgId) != 0) continue;
                matchId = groupSetting.getLong("id");
                groupDims = CommonUtils.trimComma((String)groupSetting.getString("groupdims"));
            }
            rowX.set(groupSettingIdx, (Object)matchId);
            rowX.set(groupDimIdx, (Object)groupDims);
            dataList.add(rowX.values());
        }
        return dataList.iterator();
    }

    private RowX getRowx(Row row) {
        Field[] fields = this.getResultRowMeta().getFields();
        Object[] values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = row.get(fields[i].getName());
        }
        return new RowX(values);
    }
}

