/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.mq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.mservice.mq.IMqPublisherStrategy;
import kd.fi.cal.mservice.mq.ServiceMessageInfo;
import kd.fi.cal.mservice.mq.ServiceMsgPublisher;

public abstract class AbstractMqStrategy
implements IMqPublisherStrategy {
    private static final Log logger = LogFactory.getLog(AbstractMqStrategy.class);
    private String actionName;
    private Map params;
    private String serviceType;
    private String defaultProcessQueueName = "fi.cal.mservice";
    protected DynamicObject[] curMqStrategyBizBillDycs = null;
    protected DynamicObject[] nextMqStrategyBizBillDycs = null;
    private boolean hasCurStrategyBizBillDyc = false;
    private boolean hasNextStrategyBizBillDyc = false;
    private MainEntityType entityType;
    private Map<String, String> keyOrgMqOffsetValueMap = CalDbParamServiceHelper.getKeyOrgValueMap((String)CalDbParamConstant.PROCESS_MQ_OFFSET);
    private Integer processMqCount = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.PROCESS_MQ_COUNT);
    private Map<Long, Long> dycIdSplitOwnerIdMap;
    private final String mqSplitField = CalDbParamServiceHelper.getString((String)CalDbParamConstant.PROCESS_MQ_SPLIT_FIELD, null);

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    @Override
    public void collectData(DynamicObject[] bizBillDycs) {
        if (bizBillDycs == null) {
            this.hasCurStrategyBizBillDyc = this.isExecuteStrategy(null);
            this.hasNextStrategyBizBillDyc = !this.hasCurStrategyBizBillDyc;
        } else {
            ArrayList<DynamicObject> curMqStrategyBizBillDycList = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> nextMqStrategyBizBillDycList = new ArrayList<DynamicObject>(16);
            for (DynamicObject bizBillDyc : bizBillDycs) {
                if (this.isExecuteStrategy(bizBillDyc)) {
                    curMqStrategyBizBillDycList.add(bizBillDyc);
                    this.hasCurStrategyBizBillDyc = true;
                    continue;
                }
                nextMqStrategyBizBillDycList.add(bizBillDyc);
                this.hasNextStrategyBizBillDyc = true;
            }
            this.curMqStrategyBizBillDycs = curMqStrategyBizBillDycList.toArray(new DynamicObject[0]);
            this.nextMqStrategyBizBillDycs = nextMqStrategyBizBillDycList.toArray(new DynamicObject[0]);
        }
    }

    public void publish(String queueName, DynamicObject[] bizBills) {
        if (!this.hasCurStrategyBizBillDyc) {
            return;
        }
        try {
            ServiceMsgPublisher publisher = new ServiceMsgPublisher();
            if (ActionEnum.UN_AUDIT.getValue().equals(this.actionName) || ActionEnum.RESYNC.getValue().equals(this.actionName)) {
                for (DynamicObject info : bizBills) {
                    ServiceMessageInfo msgInfo = new ServiceMessageInfo();
                    msgInfo.setActionName(this.actionName);
                    msgInfo.setParams(this.params);
                    msgInfo.setBizBills(new DynamicObject[]{info});
                    msgInfo.setServiceType(this.getServiceType());
                    publisher.publish(queueName, msgInfo);
                }
            } else if (ActionEnum.AUDIT.getValue().equals(this.actionName) || ActionEnum.REESTIMATE.getValue().equals(this.actionName)) {
                int pageInt = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.PAGE_SIZE_INT);
                this.batchPublish(queueName, this.actionName, this.params, bizBills, publisher, pageInt);
            } else if (ActionEnum.PUR_WRITEOFF.getValue().equals(this.actionName) || ActionEnum.SALE_WRITEOFF.getValue().equals(this.actionName)) {
                if ("im_mdc_omcmplinbill".equals(bizBills[0].getString("billtype"))) {
                    return;
                }
                HashSet<String> assistEntryKeys = new HashSet<String>(16);
                HashSet<String> mainEntryKeys = new HashSet<String>(16);
                ArrayList<DynamicObject> writeOffInfos = new ArrayList<DynamicObject>(16);
                HashMap billMap = new HashMap(bizBills.length);
                for (DynamicObject dynamicObject : bizBills) {
                    String billid = dynamicObject.getString("billid");
                    String verifyseq = dynamicObject.getString("verifyseq");
                    String key = billid + "_" + verifyseq;
                    HashSet<DynamicObject> entrys = (HashSet<DynamicObject>)billMap.get(key);
                    if (entrys == null) {
                        entrys = new HashSet<DynamicObject>(bizBills.length);
                        entrys.add(dynamicObject);
                        billMap.put(key, entrys);
                        for (DynamicObject entry : dynamicObject.getDynamicObjectCollection("entry")) {
                            assistEntryKeys.add(key + entry.getLong("e_billentryid"));
                        }
                        mainEntryKeys.add(key + dynamicObject.getLong("billentryid"));
                        continue;
                    }
                    boolean sameEntry = false;
                    for (DynamicObject entry : dynamicObject.getDynamicObjectCollection("entry")) {
                        if (assistEntryKeys.add(key + entry.getLong("e_billentryid"))) continue;
                        writeOffInfos.add(dynamicObject);
                        sameEntry = true;
                        break;
                    }
                    if (!sameEntry && !mainEntryKeys.add(key + dynamicObject.getLong("billentryid"))) {
                        writeOffInfos.add(dynamicObject);
                        sameEntry = true;
                    }
                    if (sameEntry) continue;
                    entrys.add(dynamicObject);
                }
                for (Map.Entry entry : billMap.entrySet()) {
                    ServiceMessageInfo msgInfo = new ServiceMessageInfo();
                    msgInfo.setActionName(this.actionName);
                    msgInfo.setParams(this.params);
                    msgInfo.setBizBills(((Set)entry.getValue()).toArray(new DynamicObject[0]));
                    msgInfo.setServiceType(this.getServiceType());
                    publisher.publish(queueName, msgInfo);
                }
                for (DynamicObject dynamicObject : writeOffInfos) {
                    ServiceMessageInfo msgInfo = new ServiceMessageInfo();
                    msgInfo.setActionName(this.actionName);
                    msgInfo.setParams(this.params);
                    msgInfo.setBizBills(new DynamicObject[]{dynamicObject});
                    msgInfo.setServiceType(this.getServiceType());
                    publisher.publish(queueName, msgInfo);
                }
            } else if (!ActionEnum.SUBMIT.getValue().equals(this.actionName) && !ActionEnum.UN_SUBMIT.getValue().equals(this.actionName)) {
                ServiceMessageInfo msgInfo = new ServiceMessageInfo();
                msgInfo.setActionName(this.actionName);
                msgInfo.setParams(this.params);
                msgInfo.setBizBills(bizBills);
                msgInfo.setServiceType(this.getServiceType());
                publisher.publish(queueName, msgInfo);
            }
        }
        catch (Throwable e) {
            logger.error("AbstractMqStrategy-push\u961f\u5217\u51fa\u73b0\u5f02\u5e38\uff1a", e);
            throw e;
        }
    }

    public Long getOrgId(DynamicObject bizBillDyc) {
        String orgName = this.getEntityType().getMainOrg();
        Long orgId = null;
        if (StringUtils.isNotEmpty((String)orgName)) {
            orgId = this.getBaseId(bizBillDyc, orgName);
        } else if (this.getEntityType().getProperties().containsKey((Object)"org")) {
            orgId = this.getBaseId(bizBillDyc, "org");
        }
        if ("owner".equals(this.mqSplitField)) {
            long id = bizBillDyc.getLong("id");
            orgId = this.getDycIdSplitOwnerIdMap().get(id);
        }
        return orgId;
    }

    private Long getBaseId(DynamicObject info, String baseIdKey) {
        Long baseId = info.getLong(baseIdKey + "_id");
        Object baseIdObj = info.get(baseIdKey);
        if (baseIdObj instanceof Long && !baseIdObj.equals(0L)) {
            baseId = (Long)baseIdObj;
        }
        return baseId;
    }

    public String getQueueBySuffix(int processMqSuffix) {
        return this.getDefaultProcessQueueName() + "_" + processMqSuffix;
    }

    private void batchPublish(String queueName, String actionName, Map params, DynamicObject[] bizBills, ServiceMsgPublisher publisher, int pageInt) {
        int page = bizBills.length / pageInt;
        for (int i = 0; i <= page; ++i) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            int start = i * pageInt;
            int end = start + pageInt;
            for (int j = start; j < end && j < bizBills.length; ++j) {
                list.add(bizBills[j]);
            }
            if (list.isEmpty()) continue;
            ServiceMessageInfo msgInfo = new ServiceMessageInfo();
            msgInfo.setActionName(actionName);
            msgInfo.setParams(params);
            msgInfo.setBizBills(list.toArray(new DynamicObject[0]));
            msgInfo.setServiceType(this.getServiceType());
            publisher.publish(queueName, msgInfo);
        }
    }

    public String getActionName() {
        return this.actionName;
    }

    public Map getParams() {
        return this.params;
    }

    public String getDefaultProcessQueueName() {
        return this.defaultProcessQueueName;
    }

    @Override
    public DynamicObject[] getNextMqStrategyBizBillDycs() {
        return this.nextMqStrategyBizBillDycs;
    }

    @Override
    public boolean isHasNextStrategyBizBillDyc() {
        return this.hasNextStrategyBizBillDyc;
    }

    public void setEntityType(MainEntityType entityType) {
        this.entityType = entityType;
    }

    public MainEntityType getEntityType() {
        return this.entityType;
    }

    public Map<String, String> getKeyOrgMqOffsetValueMap() {
        return this.keyOrgMqOffsetValueMap;
    }

    public Integer getProcessMqCount() {
        return this.processMqCount;
    }

    public void setDycIdSplitOwnerIdMap(Map<Long, Long> dycIdSplitOwnerIdMap) {
        this.dycIdSplitOwnerIdMap = dycIdSplitOwnerIdMap;
    }

    public Map<Long, Long> getDycIdSplitOwnerIdMap() {
        return this.dycIdSplitOwnerIdMap;
    }
}

