/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.mq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.mservice.mq.AbstractMqStrategy;

public class AppointMqStrategy
extends AbstractMqStrategy {
    private Map<String, List<DynamicObject>> queueNameBizBillDycsMap = new HashMap<String, List<DynamicObject>>(16);

    @Override
    public void execute() {
        for (Map.Entry<String, List<DynamicObject>> queueNameBizBillDycEntry : this.queueNameBizBillDycsMap.entrySet()) {
            List<DynamicObject> bizBillDycs = queueNameBizBillDycEntry.getValue();
            if (bizBillDycs.isEmpty()) continue;
            this.publish(queueNameBizBillDycEntry.getKey(), bizBillDycs.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public boolean isExecuteStrategy(DynamicObject bizBillDyc) {
        if (bizBillDyc == null || this.getKeyOrgMqOffsetValueMap().isEmpty()) {
            return false;
        }
        Long orgId = this.getOrgId(bizBillDyc);
        if (orgId == null || orgId.equals(0L)) {
            return false;
        }
        String keyOrgStr = CalDbParamConstant.PROCESS_MQ_OFFSET + orgId;
        String processMqOffsetStr = this.getKeyOrgMqOffsetValueMap().get(keyOrgStr);
        if (StringUtils.isEmpty((String)processMqOffsetStr)) {
            return false;
        }
        Integer processMqOffset = Integer.valueOf(processMqOffsetStr);
        int processMqSuffix = this.getProcessMqCount() + processMqOffset;
        String queueName = this.getQueueBySuffix(processMqSuffix);
        List bizBillDycs = this.queueNameBizBillDycsMap.computeIfAbsent(queueName, k -> new ArrayList(16));
        bizBillDycs.add(bizBillDyc);
        return true;
    }
}

